/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class CoxSave
extends BaseSubDialog {
    public static final String FUNCTION_CHECK = "IDS_COX_REG_SAVE_FUNCTION";
    public static final String STD_ERROR_CHECK = "IDS_COX_REG_SAVE_STD_ERROR";
    public static final String LOG_MINUS_LOG_CHECK = "IDS_COX_REG_SAVE_LOG_MIN_LOG";
    public static final String HAZARD_FUNC_CHECK = "IDS_COX_REG_SAVE_HAZARD_FUNCTION";
    public static final String X_BETA_CHECK = "IDS_COX_REG_SAVE_X_BETA";
    public static final String PARTIAL_RESID_CHECK = "IDS_COX_REG_SAVE_PARTIAL_RESID";
    public static final String DFBETA_CHECK = "IDS_COX_REG_SAVE_DFBETA";
    protected JCheckBox mPartialResidualCheck;
    protected JCheckBox mHazardCheck;
    protected JCheckBox mFunctionCheck;
    protected JCheckBox mStandardErrorCheck;
    protected JCheckBox mLogCheck;
    protected JCheckBox mXBetaCheck;
    private JCheckBox mDfBetaCheck;
    private FileTextField mXmlFileTextField;
    private JButton mBrowseXmlButton;
    private JLabel mFileLabel;

    public CoxSave(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_COX_REG_SAVE_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cox_sav";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        JPanel jPanel2 = this.setupSurvivalPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets.set(n2, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupExportXMLPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setTabTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        Integer n = dialogDataModel.getInteger("COUNT_KEY");
        boolean bl = n != null && n > 0;
        this.setDefaults(bl);
    }

    protected void setDefaults(boolean bl) {
        this.mDfBetaCheck.setEnabled(bl);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mFunctionCheck.setEnabled(false);
            this.mStandardErrorCheck.setEnabled(false);
            this.mLogCheck.setEnabled(false);
            this.mHazardCheck.setEnabled(false);
            this.mPartialResidualCheck.setEnabled(false);
            this.mDfBetaCheck.setEnabled(false);
            this.mXBetaCheck.setEnabled(false);
            this.mXmlFileTextField.setEnabled(false);
            this.mBrowseXmlButton.setEnabled(false);
            this.mFileLabel.setEnabled(false);
        }
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (!(CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() == null || (bl = FileValidator.validatePath((Component)((Object)this), this.mXmlFileTextField.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())))) {
            this.mXmlFileTextField.requestFocus();
        }
        return bl;
    }

    private JPanel setupSurvivalPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_COX_REG_SAVE_SURVIVAL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        this.mFunctionCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, FUNCTION_CHECK));
        DialogUtil.addUsingGBL(jPanel, this.mFunctionCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mStandardErrorCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, STD_ERROR_CHECK));
        DialogUtil.addUsingGBL(jPanel, this.mStandardErrorCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        this.mLogCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, LOG_MINUS_LOG_CHECK));
        DialogUtil.addUsingGBL(jPanel, this.mLogCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        this.mHazardCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, HAZARD_FUNC_CHECK));
        DialogUtil.addUsingGBL(jPanel, this.mHazardCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mPartialResidualCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, PARTIAL_RESID_CHECK));
        DialogUtil.addUsingGBL(jPanel, this.mPartialResidualCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        this.mDfBetaCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, DFBETA_CHECK));
        DialogUtil.addUsingGBL(jPanel, this.mDfBetaCheck, gridBagConstraints, 1, 2, 1, 1, n, insets);
        this.mXBetaCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, X_BETA_CHECK));
        DialogUtil.addUsingGBL(jPanel, this.mXBetaCheck, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupExportXMLPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COX_REG_SAVE_EXPORT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(n, n, n, n);
        this.mFileLabel = DialogUtil.createLabel(this, "IDS_COX_REG_SAVE_EXPORT_FILE");
        this.mFileLabel.setLabelFor((Component)((Object)this.mXmlFileTextField));
        DialogUtil.addUsingGBL(jPanel, this.mFileLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mXmlFileTextField), gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseXmlButton, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private void initVars() {
        this.mXmlFileTextField = new FileTextField();
        this.mXmlFileTextField.setColumns(31);
        this.mXmlFileTextField.setAction(new TextFieldAction(this, "EXPORT_XML_FILE_PATH"));
        this.mBrowseXmlButton = new JButton(new BrowseButton(this, "IDS_BROWSE_3_DOT"));
    }

    private void setTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFunctionCheck);
        vector.add(this.mStandardErrorCheck);
        vector.add(this.mLogCheck);
        vector.add(this.mHazardCheck);
        vector.add(this.mPartialResidualCheck);
        vector.add(this.mDfBetaCheck);
        vector.add(this.mXBetaCheck);
        vector.add(this.mXmlFileTextField);
        vector.add(this.mBrowseXmlButton);
        for (Component component : this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private class BrowseButton
    extends ToggleButtonAction {
        public BrowseButton(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CoxSave.this.mBrowseXmlButton) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Data, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                remoteFileChooser.setDialogTitle(CoxSave.this.getResString("IDS_COX_REG_SAVE_EXPORT_DIALOG_TITLE"));
                remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(CoxSave.this.getResString("IDS_COX_REG_SAVE_EXPORT_DIALOG_FILE_FILTER"), CoxSave.this.getResString("IDS_COX_REG_SAVE_EXPORT_DIALOG_XML_FILE_EXTENSION")));
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setFileSelectionMode(0);
                int n = remoteFileChooser.showSaveDialog((Component)((Object)CoxSave.this));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    CoxSave.this.mXmlFileTextField.setText(remoteFileChooser.getSelectedFilePath());
                    CoxSave.this.mXmlFileTextField.setCaretPosition(0);
                }
            }
        }
    }
}

