/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntComboBox;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CoxOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final String CI_EXP_PERCENTAGE = "IDS_COX_REG_OPT_PROB_PERCENTAGE";
    public static final String CI_FOR_EXP_CHECK = "IDS_COX_REG_OPT_CL_FOR_EXP";
    public static final String CORRELATION_EST_CHECK = "IDS_COX_REG_OPT_CORRELATION_OF_EST";
    public static final String EACH_STEP_DISPLAY_CHECK = "IDS_COX_REG_OPT_AT_EACH_STEP";
    public static final String LAST_STEP_DISPLAY_CHECK = "IDS_COX_REG_OPT_AT_LAST_STEP";
    public static final String PROBABILITY_ENTRY = "IDS_COX_REG_OPT_ENTRY_COLON";
    public static final String PROBABILITY_REMOVAL = "IDS_COX_REG_OPT_REMOVAL_COLON";
    public static final String MAX_ITERATIONS = "IDS_COX_REG_OPT_MAX_ITERATIONS_COLON";
    public static final String DISP_BASELINE_FUNC_CHECK = "IDS_COX_REG_OPT_DISP_BASELINE_FUNC";
    protected JCheckBox mBaselineCheck;
    private IntComboBox mCIExpComboBox;
    private JCheckBox mCIExpCheckBox;
    private JCheckBox mCorrelationEstimatesCheckbox;
    private SpssButtonGroup mButtonGroup;
    private FloatTextField mEntryTextField;
    private FloatTextField mRemovalTextField;
    private IntTextField mMaxIterTextField;

    public CoxOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_COX_REG_OPT_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cox_opt";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mCIExpComboBox.setEnabled(this.mCIExpCheckBox.isSelected());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!this.mEntryTextField.getText().equals("") && !this.mRemovalTextField.getText().equals("") && !this.mMaxIterTextField.getText().equals(""));
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!this.mEntryTextField.getText().equals("") && !this.mRemovalTextField.getText().equals("") && !this.mMaxIterTextField.getText().equals(""));
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!this.mEntryTextField.getText().equals("") && !this.mRemovalTextField.getText().equals("") && !this.mMaxIterTextField.getText().equals(""));
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString(CI_EXP_PERCENTAGE, this.mCIExpComboBox.getSelectedItem().toString());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupStatisticsPanel();
        JPanel jPanel3 = this.setupProbabilityPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        Insets insets = new Insets(0, 0, n, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 3, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets = new Insets(n, insets2.left + 4, insets2.bottom, insets2.right);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mBaselineCheck, gridBagConstraints, 1, 2, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(n, insets2.left + 4, insets2.bottom, insets2.right);
        JLabel jLabel = DialogUtil.createLabel(this, MAX_ITERATIONS);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        this.mMaxIterTextField = new IntTextField(0, 999, true);
        this.mMaxIterTextField.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_ITERATIONS));
        this.mMaxIterTextField.setText("20");
        this.mMaxIterTextField.getDocument().addDocumentListener(this);
        jLabel.setLabelFor((Component)this.mMaxIterTextField);
        n2 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(n, insets2.left, insets2.bottom, insets2.right + 8);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterTextField, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        this.setTraversalPolicy();
        this.pack();
    }

    protected void initVars() {
        this.mCIExpCheckBox = new JCheckBox(new ToggleButtonAction(this.mParentDlg, CI_FOR_EXP_CHECK));
        this.mCIExpCheckBox.addItemListener(this);
        this.mCIExpComboBox = new IntComboBox((Object[])new String[]{"90", "95", "99"}, 0, 100, true);
        this.mCIExpComboBox.setAction((Action)new ComboboxAction(this.mParentDlg, CI_EXP_PERCENTAGE));
        this.mCorrelationEstimatesCheckbox = new JCheckBox(new ToggleButtonAction(this.mParentDlg, CORRELATION_EST_CHECK));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mCIExpCheckBox);
        spssButtonGroup.add(this.mCorrelationEstimatesCheckbox);
        this.mEntryTextField = new FloatTextField(0.0, 1.0, 2, true);
        this.mEntryTextField.setAction((Action)new TextFieldAction(this.mParentDlg, PROBABILITY_ENTRY));
        this.mEntryTextField.setText(".05");
        this.mRemovalTextField = new FloatTextField(0.0, 1.0, 2, true);
        this.mRemovalTextField.setText(".10");
        this.mRemovalTextField.setAction((Action)new TextFieldAction(this.mParentDlg, PROBABILITY_REMOVAL));
        this.mBaselineCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, DISP_BASELINE_FUNC_CHECK));
        this.mEntryTextField.getDocument().addDocumentListener(this);
        this.mRemovalTextField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mCIExpComboBox.setSelectedIndex(1);
        this.mCIExpComboBox.setEnabled(this.mCIExpCheckBox.isSelected());
    }

    private JPanel setupStatisticsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_COX_REG_OPT_MOD_STATS_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCIExpCheckBox, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCIExpComboBox, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        JLabel jLabel = new JLabel(this.getResString(CI_EXP_PERCENTAGE));
        n2 = 21;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCorrelationEstimatesCheckbox, gridBagConstraints, 0, 1, 3, 1, n2, insets);
        jLabel = new JLabel(this.getResString("IDS_COX_REG_OPT_DISP_MODEL_INFO"));
        Insets insets2 = new Insets(insets.top, 6, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 3, 1, n2, insets2);
        this.mButtonGroup = new SpssButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this.mParentDlg, EACH_STEP_DISPLAY_CHECK));
        this.mButtonGroup.add(jRadioButton);
        jRadioButton.setSelected(true);
        insets2 = new Insets(insets.top, n + 4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 3, 3, 1, n2, insets2);
        jRadioButton = new JRadioButton(new ToggleButtonAction(this.mParentDlg, LAST_STEP_DISPLAY_CHECK));
        this.mButtonGroup.add(jRadioButton);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 4, 3, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupProbabilityPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_COX_REG_OPT_PROB_STEPWISE_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, PROBABILITY_ENTRY);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jLabel.setLabelFor((Component)this.mEntryTextField);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mEntryTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jLabel = DialogUtil.createLabel(this, PROBABILITY_REMOVAL);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        jLabel.setLabelFor((Component)this.mRemovalTextField);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRemovalTextField, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setTraversalPolicy() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCIExpCheckBox);
        vector.add(this.mCorrelationEstimatesCheckbox);
        vector.add(this.mCIExpComboBox);
        vector.add(this.mButtonGroup);
        vector.add(this.mEntryTextField);
        vector.add(this.mRemovalTextField);
        vector.add(this.mMaxIterTextField);
        vector.add(this.mBaselineCheck);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

