/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.charteditor.component.LimitedPlainDocument;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ACREvent;
import com.spss.java_client.ui.controls.ACRWidget;
import com.spss.java_client.ui.controls.IACRListener;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.adv_stats.AbstractCoxDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CoxDefineEvent
extends BaseSubDialog
implements ItemListener,
IACRListener,
DocumentListener {
    static final String LIST_OF_VALUES = "IDS_DEF_EVENT_LIST_OF_VALUES";
    static final String SINGLE_VALUE = "IDS_DEF_EVENT_SINGLE_VALUE";
    static final String RANGE_OF_VALUES_FROM = "IDS_DEF_EVENT_RANGE_FROM";
    static final String RANGE_OF_VALUES_THROUGH = "IDS_DEF_EVENT_RANGE_THROUGH";
    static final String LIST_OF_VALUES_CHECK = "IDS_COX_REG_LIST_OF_VALUES_COLON";
    static final String SINGLE_VALUE_CHECK = "IDS_COX_REG_SINGLE_VALUE_COLON";
    static final String RANGE_OF_VALUES_CHECK = "IDS_COX_REG_RANGE_OF_VALUES_COLON";
    private static final double MIN_VALUE = -999.0;
    private static final double MAX_VALUE = 9999.0;
    private static final int PRECISION_VALUE = 3;
    private JRadioButton mSingleValue;
    private JRadioButton mRangeOfValues;
    private JRadioButton mListOfValues;
    private JTextField mSingleValueEdit;
    private FloatTextField mRangeOfValuesEditFrom;
    private FloatTextField mRangeOfValuesEditThrough;
    private JTextField mListOfValuesEdit;
    private ACRWidget mACRWidget;
    private JLabel mRangeOfValuesEditThroughLabel;
    private SpssButtonGroup mBtnGroup;

    public CoxDefineEvent(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_COX_REG_DEFINE_EVENTS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cox_evnt";
    }

    @Override
    public boolean continuePressed() {
        if (this.mSingleValue.isSelected()) {
            DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
            if (!dialogDataModel.getBoolean(AbstractCoxDialog.IS_STATUS_STRING_VARIABLE).booleanValue() && !this.doesNumericFieldHaveValidNumOfDigits((SPSSTextField)this.mSingleValueEdit)) {
                String string = String.format(this.getResString("ERR_COX_REG_DEFINE_EVENT_INVALID_NUM_DIGITS_ERROR_MSG"), this.mSingleValueEdit.getColumns() - 1);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                this.mSingleValueEdit.requestFocus();
                return false;
            }
        } else if (this.mRangeOfValues.isSelected()) {
            if (Float.parseFloat(this.mRangeOfValuesEditFrom.getText()) >= Float.parseFloat(this.mRangeOfValuesEditThrough.getText())) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_COX_REG_DEFINE_EVENT_ERROR_MSG"), VersionInfo.getAppVersionString());
                this.mRangeOfValuesEditFrom.requestFocus();
                return false;
            }
        } else if (this.mListOfValues.isSelected()) {
            if (this.mListOfValuesEdit.getText() != null && this.mListOfValuesEdit.getText().trim().length() > 0) {
                if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_ACR_CONTINUE_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    this.mListOfValuesEdit.setText("");
                } else {
                    return false;
                }
            }
            if (this.mACRWidget.getList().getModel().getSize() == 0) {
                return false;
            }
        }
        return true;
    }

    boolean doesNumericFieldHaveValidNumOfDigits(SPSSTextField sPSSTextField) {
        sPSSTextField.setText(sPSSTextField.getText().trim());
        return sPSSTextField.getText().length() > 0 && sPSSTextField.getText().length() <= sPSSTextField.getColumns();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void listChanged(ACREvent aCREvent) {
        this.updateContinueButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mSingleValueEdit.setEnabled(this.mSingleValue.isSelected());
        this.mSingleValueEdit.setOpaque(this.mSingleValue.isSelected());
        boolean bl = this.mRangeOfValues.isSelected();
        this.mRangeOfValuesEditFrom.setEnabled(bl);
        this.mRangeOfValuesEditFrom.setOpaque(bl);
        this.mRangeOfValuesEditThrough.setEnabled(bl);
        this.mRangeOfValuesEditThrough.setOpaque(bl);
        this.mRangeOfValuesEditThroughLabel.setEnabled(bl);
        bl = this.mListOfValues.isSelected();
        this.mListOfValuesEdit.setEnabled(bl);
        this.mListOfValuesEdit.setOpaque(bl);
        this.mListOfValuesEdit.setText("");
        this.mACRWidget.setEnabled(bl);
        this.updateContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 21;
        JLabel jLabel = new JLabel(this.getResString("IDS_COX_REG_DEFINE_EVENTS_TEXT"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 4, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSingleValue, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRangeOfValues, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mListOfValues, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSingleValueEdit, gridBagConstraints, 1, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeOfValuesEditFrom, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mRangeOfValuesEditThroughLabel, gridBagConstraints, 2, 2, 1, 1, 10, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeOfValuesEditThrough, gridBagConstraints, 3, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mListOfValuesEdit, gridBagConstraints, 1, 3, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(insets.top, 20, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mACRWidget, gridBagConstraints, 0, 4, 3, 1, n, insets2);
        this.updateContinueButton();
        this.setDefault();
        this.setTraversalPolicy();
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        String string = null;
        if (this.mSingleValue.isSelected()) {
            string = this.mSingleValueEdit.getText();
            if (dialogDataModel.getBoolean(AbstractCoxDialog.IS_STATUS_STRING_VARIABLE).booleanValue()) {
                string = CharacterUtil.smartQuote((String)string);
            }
        }
        if (this.mRangeOfValues.isSelected()) {
            string = this.mRangeOfValuesEditFrom.getText() + " THRU " + this.mRangeOfValuesEditThrough.getText();
        }
        if (this.mListOfValues.isSelected()) {
            String string2;
            String[] stringArray = this.mACRWidget.getListItems();
            string = string2 = "";
            if (dialogDataModel.getBoolean(AbstractCoxDialog.IS_STATUS_STRING_VARIABLE).booleanValue()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string3 : stringArray) {
                    stringBuilder.append(CharacterUtil.smartQuote((String)string3) + " ");
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                string = stringBuilder.toString();
            } else {
                for (String string4 : stringArray) {
                    string = string + string2 + string4;
                    string2 = " ";
                }
            }
        }
        dialogDataModel.putString("EVENT_KEY", string);
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getString("EVENT_KEY") == null) {
            this.setDefault();
        }
    }

    private void initVars() {
        this.mBtnGroup = new SpssButtonGroup();
        this.mSingleValue = new JRadioButton(new ToggleButtonAction(this.mParentDlg, SINGLE_VALUE_CHECK));
        this.mSingleValue.addItemListener(this);
        this.mRangeOfValues = new JRadioButton(new ToggleButtonAction(this.mParentDlg, RANGE_OF_VALUES_CHECK));
        this.mRangeOfValues.addItemListener(this);
        this.mListOfValues = new JRadioButton(new ToggleButtonAction(this.mParentDlg, LIST_OF_VALUES_CHECK));
        this.mListOfValues.addItemListener(this);
        this.mBtnGroup.add(this.mSingleValue);
        this.mBtnGroup.add(this.mRangeOfValues);
        this.mBtnGroup.add(this.mListOfValues);
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        if (dialogDataModel.getBoolean(AbstractCoxDialog.IS_STATUS_STRING_VARIABLE).booleanValue()) {
            this.mSingleValueEdit = new StringTextField();
            this.mSingleValueEdit.setDocument((Document)new LimitedPlainDocument(8));
            this.mListOfValuesEdit = new StringTextField();
            this.mListOfValuesEdit.setDocument((Document)new LimitedPlainDocument(8));
        } else {
            this.mSingleValueEdit = new FloatTextField(-9999999.0, 9.9999999E7, 7, false);
            this.mSingleValueEdit.setColumns(8);
            this.mListOfValuesEdit = new FloatTextField(-9999999.0, 9.9999999E7, 7, false);
            this.mListOfValuesEdit.setColumns(8);
        }
        this.mSingleValueEdit.setAction(new TextFieldAction(this.mParentDlg, SINGLE_VALUE));
        this.mSingleValueEdit.getDocument().addDocumentListener(this);
        this.mRangeOfValuesEditFrom = new FloatTextField(-999.0, 9999.0, 3, false);
        this.mRangeOfValuesEditFrom.setColumns(4);
        this.mRangeOfValuesEditFrom.setAction((Action)new TextFieldAction(this.mParentDlg, RANGE_OF_VALUES_FROM));
        this.mRangeOfValuesEditFrom.getDocument().addDocumentListener(this);
        this.mRangeOfValuesEditThroughLabel = DialogUtil.createLabel(this, "IDS_COX_REG_RANGE_OF_VALUES_THROUGH");
        this.mRangeOfValuesEditThrough = new FloatTextField(-999.0, 9999.0, 3, false);
        this.mRangeOfValuesEditThrough.setColumns(4);
        this.mRangeOfValuesEditThrough.setAction((Action)new TextFieldAction(this.mParentDlg, RANGE_OF_VALUES_THROUGH));
        this.mRangeOfValuesEditThrough.getDocument().addDocumentListener(this);
        this.mRangeOfValuesEditThroughLabel.setLabelFor((Component)this.mRangeOfValuesEditThrough);
        this.mListOfValuesEdit.setAction(new TextFieldAction(this.mParentDlg, LIST_OF_VALUES));
        this.mListOfValuesEdit.getDocument().addDocumentListener(this);
        this.mACRWidget = new ACRWidget(this.mListOfValuesEdit);
        this.mACRWidget.addACRListener(this);
    }

    private void setDefault() {
        this.mSingleValue.setSelected(true);
        this.mSingleValueEdit.requestFocus();
        this.mSingleValueEdit.setText("");
        this.mRangeOfValuesEditFrom.setText("");
        this.mRangeOfValuesEditThrough.setText("");
        ((DefaultListModel)this.mACRWidget.getList().getModel()).removeAllElements();
        boolean bl = this.mParentDlg.getDialogDataModel().getBoolean(AbstractCoxDialog.IS_STATUS_STRING_VARIABLE);
        if (bl) {
            this.mRangeOfValues.setEnabled(false);
            this.mRangeOfValuesEditFrom.setEnabled(false);
            this.mRangeOfValuesEditThrough.setEnabled(false);
            this.mRangeOfValuesEditThroughLabel.setEnabled(false);
        }
    }

    private void setTraversalPolicy() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mBtnGroup);
        vector.add(this.mSingleValueEdit);
        vector.add(this.mRangeOfValuesEditFrom);
        vector.add(this.mRangeOfValuesEditThrough);
        List<JComponent> list = this.mACRWidget.getTraversalComponents();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            vector.add(list.get(i));
        }
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void updateContinueButton() {
        if (this.mSingleValue.isSelected()) {
            this.enableContinue(this.mSingleValueEdit.getText().length() > 0);
        } else if (this.mRangeOfValues.isSelected()) {
            this.enableContinue(this.mRangeOfValuesEditFrom.getText().length() > 0 && this.mRangeOfValuesEditThrough.getText().length() > 0);
        } else if (this.mListOfValues.isSelected()) {
            this.enableContinue(this.mACRWidget.getList().getModel().getSize() > 0);
        } else {
            this.enableContinue(false);
        }
    }
}

