/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.AbstractCoxDialog;
import com.spss.java_client.ui.dialogs.adv_stats.CoxCategoricalSpssVarFormatter;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.GlassPaneSwingWorker;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SwingWorker;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CoxCategorical
extends BaseSubDialog
implements FocusListener,
ItemListener,
ListDataListener {
    private static final String SPECIFIED_COVARIATES = "IDS_SPECIFIED_COVARIATES";
    private static final String CATEGORIAL_VALUES = "IDS_CATEGORIAL_VALUES";
    private static final String CATEGORIAL_VALUES_ARRAY = "IDS_CATEGORIAL_VALUES_ARRAY";
    protected ArrowButton mArrowButton;
    protected TargetVariableList mSpecifiedCovariatesList;
    protected TargetVariableList mCategoricalCovariatesList;
    protected CoxCategoricalSpssVarFormatter mFormatter;
    protected JComboBox mContrastCombo;
    protected Set<ISpssVariable> mTargetVarSet;
    private JRadioButton mLastRadio;
    private JRadioButton mFirstRadio;
    private JLabel mRefCat;
    private JPanel mChangeContrastPanel;
    private JLabel mContrastLabel;
    private JButton mChangebutton;
    private SpssButtonGroup mButtonGroup;
    private ArrayList<String> mCovarList;

    public CoxCategorical(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_COX_REG_CATEGORICAL_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cox_cat";
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mCategoricalCovariatesList.getModel())) {
            CategoricalCovariateModel categoricalCovariateModel = (CategoricalCovariateModel)this.mCategoricalCovariatesList.getModel();
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            for (int i = n; i <= n2; ++i) {
                categoricalCovariateModel.setElementPropertyAt(i, (String)this.mContrastCombo.getItemAt(0), "");
                ISpssVariable iSpssVariable = this.mCategoricalCovariatesList.getModel().getElementAt(i);
                if (this.isVariableExistinArrayList(this.mTargetVarSet, iSpssVariable)) continue;
                this.mTargetVarSet.add(iSpssVariable);
            }
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSpecifiedCovariatesList)) {
            this.enableContrast(false);
            this.enableFirstLast(false);
        } else if (focusEvent.getSource().equals(this.mCategoricalCovariatesList)) {
            this.enableContrast(true);
            int n = this.mContrastCombo.getSelectedIndex();
            this.enableFirstLast(n == 0 || n == 1 || n == 6);
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mContrastCombo)) {
            int n = this.mContrastCombo.getSelectedIndex();
            this.enableFirstLast(n == 0 || n == 1 || n == 6);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        dialogDataModel.putMap(this.mCategoricalCovariatesList.getIdentifier(), this.mFormatter.getVarMapForSerialization());
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[this.mTargetVarSet.size()];
        dialogDataModel.putVarArray("CAT_TARGET_VAR", this.mTargetVarSet.toArray(iSpssVariableArray));
        VarListModel varListModel = this.mCategoricalCovariatesList.getModel();
        int n = varListModel.getSize();
        String string = this.getResString("IDS_COX_CAT_FIRST_VALUE");
        for (int i = 0; i < n; ++i) {
            String string2 = this.mFormatter.getDisplayText(varListModel.getElementAt(i));
            String string3 = "";
            if (string2.contains(string)) {
                string2 = string2.replaceAll("\\(" + string + "\\)", "");
                string3 = "(1)";
            }
            String string4 = string2.substring(0, string2.indexOf(40));
            String string5 = string2.substring(string2.indexOf(40) + 1, string2.indexOf(41));
            this.mCovarList.add("(" + string4 + ")" + "=" + string5 + string3);
        }
        dialogDataModel.putArray(CATEGORIAL_VALUES_ARRAY, this.mCovarList.toArray());
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        HashMap<Integer, Object> i;
        super.loadState(dialogDataModel);
        this.mFormatter.setUpdateNameMap(true);
        HashMap<Integer, Object> hashMap2 = dialogDataModel.getMap(this.mCategoricalCovariatesList.getIdentifier());
        for (ISpssVariable object2 : ((AbstractCoxDialog)this.mParentDlg).getElementsToRemoveList()) {
            this.mCategoricalCovariatesList.getModel().removeElement(object2);
            i = object2.getId().asInt();
            if (hashMap2 != null && hashMap2.containsKey(i)) {
                hashMap2.remove(i);
            }
            if (((AbstractCoxDialog)this.mParentDlg).getVarCountInLayeredPanel(object2.getName()) > 0) {
                if (this.isVarExist(this.mSpecifiedCovariatesList.getModel(), (SpssVariable)object2)) continue;
                this.mSpecifiedCovariatesList.getModel().addElement(object2);
                continue;
            }
            this.mSpecifiedCovariatesList.getModel().removeElement(object2);
        }
        CategoricalCovariateModel categoricalCovariateModel = (CategoricalCovariateModel)this.mCategoricalCovariatesList.getModel();
        Set<ISpssVariable> set = ((AbstractCoxDialog)this.mParentDlg).getVariableSet();
        if (set.size() > 0) {
            Object object;
            Object i3;
            Object i22;
            for (Object i22 : set) {
                if (i22.getType() > 0) {
                    if (this.isVarExist(this.mCategoricalCovariatesList.getModel(), (SpssVariable)i22) || ((AbstractCoxDialog)this.mParentDlg).getVarCountInLayeredPanel(i22.getName()) <= 0) continue;
                    this.mCategoricalCovariatesList.getModel().addElement((ISpssVariable)i22);
                    i3 = i22.getId().asInt();
                    if (hashMap2 != null && !hashMap2.containsKey(i3)) {
                        hashMap2.put((Integer)i3, "");
                    }
                    this.mTargetVarSet.add((ISpssVariable)i22);
                    continue;
                }
                if (this.isVarExist(this.mSpecifiedCovariatesList.getModel(), (SpssVariable)i22) || this.isVarExist(this.mCategoricalCovariatesList.getModel(), (SpssVariable)i22) || ((AbstractCoxDialog)this.mParentDlg).getVarCountInLayeredPanel(i22.getName()) <= 0) continue;
                this.mSpecifiedCovariatesList.getModel().addElement((ISpssVariable)i22);
            }
            this.mContrastCombo.setSelectedIndex(0);
            this.mLastRadio.setSelected(true);
            if (hashMap2 != null) {
                i = this.mFormatter.getVarMap();
                if (!RemoteFileChooser.enableSaveInModeler()) {
                    hashMap2 = SpssVarFormatter.updateLuids(dialogDataModel, this.mCategoricalCovariatesList.getIdentifier(), hashMap2);
                }
                i.clear();
                i22 = hashMap2.keySet();
                i3 = i22.iterator();
                while (i3.hasNext()) {
                    object = (Integer)i3.next();
                    i.put((Integer)object, hashMap2.get(object));
                }
            }
            for (int varListModel = 0; varListModel < this.mCategoricalCovariatesList.getModel().getSize(); ++varListModel) {
                i22 = this.mCategoricalCovariatesList.getModel().getElementAt(varListModel);
                if (this.mFormatter.getDisplayText((ISpssVariable)i22).equals(i22.getName())) {
                    categoricalCovariateModel.setElementPropertyAt(varListModel, (String)this.mContrastCombo.getSelectedItem(), "");
                }
                this.mTargetVarSet.add((ISpssVariable)i22);
            }
            final VarListModel varListModel = this.mSpecifiedCovariatesList.getModel();
            for (int varListModel2 = 0; varListModel2 < varListModel.getSize(); ++varListModel2) {
                i3 = varListModel.getElementAt(varListModel2);
                if (this.isVariableExistinArrayList(((AbstractCoxDialog)this.mParentDlg).getVariableSet(), (ISpssVariable)i3)) continue;
                object = new GlassPaneSwingWorker(this.getParent(), (ISpssVariable)i3){
                    final /* synthetic */ ISpssVariable val$var;
                    {
                        this.val$var = iSpssVariable;
                        super(component);
                    }

                    @Override
                    public Object doConstruct() {
                        varListModel.removeElement(this.val$var);
                        return null;
                    }
                };
                ((SwingWorker)object).start();
            }
            final VarListModel varListModel2 = this.mCategoricalCovariatesList.getModel();
            for (int j = 0; j < varListModel2.getSize(); ++j) {
                object = varListModel2.getElementAt(j);
                if (this.isVariableExistinArrayList(((AbstractCoxDialog)this.mParentDlg).getVariableSet(), (ISpssVariable)object)) continue;
                GlassPaneSwingWorker glassPaneSwingWorker = new GlassPaneSwingWorker(this.getParent(), (ISpssVariable)object){
                    final /* synthetic */ ISpssVariable val$var;
                    {
                        this.val$var = iSpssVariable;
                        super(component);
                    }

                    @Override
                    public Object doConstruct() {
                        varListModel2.removeElement(this.val$var);
                        return null;
                    }
                };
                glassPaneSwingWorker.start();
                this.mCovarList.remove(this.mFormatter.getDisplayText((ISpssVariable)object));
            }
        }
        this.mSpecifiedCovariatesList.setSelectedIndex(0);
        this.removeElementsNotPresentInDataSource(this.mCategoricalCovariatesList);
        this.removeElementsNotPresentInDataSource(this.mSpecifiedCovariatesList);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COX_CAT_COVARIATES_FOR_CATEGORICAL");
        jLabel.setLabelFor(this.mSpecifiedCovariatesList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSpecifiedCovariatesList);
        jScrollPane.setPreferredSize(this.mSpecifiedCovariatesList.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, insets);
        jLabel = DialogUtil.createLabel(this, "IDS_COX_CAT_CATEGORICAL_COVARIATES");
        jLabel.setLabelFor(this.mCategoricalCovariatesList);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        jScrollPane = new JScrollPane(this.mCategoricalCovariatesList);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel2 = this.setupChangeContrastPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 21;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 2, 1, 1, n, null);
        this.setDefaults();
        this.setTraversalPolicy();
        this.pack();
    }

    private void removeElementsNotPresentInDataSource(TargetVariableList targetVariableList) {
        for (int i = targetVariableList.getModel().getSize() - 1; i >= 0; --i) {
            boolean bl;
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(iSpssVariable.getName());
            if (!iSpssVariable.getName().equals("T_COV_") && iSpssVariable != null && n == -1 && !(bl = iSpssDataSrc.isVariableInCurrentSet(iSpssVariable))) {
                targetVariableList.getModel().removeElementAt(i);
                this.removeVariable(this.mTargetVarSet, iSpssVariable);
            }
            if (((AbstractCoxDialog)this.mParentDlg).getVarCountInLayeredPanel(iSpssVariable.getName()) != 0) continue;
            targetVariableList.getModel().removeElement(iSpssVariable);
        }
    }

    private void enableContrast(boolean bl) {
        DialogUtil.enableTitledBorder(this.mChangeContrastPanel, bl);
        this.mContrastLabel.setEnabled(bl);
        this.mContrastCombo.setEnabled(bl);
        this.mChangebutton.setEnabled(bl);
        this.repaint();
    }

    private void enableFirstLast(boolean bl) {
        this.mRefCat.setEnabled(bl);
        this.mFirstRadio.setEnabled(bl);
        this.mLastRadio.setEnabled(bl);
    }

    protected void initVars() {
        this.mCategoricalCovariatesList = new TargetVariableList(TargetVariableList.TargetListType.normal, VariableList.VarMoveType.eDoNothing);
        this.mFormatter = new CoxCategoricalSpssVarFormatter(this.mCategoricalCovariatesList);
        this.mCategoricalCovariatesList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatter));
        this.mCategoricalCovariatesList.setModel(new CategoricalCovariateModel(this.mFormatter));
        this.mCategoricalCovariatesList.setIdentifier(CATEGORIAL_VALUES);
        this.mCategoricalCovariatesList.addFocusListener(this);
        this.mCategoricalCovariatesList.getModel().addListDataListener(this);
        this.mVarMoveHandler = new CategoricalVarMoveHandler();
        this.mSpecifiedCovariatesList = new TargetVariableList();
        this.mSpecifiedCovariatesList.setIdentifier(SPECIFIED_COVARIATES);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mSpecifiedCovariatesList.addVarFilter(spssVarFilter);
        this.mSpecifiedCovariatesList.setDragType(VariableList.VarMoveType.eDoNothing);
        this.mSpecifiedCovariatesList.addFocusListener(this);
        String[] stringArray = this.getResStringArray("IDS_COX_CAT_CONTRAST_ARRAY");
        this.mContrastCombo = new JComboBox<String>(stringArray);
        this.mContrastCombo.setAction(new ComboboxAction(this.mParentDlg, "IDS_COX_CAT_CONTRAST_COMBO"));
        this.mContrastCombo.addItemListener(this);
        this.mRefCat = new JLabel(this.getResString("IDS_COX_CAT_REFERENCE_CATEGORY_COLON"));
        this.mButtonGroup = new SpssButtonGroup();
        this.mLastRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_COX_CAT_LAST"));
        this.mButtonGroup.add(this.mLastRadio);
        this.mFirstRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, "IDS_COX_CAT_FIRST"));
        this.mButtonGroup.add(this.mFirstRadio);
        this.mTargetVarSet = new HashSet<ISpssVariable>();
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mArrowButton.registerVariableList(this.mSpecifiedCovariatesList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mCategoricalCovariatesList, SpssArrowButton.ButtonOrientation.left);
        this.mCovarList = new ArrayList();
        this.mFormatter.setUpdateNameMap(false);
    }

    private void setDefaults() {
        this.mLastRadio.setSelected(true);
        if (this.mSpecifiedCovariatesList.getModel().getSize() > 0) {
            this.mSpecifiedCovariatesList.setSelectedIndex(0);
        }
    }

    private JPanel setupChangeContrastPanel() {
        this.mChangeContrastPanel = new JPanel();
        this.mChangeContrastPanel.setLayout(new GridBagLayout());
        this.mChangeContrastPanel.setBorder(new TitledBorder(this.getResString("IDS_COX_CAT_CHANGE_CONTRAST_TITLE")));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.mContrastLabel = DialogUtil.createLabel(this, "IDS_COX_CAT_CONTRAST_COLON");
        this.mContrastLabel.setLabelFor(this.mContrastCombo);
        DialogUtil.addUsingGBL(jPanel2, this.mContrastLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mContrastCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_COX_CAT_CHANGE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CoxCategorical.this.mCategoricalCovariatesList.getSelectedIndices();
                CategoricalCovariateModel categoricalCovariateModel = (CategoricalCovariateModel)CoxCategorical.this.mCategoricalCovariatesList.getModel();
                int n = nArray.length;
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    ISpssVariable iSpssVariable = CoxCategorical.this.mCategoricalCovariatesList.getModel().getElementAt(nArray[i]);
                    if (iSpssVariable.getType() > 0 && CoxCategorical.this.mContrastCombo.getSelectedIndex() == 5) {
                        if (!bl) {
                            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mMainDialog, CoxCategorical.this.getResString("ERR_COX_POLY_STR_CONTRAST_ERROR_MSG"), VersionInfo.getAppVersionString());
                        }
                        bl = true;
                        continue;
                    }
                    if (CoxCategorical.this.mFirstRadio.isSelected() && CoxCategorical.this.mFirstRadio.isEnabled()) {
                        categoricalCovariateModel.setElementPropertyAt(nArray[i], (String)CoxCategorical.this.mContrastCombo.getSelectedItem(), CoxCategorical.this.getResString("IDS_COX_CAT_FIRST_VALUE"));
                        continue;
                    }
                    categoricalCovariateModel.setElementPropertyAt(nArray[i], (String)CoxCategorical.this.mContrastCombo.getSelectedItem(), "");
                }
            }
        };
        this.mChangebutton = new JButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel, this.mChangebutton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mChangeContrastPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jPanel = new JPanel(new GridBagLayout());
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mRefCat, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        n = 23;
        DialogUtil.addUsingGBL(jPanel3, this.mLastRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mFirstRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mChangeContrastPanel, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return this.mChangeContrastPanel;
    }

    private boolean isVarExist(VarListModel varListModel, SpssVariable spssVariable) {
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!varListModel.getElementAt(i).getName().equals(spssVariable.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean removeVariable(Set<ISpssVariable> set, ISpssVariable iSpssVariable) {
        for (ISpssVariable iSpssVariable2 : set) {
            if (iSpssVariable2.getId().asInt() != iSpssVariable.getId().asInt()) continue;
            return set.remove(iSpssVariable2);
        }
        return false;
    }

    private void setTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSpecifiedCovariatesList);
        vector.add(this.mArrowButton);
        vector.add(this.mCategoricalCovariatesList);
        vector.add(this.mContrastCombo);
        vector.add(this.mButtonGroup);
        vector.add(this.mChangebutton);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean isVariableExists(ISpssVariable iSpssVariable, ISpssVariable[] iSpssVariableArray) {
        for (ISpssVariable iSpssVariable2 : iSpssVariableArray) {
            if (!iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableExistinArrayList(Set<ISpssVariable> set, ISpssVariable iSpssVariable) {
        boolean bl = !RemoteFileChooser.enableSaveInModeler();
        for (ISpssVariable iSpssVariable2 : set) {
            if (bl && iSpssVariable2.getName().equals(iSpssVariable.getName())) {
                return true;
            }
            if (bl || iSpssVariable2.getId().asInt() != iSpssVariable.getId().asInt()) continue;
            return true;
        }
        return false;
    }

    protected class CategoricalVarMoveHandler
    implements IVarMoveHandler {
        protected CategoricalVarMoveHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            if (variableList.equals(CoxCategorical.this.mSpecifiedCovariatesList)) {
                ISpssVariable[] iSpssVariableArray2 = CoxCategorical.this.mCategoricalCovariatesList.getSelectedValues();
                for (int i = iSpssVariableArray2.length - 1; i >= 0; --i) {
                    CoxCategorical.this.removeVariable(CoxCategorical.this.mTargetVarSet, iSpssVariableArray2[i]);
                }
            }
            return true;
        }
    }

    private class CategoricalCovariateModel
    extends CustomVarListModel {
        public CategoricalCovariateModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "");
            return super.insertElementAt(iSpssVariable, n);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "");
            return super.addElement(iSpssVariable);
        }

        public void setElementPropertyAt(int n, String string, String string2) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            String string3 = CoxCategorical.this.getResString("IDS_COX_CAT_FIRST_VALUE");
            if (iSpssVariable.getType() > 0) {
                if (string2.equals(string3)) {
                    this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(" + string + "(" + string3 + ")" + ")<");
                } else {
                    this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(" + string + ")<");
                }
            } else if (string2.equals(string3)) {
                this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(" + string + "(" + string3 + ")" + ")");
            } else {
                this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(" + string + ")");
            }
            this.fireContentsChanged(iSpssVariable, n, n);
        }
    }
}

