/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.LayeredListWidget;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.CoxCategoricalSpssVarFormatter;
import com.spss.java_client.ui.dialogs.adv_stats.CoxDefineEvent;
import com.spss.java_client.ui.dialogs.adv_stats.CoxOptions;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.base.analyze.regression.binary_logistic.SpssVariableSimpleTextCellRenderer;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractCoxDialog
extends BaseProcedureDialog
implements ListDataListener,
FocusListener,
ListSelectionListener,
ItemListener {
    public static final String CAT_TARGET_VAR_KEY = "CAT_TARGET_VAR";
    protected static final String EVENT_VALUE_KEY = "EVENT_KEY";
    protected static final String CATEGORIAL_VALUES_ARRAY = "IDS_CATEGORIAL_VALUES_ARRAY";
    protected static String IS_STATUS_STRING_VARIABLE = "IS_STATUS_STRING_VARIABLE";
    static final String COUNT_KEY = "COUNT_KEY";
    private static String TIME_LIST = "TIME_LIST";
    private static String STRATA_LIST = "STRATA_LIST";
    private static String STATUS_LIST = "STATUS_LIST";
    private static final String VAR_SET_KEY = "VAR_SET";
    private static final String METHOD_KEY = "METHOD_KEY";
    protected SrcVariableList mSrcList;
    protected TargetVariableList mTimeList;
    protected TargetVariableList mStatusList;
    protected TargetVariableList mStrataList;
    protected ArrowButton mArrowButtonForTimeList;
    protected ArrowButton mArrowButtonForStatusList;
    protected ArrowButton mArrowButtonForStrataList;
    protected JButton mDefineEventButton;
    protected JButton mCategoricalButton;
    protected JButton mSaveButton;
    protected JButton mOptionsButton;
    protected ListWidget mLayeredListWidget;
    protected JComboBox mMethodCombo;
    protected String[] mMethodStr;
    protected JButton mMergeButton;
    protected ISpssVariable mTimeCovariateVariable;
    protected HashSet<ISpssVariable> mSetCovariateVariables;
    private String[] mMethodComboitem;
    private ISpssVariable[] mCategoryObjectArray;
    private int mCount;
    private Insets mArrowInsets;
    private boolean mDefineEventSelected;
    private CoxCategoricalSpssVarFormatter mFormatter;
    private StatusListModel mStatusListModel;
    private ArrayList<ISpssVariable> mElementsToRemove;
    protected JButton mBootstrappingButton;

    public AbstractCoxDialog(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mStatusList)) {
            this.mDefineEventButton.setEnabled(this.mStatusList.getModel().getSize() > 0);
        } else {
            this.mDefineEventButton.setEnabled(false);
        }
    }

    public ArrayList<ISpssVariable> getElementsToRemoveList() {
        return this.mElementsToRemove;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mStatusList.getModel())) {
            this.mDefineEventSelected = false;
            this.enableOkPaste(this.okPasteValue());
        } else if (listDataEvent.getSource().equals(this.mTimeList.getModel())) {
            this.enableOkPaste(this.okPasteValue());
        } else {
            this.mCategoricalButton.setEnabled(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.okPasteValue());
        if (listDataEvent.getSource().equals(this.mStatusListModel)) {
            this.getDialogDataModel().putString(EVENT_VALUE_KEY, null);
            this.mDefineEventSelected = false;
            this.mDefineEventButton.setEnabled(false);
        }
        this.mCategoricalButton.setEnabled(this.mCount > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mSrcList)) {
            ISpssVariable[] iSpssVariableArray = this.mSrcList.getSelectedValues();
            this.mMergeButton.setEnabled(iSpssVariableArray.length > 1);
        }
        if (listSelectionEvent.getSource().equals(this.mTimeList)) {
            this.enableOkPaste(this.okPasteValue());
        }
        if (listSelectionEvent.getSource().equals(this.mStatusList)) {
            this.enableOkPaste(this.okPasteValue());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mCount > 0) {
            this.mCategoricalButton.setEnabled(true);
        } else {
            this.mCategoricalButton.setEnabled(false);
        }
        if (itemEvent.getSource().equals(this.mMethodCombo)) {
            this.mMethodStr[this.mLayeredListWidget.getCurrentLayer()] = this.getMethodSyntaxStr();
        }
        this.mMethodCombo.setSelectedItem(this.mMethodStr[this.mLayeredListWidget.getCurrentLayer()]);
        this.enableOkPaste(this.okPasteValue());
        this.enableBootstrappingButton();
    }

    public int getVarCountInLayeredPanel(String string) {
        String string2 = "(" + this.getResString("IDS_COX_CAT_CAT_VALUE") + ")";
        int n = 0;
        for (VarListModel varListModel : this.mLayeredListWidget.getVarListModels()) {
            for (int i = 0; i < varListModel.getSize(); ++i) {
                String string3 = varListModel.getElementAt(i).getName();
                if (string3.contains("*")) {
                    Scanner scanner = new Scanner(string3);
                    scanner.useDelimiter("\\*");
                    while (scanner.hasNext()) {
                        String string4 = scanner.next();
                        if (!string4.equals(string) && !string4.equals(string + string2)) continue;
                        ++n;
                    }
                }
                if (!string3.equals(string)) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcList.removeAll();
        this.mTimeList.removeAll();
        this.mStatusList.removeAll();
        this.mStrataList.removeAll();
        this.mMethodCombo.setSelectedIndex(0);
        this.mSrcList.requestFocus();
        this.mCount = 0;
        this.mSetCovariateVariables.clear();
        this.mLayeredListWidget.resetLayeredListWidget();
        this.mMethodCombo.setSelectedIndex(0);
        for (int i = 0; i < 9; ++i) {
            this.mMethodStr[i] = this.getMethodSyntaxStr();
        }
        this.setDefaults();
    }

    public Set<ISpssVariable> getVariableSet() {
        return this.mSetCovariateVariables;
    }

    protected void initVars() {
        this.mSrcList = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcList.addListSelectionListener(this);
        this.mTimeList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTimeList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTimeList.setIdentifier(TIME_LIST);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mTimeList.addVarFilter(spssVarFilter);
        this.mTimeList.getModel().addListDataListener(this);
        this.mStatusList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mStatusList.setIdentifier(STATUS_LIST);
        this.mStatusList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFormatter = new CoxCategoricalSpssVarFormatter(this.mStatusList);
        this.mStatusListModel = new StatusListModel(this.mFormatter);
        this.mStatusList.setModel(this.mStatusListModel);
        this.mStatusList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatter));
        this.mStatusList.addListSelectionListener(this);
        this.mStatusList.addFocusListener(this);
        this.mStatusList.getModel().addListDataListener(this);
        this.mStrataList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mStrataList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mStrataList.setIdentifier(STRATA_LIST);
        this.mStrataList.getModel().addListDataListener(this);
        this.mVarMoveHandler = new CoxRegressionVarMoveHandler();
        this.mArrowButtonForTimeList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForTimeList.setVarMoveHandler(this.mVarMoveHandler);
        this.mArrowButtonForTimeList.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForTimeList.registerVariableList(this.mTimeList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonForStrataList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForStrataList.setVarMoveHandler(this.mVarMoveHandler);
        this.mArrowButtonForStrataList.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForStrataList.registerVariableList(this.mStrataList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonForStatusList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForStatusList.setVarMoveHandler(this.mVarMoveHandler);
        this.mArrowButtonForStatusList.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForStatusList.registerVariableList(this.mStatusList, SpssArrowButton.ButtonOrientation.left);
        this.mSetCovariateVariables = new HashSet();
        this.mArrowInsets = new Insets(0, DialogUtil.getStandardControlInsets().right, DialogUtil.getMainButtonGap(), DialogUtil.getArrowButtonInsets().right);
        this.mMethodComboitem = this.getResStringArray("IDS_COX_REG_METHOD_COMBO");
        this.mMethodCombo = new JComboBox<String>(this.mMethodComboitem);
        this.mMethodCombo.addItemListener(this);
        this.mMethodStr = new String[9];
        for (int i = 0; i < 9; ++i) {
            this.mMethodStr[i] = "ENTER";
        }
        this.mElementsToRemove = new ArrayList();
        this.mLayeredListWidget = new ListWidget(this.getResString(" IDS_COX_REG_COVARIATES_COLON"), this);
        this.mArrowInsets.left = 0;
        this.mArrowInsets.bottom = 0;
        this.mLayeredListWidget.setMaxNoOfLayers(9);
        this.mLayeredListWidget.setSrcList(this.mSrcList);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_COX_REG_DEFINE_EVENT_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractCoxDialog.this.runDefineEventSubDialog();
            }
        };
        this.mDefineEventButton = DialogUtil.createButton(this, "IDS_COX_REG_DEFINE_EVENT_3DOT", toggleButtonAction);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = n2 + DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcList);
        jScrollPane.setPreferredSize(this.mSrcList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 4, n, insets);
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(0, 2 * n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpTimeListPanel(), gridBagConstraints, 1, 0, 2, 1, n, insets);
        insets.top = n2;
        DialogUtil.addUsingGBL(jPanel, this.setUpStatusListPanel(), gridBagConstraints, 1, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLayeredListWidget, gridBagConstraints, 1, 2, 2, 1, n, new Insets(0, n2 / 2, 0, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpStrataListPanel(), gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.setDefaults();
        this.setTabTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        this.mLayeredListWidget.loadListState(dialogDataModel);
        if (dialogDataModel.getArray(METHOD_KEY) != null) {
            this.mMethodStr = (String[])dialogDataModel.getArray(METHOD_KEY);
            this.mMethodCombo.setSelectedItem(this.itemOfCombo(this.mMethodStr[this.mLayeredListWidget.getCurrentLayer()]));
        }
        this.mCount = this.getDialogDataModel().getInteger(COUNT_KEY) != null ? this.getDialogDataModel().getInteger(COUNT_KEY) : 0;
        int n = 0;
        for (VarListModel varListModel : this.mLayeredListWidget.getVarListModels()) {
            n += varListModel.getSize();
        }
        if (n == 0) {
            this.mCount = 0;
        }
        if (this.mCount > 0) {
            this.mCategoricalButton.setEnabled(true);
        } else {
            this.mCategoricalButton.setEnabled(false);
        }
        this.mDefineEventSelected = this.getDialogDataModel().getString(EVENT_VALUE_KEY) != null;
        ISpssVariable[] iSpssVariableArray = this.getDialogDataModel().getVarArray(VAR_SET_KEY);
        if (iSpssVariableArray != null) {
            this.mSetCovariateVariables.clear();
            this.mSetCovariateVariables.addAll(Arrays.asList(iSpssVariableArray));
        }
        this.mFormatter.setVarMap(this.getDialogDataModel().getMap(this.mStatusList.getIdentifier()));
        this.enableOkPaste(this.okPasteValue());
        this.mSrcList.setSelectedIndex(0);
        this.enableBootstrappingButton();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        this.mLayeredListWidget.saveListState(dialogDataModel);
        dialogDataModel.putVarArray(CAT_TARGET_VAR_KEY, this.mCategoryObjectArray);
        dialogDataModel.putInteger(COUNT_KEY, this.mCount);
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[this.mSetCovariateVariables.size()];
        dialogDataModel.putVarArray(VAR_SET_KEY, this.mSetCovariateVariables.toArray(iSpssVariableArray));
        dialogDataModel.putMap(this.mStatusList.getIdentifier(), this.mFormatter.getVarMapForSerialization());
        dialogDataModel.putArray(METHOD_KEY, this.mMethodStr);
    }

    protected void runCategoricalSubDialog() {
        this.updateLayeredPanel();
    }

    protected void runOptionsSubDialog() {
        this.runSubDialog(new CoxOptions(this));
    }

    protected void runDefineEventSubDialog() {
        boolean bl = ((ISpssVariable)this.mStatusList.getSelectedValue()).getType() > 0;
        this.getDialogDataModel().putBoolean(IS_STATUS_STRING_VARIABLE, bl);
        this.runSubDialog(new CoxDefineEvent(this));
        if (this.getDialogDataModel().getString(EVENT_VALUE_KEY) != null) {
            String string = "(" + this.getDialogDataModel().getString(EVENT_VALUE_KEY) + ")";
            ((StatusListModel)this.mStatusList.getModel()).setElementPropertyAt(0, string);
            this.mDefineEventSelected = true;
            this.enableOkPaste(this.okPasteValue());
        } else {
            this.mDefineEventSelected = false;
            this.enableOkPaste(this.okPasteValue());
        }
        this.getDialogDataModel().putBoolean(IS_STATUS_STRING_VARIABLE, false);
    }

    protected abstract void setTabTraversalPolicy();

    protected boolean isVariableExist(VarListModel varListModel, ISpssVariable iSpssVariable) {
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!iSpssVariable.getName().equals(varListModel.getElementAt(i).getName())) continue;
            return true;
        }
        return false;
    }

    private String getMethodSyntaxStr() {
        String string = "";
        if (this.mMethodCombo.getSelectedItem().equals(this.mMethodComboitem[0])) {
            string = "ENTER";
        }
        if (this.mMethodCombo.getSelectedItem().equals(this.mMethodComboitem[1])) {
            string = "FSTEP(COND)";
        }
        if (this.mMethodCombo.getSelectedItem().equals(this.mMethodComboitem[2])) {
            string = "FSTEP(LR)";
        }
        if (this.mMethodCombo.getSelectedItem().equals(this.mMethodComboitem[3])) {
            string = "FSTEP(WALD)";
        }
        if (this.mMethodCombo.getSelectedItem().equals(this.mMethodComboitem[4])) {
            string = "BSTEP(COND)";
        }
        if (this.mMethodCombo.getSelectedItem().equals(this.mMethodComboitem[5])) {
            string = "BSTEP(LR)";
        }
        if (this.mMethodCombo.getSelectedItem().equals(this.mMethodComboitem[6])) {
            string = "BSTEP(WALD)";
        }
        return string;
    }

    private void updateLayeredPanel() {
        this.mLayeredListWidget.getTargetVariableList().setCellRenderer(new CovariateListRenderer());
    }

    private JPanel setUpTimeListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForTimeList, gridBagConstraints, 0, 0, 1, 1, n, this.mArrowInsets);
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COX_REG_TIME_COLON");
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        JScrollPane jScrollPane = new JScrollPane(this.mTimeList);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(this.mTimeList.getPreferredSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 20;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 2, 1, n, new Insets(0, n2, 0, 0));
        return jPanel;
    }

    private JPanel setUpStatusListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForStatusList, gridBagConstraints, 0, 0, 1, 1, n, this.mArrowInsets);
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COX_REG_STATUS_COLON");
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        JScrollPane jScrollPane = new JScrollPane(this.mStatusList);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(this.mStatusList.getPreferredSize());
        n = 20;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 2, 1, n, new Insets(0, n2, 0, 0));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDefineEventButton, gridBagConstraints, 1, 1, 1, 1, n, new Insets(n2, n2, n2, 0));
        return jPanel;
    }

    private JPanel setUpStrataListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForStrataList, gridBagConstraints, 0, 0, 1, 1, n, this.mArrowInsets);
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COX_REG_STRATA_COLON");
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        JScrollPane jScrollPane = new JScrollPane(this.mStrataList);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(this.mStrataList.getPreferredSize());
        n = 20;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mDefineEventSelected = false;
        this.mDefineEventButton.setEnabled(false);
        this.enableOkPaste(false);
        this.mCategoricalButton.setEnabled(false);
        this.mMergeButton.setEnabled(false);
    }

    private boolean okPasteValue() {
        return this.mTimeList.getModel().getSize() > 0 && this.mStatusList.getModel().getSize() > 0 && this.mDefineEventSelected;
    }

    private void updateModel(ISpssVariable iSpssVariable) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(CAT_TARGET_VAR_KEY);
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (iSpssVariableArray != null) {
            arrayList.addAll(Arrays.asList(iSpssVariableArray));
        }
        arrayList.remove(iSpssVariable);
        this.mElementsToRemove.add(iSpssVariable);
        iSpssVariableArray = new ISpssVariable[arrayList.size()];
        dialogDataModel.putVarArray(CAT_TARGET_VAR_KEY, arrayList.toArray(iSpssVariableArray));
    }

    private String itemOfCombo(String string) {
        if (string.equals("ENTER")) {
            return this.mMethodComboitem[0];
        }
        if (string.equals("FSTEP(COND)")) {
            return this.mMethodComboitem[1];
        }
        if (string.equals("FSTEP(LR)")) {
            return this.mMethodComboitem[2];
        }
        if (string.equals("FSTEP(WALD)")) {
            return this.mMethodComboitem[3];
        }
        if (string.equals("BSTEP(COND)")) {
            return this.mMethodComboitem[4];
        }
        if (string.equals("BSTEP(LR)")) {
            return this.mMethodComboitem[5];
        }
        if (string.equals("BSTEP(WALD)")) {
            return this.mMethodComboitem[6];
        }
        return this.mMethodComboitem[0];
    }

    private boolean isVariableExistinArrayList(HashSet<ISpssVariable> hashSet, String string) {
        for (ISpssVariable iSpssVariable : hashSet) {
            String string2 = iSpssVariable.getName();
            if (string2.contains("*")) {
                Scanner scanner = new Scanner(string2);
                scanner.useDelimiter("*");
                while (scanner.hasNext()) {
                    String string3 = scanner.next();
                    if (!string3.equals(string)) continue;
                    return true;
                }
            }
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private void enableBootstrappingButton() {
        if (this.mBootstrappingButton != null) {
            if (!this.areMethodAllENTER()) {
                this.mBootstrappingButton.setEnabled(false);
            } else {
                this.mBootstrappingButton.setEnabled(true);
            }
            if (BootstrapDlg.isCurrentDatasetInMIMode() || CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() != null && RemoteFileChooser.getFileBrowseCallback().isFromModelerModelNode()) {
                this.mBootstrappingButton.setEnabled(false);
            }
        }
    }

    private boolean areMethodAllENTER() {
        for (String string : this.mMethodStr) {
            if (string.equalsIgnoreCase("ENTER")) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ ISpssVariable[] access$402(AbstractCoxDialog abstractCoxDialog, ISpssVariable[] iSpssVariableArray) {
        abstractCoxDialog.mCategoryObjectArray = iSpssVariableArray;
        return iSpssVariableArray;
    }

    protected class ListWidget
    extends LayeredListWidget {
        public ListWidget(String string, ListDataListener listDataListener) {
            super(string, listDataListener);
            this.mArrow.setVarMoveHandler(AbstractCoxDialog.this.mVarMoveHandler);
        }

        public TargetVariableList getCovariateList() {
            return this.mVarList;
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            super.intervalAdded(listDataEvent);
            if (AbstractCoxDialog.this.mCount > 0) {
                AbstractCoxDialog.this.mCategoricalButton.setEnabled(true);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            super.intervalRemoved(listDataEvent);
            if (AbstractCoxDialog.this.mCount == 0) {
                AbstractCoxDialog.this.mCategoricalButton.setEnabled(false);
            }
        }

        @Override
        protected void moreOperationOnNext() {
            AbstractCoxDialog.this.mMethodCombo.setSelectedItem(AbstractCoxDialog.this.itemOfCombo(AbstractCoxDialog.this.mMethodStr[this.getCurrentLayer()]));
            super.moreOperationOnNext();
        }

        @Override
        protected void moreOperationOnPrevious() {
            AbstractCoxDialog.this.mMethodCombo.setSelectedItem(AbstractCoxDialog.this.itemOfCombo(AbstractCoxDialog.this.mMethodStr[this.getCurrentLayer()]));
            super.moreOperationOnPrevious();
        }

        @Override
        protected void setIndependentBorder() {
            this.mBorderTitle = AbstractCoxDialog.this.getResString("IDS_COX_REG_BLOCK_TITLE");
            super.setIndependentBorder();
        }

        @Override
        protected JPanel setupIndependentPanel() {
            this.mBorderTitle = AbstractCoxDialog.this.getResString("IDS_COX_REG_BLOCK_TITLE");
            this.mVarList.setCellRenderer(new CovariateListRenderer());
            this.setLayeredList(this.mVarList);
            this.mArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    ISpssVariable[] iSpssVariableArray;
                    super.actionPerformed(actionEvent);
                    if (ListWidget.this.mArrow.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.left)) {
                        ISpssVariable[] objectArray = iSpssVariableArray = ListWidget.this.mVarList.getSelectedValues();
                        n = objectArray.length;
                        for (int varListModel = 0; varListModel < n; ++varListModel) {
                            ISpssVariable iSpssVariable = objectArray[varListModel];
                            ListWidget.this.mVarList.getModel().removeElement(iSpssVariable);
                            if (!iSpssVariable.getName().contains("*")) continue;
                            Scanner scanner = new Scanner(iSpssVariable.getName());
                            scanner.useDelimiter("\\*");
                            while (scanner.hasNext()) {
                                String string = scanner.next();
                                SpssVariable spssVariable = new SpssVariable();
                                spssVariable.setName(string);
                            }
                        }
                        ListWidget.this.setLayeredList(ListWidget.this.mVarList);
                    }
                    if (ListWidget.this.mArrow.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right)) {
                        iSpssVariableArray = AbstractCoxDialog.this.mSrcList.getSelectedValues();
                        int[] nArray = new int[iSpssVariableArray.length];
                        for (n = 0; n < iSpssVariableArray.length; ++n) {
                            VarListModel varListModel = ListWidget.this.mVarList.getModel();
                            if (!AbstractCoxDialog.this.isVariableExist(varListModel, iSpssVariableArray[n])) {
                                varListModel.addElement(iSpssVariableArray[n]);
                                nArray[n] = varListModel.findElementIndex(iSpssVariableArray[n]);
                                continue;
                            }
                            nArray[n] = ListWidget.this.mVarList.getModel().findElementIndex(iSpssVariableArray[n]);
                        }
                        ListWidget.this.mVarList.setSelectedIndices(nArray);
                        AbstractCoxDialog.this.mSrcList.clearSelection();
                        ListWidget.this.mVarList.requestFocus();
                        this.setEnabled(true);
                    }
                    if (AbstractCoxDialog.this.mCount > 0) {
                        AbstractCoxDialog.this.mCategoricalButton.setEnabled(true);
                    } else {
                        AbstractCoxDialog.this.mCategoricalButton.setEnabled(false);
                    }
                }
            };
            ToggleButtonAction toggleButtonAction = new ToggleButtonAction(AbstractCoxDialog.this, "IDS_COX_REG_MULTIPLE_ADD"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "(" + AbstractCoxDialog.this.getResString("IDS_COX_CAT_CAT_VALUE") + ")";
                    ISpssVariable[] iSpssVariableArray = AbstractCoxDialog.this.mSrcList.getSelectedValues();
                    VarListModel varListModel = ListWidget.this.mVarList.getModel();
                    Object[] objectArray = new String[iSpssVariableArray.length];
                    for (int i = 0; i < iSpssVariableArray.length; ++i) {
                        objectArray[i] = iSpssVariableArray[i].getType() > 0 ? iSpssVariableArray[i].getName() + string : iSpssVariableArray[i].getName();
                        AbstractCoxDialog.this.mSetCovariateVariables.add(iSpssVariableArray[i]);
                    }
                    Arrays.sort(objectArray);
                    String string2 = "";
                    int n = objectArray.length;
                    for (int i = 0; i < n - 1; ++i) {
                        string2 = string2 + (String)objectArray[i] + "*";
                    }
                    string2 = string2 + (String)objectArray[n - 1];
                    SpssVariable spssVariable = new SpssVariable();
                    spssVariable.setName(string2);
                    if (!AbstractCoxDialog.this.isVariableExist(varListModel, (ISpssVariable)spssVariable)) {
                        ListWidget.this.mVarList.getModel().addElement((ISpssVariable)spssVariable);
                        AbstractCoxDialog.this.mCount++;
                        ListWidget.this.mVarList.setSelectedIndex(ListWidget.this.mVarList.getModel().findElementIndex((ISpssVariable)spssVariable));
                        ListWidget.this.mArrow.setEnabled(true);
                    } else {
                        int n2 = -1;
                        for (int i = 0; i < ListWidget.this.mVarList.getModel().getSize(); ++i) {
                            if (!spssVariable.getName().equals(ListWidget.this.mVarList.getModel().getElementAt(i).getName())) continue;
                            n2 = i;
                        }
                        ListWidget.this.mVarList.setSelectedIndex(n2);
                    }
                    if (AbstractCoxDialog.this.mCount > 0) {
                        AbstractCoxDialog.this.mCategoricalButton.setEnabled(true);
                    } else {
                        AbstractCoxDialog.this.mCategoricalButton.setEnabled(false);
                    }
                    AbstractCoxDialog.this.mSrcList.clearSelection();
                }
            };
            AbstractCoxDialog.this.mMergeButton = DialogUtil.createButton(AbstractCoxDialog.this, "IDS_COX_REG_MULTIPLE_ADD", toggleButtonAction);
            this.mVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
            this.mArrow.registerVariableList(this.mVarList, SpssArrowButton.ButtonOrientation.left);
            this.mIndependentListLabel = DialogUtil.createLabel(AbstractCoxDialog.this, "IDS_COX_REG_COVARIATES_COLON");
            this.setUpPanel();
            return this.mLayeredListPanel;
        }

        private void setUpPanel() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            int n = 23;
            Insets insets = new Insets(DialogUtil.getStandardControlInsets().top + 2, DialogUtil.getStandardControlInsets().left + 5, DialogUtil.getStandardControlInsets().bottom + 2, 0);
            this.mLayeredListPanel = new JPanel(new GridBagLayout());
            this.mLayeredListPanel.setBorder(new TitledBorder(this.mBorderTitle + (this.getCurrentLayer() + 1) + ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_INDEPENDENT_LAYER_TITLE2") + (this.getNoOfLayers() + 1)));
            DialogUtil.addUsingGBL(this.mLayeredListPanel, this.setupButtonPanel(), gridBagConstraints, 0, 0, 2, 1, n, insets);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            Insets insets2 = DialogUtil.getStandardControlInsets();
            insets = new Insets(insets2.top + 5, 0, insets2.bottom + 2, insets2.right + 5);
            DialogUtil.addUsingGBL(this.mLayeredListPanel, this.mIndependentListLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
            JPanel jPanel = new JPanel(new GridBagLayout());
            n = 20;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, this.mArrow, gridBagConstraints, 0, 0, 1, 1, n, AbstractCoxDialog.this.mArrowInsets);
            n = 23;
            DialogUtil.addUsingGBL(jPanel, AbstractCoxDialog.this.mMergeButton, gridBagConstraints, 0, 1, 1, 1, n, AbstractCoxDialog.this.mArrowInsets);
            n = 10;
            DialogUtil.addUsingGBL(this.mLayeredListPanel, jPanel, gridBagConstraints, 0, 2, 1, 1, n, null);
            gridBagConstraints.weighty = 1.0;
            n = 23;
            gridBagConstraints.fill = 1;
            JScrollPane jScrollPane = new JScrollPane(this.mVarList);
            Dimension dimension = this.mVarList.getMinimumSize();
            jScrollPane.setPreferredSize(new Dimension(dimension.width, dimension.height + 5));
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setVerticalScrollBarPolicy(20);
            insets = new Insets(0, 0, insets2.bottom + 10, insets2.right + 5);
            DialogUtil.addUsingGBL(this.mLayeredListPanel, jScrollPane, gridBagConstraints, 1, 2, 1, 1, n, insets);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            n = 20;
            JLabel jLabel = DialogUtil.createLabel(AbstractCoxDialog.this, "IDS_COX_REG_METHOD_COLON");
            jLabel.setLabelFor(AbstractCoxDialog.this.mMethodCombo);
            insets = DialogUtil.getStandardControlInsets();
            DialogUtil.addUsingGBL(this.mLayeredListPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(this.mLayeredListPanel, AbstractCoxDialog.this.mMethodCombo, gridBagConstraints, 1, 3, 2, 1, n, insets);
        }
    }

    private class CovariateListRenderer
    extends SpssVariableSimpleTextCellRenderer {
        private CovariateListRenderer() {
        }

        @Override
        protected String getViewText(ISpssVariable iSpssVariable) {
            String string = "(" + AbstractCoxDialog.this.getResString("IDS_COX_CAT_CAT_VALUE") + ")";
            DialogDataModel dialogDataModel = AbstractCoxDialog.this.getDialogDataModel();
            ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(AbstractCoxDialog.CAT_TARGET_VAR_KEY);
            if (iSpssVariableArray != null) {
                AbstractCoxDialog.access$402(AbstractCoxDialog.this, new ISpssVariable[iSpssVariableArray.length]);
                AbstractCoxDialog.access$402(AbstractCoxDialog.this, iSpssVariableArray);
                SpssVariable[] spssVariableArray = new SpssVariable[iSpssVariableArray.length];
                System.arraycopy(iSpssVariableArray, 0, spssVariableArray, 0, iSpssVariableArray.length);
                for (SpssVariable spssVariable : spssVariableArray) {
                    if (spssVariable.getId().equals((Object)iSpssVariable.getId())) {
                        return iSpssVariable.getName() + string;
                    }
                    if (!iSpssVariable.getName().contains("*")) continue;
                    String string2 = iSpssVariable.getName();
                    String string3 = "";
                    Scanner scanner = new Scanner(string2);
                    scanner.useDelimiter("\\*");
                    while (scanner.hasNext()) {
                        String string4 = scanner.next();
                        for (SpssVariable spssVariable2 : spssVariableArray) {
                            if (!string4.equals(spssVariable2.getName()) || string4.contains(string)) continue;
                            string4 = string4 + string;
                        }
                        string3 = string3 + string4 + "*";
                    }
                    string3 = string3.substring(0, string3.length() - 1);
                    return string3;
                }
            }
            if (iSpssVariable.getType() > 0) {
                return iSpssVariable.getName() + string;
            }
            return iSpssVariable.getName();
        }
    }

    private class StatusListModel
    extends CustomVarListModel {
        public StatusListModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(?)");
            return super.insertElementAt(iSpssVariable, n);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(?)");
            return super.addElement(iSpssVariable);
        }

        public void setElementPropertyAt(int n, String string) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), string);
            this.fireContentsChanged(iSpssVariable, n, n);
        }
    }

    class CoxRegressionVarMoveHandler
    implements IVarMoveHandler {
        CoxRegressionVarMoveHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            String string = AbstractCoxDialog.this.getResString("IDS_COX_CAT_CAT_VALUE");
            TargetVariableList targetVariableList = AbstractCoxDialog.this.mLayeredListWidget.getCovariateList();
            VarListModel varListModel = targetVariableList.getModel();
            if (variableList.equals(AbstractCoxDialog.this.mTimeList) || variableList.equals(AbstractCoxDialog.this.mStatusList) || variableList.equals(AbstractCoxDialog.this.mStrataList)) {
                ISpssVariable iSpssVariable = (ISpssVariable)AbstractCoxDialog.this.mSrcList.getSelectedValue();
                if (iSpssVariable != null) {
                    if (AbstractCoxDialog.this.mTimeCovariateVariable != null && iSpssVariable.getId().equals((Object)AbstractCoxDialog.this.mTimeCovariateVariable.getId())) {
                        return false;
                    }
                    if (AbstractCoxDialog.this.isVariableExistinArrayList(AbstractCoxDialog.this.mSetCovariateVariables, iSpssVariable.getName())) {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)AbstractCoxDialog.this), ResUtil.getCommonDlgString("ERR_CANNOT_ACCEPT_VARS_PRESENT_IN_OTHER_TARGET_LIST"), VersionInfo.getAppVersionString());
                        return false;
                    }
                }
            } else {
                if (variableList.equals(targetVariableList)) {
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (AbstractCoxDialog.this.isVariableExist(varListModel, iSpssVariable)) continue;
                        AbstractCoxDialog.this.mCount++;
                        AbstractCoxDialog.this.mSetCovariateVariables.add(iSpssVariable);
                    }
                    return true;
                }
                if (variableList.equals(AbstractCoxDialog.this.mSrcList)) {
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (!AbstractCoxDialog.this.isVariableExist(varListModel, iSpssVariable)) continue;
                        AbstractCoxDialog.this.mCount--;
                        if (iSpssVariable.getName().contains("*")) {
                            Scanner scanner = new Scanner(iSpssVariable.getName());
                            scanner.useDelimiter("\\*");
                            while (scanner.hasNext()) {
                                int n;
                                ISpssVariable iSpssVariable2;
                                String string2 = scanner.next();
                                LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                                if (string2.contains(string)) {
                                    string2 = string2.substring(0, string2.indexOf("("));
                                }
                                if (AbstractCoxDialog.this.getVarCountInLayeredPanel((iSpssVariable2 = iSpssDataSrc.getVariable(n = iSpssDataSrc.findVarIndex(string2))).getName()) == 0) {
                                    AbstractCoxDialog.this.updateModel(iSpssVariable2);
                                }
                                this.removeVarFromSetIfExist(AbstractCoxDialog.this.mSetCovariateVariables, (SpssVariable)iSpssVariable2);
                            }
                            continue;
                        }
                        if (AbstractCoxDialog.this.getVarCountInLayeredPanel(iSpssVariable.getName()) != 1) continue;
                        AbstractCoxDialog.this.updateModel(iSpssVariable);
                        this.removeVarFromSetIfExist(AbstractCoxDialog.this.mSetCovariateVariables, (SpssVariable)iSpssVariable);
                    }
                }
            }
            return true;
        }

        private boolean removeVarFromSetIfExist(HashSet<ISpssVariable> hashSet, SpssVariable spssVariable) {
            for (ISpssVariable iSpssVariable : hashSet) {
                if (!iSpssVariable.getName().equals(spssVariable.getName())) continue;
                hashSet.remove(iSpssVariable);
                return true;
            }
            return false;
        }
    }
}

