/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.datamodel.DataModel;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.ExecStartupPreferences;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetMoveList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioPeriodDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMMultiDimScenariosTable;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMSelectDimensionValuesTable;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import com.spss.pes.util.io.FileUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TCMUtilities {
    private static final String TEMP_TCSM_SCENARIOS_EXPRESSION_XML_NAME = "TCMANALYSIS_expressions.xml";
    static Long mExpressionID = null;

    public static ResourceBundle getTCMResBundle() {
        return ResUtil.getBundle(TCMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
    }

    public static ArrayList<Object> getVariablesFromListDataEvent(TargetMoveList targetMoveList, ListDataEvent listDataEvent) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (targetMoveList.getModel().getSize() > 0 && listDataEvent.getIndex1() < targetMoveList.getModel().getSize()) {
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                String string = (String)targetMoveList.getModel().getElementAt(i);
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static ArrayList<ISpssVariable> getVariablesFromListDataEvent(SrcVariableList srcVariableList, ListDataEvent listDataEvent) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (srcVariableList.getModel().getSize() > 0 && listDataEvent.getIndex1() < srcVariableList.getModel().getSize()) {
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                ISpssVariable iSpssVariable = srcVariableList.getModel().getElementAt(i);
                if (iSpssVariable == null) continue;
                arrayList.add(iSpssVariable);
            }
        }
        return arrayList;
    }

    public static ArrayList<ISpssVariable> getVariablesFromListDataEvent(TargetVariableList targetVariableList, ListDataEvent listDataEvent) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (targetVariableList.getModel().getSize() > 0 && listDataEvent.getIndex1() < targetVariableList.getModel().getSize()) {
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
                if (iSpssVariable == null) continue;
                arrayList.add(iSpssVariable);
            }
        }
        return arrayList;
    }

    public static void throwErrorDialog(JDialog jDialog, String string) {
        Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
        SpssAlertOptionPane.showOptionDialog(jDialog, string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, objectArray[0]);
    }

    public static boolean isExpressionValid(BaseDialog baseDialog, String string) {
        ExpressionBuilderTextArea expressionBuilderTextArea = new ExpressionBuilderTextArea();
        expressionBuilderTextArea.setText(string);
        boolean bl = true;
        if (!expressionBuilderTextArea.validateContents() || !DialogUtil.isValidIfExpression(expressionBuilderTextArea.getText(), baseDialog)) {
            bl = false;
        }
        return bl;
    }

    public static String replaceSpacesWithUndeline(String string) {
        return string.replace(' ', '_');
    }

    public static String getTCMScenarioExpressionsTempFileNamePath() {
        String string = TCMUtilities.getOtherFilePath();
        return "*" + TCMUtilities.getFileSeparator(string) + TEMP_TCSM_SCENARIOS_EXPRESSION_XML_NAME;
    }

    static String getOtherFilePath() {
        if (DataServerProxy.getDataProxy().isRemoteConnection()) {
            return FileLocationsUtil.getDataFilesDirectoryPath();
        }
        return FileLocationsUtil.getOtherFilesDirectoryPath();
    }

    static char getFileSeparator(String string) {
        char c = string.indexOf(47) >= 0 ? (char)'/' : '\\';
        return c;
    }

    static String getTempFileDirectory() {
        return ExecStartupPreferences.getTempDirectory().getAbsolutePath();
    }

    public static String formatMTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMC"));
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String formatDateValueToISO8601(Long l, SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType) {
        SimpleDateFormat simpleDateFormat = TCMUtilities.getISO8601DateTimeFormatter(simpleDateTimeType);
        return simpleDateFormat.format(new Date(l));
    }

    public static String formatDateValueToISO8601(Date date, SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType) {
        SimpleDateFormat simpleDateFormat = TCMUtilities.getISO8601DateTimeFormatter(simpleDateTimeType);
        return simpleDateFormat.format(date);
    }

    public static SimpleDateFormat getISO8601DateTimeFormatter(SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType) {
        String string = "yyyy-MM-dd HH:mm:ss";
        if (simpleDateTimeType == SpssDateFormatHelper.SimpleDateTimeType.DATE) {
            string = "yyyy-MM-dd";
        } else if (simpleDateTimeType == SpssDateFormatHelper.SimpleDateTimeType.TIME) {
            string = "HH:mm:ss";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMC"));
        return simpleDateFormat;
    }

    public static boolean isValidFileDirectory(JDialog jDialog, String string, String string2, String string3) {
        boolean bl = true;
        String string4 = FileUtil.getExtension((String)string);
        if (string == null || string.trim().length() == 0 || string4 == null || string4.trim().length() == 0) {
            TCMUtilities.throwErrorDialog(jDialog, string2);
            bl = false;
        } else {
            String string5 = FileUtil.getDirectoryName((String)string);
            RemoteFileStatus remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(string);
            if (remoteFileStatus.getParentDirStatus() == RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST || remoteFileStatus.getParentDirStatus() == RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY) {
                TCMUtilities.throwErrorDialog(jDialog, string3);
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isValidFile(JDialog jDialog, String string, String string2, String string3) {
        boolean bl = true;
        String string4 = FileUtil.getExtension((String)string);
        if (string == null || string.trim().length() == 0 || string4 == null || string4.trim().length() == 0) {
            TCMUtilities.throwErrorDialog(jDialog, string2);
            bl = false;
        } else {
            RemoteFileStatus remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(string);
            if (remoteFileStatus.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST || remoteFileStatus.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY) {
                TCMUtilities.throwErrorDialog(jDialog, string3);
                bl = false;
            }
        }
        return bl;
    }

    public static Vector<ISpssVariable> getNumericFields() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.columnCount();
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            if (!iSpssVariable.getFormat().getFormatType().isNumericFormat()) continue;
            vector.add(iSpssVariable);
        }
        return vector;
    }

    public static JPanel createInfoPanel(FocusableTextArea focusableTextArea) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, focusableTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    public static void stopTableEditing(JTable jTable) {
        if (jTable != null && jTable.isEditing()) {
            TableCellEditor tableCellEditor = jTable.getCellEditor(jTable.getEditingRow(), jTable.getEditingColumn());
            tableCellEditor.stopCellEditing();
        }
    }

    public static String getScenarioPeriodSyntax(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/SCENARIOPERIOD"));
        stringBuffer.append(" TIMES=");
        String string = scenarioPeriodInfo.isSpecifyByStartEndPredictTimes() ? "ABSOLUTE" : "RELATIVE";
        stringBuffer.append(string);
        if (scenarioPeriodInfo.isSpecifyByStartEndPredictTimes()) {
            String string2 = TCMUtilities.getSpecifyByStartEndPredictTimesSyntax(tCMForecastGatingInfo, scenarioPeriodInfo);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            }
        } else {
            String string3 = TCMUtilities.getSpecifyByTimeIntervalSyntax(scenarioPeriodInfo);
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(string3);
            }
        }
        return stringBuffer.toString();
    }

    public static String getSpecifyByStartEndPredictTimesSyntax(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        if (scenarioPeriodInfo.isDateTime()) {
            Object[] objectArray;
            boolean bl = tCMForecastGatingInfo.getDateTimeField().equals("mtime");
            Long l = scenarioPeriodInfo.getPredictDateTimeTableInfo().getStartTime();
            Long l2 = scenarioPeriodInfo.getPredictDateTimeTableInfo().getEndTime();
            Long l3 = scenarioPeriodInfo.getPredictDateTimeTableInfo().getPredictTime();
            String string = TCMUtilities.formatStartEndPredictTimes(l, tCMForecastGatingInfo.getDateTimeInfo().getDateTimeType(), bl);
            String string2 = TCMUtilities.formatStartEndPredictTimes(l2, tCMForecastGatingInfo.getDateTimeInfo().getDateTimeType(), bl);
            String string3 = TCMUtilities.formatStartEndPredictTimes(l3, tCMForecastGatingInfo.getDateTimeInfo().getDateTimeType(), bl);
            string = string != null ? SyntaxUtil.wrapText(string, '\'') : null;
            string2 = string2 != null ? SyntaxUtil.wrapText(string2, '\'') : null;
            string3 = string3 != null ? SyntaxUtil.wrapText(string3, '\'') : null;
            String string4 = bl ? "VARIABLE" : "ISO8601";
            stringBuffer.append(" FORMAT=" + string4);
            if (string3 == null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = string;
                objectArray = objectArray2;
                objectArray2[1] = string2;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = string;
                objectArray3[1] = string2;
                objectArray = objectArray3;
                objectArray3[2] = string3;
            }
            Object[] objectArray4 = objectArray;
            String string5 = string3 == null ? " START={0} END={1}" : " START={0} END={1} PREDICTTHRU ={2}";
            String string6 = MessageFormat.format(string5, objectArray4);
            stringBuffer.append(string6);
        } else {
            Object object;
            String string7;
            TCMScenarioPeriodDlg.PredictCyclicTableModel.PredictCyclicTableInfo predictCyclicTableInfo = scenarioPeriodInfo.getPredictCyclicTableInfo();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (String string7 : predictCyclicTableInfo.getCyclicNames()) {
                Long l;
                Long l4;
                object = predictCyclicTableInfo.getCyclicNameToStartValueMap().get(string7);
                if (object != null) {
                    arrayList.add("" + object);
                }
                if ((l4 = predictCyclicTableInfo.getCyclicNameToEndValueMap().get(string7)) != null) {
                    arrayList2.add("" + l4);
                }
                if ((l = predictCyclicTableInfo.hasCyclicPredictTimes() ? predictCyclicTableInfo.getCyclicNameToPredictValueMap().get(string7) : null) == null) continue;
                arrayList3.add("" + l);
            }
            String string8 = TCMUtilities.getCyclicStartEndPredictSyntax(" START=", arrayList);
            if (string8 != null) {
                stringBuffer.append(string8);
            }
            if ((string7 = TCMUtilities.getCyclicStartEndPredictSyntax(" END=", arrayList2)) != null) {
                stringBuffer.append(string7);
            }
            if ((object = TCMUtilities.getCyclicStartEndPredictSyntax(" PREDICTTHRU=", arrayList3)) != null) {
                stringBuffer.append((String)object);
            }
        }
        return stringBuffer.toString();
    }

    private static String formatStartEndPredictTimes(Long l, SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType, boolean bl) {
        String string = null;
        if (l != null) {
            string = bl ? TCMUtilities.formatMTime(new Date(l)) : TCMUtilities.formatDateValueToISO8601(l, simpleDateTimeType);
        }
        return string;
    }

    public static String getSpecifyByTimeIntervalSyntax(TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
        Object[] objectArray = new Object[]{scenarioPeriodInfo.getStartingIntervalScenarioValue(), scenarioPeriodInfo.getEndingIntervalScenarioValue(), "" + scenarioPeriodInfo.getIntervalsToPredict()};
        String string = MessageFormat.format(" START={0} END={1} PREDICTTHRU={2}", objectArray);
        return string;
    }

    public static String getCyclicStartEndPredictSyntax(String string, ArrayList<String> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList != null && arrayList.size() > 0) {
            stringBuffer.append(string);
            for (String string2 : arrayList) {
                stringBuffer.append(string2);
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    public static int findString(ArrayList<String> arrayList, String string, boolean bl) {
        return TCMUtilities.findString(arrayList.toArray(new String[arrayList.size()]), string, bl);
    }

    public static int findString(String[] stringArray, String string, boolean bl) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (bl) {
                if (!string2.equalsIgnoreCase(string)) continue;
                n = i;
                break;
            }
            if (!string2.equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static Vector<String> convertListToVector(ArrayList<String> arrayList) {
        Vector<String> vector = new Vector<String>();
        if (arrayList != null) {
            for (String string : arrayList) {
                vector.add(string);
            }
        }
        return vector;
    }

    public static ArrayList<Long> getStartEstimationPeriodCycle(TCMForecastGatingInfo tCMForecastGatingInfo, int n, int n2) {
        int n3 = -Math.min(0, n2);
        ArrayList<Long> arrayList = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToEndEstimationValues();
        for (int i = 0; i <= -(n + 1); ++i) {
            if (i < n3) continue;
            arrayList = TCMUtilities.decrementCyclicValues(tCMForecastGatingInfo, arrayList, tCMForecastGatingInfo.getCyclicInfo().getIncrement());
        }
        return arrayList;
    }

    public static ArrayList<Long> decrementCyclicValues(TCMForecastGatingInfo tCMForecastGatingInfo, ArrayList<Long> arrayList, Long l) {
        HashMap<String, Long> hashMap = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToRangeStartMap();
        HashMap<String, Long> hashMap2 = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToRangeEndMap();
        Long[] longArray = new Long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            longArray[i] = arrayList.get(i);
        }
        ArrayList<Long> arrayList2 = TCMForecastGatingInfo.getCyclicValues(tCMForecastGatingInfo.getCyclicInfo().getCyclicFieldNames(), hashMap);
        ArrayList<Long> arrayList3 = TCMForecastGatingInfo.getCyclicValues(tCMForecastGatingInfo.getCyclicInfo().getCyclicFieldNames(), hashMap2);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Long[] longArray2 = arrayList2.get(i);
            if (longArray2 == null || arrayList.get(i) - l >= longArray2.longValue()) {
                longArray[i] = arrayList.get(i) - l;
                break;
            }
            longArray[i] = arrayList3.get(i);
        }
        ArrayList<Long> arrayList4 = new ArrayList<Long>();
        for (Long l2 : longArray) {
            arrayList4.add(l2);
        }
        return arrayList4;
    }

    public static DataModel createDataModelFromDataModelXML(String string) {
        DataModel dataModel = new DataModel();
        try {
            XMLStreamReader xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(string));
            dataModel.read(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            dataModel = null;
            xMLStreamException.printStackTrace();
        }
        return dataModel;
    }

    public static ISpssVariable findVariableInActiveDataset(String string) {
        ISpssVariable iSpssVariable = null;
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
            ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(i);
            String string2 = iSpssVariable2.getName();
            if (!string.equals(string2)) continue;
            iSpssVariable = iSpssVariable2;
            break;
        }
        return iSpssVariable;
    }

    public static String getVarLabel(String string) {
        ISpssVariable iSpssVariable = TCMUtilities.findVariableInActiveDataset(string);
        String string2 = iSpssVariable != null ? iSpssVariable.getLabel() : string;
        return string2;
    }

    public static boolean isShowVarLabels() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("general");
        return preferences3.get("var_list_display", "").equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
    }

    public static Vector<ISpssVariable> getMetricVariables(TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
        ArrayList<String> arrayList = bl ? tCMForecastGatingInfo.getMetricFieldNames(TCMForecastGatingInfo.ListType.TARGET_METRICS) : tCMForecastGatingInfo.getMetricFieldNames(TCMForecastGatingInfo.ListType.ALL_METRICS);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (String string : arrayList) {
            ISpssVariable iSpssVariable = TCMUtilities.findVariableInActiveDataset(string);
            if (iSpssVariable == null) continue;
            vector.add(iSpssVariable);
        }
        return vector;
    }

    public static void setDimensionColHeaderImage(JTable jTable, TCMMultiDimScenariosTable.MyTableSorter myTableSorter, ArrayList<Integer> arrayList, final ImageIcon imageIcon) {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JTableHeader jTableHeader = jTable.getTableHeader();
                Color color = jTableHeader.getForeground();
                Color color2 = jTableHeader.getBackground();
                Border border = UIManager.getBorder("TableHeader.cellBorder");
                this.setBorder(border);
                this.setForeground(color);
                this.setBackground(color2);
                this.setHorizontalTextPosition(10);
                this.setText((String)(object != null ? object.toString() : object));
                this.setIcon(imageIcon);
                this.setHorizontalAlignment(0);
                return this;
            }
        };
        for (Integer n : arrayList) {
            jTable.getTableHeader().getColumnModel().getColumn(n).setHeaderRenderer(defaultTableCellRenderer);
        }
    }

    public static void addTooltip(BaseDialog baseDialog, JButton jButton, String string) {
        String string2 = baseDialog.getResString(string + "_TOOLTIP");
        if (jButton != null) {
            jButton.setToolTipText(string2);
        }
    }

    public static Vector<String> getDimensionValuesVector(TCMSelectDimensionValuesTable tCMSelectDimensionValuesTable, int n) {
        return TCMUtilities.getDimensionValuesVector(tCMSelectDimensionValuesTable, TCMUtilities.convertListToVector(tCMSelectDimensionValuesTable.getDimensionNames()), n);
    }

    public static Vector<String> getDimensionValuesVector(TCMSelectDimensionValuesTable tCMSelectDimensionValuesTable, Vector<String> vector, int n) {
        TCMSelectDimensionValuesTable.RowData rowData = tCMSelectDimensionValuesTable.getRowDatas().size() > 0 ? tCMSelectDimensionValuesTable.getRowDatas().get(n) : null;
        Vector<String> vector2 = new Vector<String>();
        if (rowData != null) {
            for (String string : vector) {
                ArrayList<String> arrayList = rowData.getDimValuesForDimName(string);
                String string2 = arrayList != null && arrayList.size() > 0 ? arrayList.get(0) : null;
                if (string2 == null || string2.trim().length() <= 0) continue;
                vector2.add(string2);
            }
        }
        return vector2.size() > 0 ? vector2 : null;
    }

    public static void writeOutputFileXML_JSON(String string, String string2, String string3) {
        String string4 = string != null ? com.ibm.statistics.lighttable.ui.util.FileUtil.getFileNameWithoutExtension((String)string) : "";
        String string5 = TCMUtilities.getFilepath(string4, string2);
        try {
            PrintWriter printWriter = new PrintWriter(string5);
            printWriter.println(string3);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static NumberSpinner createPercentSpinner(JLabel jLabel) {
        return TCMUtilities.createPercentSpinner(jLabel, 0.0, 100.0);
    }

    public static NumberSpinner createPercentSpinner(JLabel jLabel, double d, double d2) {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(d, d, d2, 1.0);
        spinnerNumberModel.setStepSize(1);
        FloatTextField floatTextField = new FloatTextField(d, d2, 5, true);
        floatTextField.setAllowMinMax(false, false);
        floatTextField.setHorizontalAlignment(4);
        NumberSpinner numberSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        if (jLabel != null) {
            jLabel.setLabelFor((Component)numberSpinner);
        }
        return numberSpinner;
    }

    public static String getExpressionID() {
        mExpressionID = mExpressionID == null ? Calendar.getInstance().getTime().getTime() : mExpressionID + 1L;
        return "EXP_ID_" + mExpressionID;
    }

    private static String getFilepath(String string, String string2) {
        return "C:\\Users\\datkinson\\Documents\\TCM\\XMLOutput\\" + string + "_" + string2 + ".xml";
    }

    public static class IntegerCellEditor
    extends DefaultCellEditor {
        private JTextField textField;

        public IntegerCellEditor(JTextField jTextField) {
            super(jTextField);
            this.textField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            if (string.trim().length() > 0) {
                Long l;
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    l = null;
                }
                return l;
            }
            return string;
        }
    }

    public static class DoubleCellEditor
    extends DefaultCellEditor {
        private JTextField textField;

        public DoubleCellEditor(JTextField jTextField) {
            super(jTextField);
            this.textField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            if (string.trim().length() > 0) {
                Double d;
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    d = null;
                }
                return d;
            }
            return string;
        }
    }

    public static class ScenarioValueCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            object = object != null ? "" + object : "";
            this.setText((String)object);
            return this;
        }
    }
}

