/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.ui.controls.TableSorter;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMMultiDimScenarioDefinitionDialog;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioPeriodDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMSelectDimensionValuesInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMSelectDimensionValuesTable;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.controls.row_management_table.AbstractListTableModel;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class TCMMultiDimScenariosTable
extends JTable {
    public static final int ID_COL = 0;
    public static final int ROOT_FIELD_COL = 1;
    public static final int VALUE_COL = 2;
    TCMForecastGatingInfo mTCMForecastGatingInfo;
    private BaseTabbedDialog mParentDialog;
    private ResourceBundle mResourceBundle;
    private String mImageFilePath = TCMResBundle.getImageFolder();
    private TCMMultiDimScenariosTableModel mTableModel;
    private MyTableSorter mTableSorter;
    private boolean mIsGroup = true;

    public TCMMultiDimScenariosTable(BaseTabbedDialog baseTabbedDialog, TCMForecastGatingInfo tCMForecastGatingInfo, ResourceBundle resourceBundle, boolean bl) {
        this.mIsGroup = bl;
        this.mTableModel = new TCMMultiDimScenariosTableModel(tCMForecastGatingInfo.getMultiDimensionInfo().getDimFields(), resourceBundle, this.mIsGroup);
        this.mTableSorter = new MyTableSorter(this.mTableModel, this.getTableHeader());
        this.setModel(this.mTableSorter);
        this.mParentDialog = baseTabbedDialog;
        this.mResourceBundle = resourceBundle;
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        ArrayList<Integer> arrayList = this.mTableModel.getDimensionColumns();
        TCMUtilities.setDimensionColHeaderImage(this, this.mTableSorter, arrayList, new ImageIcon(this.getResImageURL("IDS_TCM_DIMENSION_COLHEADER_IMAGE")));
        this.getColumnModel().getColumn(this.mTableModel.getExpressionValueColumn()).setCellRenderer(new MYValueExpressionCellRenderer());
    }

    public void setModel(TableSorter tableSorter) {
        super.setModel(tableSorter);
    }

    public void reset() {
        this.mTableModel.reset();
    }

    public boolean isScenarioIDUnique(String string, int n) {
        int n2 = this.mTableModel.findRowByScenarioIDName(string);
        return n2 < 0 || n != -1 && n2 == n;
    }

    public int findRowByScenarioIDName(String string) {
        return this.mTableModel.findRowByScenarioIDName(string);
    }

    protected void initSelectionListener() {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().addListSelectionListener(this);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.processControlStates();
        this.repaint();
    }

    public void processControlStates() {
        int[] nArray = this.getSelectedRows();
        boolean bl = nArray.length > 0;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (!super.editCellAt(n, n2, eventObject)) {
            return false;
        }
        Component component = this.getEditorComponent();
        component.requestFocusInWindow();
        if (component.getClass() == JComboBox.class) {
            final ComboBoxEditor comboBoxEditor = ((JComboBox)component).getEditor();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)comboBoxEditor.getEditorComponent()).selectAll();
                }
            });
        }
        return true;
    }

    public Color getForegroundColor(Component component, boolean bl) {
        Color color = component.getForeground();
        if (bl) {
            if (component instanceof JTable) {
                color = ((JTable)component).getSelectionForeground();
            } else if (component instanceof JList) {
                color = ((JList)component).getSelectionForeground();
            }
        }
        return color;
    }

    public Color getBackgroundColor(Component component, int n, boolean bl) {
        Color color = component.getBackground();
        if (bl) {
            if (component instanceof JTable) {
                color = ((JTable)component).getSelectionBackground();
            } else if (component instanceof JList) {
                color = ((JList)component).getSelectionBackground();
            }
        }
        return color;
    }

    public URL getResImageURL(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return UIToolResUtil.getImageResourceFullPath((String)(this.mImageFilePath + string2));
    }

    public String copyRow(int n) {
        return this.mTableModel.copyRow(n);
    }

    public void addScenario(TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo) {
        this.mTableModel.addScenario(multiDimScenarioDefinitionInfo);
    }

    public void selectRowsByScenarioIDNames(ArrayList<String> arrayList) {
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            int n = this.mTableModel.findRowByScenarioIDName(string);
            if (i == -1) continue;
            this.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo getScenarioDefinitionInfoForRow(int n) {
        int n2 = this.mTableSorter.modelIndex(n);
        return this.mTableModel.getRowDataAt(n2) != null ? this.mTableModel.getRowDataAt(n2).getScenarioDefinitionInfo() : null;
    }

    public void editScenario(int n, TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo) {
        int n2 = this.mTableSorter.modelIndex(n);
        RowData rowData = this.mTableModel.getRowDataAt(n2);
        if (rowData != null) {
            rowData.setScenarioDefinitionInfoForRow(multiDimScenarioDefinitionInfo);
        }
        this.mTableModel.fireTableRowsUpdated(n, n);
        this.repaint();
    }

    public boolean setNewScenarioPeriod(TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
        return this.mTableModel.setNewScenarioPeriod(scenarioPeriodInfo);
    }

    public String getScenarioSyntax(boolean bl) {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        for (int i = 0; i < this.mTableModel.getRowDatas().size(); ++i) {
            RowData rowData = this.mTableModel.getRowDatas().get(i);
            boolean bl2 = !bl && rowData.getScenarioDefinitionInfo().isSpecifyScenarioValuesForRootField();
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand(bl ? "/SCENARIOGROUP" : "/SCENARIO"));
            String string = bl2 ? (String)this.mTableModel.getValueAt(i, 0) : rowData.getSyntaxScenarioID();
            String string2 = rowData.getExpressionID();
            stringBuffer.append(MessageFormat.format(bl ? " IDPREFIX={0}" : " ID={0}", string != null ? SyntaxUtil.wrapTextSingleQuotes(string) : ""));
            TCMSelectDimensionValuesTable.RowData rowData2 = rowData.getScenarioDefinitionInfo().getRootTableRowData();
            String string3 = rowData2.getVarName();
            String string4 = bl2 ? (String)this.mTableModel.getValueAt(i, this.mTableModel.getExpressionValueColumn()) : string2;
            String string5 = bl ? " EXPRESSION={0}" : " VALUES=EXPRESSION({0})";
            String string6 = bl2 ? " VALUES=ACTUAL({0})" : string5;
            stringBuffer.append(MessageFormat.format(string6, string != null ? string4 : ""));
            stringBuffer.append(MessageFormat.format(" ROOTFIELD={0}", string3 != null ? string3 : ""));
            String string7 = this.getRootDimValuesSyntax(rowData2);
            if (string7 != null) {
                stringBuffer.append(string7);
            }
            if (rowData.getScenarioDefinitionInfo().isAffectedTargetsSelected()) {
                stringBuffer.append(MessageFormat.format(" EFFECTS=TARGETLIST({0})", string));
                ArrayList<TCMSelectDimensionValuesTable.RowData> arrayList = rowData.getScenarioDefinitionInfo().getTargetTableRowDatas();
                for (int j = 0; j < arrayList.size(); ++j) {
                    String string8;
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/TARGETLIST"));
                    stringBuffer.append(MessageFormat.format(" LISTID={0}", string));
                    stringBuffer.append(" FIELDS=");
                    TCMSelectDimensionValuesTable.RowData rowData3 = arrayList.get(j);
                    stringBuffer.append(rowData3.getVarName());
                    if (j + 1 < arrayList.size()) {
                        stringBuffer.append(" ");
                    }
                    if ((string8 = this.geTargetDimValuesSyntax(rowData3)) == null || string8.length() <= 0) continue;
                    stringBuffer.append(string8);
                }
                continue;
            }
            stringBuffer.append(" EFFECTS=AUTOMATIC");
        }
        return stringBuffer.toString();
    }

    public String getRootDimValuesSyntax(TCMSelectDimensionValuesTable.RowData rowData) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = rowData.getDimNames();
        if (arrayList.size() > 0) {
            stringBuffer.append(" DIMVALUES=");
        }
        for (String string : arrayList) {
            ArrayList<String> arrayList2 = rowData.getDimValuesForDimName(string);
            String string2 = this.mIsGroup ? " {0}(VALUES={1})" : " {0}(VALUE={1}) ";
            String string3 = SyntaxUtil.getDelimitedStringFromStringList(arrayList2, ",", Character.valueOf('\''));
            String string4 = arrayList2 != null && arrayList2.size() > 0 ? MessageFormat.format(string2, string, string3) : null;
            if (string4 == null) continue;
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public String geTargetDimValuesSyntax(TCMSelectDimensionValuesTable.RowData rowData) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = rowData.getDimNames();
        if (arrayList.size() > 0) {
            stringBuffer.append(" DIMVALUES=");
        }
        for (String string : arrayList) {
            TCMSelectDimensionValuesInfo tCMSelectDimensionValuesInfo = rowData.getSelectDimensionValuesInfoForDimName(string);
            if (tCMSelectDimensionValuesInfo == null || tCMSelectDimensionValuesInfo.isSelectAllValues()) continue;
            ArrayList<String> arrayList2 = rowData.getDimValuesForDimName(string);
            String string2 = SyntaxUtil.getDelimitedStringFromStringList(arrayList2, ",", Character.valueOf('\''));
            String string3 = arrayList2 != null && arrayList2.size() > 0 ? MessageFormat.format("{0}(VALUES={1}) ", string, string2) : null;
            if (string3 == null) continue;
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public String getComputeSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        for (int i = 0; i < this.mTableModel.getRowDatas().size(); ++i) {
            String string;
            RowData rowData = this.mTableModel.getRowDatas().get(i);
            String string2 = rowData.getSyntaxScenarioID() != null ? rowData.getExpressionID() : rowData.getScenarioID();
            String string3 = rowData.getScenarioDefinitionInfo().getExpression();
            if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0 || (string = MessageFormat.format("COMPUTE {0}={1}.", string2, string3)) == null) continue;
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public ArrayList<String> getScenarioIDList() {
        return this.mTableModel.getScenarioIDList();
    }

    public void generateUniqueSyntaxExpressionIDs(ArrayList<String> arrayList) {
        this.mTableModel.generateUniqueSyntaxExpressionIDs(arrayList);
    }

    public boolean doValidateTable() {
        String string = null;
        TCMUtilities.stopTableEditing(this);
        ArrayList<RowData> arrayList = this.mTableModel.getRowDatas();
        for (int i = 0; i < arrayList.size(); ++i) {
            TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo;
            boolean bl;
            RowData rowData = arrayList.get(i);
            if (rowData.getScenarioID() == null || rowData.getScenarioID().trim().length() == 0) {
                string = this.mParentDialog.getResString("IDS_TCM_SCENARIO_DEFINITION_SCENARIO_ID_IS_REQUIRED_ERROR_MESSAGE");
                TCMUtilities.throwErrorDialog((JDialog)((Object)this.mParentDialog), string);
                this.setRowSelectionInterval(i, i);
                break;
            }
            if (string == null && this.hasValues(rowData) && !(bl = (multiDimScenarioDefinitionInfo = rowData.getScenarioDefinitionInfo()).areAllScenarioValuesDefined())) {
                string = this.mParentDialog.getResString("IDS_TCM_SCENARIO_DEFINITION_SCENARIO_VALUES_MUST_BE_SPECIFIED_ERROR_MESSAGE");
                break;
            }
            if (string == null) continue;
            TCMUtilities.throwErrorDialog((JDialog)((Object)this.mParentDialog), string);
        }
        return string == null;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() == 401 && (keyEvent.isControlDown() || keyEvent.isMetaDown()) && !keyEvent.isAltDown()) {
            if (keyEvent.getKeyCode() == 67) {
                this.doCopySelectedRows();
            }
        } else if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 127) {
            this.deleteSelectedRows();
        }
    }

    public void doCopySelectedRows() {
        int[] nArray = this.getSelectedRows();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            String string = this.copyRow(n);
            if (string == null) continue;
            arrayList.add(string);
        }
        this.selectRowsByScenarioIDNames(arrayList);
    }

    public void deleteSelectedRows() {
        TCMUtilities.stopTableEditing(this);
        int[] nArray = this.getSelectedRows();
        ArrayList<RowData> arrayList = this.mTableModel.getRowDatas();
        if (arrayList != null && arrayList.size() > 0) {
            int n = arrayList.size();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = this.mTableSorter.modelIndex(nArray[i]);
                if (arrayList.remove(n2) == null) continue;
                this.mTableModel.fireTableDataChanged();
                ListSelectionModel listSelectionModel = this.getSelectionModel();
                listSelectionModel.setSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
            }
        }
    }

    public void stopTableEditing() {
        TCMUtilities.stopTableEditing(this);
    }

    protected void doRemove() {
        int[] nArray = this.getSelectedRows();
        if (this.canRemove(nArray)) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                if (nArray == null || nArray.length <= 0) continue;
                int n2 = this.mTableSorter.modelIndex(n);
                this.mTableModel.remove(n2);
            }
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.setSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
            this.processControlStates();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected boolean canRemove() {
        return this.canRemove(this.getSelectedRows());
    }

    protected boolean canRemove(int[] nArray) {
        return nArray.length > 0 && this.getRowCount() > 0;
    }

    private void cancelEditingInSelectedRows() {
        int n;
        if (this.isEditing() && this.isRowSelected(n = this.getEditingRow())) {
            TableCellEditor tableCellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn());
            tableCellEditor.cancelCellEditing();
        }
    }

    public boolean hasScenariosBasedOnExpressions() {
        return this.mTableModel.hasScenariosBasedOnExpressions();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        return this.mTableModel.getMyValueAt(n, n2, true);
    }

    private boolean hasValues(RowData rowData) {
        return !this.mIsGroup && rowData.mScenarioDefinitionInfo.isSpecifyScenarioValuesForRootField();
    }

    class MyTableSorter
    extends TableSorter {
        TCMMultiDimScenariosTableModel mTableModel;

        MyTableSorter(TCMMultiDimScenariosTableModel tCMMultiDimScenariosTableModel, JTableHeader jTableHeader) {
            super((TableModel)((Object)tCMMultiDimScenariosTableModel), jTableHeader);
            this.mTableModel = null;
            this.mTableModel = tCMMultiDimScenariosTableModel;
        }

        @Override
        public boolean canSortColumn(int n) {
            return !this.mTableModel.isValueOrExpressionColumn(n);
        }
    }

    class MYValueExpressionCellRenderer
    extends DefaultTableCellRenderer {
        MYValueExpressionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            RowData rowData = TCMMultiDimScenariosTable.this.mTableModel.getRowDataAt(n);
            if (TCMMultiDimScenariosTable.this.hasValues(rowData) && rowData != null && !rowData.getScenarioDefinitionInfo().areAllScenarioValuesDefined()) {
                this.setText(TCMMultiDimScenariosTable.this.mParentDialog.getResString("IDS_TCM_SCENARIOS_VALUES_MISSING"));
            }
            return this;
        }
    }

    public class TCMMultiDimScenariosTableModel
    extends AbstractListTableModel {
        public static final int SCENARIO_ID_COL = 0;
        private ArrayList<RowData> mRowDatas = new ArrayList();
        ArrayList<String> mTableColNames = new ArrayList();
        private ResourceBundle mResourceBundle;
        private boolean mIsGroup = false;
        ArrayList<String> mDimNames;

        public TCMMultiDimScenariosTableModel(ArrayList<String> arrayList, ResourceBundle resourceBundle, boolean bl) {
            this.setList(this.mRowDatas);
            this.mIsGroup = bl;
            this.mResourceBundle = resourceBundle;
            this.mDimNames = arrayList;
            this.initTableColumnNames();
        }

        private void initTableColumnNames() {
            this.mTableColNames = new ArrayList();
            this.mTableColNames.add(this.mIsGroup ? this.mResourceBundle.getString("IDS_TCM_MULTI_DIM_SCENARIOS_TAB_GROUP_SCENARIOS_TABLE_SCENARIO_ID_PREFIXCOL") : this.mResourceBundle.getString("IDS_TCM_MULTI_DIM_SCENARIOS_TAB_INDIVIDUAL_SCENARIOS_TABLE_SCENARIO_ID_COL"));
            if (this.mIsGroup) {
                this.mTableColNames.add(this.mResourceBundle.getString("IDS_TCM_FORCASTING_METRIC_TABLE_SERIES_COUNT"));
            }
            this.mTableColNames.add(this.mResourceBundle.getString("IDS_TCM_MULTI_DIM_SCENARIOS_TAB_INDIVIDUAL_SCENARIOS_TABLE_ROOT_METRIC_COL"));
            for (String string : this.mDimNames) {
                this.mTableColNames.add(string);
            }
            this.mTableColNames.add(this.mIsGroup ? this.mResourceBundle.getString("IDS_TCM_MULTI_DIM_SCENARIOS_TAB_GROUP_SCENARIOS_TABLE_EXPRESSION_COL") : this.mResourceBundle.getString("IDS_TCM_MULTI_DIM_SCENARIOS_TAB_INDIVIDUAL_SCENARIOS_TABLE_SCENARIO_VALUES_COL"));
        }

        public String getDimNameForColumn(int n) {
            String string = this.isDimValueColumn(n) ? this.getColumnName(n) : null;
            return string;
        }

        public boolean isDimValueColumn(int n) {
            int n2 = this.getRootMetricColumn() + 1;
            int n3 = n2 + this.mDimNames.size() - 1;
            return n >= n2 && n <= n3;
        }

        public boolean isScenarioIDColumn(int n) {
            return 0 == n;
        }

        public int getRootMetricColumn() {
            return this.mIsGroup ? 2 : 1;
        }

        public boolean isRootMetricColumn(int n) {
            return n == this.getRootMetricColumn();
        }

        public boolean isSeriesCountColumn(int n) {
            return this.mIsGroup ? n == 1 : false;
        }

        public boolean isValueOrExpressionColumn(int n) {
            return n == this.getExpressionValueColumn();
        }

        public int getExpressionValueColumn() {
            int n = this.getRootMetricColumn() + this.mDimNames.size() + 1;
            return n;
        }

        public boolean setNewScenarioPeriod(TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            boolean bl = false;
            for (int i = 0; i < this.getRowDatas().size(); ++i) {
                int n = TCMMultiDimScenariosTable.this.mTableSorter.modelIndex(i);
                RowData rowData = this.getRowDataAt(n);
                boolean bl2 = rowData.setNewScenarioPeriod(TCMMultiDimScenariosTable.this.mTCMForecastGatingInfo, scenarioPeriodInfo);
                if (!bl2) continue;
                bl = bl2;
                this.fireTableRowsUpdated(i, i);
            }
            return bl;
        }

        public void reset() {
            this.mRowDatas = new ArrayList();
            this.fireTableDataChanged();
        }

        protected String[] createDefaultColumnNames() {
            return new String[]{""};
        }

        protected Object createDefaultEntry() {
            RowData rowData = new RowData(null);
            return rowData;
        }

        public int getColumnCount() {
            return this.mTableColNames != null ? this.mTableColNames.size() : 0;
        }

        public int getRowCount() {
            return this.mRowDatas != null ? this.mRowDatas.size() : 0;
        }

        public String getColumnName(int n) {
            return this.mTableColNames.get(n);
        }

        public ArrayList<RowData> getRowDatas() {
            return this.mRowDatas;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                if (this.isScenarioIDColumn(n2)) {
                    if (TCMMultiDimScenariosTable.this.isScenarioIDUnique((String)object, n)) {
                        rowData.setScenarioID((String)object);
                    } else {
                        String string = this.mIsGroup ? "IDS_TCM_MULTI_DIM_SCENARIO_DEFINITION_SCENARIO_ID_ALREADY_IN_USE_ERROR_MESSAGE" : "IDS_TCM_SCENARIO_DEFINITION_SCENARIO_ID_ALREADY_IN_USE_ERROR_MESSAGE";
                        TCMUtilities.throwErrorDialog((JDialog)((Object)TCMMultiDimScenariosTable.this.mParentDialog), MessageFormat.format(TCMMultiDimScenariosTable.this.mParentDialog.getResString(string), (String)object));
                    }
                }
                this.fireTableRowsUpdated(n, n);
            }
        }

        public Object getValueAt(int n, int n2) {
            String string = this.getMyValueAt(n, n2, false);
            return string;
        }

        private String getMyValueAt(int n, int n2, boolean bl) {
            String string = "";
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                TCMSelectDimensionValuesTable.RowData rowData2 = rowData.getScenarioDefinitionInfo().getRootTableRowData();
                if (this.isScenarioIDColumn(n2)) {
                    string = "" + rowData.getScenarioID();
                } else if (this.isRootMetricColumn(n2)) {
                    string = rowData2 != null ? rowData2.getVarName() : "";
                } else if (this.isSeriesCountColumn(n2)) {
                    string = rowData2 != null ? "" + rowData2.getSeriesCount() : "";
                } else if (this.isDimValueColumn(n2) && rowData2 != null) {
                    String string2 = this.getDimNameForColumn(n2);
                    String string3 = rowData2.getDimValuesAsStringForDimName(string2);
                    if (!TCMMultiDimScenariosTable.this.mIsGroup) {
                        string = string3 != null ? string3 : "";
                    } else {
                        TCMSelectDimensionValuesInfo tCMSelectDimensionValuesInfo = rowData2.getSelectDimensionValuesInfoForDimName(string2);
                        StringBuffer stringBuffer = new StringBuffer();
                        if (tCMSelectDimensionValuesInfo == null || tCMSelectDimensionValuesInfo.isSelectAllValues()) {
                            String string4 = TCMMultiDimScenariosTable.this.mParentDialog.getResString("IDS_TCM_MULTI_DIM_SCENARIO_DEFINITION_TARGET_ALL_VALUES");
                            stringBuffer.append(string4);
                        } else if (bl) {
                            stringBuffer.append(string3);
                        } else {
                            ArrayList<String> arrayList = tCMSelectDimensionValuesInfo.getSelectedListDimValues();
                            if (arrayList != null && arrayList.size() > 0) {
                                stringBuffer.append((Object)arrayList.get(0));
                                if (arrayList.size() > 1) {
                                    stringBuffer.append("...");
                                }
                            }
                        }
                        string = stringBuffer.toString();
                    }
                } else if (this.isValueOrExpressionColumn(n2)) {
                    string = rowData.getScenarioValuesOrExpressionText() != null ? rowData.getScenarioValuesOrExpressionText() : "";
                }
            }
            return string;
        }

        public void remove(int[] nArray) {
            int n = this.valueList.size();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (this.remove(nArray[i])) continue;
                return;
            }
            this.fireTableDataChanged();
        }

        private void readDisplayPrefs() {
        }

        public String copyRow(int n) {
            String string = null;
            try {
                int n2 = TCMMultiDimScenariosTable.this.mTableSorter.modelIndex(n);
                RowData rowData = (RowData)TCMMultiDimScenariosTable.this.mTableModel.getRowDataAt(n2).clone();
                String string2 = rowData.getScenarioID();
                string = this.createUniqueScenarioIDName(string2);
                rowData.setScenarioID(string);
                this.mRowDatas.add(rowData);
                this.fireTableRowsInserted(this.mRowDatas.size() - 1, this.mRowDatas.size() - 1);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            return string;
        }

        protected int findRowByScenarioIDName(String string) {
            int n = -1;
            for (int i = 0; i < TCMMultiDimScenariosTable.this.mTableModel.getRowDatas().size(); ++i) {
                String string2 = (String)TCMMultiDimScenariosTable.this.mTableSorter.getValueAt(i, 0);
                if (!string2.trim().equals(string.trim())) continue;
                n = i;
                break;
            }
            return n;
        }

        private boolean isUniqueScenarioIDName(String string, int n) {
            boolean bl = true;
            String string2 = n == 0 ? string : string + "_" + n;
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                RowData rowData = this.mRowDatas.get(i);
                if (!rowData.getScenarioID().equalsIgnoreCase(string2)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        private String createUniqueScenarioIDName(String string) {
            String string2 = string;
            int n = 0;
            while (!this.isUniqueScenarioIDName(string2, n)) {
                ++n;
            }
            return n == 0 ? string : string + "_" + n;
        }

        public ArrayList<String> getScenarioIDList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                RowData rowData = this.mRowDatas.get(i);
                arrayList.add(this.mRowDatas.get(i).getScenarioID());
            }
            return arrayList;
        }

        public void generateUniqueSyntaxExpressionIDs(ArrayList<String> arrayList) {
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                RowData rowData = this.mRowDatas.get(i);
                String string = rowData.getScenarioID();
                if (arrayList != null && TCMUtilities.findString(arrayList, string, false) != -1) {
                    String string2 = this.createUniqueSyntaxExpressionID(arrayList, string);
                    rowData.setSyntaxScenarioID(string2);
                    continue;
                }
                rowData.setSyntaxScenarioID(TCMUtilities.replaceSpacesWithUndeline(string));
            }
        }

        private String createUniqueSyntaxExpressionID(ArrayList<String> arrayList, String string) {
            String string2 = string;
            int n = 0;
            while (!this.isUniqueExpressionIDName(arrayList, string2, n)) {
                ++n;
            }
            return n == 0 ? string : string + "_" + n;
        }

        private boolean isUniqueExpressionIDName(ArrayList<String> arrayList, String string, int n) {
            String string2;
            boolean bl = true;
            String string3 = string2 = n == 0 ? string : string + "_" + n;
            if (TCMUtilities.findString(arrayList, string2, false) != -1) {
                bl = false;
            } else {
                for (int i = 0; i < this.mRowDatas.size(); ++i) {
                    RowData rowData = this.mRowDatas.get(i);
                    if (!rowData.getScenarioID().equalsIgnoreCase(string2)) continue;
                    bl = false;
                    break;
                }
            }
            return bl;
        }

        private RowData getRowDataAt(int n) {
            RowData rowData = null;
            if (this.mRowDatas != null && n >= 0 && n < this.mRowDatas.size()) {
                rowData = this.mRowDatas.get(n);
            }
            return rowData;
        }

        public void addScenario(TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo) {
            RowData rowData = new RowData(multiDimScenarioDefinitionInfo);
            this.mRowDatas.add(rowData);
            this.fireTableRowsInserted(this.mRowDatas.size() - 1, this.mRowDatas.size() - 1);
        }

        public boolean hasScenariosBasedOnExpressions() {
            boolean bl = false;
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                String string;
                RowData rowData = this.mRowDatas.get(i);
                if (TCMMultiDimScenariosTable.this.hasValues(rowData) || (string = rowData.getScenarioDefinitionInfo().getExpression()) == null || string.length() <= 0) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public ArrayList<Integer> getDimensionColumns() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!this.isDimValueColumn(i)) continue;
                arrayList.add(i);
            }
            return arrayList;
        }
    }

    public class RowData
    implements Cloneable {
        TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo mScenarioDefinitionInfo;
        String mSyntaxScenarioID = null;
        String mExpressionID = null;

        private RowData(TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo) {
            this.mScenarioDefinitionInfo = multiDimScenarioDefinitionInfo;
        }

        public String getScenarioID() {
            return this.mScenarioDefinitionInfo != null ? this.mScenarioDefinitionInfo.getScenarioID() : "";
        }

        public String getExpressionID() {
            if (this.mExpressionID == null) {
                this.mExpressionID = TCMUtilities.getExpressionID();
            }
            return this.mExpressionID;
        }

        public String getSyntaxScenarioID() {
            return this.mSyntaxScenarioID;
        }

        public void setSyntaxScenarioID(String string) {
            this.mSyntaxScenarioID = string;
        }

        public void setScenarioID(String string) {
            this.mScenarioDefinitionInfo.setScenarioID(string);
        }

        public String getScenarioValuesOrExpressionText() {
            String string = "";
            if (this.mScenarioDefinitionInfo != null) {
                if (this.mScenarioDefinitionInfo.isSpecifyScenarioValuesForRootField() && this.mScenarioDefinitionInfo.getScenarioValuesText() != null) {
                    string = this.mScenarioDefinitionInfo.getScenarioValuesText();
                } else if (this.mScenarioDefinitionInfo.getExpression() != null) {
                    string = this.mScenarioDefinitionInfo.getExpression();
                }
            }
            return string;
        }

        protected Object clone() throws CloneNotSupportedException {
            RowData rowData = (RowData)super.clone();
            TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo = (TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo)this.mScenarioDefinitionInfo.clone();
            rowData.setScenarioDefinitionInfoForRow(multiDimScenarioDefinitionInfo);
            return rowData;
        }

        public TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo getScenarioDefinitionInfo() {
            return this.mScenarioDefinitionInfo;
        }

        public void setScenarioDefinitionInfoForRow(TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo) {
            this.mScenarioDefinitionInfo = multiDimScenarioDefinitionInfo;
        }

        public boolean setScenarioPeriod(TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            return this.mScenarioDefinitionInfo.setScenarioPeriod(scenarioPeriodInfo);
        }

        public boolean setNewScenarioPeriod(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            return this.mScenarioDefinitionInfo.setNewScenarioPeriod(tCMForecastGatingInfo, scenarioPeriodInfo);
        }
    }
}

