/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.TableSorter;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioDefinitionDialog;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioPeriodDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.controls.row_management_table.AbstractListTableModel;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class TCMDefineScenariosTable
extends JTable {
    public static final int ID_COL = 0;
    public static final int ROOT_FIELD_COL = 1;
    public static final int VALUE_COL = 2;
    TCMForecastGatingInfo mTCMForecastGatingInfo;
    private BaseTabbedDialog mParentDialog;
    private ResourceBundle mResourceBundle;
    private String mImageFilePath = TCMResBundle.getImageFolder();
    private TCMDefineScenariosTableModel mTableModel;
    private MyTableSorter mTableSorter;

    public TCMDefineScenariosTable(BaseTabbedDialog baseTabbedDialog, TCMForecastGatingInfo tCMForecastGatingInfo, ResourceBundle resourceBundle) {
        this.mTableModel = new TCMDefineScenariosTableModel(resourceBundle);
        this.mTableSorter = new MyTableSorter((TableModel)((Object)this.mTableModel), this.getTableHeader());
        this.setModel(this.mTableSorter);
        this.mParentDialog = baseTabbedDialog;
        this.mResourceBundle = resourceBundle;
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.getColumnModel().getColumn(this.mTableModel.getExpressionValueColumn()).setCellRenderer(new MYValueExpressionCellRenderer());
    }

    public void setModel(TableSorter tableSorter) {
        super.setModel(tableSorter);
    }

    public void reset() {
        this.mTableModel.reset();
    }

    public boolean doValidateTable() {
        String string = null;
        TCMUtilities.stopTableEditing(this);
        ArrayList<RowData> arrayList = this.mTableModel.getRowDatas();
        for (int i = 0; i < arrayList.size(); ++i) {
            TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo;
            boolean bl;
            RowData rowData = arrayList.get(i);
            if (rowData.getScenarioID() == null || rowData.getScenarioID().trim().length() == 0) {
                string = this.mParentDialog.getResString("IDS_TCM_SCENARIO_DEFINITION_SCENARIO_ID_IS_REQUIRED_ERROR_MESSAGE");
                this.setRowSelectionInterval(i, i);
                break;
            }
            if (string != null || !this.hasValues(rowData) || (bl = (scenarioDefinitionInfo = rowData.getScenarioDefinitionInfo()).areAllScenarioValuesDefined())) continue;
            string = this.mParentDialog.getResString("IDS_TCM_SCENARIO_DEFINITION_SCENARIO_VALUES_MUST_BE_SPECIFIED_ERROR_MESSAGE");
            break;
        }
        if (string != null) {
            TCMUtilities.throwErrorDialog((JDialog)((Object)this.mParentDialog), string);
        }
        return string == null;
    }

    private boolean hasValues(RowData rowData) {
        return rowData.mScenarioDefinitionInfo.isSpecifyScenarioValuesForRootField();
    }

    public int findRowByScenarioIDName(String string) {
        return this.mTableModel.findRowByScenarioIDName(string);
    }

    protected void initSelectionListener() {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().addListSelectionListener(this);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.processControlStates();
        this.repaint();
    }

    public void processControlStates() {
        int[] nArray = this.getSelectedRows();
        boolean bl = nArray.length > 0;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (!super.editCellAt(n, n2, eventObject)) {
            return false;
        }
        Component component = this.getEditorComponent();
        component.requestFocusInWindow();
        if (component.getClass() == JComboBox.class) {
            final ComboBoxEditor comboBoxEditor = ((JComboBox)component).getEditor();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)comboBoxEditor.getEditorComponent()).selectAll();
                }
            });
        }
        return true;
    }

    public Color getForegroundColor(Component component, boolean bl) {
        Color color = component.getForeground();
        if (bl) {
            if (component instanceof JTable) {
                color = ((JTable)component).getSelectionForeground();
            } else if (component instanceof JList) {
                color = ((JList)component).getSelectionForeground();
            }
        }
        return color;
    }

    public Color getBackgroundColor(Component component, int n, boolean bl) {
        Color color = component.getBackground();
        if (bl) {
            if (component instanceof JTable) {
                color = ((JTable)component).getSelectionBackground();
            } else if (component instanceof JList) {
                color = ((JList)component).getSelectionBackground();
            }
        }
        return color;
    }

    public URL getResImageURL(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return UIToolResUtil.getImageResourceFullPath((String)(this.mImageFilePath + string2));
    }

    public String copyRow(int n) {
        return this.mTableModel.copyRow(n);
    }

    public void addScenario(TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo) {
        this.mTableModel.addScenario(scenarioDefinitionInfo);
    }

    public void selectRowsByScenarioIDNames(ArrayList<String> arrayList) {
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            int n = this.mTableModel.findRowByScenarioIDName(string);
            if (i == -1) continue;
            this.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public TCMScenarioDefinitionDialog.ScenarioDefinitionInfo getScenarioDefinitionInfoForRow(int n) {
        int n2 = this.mTableSorter.modelIndex(n);
        return this.mTableModel.getRowDataAt(n2) != null ? this.mTableModel.getRowDataAt(n2).getScenarioDefinitionInfo() : null;
    }

    public void editScenario(int n, TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo) {
        int n2 = this.mTableSorter.modelIndex(n);
        RowData rowData = this.mTableModel.getRowDataAt(n2);
        if (rowData != null) {
            rowData.setScenarioDefinitionInfoForRow(scenarioDefinitionInfo);
        }
        this.mTableModel.fireTableRowsUpdated(n, n);
    }

    public boolean setNewScenarioPeriod(TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
        return this.mTableModel.setNewScenarioPeriod(scenarioPeriodInfo);
    }

    public String getScenarioSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        for (int i = 0; i < this.mTableModel.getRowDatas().size(); ++i) {
            RowData rowData = this.mTableModel.getRowDatas().get(i);
            boolean bl = rowData.getScenarioDefinitionInfo().isSpecifyScenarioValuesForRootField();
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SCENARIO"));
            String string = (String)this.mTableModel.getValueAt(i, 0);
            if (!bl) {
                string = TCMUtilities.replaceSpacesWithUndeline(string);
            }
            stringBuffer.append(MessageFormat.format(" ID={0}", string != null ? SyntaxUtil.wrapTextSingleQuotes(string) : ""));
            String string2 = rowData.getScenarioDefinitionInfo().getRootFieldVar().getName();
            String string3 = rowData.getScenarioDefinitionInfo().getExpressionID();
            String string4 = rowData.getScenarioDefinitionInfo().isSpecifyScenarioValuesForRootField() ? (String)this.mTableModel.getValueAt(i, 2) : string3;
            String string5 = rowData.getScenarioDefinitionInfo().isSpecifyScenarioValuesForRootField() ? " VALUES=ACTUAL({0})" : " VALUES=EXPRESSION({0})";
            stringBuffer.append(MessageFormat.format(string5, string != null ? string4 : ""));
            stringBuffer.append(MessageFormat.format(" ROOTFIELD={0}", string2 != null ? string2 : ""));
            if (rowData.getScenarioDefinitionInfo().isAffectedTargetsSelected()) {
                stringBuffer.append(MessageFormat.format(" EFFECTS=TARGETLIST({0})", string));
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/TARGETLIST"));
                stringBuffer.append(MessageFormat.format(" LISTID={0}", string));
                stringBuffer.append(MessageFormat.format(" FIELDS=", string));
                ISpssVariable[] iSpssVariableArray = rowData.getScenarioDefinitionInfo().getAffectedTargetsVars();
                for (int j = 0; j < iSpssVariableArray.length; ++j) {
                    ISpssVariable iSpssVariable = iSpssVariableArray[j];
                    stringBuffer.append(iSpssVariable.getName());
                    if (j + 1 >= iSpssVariableArray.length) continue;
                    stringBuffer.append(" ");
                }
                continue;
            }
            stringBuffer.append(" EFFECTS=AUTOMATIC");
        }
        return stringBuffer.toString();
    }

    public String getComputeSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        for (int i = 0; i < this.mTableModel.getRowDatas().size(); ++i) {
            String string;
            RowData rowData = this.mTableModel.getRowDatas().get(i);
            String string2 = rowData.getScenarioDefinitionInfo().getRootFieldVar().getName();
            String string3 = rowData.getScenarioDefinitionInfo().getExpression();
            String string4 = TCMUtilities.replaceSpacesWithUndeline(rowData.getScenarioID());
            String string5 = rowData.getScenarioDefinitionInfo().getExpressionID();
            if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0 || (string = MessageFormat.format("COMPUTE {0}={1}.", string5, string3)) == null) continue;
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void stopTableEditing() {
        TCMUtilities.stopTableEditing(this);
    }

    public void deleteSelectedRows() {
        this.stopTableEditing();
        this.cancelEditingInSelectedRows();
        int[] nArray = this.getSelectedRows();
        ArrayList<RowData> arrayList = this.mTableModel.getRowDatas();
        if (arrayList != null && arrayList.size() > 0) {
            int n = arrayList.size();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = this.mTableSorter.modelIndex(nArray[i]);
                if (arrayList.remove(n2) == null) continue;
                this.mTableModel.fireTableDataChanged();
                ListSelectionModel listSelectionModel = this.getSelectionModel();
                listSelectionModel.setSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
            }
        }
    }

    protected boolean canRemove() {
        return this.canRemove(this.getSelectedRows());
    }

    protected boolean canRemove(int[] nArray) {
        return nArray.length > 0 && this.getRowCount() > 0;
    }

    private void cancelEditingInSelectedRows() {
        int n;
        if (this.isEditing() && this.isRowSelected(n = this.getEditingRow())) {
            TableCellEditor tableCellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn());
            tableCellEditor.cancelCellEditing();
        }
    }

    public boolean hasScenariosBasedOnExpressions() {
        return this.mTableModel.hasScenariosBasedOnExpressions();
    }

    public boolean isScenarioIDUnique(String string, int n) {
        int n2 = this.mTableModel.findRowByScenarioIDName(string);
        return n2 < 0 || n != -1 && n2 == n;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        return (String)this.mTableModel.getValueAt(n, n2);
    }

    class MYValueExpressionCellRenderer
    extends DefaultTableCellRenderer {
        MYValueExpressionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            RowData rowData = TCMDefineScenariosTable.this.mTableModel.getRowDataAt(n);
            if (TCMDefineScenariosTable.this.hasValues(rowData) && rowData != null && !rowData.getScenarioDefinitionInfo().areAllScenarioValuesDefined()) {
                this.setText(TCMDefineScenariosTable.this.mParentDialog.getResString("IDS_TCM_SCENARIOS_VALUES_MISSING"));
            }
            return this;
        }
    }

    class MyTableSorter
    extends TableSorter {
        MyTableSorter(TableModel tableModel, JTableHeader jTableHeader) {
            super(tableModel, jTableHeader);
        }

        @Override
        public boolean canSortColumn(int n) {
            return n != 2 ? super.canSortColumn(n) : false;
        }
    }

    public class TCMDefineScenariosTableModel
    extends AbstractListTableModel {
        private ArrayList<RowData> mRowDatas = new ArrayList();
        ArrayList<String> mTableColNames = new ArrayList();
        private ResourceBundle mResourceBundle;

        public TCMDefineScenariosTableModel(ResourceBundle resourceBundle) {
            this.setList(this.mRowDatas);
            this.mResourceBundle = resourceBundle;
            this.initTableColumnNames();
        }

        private void initTableColumnNames() {
            this.mTableColNames = new ArrayList();
            this.mTableColNames.add(this.mResourceBundle.getString("IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_SCENARIO_ID_COL"));
            this.mTableColNames.add(this.mResourceBundle.getString("IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_ROOT_FIELD_COL"));
            this.mTableColNames.add(this.mResourceBundle.getString("IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_SCENARIO_VALUES_COL"));
        }

        public boolean setNewScenarioPeriod(TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            boolean bl = false;
            for (int i = 0; i < this.getRowDatas().size(); ++i) {
                int n = TCMDefineScenariosTable.this.mTableSorter.modelIndex(i);
                RowData rowData = this.getRowDataAt(n);
                boolean bl2 = rowData.setNewScenarioPeriod(TCMDefineScenariosTable.this.mTCMForecastGatingInfo, scenarioPeriodInfo);
                if (!bl2) continue;
                bl = bl2;
                this.fireTableRowsUpdated(i, i);
            }
            return bl;
        }

        public void reset() {
            this.mRowDatas = new ArrayList();
            this.fireTableDataChanged();
        }

        protected String[] createDefaultColumnNames() {
            return new String[]{""};
        }

        protected Object createDefaultEntry() {
            RowData rowData = new RowData(null);
            return rowData;
        }

        public int getColumnCount() {
            return this.mTableColNames != null ? this.mTableColNames.size() : 0;
        }

        public int getRowCount() {
            return this.mRowDatas != null ? this.mRowDatas.size() : 0;
        }

        public String getColumnName(int n) {
            return this.mTableColNames.get(n);
        }

        public ArrayList<RowData> getRowDatas() {
            return this.mRowDatas;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                if (n2 == 0) {
                    if (TCMDefineScenariosTable.this.isScenarioIDUnique((String)object, n)) {
                        rowData.setScenarioID((String)object);
                    } else {
                        String string = "IDS_TCM_SCENARIO_DEFINITION_SCENARIO_ID_ALREADY_IN_USE_ERROR_MESSAGE";
                        TCMUtilities.throwErrorDialog((JDialog)((Object)TCMDefineScenariosTable.this.mParentDialog), MessageFormat.format(TCMDefineScenariosTable.this.mParentDialog.getResString(string), (String)object));
                    }
                }
                this.fireTableRowsUpdated(n, n);
            }
        }

        public Object getValueAt(int n, int n2) {
            String string = "";
            RowData rowData = this.getRowDataAt(n);
            if (rowData != null) {
                if (n2 == 0) {
                    string = rowData.getScenarioID();
                } else if (n2 == 1) {
                    string = rowData.getRootFieldName() != null ? rowData.getRootFieldName() : "";
                } else if (n2 == 2) {
                    string = rowData.getScenarioValues() != null ? rowData.getScenarioValues() : "";
                }
            }
            return string;
        }

        public void remove(int[] nArray) {
            int n = this.valueList.size();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (this.remove(nArray[i])) continue;
                return;
            }
            this.fireTableDataChanged();
        }

        private void readDisplayPrefs() {
        }

        public String copyRow(int n) {
            String string = null;
            try {
                int n2 = TCMDefineScenariosTable.this.mTableSorter.modelIndex(n);
                RowData rowData = (RowData)TCMDefineScenariosTable.this.mTableModel.getRowDataAt(n2).clone();
                String string2 = rowData.getScenarioID();
                string = this.createUniqueScenarioIDName(string2);
                rowData.setScenarioID(string);
                this.mRowDatas.add(rowData);
                this.fireTableRowsInserted(this.mRowDatas.size() - 1, this.mRowDatas.size() - 1);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            return string;
        }

        protected int findRowByScenarioIDName(String string) {
            int n = -1;
            for (int i = 0; i < TCMDefineScenariosTable.this.mTableModel.getRowDatas().size(); ++i) {
                String string2 = (String)TCMDefineScenariosTable.this.mTableSorter.getValueAt(i, 0);
                if (!string2.equals(string)) continue;
                n = i;
                break;
            }
            return n;
        }

        private boolean isUniqueScenarioIDName(String string, int n) {
            boolean bl = true;
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                String string2;
                RowData rowData = this.mRowDatas.get(i);
                String string3 = string2 = n == 0 ? string : string + "_" + n;
                if (!rowData.getScenarioID().equalsIgnoreCase(string2)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        private String createUniqueScenarioIDName(String string) {
            String string2 = string;
            int n = 0;
            while (!this.isUniqueScenarioIDName(string2, n)) {
                ++n;
            }
            return n == 0 ? string : string + "_" + n;
        }

        private RowData getRowDataAt(int n) {
            RowData rowData = null;
            if (this.mRowDatas != null && n >= 0 && n < this.mRowDatas.size()) {
                rowData = this.mRowDatas.get(n);
            }
            return rowData;
        }

        public void addScenario(TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo) {
            RowData rowData = new RowData(scenarioDefinitionInfo);
            this.mRowDatas.add(rowData);
            this.fireTableRowsInserted(this.mRowDatas.size() - 1, this.mRowDatas.size() - 1);
        }

        public boolean hasScenariosBasedOnExpressions() {
            boolean bl = false;
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                String string;
                RowData rowData = this.mRowDatas.get(i);
                if (rowData.getScenarioDefinitionInfo().isSpecifyScenarioValuesForRootField() || (string = rowData.getScenarioDefinitionInfo().getExpression()) == null || string.length() <= 0) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public int getExpressionValueColumn() {
            return 2;
        }
    }

    public class RowData
    implements Cloneable {
        TCMScenarioDefinitionDialog.ScenarioDefinitionInfo mScenarioDefinitionInfo;

        private RowData(TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo) {
            this.mScenarioDefinitionInfo = scenarioDefinitionInfo;
        }

        public String getScenarioID() {
            return this.mScenarioDefinitionInfo != null ? this.mScenarioDefinitionInfo.getScenarioID() : "";
        }

        public void setScenarioID(String string) {
            this.mScenarioDefinitionInfo.setScenarioID(string);
        }

        public String getRootFieldName() {
            return this.mScenarioDefinitionInfo != null && this.mScenarioDefinitionInfo.getRootFieldVar() != null ? this.mScenarioDefinitionInfo.getRootFieldVar().getName() : "";
        }

        public String getScenarioValues() {
            String string = "";
            if (this.mScenarioDefinitionInfo != null) {
                if (this.mScenarioDefinitionInfo.isSpecifyScenarioValuesForRootField() && this.mScenarioDefinitionInfo.getScenarioValuesText() != null) {
                    string = this.mScenarioDefinitionInfo.getScenarioValuesText();
                } else if (this.mScenarioDefinitionInfo.getExpression() != null) {
                    string = this.mScenarioDefinitionInfo.getExpression();
                }
            }
            return string;
        }

        protected Object clone() throws CloneNotSupportedException {
            RowData rowData = (RowData)super.clone();
            TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo = (TCMScenarioDefinitionDialog.ScenarioDefinitionInfo)this.mScenarioDefinitionInfo.clone();
            rowData.setScenarioDefinitionInfoForRow(scenarioDefinitionInfo);
            return rowData;
        }

        public TCMScenarioDefinitionDialog.ScenarioDefinitionInfo getScenarioDefinitionInfo() {
            return this.mScenarioDefinitionInfo;
        }

        public void setScenarioDefinitionInfoForRow(TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo) {
            this.mScenarioDefinitionInfo = scenarioDefinitionInfo;
        }

        public boolean setScenarioPeriod(TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            return this.mScenarioDefinitionInfo.setScenarioPeriod(scenarioPeriodInfo);
        }

        public boolean setNewScenarioPeriod(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            return this.mScenarioDefinitionInfo.setNewScenarioPeriod(tCMForecastGatingInfo, scenarioPeriodInfo);
        }
    }
}

