/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioPeriodDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import com.spss.uitools.res.UIToolResUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SpecifyScenarioValuesDateTimeTableModel
extends AbstractTableModel {
    public static final int DATE_COL_NO_INTERVAL = 0;
    public static final int SCENARIO_VALUE_COL_NO_INTERVAL = 1;
    public static final int ROOT_FIELD_COL_NO_INTERVAL = 2;
    private SpecifyScenarioValuesDateTimeTableInfo mSpecifyScenarioValuesDateTimeTableInfo;
    protected Long mDefaultStartTime = null;
    protected Long mDefaultEndTime = null;
    boolean mIsEditable = true;
    ResourceBundle mResourceBundle;

    public SpecifyScenarioValuesDateTimeTableModel(ResourceBundle resourceBundle, TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
        this.mResourceBundle = resourceBundle;
        this.initSpecifyScenarioValuesDateTimeTableInfo(tCMForecastGatingInfo, scenarioPeriodInfo, bl);
        this.saveDefaultDateTimeInfo(this.getSpecifyScenarioValuesDateTimeTableInfo());
    }

    public SpecifyScenarioValuesDateTimeTableModel(ResourceBundle resourceBundle, SpecifyScenarioValuesDateTimeTableInfo specifyScenarioValuesDateTimeTableInfo) {
        this.mResourceBundle = resourceBundle;
        this.saveDateTimeTableInfo(specifyScenarioValuesDateTimeTableInfo);
        this.saveDefaultDateTimeInfo(this.getSpecifyScenarioValuesDateTimeTableInfo());
    }

    protected void initSpecifyScenarioValuesDateTimeTableInfo(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
        SpecifyScenarioValuesDateTimeTableInfo specifyScenarioValuesDateTimeTableInfo = new SpecifyScenarioValuesDateTimeTableInfo(tCMForecastGatingInfo, scenarioPeriodInfo, bl);
        this.saveDateTimeTableInfo(specifyScenarioValuesDateTimeTableInfo);
    }

    protected void saveDateTimeTableInfo(SpecifyScenarioValuesDateTimeTableInfo specifyScenarioValuesDateTimeTableInfo) {
        this.mSpecifyScenarioValuesDateTimeTableInfo = specifyScenarioValuesDateTimeTableInfo;
    }

    protected void saveDefaultDateTimeInfo(SpecifyScenarioValuesDateTimeTableInfo specifyScenarioValuesDateTimeTableInfo) {
        this.mDefaultStartTime = specifyScenarioValuesDateTimeTableInfo.getStartEstimationTime();
        this.mDefaultEndTime = specifyScenarioValuesDateTimeTableInfo.getEndEstimationTime();
    }

    public void setEditable(boolean bl) {
        this.mIsEditable = bl;
    }

    @Override
    public int getRowCount() {
        return this.mSpecifyScenarioValuesDateTimeTableInfo.getRowDatas().size();
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        if (this.getIntervalColIndex() == n) {
            string = this.getLabel("IDS_TCM_SCENARIO_DEFINITION_INTERVAL_COL");
        } else if (n == this.getDateTimeTableColIndex()) {
            SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType = this.getSpecifyScenarioValuesDateTimeTableInfo().getSimpleDateTimeType();
            string = simpleDateTimeType == SpssDateFormatHelper.SimpleDateTimeType.DATE ? this.getLabel("IDS_TCM_FORCASTING_DATE_LABEL") : (simpleDateTimeType == SpssDateFormatHelper.SimpleDateTimeType.TIME ? this.getLabel("IDS_TCM_FORCASTING_TIME_LABEL") : (simpleDateTimeType == SpssDateFormatHelper.SimpleDateTimeType.DATETIME ? this.getLabel("IDS_TCM_FORCASTING_DATE_AND_TIME_LABEL") : "error unknown date_time type"));
        } else if (n == this.getScenarioValueTableColIndex()) {
            string = this.getLabel("IDS_TCM_SCENARIO_DEFINITION_SCENARIO_VALUE_COL");
        } else if (n == this.getRootFieldTableColIndex()) {
            string = this.mSpecifyScenarioValuesDateTimeTableInfo.isRootField() ? this.getLabel("IDS_TCM_SCENARIO_DEFINITION_ROOT_FIELD_VALUE_COL") : this.getLabel("IDS_TCM_MULTI_DIM_SCENARIO_DEFINITION_ROOT_SERIES_VALUE_COL");
        }
        return string;
    }

    private String getLabel(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return string2 == null ? "" : string2;
    }

    @Override
    public int getColumnCount() {
        return this.getSpecifyScenarioValuesDateTimeTableInfo().hasIntervalColumn() ? 4 : 3;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    public SpecifyScenarioValuesDateTimeTableInfo getSpecifyScenarioValuesDateTimeTableInfo() {
        return this.mSpecifyScenarioValuesDateTimeTableInfo;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        ArrayList<SpecifyScenarioValuesDateTimeTableInfo.RowData> arrayList = this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas();
        if (n2 == this.getIntervalColIndex()) {
            object = arrayList.get(n).getInterval();
        } else if (n2 == this.getDateTimeTableColIndex()) {
            object = arrayList.get(n).getDate();
        } else if (n2 == this.getScenarioValueTableColIndex()) {
            object = arrayList.get(n).getScenarioValue();
        } else if (n2 == this.getRootFieldTableColIndex()) {
            object = arrayList.get(n).getRootFieldValue();
        }
        object = object != null ? object : "";
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ArrayList<SpecifyScenarioValuesDateTimeTableInfo.RowData> arrayList = this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas();
        if (n2 == this.getScenarioValueTableColIndex() && object instanceof Double) {
            arrayList.get(n).setScenarioValue((Double)object);
        }
    }

    public String formatDateValue(Date date) {
        SimpleDateFormat simpleDateFormat = this.getDateTimeFormatter();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMC"));
        return simpleDateFormat.format(date);
    }

    public String formatDateValueToISO8601(Date date, SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType) {
        SimpleDateFormat simpleDateFormat = TCMUtilities.getISO8601DateTimeFormatter(simpleDateTimeType);
        return simpleDateFormat.format(date);
    }

    public SimpleDateFormat getDateTimeFormatter() {
        String string = this.getSpecifyScenarioValuesDateTimeTableInfo().getDateTimePattern();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat;
    }

    public String getUserExampleDateTimePattern() {
        return this.getSpecifyScenarioValuesDateTimeTableInfo().getDefaultDateTimePattern();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = this.getSpecifyScenarioValuesDateTimeTableInfo().hasIntervalColumn();
        int n3 = bl ? n2 - 1 : n2;
        return n3 == 1;
    }

    private Long getLongValue(Object object) {
        long l = 1L;
        if (object instanceof String) {
            l = Long.parseLong((String)object);
        } else if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Float) {
            l = ((Float)object).longValue();
        } else if (object instanceof Double) {
            l = ((Double)object).longValue();
        }
        return l > 1L ? l : 1L;
    }

    public void reset() {
        this.getSpecifyScenarioValuesDateTimeTableInfo().setStartEstimationTime(this.mDefaultStartTime);
        this.getSpecifyScenarioValuesDateTimeTableInfo().setEndEstimationTime(this.mDefaultEndTime);
        this.getSpecifyScenarioValuesDateTimeTableInfo().reset();
        this.fireTableDataChanged();
    }

    public int getIntervalColIndex() {
        boolean bl = this.getSpecifyScenarioValuesDateTimeTableInfo().hasIntervalColumn();
        return bl ? 0 : -1;
    }

    public int getDateTimeTableColIndex() {
        boolean bl = this.getSpecifyScenarioValuesDateTimeTableInfo().hasIntervalColumn();
        return bl ? 1 : 0;
    }

    public int getScenarioValueTableColIndex() {
        boolean bl = this.getSpecifyScenarioValuesDateTimeTableInfo().hasIntervalColumn();
        return bl ? 2 : 1;
    }

    public int getRootFieldTableColIndex() {
        boolean bl = this.getSpecifyScenarioValuesDateTimeTableInfo().hasIntervalColumn();
        return bl ? 3 : 2;
    }

    public boolean isRowTimeWithinEstimationPeriod(int n) {
        return this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas().get(n).isWithinEstimationPeriod();
    }

    public boolean hasReadIntervals() {
        return this.hasReadForecastIntervals(true);
    }

    public boolean hasForecastIntervals() {
        return this.hasReadForecastIntervals(false);
    }

    protected boolean hasReadForecastIntervals(boolean bl) {
        boolean bl2 = false;
        ArrayList<SpecifyScenarioValuesDateTimeTableInfo.RowData> arrayList = this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas();
        for (int i = 0; i < arrayList.size(); ++i) {
            SpecifyScenarioValuesDateTimeTableInfo.RowData rowData = arrayList.get(i);
            if ((!bl || !rowData.isWithinEstimationPeriod()) && (bl || rowData.isWithinEstimationPeriod())) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    private static Long incrementDateTime(Long l, String string) {
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
        calendar.setTime(date);
        if (string.equals("YEAR")) {
            calendar.add(1, 1);
        } else if (string.equals("MONTH")) {
            calendar.add(2, 1);
        } else if (string.equals("DAY")) {
            calendar.add(6, 1);
        } else if (string.equals("HOUR")) {
            calendar.add(10, 1);
        } else if (string.equals("MINUTE")) {
            calendar.add(12, 1);
        } else if (string.equals("SECONDS")) {
            calendar.add(13, 1);
        } else if (string.equals("QUARTERS")) {
            calendar.add(1, 3);
        } else if (string.equals("WEEK")) {
            calendar.add(4, 1);
        }
        return calendar.getTime().getTime();
    }

    public static ArrayList<Long> createForecastTimeIntervals(TCMForecastGatingInfo tCMForecastGatingInfo, int n, int n2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l = tCMForecastGatingInfo.getDateTimeInfo().getEndTime();
        for (int i = 1; i <= n2; ++i) {
            l = SpecifyScenarioValuesDateTimeTableModel.incrementDateTime(l, tCMForecastGatingInfo.getOutputTimeInterval());
            if (i < n || i > n2) continue;
            arrayList.add(l);
        }
        return arrayList;
    }

    public ISpssVariable getActiveVariable() {
        return this.mSpecifyScenarioValuesDateTimeTableInfo.getActiveVariable();
    }

    public void setActiveVariable(ISpssVariable iSpssVariable) {
        this.mSpecifyScenarioValuesDateTimeTableInfo.setActiveVariable(iSpssVariable);
    }

    public Long getModelStartTime() {
        ArrayList<SpecifyScenarioValuesDateTimeTableInfo.RowData> arrayList = this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas();
        return arrayList.size() >= 1 ? arrayList.get(0).getDate() : null;
    }

    public Long getModelEndTime() {
        ArrayList<SpecifyScenarioValuesDateTimeTableInfo.RowData> arrayList = this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas();
        return arrayList.size() >= 1 ? arrayList.get(arrayList.size() - 1).getDate() : null;
    }

    public String getModelStartInterval() {
        ArrayList<SpecifyScenarioValuesDateTimeTableInfo.RowData> arrayList = this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas();
        return arrayList.size() >= 1 ? "" + arrayList.get(0).getInterval() : null;
    }

    public String getModelEndInterval() {
        ArrayList<SpecifyScenarioValuesDateTimeTableInfo.RowData> arrayList = this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas();
        return arrayList.size() >= 1 ? "" + arrayList.get(arrayList.size() - 1).getInterval() : null;
    }

    public void setRootFieldValue(Vector<Double> vector, Vector<Double> vector2) {
        Object object;
        int n;
        ArrayList<SpecifyScenarioValuesDateTimeTableInfo.RowData> arrayList = this.getSpecifyScenarioValuesDateTimeTableInfo().getRowDatas();
        for (n = 0; n < vector.size(); ++n) {
            Double d = vector.elementAt(n);
            object = arrayList.get(n);
            ((SpecifyScenarioValuesDateTimeTableInfo.RowData)object).setRootFieldValue("" + d);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            object = vector2.elementAt(i);
            SpecifyScenarioValuesDateTimeTableInfo.RowData rowData = arrayList.get(n + i);
            rowData.setRootFieldValue("" + object);
        }
        this.fireTableRowsUpdated(0, arrayList.size() - 1);
    }

    public class SpecifyScenarioValuesDateTimeTableInfo
    implements Cloneable {
        protected Long mStartEstimationTime = null;
        protected Long mEndEstimationTime = null;
        protected Long mUserSetStartTime;
        protected Long mUserSetEndTime;
        boolean mHasIntervalColumn = false;
        SpssDateFormatHelper.SimpleDateTimeType mSimpleDateTimeType;
        String mDefaultDateTimePattern = null;
        String mSPSSDateTimeFormat = null;
        String mDateTimePattern = null;
        ArrayList<RowData> mRowDatas = new ArrayList();
        ISpssVariable mActiveVar;
        Long mIncrement = null;
        boolean mIsRootField = true;

        public SpecifyScenarioValuesDateTimeTableInfo(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
            this.init(tCMForecastGatingInfo, scenarioPeriodInfo, bl);
        }

        protected void init(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
            TCMForecastGatingInfo.DateTimeInfo dateTimeInfo = tCMForecastGatingInfo.getDateTimeInfo();
            this.mStartEstimationTime = dateTimeInfo.getStartTime();
            this.mEndEstimationTime = dateTimeInfo.getEndTime();
            this.mUserSetStartTime = scenarioPeriodInfo.getPredictDateTimeTableInfo().getStartTime();
            this.mUserSetEndTime = scenarioPeriodInfo.getPredictDateTimeTableInfo().getEndTime();
            this.mHasIntervalColumn = !scenarioPeriodInfo.isSpecifyByStartEndPredictTimes();
            this.mIncrement = dateTimeInfo.getOutputTimeIncrement();
            this.mSimpleDateTimeType = dateTimeInfo.getDateTimeType();
            this.mDefaultDateTimePattern = dateTimeInfo.getLocalizedDateTimeFormatString();
            this.mSPSSDateTimeFormat = dateTimeInfo.getSPSSDateTimeFormatKey();
            this.mDateTimePattern = dateTimeInfo.getDateTimePattern();
            this.mIsRootField = bl;
            this.initRowDatas(tCMForecastGatingInfo, scenarioPeriodInfo);
        }

        private void initRowDatas(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            this.mRowDatas = new ArrayList();
            if (scenarioPeriodInfo.isSpecifyByStartEndPredictTimes()) {
                this.createRowDatasForEstimationPeriodDateCentric(tCMForecastGatingInfo);
                this.createRowDatasForForecastDateCentric(tCMForecastGatingInfo);
            } else {
                this.createRowDatasForEstimationPeriodIntervalCentric(tCMForecastGatingInfo, scenarioPeriodInfo);
                this.createRowDatasForForecastIntervalCentric(tCMForecastGatingInfo, scenarioPeriodInfo);
            }
        }

        private void createRowDatasForEstimationPeriodIntervalCentric(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            int n = new Integer(scenarioPeriodInfo.getStartingIntervalScenarioValue());
            int n2 = new Integer(scenarioPeriodInfo.getEndingIntervalScenarioValue());
            ArrayList<Long> arrayList = tCMForecastGatingInfo.getDateTimeInfo().getOutputTimeIntervals();
            if (n <= 0) {
                int n3 = Math.min(n2, 0);
                ArrayList<Long> arrayList2 = new ArrayList<Long>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n4 = -(arrayList.size() - i - 1);
                    if (n4 < n || n4 > n2) continue;
                    arrayList2.add(arrayList.get(i));
                }
                this.createRowDatas(arrayList2, n, true);
            }
        }

        private void createRowDatasForForecastIntervalCentric(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            int n = new Integer(scenarioPeriodInfo.getStartingIntervalScenarioValue());
            int n2 = new Integer(scenarioPeriodInfo.getEndingIntervalScenarioValue());
            int n3 = this.createForecastTimeIntervals(arrayList, tCMForecastGatingInfo.getOutputTimeInterval(), this.mEndEstimationTime, n, n2);
            this.createRowDatas(arrayList, n3, false);
        }

        private void createRowDatasForEstimationPeriodDateCentric(TCMForecastGatingInfo tCMForecastGatingInfo) {
            boolean bl;
            String string = tCMForecastGatingInfo.getOutputTimeInterval();
            ArrayList<Long> arrayList = tCMForecastGatingInfo.getDateTimeInfo().getOutputTimeIntervals();
            boolean bl2 = bl = this.mUserSetStartTime >= this.mStartEstimationTime && this.mUserSetStartTime <= this.mEndEstimationTime;
            if (bl) {
                Long l = Math.min(this.mUserSetEndTime, this.mEndEstimationTime);
                ArrayList<Long> arrayList2 = tCMForecastGatingInfo.getDateTimeInfo().getOutputTimeIntervals(string, this.mUserSetStartTime, l);
                int n = this.getTimeIndex(arrayList, l);
                int n2 = (arrayList.size() - (n + 1)) * -1;
                this.createRowDatas(arrayList2, n2 - (arrayList2.size() - 1), true);
            }
        }

        private void createRowDatasForForecastDateCentric(TCMForecastGatingInfo tCMForecastGatingInfo) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            int n = this.createForecastTimeIntervals(arrayList, tCMForecastGatingInfo.getOutputTimeInterval(), this.mEndEstimationTime, this.mUserSetStartTime, this.mUserSetEndTime);
            this.createRowDatas(arrayList, n, false);
        }

        private int createForecastTimeIntervals(ArrayList<Long> arrayList, String string, Long l, Long l2, Long l3) {
            int n = 0;
            long l4 = l;
            if (l2 > l) {
                l4 = SpecifyScenarioValuesDateTimeTableModel.incrementDateTime(l4, string);
                ++n;
                while (l4 < l2) {
                    l4 = SpecifyScenarioValuesDateTimeTableModel.incrementDateTime(l4, string);
                    ++n;
                }
            } else {
                l4 = SpecifyScenarioValuesDateTimeTableModel.incrementDateTime(l, string);
            }
            while (l4 <= l3) {
                arrayList.add(l4);
                l4 = SpecifyScenarioValuesDateTimeTableModel.incrementDateTime(l4, string);
            }
            return n == 0 ? 1 : n;
        }

        private int createForecastTimeIntervals(ArrayList<Long> arrayList, String string, Long l, int n, int n2) {
            boolean bl = false;
            long l2 = l;
            for (int i = 1; i <= n2; ++i) {
                l2 = SpecifyScenarioValuesDateTimeTableModel.incrementDateTime(l2, string);
                if (i < n || i > n2) continue;
                arrayList.add(l2);
            }
            return Math.max(1, n);
        }

        private int getTimeIndex(ArrayList<Long> arrayList, Long l) {
            int n = -1;
            for (int i = 0; i < arrayList.size(); ++i) {
                Long l2 = arrayList.get(i);
                if (l2.longValue() != l.longValue()) continue;
                n = i;
                break;
            }
            return n;
        }

        private void createRowDatas(ArrayList<Long> arrayList, int n, boolean bl) {
            int n2 = n - 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                Long l = arrayList.get(i);
                RowData rowData = new RowData(++n2, l, null, null, bl);
                this.mRowDatas.add(rowData);
            }
        }

        public ArrayList<RowData> getRowDatas() {
            return this.mRowDatas;
        }

        public boolean isRootField() {
            return this.mIsRootField;
        }

        public SpssDateFormatHelper.SimpleDateTimeType getSimpleDateTimeType() {
            return this.mSimpleDateTimeType;
        }

        public boolean hasIntervalColumn() {
            return this.mHasIntervalColumn;
        }

        public void setHasIntervalColumn(boolean bl) {
            this.mHasIntervalColumn = bl;
        }

        public Long getStartEstimationTime() {
            return this.mStartEstimationTime;
        }

        public void setStartEstimationTime(Long l) {
            this.mStartEstimationTime = l;
        }

        public void setEndEstimationTime(Long l) {
            this.mEndEstimationTime = l;
        }

        public Long getEndEstimationTime() {
            return this.mEndEstimationTime;
        }

        public String getDefaultDateTimePattern() {
            return this.mDefaultDateTimePattern;
        }

        public String getSPSSDateTimeFormat() {
            return this.mSPSSDateTimeFormat;
        }

        public String getDateTimePattern() {
            return this.mDateTimePattern;
        }

        public Long getUserSetStartTime() {
            return this.mUserSetStartTime;
        }

        public Long getUserSetEndTime() {
            return this.mUserSetEndTime;
        }

        public boolean updateNewScenarioPeriodInfo(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
            boolean bl2 = false;
            ArrayList<RowData> arrayList = this.mRowDatas;
            this.mRowDatas = new ArrayList();
            this.init(tCMForecastGatingInfo, scenarioPeriodInfo, bl);
            for (int i = 0; i < arrayList.size(); ++i) {
                RowData rowData;
                RowData rowData2 = arrayList.get(i);
                if (rowData2.getScenarioValue() == null || (rowData = this.findRowByDate(rowData2)) == null) continue;
                rowData.copyRowData(rowData2);
                bl2 = true;
            }
            return bl2;
        }

        private RowData findRowByDate(RowData rowData) {
            RowData rowData2 = null;
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                if (this.mRowDatas.get(i).getDate().longValue() != rowData.getDate().longValue()) continue;
                rowData2 = this.mRowDatas.get(i);
                break;
            }
            return rowData2;
        }

        public void setActiveVariable(ISpssVariable iSpssVariable) {
            if (this.mActiveVar != null && !this.mActiveVar.getName().equals(iSpssVariable.getName())) {
                this.reset();
            }
            this.mActiveVar = iSpssVariable;
        }

        public boolean areAllScenarioValuesDefined() {
            boolean bl = true;
            ArrayList<RowData> arrayList = this.getRowDatas();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).getScenarioValue() != null) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public ISpssVariable getActiveVariable() {
            return this.mActiveVar;
        }

        public void reset() {
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                RowData rowData = this.mRowDatas.get(i);
                rowData.reset();
            }
            SpecifyScenarioValuesDateTimeTableModel.this.fireTableRowsUpdated(0, this.mRowDatas.size() - 1);
        }

        public Object clone() throws CloneNotSupportedException {
            SpecifyScenarioValuesDateTimeTableInfo specifyScenarioValuesDateTimeTableInfo = (SpecifyScenarioValuesDateTimeTableInfo)super.clone();
            ArrayList<RowData> arrayList = new ArrayList<RowData>();
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                RowData rowData = this.mRowDatas.get(i);
                arrayList.add((RowData)rowData.clone());
            }
            specifyScenarioValuesDateTimeTableInfo.mRowDatas = arrayList;
            return specifyScenarioValuesDateTimeTableInfo;
        }

        public class RowData
        implements Cloneable {
            int interval;
            Long date;
            Double scenarioValue;
            String rootFieldValue;
            boolean withinEstimationPeriod;

            RowData(int n, Long l, Double d, String string, boolean bl) {
                this.interval = n;
                this.date = l;
                this.scenarioValue = d;
                this.rootFieldValue = string;
                this.withinEstimationPeriod = bl;
            }

            public boolean isWithinEstimationPeriod() {
                return this.withinEstimationPeriod;
            }

            public int getInterval() {
                return this.interval;
            }

            public void setInterval(int n) {
                this.interval = n;
            }

            public Long getDate() {
                return this.date;
            }

            public void setDate(Long l) {
                this.date = l;
            }

            public Double getScenarioValue() {
                return this.scenarioValue;
            }

            public void setScenarioValue(Double d) {
                this.scenarioValue = d;
            }

            public String getRootFieldValue() {
                return this.rootFieldValue;
            }

            public void setRootFieldValue(String string) {
                this.rootFieldValue = string;
            }

            public Object clone() throws CloneNotSupportedException {
                RowData rowData = (RowData)super.clone();
                return rowData;
            }

            public void copyRowData(RowData rowData) {
                this.interval = rowData.getInterval();
                this.date = rowData.getDate();
                this.scenarioValue = rowData.getScenarioValue();
                this.rootFieldValue = rowData.getRootFieldValue();
                this.withinEstimationPeriod = rowData.isWithinEstimationPeriod();
            }

            public void reset() {
                this.scenarioValue = null;
                this.rootFieldValue = null;
            }
        }
    }
}

