/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.ui.dialogs.TCM.controls_models.SpecifyScenarioValuesDateTimeTableModel;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;

public class SpecifyScenarioValuesDateTimeTable
extends JTable
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    ResourceBundle mResourceBundle;
    private SpecifyScenarioValuesDateTimeTableModel model;
    private boolean initialized = false;

    public SpecifyScenarioValuesDateTimeTable(ResourceBundle resourceBundle, SpecifyScenarioValuesDateTimeTableModel specifyScenarioValuesDateTimeTableModel) {
        super(specifyScenarioValuesDateTimeTableModel);
        this.mResourceBundle = resourceBundle;
        this.model = specifyScenarioValuesDateTimeTableModel;
        this.setOptions();
        this.setColumnsRender();
        this.setColumnsEditor();
        this.initialized = true;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                if (!(focusEvent.getOppositeComponent() instanceof JTextField)) {
                    TCMUtilities.stopTableEditing(SpecifyScenarioValuesDateTimeTable.this);
                }
            }
        });
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.initialized && tableModelEvent.getType() == 0) {
            this.setColumnsRender();
            this.setColumnsEditor();
        }
    }

    private void setOptions() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        this.setRowHeight(20);
        this.addMouseMotionListener(this);
    }

    private void setColumnsRender() {
        DateTimeTableCellRenderer dateTimeTableCellRenderer = new DateTimeTableCellRenderer();
        boolean bl = this.model.getSpecifyScenarioValuesDateTimeTableInfo().hasIntervalColumn();
        this.getColumnModel().getColumn(bl ? 1 : 0).setCellRenderer(dateTimeTableCellRenderer);
        this.getColumnModel().getColumn(bl ? 2 : 1).setCellRenderer(new TCMUtilities.ScenarioValueCellRenderer());
        this.getColumnModel().getColumn(bl ? 3 : 2).setCellRenderer(new RootFieldCellRenderer(ReadForeCastType.READ));
    }

    private void setColumnsEditor() {
        boolean bl = this.model.getSpecifyScenarioValuesDateTimeTableInfo().hasIntervalColumn();
        this.getColumnModel().getColumn(bl ? 1 : 0).setCellEditor(new DateCellEditor(new JTextField()));
        this.getColumnModel().getColumn(bl ? 2 : 1).setCellEditor(new TCMUtilities.DoubleCellEditor(new JTextField()));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean isControlEnabled() {
        return this.isEnabled();
    }

    public void setControlEnabled(boolean bl) {
        this.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private String getLabel(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return string2 == null ? "" : string2;
    }

    public void refresh() {
        this.model.fireTableStructureChanged();
    }

    public static enum ReadForeCastType {
        READ,
        FORECAST,
        READ_FORECAST;

    }

    public class DateCellEditor
    extends DefaultCellEditor {
        private JTextField mTextField;
        private SimpleDateFormat mForamatter;

        public DateCellEditor(JTextField jTextField) {
            super(jTextField);
            this.mTextField = jTextField;
            this.mForamatter = SpecifyScenarioValuesDateTimeTable.this.model.getDateTimeFormatter();
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.mTextField.getText();
            if (string.trim().length() > 0) {
                try {
                    Date date = this.mForamatter.parse(string.trim());
                    return date;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            Date date = null;
            if (object instanceof Date) {
                date = (Date)object;
            } else if (object instanceof Long) {
                date = new Date((Long)object);
            }
            if (date != null) {
                this.mTextField.setText(this.mForamatter.format(date));
            }
            return component;
        }
    }

    public class DateTimeTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Long) {
                Date date = new Date((Long)object);
                if (date != null) {
                    String string = SpecifyScenarioValuesDateTimeTable.this.model.formatDateValue(date);
                    this.setText(string);
                }
                this.setForeground(Color.BLACK);
            } else {
                String string = SpecifyScenarioValuesDateTimeTable.this.model.getUserExampleDateTimePattern();
                this.setText(string);
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }

    public class RootFieldCellRenderer
    extends DefaultTableCellRenderer {
        private ReadForeCastType mReadForeCastType;

        public RootFieldCellRenderer(ReadForeCastType readForeCastType) {
            this.mReadForeCastType = readForeCastType;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object == null || ((String)object).trim().length() == 0) {
                object = this.getDefaultText(n);
            } else if (object != null && !SpecifyScenarioValuesDateTimeTable.this.model.isRowTimeWithinEstimationPeriod(n)) {
                object = object + "*";
            }
            this.setText((String)object);
            return this;
        }

        private String getDefaultText(int n) {
            String string = "";
            boolean bl = SpecifyScenarioValuesDateTimeTable.this.model.isRowTimeWithinEstimationPeriod(n);
            string = bl ? SpecifyScenarioValuesDateTimeTable.this.getLabel("IDS_TCM_SCENARIO_DEFINITION_READ_TABLE_TEXT") : SpecifyScenarioValuesDateTimeTable.this.getLabel("IDS_TCM_SCENARIO_DEFINITION_FORECAST_TABLE_TEXT");
            return string;
        }
    }
}

