/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioPeriodDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.uitools.res.UIToolResUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SpecifyScenarioValuesCyclicTableModel
extends AbstractTableModel {
    public static final int SCENARIO_VALUE_COL_NO_INTERVAL_NO_CYCLIC = 0;
    public static final int ROOT_FIELD_COL_NO_INTERVAL = 1;
    public static final int LAST_COL_NO_INTERVAL = 1;
    private SpecifyScenarioValuesCyclicTableInfo mCyclicTableInfo;
    protected Long mDefaultStartTime = null;
    protected Long mDefaultEndTime = null;
    boolean mIsEditable = true;
    ResourceBundle mResourceBundle;

    public SpecifyScenarioValuesCyclicTableModel(ResourceBundle resourceBundle, TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
        this.mResourceBundle = resourceBundle;
        this.initSpecifyScenarioValuesCyclicTableInfo(tCMForecastGatingInfo, scenarioPeriodInfo, bl);
    }

    public SpecifyScenarioValuesCyclicTableModel(ResourceBundle resourceBundle, SpecifyScenarioValuesCyclicTableInfo specifyScenarioValuesCyclicTableInfo) {
        this.mResourceBundle = resourceBundle;
        this.saveCyclicTableInfo(specifyScenarioValuesCyclicTableInfo);
    }

    protected void initSpecifyScenarioValuesCyclicTableInfo(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
        SpecifyScenarioValuesCyclicTableInfo specifyScenarioValuesCyclicTableInfo = new SpecifyScenarioValuesCyclicTableInfo(tCMForecastGatingInfo, scenarioPeriodInfo, bl);
        this.saveCyclicTableInfo(specifyScenarioValuesCyclicTableInfo);
    }

    protected void saveCyclicTableInfo(SpecifyScenarioValuesCyclicTableInfo specifyScenarioValuesCyclicTableInfo) {
        this.mCyclicTableInfo = specifyScenarioValuesCyclicTableInfo;
    }

    public void setEditable(boolean bl) {
        this.mIsEditable = bl;
    }

    @Override
    public int getRowCount() {
        return this.mCyclicTableInfo.getRowDatas().size();
    }

    public String getCycleName(int n) {
        String string = "";
        if (this.isCyclicTableColIndex(n)) {
            string = this.mCyclicTableInfo.getCyclicNames().get(n - this.getCyclicColStartindex());
        }
        return string;
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        if (this.getIntervalColIndex() == n) {
            string = this.getLabel("IDS_TCM_SCENARIO_DEFINITION_INTERVAL_COL");
        } else if (this.isCyclicTableColIndex(n)) {
            string = this.mCyclicTableInfo.getCyclicNames().get(n - this.getCyclicColStartindex());
            if (string.equals("$casecount")) {
                string = this.getLabel("IDS_TCM_CASECOUNT_DISPLAY_LABEL");
            }
        } else if (n == this.getScenarioValueTableColIndex()) {
            string = this.getLabel("IDS_TCM_SCENARIO_DEFINITION_SCENARIO_VALUE_COL");
        } else if (n == this.getRootFieldTableColIndex()) {
            string = this.getCyclicTableInfo().isRootField() ? this.getLabel("IDS_TCM_SCENARIO_DEFINITION_ROOT_FIELD_VALUE_COL") : this.getLabel("IDS_TCM_MULTI_DIM_SCENARIO_DEFINITION_ROOT_SERIES_VALUE_COL");
        }
        return string;
    }

    private String getLabel(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return string2 == null ? "" : string2;
    }

    @Override
    public int getColumnCount() {
        int n = this.getCyclicTableInfo().hasIntervalColumn() ? 1 : 0;
        int n2 = this.getNumCycleColumns();
        return n + n2 + 1 + 1;
    }

    private int getNumCycleColumns() {
        return this.mCyclicTableInfo.getCyclicNames().size();
    }

    public String getModelStartInterval() {
        ArrayList<SpecifyScenarioValuesCyclicTableInfo.RowData> arrayList = this.getCyclicTableInfo().getRowDatas();
        return arrayList.size() >= 1 ? "" + arrayList.get(0).getInterval() : null;
    }

    public String getModelEndInterval() {
        ArrayList<SpecifyScenarioValuesCyclicTableInfo.RowData> arrayList = this.getCyclicTableInfo().getRowDatas();
        return arrayList.size() >= 1 ? "" + arrayList.get(arrayList.size() - 1).getInterval() : null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    public SpecifyScenarioValuesCyclicTableInfo getCyclicTableInfo() {
        return this.mCyclicTableInfo;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        ArrayList<SpecifyScenarioValuesCyclicTableInfo.RowData> arrayList = this.getCyclicTableInfo().getRowDatas();
        if (n2 == this.getIntervalColIndex()) {
            object = arrayList.get(n).getInterval();
        } else if (this.isCyclicTableColIndex(n2)) {
            object = arrayList.get(n).getCyclicNameToValueMap().get(this.getCycleName(n2));
        } else if (n2 == this.getScenarioValueTableColIndex()) {
            object = arrayList.get(n).getScenarioValue();
        } else if (n2 == this.getRootFieldTableColIndex()) {
            object = arrayList.get(n).getRootFieldValue();
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ArrayList<SpecifyScenarioValuesCyclicTableInfo.RowData> arrayList = this.getCyclicTableInfo().getRowDatas();
        if (n2 == this.getScenarioValueTableColIndex() && object instanceof Double) {
            arrayList.get(n).setScenarioValue((Double)object);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == this.getScenarioValueTableColIndex();
    }

    private Long getLongValue(Object object) {
        long l = 1L;
        if (object instanceof String) {
            l = Long.parseLong((String)object);
        } else if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Float) {
            l = ((Float)object).longValue();
        } else if (object instanceof Double) {
            l = ((Double)object).longValue();
        }
        return l > 1L ? l : 1L;
    }

    public void reset() {
    }

    public int getIntervalColIndex() {
        boolean bl = this.getCyclicTableInfo().hasIntervalColumn();
        return bl ? 0 : -1;
    }

    public boolean isCyclicTableColIndex(int n) {
        int n2 = this.getCyclicColStartindex();
        return n >= n2 && n < n2 + this.getNumCycleColumns();
    }

    public int getScenarioValueTableColIndex() {
        int n = this.getCyclicTableInfo().hasIntervalColumn() ? 1 : 0;
        int n2 = this.getNumCycleColumns();
        return n + n2;
    }

    private int getCyclicColStartindex() {
        return this.getCyclicTableInfo().hasIntervalColumn() ? 1 : 0;
    }

    public int getRootFieldTableColIndex() {
        return this.getScenarioValueTableColIndex() + 1;
    }

    public boolean isRowTimeWithinEstimationPeriod(int n) {
        return this.getCyclicTableInfo().getRowDatas().get(n).isWithinEstimationPeriod();
    }

    public boolean hasReadIntervals() {
        return this.hasReadForecastIntervals(true);
    }

    public boolean hasForecastIntervals() {
        return this.hasReadForecastIntervals(false);
    }

    protected boolean hasReadForecastIntervals(boolean bl) {
        boolean bl2 = false;
        ArrayList<SpecifyScenarioValuesCyclicTableInfo.RowData> arrayList = this.getCyclicTableInfo().getRowDatas();
        for (int i = 0; i < arrayList.size(); ++i) {
            SpecifyScenarioValuesCyclicTableInfo.RowData rowData = arrayList.get(i);
            if ((!bl || !rowData.isWithinEstimationPeriod()) && (bl || rowData.isWithinEstimationPeriod())) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public void setActiveVariable(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, ISpssVariable iSpssVariable) {
        this.mCyclicTableInfo.setActiveVariable(tCMForecastGatingInfo, scenarioPeriodInfo, iSpssVariable);
    }

    public ISpssVariable getActiveVariable() {
        return this.mCyclicTableInfo.getActiveVariable();
    }

    public Vector<String> getCyclicNamesV() {
        Vector<String> vector = new Vector<String>();
        for (String string : this.mCyclicTableInfo.getCyclicNames()) {
            vector.add(string);
        }
        return vector;
    }

    public Vector<Long> getModelCyclicStartEndValues(Vector<String> vector, boolean bl) {
        Vector<Long> vector2;
        Vector<Long> vector3 = vector2 = this.mCyclicTableInfo.getRowDatas().size() >= 1 ? new Vector<Long>() : null;
        if (vector2 != null) {
            SpecifyScenarioValuesCyclicTableInfo.RowData rowData = this.mCyclicTableInfo.getRowDatas().get(bl ? 0 : this.mCyclicTableInfo.getRowDatas().size() - 1);
            for (String string : vector) {
                vector2.add(rowData.getCyclicNameToValueMap().get(string));
            }
        }
        return vector2;
    }

    public void setRootFieldValue(Vector<Double> vector, Vector<Double> vector2) {
        Object object;
        int n;
        ArrayList<SpecifyScenarioValuesCyclicTableInfo.RowData> arrayList = this.getCyclicTableInfo().getRowDatas();
        for (n = 0; n < vector.size(); ++n) {
            Double d = vector.elementAt(n);
            object = arrayList.get(n);
            ((SpecifyScenarioValuesCyclicTableInfo.RowData)object).setRootFieldValue("" + d);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            object = vector2.elementAt(i);
            SpecifyScenarioValuesCyclicTableInfo.RowData rowData = arrayList.get(n + i);
            rowData.setRootFieldValue("" + object);
        }
        this.fireTableRowsUpdated(0, arrayList.size() - 1);
    }

    public class SpecifyScenarioValuesCyclicTableInfo
    implements Cloneable {
        boolean mHasIntervalColumn = false;
        ArrayList<RowData> mRowDatas = new ArrayList();
        ISpssVariable mActiveVar;
        boolean mIsRootField = false;
        Long mIncrement = null;
        private TCMForecastGatingInfo.CyclicInfo mCyclicInfo;
        ArrayList<String> mCyclicNames = new ArrayList();
        public HashMap<String, Long> mCyclicNameToUserSetStartValueMap = new HashMap();
        public HashMap<String, Long> mCyclicNameToUserSetEndValueMap = new HashMap();

        public SpecifyScenarioValuesCyclicTableInfo(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
            this.init(tCMForecastGatingInfo, scenarioPeriodInfo, bl);
        }

        protected void init(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
            this.mCyclicInfo = tCMForecastGatingInfo.getCyclicInfo();
            this.mHasIntervalColumn = !scenarioPeriodInfo.isSpecifyByStartEndPredictTimes();
            this.mCyclicNames = this.mCyclicInfo.getCyclicFieldNames();
            TCMScenarioPeriodDlg.PredictCyclicTableModel.PredictCyclicTableInfo predictCyclicTableInfo = scenarioPeriodInfo.getPredictCyclicTableInfo();
            this.mCyclicNameToUserSetStartValueMap = predictCyclicTableInfo.getCyclicNameToStartValueMap();
            this.mCyclicNameToUserSetEndValueMap = predictCyclicTableInfo.getCyclicNameToEndValueMap();
            this.mIncrement = this.mCyclicInfo.getIncrement();
            this.mIsRootField = bl;
            this.initRowDatas(tCMForecastGatingInfo, scenarioPeriodInfo);
        }

        public boolean isRootField() {
            return this.mIsRootField;
        }

        public ArrayList<String> getCyclicNames() {
            return this.mCyclicNames;
        }

        public void reset() {
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                RowData rowData = this.mRowDatas.get(i);
                rowData.reset();
            }
            SpecifyScenarioValuesCyclicTableModel.this.fireTableRowsUpdated(0, this.mRowDatas.size() - 1);
        }

        private void initRowDatas(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            this.mRowDatas = new ArrayList();
            if (scenarioPeriodInfo.isSpecifyByStartEndPredictTimes()) {
                this.createRowDatasForCycleCentric(tCMForecastGatingInfo);
            } else {
                this.createRowDatasForIntervalCentric(tCMForecastGatingInfo, scenarioPeriodInfo);
            }
        }

        private void createRowDatasForCycleCentric(TCMForecastGatingInfo tCMForecastGatingInfo) {
            ArrayList<Long> arrayList = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.mCyclicNameToUserSetStartValueMap);
            ArrayList<Long> arrayList2 = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.mCyclicNameToUserSetEndValueMap);
            this.createRowDatas(tCMForecastGatingInfo, arrayList, arrayList2, this.mIncrement);
        }

        private void createRowDatasForIntervalCentric(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo) {
            ArrayList<Long> arrayList = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.mCyclicNameToUserSetStartValueMap);
            ArrayList<Long> arrayList2 = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.mCyclicNameToUserSetEndValueMap);
            int n = new Integer(scenarioPeriodInfo.getStartingIntervalScenarioValue());
            int n2 = new Integer(scenarioPeriodInfo.getEndingIntervalScenarioValue());
            if (n <= 0) {
                this.createEstimationPeriodCycles(tCMForecastGatingInfo, n, n2);
            }
            if (n2 > 0) {
                this.createForecastPeriodCycles(tCMForecastGatingInfo, n, n2);
            }
        }

        private void createForecastPeriodCycles(TCMForecastGatingInfo tCMForecastGatingInfo, int n, int n2) {
            ArrayList<Long> arrayList = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToEndEstimationValues();
            arrayList = this.incrementCyclicValues(tCMForecastGatingInfo, arrayList, this.mIncrement);
            for (int i = 1; i <= n2; ++i) {
                if (i >= n && i <= n2) {
                    RowData rowData = this.createRowData(tCMForecastGatingInfo, arrayList, i);
                    this.mRowDatas.add(rowData);
                }
                arrayList = this.incrementCyclicValues(tCMForecastGatingInfo, arrayList, this.mIncrement);
            }
        }

        private void createEstimationPeriodCycles(TCMForecastGatingInfo tCMForecastGatingInfo, int n, int n2) {
            int n3 = -Math.min(0, n2);
            ArrayList<Long> arrayList = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToEndEstimationValues();
            for (int i = 0; i <= -n; ++i) {
                if (i >= n3) {
                    RowData rowData = this.createRowData(tCMForecastGatingInfo, arrayList, -i);
                    this.mRowDatas.add(0, rowData);
                }
                arrayList = this.decrementCyclicValues(tCMForecastGatingInfo, arrayList, this.mIncrement);
            }
        }

        private void createRowDatas(TCMForecastGatingInfo tCMForecastGatingInfo, ArrayList<Long> arrayList, ArrayList<Long> arrayList2, Long l) {
            int n = this.getStartingInterval(tCMForecastGatingInfo, arrayList);
            while (!TCMForecastGatingInfo.CyclicInfo.areValuesEqual(arrayList, arrayList2)) {
                this.addRowData(tCMForecastGatingInfo, arrayList, n);
                arrayList = this.incrementCyclicValues(tCMForecastGatingInfo, arrayList, l);
                ++n;
            }
            this.addRowData(tCMForecastGatingInfo, arrayList, n);
        }

        private int getStartingInterval(TCMForecastGatingInfo tCMForecastGatingInfo, ArrayList<Long> arrayList) {
            int n = 0;
            ArrayList<Long> arrayList2 = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToEndEstimationValues();
            int n2 = TCMForecastGatingInfo.CyclicInfo.compareCyclicPeriods(arrayList, arrayList2);
            if (n2 < 0) {
                while (!TCMForecastGatingInfo.CyclicInfo.areValuesEqual(arrayList, arrayList2)) {
                    arrayList = this.incrementCyclicValues(tCMForecastGatingInfo, arrayList, this.mIncrement);
                    ++n;
                }
                n = -n;
            } else if (n2 > 0) {
                while (!TCMForecastGatingInfo.CyclicInfo.areValuesEqual(arrayList, arrayList2)) {
                    arrayList = this.decrementCyclicValues(tCMForecastGatingInfo, arrayList, this.mIncrement);
                    --n;
                }
                n = -n;
            }
            return n;
        }

        private ArrayList<Long> incrementCyclicValues(TCMForecastGatingInfo tCMForecastGatingInfo, ArrayList<Long> arrayList, Long l) {
            HashMap<String, Long> hashMap = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToRangeStartMap();
            HashMap<String, Long> hashMap2 = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToRangeEndMap();
            Long[] longArray = new Long[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                longArray[i] = arrayList.get(i);
            }
            ArrayList<Long> arrayList2 = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, hashMap);
            ArrayList<Long> arrayList3 = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, hashMap2);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Long[] longArray2 = arrayList3.get(i);
                if (longArray2 == null || arrayList.get(i) + l <= longArray2.longValue()) {
                    longArray[i] = arrayList.get(i) + l;
                    break;
                }
                longArray[i] = arrayList2.get(i);
            }
            ArrayList<Long> arrayList4 = new ArrayList<Long>();
            for (Long l2 : longArray) {
                arrayList4.add(l2);
            }
            return arrayList4;
        }

        private ArrayList<Long> decrementCyclicValues(TCMForecastGatingInfo tCMForecastGatingInfo, ArrayList<Long> arrayList, Long l) {
            HashMap<String, Long> hashMap = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToRangeStartMap();
            HashMap<String, Long> hashMap2 = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToRangeEndMap();
            Long[] longArray = new Long[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                longArray[i] = arrayList.get(i);
            }
            ArrayList<Long> arrayList2 = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, hashMap);
            ArrayList<Long> arrayList3 = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, hashMap2);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Long[] longArray2 = arrayList2.get(i);
                if (longArray2 == null || arrayList.get(i) - l >= longArray2.longValue()) {
                    longArray[i] = arrayList.get(i) - l;
                    break;
                }
                longArray[i] = arrayList3.get(i);
            }
            ArrayList<Long> arrayList4 = new ArrayList<Long>();
            for (Long l2 : longArray) {
                arrayList4.add(l2);
            }
            return arrayList4;
        }

        private void addRowData(TCMForecastGatingInfo tCMForecastGatingInfo, ArrayList<Long> arrayList, int n) {
            RowData rowData = this.createRowData(tCMForecastGatingInfo, arrayList, n);
            this.mRowDatas.add(rowData);
        }

        private RowData createRowData(TCMForecastGatingInfo tCMForecastGatingInfo, ArrayList<Long> arrayList, int n) {
            Object object;
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (int i = 0; i < this.mCyclicNames.size(); ++i) {
                String string = this.mCyclicNames.get(i);
                object = arrayList.get(i);
                if (object == null) continue;
                hashMap.put(string, (Long)object);
            }
            ArrayList<Long> arrayList2 = tCMForecastGatingInfo.getCyclicInfo().getCycleNameToEndEstimationValues();
            boolean bl = this.isCyclicPeriodWithinEstimationPeriod(arrayList, arrayList2);
            object = new RowData(n, hashMap, null, null, bl);
            return object;
        }

        protected boolean isCyclicPeriodWithinEstimationPeriod(ArrayList<Long> arrayList, ArrayList<Long> arrayList2) {
            return TCMForecastGatingInfo.CyclicInfo.compareCyclicPeriods(arrayList, arrayList2) <= 0;
        }

        public ArrayList<RowData> getRowDatas() {
            return this.mRowDatas;
        }

        public boolean hasIntervalColumn() {
            return this.mHasIntervalColumn;
        }

        public void setHasIntervalColumn(boolean bl) {
            this.mHasIntervalColumn = bl;
        }

        public boolean updateNewScenarioPeriodInfo(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, boolean bl) {
            boolean bl2 = false;
            ArrayList<RowData> arrayList = this.mRowDatas;
            this.mRowDatas = new ArrayList();
            this.init(tCMForecastGatingInfo, scenarioPeriodInfo, bl);
            for (int i = 0; i < arrayList.size(); ++i) {
                RowData rowData;
                RowData rowData2 = arrayList.get(i);
                if (rowData2.getScenarioValue() == null || (rowData = this.findRowByCycle(rowData2)) == null) continue;
                rowData.copyRowData(rowData2);
                bl2 = true;
            }
            return bl2;
        }

        private RowData findRowByCycle(RowData rowData) {
            RowData rowData2 = null;
            ArrayList<Long> arrayList = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, rowData.getCyclicNameToValueMap());
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                ArrayList<Long> arrayList2 = TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.mRowDatas.get(i).getCyclicNameToValueMap());
                if (!TCMForecastGatingInfo.CyclicInfo.areValuesEqual(arrayList2, arrayList)) continue;
                rowData2 = this.mRowDatas.get(i);
                break;
            }
            return rowData2;
        }

        public void setActiveVariable(TCMForecastGatingInfo tCMForecastGatingInfo, TCMScenarioPeriodDlg.ScenarioPeriodInfo scenarioPeriodInfo, ISpssVariable iSpssVariable) {
            if (this.mActiveVar != null && !this.mActiveVar.getName().equals(iSpssVariable.getName())) {
                this.reset();
            }
            this.mActiveVar = iSpssVariable;
        }

        public ISpssVariable getActiveVariable() {
            return this.mActiveVar;
        }

        public boolean areAllScenarioValuesDefined() {
            boolean bl = true;
            ArrayList<RowData> arrayList = SpecifyScenarioValuesCyclicTableModel.this.mCyclicTableInfo.getRowDatas();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).getScenarioValue() != null) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public Object clone() throws CloneNotSupportedException {
            SpecifyScenarioValuesCyclicTableInfo specifyScenarioValuesCyclicTableInfo = (SpecifyScenarioValuesCyclicTableInfo)super.clone();
            ArrayList<RowData> arrayList = new ArrayList<RowData>();
            for (int i = 0; i < this.mRowDatas.size(); ++i) {
                RowData rowData = this.mRowDatas.get(i);
                arrayList.add((RowData)rowData.clone());
            }
            specifyScenarioValuesCyclicTableInfo.mRowDatas = arrayList;
            return specifyScenarioValuesCyclicTableInfo;
        }

        public class RowData
        implements Cloneable {
            int interval;
            HashMap<String, Long> mCyclicNameToValueMap = new HashMap();
            Double scenarioValue;
            String rootFieldValue;
            boolean withinEstimationPeriod;

            RowData(int n, HashMap<String, Long> hashMap, Double d, String string, boolean bl) {
                this.interval = n;
                this.mCyclicNameToValueMap = hashMap;
                this.scenarioValue = d;
                this.rootFieldValue = string;
                this.withinEstimationPeriod = bl;
            }

            public boolean isWithinEstimationPeriod() {
                return this.withinEstimationPeriod;
            }

            public int getInterval() {
                return this.interval;
            }

            public void setInterval(int n) {
                this.interval = n;
            }

            public Long getCyclicValueForName(String string) {
                return this.mCyclicNameToValueMap.get(string);
            }

            public void setDate(String string, Long l) {
                this.mCyclicNameToValueMap.put(string, l);
            }

            public Double getScenarioValue() {
                return this.scenarioValue;
            }

            public void setScenarioValue(Double d) {
                this.scenarioValue = d;
            }

            public String getRootFieldValue() {
                return this.rootFieldValue;
            }

            public void setRootFieldValue(String string) {
                this.rootFieldValue = string;
            }

            public Object clone() throws CloneNotSupportedException {
                RowData rowData = (RowData)super.clone();
                return rowData;
            }

            public HashMap<String, Long> getCyclicNameToValueMap() {
                return this.mCyclicNameToValueMap;
            }

            public void copyRowData(RowData rowData) {
                this.interval = rowData.getInterval();
                this.mCyclicNameToValueMap = (HashMap)rowData.getCyclicNameToValueMap().clone();
                this.scenarioValue = rowData.getScenarioValue();
                this.rootFieldValue = rowData.getRootFieldValue();
                this.withinEstimationPeriod = rowData.isWithinEstimationPeriod();
            }

            public void reset() {
                this.scenarioValue = null;
                this.rootFieldValue = null;
            }
        }
    }
}

