/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.ui.dialogs.TCM.controls_models.SpecifyScenarioValuesCyclicTableModel;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ResourceBundle;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;

public class SpecifyScenarioValuesCyclicTable
extends JTable
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    ResourceBundle mResourceBundle;
    private SpecifyScenarioValuesCyclicTableModel model;
    private boolean initialized = false;

    public SpecifyScenarioValuesCyclicTable(ResourceBundle resourceBundle, SpecifyScenarioValuesCyclicTableModel specifyScenarioValuesCyclicTableModel) {
        super(specifyScenarioValuesCyclicTableModel);
        this.mResourceBundle = resourceBundle;
        this.model = specifyScenarioValuesCyclicTableModel;
        this.setOptions();
        this.setColumnsRender();
        this.setColumnsEditor();
        this.initialized = true;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                if (!(focusEvent.getOppositeComponent() instanceof JTextField)) {
                    TCMUtilities.stopTableEditing(SpecifyScenarioValuesCyclicTable.this);
                }
            }
        });
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.initialized && tableModelEvent.getType() == 0) {
            this.setColumnsRender();
            this.setColumnsEditor();
        }
    }

    private void setOptions() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        this.setRowHeight(20);
        this.addMouseMotionListener(this);
    }

    public void stopTableEditing() {
        TCMUtilities.stopTableEditing(this);
    }

    private void setColumnsRender() {
        this.getColumnModel().getColumn(this.model.getScenarioValueTableColIndex()).setCellRenderer(new TCMUtilities.ScenarioValueCellRenderer());
        this.getColumnModel().getColumn(this.model.getRootFieldTableColIndex()).setCellRenderer(new RootFieldCellRenderer(ReadForeCastType.READ));
    }

    private void setColumnsEditor() {
        this.getColumnModel().getColumn(this.model.getScenarioValueTableColIndex()).setCellEditor(new TCMUtilities.DoubleCellEditor(new JTextField()));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean isControlEnabled() {
        return this.isEnabled();
    }

    public void setControlEnabled(boolean bl) {
        this.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private String getLabel(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return string2 == null ? "" : string2;
    }

    public void refresh() {
        this.model.fireTableStructureChanged();
    }

    public static enum ReadForeCastType {
        READ,
        FORECAST,
        READ_FORECAST;

    }

    public class RootFieldCellRenderer
    extends DefaultTableCellRenderer {
        private ReadForeCastType mReadForeCastType;

        public RootFieldCellRenderer(ReadForeCastType readForeCastType) {
            this.mReadForeCastType = readForeCastType;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object == null || ((String)object).trim().length() == 0) {
                object = this.getDefaultText(n);
            } else if (object != null && !SpecifyScenarioValuesCyclicTable.this.model.isRowTimeWithinEstimationPeriod(n)) {
                object = object + "*";
            }
            this.setText((String)object);
            return this;
        }

        private String getDefaultText(int n) {
            String string = "";
            boolean bl = SpecifyScenarioValuesCyclicTable.this.model.isRowTimeWithinEstimationPeriod(n);
            string = bl ? SpecifyScenarioValuesCyclicTable.this.getLabel("IDS_TCM_SCENARIO_DEFINITION_READ_TABLE_TEXT") : SpecifyScenarioValuesCyclicTable.this.getLabel("IDS_TCM_SCENARIO_DEFINITION_FORECAST_TABLE_TEXT");
            return string;
        }
    }
}

