/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.pasw.core.property.descriptor.DefaultStructure;
import com.spss.datamodel.Storage;
import com.spss.java_client.ui.dialogs.TCM.controls_models.EstimationPeriodModel;
import com.spss.java_client.ui.dialogs.TCM.controls_models.Observations;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class EstimationPeriodTable
extends JTable
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private EstimationPeriodModel model;
    private boolean initialized = false;
    public static final String DATE_TOOLTIP = "observationsTimes.date";
    public static final String TIME_TOOLTIP = "observationsTimes.time";
    public static final String DATE_TIME_TOOLTIP = "observationsTimes.dateTime";
    public static final String[] PERIOD_TOOLTIP = new String[]{"observationspPeriod.start", "observationspPeriod.end"};

    public EstimationPeriodTable(EstimationPeriodModel estimationPeriodModel) {
        super(estimationPeriodModel);
        this.model = estimationPeriodModel;
        this.setOptions();
        this.setColumnsWith();
        this.setColumnsRender();
        this.setColumnsEditer();
        this.initialized = true;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.initialized && tableModelEvent.getType() == 0) {
            this.setColumnsWith();
            this.setColumnsRender();
            this.setColumnsEditer();
        }
    }

    private void setOptions() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        this.setRowHeight(20);
        this.addMouseMotionListener(this);
    }

    private void setColumnsWith() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.charWidth('_');
        int n2 = this.getRowHeight();
        int n3 = 0;
        int n4 = 30 * n;
        Observations observations = this.model.getObservations();
        if (observations != null && observations.getType() == Observations.OBSERVATIONS_TYPE.CYCLIC) {
            n4 = 10 * n;
        }
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            int n5 = i == 0 ? 10 * n : n4;
            tableColumn.setPreferredWidth(n5);
            tableColumn.setMinWidth(n5);
            tableColumn.setMaxWidth(n5);
            n3 += n5;
        }
        this.setPreferredScrollableViewportSize(new Dimension(n3 + 1, n2 * this.getRowCount()));
    }

    private void setColumnsRender() {
        Observations observations = this.model.getObservations();
        if (observations == null) {
            return;
        }
        if (observations.getType() == Observations.OBSERVATIONS_TYPE.DATETIME) {
            Storage storage = observations.getValues().get(0).getDateTimeValue().getType();
            DateTimeTableCellRenderer dateTimeTableCellRenderer = new DateTimeTableCellRenderer(storage);
            this.getColumnModel().getColumn(1).setCellRenderer(dateTimeTableCellRenderer);
        } else if (observations.getType() == Observations.OBSERVATIONS_TYPE.CYCLIC) {
            int n = this.getColumnModel().getColumnCount();
            for (int i = 1; i < n; ++i) {
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        if (object instanceof Integer) {
                            String string = object == EstimationPeriodModel.DEFAULT_PERIOD_VALUE ? "" : object.toString();
                            this.setText(string);
                            if (EstimationPeriodTable.this.model.validatePeriodValue((Integer)object, n, n2)) {
                                this.setForeground(Color.BLACK);
                            } else {
                                this.setForeground(Color.RED);
                            }
                        } else {
                            this.setForeground(Color.RED);
                        }
                        return this;
                    }
                };
                this.getColumnModel().getColumn(i).setCellRenderer(defaultTableCellRenderer);
            }
        }
    }

    private void setColumnsEditer() {
        Observations observations = this.model.getObservations();
        if (observations == null) {
            return;
        }
        if (observations.getType() == Observations.OBSERVATIONS_TYPE.DATETIME) {
            Storage storage = observations.getValues().get(0).getDateTimeValue().getType();
            String string = null;
            SimpleDateFormat simpleDateFormat = null;
            if (storage == Storage.DATE) {
                string = DATE_TOOLTIP;
                simpleDateFormat = EstimationPeriodModel.DATE_FORMATTER;
            } else if (storage == Storage.TIME) {
                string = TIME_TOOLTIP;
                simpleDateFormat = EstimationPeriodModel.TIME_FORMATTER;
            } else if (storage == Storage.TIMESTAMP) {
                string = DATE_TIME_TOOLTIP;
                simpleDateFormat = EstimationPeriodModel.DATE_TIME_FORMATTER;
            }
            JTextField jTextField = new JTextField();
            this.getColumnModel().getColumn(1).setCellEditor(new DateCellEditor(jTextField, simpleDateFormat));
        } else if (observations.getType() == Observations.OBSERVATIONS_TYPE.CYCLIC) {
            int n = observations.getValues().get(0).getPeriodValues().size();
            for (int i = 0; i < n; ++i) {
                JTextField jTextField = new JTextField();
                this.getColumnModel().getColumn(1 + i).setCellEditor(new IntegerCellEditor(jTextField));
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean isControlEnabled() {
        return this.isEnabled();
    }

    public void setControlEnabled(boolean bl) {
        this.setEnabled(bl);
    }

    public Object getControlValue() {
        return this.model.getPropertyValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 > 0) {
            String string = null;
            Observations observations = this.model.getObservations();
            if (observations == null) {
                return;
            }
            if (observations.getType() == Observations.OBSERVATIONS_TYPE.DATETIME) {
                Storage storage = observations.getValues().get(0).getDateTimeValue().getType();
                if (storage == Storage.DATE) {
                    string = DATE_TOOLTIP;
                } else if (storage == Storage.TIME) {
                    string = TIME_TOOLTIP;
                } else if (storage == Storage.TIMESTAMP) {
                    string = DATE_TIME_TOOLTIP;
                }
            } else if (observations.getType() == Observations.OBSERVATIONS_TYPE.CYCLIC) {
                string = PERIOD_TOOLTIP[n];
            }
        }
    }

    public void setDateTimeObservations(String string) {
    }

    public void setCyclicObservations(String string, Integer n, List<DefaultStructure> list) {
    }

    public void refresh() {
        this.model.fireTableStructureChanged();
    }

    public class IntegerCellEditor
    extends DefaultCellEditor {
        private JTextField textField;

        public IntegerCellEditor(JTextField jTextField) {
            super(jTextField);
            this.textField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            if (string.trim().length() > 0) {
                Integer n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 1;
                }
                return n;
            }
            return string;
        }
    }

    public class DateCellEditor
    extends DefaultCellEditor {
        private JTextField textField;
        private SimpleDateFormat formater;

        public DateCellEditor(JTextField jTextField, SimpleDateFormat simpleDateFormat) {
            super(jTextField);
            this.textField = jTextField;
            this.formater = simpleDateFormat;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            if (string.trim().length() > 0) {
                try {
                    Date date = this.formater.parse(string.trim());
                    return date;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (object instanceof Date) {
                this.textField.setText(this.formater.format(object));
            }
            return component;
        }
    }

    public class DateTimeTableCellRenderer
    extends DefaultTableCellRenderer {
        Storage mDateType;

        public DateTimeTableCellRenderer(Storage storage) {
            this.mDateType = storage;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Date) {
                String string = EstimationPeriodTable.this.model.formatDateValue((Date)object, n, n2);
                this.setText(string);
                if (EstimationPeriodTable.this.model.validateDateTimeValue((Date)object, n, n2)) {
                    this.setForeground(Color.BLACK);
                } else {
                    this.setForeground(Color.RED);
                }
            } else {
                this.setText(this.getDateTypeDefaultStringRepresentation());
                this.setForeground(Color.GRAY);
            }
            return this;
        }

        private String getDateTypeDefaultStringRepresentation() {
            String string = "";
            if (this.mDateType == Storage.DATE) {
                string = SpssDateFormatHelper.eDEFAULT_ISO_DATE.getSimpleDateFormatPattern();
            } else if (this.mDateType == Storage.TIME) {
                string = SpssDateFormatHelper.eDEFAULT_ISO_TIME.getSimpleDateFormatPattern();
            } else if (this.mDateType == Storage.TIMESTAMP) {
                string = SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getSimpleDateFormatPattern();
            }
            return string;
        }
    }
}

