/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.pasw.core.property.PropertyDescriptor;
import com.pasw.core.property.descriptor.DefaultStructure;
import com.pasw.core.property.descriptor.DefaultStructureDefinition;
import com.pasw.core.property.descriptor.StringProperty;
import com.pasw.core.property.descriptor.StructureListProperty;
import com.pasw.core.property.descriptor.StructureProperty;
import com.pasw.framework.common.core.StructureDefinition;
import com.spss.datamodel.Field;
import com.spss.datamodel.Fields;
import com.spss.datamodel.Storage;
import com.spss.datamodel.ValidValue;
import com.spss.datamodel.ValidValues;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.DateTimeValue;
import com.spss.java_client.ui.dialogs.TCM.controls_models.Observations;
import com.spss.java_client.ui.dialogs.TCM.controls_models.ObservationsValue;
import com.spss.java_client.ui.dialogs.TCM.controls_models.PeriodValue;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import com.spss.uitools.res.UIToolResUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class EstimationPeriodModel
extends AbstractTableModel {
    public static final String CYCLIC_LEVEL = "level";
    public static final String CYCLIC_FIELDNAME = "fieldName";
    public static final String CYCLIC_FIELDLENGTH = "cyclicLength";
    public static final String CYCLIC_FIELDSTARTVALUE = "cyclicStartingValue";
    private static final long serialVersionUID = 1L;
    private static DefaultStructureDefinition dateTimeValue = new DefaultStructureDefinition("dateTimeValue");
    private static DefaultStructureDefinition periodValue = new DefaultStructureDefinition("periodValue");
    private static DefaultStructureDefinition observationsValue = new DefaultStructureDefinition("observationsValue");
    private static DefaultStructureDefinition observations = new DefaultStructureDefinition("observations");
    private static final Map<Storage, String> dataTimeColumns = new HashMap<Storage, String>();
    private static final Map<Storage, SimpleDateFormat> dataTimeFormaters = new HashMap<Storage, SimpleDateFormat>();
    private static final String[] periodColumns = new String[]{"observationspPeriod.periods", "observationspPeriod.firstCyles", "observationspPeriod.secondstCyles"};
    private static final String[] fixedRows = new String[]{"IDS_TCM_FORCASTING_MODELTAB_START_LABEL", "IDS_TCM_FORCASTING_MODELTAB_END_LABEL"};
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat DATE_TIME_FORMATTER = new SimpleDateFormat(SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getSimpleDateFormatPattern());
    public static Long DEFAULT_PERIOD_VALUE;
    public static Long DEFAULT_DATE_TIME_VALUE;
    public static final String OBSERVATION_NAME = "name";
    public static final String OBSERVATION_TYPE = "type";
    public static final String OBSERVATION_LENGTH = "length";
    public static final String OBSERVATION_START = "start";
    public static final String OBSERVATION_END = "end";
    public static final String OBSERVATION_VALUE = "value";
    public static final String OBSERVATION_VALUES = "values";
    public static final String OBSERVATION_DATE_TIME_VALUE = "dateTimeValue";
    public static final String OBSERVATION_PERIOD_VALUES = "periodValues";
    private TCMForecastGatingInfo mTCMForecastGatingInfo;
    ResourceBundle mResourceBundle;
    private Observations observation;

    public EstimationPeriodModel(ResourceBundle resourceBundle, TCMForecastGatingInfo tCMForecastGatingInfo) {
        this.mResourceBundle = resourceBundle;
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.initObservation();
    }

    private void initObservation() {
        Observations.OBSERVATIONS_TYPE oBSERVATIONS_TYPE = Observations.OBSERVATIONS_TYPE.DATETIME;
        ArrayList<ObservationsValue> arrayList = new ArrayList<ObservationsValue>();
        DateTimeValue dateTimeValue = new DateTimeValue(Storage.DATE, DEFAULT_DATE_TIME_VALUE, DEFAULT_DATE_TIME_VALUE, DEFAULT_DATE_TIME_VALUE);
        DateTimeValue dateTimeValue2 = new DateTimeValue(Storage.DATE, DEFAULT_DATE_TIME_VALUE, DEFAULT_DATE_TIME_VALUE, DEFAULT_DATE_TIME_VALUE);
        ArrayList<PeriodValue> arrayList2 = new ArrayList<PeriodValue>();
        arrayList.add(new ObservationsValue(dateTimeValue, arrayList2));
        arrayList.add(new ObservationsValue(dateTimeValue2, arrayList2));
        this.observation = new Observations(oBSERVATIONS_TYPE, arrayList);
    }

    @Override
    public int getRowCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        if (this.observation != null) {
            Observations.OBSERVATIONS_TYPE oBSERVATIONS_TYPE = this.observation.getType();
            if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.DATETIME) {
                Storage storage = this.observation.getValues().get(0).getDateTimeValue().getType();
                return n == 1 ? this.getLabel(dataTimeColumns.get(storage)) : "";
            }
            if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.CYCLIC) {
                List<PeriodValue> list = this.observation.getValues().get(0).getPeriodValues();
                return n > 0 && n <= list.size() ? list.get(n - 1).getName() : "";
            }
        }
        return "";
    }

    private String getLabel(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return string2 == null ? "" : string2;
    }

    @Override
    public int getColumnCount() {
        if (this.observation != null) {
            Observations.OBSERVATIONS_TYPE oBSERVATIONS_TYPE = this.observation.getType();
            if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.DATETIME) {
                return 2;
            }
            if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.CYCLIC) {
                int n = this.observation.getValues().get(0).getPeriodValues().size();
                return n + 1;
            }
        }
        return 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        Observations.OBSERVATIONS_TYPE oBSERVATIONS_TYPE = this.observation.getType();
        if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.DATETIME) {
            return Date.class;
        }
        if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.CYCLIC) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getLabel(fixedRows[n]);
        }
        Observations.OBSERVATIONS_TYPE oBSERVATIONS_TYPE = this.observation.getType();
        if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.DATETIME) {
            Long l = this.observation.getValues().get(n).getDateTimeValue().getValue();
            if (l != null && !l.equals(DEFAULT_DATE_TIME_VALUE)) {
                try {
                    Long l2 = l * 1000L;
                    return new Date(l2);
                }
                catch (Exception exception) {}
            }
        } else if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.CYCLIC) {
            List<PeriodValue> list = this.observation.getValues().get(n).getPeriodValues();
            return n2 <= list.size() ? Integer.valueOf(list.get(n2 - 1).getValue()) : null;
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 > 0) {
            Observations.OBSERVATIONS_TYPE oBSERVATIONS_TYPE = this.observation.getType();
            if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.DATETIME) {
                Long l = DEFAULT_DATE_TIME_VALUE;
                if (n2 == 1 && object instanceof Date) {
                    l = ((Date)object).getTime() / 1000L;
                }
                this.observation.getValues().get(n).getDateTimeValue().setValue(new Long(l));
            } else if (oBSERVATIONS_TYPE == Observations.OBSERVATIONS_TYPE.CYCLIC) {
                Integer n3 = object instanceof Integer ? (Integer)object : 0;
                List<PeriodValue> list = this.observation.getValues().get(n).getPeriodValues();
                if (n2 <= list.size()) {
                    list.get(n2 - 1).setValue(n3);
                }
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public Observations getObservations() {
        return this.observation;
    }

    public Object getPropertyValue() {
        if (this.observation != null) {
            ArrayList<DefaultStructure> arrayList = new ArrayList<DefaultStructure>();
            Object[] objectArray = null;
            for (ObservationsValue observationsValue : this.observation.getValues()) {
                Object[] objectArray2;
                objectArray = new Object[2];
                if (this.observation.getType() == Observations.OBSERVATIONS_TYPE.DATETIME) {
                    objectArray2 = new Object[]{observationsValue.getDateTimeValue().getName(), observationsValue.getDateTimeValue().getType(), observationsValue.getDateTimeValue().getStart(), observationsValue.getDateTimeValue().getEnd(), observationsValue.getDateTimeValue().getValue()};
                    objectArray[0] = new DefaultStructure((StructureDefinition)dateTimeValue, objectArray2);
                    objectArray[1] = new ArrayList();
                } else if (this.observation.getType() == Observations.OBSERVATIONS_TYPE.CYCLIC) {
                    objectArray2 = new Object[]{Storage.DATE.toString(), Storage.DATE.toString(), DEFAULT_DATE_TIME_VALUE, DEFAULT_DATE_TIME_VALUE, DEFAULT_DATE_TIME_VALUE};
                    objectArray[0] = new DefaultStructure((StructureDefinition)dateTimeValue, objectArray2);
                    ArrayList<DefaultStructure> arrayList2 = new ArrayList<DefaultStructure>();
                    for (PeriodValue periodValue : observationsValue.getPeriodValues()) {
                        Object[] objectArray3 = new Object[]{periodValue.getName(), periodValue.getLength(), periodValue.getStart(), periodValue.getValue()};
                        arrayList2.add(new DefaultStructure((StructureDefinition)EstimationPeriodModel.periodValue, objectArray3));
                    }
                    objectArray[1] = arrayList2;
                }
                arrayList.add(new DefaultStructure((StructureDefinition)EstimationPeriodModel.observationsValue, objectArray));
            }
            objectArray = new Object[]{this.observation.getType(), arrayList};
            DefaultStructure defaultStructure = new DefaultStructure((StructureDefinition)observations, objectArray);
            return defaultStructure;
        }
        return null;
    }

    public String formatDateValue(Date date, int n, int n2) {
        Storage storage = this.observation.getValues().get(n).getDateTimeValue().getType();
        SimpleDateFormat simpleDateFormat = dataTimeFormaters.get(storage);
        return simpleDateFormat.format(date);
    }

    public Date parseDateValue(String string, int n, int n2) {
        Storage storage = this.observation.getValues().get(n).getDateTimeValue().getType();
        SimpleDateFormat simpleDateFormat = dataTimeFormaters.get(storage);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public boolean validateDateTimeValue(Date date, int n, int n2) {
        try {
            Long l = date.getTime() / 1000L;
            Long l2 = Long.parseLong("" + this.observation.getValues().get(n).getDateTimeValue().getStart());
            Long l3 = Long.parseLong("" + this.observation.getValues().get(n).getDateTimeValue().getEnd());
            if (l < l2 || l > l3) {
                return false;
            }
            Long l4 = Long.parseLong("" + this.observation.getValues().get(1 - n).getDateTimeValue().getValue());
            return (n != 0 || l <= l4) && (n != 1 || l >= l4);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private ValidValue getValidValue(ValidValues validValues, int n) {
        Object var3_3 = null;
        Iterator iterator = validValues.iterator();
        int n2 = 0;
        ValidValue validValue = null;
        while (iterator.hasNext()) {
            ValidValue validValue2 = (ValidValue)iterator.next();
            if (n2 != n) continue;
            validValue = validValue2;
            break;
        }
        return validValue;
    }

    private Field findField(String string) {
        Fields fields = this.mTCMForecastGatingInfo.getDataModel().getFields();
        return fields.getField(string);
    }

    private int getIntValue(Object object) {
        int n = 1;
        if (object instanceof Long) {
            n = ((Long)object).intValue();
        } else if (object instanceof Long) {
            n = ((Long)object).intValue();
        } else if (object instanceof Float) {
            n = ((Float)object).intValue();
        } else if (object instanceof Double) {
            n = ((Double)object).intValue();
        }
        return n > 1 ? n : 1;
    }

    public boolean validatePeriodValue(Integer n, int n2, int n3) {
        if (n2 > this.observation.getValues().size()) {
            return false;
        }
        List<PeriodValue> list = this.observation.getValues().get(n2).getPeriodValues();
        if (n3 > list.size() + 1) {
            return false;
        }
        int n4 = list.get(n3 - 1).getLength();
        int n5 = list.get(n3 - 1).getStart();
        if (n < n5 || n3 != list.size() && n > n5 + n4) {
            return false;
        }
        int n6 = this.observation.getValues().get(1 - n2).getPeriodValues().get(n3 - 1).getValue();
        return (n2 != 0 || n <= n6) && (n2 != 1 || n >= n6);
    }

    public void reset() {
        this.initObservation();
        this.fireTableDataChanged();
    }

    static {
        DEFAULT_DATE_TIME_VALUE = DEFAULT_PERIOD_VALUE = Long.valueOf(-1L);
        dateTimeValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_NAME));
        dateTimeValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_TYPE));
        dateTimeValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_START));
        dateTimeValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_END));
        dateTimeValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_VALUE));
        periodValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_NAME));
        periodValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_LENGTH));
        periodValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_START));
        periodValue.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_VALUE));
        observationsValue.addAttribute((PropertyDescriptor)new StructureProperty(OBSERVATION_DATE_TIME_VALUE, (StructureDefinition)dateTimeValue));
        observationsValue.addAttribute((PropertyDescriptor)new StructureListProperty(OBSERVATION_PERIOD_VALUES, (StructureDefinition)periodValue));
        observations.addAttribute((PropertyDescriptor)new StringProperty(OBSERVATION_TYPE));
        observations.addAttribute((PropertyDescriptor)new StructureListProperty(OBSERVATION_VALUES, (StructureDefinition)observationsValue));
        dataTimeColumns.put(Storage.DATE, "IDS_TCM_FORCASTING_DATE_LABEL");
        dataTimeColumns.put(Storage.TIME, "IDS_TCM_FORCASTING_DATETIME_LABEL");
        dataTimeColumns.put(Storage.TIMESTAMP, "IDS_TCM_FORCASTING_TIME_LABEL");
        dataTimeFormaters.put(Storage.DATE, DATE_FORMATTER);
        dataTimeFormaters.put(Storage.TIME, TIME_FORMATTER);
        dataTimeFormaters.put(Storage.TIMESTAMP, DATE_TIME_FORMATTER);
    }
}

