/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import com.spss.uitools.res.UIToolResUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.table.AbstractTableModel;

public class DateTimeTableModel
extends AbstractTableModel {
    private DateTimeTableInfo mDateTimeTableInfo;
    protected Long mDefaultStartTime = null;
    protected Long mDefaultEndTime = null;
    boolean mIsEditable = true;
    ResourceBundle mResourceBundle;

    public DateTimeTableModel(ResourceBundle resourceBundle, TCMForecastGatingInfo tCMForecastGatingInfo) {
        this(resourceBundle, tCMForecastGatingInfo, true);
    }

    public DateTimeTableModel(ResourceBundle resourceBundle, TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
        this.mResourceBundle = resourceBundle;
        this.initDateTimeTableInfo(tCMForecastGatingInfo, bl);
        this.saveDefaultDateTimeInfo(this.getDateTimeTableInfo());
    }

    public DateTimeTableModel(ResourceBundle resourceBundle, DateTimeTableInfo dateTimeTableInfo) {
        this.mResourceBundle = resourceBundle;
        this.saveDateTimTableInfo(dateTimeTableInfo);
        this.saveDefaultDateTimeInfo(this.getDateTimeTableInfo());
    }

    protected void initDateTimeTableInfo(TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
        DateTimeTableInfo dateTimeTableInfo = new DateTimeTableInfo(tCMForecastGatingInfo, bl);
        this.saveDateTimTableInfo(dateTimeTableInfo);
    }

    protected void saveDateTimTableInfo(DateTimeTableInfo dateTimeTableInfo) {
        this.mDateTimeTableInfo = dateTimeTableInfo;
    }

    protected void saveDefaultDateTimeInfo(DateTimeTableInfo dateTimeTableInfo) {
        this.mDefaultStartTime = dateTimeTableInfo.getStartTime();
        this.mDefaultEndTime = dateTimeTableInfo.getEndTime();
    }

    public void setEditable(boolean bl) {
        this.mIsEditable = bl;
    }

    @Override
    public int getRowCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        if (n > 0) {
            SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType = this.getDateTimeTableInfo().getSimpleDateTimeType();
            string = simpleDateTimeType == SpssDateFormatHelper.SimpleDateTimeType.DATE ? this.getLabel("IDS_TCM_FORCASTING_DATE_LABEL") : (simpleDateTimeType == SpssDateFormatHelper.SimpleDateTimeType.TIME ? this.getLabel("IDS_TCM_FORCASTING_TIME_LABEL") : (simpleDateTimeType == SpssDateFormatHelper.SimpleDateTimeType.DATETIME ? this.getLabel("IDS_TCM_FORCASTING_DATE_AND_TIME_LABEL") : "error unknown date_time type"));
        }
        return string;
    }

    public String getRowName(int n) {
        String string = "";
        string = n == 0 ? this.getLabel("IDS_TCM_FORCASTING_START_ROW_NAME") : this.getLabel("IDS_TCM_FORCASTING_END_ROW_NAME");
        return string;
    }

    private String getLabel(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return string2 == null ? "" : string2;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    public DateTimeTableInfo getDateTimeTableInfo() {
        return this.mDateTimeTableInfo;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Long l = null;
        if (n2 == 0) {
            return this.getRowName(n);
        }
        l = n == 0 ? this.getDateTimeTableInfo().getStartTime() : this.getDateTimeTableInfo().getEndTime();
        return l;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 > 0) {
            if (object != null && object instanceof Date) {
                Date date = (Date)object;
                if (date != null) {
                    if (n == 0) {
                        this.getDateTimeTableInfo().setStartTime(date.getTime());
                    } else if (n == 1) {
                        this.getDateTimeTableInfo().setEndTime(date.getTime());
                    }
                }
            } else if (n == 0) {
                this.getDateTimeTableInfo().setStartTime(null);
            } else if (n == 1) {
                this.getDateTimeTableInfo().setEndTime(null);
            }
        }
    }

    public String formatDateValue(Date date) {
        SimpleDateFormat simpleDateFormat = this.getDateTimeFormatter();
        return simpleDateFormat.format(date);
    }

    public String formatDateValueToISO8601(Date date, SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType) {
        SimpleDateFormat simpleDateFormat = TCMUtilities.getISO8601DateTimeFormatter(simpleDateTimeType);
        return simpleDateFormat.format(date);
    }

    public SimpleDateFormat getDateTimeFormatter() {
        String string = this.getDateTimeTableInfo().getDateTimePattern();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMC"));
        return simpleDateFormat;
    }

    public String getUserExampleDateTimePattern() {
        return this.getDateTimeTableInfo().getLocalizedDisplayDateTimePattern();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0 && this.mIsEditable;
    }

    private Long getLongValue(Object object) {
        long l = 1L;
        if (object instanceof String) {
            l = Long.parseLong((String)object);
        } else if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Float) {
            l = ((Float)object).longValue();
        } else if (object instanceof Double) {
            l = ((Double)object).longValue();
        }
        return l > 1L ? l : 1L;
    }

    public void reset() {
        this.getDateTimeTableInfo().setStartTime(this.mDefaultStartTime);
        this.getDateTimeTableInfo().setEndTime(this.mDefaultEndTime);
        this.fireTableDataChanged();
    }

    public class DateTimeTableInfo
    implements Cloneable {
        protected Long mStartTime = null;
        protected Long mEndTime = null;
        SpssDateFormatHelper.SimpleDateTimeType mSimpleDateTimeType;
        String mLocalizedDisplayDateTimePattern = null;
        String mSPSSDateTimeFormatKey = null;
        String mDateTimePattern;

        public DateTimeTableInfo(TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
            this.init(tCMForecastGatingInfo, bl);
        }

        protected void init(TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
            if (bl) {
                this.mStartTime = tCMForecastGatingInfo.getDateTimeInfo().getStartTime();
                this.mEndTime = tCMForecastGatingInfo.getDateTimeInfo().getEndTime();
            }
            this.mSimpleDateTimeType = tCMForecastGatingInfo.getDateTimeInfo().getDateTimeType();
            this.mLocalizedDisplayDateTimePattern = tCMForecastGatingInfo.getDateTimeInfo().getLocalizedDateTimeFormatString();
            this.mSPSSDateTimeFormatKey = tCMForecastGatingInfo.getDateTimeInfo().getSPSSDateTimeFormatKey();
            this.mDateTimePattern = tCMForecastGatingInfo.getDateTimeInfo().getDateTimePattern();
        }

        public boolean areAllStartEndPeriodsDefined() {
            return this.getStartTime() != null && this.getEndTime() != null;
        }

        public boolean isStartBeforeEndPeriod() {
            return this.getStartTime() != null && this.getEndTime() != null && this.getStartTime() <= this.getEndTime();
        }

        public boolean isStartEqualToEndPeriod() {
            return this.getStartTime() != null && this.getEndTime() != null && this.getStartTime().longValue() == this.getEndTime().longValue();
        }

        public SpssDateFormatHelper.SimpleDateTimeType getSimpleDateTimeType() {
            return this.mSimpleDateTimeType;
        }

        public Long getStartTime() {
            return this.mStartTime;
        }

        public void setStartTime(Long l) {
            this.mStartTime = l;
        }

        public Long getEndTime() {
            return this.mEndTime;
        }

        public void setEndTime(Long l) {
            this.mEndTime = l;
        }

        public String getLocalizedDisplayDateTimePattern() {
            return this.mLocalizedDisplayDateTimePattern;
        }

        public String getSPSSDateTimeFormat() {
            return this.mSPSSDateTimeFormatKey;
        }

        public String getDateTimePattern() {
            return this.mDateTimePattern;
        }

        public Object clone() {
            DateTimeTableInfo dateTimeTableInfo = null;
            try {
                dateTimeTableInfo = (DateTimeTableInfo)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            return dateTimeTableInfo;
        }
    }
}

