/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.ui.dialogs.TCM.controls_models.DateTimeTableModel;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;

public class DateTimeTable
extends JTable
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private DateTimeTableModel model;
    private boolean initialized = false;

    public DateTimeTable(DateTimeTableModel dateTimeTableModel) {
        super(dateTimeTableModel);
        this.model = dateTimeTableModel;
        this.setOptions();
        this.setColumnsRender();
        this.setColumnsEditor();
        this.initialized = true;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.initialized && tableModelEvent.getType() == 0) {
            this.setColumnsRender();
            this.setColumnsEditor();
        }
    }

    private void setOptions() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        this.setRowHeight(20);
        this.addMouseMotionListener(this);
    }

    public void stopTableEditing() {
        TCMUtilities.stopTableEditing(this);
    }

    private void setColumnsRender() {
        DateTimeTableCellRenderer dateTimeTableCellRenderer = new DateTimeTableCellRenderer();
        this.getColumnModel().getColumn(1).setCellRenderer(dateTimeTableCellRenderer);
    }

    private void setColumnsEditor() {
        for (int i = 1; i < this.model.getColumnCount(); ++i) {
            JTextField jTextField = new JTextField();
            this.getColumnModel().getColumn(1).setCellEditor(new DateCellEditor(jTextField));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean isControlEnabled() {
        return this.isEnabled();
    }

    public void setControlEnabled(boolean bl) {
        this.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void refresh() {
        this.model.fireTableStructureChanged();
    }

    public class IntegerCellEditor
    extends DefaultCellEditor {
        private JTextField textField;

        public IntegerCellEditor(JTextField jTextField) {
            super(jTextField);
            this.textField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            if (string.trim().length() > 0) {
                Long l;
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    l = null;
                }
                return l;
            }
            return string;
        }
    }

    public class DateCellEditor
    extends DefaultCellEditor {
        private JTextField mTextField;
        private SimpleDateFormat mForamatter;

        public DateCellEditor(JTextField jTextField) {
            super(jTextField);
            this.mTextField = jTextField;
            this.mForamatter = DateTimeTable.this.model.getDateTimeFormatter();
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.mTextField.getText();
            if (string.trim().length() > 0) {
                try {
                    Date date = this.mForamatter.parse(string.trim());
                    return date;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            Date date = null;
            if (object instanceof Date) {
                date = (Date)object;
            } else if (object instanceof Long) {
                date = new Date((Long)object);
            }
            if (date != null) {
                this.mTextField.setText(this.mForamatter.format(date));
            }
            return component;
        }
    }

    public class DateTimeTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Long) {
                Date date = new Date((Long)object);
                if (date != null) {
                    String string = DateTimeTable.this.model.formatDateValue(date);
                    this.setText(string);
                }
                this.setForeground(Color.BLACK);
            } else {
                String string = DateTimeTable.this.model.getUserExampleDateTimePattern();
                this.setText(string);
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }
}

