/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.ui.dialogs.TCM.controls_models.CyclicPeriodModel;
import com.spss.java_client.ui.dialogs.TCM.controls_models.EstimationPeriodModel;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;

public class CyclicPeriodTable
extends JTable
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private CyclicPeriodModel model;
    private boolean initialized = false;
    public static final String DATE_TOOLTIP = "observationsTimes.date";
    public static final String TIME_TOOLTIP = "observationsTimes.time";
    public static final String DATE_TIME_TOOLTIP = "observationsTimes.dateTime";
    public static final String[] PERIOD_TOOLTIP = new String[]{"observationspPeriod.start", "observationspPeriod.end"};

    public CyclicPeriodTable(CyclicPeriodModel cyclicPeriodModel) {
        super(cyclicPeriodModel);
        this.model = cyclicPeriodModel;
        this.setOptions();
        this.setColumnsRender();
        this.setColumnsEditor();
        this.initialized = true;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
    }

    private void setOptions() {
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(true);
        this.setRowHeight(20);
        this.addMouseMotionListener(this);
    }

    private void setColumnsRender() {
        int n = this.getColumnModel().getColumnCount();
        for (int i = 1; i < n; ++i) {
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (object instanceof Long) {
                        String string = object == EstimationPeriodModel.DEFAULT_PERIOD_VALUE ? "" : object.toString();
                        this.setText(string);
                        if (CyclicPeriodTable.this.model.validatePeriodValueForColumn((Long)object, n2)) {
                            this.setForeground(Color.BLACK);
                        } else {
                            this.setForeground(Color.RED);
                        }
                    } else {
                        this.setForeground(Color.RED);
                    }
                    return this;
                }
            };
            this.getColumnModel().getColumn(i).setCellRenderer(defaultTableCellRenderer);
        }
    }

    private void setColumnsEditor() {
        for (int i = 1; i < this.model.getColumnCount(); ++i) {
            JTextField jTextField = new JTextField();
            this.getColumnModel().getColumn(i).setCellEditor(new IntegerCellEditor(jTextField));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean isControlEnabled() {
        return this.isEnabled();
    }

    public void setControlEnabled(boolean bl) {
        this.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void stopTableEditing() {
        TCMUtilities.stopTableEditing(this);
    }

    public void refresh() {
        this.model.fireTableStructureChanged();
    }

    public class IntegerCellEditor
    extends DefaultCellEditor {
        private JTextField textField;

        public IntegerCellEditor(JTextField jTextField) {
            super(jTextField);
            this.textField = jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.textField.getText();
            if (string.trim().length() > 0) {
                Long l;
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    l = null;
                }
                return l;
            }
            return string;
        }
    }
}

