/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.controls_models;

import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.uitools.res.UIToolResUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class CyclicPeriodModel
extends AbstractTableModel {
    private CyclicTableModelInfo mCyclicTableModelInfo;
    private TCMForecastGatingInfo mTCMForecastGatingInfo;
    boolean mIsEditable = true;
    ResourceBundle mResourceBundle;

    public CyclicPeriodModel(ResourceBundle resourceBundle, TCMForecastGatingInfo tCMForecastGatingInfo) {
        this(resourceBundle, tCMForecastGatingInfo, true);
    }

    public CyclicPeriodModel(ResourceBundle resourceBundle, TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
        this.mResourceBundle = resourceBundle;
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.initCyclicTableInfo(tCMForecastGatingInfo, bl);
    }

    public CyclicPeriodModel(ResourceBundle resourceBundle, CyclicTableModelInfo cyclicTableModelInfo) {
        this.mResourceBundle = resourceBundle;
        this.saveCyclicTableModelInfo(cyclicTableModelInfo);
    }

    protected void initCyclicTableInfo(TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
        CyclicTableModelInfo cyclicTableModelInfo = new CyclicTableModelInfo(tCMForecastGatingInfo, bl);
        this.saveCyclicTableModelInfo(cyclicTableModelInfo);
    }

    protected void saveCyclicTableModelInfo(CyclicTableModelInfo cyclicTableModelInfo) {
        this.mCyclicTableModelInfo = cyclicTableModelInfo;
    }

    public void setEditable(boolean bl) {
        this.mIsEditable = bl;
    }

    @Override
    public int getRowCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        if (n > 0 && (string = this.getCyclicTableModelInfo().getCyclicNames().get(n - 1)).equals("$casecount")) {
            string = this.getLabel("IDS_TCM_CASECOUNT_DISPLAY_LABEL");
        }
        return string;
    }

    private String getLabel(String string) {
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)string);
        return string2 == null ? "" : string2;
    }

    @Override
    public int getColumnCount() {
        return this.getNumCycleColumns() + 1;
    }

    private int getNumCycleColumns() {
        return this.getCyclicTableModelInfo().getCyclicNames().size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? String.class : Long.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Long l = -1L;
        if (n2 == 0) {
            return this.getRowName(n);
        }
        String string = this.getCyclicTableModelInfo().getCyclicNames().get(n2 - 1);
        l = n == 0 ? this.getCyclicTableModelInfo().getCyclicNameToStartValueMap().get(string) : this.getCyclicTableModelInfo().getCyclicNameToEndValueMap().get(string);
        return l;
    }

    public String getRowName(int n) {
        String string = "";
        string = n == 0 ? this.getLabel("IDS_TCM_FORCASTING_START_ROW_NAME") : this.getLabel("IDS_TCM_FORCASTING_END_ROW_NAME");
        return string;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 > 0) {
            String string = this.getCyclicTableModelInfo().getCyclicNames().get(n2 - 1);
            if (n == 0) {
                try {
                    Long l = this.getLongValue(object);
                    this.getCyclicTableModelInfo().getCyclicNameToStartValueMap().put(string, l);
                }
                catch (Exception exception) {}
            } else {
                try {
                    Long l = this.getLongValue(object);
                    this.getCyclicTableModelInfo().getCyclicNameToEndValueMap().put(string, l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0 && this.mIsEditable;
    }

    protected Long getLongValue(Object object) {
        long l = 1L;
        if (object instanceof String) {
            l = Long.parseLong((String)object);
        } else if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof Float) {
            l = ((Float)object).longValue();
        } else if (object instanceof Double) {
            l = ((Double)object).longValue();
        }
        return l > 1L ? l : 1L;
    }

    public boolean validatePeriodValueForColumn(Long l, int n) {
        boolean bl = true;
        if (n > 0) {
            String string = this.getColumnName(n);
            bl = this.validateCyclePeriodValue(string, l);
        }
        return bl;
    }

    public boolean validateCyclePeriodValue(String string, Long l) {
        return this.validateCyclePeriodValue(string, l, this.getCyclicTableModelInfo().getCyclicNameToToRangeStartMap(), this.getCyclicTableModelInfo().getCyclicNameToToRangeEndMap());
    }

    public boolean validateCyclePeriodValue(String string, Long l, HashMap<String, Long> hashMap, HashMap<String, Long> hashMap2) {
        boolean bl = true;
        if (string != null) {
            boolean bl2 = hashMap != null && hashMap.get(string) != null;
            Long l2 = hashMap != null ? hashMap.get(string) : null;
            Long l3 = hashMap2 != null ? hashMap2.get(string) : null;
            Long l4 = this.getCyclicTableModelInfo().getIncrement();
            if (!bl2 && l % l4 != 0L) {
                bl = false;
            } else if (bl2 && (l % l4 != 0L || l < l2 || l > l3)) {
                bl = false;
            }
        }
        return bl;
    }

    public void reset() {
        this.getCyclicTableModelInfo().reset(this.mTCMForecastGatingInfo);
        this.fireTableDataChanged();
    }

    public CyclicTableModelInfo getCyclicTableModelInfo() {
        return this.mCyclicTableModelInfo;
    }

    public class CyclicTableModelInfo
    implements Cloneable {
        public HashMap<String, Long> mCyclicNameToStartValueMap = new HashMap();
        public HashMap<String, Long> mCyclicNameToEndValueMap = new HashMap();
        public HashMap<String, Long> mCycleNameToRangeStartMap = new HashMap();
        public HashMap<String, Long> mCycleNameToRangeEndMap = new HashMap();
        long mIncrement = 1L;
        boolean mSetDefaultStartEndTimes;
        ArrayList<String> mCyclicNames = new ArrayList();

        public CyclicTableModelInfo(TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
            this.init(tCMForecastGatingInfo, bl);
        }

        protected void init(TCMForecastGatingInfo tCMForecastGatingInfo, boolean bl) {
            String string;
            int n;
            this.mCyclicNameToStartValueMap = new HashMap();
            this.mCyclicNameToEndValueMap = new HashMap();
            this.mCyclicNames = new ArrayList();
            TCMForecastGatingInfo.CyclicInfo cyclicInfo = tCMForecastGatingInfo.getCyclicInfo();
            ArrayList<String> arrayList = cyclicInfo.getCyclicFieldNames();
            for (n = 0; n < arrayList.size(); ++n) {
                string = arrayList.get(n);
                this.mCyclicNames.add(string);
            }
            this.mSetDefaultStartEndTimes = bl;
            this.mCycleNameToRangeStartMap = cyclicInfo.getCycleNameToRangeStartMap();
            this.mCycleNameToRangeEndMap = cyclicInfo.getCycleNameToRangeEndMap();
            this.mIncrement = cyclicInfo.getIncrement();
            if (bl) {
                for (n = 0; n < arrayList.size(); ++n) {
                    string = arrayList.get(n);
                    this.mCyclicNameToStartValueMap.put(string, tCMForecastGatingInfo.getCyclicInfo().getStartValueForCycleName(string));
                    this.mCyclicNameToEndValueMap.put(string, tCMForecastGatingInfo.getCyclicInfo().getEndValueForCycleName(string));
                }
            } else {
                this.mCyclicNameToStartValueMap = new HashMap();
                this.mCyclicNameToEndValueMap = new HashMap();
            }
        }

        public void reset(TCMForecastGatingInfo tCMForecastGatingInfo) {
            this.init(CyclicPeriodModel.this.mTCMForecastGatingInfo, this.mSetDefaultStartEndTimes);
        }

        public ArrayList<String> getCyclicNames() {
            return this.mCyclicNames;
        }

        public HashMap<String, Long> getCyclicNameToStartValueMap() {
            return this.mCyclicNameToStartValueMap;
        }

        public HashMap<String, Long> getCyclicNameToEndValueMap() {
            return this.mCyclicNameToEndValueMap;
        }

        public HashMap<String, Long> getCyclicNameToToRangeStartMap() {
            return this.mCycleNameToRangeStartMap;
        }

        public HashMap<String, Long> getCyclicNameToToRangeEndMap() {
            return this.mCycleNameToRangeEndMap;
        }

        public long getIncrement() {
            return this.mIncrement;
        }

        public boolean areAllStartEndPeriodsDefined() {
            boolean bl = true;
            for (String string : this.getCyclicNames()) {
                if (this.getCyclicNameToStartValueMap().get(string) != null && this.getCyclicNameToEndValueMap().get(string) != null) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public boolean isStartBeforeEndPeriod() {
            ArrayList<Long> arrayList;
            boolean bl = false;
            ArrayList<Long> arrayList2 = this.getCyclicNameToStartValueMap() != null ? TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.getCyclicNameToStartValueMap()) : null;
            ArrayList<Long> arrayList3 = arrayList = this.getCyclicNameToEndValueMap() != null ? TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.getCyclicNameToEndValueMap()) : null;
            if (arrayList2 == null || arrayList == null || TCMForecastGatingInfo.CyclicInfo.compareCyclicPeriods(arrayList2, arrayList) <= 0) {
                bl = true;
            }
            return bl;
        }

        public boolean isStartEqualToEndPeriod() {
            ArrayList<Long> arrayList;
            boolean bl = false;
            ArrayList<Long> arrayList2 = this.getCyclicNameToStartValueMap() != null ? TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.getCyclicNameToStartValueMap()) : null;
            ArrayList<Long> arrayList3 = arrayList = this.getCyclicNameToEndValueMap() != null ? TCMForecastGatingInfo.getCyclicValues(this.mCyclicNames, this.getCyclicNameToEndValueMap()) : null;
            if (arrayList2 == null || arrayList == null || TCMForecastGatingInfo.CyclicInfo.compareCyclicPeriods(arrayList2, arrayList) == 0) {
                bl = true;
            }
            return bl;
        }

        public boolean areAllPeriodsValidValues() {
            boolean bl = true;
            for (String string : this.getCyclicNames()) {
                Long l = this.getCyclicNameToStartValueMap().get(string);
                Long l2 = this.getCyclicNameToEndValueMap().get(string);
                boolean bl2 = CyclicPeriodModel.this.validateCyclePeriodValue(string, l);
                boolean bl3 = CyclicPeriodModel.this.validateCyclePeriodValue(string, l2);
                if (bl2 && bl3) continue;
                bl = false;
            }
            return bl;
        }
    }
}

