/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.TCM.BuildOptionTab;
import com.spss.java_client.ui.dialogs.TCM.DataSpecificationTab;
import com.spss.java_client.ui.dialogs.TCM.FieldsTab;
import com.spss.java_client.ui.dialogs.TCM.ModelOptionTab;
import com.spss.java_client.ui.dialogs.TCM.ModelTab;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.vis.maptool.DataBundle;
import com.spss.vis.maptool.EsriShapefileReader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumnModel;

public class TemporalCausalModeling
extends BaseTabbedDialog {
    private ModelTab mModelTab;
    private DataSpecificationTab mDataSpecTab;
    private FieldsTab mFieldTab;
    private BuildOptionTab mBuildOptionTab;
    private ModelOptionTab mModelOptionTab;

    public TemporalCausalModeling(JFrame jFrame) {
        super(jFrame, false, TCMResBundle.getDefaultResourceBundleName(), TCMResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TCM_MODEL_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    public static void setSelectionText(JComponent jComponent) {
        TemporalCausalModeling.setSelectionText(jComponent, 0);
    }

    public static void setSelectionText(final JComponent jComponent, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jComponent.requestFocusInWindow();
            }
        });
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setSelectionStart(n);
            ((JTextField)jComponent).setSelectionEnd(((JTextField)jComponent).getText().length());
        }
    }

    public static String[] showOpenFileDialog(BaseDialog baseDialog, String string, String[] stringArray, String[] stringArray2) {
        int n;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileSelectionMode(0);
        for (n = 1; n < stringArray.length; ++n) {
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(stringArray[n], stringArray2[n]));
        }
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(stringArray[0], stringArray2[0]));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        n = remoteFileChooser.showOpenDialog((Component)baseDialog);
        if (n == 0) {
            String string2 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            return new String[]{string2, remoteFileChooser.getSelectedFileName()};
        }
        return null;
    }

    public static JPanel createButtonsPanel(JButton[] jButtonArray) {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 0;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n3, n3, n3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        for (n2 = 0; n2 < jButtonArray.length; ++n2) {
            if (n2 == jButtonArray.length - 1) {
                gridBagConstraints.weighty = 1.0;
                insets.set(n3 * 4, n3, n3, n3);
            }
            DialogUtil.addUsingGBL(jPanel, jButtonArray[n2], gridBagConstraints, 0, n2, 1, 1, n, insets);
        }
        return jPanel;
    }

    public String showSaveDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(this.getResString("IDS_MI_IMPUTE_MISSING_SAVE_DIALOG_TITLE"));
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_MI_IMPUTE_MISSING_FILE_FILTER"), this.getResString("IDS_MI_IMPUTE_MISSING_FILE_FILTER_EXTN")));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            String string = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            int n2 = string.indexOf(this.getResString("IDS_MI_IMPUTE_MISSING_FILE_FILTER_EXTN"));
            if (n2 == -1) {
                string = string.concat(this.getResString("IDS_MI_IMPUTE_MISSING_FILE_FILTER_EXTN"));
            }
            return string;
        }
        return "";
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("*Prepare Maps for Spatio Temporal Modeling.");
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        return true;
    }

    @Override
    public String getIActionKey() {
        return "analyze_temporal_causal_modeling_model";
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    public void reset() {
        Object[] objectArray = this.getResStringArray("IDS_MI_IMPUTE_MISSING_RESET_BUTTON_LABELS");
        int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_MI_IMPUTE_MISSING_WARNING2"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
    }

    public static String getAttributes(String string) {
        String[] stringArray;
        DataBundle dataBundle = null;
        String string2 = "";
        try {
            stringArray = string.substring(0, string.length() - 4) + ".dbf";
            dataBundle = EsriShapefileReader.loadDataFile((File)new File((String)stringArray));
        }
        catch (IOException iOException) {
            return "";
        }
        stringArray = dataBundle.getAttributeNames();
        if (stringArray == null) {
            return "";
        }
        int n = 0;
        for (String string3 : stringArray) {
            string2 = string2 + stringArray[n++];
            if (n >= stringArray.length) continue;
            string2 = string2 + "; ";
        }
        return string2;
    }

    static void setupColumnWidths(JTable jTable, double[] dArray) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (dArray == null || tableColumnModel.getColumnCount() != dArray.length) {
            return;
        }
        int n = jTable.getPreferredScrollableViewportSize().width;
        int n2 = 0;
        for (double d : dArray) {
            tableColumnModel.getColumn(n2).setPreferredWidth((int)((double)n * d));
            ++n2;
        }
    }

    @Override
    protected void init() {
        super.init();
        this.mModelTab = new ModelTab(this);
        this.addTab(this.getResString("IDS_TCM_MODEL_TAB_TITLE"), this.mModelTab);
        this.mDataSpecTab = new DataSpecificationTab(this);
        this.addTab(this.getResString("IDS_TCM_DATA_SPEC_TAB_TITLE"), this.mDataSpecTab);
        this.mFieldTab = new FieldsTab(this);
        this.addTab(this.getResString("IDS_TCM_FIELDS_TAB_TITLE"), this.mFieldTab);
        this.mBuildOptionTab = new BuildOptionTab(this);
        this.addTab(this.getResString("IDS_TCM_BUILD_OPTION_TAB_TITLE"), this.mBuildOptionTab);
        this.mModelOptionTab = new ModelOptionTab(this);
        this.addTab(this.getResString("IDS_TCM_MODEL_OPTION_TAB_TITLE"), this.mModelOptionTab);
        this.pack();
    }
}

