/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.TCM.TimeSeriesCommonAlertDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class TSEAlertDlg
extends TimeSeriesCommonAlertDlg {
    public static final String TSE_SELECTED_SERIES = "TSE_SELECTED_SERIES";
    private SrcVariableList mSrcVarList;
    private JLabel mSourceListLabel;
    private TargetVariableList mTargetVarList;
    private JLabel mTargetListLabel;
    private ArrowButton mArrowButton;
    private ListTravArrowButtonFactory mArrowButtonTarget;

    public TSEAlertDlg(JFrame jFrame, ResourceBundle resourceBundle, Vector<String> vector) {
        super(jFrame, resourceBundle, resourceBundle.getString("IDS_TCM_GATING_DLG_INFO_MESSAGE"), resourceBundle.getString("IDS_TSE_MODEL_TITLE"), vector);
    }

    @Override
    protected JRadioButton createMultiLineRadio(int n) {
        return new SpssMultiLineRadioButton(new ToggleButtonAction(this, "IDS_TSE_GATING_MULTI_TS_RADIO"), n);
    }

    @Override
    protected void initDataPanelVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSourceListLabel = DialogUtil.createLabel(this, "IDS_TCM_DATA_STRUC_SOURCE_LABEL");
        this.mSourceListLabel.setLabelFor(this.mSrcVarList);
        this.mTargetListLabel = DialogUtil.createLabel(this, "IDS_TCM_DATA_STRUC_TARGET_LABEL");
        this.mTargetVarList = new TargetVariableList();
        this.mTargetListLabel.setLabelFor(this.mTargetVarList);
        this.mTargetVarList.setMaxLimitOfList(500);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setSelectionMode(0);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonTarget = new ListTravArrowButtonFactory(this.mTargetVarList, false);
    }

    @Override
    protected void enableDataControls() {
        if (this.mMultiTSRadio.isSelected()) {
            this.mSrcVarList.setEnabled(true);
            this.mSourceListLabel.setEnabled(true);
            this.mTargetListLabel.setEnabled(true);
            this.mTargetVarList.setEnabled(true);
            this.mArrowButton.setEnabled(true);
            this.mArrowButtonTarget.getDownArrowButton().setEnabled(true);
            this.mArrowButtonTarget.getUpArrowButton().setEnabled(true);
        } else {
            this.mSrcVarList.setEnabled(false);
            this.mSourceListLabel.setEnabled(false);
            this.mTargetListLabel.setEnabled(false);
            this.mTargetVarList.setEnabled(false);
            this.mArrowButton.setEnabled(false);
            this.mArrowButtonTarget.getDownArrowButton().setEnabled(false);
            this.mArrowButtonTarget.getUpArrowButton().setEnabled(false);
        }
    }

    @Override
    protected JPanel setupDataControlPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDataStrucInfo), gridBagConstraints, 0, 0, 4, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSingleTSRadio, gridBagConstraints, 0, 1, 4, 1, n, insets);
        insets.set(n2, n2, n2 * 3, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMultiTSRadio, gridBagConstraints, 0, 2, 4, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSourceListLabel, gridBagConstraints, 0, 3, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 4, 1, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTargetListLabel, gridBagConstraints, 2, 3, 2, 1, n, insets);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 7 + 2));
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 4, 1, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonTarget.getArrowButtonPanel(), gridBagConstraints, 3, 4, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        VarListModel varListModel = this.mTargetVarList.getModel();
        dialogDataModel.putObject(TSE_SELECTED_SERIES, varListModel);
    }

    @Override
    protected String getIActionKey() {
        return "analyze_time_series_exploration";
    }
}

