/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.pasw.framework.common.core.Structure;
import com.spss.datamodel.BaseFieldContent;
import com.spss.datamodel.DataModel;
import com.spss.datamodel.Field;
import com.spss.datamodel.Fields;
import com.spss.datamodel.Measure;
import com.spss.datamodel.Storage;
import com.spss.datamodel.ValidValue;
import com.spss.datamodel.ValidValues;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.ASMapsError;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.cf_integration.action.CFCommandAction;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VarManualReorderPanel;
import com.spss.java_client.ui.controls.VarSourceSortingPanel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.VariableSelectorPanel;
import com.spss.java_client.ui.dialogs.TCM.DateVarUtil;
import com.spss.java_client.ui.dialogs.TCM.TCMDontShowMessageAgainErrorDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMSelectDimensionValuesDlg;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMSelectDimensionValuesInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMSrcVariableList;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DefineVariablesAlertDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TCMModelGatingDlg
extends BaseGatingDialog {
    private static final String SRC_VAR_LIST = "IDS_TCM_GATING_SRC_VARLIST";
    static final String TARGET_LIST_KEY = "IDS_TCM_GATING_TARGET_LIST";
    JFrame mParentFrame;
    protected InteractiveCallInfo mLastInteractiveCallInfo;
    protected TCMSrcVariableList mSrcVariableList;
    protected JScrollPane mSrcScrollPane;
    protected JLabel mSrcListLabel;
    VariableSelectorPanel mSelectorPanel;
    protected JPanel mFieldsAndDimensionsPanel;
    VarSourceSortingPanel mSortPanel;
    VarManualReorderPanel mVarManualOrderPanel;
    JPanel mDimensionsPanel;
    protected JCheckBox mIsDateTimeCheckBox;
    protected JLabel mDateTimeComboLabel;
    protected JComboBox mDateTimeComboBox;
    protected JButton mSpecifySubsetButton;
    protected FocusableTextArea mInfoText;
    protected JCheckBox mSpecifyAnyDimFieldsRequiredCheckbox;
    protected String mNextActionKey = "";
    private JLabel mDimVarListLabel;
    protected TargetVariableList mTargetVarList;
    private ArrowButton mDimArrowButton;
    private Hashtable<String, String> mDateTimeVarNameLabels;
    TCMSelectDimensionValuesInfo mSelectDimensionValuesInfo;
    HashMap<String, ArrayList<String>> mMasterFieldNameToDimensionValuesMap = new HashMap();
    HashMap<String, String> mMasterTimeFieldNameToTimeIntervalMap = new HashMap();
    Hashtable<String, TCMSelectDimensionValuesInfo> mDimensionToSpecifySubsetInfoMap;
    static LocallyUniqueId.LocallyUniqueIDGenerator sIdGenerator = new LocallyUniqueId.LocallyUniqueIDGenerator(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
    private JCheckBox mEnableCustomizationCheckbox;
    private JLabel mMaxNumDistinctValuesPerDimLabel;
    private IntTextField mMaxNumDistinctValuesPerDimTextField;
    private DateVarUtil mDateUtil;
    private String mDateSpec;
    private String[] mDateSpecVarNames;
    private ArrayList<Structure> mDateVarNameAndPeriod;

    public TCMModelGatingDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, TCMResBundle.getDefaultResourceBundleName(), TCMResBundle.getImageFolder());
        this.mParentFrame = jFrame;
        this.setTitle(this.getResString("IDS_TCM_GATING_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.processEnableControls();
        this.checkInternalDateVar();
    }

    private HashMap<String, ArrayList<String>> createDimensionNameToDimensionValuesMap(DataModel dataModel) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        Fields fields = dataModel.getFields();
        for (Field field : fields) {
            ArrayList<String> arrayList = this.getCategoryValues(field);
            hashMap.put(field.getName(), arrayList);
        }
        return hashMap;
    }

    private HashMap<String, Storage> createDimensionNameToStorageTypeMap(DataModel dataModel) {
        HashMap<String, Storage> hashMap = new HashMap<String, Storage>();
        Fields fields = dataModel.getFields();
        for (Field field : fields) {
            hashMap.put(field.getName(), field.getStorage());
        }
        return hashMap;
    }

    private ArrayList<String> getCategoryValues(Field field) {
        BaseFieldContent baseFieldContent = field.getBaseFieldContent();
        ValidValues validValues = baseFieldContent.getValues();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (validValues != null) {
            for (ValidValue validValue : validValues) {
                String string = validValue.getValue();
                if (string == null || string.length() <= 0) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private ArrayList<ISpssVariable> createVariablesFromDataModel(DataModel dataModel) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        Fields fields = dataModel.getFields();
        while (fields.iterator().hasNext()) {
            Field field = (Field)fields.iterator().next();
            SpssVariable spssVariable = new SpssVariable();
            spssVariable.setName(field.getName());
            MeasurementLevel measurementLevel = this.convertFieldMeasureToMeasurementLevel(field);
            spssVariable.setMeasurementLevel(measurementLevel);
            spssVariable.setLabel(field.getName());
            BaseFieldContent baseFieldContent = field.getBaseFieldContent();
            ValidValues validValues = baseFieldContent.getValues();
            spssVariable.setId(sIdGenerator.next());
            arrayList.add((ISpssVariable)spssVariable);
        }
        return arrayList;
    }

    private MeasurementLevel convertFieldMeasureToMeasurementLevel(Field field) {
        Measure measure = field.getMeasure();
        MeasurementLevel measurementLevel = MeasurementLevel.unknown;
        switch (measure) {
            case UNKNONWN: {
                measurementLevel = MeasurementLevel.unknown;
                break;
            }
            case CONTINUOUS: {
                measurementLevel = MeasurementLevel.scale;
                break;
            }
            case NOMINAL: 
            case FLAG: 
            case DISCRETE: 
            case TYPELESS: {
                measurementLevel = MeasurementLevel.nominal;
                break;
            }
            case ORDINAL: {
                measurementLevel = MeasurementLevel.ordinal;
                break;
            }
            default: {
                measurementLevel = MeasurementLevel.unknown;
            }
        }
        return measurementLevel;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_tcm_howto";
    }

    @Override
    public String getIActionKey() {
        return "analyze_tcm_model_gating_dialog";
    }

    @Override
    public boolean continuePressed() {
        AbstractList abstractList;
        Object object;
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = this.mDateTimeComboBox.getModel().getSize() > 1;
        ArrayList<ISpssVariable> arrayList = this.getSelectedDims();
        String string = this.getTimeInterval();
        boolean bl4 = !PrefsMgr.getPrefsMgr().getDialogBooleanPref("tcm_model_gating", "dont_show_tcm_model_gating_1");
        boolean bl5 = bl = !PrefsMgr.getPrefsMgr().getDialogBooleanPref("tcm_model_gating", "dont_show_tcm_model_gating_2");
        if (bl4 && !bl3 && arrayList.size() == 0 ? ((TCMDontShowMessageAgainErrorDlg)((Object)(object = new TCMDontShowMessageAgainErrorDlg(this, this.getResourceBundle(), this.getResString("IDS_TCM_GATING_FILE_ERROR_1_1") + this.getResString("IDS_TCM_GATING_FILE_ERROR_1_2") + this.getResString("IDS_TCM_GATING_FILE_ERROR_1_3"), "dont_show_tcm_model_gating_1")))).getExitCode() != DefineVariablesAlertDlg.ExitCode.OK_ACTION : bl && !bl3 && arrayList.size() > 0 && ((TCMDontShowMessageAgainErrorDlg)((Object)(object = new MyTCMDontShowMessageAgainErrorDlg(this, this.getResourceBundle(), this.getResString("IDS_TCM_GATING_FILE_ERROR_2_1") + this.getResString("IDS_TCM_GATING_FILE_ERROR_2_2"), "dont_show_tcm_model_gating_2")))).getExitCode() != DefineVariablesAlertDlg.ExitCode.OK_ACTION) {
            return false;
        }
        object = this.getSelectedDateTimeVarName();
        if (object == null && this.mTargetVarList.getAllVariables().size() == 0) {
            return bl2;
        }
        Integer n = this.getMaxNumDistinctValues();
        if (this.hasValidLastInteractiveCallInfo() && this.mEnableCustomizationCheckbox.isSelected() && n < this.mLastInteractiveCallInfo.getMaxNumDistinctValuesPerDims()) {
            this.clearAllSavedInfo();
        }
        if (this.isBackendCallNeeded()) {
            this.mSelectDimensionValuesInfo = null;
            abstractList = this.getSelectedDimensions();
            bl2 = this.doThreadedBackendInteractiveCall((Vector<String>)abstractList);
            if (this.mLastInteractiveCallInfo != null && this.mLastInteractiveCallInfo.isLastCallHadErrors()) {
                TCMUtilities.throwErrorDialog((JDialog)((Object)this), this.mLastInteractiveCallInfo.getErrorMessage());
            }
        }
        if (bl2) {
            abstractList = this.getUnSelectedFields();
            HashMap<String, ArrayList<String>> hashMap = this.getDimensionValuesNames();
            this.updateDimensionValues(arrayList, hashMap);
            String string2 = this.getTimeInterval();
        }
        return bl2;
    }

    private boolean areSelectedDimValuesStillValid() {
        return this.mSelectDimensionValuesInfo != null && this.getSelectedDimensions().contains(this.mSelectDimensionValuesInfo.getDimFieldName());
    }

    private boolean areThereDimensionValuesForAllSelectedDimesions() {
        boolean bl = true;
        this.getSelectedDimensions();
        for (String string : this.getSelectedDimensions()) {
            if (this.mMasterFieldNameToDimensionValuesMap.get(string) != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean doWeHaveTimeIntervalForSelectedDateTime() {
        String string = this.getSelectedDateTimeVarName();
        return string != null && this.mMasterTimeFieldNameToTimeIntervalMap.get(string) != null;
    }

    private boolean isBackendCallNeeded() {
        boolean bl = this.mSpecifyAnyDimFieldsRequiredCheckbox.isSelected() ? !this.areThereDimensionValuesForAllSelectedDimesions() || !this.doWeHaveTimeIntervalForSelectedDateTime() : !this.doWeHaveTimeIntervalForSelectedDateTime();
        return bl;
    }

    private void updateDimensionValues(ArrayList<ISpssVariable> arrayList, HashMap<String, ArrayList<String>> hashMap) {
        if (arrayList != null && arrayList.size() > 0 && hashMap != null && hashMap.size() > 0) {
            for (ISpssVariable iSpssVariable : arrayList) {
                if (iSpssVariable == null) continue;
                String string = iSpssVariable.getName();
                ArrayList<String> arrayList2 = hashMap.get(string);
                if (iSpssVariable.getDimensionValues() != null && iSpssVariable.getDimensionValues().size() != 0 || arrayList2 == null || arrayList2.size() <= 0) continue;
                iSpssVariable.setDimensionVariable(true);
                iSpssVariable.setDimensionValues(new ArrayList<String>(arrayList2));
            }
        }
    }

    public ITrendsInfo getTrendInfo() {
        if (this.mDateUtil != null) {
            return this.mDateUtil.getTrendsInfo();
        }
        return null;
    }

    public String getDateSpec() {
        return this.mDateSpec;
    }

    public String getDataFilterSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.mSpecifyAnyDimFieldsRequiredCheckbox.isSelected() && this.mDimensionToSpecifySubsetInfoMap != null && this.mDimensionToSpecifySubsetInfoMap.size() > 0) {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Set<String> set = this.mDimensionToSpecifySubsetInfoMap.keySet();
            for (String object2 : set) {
                if (this.mDimensionToSpecifySubsetInfoMap.get(object2).isModeInclude()) {
                    vector.add(object2);
                    continue;
                }
                vector2.add(object2);
            }
            StringBuffer stringBuffer2 = new StringBuffer("");
            for (Object object : vector) {
                stringBuffer2.append((String)object);
                boolean bl = this.mDimensionToSpecifySubsetInfoMap.get(object).isDimFieldString();
                stringBuffer2.append("(INCLUDE=");
                ArrayList<String> arrayList = this.mDimensionToSpecifySubsetInfoMap.get(object).getSelectedListDimValues();
                for (String string : arrayList) {
                    if (bl) {
                        stringBuffer2.append("\"");
                    }
                    stringBuffer2.append(string);
                    if (bl) {
                        stringBuffer2.append("\" ");
                        continue;
                    }
                    stringBuffer2.append(" ");
                }
                stringBuffer2.append(") ");
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(" DIMVALUES=");
                stringBuffer.append(stringBuffer2);
            }
            StringBuffer stringBuffer3 = new StringBuffer("");
            for (String string : vector2) {
                stringBuffer3.append(string);
                boolean bl = this.mDimensionToSpecifySubsetInfoMap.get(string).isDimFieldString();
                stringBuffer3.append("(EXCLUDE=");
                ArrayList<String> arrayList = this.mDimensionToSpecifySubsetInfoMap.get(string).getSelectedListDimValues();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (bl) {
                        stringBuffer3.append("\"");
                    }
                    stringBuffer3.append(string2);
                    if (bl) {
                        stringBuffer3.append("\" ");
                        continue;
                    }
                    stringBuffer3.append(" ");
                }
                stringBuffer3.append(") ");
            }
            if (stringBuffer3.length() > 0) {
                stringBuffer.append(" DIMVALUES=");
                stringBuffer.append(stringBuffer3);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String getNextProcDlgActionKey() {
        this.mNextActionKey = this.mSpecifyAnyDimFieldsRequiredCheckbox.isSelected() && this.mTargetVarList.getModel().getSize() > 0 ? "tcm_md" : "tcm";
        return this.mNextActionKey;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVariableList.loadFromActiveDataset();
        this.removeVariablesThatAreNoLongerValidTypes();
        this.removeTargetVarsFromSrcVariableList();
        String string = (String)this.getDialogDataModel().getObject("IDS_SELECTED_DATETIME_VARNAME");
        if (string != null) {
            this.mDateTimeComboBox.setSelectedItem(string);
        }
        this.processEnableControls();
    }

    private void removeTargetVarsFromSrcVariableList() {
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(i);
            this.mSrcVariableList.getModel().removeElement(iSpssVariable);
        }
    }

    protected void removeVariablesThatAreNoLongerValidTypes() {
        String string;
        int n;
        for (n = this.mDateTimeComboBox.getItemCount() - 1; n >= 0; --n) {
            ISpssVariable iSpssVariable;
            string = (String)this.mDateTimeComboBox.getItemAt(n);
            if (string == null || (iSpssVariable = TCMUtilities.findVariableInActiveDataset(string)) == null || iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) continue;
            this.mDateTimeComboBox.remove(n);
        }
        for (n = this.mTargetVarList.getModel().getSize() - 1; n >= 0; --n) {
            string = this.mTargetVarList.getModel().getElementAt(n);
            if (string == null || string.getMeasurementLevel() == MeasurementLevel.nominal || string.getMeasurementLevel() == MeasurementLevel.ordinal) continue;
            this.mTargetVarList.getModel().removeElement((ISpssVariable)string);
            this.mSrcVariableList.getModel().addElement((ISpssVariable)string);
        }
        for (n = 0; n < this.mSrcVariableList.getModel().getSize(); ++n) {
            string = this.mSrcVariableList.getModel().getElementAt(n);
            string.setDimensionVariable(false);
            string.setDimensionValues(new ArrayList());
        }
    }

    @Override
    public void saveDialogState() {
        BaseProcedureDialog.saveState(this.getDialogDataModel(), (Container)((Object)this));
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
        if (this.getSelectedDateTimeVarName() != null) {
            this.getDialogDataModel().putObject("IDS_SELECTED_DATETIME_VARNAME", this.getSelectedDateTimeVarName());
        }
    }

    protected void processEnableControls() {
        boolean bl = this.mDateTimeComboBox.getModel().getSize() > 1;
        this.mIsDateTimeCheckBox.setEnabled(bl);
        this.mDateTimeComboLabel.setEnabled(bl && this.mIsDateTimeCheckBox.isSelected());
        this.mInfoText.setEnabled(bl && this.mIsDateTimeCheckBox.isSelected());
        this.mDateTimeComboBox.setEnabled(bl && this.mIsDateTimeCheckBox.isSelected());
        boolean bl2 = this.mSpecifyAnyDimFieldsRequiredCheckbox.isSelected();
        this.mSrcListLabel.setEnabled(bl2);
        this.mSortPanel.setEnabled(bl2);
        this.mSelectorPanel.setEnabled(bl2);
        this.mSrcVariableList.setEnabled(bl2);
        this.mDimArrowButton.setEnabled(bl2);
        this.mDimVarListLabel.setEnabled(bl2);
        this.mTargetVarList.setEnabled(bl2);
        this.mVarManualOrderPanel.setEnabled(bl2);
        boolean bl3 = this.mTargetVarList.getModel().getSize() > 0 && this.mTargetVarList.getSelectedValues() != null && this.mTargetVarList.getSelectedValues().length > 0 && this.mTargetVarList.getSelectedValues().length <= 1;
        this.mSpecifySubsetButton.setEnabled(bl2 && this.mEnableCustomizationCheckbox.isSelected() && bl3);
        this.mEnableCustomizationCheckbox.setEnabled(bl2 && bl3);
        this.mMaxNumDistinctValuesPerDimLabel.setEnabled(bl2 && bl3 && this.mEnableCustomizationCheckbox.isSelected());
        this.mMaxNumDistinctValuesPerDimTextField.setEnabled(bl2 && bl3 && this.mEnableCustomizationCheckbox.isSelected());
    }

    @Override
    public void init() {
        super.init();
        this.initVars();
        this.initDimensionPanelVar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        JPanel jPanel = this.getViewPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mIsDateTimeCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDateTimeComboLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel2 = this.createDateTimeComboPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel3 = TCMUtilities.createInfoPanel(this.mInfoText);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSpecifyAnyDimFieldsRequiredCheckbox, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mFieldsAndDimensionsPanel = this.createFieldsAndDimensionsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mFieldsAndDimensionsPanel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        this.setDefault();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mIsDateTimeCheckBox);
        vector.add(this.mDateTimeComboBox);
        vector.add(this.mInfoText);
        vector.add(this.mSpecifyAnyDimFieldsRequiredCheckbox);
        vector.addAll(this.mSortPanel.getTabTraversalComponent());
        vector.add(this.mSrcVariableList);
        vector.addAll(this.mSelectorPanel.getTabTraversalComponent());
        vector.add(this.mDimArrowButton);
        vector.addAll(this.mVarManualOrderPanel.getTabTraversalComponent());
        vector.add(this.mSpecifySubsetButton);
        vector.add(this.mEnableCustomizationCheckbox);
        vector.add(this.mMaxNumDistinctValuesPerDimTextField);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel createDateTimeComboPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        Insets insets2 = new Insets(2, 0, n2, n2 * 2);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDateTimeComboBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(new JPanel());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel createFieldsAndDimensionsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 1, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSrcListLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mSortPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mSelectorPanel, gridBagConstraints, 0, 2, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(1, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDimVarListLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDimArrowButton, gridBagConstraints, 1, 3, 1, 1, 10, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mDimensionsPanel, gridBagConstraints, 2, 3, 1, 1, n, insets);
        JPanel jPanel3 = this.createDimensionValuesPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 3, 1, n, insets);
        return jPanel;
    }

    public JPanel createDimensionValuesPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_MODEL_DIM_VALUES_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n3, n3, n3);
        Insets insets2 = new Insets(insets.top, insets.left + 25, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mEnableCustomizationCheckbox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mMaxNumDistinctValuesPerDimLabel);
        jPanel2.add((Component)this.mMaxNumDistinctValuesPerDimTextField);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private void setDefault() {
        this.mSrcVariableList.loadFromActiveDataset();
        this.mIsDateTimeCheckBox.setSelected(true);
        this.mEnableCustomizationCheckbox.setSelected(true);
        this.mMaxNumDistinctValuesPerDimTextField.setText("250");
        this.mSpecifyAnyDimFieldsRequiredCheckbox.setSelected(false);
        this.processEnableControls();
    }

    private void initVars() {
        this.mIsDateTimeCheckBox = DialogUtil.createCheckBox(this, "IDS_TCM_GATING_DATE_TIME_FIELD_CHECK", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMModelGatingDlg.this.processEnableControls();
            }
        });
        this.mDateTimeComboLabel = DialogUtil.createLabel(this, "IDS_TCM_GATING_DLG_FIELD_LABEL");
        this.mDateTimeVarNameLabels = new Hashtable();
        String[] stringArray = this.createDateTimeComboboxEntries();
        this.mDateTimeComboBox = new JComboBox<String>(stringArray);
        this.mDateTimeComboLabel.setLabelFor(this.mDateTimeComboBox);
        this.mDateTimeComboBox.setEditable(false);
        this.mDateTimeComboBox.setOpaque(true);
        this.mDateTimeComboBox.setRenderer(new MyDefaultListCellRenderer());
        this.mDateTimeComboBox.setAction(new ComboboxAction(this, "DATE_TIME_COMBO"));
        this.mSpecifySubsetButton = DialogUtil.createButton(this, "IDS_TCM_GATING_SPECIFY_SUBSET_BUTTON", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMModelGatingDlg.this.processSpecifySubsetAction();
            }
        });
        this.mInfoText = new FocusableTextArea(this.getResString("IDS_TCM_GATING_SCANN_DATA_INFO_LABEL"), null);
        this.mSpecifyAnyDimFieldsRequiredCheckbox = DialogUtil.createCheckBox(this, "IDS_TCM_SPECIFY_ANY_DIMENSION_FIELDS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMModelGatingDlg.this.processEnableControls();
            }
        });
        this.mSrcVariableList = new TCMSrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVariableList.setIdentifier(SRC_VAR_LIST);
        this.mSrcVariableList.setContextMenuFlags(this.mSrcVariableList.getContextMenuFlags() | 8);
        this.mSrcVariableList.setDragSupported(true);
        this.mSrcVariableList.setLoadFromPersistent(false);
        this.mSrcListLabel = DialogUtil.createLabel(this, "IDS_TCM_DATA_STRUC_SOURCE_LABEL");
        this.mSrcListLabel.setLabelFor(this.mSrcVariableList);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVariableList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mSelectorPanel = new VariableSelectorPanel((SrcVariableList)this.mSrcVariableList, (BaseDialog)this, false);
        this.mSortPanel = new VarSourceSortingPanel(this.mSrcVariableList, this, true);
        this.mDateUtil = new DateVarUtil();
        this.mDateSpec = this.mDateUtil.getDateSpecInfo();
        this.mDateSpecVarNames = this.mDateUtil.getDateVarNames();
        this.mDateVarNameAndPeriod = this.mDateUtil.getDateVarNameAndPeriod();
    }

    private String[] createDateTimeComboboxEntries() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.columnCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getResString("IDS_TCM_GATING_DLG_NONE"));
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            if (!iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat()) continue;
            arrayList.add(iSpssVariable.getName());
            this.mDateTimeVarNameLabels.put(iSpssVariable.getName(), iSpssVariable.getLabel());
        }
        arrayList = arrayList != null ? arrayList : new ArrayList<String>();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void processSpecifySubsetAction() {
        TCMSelectDimensionValuesInfo tCMSelectDimensionValuesInfo = new TCMSelectDimensionValuesInfo();
        Integer n = this.getMaxNumDistinctValues();
        String string = this.mTargetVarList.getSelectedIndex() != -1 ? ((ISpssVariable)this.mTargetVarList.getSelectedValue()).getName() : null;
        ISpssVariable iSpssVariable = null;
        ArrayList<String> arrayList = null;
        if (this.hasValidLastInteractiveCallInfo() && this.mEnableCustomizationCheckbox.isSelected() && n < this.mLastInteractiveCallInfo.getMaxNumDistinctValuesPerDims()) {
            this.clearAllSavedInfo();
        }
        if (string != null) {
            boolean bl;
            iSpssVariable = (ISpssVariable)this.mTargetVarList.getSelectedValue();
            TCMSelectDimensionValuesInfo tCMSelectDimensionValuesInfo2 = this.mDimensionToSpecifySubsetInfoMap != null ? this.mDimensionToSpecifySubsetInfoMap.get(string) : null;
            boolean bl2 = bl = tCMSelectDimensionValuesInfo2 != null && this.getSelectedDateTimeVarName() != null && this.mMasterTimeFieldNameToTimeIntervalMap.get(this.getSelectedDateTimeVarName()) != null;
            if (bl) {
                arrayList = this.mMasterFieldNameToDimensionValuesMap.get(string);
                tCMSelectDimensionValuesInfo = tCMSelectDimensionValuesInfo2;
            } else {
                boolean bl3 = false;
                tCMSelectDimensionValuesInfo.setDimFieldName(string);
                boolean bl4 = iSpssVariable.getType() > 0;
                tCMSelectDimensionValuesInfo.setIsDimFieldString(bl4);
                if (this.mMasterFieldNameToDimensionValuesMap.get(string) != null) {
                    arrayList = this.mMasterFieldNameToDimensionValuesMap.get(string);
                    tCMSelectDimensionValuesInfo.setDimValuesUnSelectedList(arrayList);
                } else {
                    bl3 = true;
                }
                if (this.getSelectedDateTimeVarName() != null && this.mMasterTimeFieldNameToTimeIntervalMap.get(this.getSelectedDateTimeVarName()) == null) {
                    bl3 = true;
                }
                if (bl3) {
                    Vector<String> vector = this.getSelectedDimensions();
                    boolean bl5 = this.doThreadedBackendInteractiveCall(vector, this.getResString("IDS_TCM_DIM_FIELDS_PROGRESS_DLG_TEXT"));
                    if (this.hasValidLastInteractiveCallInfo()) {
                        arrayList = this.mLastInteractiveCallInfo.getDimValuesForFieldName(string) != null ? this.mLastInteractiveCallInfo.getDimValuesForFieldName(string) : new ArrayList();
                        tCMSelectDimensionValuesInfo.setDimValuesUnSelectedList(arrayList);
                    } else if (this.mLastInteractiveCallInfo != null && this.mLastInteractiveCallInfo.getErrorMessage() != null) {
                        TCMUtilities.throwErrorDialog((JDialog)((Object)this), this.mLastInteractiveCallInfo.getErrorMessage());
                    }
                }
            }
            if (this.hasValidLastInteractiveCallInfo() && tCMSelectDimensionValuesInfo != null && arrayList != null) {
                this.launchTCMSelectDimensionValuesDlg(tCMSelectDimensionValuesInfo, iSpssVariable, arrayList);
            }
        }
    }

    private void clearAllSavedInfo() {
        this.mLastInteractiveCallInfo = null;
        this.mSelectDimensionValuesInfo = null;
        this.mMasterTimeFieldNameToTimeIntervalMap = new HashMap();
        this.mMasterFieldNameToDimensionValuesMap = new HashMap();
    }

    private void launchTCMSelectDimensionValuesDlg(TCMSelectDimensionValuesInfo tCMSelectDimensionValuesInfo, ISpssVariable iSpssVariable, ArrayList<String> arrayList) {
        if (this.mDimensionToSpecifySubsetInfoMap == null) {
            this.mDimensionToSpecifySubsetInfoMap = new Hashtable();
        }
        TCMSelectDimensionValuesDlg tCMSelectDimensionValuesDlg = new TCMSelectDimensionValuesDlg(this, tCMSelectDimensionValuesInfo);
        tCMSelectDimensionValuesDlg.setVisible(true);
        if (tCMSelectDimensionValuesDlg.wasOkPressed()) {
            this.mSelectDimensionValuesInfo = tCMSelectDimensionValuesDlg.getTCMSelectDimensionValuesInfo();
            iSpssVariable.setDimensionVariable(true);
            String string = iSpssVariable.getName();
            if (this.mDimensionToSpecifySubsetInfoMap.contains(string)) {
                this.mDimensionToSpecifySubsetInfoMap.remove(string);
            }
            if (this.mSelectDimensionValuesInfo.isSelectAllValues()) {
                iSpssVariable.setDimensionValues(new ArrayList<String>(arrayList));
            } else {
                if (this.mSelectDimensionValuesInfo.isModeInclude()) {
                    iSpssVariable.setDimensionValues(new ArrayList<String>(this.mSelectDimensionValuesInfo.getSelectedListDimValues()));
                } else {
                    iSpssVariable.setDimensionValues(new ArrayList<String>(this.mSelectDimensionValuesInfo.getUnSelectedDimValues()));
                }
                boolean bl = iSpssVariable.getType() > 0;
                this.mSelectDimensionValuesInfo.setIsDimFieldString(bl);
                this.mDimensionToSpecifySubsetInfoMap.put(string, this.mSelectDimensionValuesInfo);
            }
        }
    }

    private boolean doThreadedBackendInteractiveCall(Vector<String> vector) {
        return this.doThreadedBackendInteractiveCall(vector, null);
    }

    private boolean doThreadedBackendInteractiveCall(Vector<String> vector, String string) {
        SpssProgressDlg spssProgressDlg = new SpssProgressDlg((Window)this.mParentFrame, VersionInfo.getAppVersionString());
        spssProgressDlg.setMessage(string != null ? string : this.getResString("IDS_TCM_PROGRESS_DLG_TEXT"));
        spssProgressDlg.setLocationRelativeTo(this.mParentFrame);
        TCMInteractiveCallRunnable tCMInteractiveCallRunnable = new TCMInteractiveCallRunnable(vector, spssProgressDlg);
        Thread thread = new Thread(tCMInteractiveCallRunnable);
        thread.start();
        spssProgressDlg.setVisible(true);
        if (!spssProgressDlg.isWorkDone()) {
            thread.interrupt();
            return false;
        }
        return tCMInteractiveCallRunnable.isConnectSuccess();
    }

    protected void initDimensionPanelVar() {
        this.mTargetVarList = new TargetVariableList();
        TCMGatingVarListModel tCMGatingVarListModel = new TCMGatingVarListModel(this.mTargetVarList);
        this.mTargetVarList.setModel(tCMGatingVarListModel);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setSelectionMode(1);
        this.mTargetVarList.setIdentifier(TARGET_LIST_KEY);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(3, false, true));
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 4 + 2));
        this.mTargetVarList.setDragSupported(true);
        this.mTargetVarList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TCMModelGatingDlg.this.processEnableControls();
            }
        });
        this.mDimVarListLabel = DialogUtil.createLabel(this, "IDS_TCM_GATING_DIMENTION_TARGET_LABEL");
        this.mDimVarListLabel.setLabelFor(this.mTargetVarList);
        this.mDimensionsPanel = this.createMyVarManualReorderPanel();
        JScrollPane jScrollPane = this.mVarManualOrderPanel.getListScrollPane();
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.mDimArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDimArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mDimArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mEnableCustomizationCheckbox = DialogUtil.createCheckBox(this, "IDS_TCM_MODEL_ENABLE_CUSTOMIZATION_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TCMModelGatingDlg.this.mEnableCustomizationCheckbox.isSelected() && TCMModelGatingDlg.this.mSelectDimensionValuesInfo != null) {
                    String string = TCMModelGatingDlg.this.getResString("IDS_TCM_GATING_DISABLING_CUSTOMIZATION_WARNING");
                    int n = SpssAlertOptionPane.showConfirmDialog(TCMModelGatingDlg.this.mParentFrame, string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                    if (n == 1) {
                        TCMModelGatingDlg.this.mSelectDimensionValuesInfo = null;
                    } else {
                        TCMModelGatingDlg.this.mEnableCustomizationCheckbox.setSelected(true);
                    }
                }
                TCMModelGatingDlg.this.processEnableControls();
            }
        });
        this.mMaxNumDistinctValuesPerDimLabel = DialogUtil.createLabel(this, "IDS_TCM_MODEL_MAX_NUM_DISTICT_VALUES_PER_DIMENSION");
        this.mMaxNumDistinctValuesPerDimTextField = new IntTextField(100, Integer.MAX_VALUE, true);
        this.mMaxNumDistinctValuesPerDimTextField.setHorizontalAlignment(4);
        this.mMaxNumDistinctValuesPerDimLabel.setLabelFor((Component)this.mMaxNumDistinctValuesPerDimTextField);
        this.mMaxNumDistinctValuesPerDimTextField.setAction((Action)new TextFieldAction(this, "MAX_NUM_DISTINCT_VALUES_PER_DIM"));
    }

    private JPanel createMyVarManualReorderPanel() {
        this.mVarManualOrderPanel = new VarManualReorderPanel(this, this.mTargetVarList);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVarManualOrderPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSpecifySubsetButton, gridBagConstraints, 0, 1, 1, 1, n, new Insets(5, 0, 0, 0));
        return jPanel;
    }

    private void setTabPolicy() {
    }

    private void setDefaults() {
    }

    public Vector<String> getSelectedDimensions() {
        Vector<String> vector = new Vector<String>();
        ArrayList<ISpssVariable> arrayList = this.mTargetVarList.getAllVariables();
        for (ISpssVariable iSpssVariable : arrayList) {
            vector.add(iSpssVariable.getName());
        }
        return vector;
    }

    public String getTimeIntervalFromAutoDetectInfo(String string) {
        String string2 = null;
        if (string != null) {
            try {
                JSONObject jSONObject = JSONObject.parse((String)string);
                JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"intervalResults");
                JSONObject jSONObject2 = (JSONObject)jSONArray.get(0);
                string2 = (String)jSONObject2.get((Object)"timeInterval");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string2;
    }

    @Override
    protected void processCancelAction() {
        super.processCancelAction();
    }

    @Override
    protected void processContinueAction(ActionEvent actionEvent) {
        super.processContinueAction(actionEvent);
    }

    public String getSelectedDateTimeVarName() {
        return this.mIsDateTimeCheckBox.isSelected() && this.mDateTimeComboBox.getSelectedIndex() != 0 ? (String)this.mDateTimeComboBox.getSelectedItem() : null;
    }

    public ArrayList<ISpssVariable> getSelectedDims() {
        if (this.mSpecifyAnyDimFieldsRequiredCheckbox.isSelected()) {
            return this.mTargetVarList.getAllVariables();
        }
        return new ArrayList<ISpssVariable>();
    }

    public boolean isEnableDimValueChecked() {
        return this.getSelectedDims().size() > 0 && this.mEnableCustomizationCheckbox.isSelected();
    }

    public ArrayList<ISpssVariable> getUnSelectedFields() {
        return this.mSrcVariableList.getAllVariables();
    }

    public String getTimeInterval() {
        return this.hasValidLastInteractiveCallInfo() ? this.mLastInteractiveCallInfo.getTimeInterval() : null;
    }

    private boolean hasValidLastInteractiveCallInfo() {
        return this.mLastInteractiveCallInfo != null && !this.mLastInteractiveCallInfo.isLastCallHadErrors();
    }

    public HashMap<String, ArrayList<String>> getDimensionValuesNames() {
        HashMap<String, ArrayList<String>> hashMap = null;
        if (this.mSelectDimensionValuesInfo != null && this.mSelectDimensionValuesInfo.getSelectedListDimValues() != null) {
            hashMap = new HashMap<String, ArrayList<String>>();
            hashMap.put(this.mSelectDimensionValuesInfo.getDimFieldName(), this.mSelectDimensionValuesInfo.getSelectedListDimValues());
        }
        HashMap<String, ArrayList<String>> hashMap2 = this.hasValidLastInteractiveCallInfo() ? this.mLastInteractiveCallInfo.getFieldNameToDimensionValuesMap() : null;
        return hashMap != null ? hashMap : hashMap2;
    }

    public boolean getDimensionValuesIncludeMode() {
        return this.mSelectDimensionValuesInfo.isModeInclude();
    }

    private boolean callBackend(Vector<String> vector) {
        boolean bl = true;
        this.mLastInteractiveCallInfo = null;
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        String string = this.getSelectedDateTimeVarName();
        Integer n = this.getMaxNumDistinctValues();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().getGatingInfo(locallyUniqueId, "", string, n.intValue(), vector, vector2, vector3);
        if (aSMapsError.getHasError()) {
            String string2 = aSMapsError.getMessage();
            String string3 = aSMapsError.getExplain();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2 + " " + string3, VersionInfo.getAppVersionString());
            bl = false;
        } else {
            Vector<String> vector4 = vector2 = string != null ? vector2 : null;
            if (vector.size() > 0) {
                ArrayList<String> arrayList;
                DataModel dataModel = new DataModel();
                try {
                    arrayList = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader((String)vector3.get(0)));
                    dataModel.read((XMLStreamReader)((Object)arrayList));
                }
                catch (XMLStreamException xMLStreamException) {
                    bl = false;
                    xMLStreamException.printStackTrace();
                }
                if (dataModel != null) {
                    this.mLastInteractiveCallInfo = new InteractiveCallInfo(dataModel, vector2);
                    arrayList = this.updateMasterFieldNameToDimensionValuesMap(this.mLastInteractiveCallInfo.getFieldNameToDimensionValuesMap(), n);
                    if (arrayList != null) {
                        String string4 = SyntaxUtil.getDelimitedStringFromStringList(arrayList, ",", null);
                        String string5 = MessageFormat.format(this.getResString("IDS_TCM_GATING_MAX_NUM_DISTINCT_VALUES_EXCEEDED_WARNING"), string4);
                        this.mLastInteractiveCallInfo.setErrorState(string5);
                        bl = false;
                    } else {
                        this.updateMasterTimeFieldNameToTimeIntervalMap(string, this.mLastInteractiveCallInfo.getTimeInterval());
                        this.mLastInteractiveCallInfo.setMaxNumDistinctValuesPerDims(n);
                    }
                } else {
                    bl = false;
                }
            } else if (vector2 != null) {
                this.mLastInteractiveCallInfo = new InteractiveCallInfo(null, vector2);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private Integer getMaxNumDistinctValues() {
        String string = this.mEnableCustomizationCheckbox.isSelected() && this.mMaxNumDistinctValuesPerDimTextField != null && this.mMaxNumDistinctValuesPerDimTextField.getText().trim().length() > 0 ? this.mMaxNumDistinctValuesPerDimTextField.getText() : "105";
        Integer n = string != null ? new Integer(string) : null;
        return n;
    }

    private ArrayList<String> updateMasterFieldNameToDimensionValuesMap(HashMap<String, ArrayList<String>> hashMap, Integer n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : hashMap.keySet()) {
            if (hashMap.get(string) != null && hashMap.get(string).size() > n) {
                arrayList.add(string);
            }
            if (this.mMasterFieldNameToDimensionValuesMap.get(string) != null) continue;
            this.mMasterFieldNameToDimensionValuesMap.put(string, hashMap.get(string));
        }
        if (arrayList.size() > 0) {
            this.mMasterFieldNameToDimensionValuesMap = new HashMap();
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    private void updateMasterTimeFieldNameToTimeIntervalMap(String string, String string2) {
        if (string != null && this.mMasterTimeFieldNameToTimeIntervalMap.get(string2) == null) {
            this.mMasterTimeFieldNameToTimeIntervalMap.put(string, string2);
        }
    }

    private void checkInternalDateVar() {
        if (this.mDateSpec != null && this.mDateSpec.length() > 0) {
            this.processCancelAction();
            this.showColDataTCM(this.mDateSpec);
        }
    }

    private void showColDataTCM(String string) {
        SpssAction spssAction;
        String string2 = "tcm";
        if (string2 != null && !string2.equals("") && (spssAction = ActionCatalog.getActionCatalog().getSpssAction(string2)) instanceof CFCommandAction) {
            CFCommandAction cFCommandAction = (CFCommandAction)spssAction;
            cFCommandAction.setDimensionFields(this.getSelectedDims(), false);
            cFCommandAction.setTCMDataFilterSyntax(this.getDataFilterSyntax());
            cFCommandAction.setmDateTimeVar(this.getSelectedDateTimeVarName(), this.getTimeInterval());
            cFCommandAction.setTrendInfo(string);
            cFCommandAction.setDateSpecVarNames(this.mDateSpecVarNames, this.mDateVarNameAndPeriod);
            cFCommandAction.actionPerformed(new ActionEvent((Object)this, 1, "launch"));
        }
    }

    class InteractiveCallInfo {
        public boolean mLastCallHadErrors = false;
        public String mErrorMessage = null;
        public String mTimeInterval = null;
        private HashMap<String, ArrayList<String>> mDimNameToDimensionValuesMap;
        private HashMap<String, Storage> mDimNameToStorageTypeMap;
        int mMaxNumDistinctValuesPerDims = 250;

        InteractiveCallInfo() {
        }

        public InteractiveCallInfo(DataModel dataModel, Vector<String> vector) {
            if (dataModel != null) {
                this.mDimNameToDimensionValuesMap = TCMModelGatingDlg.this.createDimensionNameToDimensionValuesMap(dataModel);
                this.mDimNameToStorageTypeMap = TCMModelGatingDlg.this.createDimensionNameToStorageTypeMap(dataModel);
            }
            if (vector != null && vector.size() > 0) {
                this.mTimeInterval = TCMModelGatingDlg.this.getTimeIntervalFromAutoDetectInfo(vector.get(0));
            }
        }

        public String getTimeInterval() {
            return this.mTimeInterval;
        }

        public HashMap<String, ArrayList<String>> getFieldNameToDimensionValuesMap() {
            return this.mDimNameToDimensionValuesMap;
        }

        public ArrayList<String> getDimValuesForFieldName(String string) {
            return this.mDimNameToDimensionValuesMap != null && this.mDimNameToDimensionValuesMap.size() > 0 ? this.mDimNameToDimensionValuesMap.get(string) : null;
        }

        public Storage getStorageTypeForDimension(String string) {
            return this.mDimNameToStorageTypeMap.get(string);
        }

        public void setMaxNumDistinctValuesPerDims(int n) {
            this.mMaxNumDistinctValuesPerDims = n;
        }

        public int getMaxNumDistinctValuesPerDims() {
            return this.mMaxNumDistinctValuesPerDims;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }

        public boolean isLastCallHadErrors() {
            return this.mLastCallHadErrors;
        }

        public void setErrorState(String string) {
            this.mErrorMessage = string;
            this.mLastCallHadErrors = true;
        }
    }

    class TCMInteractiveCallRunnable
    implements Runnable {
        private boolean mBackEndRequestSuccess = false;
        private SpssProgressDlg mSpssProgressDlg;
        Vector<String> mDimensionFields;

        public TCMInteractiveCallRunnable(Vector<String> vector, SpssProgressDlg spssProgressDlg) {
            this.mSpssProgressDlg = spssProgressDlg;
            this.mDimensionFields = vector;
        }

        @Override
        public void run() {
            try {
                this.mBackEndRequestSuccess = TCMModelGatingDlg.this.callBackend(this.mDimensionFields);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.mSpssProgressDlg.setWorkDone(true);
            }
            catch (Exception exception) {
                this.mBackEndRequestSuccess = false;
                this.mSpssProgressDlg.setWorkDone(true);
            }
            this.mSpssProgressDlg.dispose();
        }

        public boolean isConnectSuccess() {
            return this.mBackEndRequestSuccess;
        }
    }

    class TCMGatingVarListModel
    extends VarListModel {
        private ISpssVariable mRemovedVar;

        public TCMGatingVarListModel(VariableList variableList) {
            super(variableList);
            this.mRemovedVar = null;
        }

        @Override
        public boolean removeElement(ISpssVariable iSpssVariable) {
            this.mRemovedVar = null;
            int n = this.mVariables.indexOf(iSpssVariable);
            boolean bl = this.mVariables.removeElement(iSpssVariable);
            if (n >= 0) {
                this.mRemovedVar = iSpssVariable;
                this.fireIntervalRemoved(this, n, n);
            }
            return bl;
        }

        public ISpssVariable getRemovedVar() {
            return this.mRemovedVar;
        }
    }

    class MyDefaultListCellRenderer
    extends DefaultListCellRenderer {
        MyDefaultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                String string;
                object2 = (String)object;
                if (TCMUtilities.isShowVarLabels() && (string = (String)TCMModelGatingDlg.this.mDateTimeVarNameLabels.get(object2)) != null && string.length() > 0) {
                    object2 = string + " [" + (String)object2 + "]";
                }
                jLabel.setText((String)object2);
            }
            object2 = n > 0 ? new ImageIcon(TCMModelGatingDlg.this.getResImageURL("IDS_TCM_DATE_TIME_IMAGE")) : null;
            jLabel.setIcon((Icon)object2);
            return jLabel;
        }
    }

    public class HelpPanel
    extends JPanel {
        private JTextArea mInfoDesc;
        private JLabel mHelpIconLabel;

        public HelpPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.initLayout(this.getFont());
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    HelpPanel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    HelpPanel.this.repaint();
                }
            });
        }

        protected void initLayout(Font font) {
            this.mInfoDesc = new JTextArea();
            this.mInfoDesc.setOpaque(false);
            this.mInfoDesc.setFont(font);
            this.mInfoDesc.setLineWrap(true);
            this.mInfoDesc.setWrapStyleWord(true);
            this.mInfoDesc.setText("");
            this.mInfoDesc.setFocusable(false);
            this.mHelpIconLabel = new JLabel();
            this.setHelpText();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            int n2 = DialogUtil.getGroupBoxInnerMargin();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, 0, 0, 1, 1, n, null);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(this, this.mHelpIconLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        }

        public void setHelpText() {
            this.mInfoDesc.setText(TCMModelGatingDlg.this.getResString("IDS_SIMULATION_SELECTION_DESCRIPTION"));
            this.mInfoDesc.setEnabled(true);
            this.mHelpIconLabel.setEnabled(true);
            this.getAccessibleContext().setAccessibleName(this.mInfoDesc.getText());
            this.getAccessibleContext().setAccessibleDescription(this.mInfoDesc.getText());
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        public void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private class MyTCMDontShowMessageAgainErrorDlg
    extends TCMDontShowMessageAgainErrorDlg {
        private MyTCMDontShowMessageAgainErrorDlg(BaseDialog baseDialog, ResourceBundle resourceBundle, String string, String string2) {
            super(baseDialog, resourceBundle, string, string2);
        }

        @Override
        protected boolean doDefineDatesButton() {
            return false;
        }
    }
}

