/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.spss.datamodel.BaseFieldContent;
import com.spss.datamodel.DataModel;
import com.spss.datamodel.Field;
import com.spss.datamodel.Fields;
import com.spss.datamodel.Storage;
import com.spss.datamodel.ValidValue;
import com.spss.datamodel.ValidValues;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingDlg;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.utilities.SpssDateFormatHelper;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.utilities.targetpredictormap.TargetPredictorMap;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TCMForecastGatingInfo {
    private static final String[] DATE_SPEC_NAMES_LIST = new String[]{"", "CYCLE_", "YEAR_", "QUARTER_", "MONTH_", "WEEK_", "DAY_", "HOUR_", "MINUTE_", "SECOND_", "OBS_", "DATE_"};
    protected CyclicInfo mCyclicInfo;
    protected DateTimeInfo mDateTimeInfo;
    protected MultiDimensionInfo mMultiDimensionInfo;
    String mModelFilePath = null;
    DataModel mFullDataModel = null;
    DataModel mTSDPDataModel = null;
    String mDateTimeField = null;
    ArrayList<String> mJSONMetricFieldNames = new ArrayList();
    ArrayList<String> mFullMetricFieldNames = new ArrayList();
    ArrayList<String> mTargetMetricFieldNames = new ArrayList();
    ArrayList<String> mTargetFields = new ArrayList();
    ArrayList<String> mInputFields = new ArrayList();
    Storage mStorage;
    String mLatestOrEarliestObservationType = "Latest";
    int mLatestOrEarliestNumObservations = 100000;
    int mLatestOrEarliestObservationsToExclude = 0;
    int mConfidenceLevel = 95;
    int mOutlierThreshold = 95;
    static ExceptionType mExceptionType = ExceptionType.NONE;

    public TCMForecastGatingInfo(String string, String string2, String string3) {
        this.mFullDataModel = TCMUtilities.createDataModelFromDataModelXML(string3);
        this.initFromTSDP(string, string2, this.mFullDataModel);
        this.initFromNetworkGraphJSON(string2, this.mFullDataModel);
    }

    public void initFromTSDP(String string, String string2, DataModel dataModel) {
        if (string != null) {
            try {
                String string3;
                JSONObject jSONObject = JSONObject.parse((String)string);
                JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"settings");
                JSONObject jSONObject3 = (JSONObject)jSONObject.get((Object)"innerUsedInfo");
                String string4 = (String)jSONObject3.get((Object)"inputDataModel");
                this.mTSDPDataModel = TCMUtilities.createDataModelFromDataModelXML(string4);
                JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"metricFieldList");
                this.mJSONMetricFieldNames = TCMForecastGatingInfo.createStringArrayListFromJSonArray(jSONArray);
                this.mMultiDimensionInfo = new MultiDimensionInfo(string, string2, dataModel);
                this.mDateTimeField = string3 = (String)jSONObject2.get((Object)"dateTimeField");
                if (string3 != null && string3.length() > 0) {
                    this.mDateTimeInfo = new DateTimeInfo(string, this.mTSDPDataModel);
                } else {
                    this.mCyclicInfo = new CyclicInfo(string);
                }
            }
            catch (Exception exception) {
                mExceptionType = ExceptionType.MAIN_INIT;
                exception.printStackTrace();
            }
        }
    }

    public void initFromNetworkGraphJSON(String string, DataModel dataModel) {
        TargetPredictorMap targetPredictorMap = new TargetPredictorMap();
        List list = null;
        List list2 = null;
        targetPredictorMap.fromJSON(string);
        list = targetPredictorMap.getAllPredictorSeries();
        this.processMetricInputTargetInfo(dataModel, list, false);
        list2 = targetPredictorMap.getAllTargetSeries();
        this.processMetricInputTargetInfo(dataModel, list2, true);
    }

    private void processMetricInputTargetInfo(DataModel dataModel, List<String> list, boolean bl) {
        ArrayList<String> arrayList = bl ? this.mTargetMetricFieldNames : this.mFullMetricFieldNames;
        for (String string : list) {
            String[] stringArray = string.split("-");
            String string2 = this.mJSONMetricFieldNames.get(new Integer(stringArray[stringArray.length - 1]));
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
    }

    protected static ArrayList<String> createStringArrayListFromJSonArray(JSONArray jSONArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jSONArray.size(); ++i) {
            arrayList.add((String)jSONArray.get(i));
        }
        return arrayList;
    }

    protected static ArrayList<Long> createLongArrayListFromJSonArray(JSONArray jSONArray) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < jSONArray.size(); ++i) {
            Object object = jSONArray.get(i);
            Long l = object instanceof Double ? ((Double)jSONArray.get(i)).longValue() : ((Long)jSONArray.get(i)).longValue();
            arrayList.add(l);
        }
        return arrayList;
    }

    public DataModel createDataModelFromDataModelXML(String string) {
        DataModel dataModel = new DataModel();
        try {
            XMLStreamReader xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(string));
            dataModel.read(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            mExceptionType = ExceptionType.DATAMODEL;
            dataModel = null;
            xMLStreamException.printStackTrace();
        }
        return dataModel;
    }

    public ArrayList<String> getMetricFieldNames(ListType listType) {
        ArrayList<String> arrayList = null;
        if (listType == ListType.ALL_METRICS) {
            arrayList = this.mFullMetricFieldNames;
        } else if (listType == ListType.TARGET_METRICS) {
            arrayList = this.mTargetMetricFieldNames;
        } else if (listType == ListType.JSON) {
            arrayList = this.mJSONMetricFieldNames;
        }
        return arrayList;
    }

    public boolean isDateTimeType() {
        return this.mDateTimeInfo != null;
    }

    public MultiDimensionInfo getMultiDimensionInfo() {
        return this.mMultiDimensionInfo;
    }

    public DateTimeInfo getDateTimeInfo() {
        return this.mDateTimeInfo;
    }

    public CyclicInfo getCyclicInfo() {
        return this.mCyclicInfo;
    }

    private Field findField(String string) {
        Fields fields = this.getDataModel().getFields();
        return fields.getField(string);
    }

    public EstimationPeriodType getEstmationPeriodType() {
        return this.mDateTimeInfo != null ? this.mDateTimeInfo.getEstimationPeriodType() : this.mCyclicInfo.getEstimationPeriodType();
    }

    public Storage getStorage() {
        return this.mStorage;
    }

    public void setStorage(Storage storage) {
        this.mStorage = storage;
    }

    public String getLatestOrEarliestObservationType() {
        return this.mLatestOrEarliestObservationType;
    }

    public void setLatestOrEarliestObservationType(String string) {
        this.mLatestOrEarliestObservationType = string;
    }

    public Long getNumberOfObservations() {
        return this.mDateTimeInfo != null ? this.mDateTimeInfo.getNumberOfObservations() : this.mCyclicInfo.getNumberOfObservations();
    }

    public Long getNumberOfObservationsToExclude() {
        return this.mDateTimeInfo != null ? this.mDateTimeInfo.getNumberOfObservationsToExclude() : this.mCyclicInfo.getNumberOfObservationsToExclude();
    }

    public int getConfidenceLevel() {
        return this.mConfidenceLevel;
    }

    public void setConfidenceLevel(int n) {
        this.mConfidenceLevel = n;
    }

    public int getOutlierThreshold() {
        return this.mOutlierThreshold;
    }

    public void setOutlierThreshold(int n) {
        this.mOutlierThreshold = n;
    }

    public DataModel getDataModel() {
        return this.mTSDPDataModel;
    }

    public void setModelFilePath(String string) {
        this.mModelFilePath = string;
    }

    public String getModelFilePath() {
        return this.mModelFilePath;
    }

    public boolean containsMetricFieldName(String string) {
        return this.containsMetricFieldName(string, ListType.ALL_METRICS);
    }

    public boolean containsMetricFieldName(String string, ListType listType) {
        return this.getMetricFieldNames(listType).contains(string);
    }

    public boolean isMultiDimensionalData() {
        return this.mMultiDimensionInfo != null ? this.mMultiDimensionInfo.isMultiDimensionalData() : false;
    }

    public String getInputTimeInterval() {
        return this.mDateTimeInfo != null ? this.mDateTimeInfo.getInputInterval() : this.mCyclicInfo.getInputInterval();
    }

    public String getOutputTimeInterval() {
        return this.mDateTimeInfo != null ? this.mDateTimeInfo.getOutputInterval() : this.mCyclicInfo.getOutputInterval();
    }

    public boolean areInputAndOutputTimeIntervalsEqual() {
        return this.mDateTimeInfo != null ? this.getInputTimeInterval().equalsIgnoreCase(this.getOutputTimeInterval()) : this.mCyclicInfo.getAggreLevel() == 0L;
    }

    public static ExceptionType getExceptionType() {
        return mExceptionType;
    }

    public String getDateTimeField() {
        return this.mDateTimeField;
    }

    public String getLocalizeTimeInterval(BaseDialog baseDialog, String string) {
        String string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_IRREGULAR");
        if (string.equals("CYCLIC_PERIOD")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_CYCLIC_PERIOD");
        } else if (string.equals("YEAR")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_YEAR");
        } else if (string.equals("QUARTER")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_QUARTER");
        } else if (string.equals("MONTH")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_MONTH");
        } else if (string.equals("WEEK")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_WEEK");
        } else if (string.equals("DAY")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_DAY");
        } else if (string.equals("HOUR")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_HOUR");
        } else if (string.equals("MINUTE")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_MINUTE");
        } else if (string.equals("SECONDS")) {
            string2 = baseDialog.getResString("TCM_INPUT_TIME_INTERVAL_SECONDS");
        }
        return string2;
    }

    public void setMode(Mode mode) {
        if (this.mCyclicInfo != null) {
            this.mCyclicInfo.setMode(mode);
        }
    }

    public boolean canWriteToActiveDataset() {
        boolean bl = false;
        if (this.mCyclicInfo != null) {
            bl = this.mCyclicInfo.hasCaseCount() || this.mCyclicInfo.isDateSpecification() && this.mCyclicInfo.getAggreLevel() == 0L;
        }
        return bl;
    }

    public static ArrayList<Long> getCyclicValues(ArrayList<String> arrayList, HashMap<String, Long> hashMap) {
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            Long l = hashMap.get(string);
            arrayList2.add(l);
        }
        return arrayList2;
    }

    public static enum ExceptionType {
        NONE,
        MAIN_INIT,
        DATAMODEL,
        MUTLI_DIMENSION_INFO,
        DATE_TIME,
        CYCLIC;

    }

    public static enum Mode {
        FORECASTING,
        SCENARIOS;

    }

    public static enum EstimationPeriodType {
        ALL_OBSRVATIONS,
        START_END_TIMES,
        LATEST,
        EARLIEST;

    }

    public static class CyclicInfo
    extends DateCyclicBase {
        private Mode mMode = Mode.FORECASTING;
        ArrayList<String> mCyclicFieldNames = new ArrayList();
        protected HashMap<String, ArrayList<Long>> mCycleNameOutputTimeIntervals = null;
        protected HashMap<String, Long> mCycleNameToStartEstimationMap = null;
        protected HashMap<String, Long> mCycleNameToEndEstimationMap = null;
        protected HashMap<String, Long> mCycleNameToRangeStartMap = null;
        protected HashMap<String, Long> mCycleNameToRangeEndMap = null;
        Long mIncrement = 1L;
        Long mAggreLevel = 0L;

        public CyclicInfo(String string) {
            this.initFromTSDP(string);
        }

        public void initFromTSDP(String string) {
            if (string != null) {
                try {
                    Object object;
                    JSONObject jSONObject = JSONObject.parse((String)string);
                    JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"settings");
                    this.mAggreLevel = (Long)jSONObject2.get((Object)"aggreLevel");
                    JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"cyclicFieldList");
                    this.mCyclicFieldNames = TCMForecastGatingInfo.createStringArrayListFromJSonArray(jSONArray);
                    this.mCycleNameOutputTimeIntervals = this.createCyclicNameToOutputTimeIntervalsMap(jSONObject);
                    JSONArray jSONArray2 = (JSONArray)jSONObject2.get((Object)"nonStdStartTime");
                    if (jSONArray2 != null && jSONArray2.size() > 0) {
                        this.mCycleNameToStartEstimationMap = this.createCycleNameToTimeMap(this.mCyclicFieldNames, jSONArray2);
                        this.setEstimationPeriodType(EstimationPeriodType.START_END_TIMES);
                    } else {
                        this.mCycleNameToStartEstimationMap = this.createCyclicNametoStartEndMap(this.mCyclicFieldNames, this.mCycleNameOutputTimeIntervals, true);
                    }
                    JSONArray jSONArray3 = (JSONArray)jSONObject2.get((Object)"nonStdEndTime");
                    this.mCycleNameToEndEstimationMap = jSONArray3 != null && jSONArray3.size() > 0 ? this.createCycleNameToTimeMap(this.mCyclicFieldNames, jSONArray3) : this.createCyclicNametoStartEndMap(this.mCyclicFieldNames, this.mCycleNameOutputTimeIntervals, false);
                    String string2 = (String)jSONObject2.get((Object)"valuesSelStrategy");
                    if (string2 != null && (string2.equals("OLDEST") || string2.equals("NEWEST"))) {
                        object = string2.equals("NEWEST") ? EstimationPeriodType.EARLIEST : EstimationPeriodType.LATEST;
                        this.setEstimationPeriodType((EstimationPeriodType)((Object)object));
                        this.mNumberOfObservations = (Long)jSONObject2.get((Object)"numOfKeptValues");
                        this.mObservationsToExclude = (Long)jSONObject2.get((Object)"offset");
                    }
                    this.mCycleNameToRangeStartMap = (object = (JSONArray)jSONObject2.get((Object)"cycOffsetList")) != null && object.size() > 0 ? this.createCycleNameToTimeMap(this.mCyclicFieldNames, (JSONArray)object, true) : new HashMap();
                    this.mCycleNameToRangeStartMap.put(this.mCyclicFieldNames.get(0), Long.MIN_VALUE);
                    JSONArray jSONArray4 = (JSONArray)jSONObject2.get((Object)"cycPeriodList");
                    HashMap<String, Long> hashMap = jSONArray4 != null && jSONArray4.size() > 0 ? this.createCycleNameToTimeMap(this.mCyclicFieldNames, jSONArray4, true) : new HashMap<String, Long>();
                    this.mCycleNameToRangeEndMap = this.createCycleNameToRangeEndMap(this.getCyclicFieldNames(), this.mCycleNameToRangeStartMap, hashMap);
                    this.mIncrement = (Long)jSONObject2.get((Object)"increments");
                    this.mInputInterval = (String)jSONObject2.get((Object)"inputInterval");
                    this.mOutputInterval = (String)jSONObject2.get((Object)"outputInterval");
                }
                catch (Exception exception) {
                    mExceptionType = ExceptionType.CYCLIC;
                    exception.printStackTrace();
                }
            }
        }

        private HashMap<String, Long> createCycleNameToRangeEndMap(ArrayList<String> arrayList, HashMap<String, Long> hashMap, HashMap<String, Long> hashMap2) {
            HashMap<String, Long> hashMap3 = new HashMap<String, Long>();
            for (int i = 1; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                Long l = hashMap.get(string);
                Long l2 = hashMap2.get(string);
                hashMap3.put(string, l + l2 - 1L);
            }
            hashMap3.put(this.mCyclicFieldNames.get(0), Long.MAX_VALUE);
            return hashMap3;
        }

        @Override
        public void setEstimationPeriodType(EstimationPeriodType estimationPeriodType) {
            this.mEstimationPeriodType = estimationPeriodType;
        }

        @Override
        public EstimationPeriodType getEstimationPeriodType() {
            return this.mEstimationPeriodType;
        }

        private HashMap<String, Long> createCyclicNametoStartEndMap(ArrayList<String> arrayList, HashMap<String, ArrayList<Long>> hashMap, boolean bl) {
            HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                ArrayList<Long> arrayList2 = hashMap.get(string);
                Long l = arrayList2 != null ? arrayList2.get(bl ? 0 : arrayList2.size() - 1) : null;
                hashMap2.put(string, l);
            }
            return hashMap2;
        }

        private HashMap<String, ArrayList<Long>> createCyclicNameToOutputTimeIntervalsMap(JSONObject jSONObject) {
            HashMap<String, ArrayList<Long>> hashMap = new HashMap<String, ArrayList<Long>>();
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"output");
            JSONObject jSONObject3 = (JSONObject)jSONObject2.get((Object)"timeVariable");
            if (jSONObject2 != null) {
                for (String string : this.mCyclicFieldNames) {
                    ArrayList<Long> arrayList;
                    JSONArray jSONArray = (JSONArray)jSONObject3.get((Object)string);
                    if (jSONArray == null || jSONArray.size() <= 0 || (arrayList = TCMForecastGatingInfo.createLongArrayListFromJSonArray(jSONArray)) == null || arrayList.size() <= 0) continue;
                    hashMap.put(string, arrayList);
                }
            }
            return hashMap;
        }

        private HashMap<String, Long> createCycleNameToTimeMap(ArrayList<String> arrayList, JSONArray jSONArray) {
            return this.createCycleNameToTimeMap(arrayList, jSONArray, false);
        }

        private HashMap<String, Long> createCycleNameToTimeMap(ArrayList<String> arrayList, JSONArray jSONArray, boolean bl) {
            int n;
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            int n2 = n = bl ? 1 : 0;
            while (n < arrayList.size()) {
                String string = arrayList.get(n);
                int n3 = bl ? n - 1 : n;
                Long l = (Long)jSONArray.get(n3);
                hashMap.put(string, l);
                ++n;
            }
            return hashMap;
        }

        public ArrayList<String> getAllCyclicFieldNames() {
            return this.mCyclicFieldNames;
        }

        public ArrayList<String> getCyclicFieldNames() {
            ArrayList<String> arrayList = new ArrayList();
            if (this.mMode == Mode.SCENARIOS && this.mAggreLevel > 0L) {
                List<String> list = this.mCyclicFieldNames.subList(0, (int)((long)this.mCyclicFieldNames.size() - this.mAggreLevel));
                arrayList.clear();
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i);
                    arrayList.add(string);
                }
            } else {
                arrayList = this.mCyclicFieldNames;
            }
            return arrayList;
        }

        public ArrayList<Long> getCyclicStartEstimationValues() {
            return this.getCyclicValues(this.mCycleNameToStartEstimationMap);
        }

        public ArrayList<Long> getCyclicEndEstimationValues() {
            return this.getCyclicValues(this.mCycleNameToEndEstimationMap);
        }

        public boolean doesCyleHaveRange(String string) {
            return this.mCycleNameToRangeStartMap != null && this.mCycleNameToRangeStartMap.get(string) != null;
        }

        public ArrayList<Long> getCycleNameToRangeStartValues() {
            return this.getCyclicValues(this.mCycleNameToRangeStartMap);
        }

        public ArrayList<Long> getCycleNameToRangeEndValues() {
            return this.getCyclicValues(this.mCycleNameToRangeEndMap);
        }

        public HashMap<String, Long> getCycleNameToStartEstimationMap() {
            return this.mCycleNameToStartEstimationMap;
        }

        public ArrayList<Long> getCycleNameToStartEstimationValues() {
            return this.getCyclicValues(this.mCycleNameToStartEstimationMap);
        }

        public ArrayList<Long> getCycleNameToEndEstimationValues() {
            return this.getCyclicValues(this.mCycleNameToEndEstimationMap);
        }

        public HashMap<String, Long> getCycleNameToEndEstimationMap() {
            return this.mCycleNameToEndEstimationMap;
        }

        public HashMap<String, Long> getCycleNameToRangeStartMap() {
            return this.mCycleNameToRangeStartMap;
        }

        public HashMap<String, Long> getCycleNameToRangeEndMap() {
            return this.mCycleNameToRangeEndMap;
        }

        public ArrayList<Long> getCyclicValues(HashMap<String, Long> hashMap) {
            return TCMForecastGatingInfo.getCyclicValues(this.getCyclicFieldNames(), hashMap);
        }

        public Long getStartValueForCycleName(String string) {
            ArrayList<Long> arrayList = this.mCycleNameOutputTimeIntervals.get(string);
            return arrayList != null && arrayList.size() > 0 ? arrayList.get(0) : null;
        }

        public Long getEndValueForCycleName(String string) {
            ArrayList<Long> arrayList = this.mCycleNameOutputTimeIntervals.get(string);
            return arrayList != null && arrayList.size() > 0 ? arrayList.get(arrayList.size() - 1) : null;
        }

        public Long getRangeStartValueForCycleName(String string) {
            return this.mCycleNameToRangeStartMap.get(string);
        }

        public Long getRangeEndValueForCycleName(String string) {
            return this.mCycleNameToRangeEndMap.get(string);
        }

        public Long getIncrement() {
            return this.mIncrement;
        }

        public static int compareCyclicPeriods(ArrayList<Long> arrayList, ArrayList<Long> arrayList2) {
            int n = -1;
            if (arrayList.size() == arrayList2.size()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    long l;
                    long l2 = arrayList.get(i);
                    if (l2 > (l = arrayList2.get(i).longValue())) {
                        return 1;
                    }
                    if (l2 >= l) continue;
                    return -1;
                }
                n = 0;
            } else {
                n = 1;
            }
            return n;
        }

        public static boolean areValuesEqual(ArrayList<Long> arrayList, ArrayList<Long> arrayList2) {
            boolean bl = true;
            if (arrayList.size() == arrayList2.size()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    long l;
                    long l2 = arrayList.get(i);
                    if (l2 == (l = arrayList2.get(i).longValue())) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public void setMode(Mode mode) {
            this.mMode = mode;
        }

        public Long getAggreLevel() {
            return this.mAggreLevel;
        }

        public boolean hasCaseCount() {
            boolean bl = false;
            for (String string : this.mCyclicFieldNames) {
                if (!string.equals("$casecount")) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public boolean isDateSpecification() {
            boolean bl = true;
            for (String string : this.mCyclicFieldNames) {
                if (TCMUtilities.findString(DATE_SPEC_NAMES_LIST, string, false) != -1) continue;
                bl = false;
                break;
            }
            return bl;
        }
    }

    public static class DateTimeInfo
    extends DateCyclicBase {
        String mDateTimeField = null;
        Long mStartTime = null;
        Long mEndTime = null;
        String mSPSSDateTimeFormatKey;
        String mDateTimePattern;
        String mLocalizedDateTimeFormatString;
        SpssDateFormatHelper.SimpleDateTimeType mDateTimeType;
        ArrayList<Long> mOutputTimeIntervals = new ArrayList();
        String mTimeFormat;
        Long mOutputTimeIncrement = null;

        public DateTimeInfo(String string, DataModel dataModel) {
            this.initFromTSDP(string, dataModel);
        }

        public void initFromTSDP(String string, DataModel dataModel) {
            if (string != null) {
                try {
                    SpssDateFormatHelper spssDateFormatHelper;
                    Field field;
                    EstimationPeriodType estimationPeriodType;
                    String string2;
                    JSONObject jSONObject = JSONObject.parse((String)string);
                    JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"settings");
                    this.mDateTimeField = (String)jSONObject2.get((Object)"dateTimeField");
                    if (jSONObject2.get((Object)"stdStartTime") != null) {
                        this.mStartTime = (Long)jSONObject2.get((Object)"stdStartTime") * 1000L;
                        this.setEstimationPeriodType(EstimationPeriodType.START_END_TIMES);
                    }
                    if (jSONObject2.get((Object)"stdEndTime") != null) {
                        this.mEndTime = (Long)jSONObject2.get((Object)"stdEndTime") * 1000L;
                    }
                    if ((string2 = (String)jSONObject2.get((Object)"valuesSelStrategy")) != null) {
                        if (string2.equals("OLDEST") || string2.equals("NEWEST")) {
                            estimationPeriodType = string2.equals("NEWEST") ? EstimationPeriodType.LATEST : EstimationPeriodType.EARLIEST;
                            this.setEstimationPeriodType(estimationPeriodType);
                            this.mNumberOfObservations = (Long)jSONObject2.get((Object)"numOfKeptValues");
                            this.mObservationsToExclude = (Long)jSONObject2.get((Object)"offset");
                        } else if (string2.equals("TIME")) {
                            this.setEstimationPeriodType(EstimationPeriodType.START_END_TIMES);
                        }
                    }
                    this.mInputInterval = (String)jSONObject2.get((Object)"inputInterval");
                    this.mOutputInterval = (String)jSONObject2.get((Object)"outputInterval");
                    estimationPeriodType = (JSONObject)jSONObject.get((Object)"output");
                    if (estimationPeriodType != null) {
                        JSONObject jSONObject3;
                        this.mTimeFormat = (String)estimationPeriodType.get("timeFormat");
                        field = (JSONArray)estimationPeriodType.get("timeVariable");
                        this.mOutputTimeIntervals = TCMForecastGatingInfo.createLongArrayListFromJSonArray((JSONArray)field);
                        this.mOutputTimeIntervals = this.convertTimeToMilliSeconds(this.mOutputTimeIntervals, this.mTimeFormat.equals("date"));
                        spssDateFormatHelper = (JSONObject)estimationPeriodType.get("dateTimeConvertor");
                        if (spssDateFormatHelper != null && (jSONObject3 = (JSONObject)spssDateFormatHelper.get("outputConvertorSettings")) != null) {
                            this.mOutputTimeIncrement = (Long)jSONObject3.get((Object)"increments");
                        }
                    }
                    field = this.findField(dataModel, this.mDateTimeField);
                    this.mSPSSDateTimeFormatKey = this.getSPSSDateTimeFormatFromField(field);
                    spssDateFormatHelper = this.mSPSSDateTimeFormatKey != null ? SpssDateFormatHelper.getSpssDateFormatForFormatKey(this.mSPSSDateTimeFormatKey) : null;
                    spssDateFormatHelper = spssDateFormatHelper == null ? SpssDateFormatHelper.getClosestSpssDateFormatForFormatKey(this.mSPSSDateTimeFormatKey) : spssDateFormatHelper;
                    this.mDateTimePattern = spssDateFormatHelper != null ? spssDateFormatHelper.getSimpleDateFormatPattern() : this.getDefaultISO8601Pattern(this.mTimeFormat);
                    this.mDateTimeType = spssDateFormatHelper != null ? spssDateFormatHelper.getSimpleDateTimeType() : this.getDefaultDateTimeType(this.mTimeFormat);
                    this.mLocalizedDateTimeFormatString = spssDateFormatHelper != null ? spssDateFormatHelper.getLocalizedFormatString() : this.getDefaultLocalizedISO8601String(this.mTimeFormat);
                }
                catch (Exception exception) {
                    mExceptionType = ExceptionType.DATE_TIME;
                    exception.printStackTrace();
                }
            }
        }

        public SpssDateFormatHelper.SimpleDateTimeType getDefaultDateTimeType(String string) {
            SpssDateFormatHelper.SimpleDateTimeType simpleDateTimeType = SpssDateFormatHelper.SimpleDateTimeType.DATETIME;
            if (string == null || string.equalsIgnoreCase("timestamp")) {
                simpleDateTimeType = SpssDateFormatHelper.SimpleDateTimeType.DATETIME;
            } else if (string.equalsIgnoreCase("date")) {
                simpleDateTimeType = SpssDateFormatHelper.SimpleDateTimeType.DATE;
            } else if (string.equalsIgnoreCase("time")) {
                simpleDateTimeType = SpssDateFormatHelper.SimpleDateTimeType.TIME;
            }
            return simpleDateTimeType;
        }

        public String getDefaultISO8601Pattern(String string) {
            String string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getSimpleDateFormatPattern();
            if (string == null || string.equalsIgnoreCase("timestamp")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getSimpleDateFormatPattern();
            } else if (string.equalsIgnoreCase("date")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATE.getSimpleDateFormatPattern();
            } else if (string.equalsIgnoreCase("time")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_TIME.getSimpleDateFormatPattern();
            }
            return string2;
        }

        public String getDefaultISOFormat(String string) {
            String string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getSimpleDateFormatPattern();
            if (string == null || string.equalsIgnoreCase("timestamp")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getSimpleDateFormatPattern();
            } else if (string.equalsIgnoreCase("date")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATE.getSimpleDateFormatPattern();
            } else if (string.equalsIgnoreCase("time")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_TIME.getSimpleDateFormatPattern();
            }
            return string2;
        }

        public String getDefaultLocalizedISO8601String(String string) {
            String string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getLocalizedFormatString();
            if (string == null || string.equalsIgnoreCase("timestamp")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATETIME.getLocalizedFormatString();
            } else if (string.equalsIgnoreCase("date")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_DATE.getLocalizedFormatString();
            } else if (string.equalsIgnoreCase("time")) {
                string2 = SpssDateFormatHelper.eDEFAULT_ISO_TIME.getLocalizedFormatString();
            }
            return string2;
        }

        private ArrayList<Long> convertTimeToMilliSeconds(ArrayList<Long> arrayList, boolean bl) {
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (int i = 0; i < arrayList.size(); ++i) {
                Long l = arrayList.get(i);
                Long l2 = bl ? l * 86400000L : l * 1000L;
                arrayList2.add(l2);
            }
            return arrayList2;
        }

        public String getSPSSDateTimeFormatFromField(Field field) {
            BaseFieldContent baseFieldContent;
            String string = null;
            if (field != null && (baseFieldContent = field.getBaseFieldContent()) != null && baseFieldContent.getFieldFormat() != null) {
                string = baseFieldContent.getFieldFormat().getDateFormat() != null ? baseFieldContent.getFieldFormat().getDateFormat().getName() : baseFieldContent.getFieldFormat().getTimeFormat().getName();
            }
            return string;
        }

        public int getSPSSDateTimeWidthFromField(Field field) {
            int n = -1;
            if (field != null) {
                BaseFieldContent baseFieldContent = field.getBaseFieldContent();
                n = baseFieldContent != null ? baseFieldContent.getFieldFormat().getDateFormat().getWidth() : null;
            }
            return n;
        }

        public int getSPSSDateTimeDecimalsFromField(Field field) {
            int n = -1;
            if (field != null) {
                BaseFieldContent baseFieldContent = field.getBaseFieldContent();
                n = baseFieldContent != null ? baseFieldContent.getFieldFormat().getDateFormat().getDecimalPlaces() : null;
            }
            return n;
        }

        private Field findField(DataModel dataModel, String string) {
            Fields fields = dataModel.getFields();
            return fields.getField(string);
        }

        public String getDateTimeField() {
            return this.mDateTimeField;
        }

        public SpssDateFormatHelper.SimpleDateTimeType getDateTimeType() {
            return this.mDateTimeType;
        }

        public String getLocalizedDateTimeFormatString() {
            return this.mLocalizedDateTimeFormatString;
        }

        public String getSPSSDateTimeFormatKey() {
            return this.mSPSSDateTimeFormatKey;
        }

        public String getDateTimePattern() {
            return this.mDateTimePattern;
        }

        public Long getStartTime() {
            Long l = this.mOutputTimeIntervals != null && this.mOutputTimeIntervals.size() > 0 ? this.mOutputTimeIntervals.get(0) : null;
            Long l2 = this.mStartTime != null ? this.mStartTime : l;
            return l2;
        }

        public Date getStartTimeAsDate() {
            return new Date(this.getStartTime());
        }

        public Long getEndTime() {
            Long l = this.mOutputTimeIntervals != null && this.mOutputTimeIntervals.size() > 0 ? this.mOutputTimeIntervals.get(this.mOutputTimeIntervals.size() - 1) : null;
            Long l2 = this.mEndTime != null ? this.mEndTime : l;
            return l2;
        }

        public Date getEndTimeAsDate() {
            return new Date(this.getEndTime());
        }

        public ArrayList<Long> getOutputTimeIntervals(String string, Long l, Long l2) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            l = this.convertTimeForRangeTesting(string, l);
            l2 = this.convertTimeForRangeTesting(string, l2);
            for (Long l3 : this.mOutputTimeIntervals) {
                Long l4 = this.convertTimeForRangeTesting(string, l3);
                if (l4 < l || l4 > l2) continue;
                arrayList.add(l3);
            }
            return arrayList;
        }

        private long convertTimeForRangeTesting(String string, long l) {
            long l2 = l;
            if (string != null) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
                calendar.setTime(new Date(l));
                if (string.equals("YEAR")) {
                    calendar.set(2, 0);
                    calendar.set(5, 1);
                    calendar.set(10, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.add(14, 0);
                } else if (string.equals("MONTH")) {
                    calendar.set(5, 1);
                    calendar.set(10, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.add(14, 0);
                } else if (string.equals("DAY")) {
                    calendar.set(10, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.add(14, 0);
                } else if (string.equals("HOUR")) {
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.add(14, 0);
                } else if (string.equals("MINUTE")) {
                    calendar.set(13, 0);
                    calendar.add(14, 0);
                } else if (string.equals("SECONDS")) {
                    calendar.add(14, 0);
                }
                l2 = calendar.getTimeInMillis();
            }
            return l2;
        }

        public ArrayList<Long> getOutputTimeIntervals() {
            return this.mOutputTimeIntervals;
        }

        public Long getOutputTimeIncrement() {
            return this.mOutputTimeIncrement;
        }
    }

    public static class DateCyclicBase {
        protected Long mNumberOfObservations = null;
        protected Long mObservationsToExclude = null;
        EstimationPeriodType mEstimationPeriodType;
        String mInputInterval = "";
        String mOutputInterval = "";

        public void setEstimationPeriodType(EstimationPeriodType estimationPeriodType) {
            this.mEstimationPeriodType = estimationPeriodType;
        }

        public EstimationPeriodType getEstimationPeriodType() {
            return this.mEstimationPeriodType;
        }

        public String getInputInterval() {
            return this.mInputInterval;
        }

        public String getOutputInterval() {
            return this.mOutputInterval;
        }

        public Long getNumberOfObservations() {
            return this.mNumberOfObservations;
        }

        public Long getNumberOfObservationsToExclude() {
            return this.mObservationsToExclude;
        }
    }

    public static class MultiDimensionInfo {
        ArrayList<String> mJSONDimFieldNames = new ArrayList();
        ArrayList<String> mFullDimFieldNames = new ArrayList();
        ArrayList<String> mTargetDimFieldNames = new ArrayList();
        protected HashMap<String, ArrayList<String>> mFullDimNameToDimValuesMap = new HashMap();
        protected HashMap<String, ArrayList<String>> mFullDimNameToDimValueLabelsMap = new HashMap();
        protected HashMap<String, ArrayList<String>> mTargetDimNameToDimValuesMap = new HashMap();
        protected HashMap<String, ArrayList<String>> mTargetDimNameToDimValueLabelsMap = new HashMap();
        boolean mIsMutiDimensionalData = true;

        public MultiDimensionInfo(String string, String string2, DataModel dataModel) {
            this.initFromTSDP(string);
            this.initFromNetworkGraphJSON(string2, dataModel);
        }

        public void initFromTSDP(String string) {
            if (string != null) {
                try {
                    JSONObject jSONObject = JSONObject.parse((String)string);
                    JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"settings");
                    JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"dimFieldList");
                    if (jSONArray != null && jSONArray.size() > 0) {
                        this.mJSONDimFieldNames = TCMForecastGatingInfo.createStringArrayListFromJSonArray(jSONArray);
                    }
                    boolean bl = true;
                }
                catch (Exception exception) {
                    mExceptionType = ExceptionType.MUTLI_DIMENSION_INFO;
                    exception.printStackTrace();
                }
            }
        }

        public void initFromNetworkGraphJSON(String string, DataModel dataModel) {
            TargetPredictorMap targetPredictorMap = new TargetPredictorMap();
            List list = null;
            List list2 = null;
            targetPredictorMap.fromJSON(string);
            list = targetPredictorMap.getAllPredictorSeries();
            this.processInputTargetInfo(dataModel, list, false);
            list2 = targetPredictorMap.getAllTargetSeries();
            this.processInputTargetInfo(dataModel, list2, true);
        }

        private void processInputTargetInfo(DataModel dataModel, List<String> list, boolean bl) {
            HashMap<String, ArrayList<String>> hashMap = bl ? this.mTargetDimNameToDimValuesMap : this.mFullDimNameToDimValuesMap;
            HashMap<String, ArrayList<String>> hashMap2 = bl ? this.mTargetDimNameToDimValueLabelsMap : this.mFullDimNameToDimValueLabelsMap;
            ArrayList<String> arrayList = bl ? this.mFullDimFieldNames : this.mTargetDimFieldNames;
            for (String string : list) {
                String[] stringArray = string.split("-");
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    String string2 = stringArray[i];
                    String string3 = this.mJSONDimFieldNames.get(i);
                    this.addToDimFieldDimValuesMap(string3, new Integer(string2), dataModel, hashMap, hashMap2);
                    if (arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
            }
        }

        private void addToDimFieldDimValuesMap(String string, int n, DataModel dataModel, HashMap<String, ArrayList<String>> hashMap, HashMap<String, ArrayList<String>> hashMap2) {
            BaseFieldContent baseFieldContent;
            Field field = TCMForcastingDlg.findField(dataModel, string);
            if (field != null && (baseFieldContent = field.getBaseFieldContent()) != null) {
                ValidValues validValues = baseFieldContent.getValues();
                ValidValue validValue = this.getValidValueAt(validValues, n);
                if (validValues != null) {
                    String string2 = validValue.getValue();
                    String string3 = validValue.getDisplayLabel();
                    this.addnewDimValueForDimName(hashMap2, string, string3);
                }
            }
        }

        private void addnewDimValueForDimName(HashMap<String, ArrayList<String>> hashMap, String string, String string2) {
            ArrayList<String> arrayList = hashMap.get(string);
            if (arrayList != null) {
                if (!arrayList.contains(string2)) {
                    arrayList.add(string2);
                }
            } else {
                arrayList = new ArrayList();
            }
            hashMap.remove(string);
            hashMap.put(string, arrayList);
        }

        private ValidValue getValidValueAt(ValidValues validValues, int n) {
            ValidValue validValue = null;
            if (validValues != null) {
                for (ValidValue validValue2 : validValues) {
                    if (new Integer(validValue2.getValue()) != n) continue;
                    validValue = validValue2;
                    break;
                }
            }
            return validValue;
        }

        public boolean isMultiDimensionalData() {
            return this.hasDimensionFieldNames();
        }

        private boolean hasDimensionFieldNames() {
            boolean bl = false;
            if (this.mJSONDimFieldNames != null) {
                for (int i = 0; i < this.mJSONDimFieldNames.size(); ++i) {
                    String string = this.mJSONDimFieldNames.get(i);
                    if (string == null || string.trim().length() <= 0) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public void setIsMutiDimensionalData(boolean bl) {
            this.mIsMutiDimensionalData = bl;
        }

        public ArrayList<String> getDimFields() {
            return this.mJSONDimFieldNames;
        }

        public ArrayList<String> getFullDimensionValuesForDimField(String string) {
            return this.mFullDimNameToDimValueLabelsMap.get(string);
        }

        public ArrayList<String> getTargetDimensionValuesForDimField(String string) {
            return this.mTargetDimNameToDimValueLabelsMap.get(string);
        }
    }

    public static enum ListType {
        JSON,
        ALL_METRICS,
        TARGET_METRICS;

    }
}

