/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.charteditor.component.DateTextField;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class TCMForcastingSaveTab
extends BaseProcedureTab {
    private TCMForcastingDlg mTCMForcastingDlgParent;
    JCheckBox mPredictedValuesCheckBox;
    JLabel mPredictedValuesRootNameLabel;
    JTextField mPredictedValuesRootNameTextField;
    JCheckBox mUpperLowerConfLimitsCheckBox;
    JLabel mUpperRootNameLabel;
    JTextField mUpperRootNameTextField;
    JLabel mLowerRootNameLabel;
    JTextField mLowerRootNameTextField;
    JCheckBox mNoiseResidualsCheckBox;
    JLabel mNoiseResidualsRootNameLabel;
    JTextField mNoiseResidualsRootNameTextField;
    JCheckBox mIndicateCasesContainingForcastsCheckBox;
    JLabel mIndicateCasesFieldNameLabel;
    JTextField mIndicateCasesFieldNameTextField;
    JLabel mTargetsToSaveLabel;
    JComboBox mTargetsToSaveComboBox;
    SpssButtonGroup mSavePredictionsToDataFileORActiveDatasetButtonGroup = new SpssButtonGroup();
    SpssButtonGroup mSPSSDataFileOrNewDatasetButtonGroup = new SpssButtonGroup();
    JRadioButton mSavePredictionsAndTransformedDataToNewDatafileRB;
    JRadioButton mSPSSDataFileRB;
    JLabel mSPSSDatafileFileLabel;
    JTextField mSPSSDatafileFileTextField;
    JButton mSPSSDatafileFileBrowseButton;
    JRadioButton mNewDatasetFileRB;
    JLabel mNewDatasetNameLabel;
    JTextField mNewDatasetNameTextField;
    JRadioButton mSavePredictionsToActiveDatasetRB;
    JCheckBox mExportModelSystemCheckBox;
    JLabel mExportmodelSystemFileLabel;
    JTextField mExportmodelSystemFileTextField;
    JButton mExportmodelSystemFileBrowseButton;
    private TCMForecastGatingInfo mTCMForecastGatingInfo;
    private Insets mMasterInsets = new Insets(0, 0, 0, 2);
    private Insets mLeftSpaceInset = new Insets(0, 6, 0, 0);
    private Insets mRightSpaceInsets = new Insets(0, 0, 0, 6);

    public TCMForcastingSaveTab(TCMForcastingDlg tCMForcastingDlg, TCMForecastGatingInfo tCMForecastGatingInfo) {
        super(tCMForcastingDlg, true);
        this.mTCMForcastingDlgParent = tCMForcastingDlg;
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.initialize();
    }

    @Override
    public Vector<Object> getComponentOrder() {
        this.mComponentOrder.clear();
        this.mComponentOrder.add(this.mPredictedValuesCheckBox);
        this.mComponentOrder.add(this.mPredictedValuesRootNameTextField);
        this.mComponentOrder.add(this.mUpperLowerConfLimitsCheckBox);
        this.mComponentOrder.add(this.mLowerRootNameTextField);
        this.mComponentOrder.add(this.mUpperRootNameTextField);
        this.mComponentOrder.add(this.mNoiseResidualsCheckBox);
        this.mComponentOrder.add(this.mNoiseResidualsRootNameTextField);
        this.mComponentOrder.add(this.mIndicateCasesContainingForcastsCheckBox);
        this.mComponentOrder.add(this.mIndicateCasesFieldNameTextField);
        this.mComponentOrder.add(this.mTargetsToSaveComboBox);
        this.mComponentOrder.add(this.mSavePredictionsAndTransformedDataToNewDatafileRB);
        this.mComponentOrder.add(this.mSPSSDataFileRB);
        this.mComponentOrder.add(this.mSPSSDatafileFileTextField);
        this.mComponentOrder.add(this.mSPSSDatafileFileBrowseButton);
        this.mComponentOrder.add(this.mNewDatasetFileRB);
        this.mComponentOrder.add(this.mNewDatasetNameTextField);
        this.mComponentOrder.add(this.mSavePredictionsToActiveDatasetRB);
        this.mComponentOrder.add(this.mExportModelSystemCheckBox);
        this.mComponentOrder.add(this.mExportmodelSystemFileTextField);
        this.mComponentOrder.add(this.mExportmodelSystemFileBrowseButton);
        return this.mComponentOrder;
    }

    public boolean doValidateTab() {
        boolean bl = true;
        boolean bl2 = this.validateSaveTargetsPanel();
        bl = bl2 ? this.validateDestinationOptionsPanel() : false;
        return bl;
    }

    private boolean validateDestinationOptionsPanel() {
        boolean bl = true;
        if (this.mSavePredictionsAndTransformedDataToNewDatafileRB.isEnabled() && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected()) {
            if (this.mSPSSDataFileRB.isEnabled() && this.mSPSSDataFileRB.isSelected()) {
                bl = TCMUtilities.isValidFileDirectory((JDialog)((Object)this.mTCMForcastingDlgParent), this.mSPSSDatafileFileTextField.getText(), this.getResString("IDS_TS_FORECASTING_EMPTY_FILE_NAME_ERROR"), this.getResString("IDS_TS_FORECASTING_INVALID_FOLDER_LOCATION_ERROR"));
            } else if (this.mNewDatasetNameTextField.isEnabled() && this.mNewDatasetNameTextField.getText() == null || this.mNewDatasetNameTextField.getText().trim().length() == 0) {
                this.throwTextFieldError(this.mNewDatasetNameTextField, this.getResString("IDS_TS_FORECASTING_INVALID_DATASETNAME_ERROR"));
                bl = false;
            }
        }
        if (bl && this.mExportModelSystemCheckBox.isEnabled() && this.mExportModelSystemCheckBox.isSelected()) {
            bl = TCMUtilities.isValidFileDirectory((JDialog)((Object)this.mTCMForcastingDlgParent), this.mExportmodelSystemFileTextField.getText(), this.getResString("IDS_TS_FORECASTING_EMPTY_FILE_NAME_ERROR"), this.getResString("IDS_TS_FORECASTING_INVALID_FOLDER_LOCATION_ERROR"));
            this.mExportmodelSystemFileTextField.requestFocusInWindow();
            this.mExportmodelSystemFileTextField.selectAll();
        }
        return bl;
    }

    private boolean validateSaveTargetsPanel() {
        boolean bl = true;
        ArrayList<JTextField> arrayList = new ArrayList<JTextField>();
        if (this.mPredictedValuesCheckBox.isSelected()) {
            arrayList.add(this.mPredictedValuesRootNameTextField);
        }
        if (this.mUpperLowerConfLimitsCheckBox.isSelected()) {
            arrayList.add(this.mUpperRootNameTextField);
            arrayList.add(this.mLowerRootNameTextField);
        }
        if (this.mNoiseResidualsCheckBox.isSelected()) {
            arrayList.add(this.mNoiseResidualsRootNameTextField);
        }
        if ((bl = this.areRootNamesValid(arrayList, true)) && this.mIndicateCasesContainingForcastsCheckBox.isSelected()) {
            bl = this.isNameValid(this.mIndicateCasesFieldNameTextField, false);
        }
        return bl;
    }

    private boolean isNameValid(JTextField jTextField, boolean bl) {
        ArrayList<JTextField> arrayList = new ArrayList<JTextField>();
        arrayList.add(jTextField);
        return this.areRootNamesValid(arrayList, false);
    }

    private boolean areRootNamesValid(ArrayList<JTextField> arrayList, boolean bl) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl2 = true;
        for (JTextField jTextField : arrayList) {
            String string = jTextField.getText();
            if (string == null || string.length() == 0) {
                this.throwTextFieldError(jTextField, this.getResString("IDS_TS_FORECASTING_INVALID_NAME_ROOTNAME_ERROR"));
                bl2 = false;
                break;
            }
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 0 && n != 100) {
                DialogUtil.showBadSpssVarNameWarning(n, this.mTCMForcastingDlgParent);
                jTextField.selectAll();
                jTextField.requestFocus();
                bl2 = false;
                break;
            }
            if (string.length() > 63) {
                this.throwTextFieldError(jTextField, this.getResString("IDS_TS_FORECASTING_INVALID_LENGTH_ROOTNAME_ERROR"));
                bl2 = false;
                break;
            }
            if (!bl) continue;
            boolean bl3 = arrayList2.contains(string);
            if (bl3) {
                this.throwTextFieldError(jTextField, this.getResString("IDS_TS_FORECASTING_DUPLICATE_ROOTNAME_ERROR"));
                bl2 = false;
                break;
            }
            arrayList2.add(string);
        }
        return bl2;
    }

    private void throwTextFieldError(JTextField jTextField, String string) {
        this.mTCMForcastingDlgParent.selectSaveTab();
        jTextField.requestFocusInWindow();
        jTextField.selectAll();
        TCMForcastingDlg.throwErrorDialog((Window)((Object)this.mTCMForcastingDlgParent), string);
    }

    public void appendSyntax(StringBuffer stringBuffer) {
        this.appendSaveTargetsSyntax(stringBuffer);
        this.appendDestinationOptionsSyntax(stringBuffer);
    }

    private String appendSaveTargetsSyntax(StringBuffer stringBuffer) {
        if (this.isARootTargetSelected()) {
            String string;
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE "));
            if (this.mTargetsToSaveComboBox.getSelectedIndex() == 0) {
                stringBuffer.append("TARGETS(FILTERED)");
            } else {
                stringBuffer.append("TARGETS(ALL)");
            }
            if (this.mPredictedValuesCheckBox.isSelected()) {
                string = MessageFormat.format(" PREDICTED({0})", this.mPredictedValuesRootNameTextField.getText());
                stringBuffer.append(string);
            }
            if (this.mUpperLowerConfLimitsCheckBox.isSelected()) {
                string = MessageFormat.format(" CL(LCLROOT={0} UCLROOT={1})", this.mLowerRootNameTextField.getText(), this.mUpperRootNameTextField.getText());
                stringBuffer.append(string);
            }
            if (this.mNoiseResidualsCheckBox.isSelected()) {
                string = MessageFormat.format(" NRESIDUAL({0})", this.mNoiseResidualsRootNameTextField.getText());
                stringBuffer.append(string);
            }
            if (this.mIndicateCasesContainingForcastsCheckBox.isSelected()) {
                string = MessageFormat.format(" FORECASTFLAG({0})", this.mIndicateCasesFieldNameTextField.getText());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    private boolean isARootTargetSelected() {
        return this.mPredictedValuesCheckBox.isSelected() || this.mUpperLowerConfLimitsCheckBox.isSelected() || this.mNoiseResidualsCheckBox.isSelected();
    }

    public String getNewDatasetName() {
        String string = null;
        boolean bl = this.isARootTargetSelected();
        if (bl && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected() && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isEnabled() && this.mNewDatasetFileRB.isSelected()) {
            string = this.mNewDatasetNameTextField.getText();
        }
        return string;
    }

    private String appendDestinationOptionsSyntax(StringBuffer stringBuffer) {
        boolean bl = this.isARootTargetSelected();
        if (bl && (this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected() && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isEnabled() || this.mExportModelSystemCheckBox.isSelected() && this.mExportModelSystemCheckBox.isEnabled())) {
            String string;
            String string2;
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand(" /OUTFILE "));
            if (this.mExportModelSystemCheckBox.isSelected()) {
                string2 = this.mExportmodelSystemFileTextField.getText().length() > 0 ? SyntaxUtil.wrapText(this.mExportmodelSystemFileTextField.getText(), '\'') : "''";
                string = MessageFormat.format(" MODELSYSTEM = {0}", string2);
                stringBuffer.append(string);
            }
            if (this.mSPSSDataFileRB.isSelected()) {
                string2 = this.mSPSSDatafileFileTextField.getText().length() > 0 ? SyntaxUtil.wrapText(this.mSPSSDatafileFileTextField.getText(), '\'') : "''";
                string = MessageFormat.format(" DATA = {0}", string2);
                stringBuffer.append(string);
            } else if (this.mNewDatasetFileRB.isSelected()) {
                string2 = MessageFormat.format(" DATA = {0}", this.mNewDatasetNameTextField.getText());
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        this.setDefaults();
        this.updateEnableStates();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_tcm_forecasting_save";
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
    }

    private void initialize() {
        this.initVars();
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = this.mMasterInsets;
        JPanel jPanel2 = this.getSaveTargetsPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.getDestinationObservationsPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel4 = this.getExpertModelSystemPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.updateEnableStates();
    }

    private void updateEnableStates() {
        boolean bl = this.mPredictedValuesCheckBox.isSelected();
        this.mPredictedValuesRootNameLabel.setEnabled(bl);
        this.mPredictedValuesRootNameTextField.setEnabled(bl);
        boolean bl2 = this.mUpperLowerConfLimitsCheckBox.isSelected();
        this.mUpperRootNameLabel.setEnabled(bl2);
        this.mUpperRootNameTextField.setEnabled(bl2);
        this.mLowerRootNameLabel.setEnabled(bl2);
        this.mLowerRootNameTextField.setEnabled(bl2);
        boolean bl3 = this.mNoiseResidualsCheckBox.isSelected();
        this.mNoiseResidualsRootNameLabel.setEnabled(bl3);
        this.mNoiseResidualsRootNameTextField.setEnabled(bl3);
        boolean bl4 = this.mIndicateCasesContainingForcastsCheckBox.isSelected();
        this.mIndicateCasesFieldNameLabel.setEnabled(bl4);
        this.mIndicateCasesFieldNameTextField.setEnabled(bl4);
        boolean bl5 = bl || bl2 || bl3;
        boolean bl6 = bl5 && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected();
        boolean bl7 = bl6 && this.mSPSSDataFileRB.isSelected();
        boolean bl8 = this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected() && bl5 && this.mNewDatasetFileRB.isSelected();
        this.mTargetsToSaveLabel.setEnabled(this.isARootTargetSelected());
        this.mTargetsToSaveComboBox.setEnabled(this.isARootTargetSelected());
        this.mSavePredictionsAndTransformedDataToNewDatafileRB.setEnabled(bl5);
        this.mSPSSDataFileRB.setEnabled(bl6);
        this.mSPSSDatafileFileLabel.setEnabled(bl7);
        this.mSPSSDatafileFileTextField.setEnabled(bl7);
        this.mSPSSDatafileFileBrowseButton.setEnabled(bl7);
        this.mNewDatasetFileRB.setEnabled(bl6);
        this.mNewDatasetNameLabel.setEnabled(bl8);
        this.mNewDatasetNameTextField.setEnabled(bl8);
        this.mSavePredictionsToActiveDatasetRB.setEnabled(bl5 && this.mTCMForecastGatingInfo.canWriteToActiveDataset());
        boolean bl9 = this.mExportModelSystemCheckBox.isSelected();
        boolean bl10 = this.mTCMForcastingDlgParent.getModelTab().isReestimateFromData();
        this.mExportModelSystemCheckBox.setEnabled(bl10);
        this.mExportmodelSystemFileLabel.setEnabled(bl10 && bl9);
        this.mExportmodelSystemFileTextField.setEnabled(bl10 && bl9);
        this.mExportmodelSystemFileBrowseButton.setEnabled(bl10 && bl9);
    }

    public void setDefaults() {
        this.mPredictedValuesCheckBox.setSelected(false);
        this.mPredictedValuesRootNameTextField.setText("Predicted");
        this.mUpperLowerConfLimitsCheckBox.setSelected(false);
        this.mUpperRootNameTextField.setText("UCL");
        this.mLowerRootNameTextField.setText("LCL");
        this.mNoiseResidualsCheckBox.setSelected(false);
        this.mNoiseResidualsRootNameTextField.setText("NResidual");
        this.mNoiseResidualsCheckBox.setSelected(false);
        this.mNoiseResidualsRootNameTextField.setText("NResidual");
        this.mIndicateCasesContainingForcastsCheckBox.setSelected(false);
        this.mIndicateCasesFieldNameTextField.setText("ForecasteIndicator");
        this.mTargetsToSaveComboBox.setSelectedIndex(0);
        this.mExportModelSystemCheckBox.setSelected(false);
        this.mExportmodelSystemFileTextField.setText("");
        boolean bl = this.mTCMForecastGatingInfo.canWriteToActiveDataset();
        this.mSavePredictionsAndTransformedDataToNewDatafileRB.setSelected(!bl);
        this.mSavePredictionsToActiveDatasetRB.setSelected(bl);
        this.mSPSSDataFileRB.setSelected(true);
        this.mSPSSDatafileFileTextField.setText("");
        this.mNewDatasetFileRB.setSelected(true);
        this.mNewDatasetNameTextField.setText("");
        this.updateEnableStates();
    }

    @Override
    protected void aboutToShowTab() {
        this.updateEnableStates();
    }

    private void initVars() {
        this.mPredictedValuesCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_PREDICTED_VALUES_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mPredictedValuesRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_PREDICTED_VALUESROOTNAME_LABEL");
        this.mPredictedValuesRootNameTextField = new JTextField();
        this.mPredictedValuesRootNameLabel.setLabelFor(this.mPredictedValuesRootNameTextField);
        this.mUpperLowerConfLimitsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_UPPER_LOWER_CONF_LIMITS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mUpperRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_UPPER_ROOTNAME_LABEL");
        this.mLowerRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_LOWER_ROOTNAME_LABEL");
        this.mLowerRootNameTextField = new JTextField();
        this.mUpperRootNameTextField = new JTextField();
        this.mUpperRootNameLabel.setLabelFor(this.mUpperRootNameTextField);
        this.mLowerRootNameLabel.setLabelFor(this.mLowerRootNameTextField);
        this.mNoiseResidualsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_NOISE_RESIDUALS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mNoiseResidualsRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_NOISE_RESIDUALS_ROOTNAME_LABEL");
        this.mNoiseResidualsRootNameTextField = new JTextField();
        this.mNoiseResidualsRootNameLabel.setLabelFor(this.mNoiseResidualsRootNameTextField);
        this.mIndicateCasesContainingForcastsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_INDICATE_CASES_FORCASTS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mIndicateCasesFieldNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_INDICATE_CASES_FORCASTS_FIELD_NAME_LABEL");
        this.mIndicateCasesFieldNameTextField = new JTextField();
        this.mIndicateCasesFieldNameLabel.setLabelFor(this.mIndicateCasesFieldNameTextField);
        this.mTargetsToSaveLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_TARGET_TO_SAVE_LABEL");
        this.mTargetsToSaveComboBox = new JComboBox<String>(new String[]{this.getResString("IDS_TCM_FORCASTING_SAVETAB_TARGETS_SPECIFIED_BY_SERIES_TODISPLAY_RB"), this.getResString("IDS_TCM_FORCASTING_SAVETAB_ALL_TARGETS_RB")});
        this.mSavePredictionsAndTransformedDataToNewDatafileRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_SAVETAB_SAVE_PREDICTIONS_TO_NEW_DATAFILE_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mSPSSDataFileRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_SAVETAB_A_NEW_SPSS_DATAFILE_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mSPSSDatafileFileLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_A_NEW_SPSS_DATAFILE_FILE_LABEL");
        this.mSPSSDatafileFileTextField = new JTextField();
        this.mSPSSDatafileFileLabel.setLabelFor(this.mSPSSDatafileFileTextField);
        this.mSPSSDatafileFileBrowseButton = DialogUtil.createButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_SAVETAB_A_NEW_SPSS_DATAFILE_FILE_BROWSE_LABEL", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TCMForcastingSaveTab.this.showSaveDialog(TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVEAS_DATA_DIALOG_TITLE"), TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVEAS_DATA_FILE_FILTER"), TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVEAS_DATA_FILE_FILTER_EXTN"), true);
                if (string != null) {
                    TCMForcastingSaveTab.this.mSPSSDatafileFileTextField.setText(string);
                }
            }
        });
        this.mNewDatasetFileRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_SAVETAB_A_NEW_DATASET_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mNewDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_A_NEW_DATASET_DATASETNAME_LABEL");
        this.mNewDatasetNameTextField = new JTextField();
        this.mNewDatasetNameLabel.setLabelFor(this.mNewDatasetNameTextField);
        this.mSavePredictionsToActiveDatasetRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_SAVETAB_SAVE_PREDICTIONS_TO_ACTIVE_DATASET_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mSPSSDataFileOrNewDatasetButtonGroup.add(this.mSPSSDataFileRB);
        this.mSPSSDataFileOrNewDatasetButtonGroup.add(this.mNewDatasetFileRB);
        this.mSavePredictionsToDataFileORActiveDatasetButtonGroup.add(this.mSavePredictionsAndTransformedDataToNewDatafileRB);
        this.mSavePredictionsToDataFileORActiveDatasetButtonGroup.add(this.mSavePredictionsToActiveDatasetRB);
        this.mExportModelSystemCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_EXPORT_MODEL_SYSTEM_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingSaveTab.this.updateEnableStates();
            }
        });
        this.mExportmodelSystemFileLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_SAVETAB_EXPORT_MODEL_SYSTEM_FILE_LABEL");
        this.mExportmodelSystemFileTextField = new JTextField();
        this.mExportmodelSystemFileLabel.setLabelFor(this.mExportmodelSystemFileTextField);
        this.mExportmodelSystemFileBrowseButton = DialogUtil.createButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_SAVETAB_EXPORT_MODEL_SYSTEM_FILE_BROWSE_LABEL", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TCMForcastingSaveTab.this.showSaveDialog(TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVEAS_MODEL_DIALOG_TITLE"), TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVEAS_MODEL_FILE_FILTER"), TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVEAS_MODEL_FILE_FILTER_EXTN"), false);
                if (string != null) {
                    TCMForcastingSaveTab.this.mExportmodelSystemFileTextField.setText(string);
                }
            }
        });
    }

    public String showSaveDialog(String string, String string2, String string3, boolean bl) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string3));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog(this);
        if (n == 0) {
            int n2;
            String string4 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            if (bl && (n2 = string4.toLowerCase().indexOf(this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVEAS_DATA_FILE_FILTER_EXTN"))) == -1) {
                string4 = string4.concat(this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVEAS_DATA_FILE_FILTER_EXTN"));
            }
            return string4;
        }
        return "";
    }

    private void autoSelectSavePredictionsAndTransformationsButton() {
        boolean bl = true;
        this.mSavePredictionsAndTransformedDataToNewDatafileRB.setSelected(bl);
    }

    private JPanel getSaveTargetsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_SAVETAB_SAVE_TARGETS_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPredictedValuesCheckBox, gridBagConstraints, 0, 0, 1, 1, n, this.mLeftSpaceInset);
        JPanel jPanel2 = this.getLabelTexFieldPanel(new JLabel[]{this.mPredictedValuesRootNameLabel}, new JTextField[]{this.mPredictedValuesRootNameTextField});
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mUpperLowerConfLimitsCheckBox, gridBagConstraints, 0, 2, 1, 1, n, this.mLeftSpaceInset);
        jPanel2 = this.getLabelTexFieldPanel(new JLabel[]{this.mLowerRootNameLabel, this.mUpperRootNameLabel}, new JTextField[]{this.mLowerRootNameTextField, this.mUpperRootNameTextField});
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNoiseResidualsCheckBox, gridBagConstraints, 0, 4, 1, 1, n, this.mLeftSpaceInset);
        jPanel2 = this.getLabelTexFieldPanel(new JLabel[]{this.mNoiseResidualsRootNameLabel}, new JTextField[]{this.mNoiseResidualsRootNameTextField});
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mIndicateCasesContainingForcastsCheckBox, gridBagConstraints, 0, 6, 1, 1, n, this.mLeftSpaceInset);
        jPanel2 = this.getLabelTexFieldPanel(new JLabel[]{this.mIndicateCasesFieldNameLabel}, new JTextField[]{this.mIndicateCasesFieldNameTextField});
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 7, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.mTargetsToSaveLabel);
        jPanel3.add(this.mTargetsToSaveComboBox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 8, 2, 1, n, this.mLeftSpaceInset);
        return jPanel;
    }

    private JPanel getLabelTexFieldPanel(JLabel[] jLabelArray, JTextField[] jTextFieldArray) {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        for (int i = 0; i < jLabelArray.length; ++i) {
            JLabel jLabel = jLabelArray[i];
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            Insets insets3 = i == 0 ? insets2 : insets;
            int n3 = i * 2;
            DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, n3, 0, 1, 1, n, insets3);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jTextFieldArray[i], gridBagConstraints, n3 + 1, 0, 1, 1, n, insets);
        }
        return jPanel;
    }

    private JPanel getDestinationObservationsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_SAVETAB_DESTINATION_OPTIONS_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        Insets insets3 = new Insets(insets2.top, insets2.left + 30, insets2.bottom, insets2.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSavePredictionsAndTransformedDataToNewDatafileRB, gridBagConstraints, 0, 0, 1, 1, n, this.mLeftSpaceInset);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSPSSDataFileRB, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel2 = this.getSpssFileBrowsePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNewDatasetFileRB, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        JPanel jPanel3 = this.getLabelTexFieldPanel(new JLabel[]{this.mNewDatasetNameLabel}, new JTextField[]{this.mNewDatasetNameTextField});
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSavePredictionsToActiveDatasetRB, gridBagConstraints, 0, 5, 1, 1, n, this.mLeftSpaceInset);
        return jPanel;
    }

    private JPanel getSpssFileBrowsePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSPSSDatafileFileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSPSSDatafileFileTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSPSSDatafileFileBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getExpertModelSystemPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(0, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mExportModelSystemCheckBox, gridBagConstraints, 0, 0, 1, 1, n, this.mLeftSpaceInset);
        JPanel jPanel2 = this.getExpertModelSystemFileBrowsePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getExpertModelSystemFileBrowsePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mExportmodelSystemFileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mExportmodelSystemFileTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mExportmodelSystemFileBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }

    class DateTextFieldEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private DateTextField mField;

        DateTextFieldEditor(DateTextField dateTextField) {
            super((JTextField)dateTextField);
            this.mField = dateTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 > 0 && object != null) {
                this.mField.setText(object.toString());
            }
            return this.mField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mField.getText();
        }
    }

    class DateTimeTableModel
    extends DefaultTableModel {
        DateTimeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n != 0;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? "" : TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_MODELTAB_DATE_AND_TIME_LABEL");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = "";
            if (n2 == 0) {
                string = n == 0 ? TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_MODELTAB_START_LABEL") : TCMForcastingSaveTab.this.getResString("IDS_TCM_FORCASTING_MODELTAB_END_LABEL");
            }
            return string;
        }
    }

    class DateTimeTable
    extends JTable {
        DateTimeTableModel mDateTimeTableModel;
        DateTextField mDateTextField;

        DateTimeTable() {
            this.mDateTimeTableModel = new DateTimeTableModel();
            this.setModel(this.mDateTimeTableModel);
            this.setAutoResizeMode(3);
            this.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.getColumnModel().getColumn(1).setPreferredWidth(150);
        }
    }
}

