/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.datamodel.DataModel;
import com.spss.datamodel.Field;
import com.spss.datamodel.ValidValues;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VarManualReorderPanel;
import com.spss.java_client.ui.controls.VarSourceSortingPanel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.VariableSelectorPanel;
import com.spss.java_client.ui.dialogs.TCM.DataSpecSidebarSelectorPanel;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMSelectDimensionValuesTable;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMSrcVariableList;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.MultiFieldChooserDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.controls.row_management_table.TableRowManagementHelper;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TCMForcastingOptionsTab
extends BaseProcedureTab {
    public static final int GENERAL_TAB_INDEX = 0;
    public static final int SERIES_TO_DISPLAY_TAB_INDEX = 1;
    public static final int OUTPUT_TAB_INDEX = 2;
    private static final String SRC_VAR_LIST = "IDS_TCM_GATING_SRC_VARLIST";
    static final String TARGET_LIST_KEY = "IDS_TCM_GATING_TARGET_LIST";
    TCMForcastingDlg mTCMForcastingDlgParent;
    private JPanel mGeneralPanel;
    private JLabel mConfidenseIntervalWidthLabel;
    protected NumberSpinner mConfidenseIntervalWidthSpinner;
    private JLabel mOutlierThreshholdLabel;
    protected NumberSpinner mOutlierThreshholdSpinner;
    private DataSpecSidebarSelectorPanel mSideBarControl;
    private JPanel mSeriesToDisplayPanel;
    private JRadioButton mFixedNumberTargetsRB;
    protected JLabel mNumberSpinnerLabel;
    protected NumberSpinner mFixedNumberSpinner;
    protected JLabel mPercentSpinnerLabel;
    private JRadioButton mPercentageOfTargetsRB;
    protected NumberSpinner mPercentSpinner;
    private SpssButtonGroup mDisplayTargetsRadioButtonGroup;
    private JLabel mGoodnessOfFitComboLabel;
    private JComboBox mGoodnessOfFitComboBox;
    private JLabel mSrcListFieldsLabel;
    private JLabel mTargetListFieldsToDisplayLabel;
    private JLabel mInfoText;
    protected TCMSrcVariableList mSrcVariableList;
    protected JScrollPane mSrcScrollPane;
    protected JLabel mSrcListLabel;
    VariableSelectorPanel mSelectorPanel;
    VarSourceSortingPanel mVarSourceSortingPanel;
    private TargetVariableList mTargetVarList;
    private VarManualReorderPanel mVarManualOrderPanel;
    private ArrowButton mDimArrowButton;
    private JPanel mOutputOptionsPanel;
    private JCheckBox mTargetOverallModelSystemCheckBox;
    private JCheckBox mTargetModelFitStatsAndOutliersCheckBox;
    private JCheckBox mTargetModelEffectsBuildSummaryCheckBox;
    private JCheckBox mTargetImpactDiagramsCheckBox;
    private JCheckBox mTargetSeriesPlotCheckBox;
    private JCheckBox mTargetResidualPlotCheckbox;
    private JCheckBox mTargetTopInputsCheckBox;
    private JCheckBox mTargetForcasteTableCheckBox;
    private JLabel mTargetSignificanceLevelLabel;
    private FloatTextField mTargetSignificanceLevelTextField;
    private JLabel mTargetTypeLabel;
    private JComboBox mTargetTypeCB;
    private JLabel mTargetLevelsSpinnerLabel;
    private NumberSpinner mTargetLevelsSpinner;
    private JCheckBox mSameAsForTargets;
    private JCheckBox mSeriesOverallModelSystemCheckBox;
    private JCheckBox mSeriesModelFitStatsAndOutliersCheckBox;
    private JCheckBox mSeriesModelEffectsBuildSummaryCheckBox;
    private JCheckBox mSeriesImpactDiagramsCheckBox;
    private JCheckBox mSeriesSeriesPlotCheckBox;
    private JCheckBox mSeriesResidualPlotCheckbox;
    private JCheckBox mSeriesTopInputsCheckBox;
    private JCheckBox mSeriesForcasteTableCheckBox;
    private JLabel mSeriesSignificanceLevelLabel;
    private FloatTextField mSeriesSignificanceLevelTextField;
    private JLabel mSeriesTypeLabel;
    private JComboBox mSeriesTypeCB;
    private JLabel mSeriesLevelsSpinnerLabel;
    private NumberSpinner mSeriesLevelsSpinner;
    private JCheckBox mSeriesOutlierRootCheckBox;
    private JLabel mSeriesCausalLevelsSpinnerLabel;
    private NumberSpinner mSeriesCausalLevelsSpinner;
    private JLabel mSeriesOutputComboboxLabel;
    private JComboBox mSeriesOutputCombobox;
    private JCheckBox mModelFitRootMeanCheckBox;
    private JCheckBox mModelFitNormalizedBICCheckBox;
    private JCheckBox mModelFitRSquareCheckBox;
    private JCheckBox mModelFitOutliersOverTimeCheckBox;
    private JCheckBox mModelFitTransformationCheckBox;
    private JCheckBox mModelFitAICCheckBox;
    private JCheckBox mModelFitRSquareErrorCheckBox;
    private JScrollPane mSelectDimValuesTableScrollPane;
    private TCMSelectDimensionValuesTable mSelectDimValuesTable;
    private TableRowManagementHelper mTableRowManagementHelper;
    private JButton mFieldChooserButton;
    private JButton mDeleteButton;
    private JButton mCopyButton;
    private JButton mUpButton;
    private JButton mDownButton;
    private TCMForecastGatingInfo mTCMForecastGatingInfo;
    private Insets mMasterInsets = new Insets(0, 0, 0, 2);
    private Insets mLeftSpaceInset = new Insets(0, 6, 0, 0);
    private Insets mRightSpaceInsets = new Insets(0, 0, 0, 6);
    private Insets mLeftRightSpaceInsets = new Insets(0, 15, 0, 6);

    public TCMForcastingOptionsTab(TCMForcastingDlg tCMForcastingDlg, TCMForecastGatingInfo tCMForecastGatingInfo) {
        super(tCMForcastingDlg, true);
        this.mTCMForcastingDlgParent = tCMForcastingDlg;
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.initialize();
    }

    public Field findField(DataModel dataModel, String string) {
        return TCMForcastingDlg.findField(dataModel, string);
    }

    public ValidValues getFieldValues(DataModel dataModel, String string) {
        return TCMForcastingDlg.getFieldValues(dataModel, string);
    }

    public ArrayList<String> getFieldValueStringList(DataModel dataModel, String string) {
        return this.mTCMForcastingDlgParent.getFieldValueStringList(dataModel, string);
    }

    public void appendSyntax(StringBuffer stringBuffer) {
        TCMUtilities.stopTableEditing(this.mSelectDimValuesTable);
        this.appendGeneralSyntax(stringBuffer);
        this.appendSeriesToDisplySyntax(stringBuffer);
        this.appendOutputOptionsSyntax(stringBuffer);
    }

    public void appendGeneralSyntax(StringBuffer stringBuffer) {
        stringBuffer.append(" CILEVEL=");
        stringBuffer.append(this.mConfidenseIntervalWidthSpinner.getValueForSyntax());
        stringBuffer.append(" OUTLIERTHRESH=");
        stringBuffer.append(this.mOutlierThreshholdSpinner.getValueForSyntax());
    }

    public void appendSeriesToDisplySyntax(StringBuffer stringBuffer) {
        this.appendTargetFilterSyntax(stringBuffer);
        this.appendSeriesFilterSyntax(stringBuffer);
    }

    private String appendTargetFilterSyntax(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/TARGETFILTER "));
        String string = this.getGoodnessOfFitSyntax();
        if (this.mFixedNumberTargetsRB.isSelected()) {
            Object[] objectArray = new Object[]{this.mFixedNumberSpinner.getValueForSyntax(), string};
            String string2 = MessageFormat.format("DISPLAY=BESTFIT(N={0} FITSTAT={1})", objectArray);
            stringBuffer.append(string2);
        } else if (this.mPercentageOfTargetsRB.isSelected()) {
            if ((Integer)this.mPercentSpinner.getValue() == 100) {
                stringBuffer.append("DISPLAY=ALLTARGETS");
            } else {
                Object[] objectArray = new Object[]{this.mPercentSpinner.getValueForSyntax(), string};
                String string3 = MessageFormat.format("DISPLAY=BESTFIT(PCT={0} FITSTAT={1})", objectArray);
                stringBuffer.append(string3);
            }
        }
        return stringBuffer.toString();
    }

    private String appendSeriesFilterSyntax(StringBuffer stringBuffer) {
        block4: {
            block3: {
                if (!this.mTCMForecastGatingInfo.isMultiDimensionalData()) break block3;
                for (int i = 0; i < this.mSelectDimValuesTable.getRowCount(); ++i) {
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/SERIESFILTER "));
                    String string = (String)this.mSelectDimValuesTable.getValueAt(i, 0);
                    stringBuffer.append("FIELDS=");
                    stringBuffer.append(string);
                    stringBuffer.append(" DIMVALUES=");
                    for (int j = 1; j < this.mSelectDimValuesTable.getColumnCount(); ++j) {
                        String string2 = this.mSelectDimValuesTable.getDimNameForColumn(j);
                        String string3 = (String)this.mSelectDimValuesTable.getValueAt(i, j);
                        Object[] objectArray = new Object[]{string2, string3};
                        String string4 = MessageFormat.format("{0}(INCLUDE={1}) ", objectArray);
                        stringBuffer.append(string4);
                    }
                }
                break block4;
            }
            if (this.mTargetVarList.getAllVariables().size() <= 0) break block4;
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SERIESFILTER "));
            stringBuffer.append("FIELDS=");
            for (int i = 0; i < this.mTargetVarList.getAllVariables().size(); ++i) {
                stringBuffer.append(this.mTargetVarList.getAllVariables().get(i).getName());
                if (i + 1 >= this.mTargetVarList.getAllVariables().size()) continue;
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    public void appendOutputOptionsSyntax(StringBuffer stringBuffer) {
        if (this.mSameAsForTargets.isSelected()) {
            this.appendOutputForSyntax(stringBuffer, OutputType.BOTH);
        } else {
            this.appendOutputForSyntax(stringBuffer, OutputType.TARGETS);
            this.appendOutputForSyntax(stringBuffer, OutputType.SERIES);
        }
        this.appendOutputModelFitSyntax(stringBuffer);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private String appendOutputForSyntax(StringBuffer var1_1, OutputType var2_2) {
        block45: {
            block44: {
                block43: {
                    block42: {
                        block41: {
                            var1_1.append("\n");
                            var1_1.append(SyntaxUtil.getSubCommand("/FILTEREDOUTPUT INCLUDE = "));
                            var1_1.append(var2_2.toString());
                            if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                            if (var2_2 == OutputType.TARGETS) lbl-1000:
                            // 2 sources

                            {
                                v0 = this.mTargetOverallModelSystemCheckBox;
                            } else {
                                v0 = var3_3 = this.mSeriesOverallModelSystemCheckBox;
                            }
                            if (!var3_3.isSelected()) break block41;
                            if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                            if (var2_2 == OutputType.TARGETS) lbl-1000:
                            // 2 sources

                            {
                                v1 = this.mTargetSignificanceLevelTextField.getText();
                            } else {
                                v1 = this.mSeriesSignificanceLevelTextField.getText();
                            }
                            var4_4 = v1;
                            var5_5 = MessageFormat.format(" NETWORKGRAPH = YES(SIGLEVEL = {0})", new Object[]{var4_4});
                            var1_1.append((String)var5_5);
                            break block42;
                        }
                        var1_1.append(" NETWORKGRAPH = NO");
                    }
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v2 = this.mTargetModelFitStatsAndOutliersCheckBox;
                    } else {
                        v2 = var4_4 = this.mSeriesModelFitStatsAndOutliersCheckBox;
                    }
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v3 = this.mTargetModelEffectsBuildSummaryCheckBox;
                    } else {
                        v3 = var5_5 = this.mSeriesModelEffectsBuildSummaryCheckBox;
                    }
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v4 = this.mTargetForcasteTableCheckBox;
                    } else {
                        v4 = var6_6 = this.mSeriesForcasteTableCheckBox;
                    }
                    if (var4_4.isSelected() || var5_5.isSelected() || var6_6.isSelected()) {
                        var1_1.append(" PRINT=");
                        if (var4_4.isSelected()) {
                            var1_1.append("MODELFIT OUTLIERS ");
                        }
                        if (var5_5.isSelected()) {
                            var1_1.append("MODELEFFECTS PARAMETERS ");
                        }
                        if (var6_6.isSelected()) {
                            var1_1.append("FORECASTS ");
                        }
                    }
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v5 = this.mTargetSeriesPlotCheckBox;
                    } else {
                        v5 = var7_7 = this.mSeriesSeriesPlotCheckBox;
                    }
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v6 = this.mTargetResidualPlotCheckbox;
                    } else {
                        v6 = var8_8 = this.mSeriesResidualPlotCheckbox;
                    }
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v7 = this.mTargetTopInputsCheckBox;
                    } else {
                        v7 = var9_9 = this.mSeriesTopInputsCheckBox;
                    }
                    if (var7_7.isSelected() || var8_8.isSelected()) {
                        var1_1.append(" PLOT=");
                        if (var7_7.isSelected()) {
                            var1_1.append("SERIESPLOT ");
                        }
                        if (var8_8.isSelected()) {
                            var1_1.append("NRESIDUAL ");
                        }
                        if (var9_9.isSelected()) {
                            var1_1.append("TOPINPUTS ");
                        }
                    }
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v8 = this.mTargetImpactDiagramsCheckBox;
                    } else {
                        v8 = var10_10 = this.mSeriesImpactDiagramsCheckBox;
                    }
                    if (!var10_10.isSelected()) break block43;
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v9 = this.mTargetTypeCB;
                    } else {
                        v9 = var11_11 = this.mSeriesTypeCB;
                    }
                    if (var2_2 == OutputType.BOTH) ** GOTO lbl-1000
                    if (var2_2 == OutputType.TARGETS) lbl-1000:
                    // 2 sources

                    {
                        v10 = this.mTargetLevelsSpinner;
                    } else {
                        v10 = this.mSeriesLevelsSpinner;
                    }
                    var12_12 /* !! */  = v10;
                    var13_13 /* !! */  = null;
                    if (((String)var11_11.getSelectedItem()).equals(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_EFFECTS"))) {
                        var13_13 /* !! */  = MessageFormat.format(" IMPACTDIAGRAMS=EFFECTS({0})", new Object[]{var12_12 /* !! */ .getValueForSyntax()});
                    } else if (((String)var11_11.getSelectedItem()).equals(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_CAUSES"))) {
                        var13_13 /* !! */  = MessageFormat.format(" IMPACTDIAGRAMS=CAUSES({0})", new Object[]{var12_12 /* !! */ .getValueForSyntax()});
                    } else if (((String)var11_11.getSelectedItem()).equals(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_BOTH_CAUSES_AND_EFFECTS"))) {
                        var13_13 /* !! */  = MessageFormat.format(" IMPACTDIAGRAMS=CAUSES({0}) EFFECTS({1})", new Object[]{var12_12 /* !! */ .getValueForSyntax(), var12_12 /* !! */ .getValueForSyntax()});
                    }
                    if (var13_13 /* !! */  != null) {
                        var1_1.append((String)var13_13 /* !! */ );
                    }
                }
                if (var2_2 == OutputType.BOTH) break block44;
                if (var2_2 != OutputType.SERIES) break block45;
            }
            if (this.mSeriesOutlierRootCheckBox.isSelected()) {
                var11_11 = "" + this.mSeriesCausalLevelsSpinner.getValueForSyntax();
                var12_12 /* !! */  = this.getOutputDisplaySyntax();
                var13_13 /* !! */  = new Object[]{var11_11, var12_12 /* !! */ };
                var14_14 = MessageFormat.format(" OUTLIER_ROOTCAUSES = YES(LEVELS={0} DISPLAY={1})", var13_13 /* !! */ );
                var1_1.append(var14_14);
            } else {
                var1_1.append(" OUTLIER_ROOTCAUSES = NO");
            }
        }
        return var1_1.toString();
    }

    private String appendOutputModelFitSyntax(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/SYSTEMOUTPUT  "));
        if (this.mModelFitRootMeanCheckBox.isSelected() || this.mModelFitNormalizedBICCheckBox.isSelected() || this.mModelFitRSquareCheckBox.isSelected() || this.mModelFitAICCheckBox.isSelected() || this.mModelFitRSquareErrorCheckBox.isSelected()) {
            stringBuffer.append("MODELFIT=");
            if (this.mModelFitRootMeanCheckBox.isSelected()) {
                stringBuffer.append(" RMSPE");
            }
            if (this.mModelFitNormalizedBICCheckBox.isSelected()) {
                stringBuffer.append(" BIC");
            }
            if (this.mModelFitRSquareCheckBox.isSelected()) {
                stringBuffer.append(" RSQUARE");
            }
            if (this.mModelFitAICCheckBox.isSelected()) {
                stringBuffer.append(" AIC");
            }
            if (this.mModelFitRSquareErrorCheckBox.isSelected()) {
                stringBuffer.append(" RMSE");
            }
        } else {
            stringBuffer.append("MODELFIT=NONE");
        }
        stringBuffer.append(" TRANSFORMATIONS=");
        String string = this.mModelFitTransformationCheckBox.isSelected() ? "YES" : "NO";
        stringBuffer.append(string);
        stringBuffer.append(" OUTLIERPLOT=");
        string = this.mModelFitOutliersOverTimeCheckBox.isSelected() ? "YES" : "NO";
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public boolean doValidateTab() {
        return this.validateSeriesToDisplayPanel();
    }

    private boolean validateSeriesToDisplayPanel() {
        String string;
        block4: {
            block3: {
                string = null;
                TCMUtilities.stopTableEditing(this.mSelectDimValuesTable);
                if (!this.mTCMForecastGatingInfo.isMultiDimensionalData()) break block3;
                for (int i = 0; i < this.mSelectDimValuesTable.getRowCount(); ++i) {
                    String string2 = (String)this.mSelectDimValuesTable.getValueAt(i, 0);
                    if (this.mTCMForecastGatingInfo.containsMetricFieldName(string2)) continue;
                    this.mTCMForcastingDlgParent.selectOptionsTab();
                    this.mSideBarControl.setSelectedIndex(1);
                    string = MessageFormat.format(this.getResString("IDS_TS_FORECASTING_MISSING_FIELD_IN_MODEL_SYSTEM_FILE_ERROR"), string2);
                    break;
                }
                if (string != null || this.areAllRootDimensionValuesDefined()) break block4;
                string = this.getResString("IDS_TCM_FORCASTING_SCENARIO_DEFINITION_VALUES_MUST_BE_SPECIFIED_ERROR_MESSAGE");
                break block4;
            }
            for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
                ISpssVariable iSpssVariable = this.mTargetVarList.getModel().getElementAt(i);
                if (this.mTCMForecastGatingInfo.containsMetricFieldName(iSpssVariable.getName())) continue;
                this.mTCMForcastingDlgParent.selectOptionsTab();
                this.mSideBarControl.setSelectedIndex(1);
                string = MessageFormat.format(this.getResString("IDS_TS_FORECASTING_MISSING_FIELD_IN_MODEL_SYSTEM_FILE_ERROR"), iSpssVariable.getName());
                break;
            }
        }
        if (string != null && !string.equals("EXPRESSION_PARSER_ERROR")) {
            TCMForcastingDlg.throwErrorDialog((Window)((Object)this.mTCMForcastingDlgParent), string);
        }
        return string == null;
    }

    public boolean areAllRootDimensionValuesDefined() {
        boolean bl = true;
        for (int i = 0; i < this.mSelectDimValuesTable.getRowCount(); ++i) {
            Vector<String> vector = TCMUtilities.getDimensionValuesVector(this.mSelectDimValuesTable, i);
            if (vector != null && vector.size() >= this.mSelectDimValuesTable.getDimensionNames().size()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        String string = "idh_tcm_forecasting_options_general";
        if (this.mSideBarControl.getSelectedIndex() == 1) {
            string = "idh_tcm_forecasting_options_series_to_display";
        } else if (this.mSideBarControl.getSelectedIndex() == 2) {
            string = "idh_tcm_forecasting_options_output";
        }
        return string;
    }

    String getSavePanelHelpText() {
        return this.getResString("IDS_MC_SAVE_PANEL_HELP");
    }

    String getOptionPanelHelpText() {
        return this.getResString("IDS_MC_OPTION_PANEL_HELP");
    }

    void enableOKPaste() {
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
    }

    private String formatOBS(OBS oBS, SPSS_Format sPSS_Format) {
        String string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
        if (string.length() >= 40) {
            string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)new SPSS_Format(FormatType.E, sPSS_Format.getWidth(), sPSS_Format.getDecimals()));
        }
        return string;
    }

    private boolean validateCorrelationPanel() {
        return true;
    }

    private boolean validateOptionPanel() {
        return true;
    }

    private boolean validateDFunctionPanel() {
        return true;
    }

    private boolean validateOutputPanel() {
        return true;
    }

    private boolean validateSavePanel() {
        return true;
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        this.setupGeneralSidebarPanel();
        this.setupSeriesToDisplaySidebarPanel();
        this.setupOutputOptionsSidebarPanel();
        this.mSideBarControl.addUIElement(this.mGeneralPanel, this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_GENERAL"));
        this.mSideBarControl.addUIElement(this.mSeriesToDisplayPanel, this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SIERIES_TO_DISPLAY"));
        this.mSideBarControl.addUIElement(this.mOutputOptionsPanel, this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OUTPUT_OPTIONS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.mSideBarControl, gridBagConstraints, 0, 0, 1, 1, n, this.mMasterInsets);
        this.updateEnableStates();
    }

    public int getGroupBoxInnerMargin() {
        return 3;
    }

    private void updateEnableStates() {
        boolean bl = this.mFixedNumberTargetsRB.isSelected();
        this.mNumberSpinnerLabel.setEnabled(bl);
        this.mFixedNumberSpinner.setEnabled(bl);
        this.mPercentSpinnerLabel.setEnabled(!bl);
        this.mPercentSpinner.setEnabled(!bl);
        boolean bl2 = this.mTargetOverallModelSystemCheckBox.isSelected();
        this.mTargetSignificanceLevelLabel.setEnabled(bl2);
        this.mTargetSignificanceLevelTextField.setEnabled(bl2);
        boolean bl3 = this.mTargetImpactDiagramsCheckBox.isSelected();
        this.mTargetTypeLabel.setEnabled(bl3);
        this.mTargetTypeCB.setEnabled(bl3);
        this.mTargetLevelsSpinnerLabel.setEnabled(bl3);
        this.mTargetLevelsSpinner.setEnabled(bl3);
        boolean bl4 = !this.mSameAsForTargets.isSelected();
        bl2 = this.mSeriesOverallModelSystemCheckBox.isSelected();
        this.mSeriesSignificanceLevelLabel.setEnabled(bl2 && bl4);
        this.mSeriesSignificanceLevelTextField.setEnabled(bl2 && bl4);
        bl3 = this.mSeriesImpactDiagramsCheckBox.isSelected();
        this.mSeriesTypeLabel.setEnabled(bl3 && bl4);
        this.mSeriesTypeCB.setEnabled(bl3 && bl4);
        this.mSeriesLevelsSpinnerLabel.setEnabled(bl3 && bl4);
        this.mSeriesLevelsSpinner.setEnabled(bl3 && bl4);
        boolean bl5 = this.mSeriesOutlierRootCheckBox.isSelected();
        this.mSeriesOutlierRootCheckBox.setEnabled(true);
        this.mSeriesCausalLevelsSpinnerLabel.setEnabled(bl5);
        this.mSeriesCausalLevelsSpinner.setEnabled(bl5);
        this.mSeriesOutputComboboxLabel.setEnabled(bl5);
        this.mSeriesOutputCombobox.setEnabled(bl5);
        this.mSeriesOverallModelSystemCheckBox.setEnabled(bl4);
        this.mSeriesModelFitStatsAndOutliersCheckBox.setEnabled(bl4);
        this.mSeriesModelEffectsBuildSummaryCheckBox.setEnabled(bl4);
        this.mSeriesImpactDiagramsCheckBox.setEnabled(bl4);
        this.mSeriesSeriesPlotCheckBox.setEnabled(bl4);
        this.mSeriesResidualPlotCheckbox.setEnabled(bl4);
        this.mSeriesTopInputsCheckBox.setEnabled(bl4);
        this.mSeriesForcasteTableCheckBox.setEnabled(bl4);
    }

    private void initVars() {
        this.initGeneralPanelVars();
        this.initSeriesToDisplayVars();
        this.initOutputOptionVars();
    }

    public void setDefaults() {
        this.setGeneralDefault();
        this.setSeriesToDisplayDefault();
        this.setOutputOptionDefault();
        this.updateEnableStates();
    }

    private void setGeneralDefault() {
        this.mConfidenseIntervalWidthSpinner.setValue((Object)this.mTCMForecastGatingInfo.getConfidenceLevel());
        this.mOutlierThreshholdSpinner.setValue((Object)this.mTCMForecastGatingInfo.getOutlierThreshold());
    }

    private void setSeriesToDisplayDefault() {
        this.mFixedNumberTargetsRB.setSelected(true);
        this.mFixedNumberSpinner.setValue((Object)10);
        this.mGoodnessOfFitComboBox.setSelectedItem(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_ROOT_MEAN_SQUARE"));
        if (this.mTCMForecastGatingInfo.isMultiDimensionalData()) {
            this.mSelectDimValuesTable.reset();
        } else {
            this.mTargetVarList.removeAll();
            this.mSrcVariableList.loadFromActiveDataset();
        }
    }

    private void setOutputOptionDefault() {
        this.mTargetOverallModelSystemCheckBox.setSelected(true);
        this.mTargetSignificanceLevelTextField.setText(".05");
        this.mTargetModelFitStatsAndOutliersCheckBox.setSelected(false);
        this.mTargetModelEffectsBuildSummaryCheckBox.setSelected(false);
        this.mTargetImpactDiagramsCheckBox.setSelected(false);
        this.mTargetTypeCB.setSelectedItem(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_BOTH_CAUSES_AND_EFFECTS"));
        this.mTargetLevelsSpinner.setValue((Object)3);
        this.mTargetSeriesPlotCheckBox.setSelected(false);
        this.mTargetResidualPlotCheckbox.setSelected(false);
        this.mTargetTopInputsCheckBox.setSelected(false);
        this.mTargetForcasteTableCheckBox.setSelected(false);
        this.mSameAsForTargets.setSelected(true);
        this.mSeriesOverallModelSystemCheckBox.setSelected(false);
        this.mSeriesSignificanceLevelTextField.setText(".05");
        this.mSeriesModelFitStatsAndOutliersCheckBox.setSelected(false);
        this.mSeriesModelEffectsBuildSummaryCheckBox.setSelected(false);
        this.mSeriesImpactDiagramsCheckBox.setSelected(false);
        this.mSeriesTypeCB.setSelectedItem(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_BOTH_CAUSES_AND_EFFECTS"));
        this.mSeriesLevelsSpinner.setValue((Object)3);
        this.mSeriesSeriesPlotCheckBox.setSelected(false);
        this.mSeriesResidualPlotCheckbox.setSelected(false);
        this.mSeriesTopInputsCheckBox.setSelected(false);
        this.mSeriesForcasteTableCheckBox.setSelected(false);
        this.mModelFitRootMeanCheckBox.setSelected(false);
        this.mModelFitNormalizedBICCheckBox.setSelected(false);
        this.mModelFitRSquareCheckBox.setSelected(true);
        this.mModelFitAICCheckBox.setSelected(false);
        this.mModelFitRSquareErrorCheckBox.setSelected(false);
        this.mModelFitOutliersOverTimeCheckBox.setSelected(false);
        this.mModelFitTransformationCheckBox.setSelected(true);
        this.mSeriesOutlierRootCheckBox.setSelected(false);
        this.mSeriesCausalLevelsSpinner.setValue((Object)3);
        this.mSeriesOutputCombobox.setSelectedItem(0);
    }

    private void setGeneralPanelFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mConfidenseIntervalWidthSpinner);
        this.mComponentOrder.add(this.mOutlierThreshholdSpinner);
    }

    private void setSeriesToDisplayPanelFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mFixedNumberTargetsRB);
        this.mComponentOrder.add(this.mFixedNumberSpinner);
        this.mComponentOrder.add(this.mPercentageOfTargetsRB);
        this.mComponentOrder.add(this.mPercentSpinner);
        this.mComponentOrder.add(this.mGoodnessOfFitComboBox);
        if (this.mTCMForecastGatingInfo.isMultiDimensionalData()) {
            this.mComponentOrder.add(this.mSelectDimValuesTable);
            this.mComponentOrder.add(this.mFieldChooserButton);
            this.mComponentOrder.add(this.mDeleteButton);
            this.mComponentOrder.add(this.mCopyButton);
            this.mComponentOrder.add(this.mUpButton);
            this.mComponentOrder.add(this.mDownButton);
        } else {
            this.mComponentOrder.addAll(this.mVarSourceSortingPanel.getTabTraversalComponent());
            this.mComponentOrder.add(this.mSrcVariableList);
            this.mComponentOrder.addAll(this.mSelectorPanel.getTabTraversalComponent());
            this.mComponentOrder.add(this.mDimArrowButton);
            this.mComponentOrder.addAll(this.mVarManualOrderPanel.getTabTraversalComponent());
        }
    }

    private void setOutputOptionFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mTargetOverallModelSystemCheckBox);
        this.mComponentOrder.add(this.mTargetSignificanceLevelTextField);
        this.mComponentOrder.add(this.mTargetModelFitStatsAndOutliersCheckBox);
        this.mComponentOrder.add(this.mTargetModelEffectsBuildSummaryCheckBox);
        this.mComponentOrder.add(this.mTargetImpactDiagramsCheckBox);
        this.mComponentOrder.add(this.mTargetTypeCB);
        this.mComponentOrder.add(this.mTargetLevelsSpinner);
        this.mComponentOrder.add(this.mTargetSeriesPlotCheckBox);
        this.mComponentOrder.add(this.mTargetResidualPlotCheckbox);
        this.mComponentOrder.add(this.mTargetTopInputsCheckBox);
        this.mComponentOrder.add(this.mTargetForcasteTableCheckBox);
        this.mComponentOrder.add(this.mSameAsForTargets);
        this.mComponentOrder.add(this.mSeriesOverallModelSystemCheckBox);
        this.mComponentOrder.add(this.mSeriesSignificanceLevelTextField);
        this.mComponentOrder.add(this.mSeriesModelFitStatsAndOutliersCheckBox);
        this.mComponentOrder.add(this.mSeriesModelEffectsBuildSummaryCheckBox);
        this.mComponentOrder.add(this.mSeriesImpactDiagramsCheckBox);
        this.mComponentOrder.add(this.mSeriesTypeCB);
        this.mComponentOrder.add(this.mSeriesLevelsSpinner);
        this.mComponentOrder.add(this.mSeriesSeriesPlotCheckBox);
        this.mComponentOrder.add(this.mSeriesResidualPlotCheckbox);
        this.mComponentOrder.add(this.mSeriesTopInputsCheckBox);
        this.mComponentOrder.add(this.mSeriesForcasteTableCheckBox);
        this.mComponentOrder.add(this.mSeriesOutlierRootCheckBox);
        this.mComponentOrder.add(this.mSeriesOutputCombobox);
        this.mComponentOrder.add(this.mSeriesCausalLevelsSpinner);
        this.mComponentOrder.add(this.mModelFitRootMeanCheckBox);
        this.mComponentOrder.add(this.mModelFitNormalizedBICCheckBox);
        this.mComponentOrder.add(this.mModelFitRSquareCheckBox);
        this.mComponentOrder.add(this.mModelFitAICCheckBox);
        this.mComponentOrder.add(this.mModelFitRSquareErrorCheckBox);
        this.mComponentOrder.add(this.mModelFitOutliersOverTimeCheckBox);
        this.mComponentOrder.add(this.mModelFitTransformationCheckBox);
    }

    @Override
    public Vector<Object> getComponentOrder() {
        this.mComponentOrder.clear();
        JList jList = this.mSideBarControl.getItemList();
        this.mComponentOrder.add(jList);
        if (this.mSideBarControl.getSelectedIndex() == 0) {
            this.setGeneralPanelFocusTraversalPolicy();
        } else if (this.mSideBarControl.getSelectedIndex() == 1) {
            this.setSeriesToDisplayPanelFocusTraversalPolicy();
        }
        if (this.mSideBarControl.getSelectedIndex() == 2) {
            this.setOutputOptionFocusTraversalPolicy();
        }
        return this.mComponentOrder;
    }

    private void initGeneralPanelVars() {
        this.mConfidenseIntervalWidthLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_CONFIDENCE_INTERVAL_WIDTH");
        this.mConfidenseIntervalWidthSpinner = TCMUtilities.createPercentSpinner(this.mConfidenseIntervalWidthLabel);
        this.mOutlierThreshholdLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OUTLIER_THRESHOLD");
        this.mOutlierThreshholdSpinner = TCMUtilities.createPercentSpinner(this.mConfidenseIntervalWidthLabel);
    }

    private void initSeriesToDisplayVars() {
        this.mSideBarControl = new DataSpecSidebarSelectorPanel(this.mTCMForcastingDlgParent, "OptionsTab", this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SELECT_AN_ITEM_LIST_HEADER"), 83);
        this.mFixedNumberTargetsRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_FIXED_NUM_TARGETS_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.updateEnableStates();
            }
        });
        this.mPercentageOfTargetsRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_PERCENTAGE_TARGETS_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.updateEnableStates();
            }
        });
        this.mDisplayTargetsRadioButtonGroup = new SpssButtonGroup();
        this.mDisplayTargetsRadioButtonGroup.add(this.mFixedNumberTargetsRB);
        this.mDisplayTargetsRadioButtonGroup.add(this.mPercentageOfTargetsRB);
        this.mNumberSpinnerLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_NUMBER_SPINNER_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 30, 1);
        IntTextField intTextField = new IntTextField(1, 30, true);
        intTextField.setHorizontalAlignment(4);
        this.mFixedNumberSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mNumberSpinnerLabel.setLabelFor((Component)this.mFixedNumberSpinner);
        this.mPercentSpinnerLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_PERCENTAGE_SPINNER_LABEL");
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(0, 0, 100, 1);
        IntTextField intTextField2 = new IntTextField(0, 100, true);
        intTextField.setHorizontalAlignment(4);
        this.mPercentSpinner = new NumberSpinner(intTextField2, spinnerNumberModel2);
        this.mPercentSpinnerLabel.setLabelFor((Component)this.mPercentSpinner);
        this.mGoodnessOfFitComboLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_COMBO_LABEL");
        this.mGoodnessOfFitComboBox = new JComboBox<String>(new String[]{this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_R_SQUARE"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_ROOT_MEAN_SQUARE"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_RSQUARE_ERROR"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_NORMALIZED_BIC"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_AIC")});
        this.mGoodnessOfFitComboLabel.setLabelFor(this.mGoodnessOfFitComboBox);
        this.mSrcListFieldsLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_FIELDS_SRC_LABEL");
        this.mTargetListFieldsToDisplayLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_FIELDS_TO_DISPLAY_TARGET_LABEL");
        this.mInfoText = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_FIELDS_TO_DISPLAY_TARGET_LABEL");
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_DELETE_BUTTON_IMAGE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.mSelectDimValuesTable.deleteSelectedRows();
            }
        };
        this.mDeleteButton = this.createButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_DELETE_BUTTON_IMAGE", toggleButtonAction);
        TCMUtilities.addTooltip(this.mTCMForcastingDlgParent, this.mDeleteButton, "IDS_TCM_FORCASTING_DELETE_BUTTON_IMAGE");
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_COPY_BUTTON_IMAGE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.doCopySelectedRow();
            }
        };
        this.mCopyButton = this.createButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_COPY_BUTTON_IMAGE", toggleButtonAction2);
        TCMUtilities.addTooltip(this.mTCMForcastingDlgParent, this.mCopyButton, "IDS_TCM_FORCASTING_COPY_BUTTON_IMAGE");
        this.mUpButton = this.createButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_UP_BUTTON_IMAGE", null);
        TCMUtilities.addTooltip(this.mTCMForcastingDlgParent, this.mUpButton, "IDS_TCM_FORCASTING_UP_BUTTON_IMAGE");
        this.mDownButton = this.createButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_DOWN_BUTTON_IMAGE", null);
        TCMUtilities.addTooltip(this.mTCMForcastingDlgParent, this.mDownButton, "IDS_TCM_FORCASTING_DOWN_BUTTON_IMAGE");
        if (this.mTCMForecastGatingInfo.isMultiDimensionalData()) {
            this.initMultiDimenionVars();
        } else {
            this.initSingleDimVars();
        }
    }

    private void initMultiDimenionVars() {
        this.mSelectDimValuesTable = new TCMSelectDimensionValuesTable(this.mTCMForcastingDlgParent, this.mTCMForecastGatingInfo, this.mTCMForcastingDlgParent.getResourceBundle(), false, false, true, false);
        this.mSelectDimValuesTableScrollPane = new JScrollPane(this.mSelectDimValuesTable);
        this.mSelectDimValuesTableScrollPane.setPreferredSize(new Dimension(400, 200));
        this.mTableRowManagementHelper = new TableRowManagementHelper((JTable)this.mSelectDimValuesTable, this.mUpButton, this.mDownButton);
    }

    private void initSingleDimVars() {
        this.mSrcVariableList = new TCMSrcVariableList(VariableList.VarMoveType.eMoveOriginal, this.mTCMForecastGatingInfo, true, false);
        this.mSrcVariableList.setIdentifier(SRC_VAR_LIST);
        this.mSrcVariableList.setContextMenuFlags(this.mSrcVariableList.getContextMenuFlags() | 8);
        this.mSrcVariableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth() + 200, this.mSrcVariableList.getFixedCellHeight() * 4 + 2));
        this.mSrcVariableList.setDragSupported(true);
        this.mSrcListLabel = DialogUtil.createLabel(this.mTCMForcastingDlgParent, "IDS_TCM_DATA_STRUC_SOURCE_LABEL");
        this.mSrcListLabel.setLabelFor(this.mSrcVariableList);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVariableList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mSelectorPanel = new VariableSelectorPanel((SrcVariableList)this.mSrcVariableList, (BaseDialog)this.mTCMForcastingDlgParent, false);
        this.mVarSourceSortingPanel = new VarSourceSortingPanel(this.mSrcVariableList, this.mTCMForcastingDlgParent, true);
        this.mTargetVarList = new TargetVariableList();
        TCMGatingVarListModel tCMGatingVarListModel = new TCMGatingVarListModel(this.mTargetVarList);
        this.mTargetVarList.setModel(tCMGatingVarListModel);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setSelectionMode(1);
        this.mTargetVarList.setIdentifier(TARGET_LIST_KEY);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth() + 200, this.mTargetVarList.getFixedCellHeight() * 4 + 2));
        this.mTargetVarList.setDragSupported(true);
        this.mTargetVarList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.mTargetListFieldsToDisplayLabel = DialogUtil.createLabel(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_OPTIONSTAB_SD_FIELDS_TO_DISPLAY_TARGET_LABEL");
        this.mTargetListFieldsToDisplayLabel.setLabelFor(this.mTargetVarList);
        this.mVarManualOrderPanel = new VarManualReorderPanel(this.mTargetVarList);
        JScrollPane jScrollPane = this.mVarManualOrderPanel.getListScrollPane();
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.mDimArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDimArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mDimArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void initOutputOptionVars() {
        this.mTargetOverallModelSystemCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_NETWORK_GRAPH_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.updateEnableStates();
            }
        });
        this.mTargetModelFitStatsAndOutliersCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_MODEL_FIT_GRAPH_CHECKBOX");
        this.mTargetModelEffectsBuildSummaryCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_MODEL_EFFECTS_CHECKBOX");
        this.mTargetImpactDiagramsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_IMPACT_DIAGRAMS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.updateEnableStates();
            }
        });
        this.mTargetSeriesPlotCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_SERIES_PLOTS_CHECKBOX");
        this.mTargetResidualPlotCheckbox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_RESIDUAL_PLOTS_CHECKBOX");
        this.mTargetTopInputsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TOP_INPUTS_CHECKBOX");
        this.mTargetForcasteTableCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_FORECAST_TABLE_CHECKBOX");
        this.mTargetSignificanceLevelLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_SIGNIFICANCE_LEVEL_LABEL");
        this.mTargetSignificanceLevelTextField = new FloatTextField(1.0E-6, 0.999999, 6);
        this.mTargetSignificanceLevelLabel.setLabelFor((Component)this.mTargetSignificanceLevelTextField);
        this.mTargetTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_LABEL");
        this.mTargetTypeCB = new JComboBox<String>(new String[]{this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_EFFECTS"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_CAUSES"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_TYPES_COMBOBOX_BOTH_CAUSES_AND_EFFECTS")});
        this.mTargetTypeLabel.setLabelFor(this.mTargetTypeCB);
        this.mTargetLevelsSpinnerLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_TARGETS_LEVELS_SPINNER_LABEL");
        this.mTargetLevelsSpinner = new NumberSpinner(1, 1, 99, true, 1);
        this.mTargetLevelsSpinnerLabel.setLabelFor((Component)this.mTargetLevelsSpinner);
        this.mSameAsForTargets = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_SAME_AS_FOPR_TARGETS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.updateEnableStates();
            }
        });
        this.mSeriesOverallModelSystemCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_NETWORK_GRAPH_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.updateEnableStates();
            }
        });
        this.mSeriesModelFitStatsAndOutliersCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_MODEL_FIT_GRAPH_CHECKBOX");
        this.mSeriesModelEffectsBuildSummaryCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_MODEL_EFFECTS_CHECKBOX");
        this.mSeriesImpactDiagramsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_IMPACT_DIAGRAMS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.updateEnableStates();
            }
        });
        this.mSeriesSeriesPlotCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_SERIES_PLOTS_CHECKBOX");
        this.mSeriesResidualPlotCheckbox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_RESIDUAL_PLOTS_CHECKBOX");
        this.mSeriesTopInputsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_TOP_INPUTS_CHECKBOX");
        this.mSeriesForcasteTableCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_FORECAST_TABLE_CHECKBOX");
        this.mSeriesSignificanceLevelLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_SIGNIFICANCE_LEVEL_LABEL");
        this.mSeriesSignificanceLevelTextField = new FloatTextField(2);
        this.mSeriesSignificanceLevelLabel.setLabelFor((Component)this.mSeriesSignificanceLevelTextField);
        this.mSeriesTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_TYPES_COMBOBOX_LABEL");
        this.mSeriesTypeCB = new JComboBox<String>(new String[]{this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_TYPES_COMBOBOX_EFFECTS"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_TYPES_COMBOBOX_CAUSES"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_TYPES_COMBOBOX_BOTH_CAUSES_AND_EFFECTS")});
        this.mSeriesLevelsSpinnerLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_LEVELS_SPINNER_LABEL");
        this.mSeriesLevelsSpinner = new NumberSpinner(1, 1, 100, true, 1);
        this.mSeriesLevelsSpinnerLabel.setLabelFor((Component)this.mSeriesLevelsSpinner);
        this.mSeriesOutlierRootCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_OUTLIER_ROOT_CAUSE_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingOptionsTab.this.updateEnableStates();
            }
        });
        this.mSeriesCausalLevelsSpinnerLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_CAUSAL_LEVELS_SPINNER_LABEL");
        this.mSeriesCausalLevelsSpinner = new NumberSpinner(1, 1, 5, true, 1);
        this.mSeriesOutputComboboxLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_OUTPUT_COMBOBOX_LABEL");
        this.mSeriesOutputCombobox = new JComboBox<String>(new String[]{this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_INTERACTIVE_OUTLIERS_TABLE_CHART"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_PIVOT_TABLE_OUTLIERS"), this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_SERIES_INTERACTIVE_AND_PIVOT_TABLES")});
        this.mGoodnessOfFitComboLabel.setLabelFor(this.mGoodnessOfFitComboBox);
        this.mModelFitRootMeanCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_MF_SERIES_ROOT_MEAN_SQUARE_CHECKBOX");
        this.mModelFitNormalizedBICCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_MF_SERIES_NORMALIZED_BIC_CHECKBOX");
        this.mModelFitRSquareCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_MF_SERIES_RSQUARE_CHECKBOX");
        this.mModelFitAICCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_MF_SERIES_AIC_CHECKBOX");
        this.mModelFitRSquareErrorCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_MF_SERIES_RSQUARE_ERROR_CHECKBOX");
        this.mModelFitOutliersOverTimeCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_MF_SERIES_OUTLIERS_OVER_TIME_CHECKBOX");
        this.mModelFitTransformationCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_OPTIONSTAB_MF_SERIES_SERIES_TRANSFORMATIONS_CHECKBOX");
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    private void resetGeneralPanel() {
    }

    private void resetSeriesToDisplayPanel() {
    }

    private void resetOutputOptionPanel() {
    }

    private String formatDouble(double d, int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }

    private void setupGeneralSidebarPanel() {
        this.mGeneralPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.mConfidenseIntervalWidthLabel);
        jPanel.add((Component)this.mConfidenseIntervalWidthSpinner);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mGeneralPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.mOutlierThreshholdLabel);
        jPanel.add((Component)this.mOutlierThreshholdSpinner);
        DialogUtil.addUsingGBL(this.mGeneralPanel, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mGeneralPanel, new JPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setGeneralPanelFocusTraversalPolicy();
    }

    private void setupSeriesToDisplaySidebarPanel() {
        this.mSeriesToDisplayPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        JPanel jPanel = this.getDisplayTargetsBestFittingPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mSeriesToDisplayPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.getSpecifyIndividualSeriesPanel(this.mTCMForecastGatingInfo.isMultiDimensionalData());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mSeriesToDisplayPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setSeriesToDisplayPanelFocusTraversalPolicy();
    }

    private JPanel getSpecifyIndividualSeriesPanel(boolean bl) {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_SPECIFY_INDIVIDUAL_SERIES_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        JPanel jPanel2 = bl ? this.getSelectDimensionValuesTablePanel() : this.getFieldsAndDimensionsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getFieldsAndDimensionsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mVarSourceSortingPanel, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 2, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSelectorPanel, gridBagConstraints, 0, 3, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDimArrowButton, gridBagConstraints, 1, 2, 1, 1, 10, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetListFieldsToDisplayLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVarManualOrderPanel, gridBagConstraints, 2, 1, 1, 2, n, insets);
        return jPanel;
    }

    private JPanel getDisplayTargetsBestFittingPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_DISPLAY_TARGETS_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFixedNumberTargetsRB, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mNumberSpinnerLabel);
        jPanel2.add((Component)this.mFixedNumberSpinner);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageOfTargetsRB, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.mPercentSpinnerLabel);
        jPanel3.add((Component)this.mPercentSpinner);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(this.mGoodnessOfFitComboLabel);
        jPanel4.add(this.mGoodnessOfFitComboBox);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 4, 1, 1, n, insets);
        return jPanel;
    }

    private void setupOutputOptionsSidebarPanel() {
        this.mOutputOptionsPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        JPanel jPanel = this.getOutputForTargetsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mOutputOptionsPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.getOutputForSeriesPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mOutputOptionsPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel3 = this.getModelFitPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mOutputOptionsPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mOutputOptionsPanel, new JPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setOutputOptionFocusTraversalPolicy();
    }

    private JPanel getOutputForTargetsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_OUTPUT_FOR_TARGETS_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        Insets insets3 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        Insets insets4 = new Insets(0, insets3.left, insets3.bottom, insets3.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetOverallModelSystemCheckBox, gridBagConstraints, 0, 0, 1, 1, n, this.mLeftSpaceInset);
        JPanel jPanel2 = this.getSignificanceLevelPanel(this.mTargetSignificanceLevelLabel, this.mTargetSignificanceLevelTextField);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetModelFitStatsAndOutliersCheckBox, gridBagConstraints, 0, 2, 1, 1, n, this.mLeftSpaceInset);
        DialogUtil.addUsingGBL(jPanel, this.mTargetModelEffectsBuildSummaryCheckBox, gridBagConstraints, 0, 3, 1, 1, n, this.mLeftSpaceInset);
        DialogUtil.addUsingGBL(jPanel, this.mTargetImpactDiagramsCheckBox, gridBagConstraints, 0, 4, 1, 1, n, this.mLeftSpaceInset);
        JPanel jPanel3 = this.getTargetTypeLevelsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetSeriesPlotCheckBox, gridBagConstraints, 1, 0, 1, 1, n, this.mRightSpaceInsets);
        DialogUtil.addUsingGBL(jPanel, this.mTargetResidualPlotCheckbox, gridBagConstraints, 1, 1, 1, 1, n, this.mRightSpaceInsets);
        DialogUtil.addUsingGBL(jPanel, this.mTargetTopInputsCheckBox, gridBagConstraints, 1, 2, 1, 1, n, this.mRightSpaceInsets);
        DialogUtil.addUsingGBL(jPanel, this.mTargetForcasteTableCheckBox, gridBagConstraints, 1, 3, 1, 1, n, this.mRightSpaceInsets);
        return jPanel;
    }

    private JPanel getOutputForSeriesPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_OO_OUTPUT_FOR_SERIES_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        Insets insets3 = new Insets(insets2.top, insets2.left, 0, insets2.right);
        Insets insets4 = new Insets(insets2.top, insets2.left + 30, insets2.bottom, insets2.right);
        Insets insets5 = new Insets(0, insets2.left + 30, insets2.bottom, insets2.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSameAsForTargets, gridBagConstraints, 0, 0, 1, 1, n, this.mLeftSpaceInset);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSeriesOverallModelSystemCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        JPanel jPanel2 = this.getSignificanceLevelPanel(this.mSeriesSignificanceLevelLabel, this.mSeriesSignificanceLevelTextField);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSeriesModelFitStatsAndOutliersCheckBox, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSeriesModelEffectsBuildSummaryCheckBox, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSeriesImpactDiagramsCheckBox, gridBagConstraints, 0, 5, 1, 1, n, insets3);
        JPanel jPanel3 = this.getSeriesTypeLevelsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 6, 1, 1, n, insets5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSeriesOutlierRootCheckBox, gridBagConstraints, 0, 7, 1, 1, n, this.mLeftSpaceInset);
        JPanel jPanel4 = this.getOutlierRootLevelCausePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 8, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSeriesSeriesPlotCheckBox, gridBagConstraints, 1, 1, 1, 1, n, this.mRightSpaceInsets);
        DialogUtil.addUsingGBL(jPanel, this.mSeriesResidualPlotCheckbox, gridBagConstraints, 1, 2, 1, 1, n, this.mRightSpaceInsets);
        DialogUtil.addUsingGBL(jPanel, this.mSeriesTopInputsCheckBox, gridBagConstraints, 1, 3, 1, 1, n, this.mRightSpaceInsets);
        DialogUtil.addUsingGBL(jPanel, this.mSeriesForcasteTableCheckBox, gridBagConstraints, 1, 4, 1, 1, n, this.mRightSpaceInsets);
        return jPanel;
    }

    private JPanel getSignificanceLevelPanel(JLabel jLabel, FloatTextField floatTextField) {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)floatTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getTargetTypeLevelsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetTypeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTargetTypeCB, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetLevelsSpinnerLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTargetLevelsSpinner, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getSeriesTypeLevelsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSeriesTypeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSeriesTypeCB, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSeriesLevelsSpinnerLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSeriesLevelsSpinner, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getOutlierRootLevelCausePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mSeriesOutputComboboxLabel);
        jPanel2.add(this.mSeriesOutputCombobox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.mSeriesCausalLevelsSpinnerLabel);
        jPanel3.add((Component)this.mSeriesCausalLevelsSpinner);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getModelFitPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        JPanel jPanel2 = this.getModelFitAcrossAllModelsPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 3, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mModelFitOutliersOverTimeCheckBox, gridBagConstraints, 1, 0, 1, 1, n, new Insets(insets.top + 15, this.mLeftSpaceInset.left, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mModelFitTransformationCheckBox, gridBagConstraints, 1, 1, 1, 1, n, this.mLeftSpaceInset);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getModelFitAcrossAllModelsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_MF_MODEL_FIT_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = this.mMasterInsets;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mModelFitRSquareCheckBox, gridBagConstraints, 0, 0, 1, 1, n, this.mLeftSpaceInset);
        DialogUtil.addUsingGBL(jPanel, this.mModelFitRootMeanCheckBox, gridBagConstraints, 0, 1, 1, 1, n, this.mLeftSpaceInset);
        DialogUtil.addUsingGBL(jPanel, this.mModelFitRSquareErrorCheckBox, gridBagConstraints, 0, 2, 1, 1, n, this.mLeftSpaceInset);
        DialogUtil.addUsingGBL(jPanel, this.mModelFitNormalizedBICCheckBox, gridBagConstraints, 1, 0, 1, 1, n, this.mLeftRightSpaceInsets);
        DialogUtil.addUsingGBL(jPanel, this.mModelFitAICCheckBox, gridBagConstraints, 1, 1, 1, 1, n, this.mLeftRightSpaceInsets);
        return jPanel;
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return null;
    }

    public JPanel getSelectDimensionValuesTablePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = this.mMasterInsets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSelectDimValuesTableScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.setupAddUpDownRemoveCmdButtonPanel();
        DialogUtil.normalizeLabelWidths(jPanel2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupAddUpDownRemoveCmdButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = this.mMasterInsets;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_MULTI_FIELD_CHOOSER_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector<ISpssVariable> vector = TCMUtilities.getMetricVariables(TCMForcastingOptionsTab.this.mTCMForecastGatingInfo, false);
                MultiFieldChooserDlg multiFieldChooserDlg = new MultiFieldChooserDlg(TCMForcastingOptionsTab.this.mTCMForcastingDlgParent, TCMForcastingOptionsTab.this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_SPECIFY_INDIVIDUAL_SERIES_GRPBX"), vector);
                multiFieldChooserDlg.setVisible(true);
                if (multiFieldChooserDlg.continuePressed()) {
                    ISpssVariable[] iSpssVariableArray = multiFieldChooserDlg.getSelectedFields();
                    TCMForcastingOptionsTab.this.mSelectDimValuesTable.addNewVariables(iSpssVariableArray);
                }
            }
        };
        this.mFieldChooserButton = this.createButton(this.mTCMForcastingDlgParent, "IDS_TCM_FIELD_CHOOSER_BUTTON_IMAGE", toggleButtonAction);
        TCMUtilities.addTooltip(this.mTCMForcastingDlgParent, this.mFieldChooserButton, "IDS_TCM_FIELD_CHOOSER_BUTTON_IMAGE");
        DialogUtil.addUsingGBL(jPanel2, this.mFieldChooserButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mDeleteButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mCopyButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mUpButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mDownButton, gridBagConstraints, 0, 4, 1, 1, n, insets);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JButton createButton(TCMForcastingDlg tCMForcastingDlg, String string, Action action) {
        String string2;
        ImageIcon imageIcon = new ImageIcon(this.mTCMForcastingDlgParent.getResImageURL(string));
        JButton jButton = new JButton(imageIcon);
        if (action != null) {
            jButton.addActionListener(action);
        }
        if ((string2 = this.getResString(string + "_TOOLTIP")) != null) {
            jButton.setToolTipText(string2);
        }
        return jButton;
    }

    private Vector<ISpssVariable> getUnusedVarsList(Vector<ISpssVariable> vector) {
        Vector<ISpssVariable> vector2 = new Vector<ISpssVariable>();
        for (int i = 0; i < vector.size(); ++i) {
            ISpssVariable iSpssVariable = vector.get(i);
            if (this.mSelectDimValuesTable.containsVariable(iSpssVariable.getName())) continue;
            vector2.add(iSpssVariable);
        }
        return vector2;
    }

    public Vector<ISpssVariable> getNumericFields() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.columnCount();
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            if (!iSpssVariable.getFormat().getFormatType().isNumericFormat()) continue;
            vector.add(iSpssVariable);
        }
        return vector;
    }

    private void doCopySelectedRow() {
        int n = this.mSelectDimValuesTable.getSelectedRow();
        if (n >= 0) {
            this.mSelectDimValuesTable.copyRow(n);
        }
    }

    public String getGoodnessOfFitSyntax() {
        String string = "";
        String string2 = (String)this.mGoodnessOfFitComboBox.getSelectedItem();
        if (string2.equals(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_ROOT_MEAN_SQUARE"))) {
            string = "RMSPE";
        } else if (string2.equals(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_NORMALIZED_BIC"))) {
            string = "BIC";
        } else if (string2.equals(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_R_SQUARE"))) {
            string = "RSQUARE";
        } else if (string2.equals(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_AIC"))) {
            string = "AIC";
        } else if (string2.equals(this.getResString("IDS_TCM_FORCASTING_OPTIONSTAB_SD_GOODNESS_OF_FIT_RSQUARE_ERROR"))) {
            string = "RMSE";
        }
        return string;
    }

    public String getOutputDisplaySyntax() {
        String string = null;
        if (this.mSeriesOutputCombobox.getSelectedIndex() == 0) {
            string = "INTERACTIVE";
        } else if (this.mSeriesOutputCombobox.getSelectedIndex() == 1) {
            string = "TABLE";
        } else if (this.mSeriesOutputCombobox.getSelectedIndex() == 2) {
            string = "BOTH";
        }
        return string;
    }

    private static enum OutputType {
        TARGETS,
        SERIES,
        BOTH;

    }

    class TCMGatingVarListModel
    extends VarListModel {
        private ISpssVariable mRemovedVar;

        public TCMGatingVarListModel(VariableList variableList) {
            super(variableList);
            this.mRemovedVar = null;
        }

        @Override
        public boolean removeElement(ISpssVariable iSpssVariable) {
            this.mRemovedVar = null;
            int n = this.mVariables.indexOf(iSpssVariable);
            boolean bl = this.mVariables.removeElement(iSpssVariable);
            if (n >= 0) {
                this.mRemovedVar = iSpssVariable;
                this.fireIntervalRemoved(this, n, n);
            }
            return bl;
        }

        public ISpssVariable getRemovedVar() {
            return this.mRemovedVar;
        }
    }
}

