/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.charteditor.component.DateTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.CyclicPeriodModel;
import com.spss.java_client.ui.dialogs.TCM.controls_models.CyclicPeriodTable;
import com.spss.java_client.ui.dialogs.TCM.controls_models.DateTimeTable;
import com.spss.java_client.ui.dialogs.TCM.controls_models.DateTimeTableModel;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class TCMForcastingModelTab
extends BaseProcedureTab {
    private TCMForcastingDlg mTCMForcastingDlgParent;
    boolean mIsDateTimeType = true;
    TCMForecastGatingInfo mTCMForecastGatingInfo;
    JRadioButton mLoadFromModelFileRB;
    JRadioButton mReestimateFromDataRB;
    SpssButtonGroup mModelParamsRadioButtonGroup;
    JRadioButton mAllObserevationsRB;
    JRadioButton mByStartAndEndTimesRB;
    JRadioButton mByLatestOrEarliestObservatiosRB;
    SpssButtonGroup mEstimationPeriodRadioButtonGroup;
    CyclicPeriodModel mCyclicPeriodModel;
    CyclicPeriodTable mCyclicPeriodTable;
    JScrollPane mCyclicPeriodTableScrollPane;
    DateTimeTableModel mDateTimeTableModel;
    DateTimeTable mDateTimeTable;
    JScrollPane mDateTimeTableScrollPane;
    private JLabel mTypeLabel;
    private JComboBox mTypeComboBox;
    private JLabel mNumObservationsLabel;
    private JLabel mObservationsToExcludeLabel;
    private NumberSpinner mObservationsToExcludeSpinner;
    private JCheckBox mExtendRecordsIntoFutureCheckBox;
    private NumberSpinner mExtendRecordsIntoFutureSpinner;
    private IntTextField mNumObservationsEdit;

    public TCMForcastingModelTab(TCMForcastingDlg tCMForcastingDlg, TCMForecastGatingInfo tCMForecastGatingInfo) {
        super(tCMForcastingDlg, true);
        this.mTCMForcastingDlgParent = tCMForcastingDlg;
        this.mIsDateTimeType = tCMForecastGatingInfo.isDateTimeType();
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.initialize();
        this.setDefaults();
        this.updateEnableStates();
    }

    public boolean doValidateTab() {
        String string = null;
        if (this.mReestimateFromDataRB.isSelected() && this.mByStartAndEndTimesRB.isSelected()) {
            boolean bl;
            if (this.mTCMForecastGatingInfo.isDateTimeType()) {
                bl = !this.mDateTimeTableModel.getDateTimeTableInfo().areAllStartEndPeriodsDefined();
            } else {
                boolean bl2 = bl = !this.mCyclicPeriodModel.getCyclicTableModelInfo().areAllStartEndPeriodsDefined();
            }
            if (bl) {
                string = this.getResString("IDS_TCM_SCENARIOPERIOD_START_END_MUST_BE_SPECIFIED_ERROR_MESSAGE");
            }
            if (string == null) {
                JTable jTable = this.mDateTimeTable != null ? this.mDateTimeTable : this.mCyclicPeriodTable;
                TCMUtilities.stopTableEditing(jTable);
                ArrayList<Integer> arrayList = this.getColumnsWithStartGreaterThanEnd(jTable.getModel());
                if (arrayList != null && arrayList.size() > 0) {
                    this.mTCMForcastingDlgParent.selectModelTab();
                    jTable.changeSelection(0, arrayList.get(0), true, false);
                    string = this.getResString("IDS_TS_FORECASTING_ESTIMATION_START_AFTER_END_ERROR");
                }
            }
        }
        if (string != null) {
            TCMUtilities.throwErrorDialog((JDialog)((Object)this.mTCMForcastingDlgParent), string);
        }
        return string == null;
    }

    private ArrayList<Integer> getColumnsWithStartGreaterThanEnd(TableModel tableModel) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 1; i < tableModel.getColumnCount(); ++i) {
            Long l = (Long)tableModel.getValueAt(0, i);
            Long l2 = (Long)tableModel.getValueAt(1, i);
            if (l <= l2) continue;
            arrayList.add(i);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_tcm_forecasting_model";
    }

    @Override
    protected boolean validateTab() {
        return true;
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
    }

    private void initialize() {
        this.initVars();
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        JPanel jPanel2 = this.getModelParametersPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.getForecastingPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.updateEnableStates();
    }

    private void updateEnableStates() {
        boolean bl = this.mReestimateFromDataRB.isSelected();
        this.mAllObserevationsRB.setEnabled(bl);
        this.mByStartAndEndTimesRB.setEnabled(bl);
        this.mByLatestOrEarliestObservatiosRB.setEnabled(bl);
        boolean bl2 = this.mByStartAndEndTimesRB.isSelected();
        if (this.mIsDateTimeType) {
            this.mDateTimeTable.setEnabled(bl && bl2);
            this.mDateTimeTableScrollPane.setEnabled(bl && bl2);
        } else {
            this.mCyclicPeriodTable.setEnabled(bl && bl2);
            this.mCyclicPeriodTableScrollPane.setEnabled(bl && bl2);
        }
        boolean bl3 = this.mByLatestOrEarliestObservatiosRB.isSelected();
        this.mTypeLabel.setEnabled(bl && bl3);
        this.mTypeComboBox.setEnabled(bl && bl3);
        this.mNumObservationsLabel.setEnabled(bl && bl3);
        this.mNumObservationsEdit.setEnabled(bl && bl3);
        this.mObservationsToExcludeLabel.setEnabled(bl && bl3);
        this.mObservationsToExcludeSpinner.setEnabled(bl && bl3);
        boolean bl4 = this.mExtendRecordsIntoFutureCheckBox.isSelected();
        this.mExtendRecordsIntoFutureSpinner.setEnabled(bl4);
    }

    public void setDefaults() {
        Object object;
        this.mLoadFromModelFileRB.setSelected(true);
        this.mAllObserevationsRB.setSelected(this.getDefaultEstimationPeriodType() == TCMForecastGatingInfo.EstimationPeriodType.ALL_OBSRVATIONS);
        this.mByStartAndEndTimesRB.setSelected(this.getDefaultEstimationPeriodType() == TCMForecastGatingInfo.EstimationPeriodType.START_END_TIMES);
        this.mByLatestOrEarliestObservatiosRB.setSelected(this.getDefaultEstimationPeriodType() == TCMForecastGatingInfo.EstimationPeriodType.LATEST || this.getDefaultEstimationPeriodType() == TCMForecastGatingInfo.EstimationPeriodType.EARLIEST);
        this.mExtendRecordsIntoFutureCheckBox.setSelected(true);
        this.mExtendRecordsIntoFutureSpinner.setValue((Object)1);
        TCMUtilities.stopTableEditing(this.mDateTimeTable);
        TCMUtilities.stopTableEditing(this.mCyclicPeriodTable);
        if (this.mDateTimeTableModel != null) {
            this.mDateTimeTableModel.reset();
        }
        if (this.mCyclicPeriodModel != null) {
            this.mCyclicPeriodModel.reset();
        }
        this.mTypeComboBox.setSelectedItem(this.getResString("IDS_TCM_FORCASTING_MODELTAB_FORECAST_EARLIEST_TEXT"));
        if (this.getDefaultEstimationPeriodType() == TCMForecastGatingInfo.EstimationPeriodType.LATEST || this.getDefaultEstimationPeriodType() == TCMForecastGatingInfo.EstimationPeriodType.EARLIEST) {
            object = this.getDefaultEstimationPeriodType() == TCMForecastGatingInfo.EstimationPeriodType.LATEST ? this.getResString("IDS_TCM_FORCASTING_MODELTAB_FORECAST_LATEST_TEXT") : this.getResString("IDS_TCM_FORCASTING_MODELTAB_FORECAST_EARLIEST_TEXT");
            this.mTypeComboBox.setSelectedItem(object);
        }
        object = this.mTCMForecastGatingInfo.getNumberOfObservations() != null ? this.mTCMForecastGatingInfo.getNumberOfObservations() : 1000L;
        this.mNumObservationsEdit.setText("" + object);
        Long l = this.mTCMForecastGatingInfo.getNumberOfObservationsToExclude() != null ? this.mTCMForecastGatingInfo.getNumberOfObservationsToExclude() : 0L;
        this.mObservationsToExcludeSpinner.setValue((Object)l);
        this.updateEnableStates();
    }

    public TCMForecastGatingInfo.EstimationPeriodType getDefaultEstimationPeriodType() {
        return this.mTCMForecastGatingInfo.getEstmationPeriodType() != null ? this.mTCMForecastGatingInfo.getEstmationPeriodType() : TCMForecastGatingInfo.EstimationPeriodType.ALL_OBSRVATIONS;
    }

    @Override
    protected void aboutToShowTab() {
    }

    private void initVars() {
        this.mLoadFromModelFileRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_MODELTAB_LOAD_FROM_MODEL_FILE_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingModelTab.this.updateEnableStates();
            }
        });
        this.mReestimateFromDataRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_MODELTAB_REESTIMATE_FROM_DATA_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingModelTab.this.updateEnableStates();
            }
        });
        this.mModelParamsRadioButtonGroup = new SpssButtonGroup();
        this.mModelParamsRadioButtonGroup.add(this.mLoadFromModelFileRB);
        this.mModelParamsRadioButtonGroup.add(this.mReestimateFromDataRB);
        this.mAllObserevationsRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_MODELTAB_ALL_OSERVATIONS_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingModelTab.this.updateEnableStates();
            }
        });
        this.mByStartAndEndTimesRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_MODELTAB_BY_START_END_TIMES_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingModelTab.this.updateEnableStates();
            }
        });
        this.mByLatestOrEarliestObservatiosRB = DialogUtil.createRadioButton(this.mTCMForcastingDlgParent, "IDS_TCM_FORCASTING_MODELTAB_BY_LATEST_EARLIEST_START_TIMES_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingModelTab.this.updateEnableStates();
            }
        });
        if (this.mIsDateTimeType) {
            this.mDateTimeTableModel = new DateTimeTableModel(this.mTCMForcastingDlgParent.getResourceBundle(), this.mTCMForecastGatingInfo);
            this.mDateTimeTable = new DateTimeTable(this.mDateTimeTableModel);
            this.mDateTimeTableScrollPane = new JScrollPane(this.mDateTimeTable);
        } else {
            this.mCyclicPeriodModel = new CyclicPeriodModel(this.mTCMForcastingDlgParent.getResourceBundle(), this.mTCMForecastGatingInfo);
            this.mCyclicPeriodTable = new CyclicPeriodTable(this.mCyclicPeriodModel);
            this.mCyclicPeriodTableScrollPane = new JScrollPane(this.mCyclicPeriodTable);
        }
        this.mEstimationPeriodRadioButtonGroup = new SpssButtonGroup();
        this.mEstimationPeriodRadioButtonGroup.add(this.mAllObserevationsRB);
        this.mEstimationPeriodRadioButtonGroup.add(this.mByStartAndEndTimesRB);
        this.mEstimationPeriodRadioButtonGroup.add(this.mByLatestOrEarliestObservatiosRB);
        this.mTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_MODELTAB_TYPE_COMBOBOX_LABEL");
        this.mTypeComboBox = new JComboBox<String>(new String[]{this.getResString("IDS_TCM_FORCASTING_MODELTAB_FORECAST_LATEST_TEXT"), this.getResString("IDS_TCM_FORCASTING_MODELTAB_FORECAST_EARLIEST_TEXT")});
        this.mTypeLabel.setLabelFor(this.mTypeComboBox);
        this.mNumObservationsLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_MODELTAB_NUM_OBSERVATIONS_LABEL");
        this.mNumObservationsEdit = new IntTextField(2, Integer.MAX_VALUE, true);
        this.mNumObservationsLabel.setLabelFor((Component)this.mNumObservationsEdit);
        this.mObservationsToExcludeLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_MODELTAB_OBSERVATIONS_TO_EXCLUDE_LABEL");
        this.mObservationsToExcludeSpinner = new NumberSpinner(0, 0, Integer.MAX_VALUE, true, 1);
        this.mObservationsToExcludeLabel.setLabelFor((Component)this.mObservationsToExcludeSpinner);
        this.mExtendRecordsIntoFutureCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_MODELTAB_EXTEND_RECORDS_FUTURE_CHECKBOX_LABEL", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingModelTab.this.updateEnableStates();
            }
        });
        this.mExtendRecordsIntoFutureSpinner = new NumberSpinner(1, 1, 10, true, 1);
    }

    private JPanel getModelParametersPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_MODELTAB_MODEL_PARAMS_GRPBOX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLoadFromModelFileRB, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mReestimateFromDataRB, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = this.getEstimationPeriodPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel getEstimationPeriodPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_MODELTAB_ESTIMATION_PERIOD_GRPBOX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 + 6, n2, n2, n2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mAllObserevationsRB, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mByStartAndEndTimesRB, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JScrollPane jScrollPane = this.mTCMForecastGatingInfo.isDateTimeType() ? this.mDateTimeTableScrollPane : this.mCyclicPeriodTableScrollPane;
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 2, 1, 1, n, insets);
        JPanel jPanel2 = this.getByEarliestOrLatestPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel getByEarliestOrLatestPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, 0, n2, n2 * 2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mByLatestOrEarliestObservatiosRB, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JPanel jPanel2 = this.getTypePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel3 = this.getObservationsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel getTypePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 + 6, 0, n2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTypeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTypeComboBox, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JLabel("    "), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, new JLabel("    "), gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getObservationsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 + 6, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNumObservationsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumObservationsEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mObservationsToExcludeLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mObservationsToExcludeSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getForecastingPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_FORCASTING_MODELTAB_FORECAST_GRPBOX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 + 6, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mExtendRecordsIntoFutureCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mExtendRecordsIntoFutureSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }

    public void appendSyntax(StringBuffer stringBuffer) {
        JTable jTable = this.mDateTimeTable != null ? this.mDateTimeTable : this.mCyclicPeriodTable;
        TCMUtilities.stopTableEditing(jTable);
        stringBuffer.append(SyntaxUtil.getSubCommand("/OPTIONS"));
        stringBuffer.append(" REESTIMATE=");
        stringBuffer.append(this.mLoadFromModelFileRB.isSelected() ? "NO" : "YES");
        this.appendEstimationPeriodSyntax(stringBuffer);
        if (this.mExtendRecordsIntoFutureCheckBox.isSelected()) {
            stringBuffer.append(" FORECASTPERIODS=");
            stringBuffer.append(this.mExtendRecordsIntoFutureSpinner.getValueForSyntax());
        }
    }

    private String appendEstimationPeriodSyntax(StringBuffer stringBuffer) {
        stringBuffer.append(" ESTIMATIONPERIOD=");
        if (this.mLoadFromModelFileRB.isSelected()) {
            stringBuffer.append("MODEL");
        } else if (this.mAllObserevationsRB.isSelected()) {
            stringBuffer.append("ALL");
        } else if (this.mByStartAndEndTimesRB.isSelected()) {
            JTable jTable = this.mIsDateTimeType ? this.mDateTimeTable : this.mCyclicPeriodTable;
            stringBuffer.append("TIMES(START=");
            stringBuffer.append(this.getRowValuesText(jTable, true));
            stringBuffer.append(" END=");
            stringBuffer.append(this.getRowValuesText(jTable, false));
            if (this.mIsDateTimeType) {
                String string = this.mTCMForecastGatingInfo.getDateTimeField().equals("mtime") ? "VARIABLE" : "ISO8601";
                stringBuffer.append(" FORMAT=" + string);
            }
            stringBuffer.append(")");
        } else if (this.mByLatestOrEarliestObservatiosRB.isSelected()) {
            String string = this.mTypeComboBox.getSelectedIndex() == 0 ? "NEWEST" : "OLDEST";
            Object[] objectArray = new Object[]{string, this.mObservationsToExcludeSpinner.getValueForSyntax(), this.mNumObservationsEdit.getText()};
            String string2 = MessageFormat.format("OBSERVATIONS(TYPE={0} OFFSET={1} NUMBER = {2})", objectArray);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getRowValuesText(JTable jTable, boolean bl) {
        boolean bl2 = this.mTCMForecastGatingInfo.getDateTimeField().equals("mtime");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < jTable.getModel().getColumnCount(); ++i) {
            int n = bl ? 0 : 1;
            Long l = (Long)jTable.getValueAt(n, i);
            if (this.mIsDateTimeType) {
                Date date = new Date(l);
                if (date != null) {
                    String string = bl2 ? TCMUtilities.formatMTime(date) : this.mDateTimeTableModel.formatDateValueToISO8601(date, this.mTCMForecastGatingInfo.getDateTimeInfo().getDateTimeType());
                    stringBuffer.append(SyntaxUtil.wrapText(string, '\''));
                }
            } else {
                stringBuffer.append("" + l);
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public boolean isReestimateFromData() {
        return this.mReestimateFromDataRB.isSelected();
    }

    public Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mLoadFromModelFileRB);
        vector.add(this.mReestimateFromDataRB);
        vector.add(this.mAllObserevationsRB);
        vector.add(this.mByStartAndEndTimesRB);
        JTable jTable = this.mDateTimeTable != null ? this.mDateTimeTable : this.mCyclicPeriodTable;
        vector.add(jTable);
        vector.add(this.mByLatestOrEarliestObservatiosRB);
        vector.add(this.mTypeComboBox);
        vector.add(this.mNumObservationsEdit);
        vector.add(this.mObservationsToExcludeSpinner);
        vector.add(this.mExtendRecordsIntoFutureCheckBox);
        vector.add(this.mExtendRecordsIntoFutureSpinner);
        return vector;
    }

    @Override
    public Vector<Object> getComponentOrder() {
        this.mComponentOrder.clear();
        this.mComponentOrder.add(this.mLoadFromModelFileRB);
        this.mComponentOrder.add(this.mReestimateFromDataRB);
        this.mComponentOrder.add(this.mAllObserevationsRB);
        this.mComponentOrder.add(this.mByStartAndEndTimesRB);
        JTable jTable = this.mDateTimeTable != null ? this.mDateTimeTable : this.mCyclicPeriodTable;
        this.mComponentOrder.add(jTable);
        this.mComponentOrder.add(this.mByLatestOrEarliestObservatiosRB);
        this.mComponentOrder.add(this.mTypeComboBox);
        this.mComponentOrder.add(this.mNumObservationsEdit);
        this.mComponentOrder.add(this.mObservationsToExcludeSpinner);
        this.mComponentOrder.add(this.mExtendRecordsIntoFutureCheckBox);
        this.mComponentOrder.add(this.mExtendRecordsIntoFutureSpinner);
        return this.mComponentOrder;
    }

    class DateTextFieldEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private DateTextField mField;

        DateTextFieldEditor(DateTextField dateTextField) {
            super((JTextField)dateTextField);
            this.mField = dateTextField;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (n2 > 0 && object != null) {
                this.mField.setText(object.toString());
            }
            return this.mField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mField.getText();
        }
    }
}

