/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.datamodel.Field;
import com.spss.datamodel.Fields;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ASMapsError;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.TemporalCausalModeling;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class TCMForcastingGatingDlg
extends BaseGatingDialog {
    ImageIcon mReestimateUnselectedNoFocus;
    ImageIcon mReestimateUnselectedFocus;
    ImageIcon mReestimateSelectedNoFocus;
    ImageIcon mReestimateSelectedFocus;
    ImageIcon mRunScenariosUnselectedNoFocus;
    ImageIcon mRunScenariosUnselectedFocus;
    ImageIcon mRunScenariosSelectedNoFocus;
    ImageIcon mRunScenariosSelectedFocus;
    public static final String EARLIEST_LATEST_OBSERVATIONS_TYPE_DEFAULT = "Latest";
    public static final int EARLIEST_LATEST_NUM_OBSERVATIONS_DEFAULT = 100000;
    public static final int EARLIEST_LATEST_OBSERVATIONS_EXCLUDE_DEFAULT = 0;
    public static final int CONFIDENCE_LEVEL_DEFULT = 95;
    public static final int OUTLIER_THRESHOLD_DEFULT = 95;
    JFrame mParentFrame;
    protected JLabel mWhatToDoLabel;
    protected JLabel mModelSystemFileLabel;
    FileTextField mModelFilePath;
    JButton mBrowseButton;
    SpssButtonGroup mRadioButtonGroup;
    protected FocusableTextArea mRestimateModelsTextArea;
    protected JToggleButton mRestimateModelsButton;
    protected FocusableTextArea mRunScenariosTextArea;
    protected JToggleButton mRunScenariosButton;
    protected String mNextActionKey;
    public static TCMForecastGatingInfo mTCMForecastGatingInfo = null;
    static LocallyUniqueId.LocallyUniqueIDGenerator sIdGenerator = new LocallyUniqueId.LocallyUniqueIDGenerator(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
    private Thread mTCMInteractiveThread;

    public TCMForcastingGatingDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, TCMResBundle.getDefaultResourceBundleName(), TCMResBundle.getImageFolder());
        this.mParentFrame = jFrame;
        this.setTitle(this.getResString("IDS_TS_FORECASTING_GATING_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.updateEnableStatus();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_tcm_apply_intro";
    }

    @Override
    public String getIActionKey() {
        return "analyze_ts_apply_gating_dialog";
    }

    @Override
    public boolean continuePressed() {
        boolean bl = TCMUtilities.isValidFile((JDialog)((Object)this), this.mModelFilePath.getText().trim(), this.getResString("IDS_TS_FORECASTING_EMPTY_FILE_NAME_ERROR"), this.getResString("IDS_TCM_GATING_FILE_ERROR"));
        if (bl) {
            this.initTCMApplyGatingInfo();
            if (mTCMForecastGatingInfo == null) {
                bl = false;
            } else {
                mTCMForecastGatingInfo.setMode(this.mRunScenariosButton.isSelected() ? TCMForecastGatingInfo.Mode.SCENARIOS : TCMForecastGatingInfo.Mode.FORECASTING);
            }
        }
        if (bl && mTCMForecastGatingInfo != null) {
            String string;
            String string2;
            ArrayList<String> arrayList;
            Object object;
            String string3;
            String string4 = string3 = mTCMForecastGatingInfo.getDateTimeInfo() != null ? mTCMForecastGatingInfo.getDateTimeInfo().getDateTimeField() : null;
            if (bl && string3 != null) {
                object = TCMUtilities.findVariableInActiveDataset(string3);
                arrayList = object != null ? Boolean.valueOf(object.getFormat().getFormatType().isStringFormat()) : null;
                String string5 = string2 = object != null ? Boolean.valueOf(object.getFormat().getFormatType().isDateOrTimeFormat()) : null;
                if (object == null || !((Boolean)((Object)string2)).booleanValue() && !((Boolean)((Object)arrayList)).booleanValue()) {
                    string = MessageFormat.format(this.getResString("IDS_TCM_GATING_DATE_TIME_ERROR"), string3);
                    this.throwErrorDialog(string);
                    bl = false;
                }
            }
            if (bl && mTCMForecastGatingInfo.getCyclicInfo() != null && (arrayList = TCMForcastingGatingDlg.getNotInActiveOrNonNumericFieldNames((ArrayList<String>)(object = mTCMForecastGatingInfo.getCyclicInfo().getCyclicFieldNames()))) != null && arrayList.size() > 0) {
                string2 = this.createCommaSeparatedVarNameText(arrayList);
                string = MessageFormat.format(this.getResString("IDS_TCM_GATING_CYCLIC_ERROR"), string2);
                this.throwErrorDialog(string);
                bl = false;
            }
            if (bl) {
                object = mTCMForecastGatingInfo.getDataModel().getFields();
                arrayList = TCMForcastingGatingDlg.getNotInActiveFieldNames((Fields)object);
                string2 = this.createCommaSeparatedVarNameText(arrayList);
                if (arrayList != null && arrayList.size() > 0) {
                    string = MessageFormat.format(this.getResString("IDS_TCM_GATING_DATAMODEL_ERROR"), string2);
                    this.throwErrorDialog(string);
                    bl = false;
                }
            }
        }
        return bl;
    }

    private String createCommaSeparatedVarNameText(ArrayList<String> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                if (i == 0) {
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append(", " + string);
            }
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    public static ArrayList<String> getNotInActiveFieldNames(Fields fields) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fields != null) {
            for (Field field : fields) {
                ISpssVariable iSpssVariable;
                if (field.getName().startsWith("$") || (iSpssVariable = TCMUtilities.findVariableInActiveDataset(field.getName())) != null) continue;
                arrayList.add(field.getName());
            }
        }
        return arrayList;
    }

    public static ArrayList<String> getNotInActiveOrNonNumericFieldNames(ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : arrayList) {
            ISpssVariable iSpssVariable;
            if (string.equals("$casecount") || (iSpssVariable = TCMUtilities.findVariableInActiveDataset(string)) != null && (iSpssVariable == null || iSpssVariable.getFormat().getFormatType().isNumericFormat())) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    private void initTCMApplyGatingInfo() {
        SpssProgressDlg spssProgressDlg = new SpssProgressDlg((Window)((Object)this), VersionInfo.getAppVersionString());
        spssProgressDlg.setMessage(this.getResString("IDS_TCM_PROGRESS_DLG_TEXT"));
        spssProgressDlg.setLocationRelativeTo((Component)((Object)this));
        mTCMForecastGatingInfo = null;
        TCMInteractiveCallRunnable tCMInteractiveCallRunnable = new TCMInteractiveCallRunnable(spssProgressDlg);
        this.mTCMInteractiveThread = new Thread(tCMInteractiveCallRunnable);
        this.mTCMInteractiveThread.start();
        spssProgressDlg.setVisible(true);
        if (!spssProgressDlg.isWorkDone()) {
            this.mTCMInteractiveThread.interrupt();
            return;
        }
        InteractiveCallReturn interactiveCallReturn = tCMInteractiveCallRunnable.getConnectErrorType();
        if (interactiveCallReturn != InteractiveCallReturn.NO_ERROR) {
            String string = interactiveCallReturn == InteractiveCallReturn.BACKEND_ERROR ? this.getResString("IDS_TCM_PROGRESS_ERROR_TEXT") : this.getResString("IDS_TCM_PARSING_ERROR_TEXT");
            this.throwErrorDialog(string);
            return;
        }
        if (mTCMForecastGatingInfo != null) {
            mTCMForecastGatingInfo.setModelFilePath(this.mModelFilePath.getText());
        }
        if (this.mTCMInteractiveThread != null) {
            this.mTCMInteractiveThread.interrupt();
            this.mTCMInteractiveThread = null;
        }
    }

    @Override
    public String getNextProcDlgActionKey() {
        this.mNextActionKey = this.mRestimateModelsButton.isSelected() ? "analyze_tcm_forecasting_dialog" : "analyze_tcm_scenarios_dialog";
        return this.mNextActionKey;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
    }

    protected void updateEnableStatus() {
        boolean bl = this.mModelFilePath.getText() == null || this.mModelFilePath.getText().trim().length() > 0;
        boolean bl2 = this.mRestimateModelsButton.isSelected() || this.mRunScenariosButton.isSelected();
        this.mDefineButton.setEnabled(bl && bl2);
    }

    @Override
    public void init() {
        super.init();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.createModelSystemFilePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mWhatToDoLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel3 = this.createRestimateRunSceenariosButtonsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        this.setDefault();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mModelFilePath);
        vector.add(this.mBrowseButton);
        vector.add(this.mRestimateModelsButton);
        vector.add(this.mRunScenariosButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel createModelSystemFilePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 + 6, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mModelSystemFileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mModelFilePath), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createRestimateRunSceenariosButtonsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 + 6, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRestimateModelsButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mRestimateModelsTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mRunScenariosButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mRunScenariosTextArea, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createTieredText(JLabel jLabel, JLabel jLabel2) {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, n2, 0, 0));
        return jPanel;
    }

    private void setDefault() {
    }

    private void initVars() {
        this.mModelSystemFileLabel = DialogUtil.createLabel(this, "IDS_TS_FORECASTING_GATING_MODEL_FILE_LABEL");
        this.mModelFilePath = new FileTextField();
        this.mModelFilePath.setEditable(true);
        this.mModelFilePath.setColumns(20);
        this.mModelFilePath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TCMForcastingGatingDlg.this.updateEnableStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TCMForcastingGatingDlg.this.updateEnableStatus();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TCMForcastingGatingDlg.this.updateEnableStatus();
            }
        });
        this.mModelSystemFileLabel.setLabelFor((Component)((Object)this.mModelFilePath));
        this.mWhatToDoLabel = new JLabel(this.getResString("IDS_TS_FORECASTING_GATING_WHAT_TO_DO_LABEL"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_TS_FORECASTING_GATING_BROWSE_BUTTON");
        this.mBrowseButton = new JButton(toggleButtonAction);
        this.mBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingGatingDlg.this.processBrowse();
            }
        });
        this.mReestimateUnselectedNoFocus = new ImageIcon(this.getResImageURL("IDS_TS_FORECASTING_GATING_REESTIMATE_MODELS_IMAGE"));
        this.mReestimateUnselectedFocus = new ImageIcon(this.getResImageURL("IDS_TS_FORECASTING_GATING_REESTIMATE_MODELS_UNSEL_FOCUS_IMAGE"));
        this.mReestimateSelectedNoFocus = new ImageIcon(this.getResImageURL("IDS_TS_FORECASTING_GATING_REESTIMATE_MODELS_SEL_IMAGE"));
        this.mReestimateSelectedFocus = new ImageIcon(this.getResImageURL("IDS_TS_FORECASTING_GATING_REESTIMATE_MODELS_SEL_FOCUS_IMAGE"));
        this.mRunScenariosUnselectedNoFocus = new ImageIcon(this.getResImageURL("IDS_TS_FORECASTING_GATING_RUN_SCENARIOS_IMAGE"));
        this.mRunScenariosUnselectedFocus = new ImageIcon(this.getResImageURL("IDS_TS_FORECASTING_GATING_RUN_SCENARIOS_UNSEL_FOCUS_IMAGE"));
        this.mRunScenariosSelectedNoFocus = new ImageIcon(this.getResImageURL("IDS_TS_FORECASTING_GATING_RUN_SCENARIOS_SEL_IMAGE"));
        this.mRunScenariosSelectedFocus = new ImageIcon(this.getResImageURL("IDS_TS_FORECASTING_GATING_RUN_SCENARIOS_SEL_FOCUS_IMAGE"));
        this.mRestimateModelsTextArea = new FocusableTextArea(this.getResString("IDS_TS_FORECASTING_GATING_REESTIMATE_MODELS_LABEL"));
        this.mRestimateModelsTextArea.setPreferredSize(new Dimension(400, 80));
        this.mRestimateModelsButton = new JToggleButton();
        this.mRestimateModelsButton.setIcon(this.mReestimateUnselectedNoFocus);
        this.mRestimateModelsButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.mRestimateModelsButton.getAccessibleContext().setAccessibleName(this.getResString("IDS_TS_FORECASTING_GATING_REESTIMATE_MODELS_LABEL"));
        this.mRestimateModelsButton.getAccessibleContext().setAccessibleDescription(this.getResString("IDS_TS_FORECASTING_GATING_REESTIMATE_MODELS_LABEL"));
        this.mRestimateModelsButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TCMForcastingGatingDlg.this.updateRestimateIconImages(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TCMForcastingGatingDlg.this.updateRestimateIconImages(false);
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingGatingDlg.this.mRunScenariosButton.setSelected(false);
                TCMForcastingGatingDlg.this.updateRestimateIconImages(true);
                TCMForcastingGatingDlg.this.updateRunScenariosIconImages(false);
                TCMForcastingGatingDlg.this.updateEnableStatus();
            }
        };
        this.mRestimateModelsButton.addActionListener(actionListener);
        this.mRunScenariosTextArea = new FocusableTextArea(this.getResString("IDS_TS_FORECASTING_GATING_RUN_SCENARIOS_LABEL"));
        this.mRunScenariosTextArea.setPreferredSize(new Dimension(400, 100));
        this.mRunScenariosButton = new JToggleButton();
        this.mRunScenariosButton.setIcon(this.mRunScenariosUnselectedNoFocus);
        this.mRunScenariosButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.mRunScenariosButton.getAccessibleContext().setAccessibleName(this.getResString("IDS_TS_FORECASTING_GATING_RUN_SCENARIOS_LABEL"));
        this.mRunScenariosButton.getAccessibleContext().setAccessibleDescription(this.getResString("IDS_TS_FORECASTING_GATING_RUN_SCENARIOS_LABEL"));
        this.mRunScenariosButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TCMForcastingGatingDlg.this.updateRunScenariosIconImages(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TCMForcastingGatingDlg.this.updateRunScenariosIconImages(false);
            }
        });
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMForcastingGatingDlg.this.mRestimateModelsButton.setSelected(false);
                TCMForcastingGatingDlg.this.updateRestimateIconImages(false);
                TCMForcastingGatingDlg.this.updateRunScenariosIconImages(true);
                TCMForcastingGatingDlg.this.updateEnableStatus();
            }
        };
        this.mRunScenariosButton.addActionListener(actionListener);
    }

    private void updateRestimateIconImages(boolean bl) {
        if (bl) {
            if (this.mRestimateModelsButton.isSelected()) {
                this.mRestimateModelsButton.setIcon(this.mReestimateSelectedFocus);
            } else {
                this.mRestimateModelsButton.setIcon(this.mReestimateUnselectedFocus);
            }
        } else if (this.mRestimateModelsButton.isSelected()) {
            this.mRestimateModelsButton.setIcon(this.mReestimateSelectedNoFocus);
        } else {
            this.mRestimateModelsButton.setIcon(this.mReestimateUnselectedNoFocus);
        }
    }

    private void updateRunScenariosIconImages(boolean bl) {
        if (bl) {
            if (this.mRunScenariosButton.isSelected()) {
                this.mRunScenariosButton.setIcon(this.mRunScenariosSelectedFocus);
            } else {
                this.mRunScenariosButton.setIcon(this.mRunScenariosUnselectedFocus);
            }
        } else if (this.mRunScenariosButton.isSelected()) {
            this.mRunScenariosButton.setIcon(this.mRunScenariosSelectedNoFocus);
        } else {
            this.mRunScenariosButton.setIcon(this.mRunScenariosUnselectedNoFocus);
        }
    }

    private void processBrowse() {
        String[] stringArray = this.getResStringArray("IDS_TS_FORECASTING_GATING_XML_FILE_FILTER_ARRY");
        String[] stringArray2 = this.getResStringArray("IDS_TS_FORECASTING_GATING_XML_FILE_EXT_ARRY");
        String[] stringArray3 = TemporalCausalModeling.showOpenFileDialog(this, this.getResString("IDS_TS_FORECASTING_GATING_FILE_BROWSE_TITLE"), stringArray, stringArray2);
        if (stringArray3 != null && stringArray3.length == 2) {
            this.mModelFilePath.setText(stringArray3[0]);
            this.parsingModelXML(stringArray3[0]);
        }
    }

    private void parsingModelXML(String string) {
    }

    private void setDefaults() {
    }

    @Override
    protected void processCancelAction() {
        super.processCancelAction();
    }

    @Override
    protected void processContinueAction(ActionEvent actionEvent) {
        super.processContinueAction(actionEvent);
    }

    private void throwErrorDialog(String string) {
        Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
        SpssAlertOptionPane.showOptionDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, objectArray[0]);
    }

    private InteractiveCallReturn callBackend() {
        InteractiveCallReturn interactiveCallReturn = InteractiveCallReturn.NO_ERROR;
        Object var2_2 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        Vector vector6 = new Vector();
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        String string = this.mModelFilePath.getText();
        ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().getModelCapabilities(string, vector, vector2, vector3, vector4, vector5, vector6);
        if (aSMapsError.getHasError()) {
            String string2 = aSMapsError.getMessage();
            String string3 = aSMapsError.getExplain();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2 + " " + string3, VersionInfo.getAppVersionString());
            interactiveCallReturn = InteractiveCallReturn.BACKEND_ERROR;
        } else {
            mTCMForecastGatingInfo = new TCMForecastGatingInfo((String)vector4.get(0), (String)vector6.get(0), (String)vector5.get(0));
            if (mTCMForecastGatingInfo.getExceptionType() != TCMForecastGatingInfo.ExceptionType.NONE) {
                interactiveCallReturn = InteractiveCallReturn.PARSING_XML_ERROR;
            }
        }
        return interactiveCallReturn;
    }

    public static JPanel createInfoPanel(FocusableTextArea focusableTextArea) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, focusableTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    protected static enum InteractiveCallReturn {
        NO_ERROR,
        BACKEND_ERROR,
        PARSING_XML_ERROR;

    }

    class TCMInteractiveCallRunnable
    implements Runnable {
        private InteractiveCallReturn mBackEndRequestSuccess = InteractiveCallReturn.NO_ERROR;
        private SpssProgressDlg mSpssProgressDlg;

        public TCMInteractiveCallRunnable(SpssProgressDlg spssProgressDlg) {
            this.mSpssProgressDlg = spssProgressDlg;
        }

        @Override
        public void run() {
            this.mBackEndRequestSuccess = TCMForcastingGatingDlg.this.callBackend();
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.mSpssProgressDlg.setWorkDone(true);
            this.mSpssProgressDlg.dispose();
        }

        public InteractiveCallReturn getConnectErrorType() {
            return this.mBackEndRequestSuccess;
        }
    }

    public class HelpPanel
    extends JPanel {
        private JTextArea mInfoDesc;
        private JLabel mHelpIconLabel;

        public HelpPanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.initLayout(this.getFont());
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    HelpPanel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    HelpPanel.this.repaint();
                }
            });
        }

        protected void initLayout(Font font) {
            this.mInfoDesc = new JTextArea();
            this.mInfoDesc.setOpaque(false);
            this.mInfoDesc.setFont(font);
            this.mInfoDesc.setLineWrap(true);
            this.mInfoDesc.setWrapStyleWord(true);
            this.mInfoDesc.setText("");
            this.mInfoDesc.setFocusable(false);
            this.mHelpIconLabel = new JLabel();
            this.setHelpText();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            int n2 = DialogUtil.getGroupBoxInnerMargin();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            DialogUtil.addUsingGBL(this, this.mInfoDesc, gridBagConstraints, 0, 0, 1, 1, n, null);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(this, this.mHelpIconLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        }

        public void setHelpText() {
            this.mInfoDesc.setText(TCMForcastingGatingDlg.this.getResString("IDS_SIMULATION_SELECTION_DESCRIPTION"));
            this.mInfoDesc.setEnabled(true);
            this.mHelpIconLabel.setEnabled(true);
            this.getAccessibleContext().setAccessibleName(this.mInfoDesc.getText());
            this.getAccessibleContext().setAccessibleDescription(this.mInfoDesc.getText());
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                this.paintFocus(graphics);
            }
        }

        public void paintFocus(Graphics graphics) {
            Color color = UIManager.getColor("ToggleButton.focus");
            graphics.setColor(color);
            Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

