/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.datamodel.BaseFieldContent;
import com.spss.datamodel.DataModel;
import com.spss.datamodel.Field;
import com.spss.datamodel.Fields;
import com.spss.datamodel.ValidValue;
import com.spss.datamodel.ValidValues;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingGatingDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingModelTab;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingOptionsTab;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingSaveTab;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TCMForcastingDlg
extends BaseTabbedDialog
implements ActionListener {
    protected TCMForcastingModelTab mModelTab;
    protected TCMForcastingOptionsTab mOptionsTab;
    protected TCMForcastingSaveTab mSaveTab;

    public TCMForcastingDlg(JFrame jFrame) {
        super(jFrame, true, TCMResBundle.getDefaultResourceBundleName(), TCMResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TCM_FORCASTING_DLG_TITLE"));
        TCMForecastGatingInfo tCMForecastGatingInfo = TCMForcastingGatingDlg.mTCMForecastGatingInfo;
        this.enableOkPaste(true);
    }

    private void setDefaults() {
        this.mModelTab.setDefaults();
        this.mOptionsTab.setDefaults();
        this.mSaveTab.setDefaults();
    }

    public static void throwErrorDialog(Window window, String string) {
        Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OK")};
        SpssAlertOptionPane.showOptionDialog(window, string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, objectArray[0]);
    }

    @Override
    public String getIActionKey() {
        return "analyze_tcm_forecasting_dialog";
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.setDefaults();
    }

    @Override
    protected void setLastTabSelected() {
        this.mTabbedPane.setSelectedIndex(0);
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.mSaveTab.getNewDatasetName();
        if (string != null) {
            stringBuffer.append("\nDATASET DECLARE ");
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("\nTCM APPLY"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MODELSYSTEM File="));
        stringBuffer.append(SyntaxUtil.wrapText(TCMForcastingGatingDlg.mTCMForecastGatingInfo.getModelFilePath(), '\''));
        stringBuffer.append("\n");
        this.mModelTab.appendSyntax(stringBuffer);
        this.mOptionsTab.appendSyntax(stringBuffer);
        this.mSaveTab.appendSyntax(stringBuffer);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (!this.mModelTab.doValidateTab()) {
            return false;
        }
        if (!this.mOptionsTab.doValidateTab()) {
            return false;
        }
        if (!this.mSaveTab.doValidateTab()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    public void reset() {
        this.mModelTab.reset();
        this.mOptionsTab.reset();
        this.mSaveTab.reset();
    }

    void selectModelTab() {
        this.mTabbedPane.setSelectedIndex(0);
    }

    void selectOptionsTab() {
        this.mTabbedPane.setSelectedIndex(1);
    }

    void selectSaveTab() {
        this.mTabbedPane.setSelectedIndex(2);
    }

    public static double formatDoubleValue(double d, int n) {
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumFractionDigits(n);
            return numberFormat.parse(numberFormat.format(d)).doubleValue();
        }
        catch (ParseException parseException) {
            return d;
        }
    }

    public TCMForcastingModelTab getModelTab() {
        return this.mModelTab;
    }

    public TCMForcastingOptionsTab getOptionsTab() {
        return this.mOptionsTab;
    }

    public TCMForcastingSaveTab getSaveTab() {
        return this.mSaveTab;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
    }

    @Override
    protected void init() {
        super.init();
        TCMForecastGatingInfo tCMForecastGatingInfo = TCMForcastingGatingDlg.mTCMForecastGatingInfo;
        this.mOkAction.putValue("Name", ResUtil.getCommonDlgString("IDS_RUN"));
        DialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
        this.mModelTab = new TCMForcastingModelTab(this, tCMForecastGatingInfo);
        this.addTab(this.getResString("IDS_TCM_FORCASTING_MODEL_TAB"), this.mModelTab);
        this.mOptionsTab = new TCMForcastingOptionsTab(this, tCMForecastGatingInfo);
        this.addTab(this.getResString("IDS_TCM_FORCASTING_OPTIONS_TAB"), this.mOptionsTab);
        this.mSaveTab = new TCMForcastingSaveTab(this, tCMForecastGatingInfo);
        this.addTab(this.getResString("IDS_TCM_FORCASTING_SAVE_TAB"), this.mSaveTab);
        this.pack();
    }

    @Override
    protected void addMainViewComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        JLabel jLabel = new JLabel("                     ");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 20, 0, 20);
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, 0, 6);
        gridBagConstraints.fill = 2;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
    }

    public static Field findField(DataModel dataModel, String string) {
        Fields fields = dataModel.getFields();
        return fields.getField(string);
    }

    public static ValidValues getFieldValues(DataModel dataModel, String string) {
        Field field = TCMForcastingDlg.findField(dataModel, string);
        BaseFieldContent baseFieldContent = field != null ? TCMForcastingDlg.findField(dataModel, string).getBaseFieldContent() : null;
        return baseFieldContent != null ? baseFieldContent.getValues() : null;
    }

    public ArrayList<String> getFieldValueStringList(DataModel dataModel, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ValidValues validValues = TCMForcastingDlg.getFieldValues(dataModel, string);
        if (validValues != null) {
            for (ValidValue validValue : validValues) {
                arrayList.add(validValue.getValue());
            }
        }
        return arrayList;
    }

    public ArrayList<String> getFieldNames(DataModel dataModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : dataModel.getFields()) {
            arrayList.add(field.getName());
        }
        return arrayList;
    }
}

