/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcMoveList;
import com.spss.java_client.ui.dialogs.TCM.TCMSimpleSelectDimensionValuesDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.dialogs.DlgKeyAdapter;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import com.spss.uitools.help.StatsHelp;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class TCMFindDimensionValueDialog
extends JDialog
implements DlgKeyAdapter.DlgHelpProvider {
    private AbstractButton findNextBtn;
    private AbstractButton closeBtn;
    private AbstractButton helpBtn;
    private Vector<String> last10Filters;
    private JLabel findLabel;
    private JComboBox findComboBox;
    private JCheckBox matchCaseCheckBox;
    private AbstractButton hideOptionButton;
    private MatchGroupPanel matchGroupPanel;
    private DirectionGroupPanel directionGroupPanel;
    private boolean showOptionsPanel = false;
    private boolean isFindClicked = false;
    private TCMSimpleSelectDimensionValuesDlg mParent;
    private SrcMoveList srcMoveList;
    private Vector<String> selectedValueList;
    private boolean isFilterMatchCase;
    private int searchStartPosition;
    private JPanel mMatchToDirectionPanel;
    private String mHelpID;

    public TCMFindDimensionValueDialog(TCMSimpleSelectDimensionValuesDlg tCMSimpleSelectDimensionValuesDlg, SrcMoveList srcMoveList, Vector<String> vector, Vector<String> vector2, boolean bl, int n) {
        super((Dialog)((Object)tCMSimpleSelectDimensionValuesDlg), tCMSimpleSelectDimensionValuesDlg.getResourceBundle().getString("IDS_TCM_FORCASTING_FIND_DIALOG_TITLE"), false);
        this.mParent = tCMSimpleSelectDimensionValuesDlg;
        this.srcMoveList = srcMoveList;
        this.last10Filters = vector;
        this.selectedValueList = vector2;
        this.isFilterMatchCase = bl;
        this.searchStartPosition = n;
        DlgKeyAdapter dlgKeyAdapter = new DlgKeyAdapter((JDialog)this);
        dlgKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new DlgKeyPressListener());
        this.initControls();
        JPanel jPanel = this.createMainPanel();
        this.getContentPane().add(jPanel);
        this.setLocationCenter();
        this.pack();
    }

    private void setLocationCenter() {
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n2 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        this.setLocation((n - this.getSize().width) / 2, (n2 - this.getSize().height) / 2);
    }

    private void initControls() {
        this.isFindClicked = false;
        this.findLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_FORCASTING_FIND_COMBOBOX_LABEL");
        this.findComboBox = new JComboBox<String>(this.last10Filters);
        this.findComboBox.setEditable(true);
        this.findLabel.setLabelFor(this.findComboBox);
        this.matchCaseCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_FORCASTING_FIND_MATCH_CASE_CHECKBOX");
        this.matchCaseCheckBox.setSelected(this.isFilterMatchCase);
        this.hideOptionButton = DialogUtil.createButton(this.mParent, "IDS_TCM_FORCASTING_FIND_SHOW_OPTIONS_BUTTON");
        this.findNextBtn = DialogUtil.createButton(this.mParent, "IDS_TCM_FORCASTING_FIND_NEXT_BUTTON");
        this.closeBtn = DialogUtil.createButton(this.mParent, "IDS_TCM_FORCASTING_FIND_CLOSE_BUTTON");
        this.helpBtn = DialogUtil.createButton(this.mParent, "IDS_TCM_FORCASTING_FIND_HELP_BUTTON");
        this.hideOptionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMFindDimensionValueDialog.this.toggleShowHideOptions();
            }
        });
        this.findNextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMFindDimensionValueDialog.this.doFindNext();
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMFindDimensionValueDialog.this.doClose();
            }
        });
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMFindDimensionValueDialog.this.doHelp();
            }
        });
        this.matchGroupPanel = new MatchGroupPanel();
        this.directionGroupPanel = new DirectionGroupPanel();
        this.hideOptionButton.setText(this.showOptionsPanel ? this.mParent.getResourceBundle().getString("IDS_TCM_FORCASTING_FIND_HIDE_OPTIONS_BUTTON") : this.mParent.getResourceBundle().getString("IDS_TCM_FORCASTING_FIND_SHOW_OPTIONS_BUTTON"));
        this.processShowOptionsSelection(this.showOptionsPanel);
    }

    private void toggleShowHideOptions() {
        this.showOptionsPanel = !this.showOptionsPanel;
        this.processShowOptionsSelection(this.showOptionsPanel);
    }

    private JPanel createMainPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n - 2, n, n, n);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = this.createFindComboBoxMatchCasePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, new Insets(insets.top + 50, insets.left, insets.bottom, insets.right));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.hideOptionButton, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        JPanel jPanel3 = this.createMatchToDirectionPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        JPanel jPanel4 = this.createNextCloseHelpPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 4, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel createMatchToDirectionPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n - 2, n, n, n);
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.matchGroupPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.directionGroupPanel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel createFindComboBoxMatchCasePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n - 2, n, n, n);
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.findLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.findComboBox, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.matchCaseCheckBox, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel createNextCloseHelpPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.findNextBtn);
        jPanel.add(this.closeBtn);
        jPanel.add(this.helpBtn);
        return jPanel;
    }

    private void doFindNext() {
        this.isFindClicked = true;
        if (this.findComboBox.getSelectedItem() != null) {
            String string = this.findComboBox.getSelectedItem().toString();
            if (string != null) {
                String string2 = this.findComboBox.getSelectedItem().toString().trim();
                if (string2.length() > 0) {
                    this.selectedValueList = new Vector();
                    int n = TCMFindDimensionValueDialog.getFindNextResult(this.srcMoveList, string2, this.matchCaseCheckBox.isSelected(), this.matchGroupPanel.getMatchType(), this.directionGroupPanel.isUpDirection(), this.selectedValueList);
                    if (n != -1) {
                        this.srcMoveList.setSelectedIndex(n);
                    } else {
                        String string3 = MessageFormat.format(this.mParent.getResourceBundle().getString("IDS_TCM_FORCASTING_FIND_NOT_FOUND_MESSAGE"), string2);
                        JOptionPane.showMessageDialog(this, string3);
                    }
                    if (this.last10Filters.size() < 10) {
                        if (this.last10Filters.contains(string2)) {
                            this.last10Filters.remove(string2);
                        }
                        this.last10Filters.add(0, string2);
                    } else {
                        if (this.last10Filters.contains(string2)) {
                            this.last10Filters.remove(string2);
                        } else {
                            this.last10Filters.remove(9);
                        }
                        this.last10Filters.add(0, string2);
                    }
                }
                this.findComboBox.setModel(new DefaultComboBoxModel<String>(this.last10Filters));
                this.findComboBox.setSelectedItem(string);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public static int getFindNextResult(SrcMoveList srcMoveList, String string, boolean bl, FilterMatchType filterMatchType, boolean bl2, Vector<String> vector) {
        Vector<String> vector2 = new Vector<String>();
        boolean bl3 = false;
        int n = srcMoveList.getSelectedIndex();
        int n2 = n >= 0 ? n : 0;
        int n3 = -1;
        if (vector != null) {
            vector.clear();
            if (srcMoveList != null) {
                if (!bl2) {
                    if (n2 < srcMoveList.getModel().getSize()) {
                        for (n2 = bl2 ? n - 1 : n + 1; n2 < srcMoveList.getModel().getSize(); ++n2) {
                            if (!(bl3 = TCMFindDimensionValueDialog.findOperation(srcMoveList, n2, bl3, vector, vector2, string, filterMatchType, bl))) continue;
                            n3 = n2;
                            break;
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (n2 >= 0) {
                    while (n2 >= 0) {
                        if (bl3 = TCMFindDimensionValueDialog.findOperation(srcMoveList, n2, bl3, vector, vector2, string, filterMatchType, bl)) {
                            n3 = n2;
                            break;
                        }
                        --n2;
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
        return n3;
    }

    private static boolean findOperation(SrcMoveList srcMoveList, int n, boolean bl, Vector<String> vector, Vector<String> vector2, String string, FilterMatchType filterMatchType, boolean bl2) {
        block14: {
            String string2;
            block13: {
                string2 = srcMoveList.getModel().getElementAt(n).toString();
                if (!bl2) {
                    string2 = string2.toLowerCase();
                    string = string.toLowerCase();
                }
                if (vector == null || vector.size() >= 1) break block13;
                if (bl) {
                    vector2.add(string2);
                    return bl;
                }
                switch (filterMatchType) {
                    case CONTAIN: {
                        if (string2.contains(string)) {
                            vector.add(string2);
                            bl = true;
                            break;
                        }
                        break block14;
                    }
                    case ENTIRE: {
                        if (string2.compareTo(string) == 0) {
                            vector.add(string2);
                            bl = true;
                            break;
                        }
                        break block14;
                    }
                    case BEGINWITH: {
                        if (string2.startsWith(string)) {
                            vector.add(string2);
                            bl = true;
                            break;
                        }
                        break block14;
                    }
                    case ENDWITH: {
                        if (string2.endsWith(string)) {
                            vector.add(string2);
                            bl = true;
                            break;
                        }
                        break block14;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
                break block14;
            }
            if (bl) {
                vector2.add(string2);
            }
        }
        return bl;
    }

    private void doClose() {
        this.isFindClicked = false;
        this.mParent.saveFindData(this.getLast10Filters(), this.getMatchType(), this.isDirectionUp());
        this.setVisible(false);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.mHelpID);
    }

    public void setHelpID(String string) {
        this.mHelpID = string;
    }

    public boolean isFindClicked() {
        return this.isFindClicked;
    }

    public boolean isShowOptionsPanel() {
        return this.showOptionsPanel;
    }

    public Vector<String> getSelectedValueList() {
        return this.selectedValueList;
    }

    public Vector<String> getLast10Filters() {
        return this.last10Filters;
    }

    public boolean getIsFilterMatchCase() {
        this.isFilterMatchCase = this.matchCaseCheckBox.isSelected();
        return this.isFilterMatchCase;
    }

    public void setShowOptions(boolean bl) {
        this.showOptionsPanel = bl;
        this.processShowOptionsSelection(bl);
    }

    private void processShowOptionsSelection(boolean bl) {
        this.hideOptionButton.setText(bl ? this.mParent.getResourceBundle().getString("IDS_TCM_FORCASTING_FIND_HIDE_OPTIONS_BUTTON") : this.mParent.getResourceBundle().getString("IDS_TCM_FORCASTING_FIND_SHOW_OPTIONS_BUTTON"));
        if (bl) {
            this.directionGroupPanel.setVisible(true);
            this.matchGroupPanel.setVisible(true);
            this.setSize(280, 400);
        } else {
            this.directionGroupPanel.setVisible(false);
            this.matchGroupPanel.setVisible(false);
            this.setSize(280, 250);
        }
    }

    public void setMatchType(FilterMatchType filterMatchType) {
        this.matchGroupPanel.setMatchType(filterMatchType);
    }

    public FilterMatchType getMatchType() {
        return this.matchGroupPanel.getMatchType();
    }

    public void setDirectionType(boolean bl) {
        this.directionGroupPanel.setDirection(bl);
    }

    public boolean isDirectionUp() {
        return this.directionGroupPanel.isUpDirection();
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyCode() == 112) {
            this.doHelp();
        }
        return true;
    }

    public static enum FilterMatchType {
        CONTAIN,
        ENTIRE,
        BEGINWITH,
        ENDWITH;

    }

    private class DirectionGroupPanel
    extends JPanel {
        private JRadioButton upBtn;
        private JRadioButton downBtn;
        private SpssButtonGroup directionBtnGroup;

        public DirectionGroupPanel() {
            this.setLayout(new GridBagLayout());
            this.initControls();
            this.addComponents();
        }

        private void initControls() {
            this.upBtn = DialogUtil.createRadioButton(TCMFindDimensionValueDialog.this.mParent, "IDS_TCM_FORCASTING_FIND_UP_RB", null);
            this.downBtn = DialogUtil.createRadioButton(TCMFindDimensionValueDialog.this.mParent, "IDS_TCM_FORCASTING_FIND_DOWN_RB", null);
            this.directionBtnGroup = new SpssButtonGroup();
            this.directionBtnGroup.add(this.upBtn);
            this.directionBtnGroup.add(this.downBtn);
            this.upBtn.setSelected(true);
        }

        private void addComponents() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            int n = DialogUtil.getGroupBoxInnerMargin();
            Insets insets = new Insets(n - 2, n, n, n);
            int n2 = 23;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            insets.set(n, n, 0, n);
            DialogUtil.addUsingGBL(this, this.upBtn, gridBagConstraints, 0, 0, 1, 1, n2, insets);
            DialogUtil.addUsingGBL(this, this.downBtn, gridBagConstraints, 0, 1, 1, 1, n2, insets);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(TCMFindDimensionValueDialog.this.mParent.getResourceBundle().getString("IDS_TCM_DIRECTION_GRPBX"));
            this.setBorder(titledBorder);
        }

        public boolean isUpDirection() {
            return this.upBtn.isSelected();
        }

        public void setDirection(boolean bl) {
            if (bl) {
                this.upBtn.setSelected(true);
            } else {
                this.downBtn.setSelected(true);
            }
        }
    }

    private class MatchGroupPanel
    extends JPanel {
        private JRadioButton containsBtn;
        private JRadioButton entireBtn;
        private JRadioButton beginBtn;
        private JRadioButton endBtn;
        private SpssButtonGroup matchBtnGroup;

        public MatchGroupPanel() {
            this.setLayout(new GridBagLayout());
            this.initControls();
            this.addComponents();
        }

        private void initControls() {
            this.containsBtn = DialogUtil.createRadioButton(TCMFindDimensionValueDialog.this.mParent, "IDS_TCM_FORCASTING_FIND_CONTAINS_RB", null);
            this.entireBtn = DialogUtil.createRadioButton(TCMFindDimensionValueDialog.this.mParent, "IDS_TCM_FORCASTING_FIND_ENTIRE_VALUE_RB", null);
            this.beginBtn = DialogUtil.createRadioButton(TCMFindDimensionValueDialog.this.mParent, "IDS_TCM_FORCASTING_FIND_BEGINS_WITH_RB", null);
            this.endBtn = DialogUtil.createRadioButton(TCMFindDimensionValueDialog.this.mParent, "IDS_TCM_FORCASTING_FIND_ENDS_WITH_RB", null);
            this.matchBtnGroup = new SpssButtonGroup();
            this.matchBtnGroup.add(this.containsBtn);
            this.matchBtnGroup.add(this.entireBtn);
            this.matchBtnGroup.add(this.beginBtn);
            this.matchBtnGroup.add(this.endBtn);
            this.containsBtn.setSelected(true);
        }

        private void addComponents() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            int n = DialogUtil.getGroupBoxInnerMargin();
            Insets insets = new Insets(n - 2, n, n, n);
            int n2 = 23;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            insets.set(n, n, 0, n);
            DialogUtil.addUsingGBL(this, this.containsBtn, gridBagConstraints, 0, 0, 1, 1, n2, insets);
            DialogUtil.addUsingGBL(this, this.entireBtn, gridBagConstraints, 0, 1, 1, 1, n2, insets);
            DialogUtil.addUsingGBL(this, this.beginBtn, gridBagConstraints, 0, 2, 1, 1, n2, insets);
            DialogUtil.addUsingGBL(this, this.endBtn, gridBagConstraints, 0, 3, 1, 1, n2, insets);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(TCMFindDimensionValueDialog.this.mParent.getResourceBundle().getString("IDS_TCM_MATCHTO_GRPBX"));
            this.setBorder(titledBorder);
        }

        public FilterMatchType getMatchType() {
            if (this.containsBtn.isSelected()) {
                return FilterMatchType.CONTAIN;
            }
            if (this.entireBtn.isSelected()) {
                return FilterMatchType.ENTIRE;
            }
            if (this.beginBtn.isSelected()) {
                return FilterMatchType.BEGINWITH;
            }
            if (this.endBtn.isSelected()) {
                return FilterMatchType.ENDWITH;
            }
            return FilterMatchType.CONTAIN;
        }

        public void setMatchType(FilterMatchType filterMatchType) {
            switch (filterMatchType) {
                case CONTAIN: {
                    this.containsBtn.setSelected(true);
                    break;
                }
                case ENTIRE: {
                    this.entireBtn.setSelected(true);
                    break;
                }
                case BEGINWITH: {
                    this.beginBtn.setSelected(true);
                    break;
                }
                case ENDWITH: {
                    this.endBtn.setSelected(true);
                    break;
                }
                default: {
                    this.containsBtn.setSelected(true);
                }
            }
        }
    }
}

