/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.Scenarios;

import com.spss.datamodel.DataModel;
import com.spss.datamodel.Field;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioDefinitionDialog;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioPeriodDlg;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenariosDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMDefineScenariosTable;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.row_management_table.TableRowManagementHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TCMScenariosSimpleScenariosTab
extends BaseProcedureTab {
    private TCMScenariosDlg mTCMScenariosDlgParent;
    private TCMForecastGatingInfo mTCMForecastGatingInfo;
    protected FocusableTextArea mScenarioInfoText;
    protected JButton mDefineScenarioPeriodButton;
    protected JLabel mScenariosTableLabel;
    protected TCMDefineScenariosTable mScenariosTable;
    protected JScrollPane mScenariosScrollPane;
    private TableRowManagementHelper mTableRowManagementHelper;
    private JButton mDeleteButton;
    private JButton mCopyButton;
    protected JButton mAddScenarioButton;
    protected JButton mEditScenarioButton;
    TCMScenarioPeriodDlg.ScenarioPeriodInfo mScenarioPeriodInfo;

    public TCMScenariosSimpleScenariosTab(TCMScenariosDlg tCMScenariosDlg, TCMForecastGatingInfo tCMForecastGatingInfo) {
        super(tCMScenariosDlg, true);
        this.mTCMScenariosDlgParent = tCMScenariosDlg;
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.initialize();
    }

    public boolean doValidateTab() {
        String string = null;
        if (this.getScenarioPeriodInfo() == null) {
            string = this.getResString("IDS_TCM_SCENARIO_A_ACENARIO_PERIOD_MUST_BE_DEFINED_ERROR_MESSAGE");
        }
        if (string == null && this.getNumScenarios() == 0) {
            string = this.getResString("IDS_TCM_SCENARIO_AT_LEAST_ONE_SCENARIO_MUST_BE_DEFINED_ERROR_MESSAGE");
        }
        if (string == null && !this.mScenariosTable.doValidateTable()) {
            return false;
        }
        if (string != null) {
            TCMUtilities.throwErrorDialog((JDialog)((Object)this.mTCMScenariosDlgParent), string);
        }
        return string == null;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_tcm_scenarios_scenarios";
    }

    @Override
    protected boolean validateTab() {
        return true;
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
    }

    private void initialize() {
        this.initVars();
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        JPanel jPanel2 = this.getScenarioPeriodPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.getScenariosTablePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.updateEnableStatus();
    }

    private JPanel getScenarioPeriodPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_TAB_SCENARIO_PERIOD_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        JPanel jPanel2 = TCMUtilities.createInfoPanel(this.mScenarioInfoText);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDefineScenarioPeriodButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel getScenariosTablePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mScenariosTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScenariosScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mAddScenarioButton);
        jPanel2.add(this.mEditScenarioButton);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel3 = this.setupAddUpDownRemoveCmdButtonPanel();
        DialogUtil.normalizeLabelWidths(jPanel3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void updateEnableStatus() {
        this.mCopyButton.setEnabled(this.mScenarioPeriodInfo != null && this.mScenariosTable.getSelectedRowCount() > 0);
        this.mDeleteButton.setEnabled(this.mScenarioPeriodInfo != null && this.mScenariosTable.getSelectedRowCount() > 0);
        this.mEditScenarioButton.setEnabled(this.mScenarioPeriodInfo != null && this.mScenariosTable.getSelectedRowCount() == 1);
        this.mScenariosTableLabel.setEnabled(this.mScenarioPeriodInfo != null);
        this.mAddScenarioButton.setEnabled(this.mScenarioPeriodInfo != null);
        this.mScenariosScrollPane.setEnabled(this.mScenarioPeriodInfo != null);
        this.mAddScenarioButton.setEnabled(this.mScenarioPeriodInfo != null);
    }

    public void setDefaults() {
        this.mScenarioPeriodInfo = null;
        this.mScenariosTable.reset();
        this.updateEnableStatus();
    }

    public TCMForecastGatingInfo.EstimationPeriodType getDefaultEstimationPeriodType() {
        return this.mTCMForecastGatingInfo.getEstmationPeriodType();
    }

    @Override
    protected void aboutToShowTab() {
    }

    private void initVars() {
        this.mScenarioInfoText = new FocusableTextArea(this.getResString("IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_TAB_INFO_TEXT"), null);
        this.mDefineScenarioPeriodButton = DialogUtil.createButton(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_TAB_DEFINE_SCENARIO_PERIOD_BUTTON", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenarioPeriodDlg tCMScenarioPeriodDlg = new TCMScenarioPeriodDlg(TCMScenariosSimpleScenariosTab.this.mTCMScenariosDlgParent, TCMScenariosSimpleScenariosTab.this.mScenarioPeriodInfo, TCMScenariosSimpleScenariosTab.this.mTCMForecastGatingInfo);
                tCMScenarioPeriodDlg.setVisible(true);
                if (tCMScenarioPeriodDlg.wasOkPressed()) {
                    boolean bl;
                    TCMScenariosSimpleScenariosTab.this.mScenarioPeriodInfo = tCMScenarioPeriodDlg.getScenarioPeriodInfo();
                    boolean bl2 = bl = TCMScenariosSimpleScenariosTab.this.mScenarioPeriodInfo != null ? TCMScenariosSimpleScenariosTab.this.mScenariosTable.setNewScenarioPeriod(TCMScenariosSimpleScenariosTab.this.mScenarioPeriodInfo) : false;
                    if (bl) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)TCMScenariosSimpleScenariosTab.this.mTCMScenariosDlgParent), TCMScenariosSimpleScenariosTab.this.getResString("IDS_TCM_SCENARIOPERIOD_NEW_SCENARIO_PERIOD_WARNING_MESSAGE"), VersionInfo.getAppVersionString());
                    }
                    TCMScenariosSimpleScenariosTab.this.updateEnableStatus();
                }
            }
        });
        this.mScenariosTableLabel = DialogUtil.createLabel(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_TAB_SCENARIOS_TABLE_LABEL");
        this.mScenariosTable = new TCMDefineScenariosTable(this.mTCMScenariosDlgParent, this.mTCMForecastGatingInfo, this.mTCMScenariosDlgParent.getResourceBundle());
        this.mScenariosScrollPane = new JScrollPane(this.mScenariosTable);
        this.mScenariosScrollPane.setPreferredSize(new Dimension(400, 300));
        this.mScenariosTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TCMScenariosSimpleScenariosTab.this.updateEnableStatus();
            }
        });
        this.mAddScenarioButton = DialogUtil.createButton(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_TAB_ADD_SCENARIO_BUTTON", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenarioDefinitionDialog tCMScenarioDefinitionDialog = new TCMScenarioDefinitionDialog(TCMScenariosSimpleScenariosTab.this.mTCMScenariosDlgParent, TCMScenariosSimpleScenariosTab.this.mTCMForecastGatingInfo, TCMScenariosSimpleScenariosTab.this.mScenarioPeriodInfo);
                tCMScenarioDefinitionDialog.setVisible(true);
                if (tCMScenarioDefinitionDialog.wasOkPressed()) {
                    TCMScenariosSimpleScenariosTab.this.mScenariosTable.addScenario(tCMScenarioDefinitionDialog.getScenarioDefinitionInfo());
                }
            }
        });
        this.mEditScenarioButton = DialogUtil.createButton(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SIMPLE_SCENARIOS_TAB_EDIT_SCENARIO_BUTTON", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TCMScenariosSimpleScenariosTab.this.mScenariosTable.getSelectedRow();
                if (n != -1) {
                    TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo = TCMScenariosSimpleScenariosTab.this.mScenariosTable.getScenarioDefinitionInfoForRow(n);
                    TCMScenarioDefinitionDialog tCMScenarioDefinitionDialog = new TCMScenarioDefinitionDialog(TCMScenariosSimpleScenariosTab.this.mTCMScenariosDlgParent, scenarioDefinitionInfo, TCMScenariosSimpleScenariosTab.this.mTCMForecastGatingInfo);
                    tCMScenarioDefinitionDialog.setVisible(true);
                    if (tCMScenarioDefinitionDialog.wasOkPressed()) {
                        TCMScenariosSimpleScenariosTab.this.mScenariosTable.editScenario(n, tCMScenarioDefinitionDialog.getScenarioDefinitionInfo());
                    }
                }
            }
        });
    }

    private JPanel setupAddUpDownRemoveCmdButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mTCMScenariosDlgParent, "IDS_TCM_FORCASTING_DELETE_BUTTON_IMAGE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSimpleScenariosTab.this.mScenariosTable.deleteSelectedRows();
                TCMScenariosSimpleScenariosTab.this.updateEnableStatus();
            }
        };
        this.mDeleteButton = this.createButton("IDS_TCM_FORCASTING_DELETE_BUTTON_IMAGE", toggleButtonAction);
        TCMUtilities.addTooltip(this.mTCMScenariosDlgParent, this.mDeleteButton, "IDS_TCM_FORCASTING_DELETE_BUTTON_IMAGE");
        DialogUtil.addUsingGBL(jPanel2, this.mDeleteButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this.mTCMScenariosDlgParent, "IDS_TCM_FORCASTING_COPY_BUTTON_IMAGE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSimpleScenariosTab.this.doCopySelectedRow();
            }
        };
        this.mCopyButton = this.createButton("IDS_TCM_FORCASTING_COPY_BUTTON_IMAGE", toggleButtonAction);
        TCMUtilities.addTooltip(this.mTCMScenariosDlgParent, this.mCopyButton, "IDS_TCM_FORCASTING_COPY_BUTTON_IMAGE");
        DialogUtil.addUsingGBL(jPanel2, this.mCopyButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private void doCopySelectedRow() {
        int[] nArray = this.mScenariosTable.getSelectedRows();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            String string = this.mScenariosTable.copyRow(n);
            if (string == null) continue;
            arrayList.add(string);
        }
        this.mScenariosTable.selectRowsByScenarioIDNames(arrayList);
    }

    private JButton createButton(String string, Action action) {
        ImageIcon imageIcon = new ImageIcon(this.mTCMScenariosDlgParent.getResImageURL(string));
        JButton jButton = new JButton(imageIcon);
        if (action != null) {
            jButton.addActionListener(action);
        }
        return jButton;
    }

    public ArrayList<String> getFieldNames(DataModel dataModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : dataModel.getFields()) {
            arrayList.add(field.getName());
        }
        return arrayList;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }

    public TCMScenarioPeriodDlg.ScenarioPeriodInfo getScenarioPeriodInfo() {
        return this.mScenarioPeriodInfo;
    }

    public int getNumScenarios() {
        return this.mScenariosTable.getRowCount();
    }

    public void addScenario(TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo) {
        this.mScenariosTable.addScenario(scenarioDefinitionInfo);
    }

    public void appendSyntax(StringBuffer stringBuffer) {
        stringBuffer.append(TCMUtilities.getScenarioPeriodSyntax(this.mTCMForecastGatingInfo, this.mScenarioPeriodInfo));
        stringBuffer.append(this.mScenariosTable.getScenarioSyntax());
    }

    public String getStartTimesSyntax() {
        return "aStart bStart cStart";
    }

    public String getEndTimesSyntax() {
        return "aEnd baEnd caEnd";
    }

    public boolean isObservationDateTimeField() {
        return true;
    }

    public boolean isScenarioIDUnique(String string) {
        return this.mScenariosTable.getModel().getRowCount() == 0 || this.mScenariosTable.findRowByScenarioIDName(string) < 0;
    }

    public boolean hasScenariosBasedOnExpressions() {
        return this.mScenariosTable.hasScenariosBasedOnExpressions();
    }

    public String getComputeSyntax() {
        return this.mScenariosTable.getComputeSyntax();
    }

    @Override
    public Vector<Object> getComponentOrder() {
        this.mComponentOrder.clear();
        this.mComponentOrder.add(this.mScenarioInfoText);
        this.mComponentOrder.add(this.mDefineScenarioPeriodButton);
        this.mComponentOrder.add(this.mScenariosTable);
        this.mComponentOrder.add(this.mDeleteButton);
        this.mComponentOrder.add(this.mCopyButton);
        this.mComponentOrder.add(this.mAddScenarioButton);
        this.mComponentOrder.add(this.mEditScenarioButton);
        return this.mComponentOrder;
    }
}

