/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.Scenarios;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenariosDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class TCMScenariosSaveTab
extends BaseProcedureTab {
    private TCMScenariosDlg mTCMScenariosDlgParent;
    JCheckBox mPredictedValuesCheckBox;
    JLabel mPredictedValuesRootNameLabel;
    JTextField mPredictedValuesRootNameTextField;
    JCheckBox mUpperLowerConfLimitsCheckBox;
    JLabel mUpperRootNameLabel;
    JTextField mUpperRootNameTextField;
    JLabel mLowerRootNameLabel;
    JTextField mLowerRootNameTextField;
    JCheckBox mIndicateCasesContainingForcastsCheckBox;
    JLabel mIndicateCasesFieldNameLabel;
    JTextField mIndicateCasesFieldNameTextField;
    SpssButtonGroup mSaveTargetsButtonGroup = new SpssButtonGroup();
    SpssButtonGroup mSavePredictionsToDataFileORActiveDatasetButtonGroup = new SpssButtonGroup();
    SpssButtonGroup mSPSSDataFileOrNewDatasetButtonGroup = new SpssButtonGroup();
    JRadioButton mSavePredictionsAndTransformedDataToNewDatafileRB;
    JRadioButton mSPSSDataFileRB;
    JLabel mSPSSDatafileFileLabel;
    JTextField mSPSSDatafileFileTextField;
    JButton mSPSSDatafileFileBrowseButton;
    JRadioButton mNewDatasetFileRB;
    JLabel mNewDatasetNameLabel;
    JTextField mNewDatasetNameTextField;
    JRadioButton mSavePredictionsToActiveDatasetRB;
    private TCMForecastGatingInfo mTCMForecastGatingInfo;
    private String mEncryptFilePassword = null;

    public TCMScenariosSaveTab(TCMScenariosDlg tCMScenariosDlg, TCMForecastGatingInfo tCMForecastGatingInfo) {
        super(tCMScenariosDlg, true);
        this.mTCMScenariosDlgParent = tCMScenariosDlg;
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.initialize();
    }

    @Override
    public Vector<Object> getComponentOrder() {
        this.mComponentOrder.clear();
        this.mComponentOrder.add(this.mPredictedValuesCheckBox);
        this.mComponentOrder.add(this.mPredictedValuesRootNameTextField);
        this.mComponentOrder.add(this.mUpperLowerConfLimitsCheckBox);
        this.mComponentOrder.add(this.mLowerRootNameTextField);
        this.mComponentOrder.add(this.mUpperRootNameTextField);
        this.mComponentOrder.add(this.mIndicateCasesContainingForcastsCheckBox);
        this.mComponentOrder.add(this.mIndicateCasesFieldNameTextField);
        this.mComponentOrder.add(this.mSaveTargetsButtonGroup);
        this.mComponentOrder.add(this.mSavePredictionsAndTransformedDataToNewDatafileRB);
        this.mComponentOrder.add(this.mSPSSDataFileRB);
        this.mComponentOrder.add(this.mSPSSDatafileFileTextField);
        this.mComponentOrder.add(this.mSPSSDatafileFileBrowseButton);
        this.mComponentOrder.add(this.mNewDatasetFileRB);
        this.mComponentOrder.add(this.mNewDatasetNameTextField);
        this.mComponentOrder.add(this.mSavePredictionsToActiveDatasetRB);
        return this.mComponentOrder;
    }

    public boolean doValidateTab() {
        boolean bl = true;
        boolean bl2 = this.validateSaveTargetsPanel();
        bl = bl2 ? this.validateDestinationOptionsPanel() : false;
        return bl;
    }

    private boolean validateDestinationOptionsPanel() {
        boolean bl = true;
        if (this.mSavePredictionsAndTransformedDataToNewDatafileRB.isEnabled() && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected()) {
            if (this.mSPSSDataFileRB.isEnabled() && this.mSPSSDataFileRB.isSelected()) {
                bl = TCMUtilities.isValidFileDirectory((JDialog)((Object)this.mTCMScenariosDlgParent), this.mSPSSDatafileFileTextField.getText(), this.getResString("IDS_TS_FORECASTING_EMPTY_FILE_NAME_ERROR"), this.getResString("IDS_TS_FORECASTING_INVALID_FOLDER_LOCATION_ERROR"));
            } else if (this.mNewDatasetNameTextField.isEnabled() && this.mNewDatasetNameTextField.getText() == null || this.mNewDatasetNameTextField.getText().trim().length() == 0) {
                this.throwTextFieldError(this.mNewDatasetNameTextField, this.getResString("IDS_TS_FORECASTING_INVALID_DATASETNAME_ERROR"));
                bl = false;
            }
        }
        return bl;
    }

    private boolean validateSaveTargetsPanel() {
        boolean bl = true;
        ArrayList<JTextField> arrayList = new ArrayList<JTextField>();
        if (this.mPredictedValuesCheckBox.isSelected()) {
            arrayList.add(this.mPredictedValuesRootNameTextField);
        }
        if (this.mUpperLowerConfLimitsCheckBox.isSelected()) {
            arrayList.add(this.mUpperRootNameTextField);
            arrayList.add(this.mLowerRootNameTextField);
        }
        if ((bl = this.areRootNamesValid(arrayList, true)) && this.mIndicateCasesContainingForcastsCheckBox.isSelected()) {
            bl = this.isNameValid(this.mIndicateCasesFieldNameTextField, false);
        }
        return bl;
    }

    private boolean isNameValid(JTextField jTextField, boolean bl) {
        ArrayList<JTextField> arrayList = new ArrayList<JTextField>();
        arrayList.add(jTextField);
        return this.areRootNamesValid(arrayList, false);
    }

    private boolean areRootNamesValid(ArrayList<JTextField> arrayList, boolean bl) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl2 = true;
        for (JTextField jTextField : arrayList) {
            String string = jTextField.getText();
            if (string == null || string.length() == 0) {
                this.throwTextFieldError(jTextField, this.getResString("IDS_TS_FORECASTING_INVALID_NAME_ROOTNAME_ERROR"));
                bl2 = false;
                break;
            }
            int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
            if (n > 0 && n != 100) {
                DialogUtil.showBadSpssVarNameWarning(n, this.mTCMScenariosDlgParent);
                jTextField.selectAll();
                jTextField.requestFocus();
                bl2 = false;
                break;
            }
            if (string.length() > 63) {
                this.throwTextFieldError(jTextField, this.getResString("IDS_TS_FORECASTING_INVALID_LENGTH_ROOTNAME_ERROR"));
                bl2 = false;
                break;
            }
            if (!bl) continue;
            boolean bl3 = arrayList2.contains(string);
            if (bl3) {
                this.throwTextFieldError(jTextField, this.getResString("IDS_TS_FORECASTING_DUPLICATE_ROOTNAME_ERROR"));
                bl2 = false;
                break;
            }
            arrayList2.add(string);
        }
        return bl2;
    }

    private void throwTextFieldError(JTextField jTextField, String string) {
        this.mTCMScenariosDlgParent.selectSaveTab();
        jTextField.requestFocusInWindow();
        jTextField.selectAll();
        TCMForcastingDlg.throwErrorDialog((Window)((Object)this.mTCMScenariosDlgParent), string);
    }

    public void appendSyntax(StringBuffer stringBuffer) {
        this.appendSaveTargetsSyntax(stringBuffer);
        this.appendDestinationOptionsSyntax(stringBuffer);
    }

    private String appendSaveTargetsSyntax(StringBuffer stringBuffer) {
        if (this.mPredictedValuesCheckBox.isSelected() || this.mUpperLowerConfLimitsCheckBox.isSelected()) {
            String string;
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE "));
            if (this.mPredictedValuesCheckBox.isSelected()) {
                string = MessageFormat.format(" PREDICTED({0})", this.mPredictedValuesRootNameTextField.getText());
                stringBuffer.append(string);
            }
            if (this.mUpperLowerConfLimitsCheckBox.isSelected()) {
                string = MessageFormat.format(" CL(LCLROOT={0} UCLROOT={1})", this.mLowerRootNameTextField.getText(), this.mUpperRootNameTextField.getText());
                stringBuffer.append(string);
            }
            if (this.mIndicateCasesContainingForcastsCheckBox.isSelected()) {
                string = MessageFormat.format(" FORECASTFLAG({0})", this.mIndicateCasesFieldNameTextField.getText());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getNewDatasetName() {
        boolean bl;
        String string = null;
        boolean bl2 = bl = this.mPredictedValuesCheckBox.isSelected() || this.mUpperLowerConfLimitsCheckBox.isSelected();
        if (bl && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected() && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isEnabled() && this.mNewDatasetFileRB.isSelected()) {
            string = this.mNewDatasetNameTextField.getText();
        }
        return string;
    }

    private String appendDestinationOptionsSyntax(StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = this.mPredictedValuesCheckBox.isSelected() || this.mUpperLowerConfLimitsCheckBox.isSelected();
        if (bl && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected() && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isEnabled()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand(" /OUTFILE "));
            if (this.mSPSSDataFileRB.isSelected()) {
                String string;
                String string2 = this.mSPSSDatafileFileTextField.getText().length() > 0 ? SyntaxUtil.wrapText(this.mSPSSDatafileFileTextField.getText(), '\'') : "''";
                String string3 = MessageFormat.format(" DATA = {0}", string2);
                stringBuffer.append(string3);
                if (this.mEncryptFilePassword != null && this.mEncryptFilePassword.length() > 0 && (string = SyntaxUtil.getEncryptPasswordSyntax(this.mEncryptFilePassword)) != null) {
                    stringBuffer.append(string);
                }
            } else if (this.mNewDatasetFileRB.isSelected()) {
                String string = MessageFormat.format(" DATA = {0}", this.mNewDatasetNameTextField.getText());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        this.setDefaults();
        this.updateEnableStates();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_tcm_scenarios_save";
    }

    @Override
    protected boolean validateTab() {
        return true;
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
    }

    private void initialize() {
        this.initVars();
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 3, 2);
        JPanel jPanel2 = this.getSaveTargetsPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.getDestinationObservationsPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.updateEnableStates();
    }

    private void updateEnableStates() {
        boolean bl = this.mPredictedValuesCheckBox.isSelected();
        this.mPredictedValuesRootNameLabel.setEnabled(bl);
        this.mPredictedValuesRootNameTextField.setEnabled(bl);
        boolean bl2 = this.mUpperLowerConfLimitsCheckBox.isSelected();
        this.mUpperRootNameLabel.setEnabled(bl2);
        this.mUpperRootNameTextField.setEnabled(bl2);
        this.mLowerRootNameLabel.setEnabled(bl2);
        this.mLowerRootNameTextField.setEnabled(bl2);
        boolean bl3 = this.mIndicateCasesContainingForcastsCheckBox.isSelected();
        this.mIndicateCasesFieldNameLabel.setEnabled(bl3);
        this.mIndicateCasesFieldNameTextField.setEnabled(bl3);
        boolean bl4 = this.mPredictedValuesCheckBox.isSelected() || this.mUpperLowerConfLimitsCheckBox.isSelected();
        boolean bl5 = bl4 && this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected();
        boolean bl6 = bl5 && this.mSPSSDataFileRB.isSelected();
        boolean bl7 = this.mSavePredictionsAndTransformedDataToNewDatafileRB.isSelected() && bl4 && this.mNewDatasetFileRB.isSelected();
        this.mSavePredictionsAndTransformedDataToNewDatafileRB.setEnabled(bl4);
        this.mSPSSDataFileRB.setEnabled(bl5);
        this.mSPSSDatafileFileLabel.setEnabled(bl6);
        this.mSPSSDatafileFileTextField.setEnabled(bl6);
        this.mSPSSDatafileFileBrowseButton.setEnabled(bl6);
        this.mNewDatasetFileRB.setEnabled(bl5);
        this.mNewDatasetNameLabel.setEnabled(bl7);
        this.mNewDatasetNameTextField.setEnabled(bl7);
        this.mSavePredictionsToActiveDatasetRB.setEnabled(bl4 && this.mTCMForecastGatingInfo.canWriteToActiveDataset());
    }

    public void setDefaults() {
        this.mPredictedValuesCheckBox.setSelected(false);
        this.mPredictedValuesRootNameTextField.setText("Predicted");
        this.mUpperLowerConfLimitsCheckBox.setSelected(false);
        this.mUpperRootNameTextField.setText("UCL");
        this.mLowerRootNameTextField.setText("LCL");
        this.mIndicateCasesContainingForcastsCheckBox.setSelected(false);
        this.mIndicateCasesFieldNameTextField.setText("ForecasteIndicator");
        boolean bl = this.mTCMForecastGatingInfo.canWriteToActiveDataset();
        this.mSavePredictionsAndTransformedDataToNewDatafileRB.setSelected(!bl);
        this.mSavePredictionsToActiveDatasetRB.setSelected(bl);
        this.mSPSSDataFileRB.setSelected(true);
        this.mSPSSDatafileFileTextField.setText("");
        this.mNewDatasetFileRB.setSelected(true);
        this.mNewDatasetNameTextField.setText("");
        this.updateEnableStates();
    }

    @Override
    protected void aboutToShowTab() {
    }

    private void initVars() {
        this.mPredictedValuesCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_PREDICTED_VALUES_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSaveTab.this.updateEnableStates();
            }
        });
        this.mPredictedValuesRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_PREDICTED_VALUESROOTNAME_LABEL");
        this.mPredictedValuesRootNameTextField = new JTextField();
        this.mPredictedValuesRootNameLabel.setLabelFor(this.mPredictedValuesRootNameTextField);
        this.mUpperLowerConfLimitsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_UPPER_LOWER_CONF_LIMITS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSaveTab.this.updateEnableStates();
            }
        });
        this.mUpperRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_UPPER_ROOTNAME_LABEL");
        this.mLowerRootNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_LOWER_ROOTNAME_LABEL");
        this.mLowerRootNameTextField = new JTextField();
        this.mUpperRootNameTextField = new JTextField();
        this.mUpperRootNameLabel.setLabelFor(this.mUpperRootNameTextField);
        this.mLowerRootNameLabel.setLabelFor(this.mLowerRootNameTextField);
        this.mIndicateCasesContainingForcastsCheckBox = DialogUtil.createCheckBox(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_INDICATE_CASES_FORCASTS_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSaveTab.this.updateEnableStates();
            }
        });
        this.mIndicateCasesFieldNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_INDICATE_CASES_FORCASTS_FIELD_NAME_LABEL");
        this.mIndicateCasesFieldNameTextField = new JTextField();
        this.mIndicateCasesFieldNameLabel.setLabelFor(this.mIndicateCasesFieldNameTextField);
        this.mSavePredictionsAndTransformedDataToNewDatafileRB = DialogUtil.createRadioButton(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SAVETAB_SAVE_PREDICTIONS_TO_NEW_DATAFILE_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSaveTab.this.updateEnableStates();
            }
        });
        this.mSPSSDataFileRB = DialogUtil.createRadioButton(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SAVETAB_A_NEW_SPSS_DATAFILE_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSaveTab.this.updateEnableStates();
            }
        });
        this.mSPSSDatafileFileLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_A_NEW_SPSS_DATAFILE_FILE_LABEL");
        this.mSPSSDatafileFileTextField = new JTextField();
        this.mSPSSDatafileFileLabel.setLabelFor(this.mSPSSDatafileFileTextField);
        this.mSPSSDatafileFileBrowseButton = DialogUtil.createButton(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SAVETAB_A_NEW_SPSS_DATAFILE_FILE_BROWSE_LABEL", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TCMScenariosSaveTab.this.showSaveDialog(TCMScenariosSaveTab.this.getResString("IDS_TCM_SCENARIOS_SAVETAB_SAVEAS_DATA_DIALOG_TITLE"), TCMScenariosSaveTab.this.getResString("IDS_TCM_SCENARIOS_SAVETAB_SAVEAS_DATA_FILE_FILTER"), TCMScenariosSaveTab.this.getResString("IDS_TCM_SCENARIOS_SAVETAB_SAVEAS_DATA_FILE_FILTER_EXTN"));
                if (string != null) {
                    TCMScenariosSaveTab.this.mSPSSDatafileFileTextField.setText(string);
                }
            }
        });
        this.mNewDatasetFileRB = DialogUtil.createRadioButton(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SAVETAB_A_NEW_DATASET_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSaveTab.this.updateEnableStates();
            }
        });
        this.mNewDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_SCENARIOS_SAVETAB_A_NEW_DATASET_DATASETNAME_LABEL");
        this.mNewDatasetNameTextField = new JTextField();
        this.mNewDatasetNameLabel.setLabelFor(this.mNewDatasetNameTextField);
        this.mSavePredictionsToActiveDatasetRB = DialogUtil.createRadioButton(this.mTCMScenariosDlgParent, "IDS_TCM_SCENARIOS_SAVETAB_SAVE_PREDICTIONS_TO_ACTIVE_DATASET_RB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TCMScenariosSaveTab.this.updateEnableStates();
            }
        });
        this.mSPSSDataFileOrNewDatasetButtonGroup.add(this.mSPSSDataFileRB);
        this.mSPSSDataFileOrNewDatasetButtonGroup.add(this.mNewDatasetFileRB);
        this.mSavePredictionsToDataFileORActiveDatasetButtonGroup.add(this.mSavePredictionsAndTransformedDataToNewDatafileRB);
        this.mSavePredictionsToDataFileORActiveDatasetButtonGroup.add(this.mSavePredictionsToActiveDatasetRB);
    }

    public String showSaveDialog(String string, String string2, String string3) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string3));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string4 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            int n2 = string4.indexOf(this.getResString("IDS_TCM_SCENARIOS_SAVETAB_SAVEAS_FILE_FILTER_EXTN"));
            if (n2 == -1) {
                string4 = string4.concat(this.getResString("IDS_TCM_SCENARIOS_SAVETAB_SAVEAS_FILE_FILTER_EXTN"));
            }
            if (remoteFileChooser.isEncryptFileWithPassword()) {
                this.mEncryptFilePassword = remoteFileChooser.getEncryptFilePassword();
            }
            return string4;
        }
        return "";
    }

    private JPanel getSaveTargetsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_SCENARIOS_SAVETAB_SAVE_TARGETS_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPredictedValuesCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.getLabelTexFieldPanel(new JLabel[]{this.mPredictedValuesRootNameLabel}, new JTextField[]{this.mPredictedValuesRootNameTextField});
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mUpperLowerConfLimitsCheckBox, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jPanel2 = this.getLabelTexFieldPanel(new JLabel[]{this.mLowerRootNameLabel, this.mUpperRootNameLabel}, new JTextField[]{this.mLowerRootNameTextField, this.mUpperRootNameTextField});
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mIndicateCasesContainingForcastsCheckBox, gridBagConstraints, 0, 4, 1, 1, n, insets);
        jPanel2 = this.getLabelTexFieldPanel(new JLabel[]{this.mIndicateCasesFieldNameLabel}, new JTextField[]{this.mIndicateCasesFieldNameTextField});
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getLabelTexFieldPanel(JLabel[] jLabelArray, JTextField[] jTextFieldArray) {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, 0, n2, n2 * 2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        for (int i = 0; i < jLabelArray.length; ++i) {
            JLabel jLabel = jLabelArray[i];
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            Insets insets3 = i == 0 ? insets2 : insets;
            int n3 = i * 2;
            DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, n3, 0, 1, 1, n, insets3);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jTextFieldArray[i], gridBagConstraints, n3 + 1, 0, 1, 1, n, insets);
        }
        return jPanel;
    }

    private JPanel getDestinationObservationsPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_TCM_SCENARIOS_SAVETAB_DESTINATION_OPTIONS_GRPBX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        Insets insets3 = new Insets(insets2.top, insets2.left + 30, insets2.bottom, insets2.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSavePredictionsAndTransformedDataToNewDatafileRB, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSPSSDataFileRB, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel2 = this.getSpssFileBrowsePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNewDatasetFileRB, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        JPanel jPanel3 = this.getLabelTexFieldPanel(new JLabel[]{this.mNewDatasetNameLabel}, new JTextField[]{this.mNewDatasetNameTextField});
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSavePredictionsToActiveDatasetRB, gridBagConstraints, 0, 5, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getSpssFileBrowsePanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(2, 0, n2, n2 * 2);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSPSSDatafileFileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSPSSDatafileFileTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSPSSDatafileFileBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
        return vector;
    }
}

