/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.Scenarios;

import com.spss.datamodel.BaseFieldContent;
import com.spss.datamodel.DataModel;
import com.spss.datamodel.Field;
import com.spss.datamodel.Fields;
import com.spss.datamodel.ValidValue;
import com.spss.datamodel.ValidValues;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMMultiDimScenarioDefinitionDialog;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenarioDefinitionDialog;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenariosMultiDimScenariosTab;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenariosOptionsTab;
import com.spss.java_client.ui.dialogs.TCM.Scenarios.TCMScenariosSimpleScenariosTab;
import com.spss.java_client.ui.dialogs.TCM.TCMForcastingGatingDlg;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TCMScenariosDlg
extends BaseTabbedDialog {
    protected TCMScenariosSimpleScenariosTab mSimpleScenariosTab;
    protected TCMScenariosMultiDimScenariosTab mScenariosMultiDimScenariosTab;
    protected TCMScenariosOptionsTab mOptionsTab;
    TCMForecastGatingInfo mTCMForecastGatingInfo;

    public TCMScenariosDlg(JFrame jFrame) {
        super(jFrame, true, TCMResBundle.getDefaultResourceBundleName(), TCMResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_TCM_SCENARIOS_DLG_TITLE"));
        this.mTCMForecastGatingInfo = TCMForcastingGatingDlg.mTCMForecastGatingInfo;
        this.mTCMForecastGatingInfo.setMode(TCMForecastGatingInfo.Mode.SCENARIOS);
        int n = ResUtil.getCommonDlgAccessKey("IDK_TCM_GATING_DEFINE_DATES_BUTTON");
        this.enableOkPaste(true);
    }

    @Override
    public String getIActionKey() {
        return "analyze_tcm_scenarios_dialog";
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.setDefaults();
    }

    public void setDefaults() {
        if (this.mSimpleScenariosTab != null) {
            this.mSimpleScenariosTab.setDefaults();
        }
        if (this.mScenariosMultiDimScenariosTab != null) {
            this.mScenariosMultiDimScenariosTab.setDefaults();
        }
        this.mOptionsTab.setDefaults();
    }

    @Override
    public boolean okPastePressed() {
        if (this.mSimpleScenariosTab != null && !this.mSimpleScenariosTab.doValidateTab()) {
            return false;
        }
        if (this.mScenariosMultiDimScenariosTab != null && !this.mScenariosMultiDimScenariosTab.doValidateTab()) {
            return false;
        }
        if (this.mOptionsTab != null && !this.mOptionsTab.doValidateTab()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    public void reset() {
        if (this.mSimpleScenariosTab != null) {
            this.mSimpleScenariosTab.reset();
        } else if (this.mScenariosMultiDimScenariosTab != null) {
            this.mScenariosMultiDimScenariosTab.reset();
        }
        this.mOptionsTab.reset();
    }

    void selectSimulationTab() {
        this.mTabbedPane.setSelectedIndex(1);
    }

    void selectModelTab() {
        this.mTabbedPane.setSelectedIndex(0);
    }

    public static double formatDoubleValue(double d, int n) {
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumFractionDigits(n);
            return numberFormat.parse(numberFormat.format(d)).doubleValue();
        }
        catch (ParseException parseException) {
            return d;
        }
    }

    public TCMScenariosSimpleScenariosTab getScenariosTab() {
        return this.mSimpleScenariosTab;
    }

    public TCMScenariosMultiDimScenariosTab getMultiDimScenariosTab() {
        return this.mScenariosMultiDimScenariosTab;
    }

    public TCMScenariosOptionsTab getOptionsTab() {
        return this.mOptionsTab;
    }

    @Override
    protected void init() {
        super.init();
        TCMForecastGatingInfo tCMForecastGatingInfo = TCMForcastingGatingDlg.mTCMForecastGatingInfo;
        this.mOkAction.putValue("Name", ResUtil.getCommonDlgString("IDS_RUN"));
        DialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
        if (!this.isMultiDimensionData()) {
            this.mSimpleScenariosTab = new TCMScenariosSimpleScenariosTab(this, tCMForecastGatingInfo);
            this.addTab(this.getResString("IDS_TCM_SCENARIOS_SCENARIOS_TAB"), this.mSimpleScenariosTab);
        } else {
            this.mScenariosMultiDimScenariosTab = new TCMScenariosMultiDimScenariosTab(this, tCMForecastGatingInfo);
            this.addTab(this.getResString("IDS_TCM_SCENARIOS_SCENARIOS_TAB"), this.mScenariosMultiDimScenariosTab);
        }
        this.mOptionsTab = new TCMScenariosOptionsTab(this, tCMForecastGatingInfo);
        this.addTab(this.getResString("IDS_TCM_SCENARIOS_OPTIONS_TAB"), this.mOptionsTab);
        this.pack();
    }

    private boolean isMultiDimensionData() {
        return TCMForcastingGatingDlg.mTCMForecastGatingInfo.isMultiDimensionalData();
    }

    @Override
    protected void addMainViewComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        JLabel jLabel = new JLabel("                     ");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 20, 0, 20);
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 0, 0, 6);
        gridBagConstraints.fill = 2;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
    }

    public Field findField(DataModel dataModel, String string) {
        Fields fields = dataModel.getFields();
        return fields.getField(string);
    }

    public ValidValues getFieldValues(DataModel dataModel, String string) {
        Field field = this.findField(dataModel, string);
        BaseFieldContent baseFieldContent = field != null ? this.findField(dataModel, string).getBaseFieldContent() : null;
        return baseFieldContent != null ? baseFieldContent.getValues() : null;
    }

    public ArrayList<String> getFieldValueStringList(DataModel dataModel, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ValidValues validValues = this.getFieldValues(dataModel, string);
        if (validValues != null) {
            for (ValidValue validValue : validValues) {
                arrayList.add(validValue.getValue());
            }
        }
        return arrayList;
    }

    public boolean isDateTimeSelected() {
        return this.mTCMForecastGatingInfo.isDateTimeType();
    }

    public ArrayList<String> getFieldNames(DataModel dataModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : dataModel.getFields()) {
            arrayList.add(field.getName());
        }
        return arrayList;
    }

    public int getMaxAutoDetectTargets() {
        return this.mOptionsTab.getMaxAutoDetectTargets();
    }

    public boolean isScenarioIDUnique(String string) {
        return this.mSimpleScenariosTab != null ? this.mSimpleScenariosTab.isScenarioIDUnique(string) : false;
    }

    public boolean isScenarioIDUnique(String string, boolean bl) {
        boolean bl2 = true;
        if (this.mSimpleScenariosTab != null) {
            bl2 = this.mSimpleScenariosTab.isScenarioIDUnique(string);
        } else if (this.mScenariosMultiDimScenariosTab != null) {
            bl2 = this.mScenariosMultiDimScenariosTab.isScenarioIDUnique(string, bl);
        }
        return bl2;
    }

    public void addScenario(TCMScenarioDefinitionDialog.ScenarioDefinitionInfo scenarioDefinitionInfo) {
        if (this.mSimpleScenariosTab != null) {
            // empty if block
        }
        this.mSimpleScenariosTab.addScenario(scenarioDefinitionInfo);
    }

    public void addScenario(TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo, boolean bl) {
        if (this.mScenariosMultiDimScenariosTab != null) {
            // empty if block
        }
        if (bl) {
            this.mScenariosMultiDimScenariosTab.addGroupScenario(multiDimScenarioDefinitionInfo);
        } else {
            this.mScenariosMultiDimScenariosTab.addIndividualScenario(multiDimScenarioDefinitionInfo);
        }
    }

    public void editScenario(TCMMultiDimScenarioDefinitionDialog.MultiDimScenarioDefinitionInfo multiDimScenarioDefinitionInfo, boolean bl) {
        if (this.mScenariosMultiDimScenariosTab != null) {
            // empty if block
        }
        if (bl) {
            this.mScenariosMultiDimScenariosTab.addGroupScenario(multiDimScenarioDefinitionInfo);
        } else {
            this.mScenariosMultiDimScenariosTab.addIndividualScenario(multiDimScenarioDefinitionInfo);
        }
    }

    void selectSaveTab() {
        this.mTabbedPane.setSelectedIndex(2);
    }

    @Override
    public String generateSyntax() {
        boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        boolean bl2 = bl = this.mSimpleScenariosTab != null ? this.mSimpleScenariosTab.hasScenariosBasedOnExpressions() : this.mScenariosMultiDimScenariosTab.hasScenariosBasedOnExpressions();
        if (this.mScenariosMultiDimScenariosTab != null) {
            this.mScenariosMultiDimScenariosTab.prepForSyntaxGeneration();
        }
        if (bl) {
            stringBuffer.append(this.getExpressionSyntax(TCMUtilities.getTCMScenarioExpressionsTempFileNamePath()));
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("\nTCM ANALYSIS"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MODELSYSTEM File="));
        stringBuffer.append(SyntaxUtil.wrapText(TCMForcastingGatingDlg.mTCMForecastGatingInfo.getModelFilePath(), '\''));
        stringBuffer.append("\n");
        if (bl) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/EXPRESSIONS "));
            stringBuffer.append("FILE=");
            stringBuffer.append(SyntaxUtil.wrapText(TCMUtilities.getTCMScenarioExpressionsTempFileNamePath(), '\''));
            stringBuffer.append("\n");
        }
        if (this.mSimpleScenariosTab != null) {
            this.mSimpleScenariosTab.appendSyntax(stringBuffer);
        } else if (this.mScenariosMultiDimScenariosTab != null) {
            this.mScenariosMultiDimScenariosTab.appendSyntax(stringBuffer);
        }
        stringBuffer.append("\n");
        this.mOptionsTab.appendSyntax(stringBuffer);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    public String getExpressionSyntax(String string) {
        String string2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\nBEGIN EXPR /OUTFILE PREPXML=");
        stringBuffer.append(SyntaxUtil.wrapText(string, '\''));
        stringBuffer.append(".");
        String string3 = string2 = this.mSimpleScenariosTab != null ? this.mSimpleScenariosTab.getComputeSyntax() : this.mScenariosMultiDimScenariosTab.getComputeSyntax();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string2);
        }
        stringBuffer.append("\nEND EXPR");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }
}

