/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM.Scenarios;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.FunctionList;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.TCM.TCMForecastGatingInfo;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMSrcVariableList;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TCMEquationSubDlg
extends BaseSubDialog
implements ItemListener {
    FocusableTextArea mMultiDimInfoLabel;
    JLabel mSrcVarListLabel;
    JLabel mExpressionTextAreaLabel;
    private TCMSrcVariableList mSrcVarList;
    private ExpressionAreaArrowButton mExpressionArrowButton;
    private ArrowButton mFunctionListArrowButton;
    private ExpressionBuilderTextArea mExpressionTextArea;
    private JScrollPane mExpressionTextAreaScrollPane;
    private JTextArea mDescriptionTextArea;
    private JScrollPane mDescriptionTextAreaScrollPane;
    private JLabel mFunctionGrpLabel;
    private JLabel mFunctionSpecialVarsLabel;
    private JList mFunctionGrpList;
    private JScrollPane mFunctionGrpListScrollPane;
    private JList mFunctionSpecialVarsList;
    private JScrollPane mFunctionSpecialVarsListScrollPane;
    private JScrollPane mSrcScrollPane;
    private CalcWidget mCalcPanel;
    private FunctionListControls mFunctionListControls;
    private Vector<String> mSupportedFunctions;
    private TCMForecastGatingInfo mTCMForecastGatingInfo;

    public TCMEquationSubDlg(BaseProcedureDialog baseProcedureDialog, TCMForecastGatingInfo tCMForecastGatingInfo, String string) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_TCM_FUNCTION_DLG_TITLE"), true);
        this.mTCMForecastGatingInfo = tCMForecastGatingInfo;
        this.myInit();
        this.mExpressionTextArea.setText(string);
        this.mSrcVarList.setTCMForecastGatingInfo(this.mTCMForecastGatingInfo);
        this.setDefaults();
    }

    @Override
    public boolean continuePressed() {
        if (!this.mExpressionTextArea.validateContents() || !DialogUtil.isValidIfExpression(this.mExpressionTextArea.getText(), this)) {
            this.mExpressionTextArea.requestFocus();
            this.mExpressionTextArea.selectAll();
            return false;
        }
        return super.continuePressed();
    }

    public String getEquation() {
        return this.mExpressionTextArea.getText();
    }

    public void setExpressionText(String string) {
        this.mExpressionTextArea.setText(string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.mExpressionTextArea.getText();
        if (string.equals("")) {
            this.enableContinue(false);
        } else if (string.contains("?")) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
        this.mDescriptionTextArea.setEnabled(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_tcm_scenarios_expressions";
    }

    protected void myInit() {
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mExpressionTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mFunctionSpecialVarsList);
        }
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        this.mFunctionListControls.loadFunctionState(dialogDataModel);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        dialogDataModel.putString("IDS_COMPUTE_OPTIONAL_CASE_SELECTION_LABEL", this.mExpressionTextArea.getText());
        dialogDataModel.putString("IDS_TC_TOP_TEXTAREA_VALUE", this.mExpressionTextArea.getText());
        this.mFunctionListControls.saveFunctionState(dialogDataModel);
        return true;
    }

    private void initVars() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(0);
        vector.add(1);
        vector.add(15);
        this.mSupportedFunctions = this.getSupportedFunctions();
        FunctionList.getInstance();
        FunctionList.reset();
        this.mFunctionListControls = new FunctionListControls(true, true, vector, this.mSupportedFunctions);
        this.mMultiDimInfoLabel = new FocusableTextArea(this.getResString("IDS_TCM_FUNCTION_MULTI_DIM_INFO_TEXT"), null);
        this.mSrcVarListLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_TCM_FUNCTION_FIELD_LIST_LABEL");
        this.mSrcVarList = new TCMSrcVariableList(VariableList.VarMoveType.eMoveOriginal, this.mTCMForecastGatingInfo, true, false);
        this.mSrcVarList.setIdentifier("SourceListIdentifier");
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eDoNothing);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mFunctionListControls.setSrcList(this.mSrcVarList);
        this.mSrcVarListLabel.setLabelFor(this.mSrcVarList);
        this.mExpressionArrowButton = new ExpressionAreaArrowButton();
        this.mFunctionListArrowButton = this.mFunctionListControls.getFunctionArrow();
        this.mExpressionTextAreaLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_TCM_FUNCTION_EXPRESSIONS_AREA_LABEL");
        this.mExpressionTextArea = new ExpressionBuilderTextArea();
        this.mExpressionTextArea.setLineWrap(true);
        this.mExpressionTextArea.setWrapStyleWord(true);
        this.mExpressionTextAreaLabel.setLabelFor((Component)((Object)this.mExpressionTextArea));
        this.mExpressionTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (TCMEquationSubDlg.this.mExpressionTextArea.getText().contains("?")) {
                    TCMEquationSubDlg.this.enableContinue(false);
                } else {
                    TCMEquationSubDlg.this.enableContinue(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (TCMEquationSubDlg.this.mExpressionTextArea.getText().equals("")) {
                    TCMEquationSubDlg.this.enableContinue(false);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.mExpressionTextAreaScrollPane = new JScrollPane((Component)((Object)this.mExpressionTextArea));
        this.mExpressionTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.mCalcPanel = new CalcWidget((JTextArea)((Object)this.mExpressionTextArea));
        this.mFunctionListControls.setExpressionArea((JTextArea)((Object)this.mExpressionTextArea));
        this.mDescriptionTextArea = this.mFunctionListControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.mDescriptionTextArea.setOpaque(false);
        this.mDescriptionTextArea.setEnabled(false);
        this.mDescriptionTextAreaScrollPane = new JScrollPane(this.mDescriptionTextArea);
        this.mDescriptionTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionGrpList = this.mFunctionListControls.getFunctionGroupList();
        this.mFunctionGrpList.setSelectionMode(0);
        this.mFunctionGrpListScrollPane = new JScrollPane(this.mFunctionGrpList);
        this.mFunctionGrpListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionGrpListScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        this.mFunctionListControls.setFunctionGroupIdentifier("TCM function groups");
        this.mFunctionSpecialVarsList = this.mFunctionListControls.getFunctionList();
        this.mFunctionSpecialVarsList.setSelectionMode(0);
        this.mFunctionSpecialVarsListScrollPane = new JScrollPane(this.mFunctionSpecialVarsList);
        this.mFunctionSpecialVarsListScrollPane.setVerticalScrollBarPolicy(20);
        this.mFunctionSpecialVarsListScrollPane.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        this.mFunctionListControls.setFunctionListIdentifier("TCM functions");
        this.mFunctionGrpLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_TCM_FUNCTION_GROUP_LABEL");
        this.mFunctionGrpLabel.setLabelFor(this.mFunctionGrpList);
        this.mFunctionSpecialVarsLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_TCM_FUNCTIONS_LABEL");
        this.mFunctionSpecialVarsLabel.setLabelFor(this.mFunctionSpecialVarsList);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mExpressionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy));
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        this.mExpressionArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mExpressionArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
    }

    private Vector<String> getSupportedFunctions() {
        Vector<String> vector = new Vector<String>();
        vector.add("Abs");
        vector.add("Exp");
        vector.add("Lg10");
        vector.add("Ln");
        vector.add("Max");
        vector.add("Min");
        vector.add("Mod");
        vector.add("Rnd(1)");
        vector.add("Rnd(2)");
        vector.add("Rnd(3)");
        vector.add("Sqrt");
        vector.add("Trunc(1)");
        vector.add("Trunc(2)");
        vector.add("Trunc(3)");
        return vector;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.enableComponents(true);
    }

    private void setupViewPanel(JPanel jPanel) {
        JPanel jPanel2 = TCMUtilities.createInfoPanel(this.mMultiDimInfoLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = 0;
        if (this.mTCMForecastGatingInfo.isMultiDimensionalData()) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, n2, 1, 1, n, null);
            ++n2;
        }
        JPanel jPanel3 = this.createMainPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, n2, 1, 7, n, null);
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcVarListLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 7, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mExpressionTextAreaLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mExpressionTextArea));
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 3, 2, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mExpressionArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets3 = new Insets(n2 * 2, insets2.left, 0, n2 * 3);
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDescriptionTextAreaScrollPane, gridBagConstraints, 1, 7, 3, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, gridBagConstraints, 2, 4, 1, 3, n, DialogUtil.getStandardControlInsets());
        insets3.set(n2 * 2, insets2.left, 0, n2 * 3);
        gridBagConstraints.fill = 0;
        n = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionListArrowButton, gridBagConstraints, 3, 5, 1, 2, n, insets3);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGrpLabel, gridBagConstraints, 4, 3, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionGrpListScrollPane, gridBagConstraints, 4, 4, 1, 1, n, null);
        insets3.set(n2, 0, 0, 0);
        n = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionSpecialVarsLabel, gridBagConstraints, 4, 5, 1, 1, n, insets3);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionSpecialVarsListScrollPane, gridBagConstraints, 4, 6, 1, 2, n, null);
        return jPanel;
    }

    private void enableComponents(boolean bl) {
        this.mSrcVarList.setEnabled(bl);
        this.mExpressionArrowButton.setEnabled(bl);
        this.mFunctionListArrowButton.setEnabled(bl && this.mFunctionListControls.getFunctionList().getSelectedIndex() > -1);
        this.setComponentEnableState(this.mCalcPanel, bl);
        this.mExpressionTextArea.setEnabled(bl);
        this.mExpressionTextArea.setOpaque(bl);
        this.mFunctionGrpList.setEnabled(bl);
        this.mFunctionSpecialVarsList.setEnabled(bl);
        this.mFunctionGrpLabel.setEnabled(bl);
        this.mFunctionSpecialVarsLabel.setEnabled(bl);
        this.mExpressionTextAreaScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mExpressionTextAreaScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mExpressionTextAreaScrollPane.setWheelScrollingEnabled(bl);
        this.mDescriptionTextAreaScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mDescriptionTextAreaScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mDescriptionTextAreaScrollPane.setWheelScrollingEnabled(bl);
        this.mDescriptionTextAreaScrollPane.setOpaque(bl);
        this.mDescriptionTextArea.setEnabled(bl);
        if (this.mExpressionTextArea.getText().equals("")) {
            this.enableContinue(false);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mExpressionArrowButton);
        vector.add((Object)this.mExpressionTextArea);
        vector.add(this.mCalcPanel.getDefaultFocusButton());
        vector.add(this.mFunctionGrpList);
        vector.add(this.mFunctionSpecialVarsList);
        vector.add(this.mFunctionListArrowButton);
        vector.add(this.mDescriptionTextArea);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

