/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.MC.ModelPMMLFileHandler;
import com.spss.java_client.ui.dialogs.TCM.TemporalCausalModeling;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class ModelTab
extends BaseProcedureTab
implements ActionListener,
ItemListener {
    private JLabel mModelFileLabel;
    private FileTextField mModelFilePath;
    private JButton mBrowseButton;
    private JRadioButton mLoadFromModelRadio;
    private JRadioButton mReestimateRadio;
    private SpssButtonGroup mDataRadioGroup;
    private SrcVariableList mSrcVarList;
    private JLabel mSourceListLabel;
    private TargetVariableList mTargetVarList;
    private JLabel mTargetListLabel;
    private ArrowButton mArrowButton;

    public ModelTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBrowseButton) {
            String[] stringArray = this.getResStringArray("IDS_TCM_MODEL_TAB_XML_FILE_FILTER_ARRY");
            String[] stringArray2 = this.getResStringArray("IDS_TCM_MODEL_TAB_XML_FILE_EXT_ARRY");
            String[] stringArray3 = TemporalCausalModeling.showOpenFileDialog(this.mParent, this.getResString("IDS_TCM_MODEL_TAB_LOAD_MODEL_LABEL"), stringArray, stringArray2);
            if (stringArray3 != null && stringArray3.length == 2) {
                this.mModelFilePath.setText(stringArray3[0]);
                this.parsingModelXML(stringArray3[0]);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        DialogUtil.addUsingGBL(jPanel, this.mModelFileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 0.2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mModelFilePath), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        insets.set(n2 * 6, n2 * 2, n2 * 2, n2 * 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getBasicPanel(new JComponent[]{this.mLoadFromModelRadio, this.mReestimateRadio}, PanelFactory.PanelType.xaxis, this.getResString("IDS_TCM_MODEL_TAB_MODEL_PARAMETER_TITLE"));
        insets.set(n2 * 2, n2 * 2, n2 * 2, n2 * 10);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 * 4, n2 * 2, n2, n2 * 10);
        DialogUtil.addUsingGBL(this, this.setupLists(), gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    private void setDefaults() {
        this.mLoadFromModelRadio.setSelected(true);
    }

    private JPanel setupLists() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSourceListLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTargetListLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 7 + 2));
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mModelFileLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_MODEL_TAB_MODEL_FILE_LABEL");
        this.mModelFilePath = new FileTextField(true);
        this.mModelFilePath.setEditable(true);
        this.mModelFilePath.setColumns(20);
        this.mModelFilePath.setAction(new TextFieldAction(this.mParent, "TCM_NEW_MODEL_PMML_FILE_PATH"));
        this.mModelFileLabel.setLabelFor((Component)((Object)this.mModelFilePath));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_TCM_MODEL_TAB_MODEL_FILE_BOTTON");
        this.mBrowseButton = new JButton(toggleButtonAction);
        this.mBrowseButton.addActionListener(this);
        this.mLoadFromModelRadio = DialogUtil.createRadioButton(this.mParent, "IDS_TCM_MODEL_TAB_LOAD_FROM_MODEL_RADIO", null);
        this.mLoadFromModelRadio.addItemListener(this);
        this.mReestimateRadio = DialogUtil.createRadioButton(this.mParent, "IDS_TCM_MODEL_TAB_REESTIMATE_RADIO", null);
        this.mReestimateRadio.addItemListener(this);
        this.mDataRadioGroup = new SpssButtonGroup();
        this.mDataRadioGroup.add(this.mLoadFromModelRadio);
        this.mDataRadioGroup.add(this.mReestimateRadio);
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSourceListLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_MODEL_TAB_SRC_LIST");
        this.mSourceListLabel.setLabelFor(this.mSrcVarList);
        this.mTargetListLabel = DialogUtil.createLabel(this.mParent, "IDS_TCM_MODEL_TAB_ANALYZE_LIST");
        this.mTargetVarList = new TargetVariableList();
        this.mTargetListLabel.setLabelFor(this.mTargetVarList);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setSelectionMode(0);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void parsingModelXML(String string) {
        ModelPMMLFileHandler modelPMMLFileHandler = new ModelPMMLFileHandler(string);
        ArrayList<String> arrayList = modelPMMLFileHandler.getInputFieldNames();
        ArrayList<String> arrayList2 = modelPMMLFileHandler.getTargetFieldNames();
        VarListModel varListModel = this.mSrcVarList.getModel();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SpssVariable spssVariable = new SpssVariable();
            spssVariable.setName(arrayList2.get(i));
            varListModel.addElement((ISpssVariable)spssVariable);
        }
    }
}

