/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ModelOptionTab
extends BaseProcedureTab
implements ItemListener,
ActionListener,
DocumentListener {
    private static String DASET_SET_NAME = "IDS_MI_IMPUTE_MISSING_DATASET_NAME_KEY";
    private static String NEW_FILE_NAME = "IDS_MI_IMPUTE_MISSING_NEW_FILE_NAME_KEY";
    private JCheckBox mImputationModelCheck;
    private JCheckBox mDescriptiveCheck;
    private JCheckBox mCreateIterationHistoryCheck;
    private SpssButtonGroup mExportDistanceRadioGrp;
    private JRadioButton mCreateDatasetRadio;
    private JRadioButton mWriteDataFileRadio;
    private JLabel mDatasetNameLabel;
    private FileTextField mNewDataFilePath;
    private StringTextField mDatasetNameValue;
    private JButton mDataFileButton;
    private String mPerAttributesSyntax = "";

    public ModelOptionTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initialize();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        if (this.mCreateIterationHistoryCheck.isEnabled() && this.mCreateIterationHistoryCheck.isSelected()) {
            this.mCreateDatasetRadio.setEnabled(true);
            this.mWriteDataFileRadio.setEnabled(true);
        } else {
            this.mCreateDatasetRadio.setEnabled(false);
            this.mWriteDataFileRadio.setEnabled(false);
            this.mDatasetNameValue.setEnabled(false);
            this.mDatasetNameLabel.setEnabled(false);
            this.mNewDataFilePath.setEnabled(false);
            this.mDataFileButton.setEnabled(false);
        }
        if (this.mCreateDatasetRadio.isEnabled() && this.mCreateDatasetRadio.isSelected()) {
            this.mDatasetNameValue.setEnabled(true);
            this.mDatasetNameLabel.setEnabled(true);
            this.mNewDataFilePath.setEnabled(false);
            this.mDataFileButton.setEnabled(false);
        }
        if (this.mWriteDataFileRadio.isEnabled() && this.mWriteDataFileRadio.isSelected()) {
            this.mNewDataFilePath.setEnabled(true);
            this.mDataFileButton.setEnabled(true);
            this.mDatasetNameValue.setEnabled(false);
            this.mDatasetNameLabel.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (itemEvent.getSource() == this.mCreateIterationHistoryCheck) {
            if (n == 1) {
                this.mCreateDatasetRadio.setEnabled(true);
                if (this.mCreateDatasetRadio.isSelected()) {
                    this.mDatasetNameValue.setEnabled(true);
                    this.mDatasetNameLabel.setEnabled(true);
                }
                this.mWriteDataFileRadio.setEnabled(true);
                if (this.mWriteDataFileRadio.isSelected()) {
                    this.mNewDataFilePath.setEnabled(true);
                    this.mDataFileButton.setEnabled(true);
                }
            } else {
                this.mCreateDatasetRadio.setEnabled(false);
                this.mDatasetNameValue.setEnabled(false);
                this.mDatasetNameLabel.setEnabled(false);
                this.mWriteDataFileRadio.setEnabled(false);
                this.mNewDataFilePath.setEnabled(false);
                this.mDataFileButton.setEnabled(false);
            }
        }
        if (itemEvent.getSource() == this.mCreateDatasetRadio) {
            this.mDatasetNameValue.setEnabled(true);
            this.mDatasetNameLabel.setEnabled(true);
            this.mNewDataFilePath.setEnabled(false);
            this.mDataFileButton.setEnabled(false);
        }
        if (itemEvent.getSource() == this.mWriteDataFileRadio) {
            this.mNewDataFilePath.setEnabled(true);
            this.mDataFileButton.setEnabled(true);
            this.mDatasetNameValue.setEnabled(false);
            this.mDatasetNameLabel.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_IDD_MI_OUTPUT";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public String getOutputTabSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n  /MISSINGSUMMARIES NONE ");
        stringBuffer.append("\n  /IMPUTATIONSUMMARIES ");
        Boolean bl = dialogDataModel.getBoolean("IDS_MI_IMPUTE_MISSING_OUTOUT_MODEL_CHECK");
        boolean bl2 = true;
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("MODELS ");
            bl2 = false;
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MI_IMPUTE_MISSING_OUTOUT_DESCRIPTIVE_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append("DESCRIPTIVES ");
            bl2 = false;
        }
        if (bl2) {
            stringBuffer.append("NONE ");
        }
        return stringBuffer.toString();
    }

    public String getPESSyntax() {
        return this.mPerAttributesSyntax;
    }

    StringTextField getDatasetField() {
        return this.mDatasetNameValue;
    }

    JButton getBrowseButton() {
        return this.mDataFileButton;
    }

    String getHistoryFilePath() {
        if (this.mDataFileButton.isEnabled()) {
            return this.mNewDataFilePath.getText();
        }
        return "";
    }

    public String getDataSetCommand(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer("");
        Boolean bl = dialogDataModel.getBoolean("IDS_MI_IMPUTE_MISSING_OUTOUT_CREATE_CHECK");
        return stringBuffer.toString();
    }

    @Override
    protected boolean validateTab() {
        return this.doValidation();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mImputationModelCheck;
    }

    private void initialize() {
        this.initVars();
        super.initPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        JComponent[] jComponentArray = new JComponent[]{this.mImputationModelCheck, this.mDescriptiveCheck};
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, new JPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mImputationModelCheck);
        vector.add(this.mDescriptiveCheck);
        vector.add(this.mCreateIterationHistoryCheck);
        vector.add(this.mCreateDatasetRadio);
        vector.add(this.mDatasetNameValue);
        vector.add(this.mWriteDataFileRadio);
        vector.add(this.mDataFileButton);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        this.mImputationModelCheck.setSelected(true);
        this.mCreateIterationHistoryCheck.setSelected(false);
        this.mDescriptiveCheck.setSelected(false);
        this.mCreateDatasetRadio.setSelected(true);
        this.mCreateDatasetRadio.setEnabled(false);
        this.mWriteDataFileRadio.setEnabled(false);
        this.mDatasetNameValue.setEnabled(false);
        this.mDatasetNameValue.setText("");
        this.mDatasetNameLabel.setEnabled(false);
        this.mNewDataFilePath.setEnabled(false);
        this.mNewDataFilePath.setText("");
    }

    private void initVars() {
        this.mImputationModelCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MI_IMPUTE_MISSING_OUTOUT_MODEL_CHECK", null);
        this.mImputationModelCheck.addItemListener(this);
        this.mDescriptiveCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MI_IMPUTE_MISSING_OUTOUT_DESCRIPTIVE_CHECK", null);
        this.mDescriptiveCheck.addItemListener(this);
        this.mCreateIterationHistoryCheck = DialogUtil.createCheckBox(this.mParent, "IDS_MI_IMPUTE_MISSING_OUTOUT_CREATE_CHECK", null);
        this.mCreateIterationHistoryCheck.addItemListener(this);
        this.mCreateDatasetRadio = DialogUtil.createRadioButton(this.mParent, "IDS_MI_IMPUTE_MISSING_OUTPUT_TAB_NEW_DATASET_LABEL", null);
        this.mCreateDatasetRadio.addItemListener(this);
        this.mWriteDataFileRadio = DialogUtil.createRadioButton(this.mParent, "IDS_MI_IMPUTE_MISSING_OUTPUT_TAB_DATAFILE_LABEL", null);
        this.mWriteDataFileRadio.addItemListener(this);
        this.mExportDistanceRadioGrp = new SpssButtonGroup();
        this.mExportDistanceRadioGrp.add(this.mCreateDatasetRadio);
        this.mExportDistanceRadioGrp.add(this.mWriteDataFileRadio);
        this.mDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_MI_IMPUTE_MISSING_OUTPUT_TAB_NEW_DATASET_NAME_LABEL");
        this.mDatasetNameValue = new StringTextField();
        this.mDatasetNameValue.setColumns(30);
        this.mDatasetNameValue.setAction(new TextFieldAction(this.mParent, DASET_SET_NAME));
        this.mDatasetNameValue.getDocument().addDocumentListener(this);
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDatasetNameValue));
        this.mNewDataFilePath = new FileTextField();
        this.mNewDataFilePath.setEditable(false);
        this.mNewDataFilePath.setOpaque(false);
        this.mNewDataFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mNewDataFilePath.setAction(new TextFieldAction(this.mParent, NEW_FILE_NAME));
        this.mDataFileButton = DialogUtil.createButton(this.mParent, "IDS_MI_IMPUTE_MISSING_OUTPUT_TAB_DATAFILE_BUTTON", null);
        this.mDataFileButton.setEnabled(true);
        this.mDataFileButton.addActionListener(this);
    }

    private JPanel setupIterationHistroyPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_MI_IMPUTE_MISSING_OUTOUT_HISTORY_PANEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n - 2, n, n, n);
        int n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mCreateIterationHistoryCheck, gridBagConstraints, 0, 0, 3, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mCreateDatasetRadio, gridBagConstraints, 0, 1, 3, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 8, 0, -n * 3);
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n, -n * 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDatasetNameValue), gridBagConstraints, 1, 2, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n * 3, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mWriteDataFileRadio, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mDataFileButton, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n + 3, n, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNewDataFilePath), gridBagConstraints, 2, 3, 1, 1, n2, insets);
        return jPanel;
    }

    private boolean doValidation() {
        try {
            if (this.mCreateIterationHistoryCheck.isEnabled() && this.mCreateIterationHistoryCheck.isSelected()) {
                boolean bl = true;
                if (this.mWriteDataFileRadio.isSelected() && this.mNewDataFilePath.getText().length() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_MI_IMPUTE_MISSING_NO_FILE_WARNING1"), VersionInfo.getAppVersionString());
                    this.mDataFileButton.requestFocusInWindow();
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

