/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.TCM;

import com.pasw.core.property.PropertyDescriptor;
import com.pasw.core.property.descriptor.DefaultStructure;
import com.pasw.core.property.descriptor.DefaultStructureDefinition;
import com.pasw.core.property.descriptor.IntegerProperty;
import com.pasw.core.property.descriptor.StringProperty;
import com.pasw.framework.common.core.Structure;
import com.pasw.framework.common.core.StructureDefinition;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.cache.IDataCache;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.data.define_dates.DateType;
import com.spss.java_client.ui.dialogs.base.data.define_dates.DateVariable;
import com.spss.java_client.ui.dialogs.base.data.res.DataResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class DateVarUtil {
    public static final String CYCLIC_LEVEL = "level";
    public static final String CYCLIC_FIELDNAME = "fieldName";
    public static final String CYCLIC_FIELDLENGTH = "cyclicLength";
    public static final String CYCLIC_FIELDSTARTVALUE = "cyclicStartingValue";
    private ResourceBundle mResBundle;
    private Map<String, DateType> mDateMap;
    private String[] mDateVarNames;
    private DateVariable[] mDateVars;
    private ArrayList<Structure> mEstimFields = new ArrayList();
    static DefaultStructureDefinition fieldDefine = new DefaultStructureDefinition("field");

    public DateVarUtil() {
        this.mResBundle = ResUtil.getBundle(DataResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.initDateMap();
        this.mDateVarNames = null;
        this.mDateVars = null;
    }

    private void initDateMap() {
        this.mDateMap = new HashMap<String, DateType>();
        boolean bl = false;
        String string = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_YEARS");
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_YEARS_QUARTERS");
        String string3 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_YEARS_MONTH");
        String string4 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_YEARS_QUARTERS_MONTHS");
        String string5 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_DAYS");
        String string6 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_WEEKS_DAYS");
        String string7 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_WEEKS_WORKDAYS_5");
        String string8 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_WEEKS_WORKDAYS_6");
        String string9 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_HOURS");
        String string10 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_DAYS_HOURS");
        String string11 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_DAYS_WORKHOURS_8");
        String string12 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_WEEK_DAYS_HOURS");
        String string13 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_WEEK_WORKDAYS_HOURS");
        String string14 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_MINUTES");
        String string15 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_HOURS_MINUTES");
        String string16 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_DAYS_HOURS_MINUTES");
        String string17 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_SECONDS");
        String string18 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_MINUTES_SECONDS");
        String string19 = UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)"IDS_HOURS_MINUTES_SECONDS");
        DateType dateType = new DateType(new DateVariable[]{new YearDateVariable(0)});
        this.mDateMap.put(string, dateType);
        dateType = new DateType(new DateVariable[]{new YearDateVariable(0), new QuarterDateVariable(4)});
        this.mDateMap.put(string2, dateType);
        dateType = new DateType(new DateVariable[]{new YearDateVariable(0), new MonthDateVariable(12)});
        this.mDateMap.put(string3, dateType);
        dateType = new DateType(new DateVariable[]{new YearDateVariable(0), new QuarterDateVariable(4), new MonthDateVariable(12)});
        this.mDateMap.put(string4, dateType);
        dateType = new DateType(new DateVariable[]{new DayDateVariable(0)});
        this.mDateMap.put(string5, dateType);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(7)});
        this.mDateMap.put(string6, dateType);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(5)});
        this.mDateMap.put(string7, dateType);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(6)});
        this.mDateMap.put(string8, dateType);
        dateType = new DateType(new DateVariable[]{new HourDateVariable(0)});
        this.mDateMap.put(string9, dateType);
        dateType = new DateType(new DateVariable[]{new DayDateVariable(0), new HourDateVariable(24)});
        this.mDateMap.put(string10, dateType);
        dateType = new DateType(new DateVariable[]{new DayDateVariable(0), new HourDateVariable(8)});
        this.mDateMap.put(string11, dateType);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(7), new HourDateVariable(24)});
        this.mDateMap.put(string12, dateType);
        dateType = new DateType(new DateVariable[]{new WeekDateVariable(0), new DayDateVariable(5), new HourDateVariable(8)});
        this.mDateMap.put(string13, dateType);
        dateType = new DateType(new DateVariable[]{new MinuteDateVariable(0)});
        this.mDateMap.put(string14, dateType);
        dateType = new DateType(new DateVariable[]{new HourDateVariable(0), new MinuteDateVariable(60)});
        this.mDateMap.put(string15, dateType);
        dateType = new DateType(new DateVariable[]{new DayDateVariable(0), new HourDateVariable(24), new MinuteDateVariable(60)});
        this.mDateMap.put(string16, dateType);
        dateType = new DateType(new DateVariable[]{new SecondDateVariable(0)});
        this.mDateMap.put(string17, dateType);
        dateType = new DateType(new DateVariable[]{new MinuteDateVariable(0), new SecondDateVariable(60)});
        this.mDateMap.put(string18, dateType);
        dateType = new DateType(new DateVariable[]{new HourDateVariable(0), new MinuteDateVariable(60), new SecondDateVariable(60)});
        this.mDateMap.put(string19, dateType);
    }

    private ISpssDataSrc getDataSource() {
        LocallyUniqueId locallyUniqueId = null;
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    public ITrendsInfo getTrendsInfo() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        ITrendsInfo iTrendsInfo = iSpssDataSrc.getTrendsInfo();
        return iTrendsInfo;
    }

    public String getDateSpecInfo() {
        String string = this.getSelectionFromTrendsInfo();
        if (string == null || string != null && string.length() == 0) {
            return this.handleTrendInfo(this.getTrendsInfo());
        }
        String[] stringArray = this.getDateVarNames(string);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = this.getDateFieldValues(stringArray);
        DateType dateType = this.mDateMap.get(string);
        DateVariable[] dateVariableArray = dateType.getVariables();
        boolean bl = false;
        if (dateVariableArray[0] instanceof YearDateVariable) {
            bl = true;
        }
        this.mDateVarNames = stringArray;
        this.handleDateVarNames(bl);
        return this.getDateSpecString(string, stringArray2);
    }

    public String[] getDateVarNames() {
        if (this.mDateVarNames == null) {
            String string = this.getSelectionFromTrendsInfo();
            if (string == null || string != null && string.length() == 0) {
                return null;
            }
            this.mDateVarNames = this.getDateVarNames(string);
            DateType dateType = this.mDateMap.get(string);
            DateVariable[] dateVariableArray = dateType.getVariables();
            boolean bl = false;
            if (dateVariableArray[0] instanceof YearDateVariable) {
                bl = true;
            }
            this.handleDateVarNames(bl);
        }
        return this.mDateVarNames;
    }

    public ArrayList<Structure> getDateVarNameAndPeriod() {
        this.mEstimFields.clear();
        String string = this.getSelectionFromTrendsInfo();
        if (string == null || string != null && string.length() == 0) {
            if (this.mDateVars == null) {
                this.handleTrendInfo(this.getTrendsInfo());
            }
            this.handleDateVarNameAndPeriod();
        } else {
            this.handleDateVarNameAndPeriod(string);
        }
        return this.mEstimFields;
    }

    private void handleDateVarNames(boolean bl) {
        String[] stringArray = this.mDateVarNames;
        for (int i = 0; i < this.mDateVarNames.length; ++i) {
            if (stringArray[i].charAt(stringArray[i].length() - 1) != '_') continue;
            this.mDateVarNames[i] = stringArray[i].substring(0, stringArray[i].length() - 1);
        }
        if (bl && this.mDateVarNames.length > 2) {
            stringArray = this.mDateVarNames;
            this.mDateVarNames = new String[2];
            this.mDateVarNames[0] = stringArray[0];
            this.mDateVarNames[1] = stringArray[stringArray.length - 1];
        }
    }

    private void handleCycleVar() {
        int n;
        String[] stringArray = this.mDateVarNames;
        boolean bl = false;
        for (n = 0; n < this.mDateVarNames.length; ++n) {
            if (n <= 0 || !stringArray[n].equals("QUARTER_") && !stringArray[n].equals("QUARTER")) continue;
            stringArray[n] = "";
            bl = true;
        }
        if (bl) {
            this.mDateVarNames = new String[stringArray.length - 1];
            n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("")) continue;
                this.mDateVarNames[n++] = stringArray[i];
            }
        }
    }

    private String getSelectionFromTrendsInfo() {
        ITrendsInfo iTrendsInfo = this.getTrendsInfo();
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        int n = iTrendsInfo.getNDateVars();
        if (n == 0) {
            return null;
        }
        Set<String> set = this.mDateMap.keySet();
        for (String string : set) {
            int n2;
            DateVariable[] dateVariableArray;
            DateType dateType = this.mDateMap.get(string);
            if (dateType == null || (dateVariableArray = dateType.getVariables()).length != n) continue;
            for (n2 = 0; n2 < dateVariableArray.length && (iTrendsInfo.getDateVarString(n2) + "_").equals(dateVariableArray[n2].getVariableName()) && iTrendsInfo.getDateVarPeriodicity(n2) == dateVariableArray[n2].getPeriodicity() && iSpssDataSrc.findVarIndex(dateVariableArray[n2].getVariableName()) >= 0; ++n2) {
            }
            if (n2 != n) continue;
            return string;
        }
        return null;
    }

    private String handleTrendInfo(ITrendsInfo iTrendsInfo) {
        int n = iTrendsInfo.getNDateVars();
        if (n == 0) {
            return null;
        }
        this.mDateVars = new DateVariable[n];
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            DateVariable dateVariable = null;
            int n2 = iTrendsInfo.getDateVarType(i).value();
            int n3 = iTrendsInfo.getDateVarPeriodicity(i);
            String string = iTrendsInfo.getDateVarString(i);
            if (string.equals("OBSERVATION")) {
                string = "OBS";
            }
            stringArray[i] = string + "_";
            switch (n2) {
                case 1: {
                    dateVariable = new CycleDateVariable(n3);
                    break;
                }
                case 2: {
                    dateVariable = new YearDateVariable(n3);
                    break;
                }
                case 3: {
                    dateVariable = new QuarterDateVariable(n3);
                    break;
                }
                case 4: {
                    dateVariable = new MonthDateVariable(n3);
                    break;
                }
                case 5: {
                    dateVariable = new WeekDateVariable(n3);
                    break;
                }
                case 6: {
                    dateVariable = new DayDateVariable(n3);
                    break;
                }
                case 7: {
                    dateVariable = new HourDateVariable(n3);
                    break;
                }
                case 8: {
                    dateVariable = new MinuteDateVariable(n3);
                    break;
                }
                case 9: {
                    dateVariable = new SecondDateVariable(n3);
                    break;
                }
                case 10: {
                    dateVariable = new OBSDateVariable(n3);
                    break;
                }
            }
            if (dateVariable == null) continue;
            this.mDateVars[i] = dateVariable;
        }
        String[] stringArray2 = this.getDateFieldValues(stringArray);
        boolean bl = false;
        if (this.mDateVars[0] instanceof YearDateVariable) {
            bl = true;
        }
        this.mDateVarNames = stringArray;
        this.handleDateVarNames(bl);
        if (this.mDateVars[0] instanceof CycleDateVariable) {
            this.handleCycleVar();
        }
        return this.getDateSpecString(this.mDateVars, stringArray2);
    }

    private String[] getDateVarNames(String string) {
        DateType dateType = this.mDateMap.get(string);
        DateVariable[] dateVariableArray = dateType.getVariables();
        String[] stringArray = new String[dateVariableArray.length];
        for (int i = 0; i < dateVariableArray.length; ++i) {
            stringArray[i] = dateVariableArray[i].getVariableName();
        }
        return stringArray;
    }

    private void handleDateVarNameAndPeriod(String string) {
        DateType dateType = this.mDateMap.get(string);
        this.mDateVars = dateType.getVariables();
        this.handleDateVarNameAndPeriod();
    }

    private void handleDateVarNameAndPeriod() {
        int n;
        if (this.mDateVars == null) {
            return;
        }
        Vector vector = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Structure> arrayList = new ArrayList<Structure>();
        for (n = 0; n < this.mDateVars.length; ++n) {
            if (n == 0) {
                if (this.mDateVars[n] instanceof YearDateVariable) {
                    bl = true;
                } else if (this.mDateVars[n] instanceof CycleDateVariable) {
                    bl2 = true;
                }
            }
            if (n == 1 && bl && this.mDateVars.length == 3 && this.mDateVars[n] instanceof QuarterDateVariable && this.mDateVars[n + 1] instanceof MonthDateVariable || bl2 && this.mDateVars[n] instanceof QuarterDateVariable) continue;
            arrayList.add(this.createStructForField(this.mDateVars[n]));
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            this.mEstimFields.add((Structure)arrayList.get(n));
        }
    }

    private String[] getDateFieldValues(String[] stringArray) {
        ITrendsInfo iTrendsInfo = this.getTrendsInfo();
        ISpssDataSrc iSpssDataSrc = null;
        iSpssDataSrc = this.getDataSource();
        IDataCache iDataCache = iSpssDataSrc.getCacheMgr();
        int n = iTrendsInfo.getNDateVars();
        String[] stringArray2 = new String[stringArray.length];
        if (n != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = iSpssDataSrc.findVarIndex(stringArray[i]);
                if (n2 == -1) {
                    stringArray2[i] = "";
                    continue;
                }
                OBS oBS = iDataCache.getCellValue(0L, n2);
                if (oBS == null || oBS.isEmpty()) continue;
                int n3 = (int)iDataCache.getCellValue(0L, n2).getNum();
                stringArray2[i] = Integer.toString(n3);
            }
        }
        return stringArray2;
    }

    private String getDateSpecString(String string, String[] stringArray) {
        String string2 = "";
        ITrendsInfo iTrendsInfo = this.getTrendsInfo();
        DateType dateType = this.mDateMap.get(string);
        DateVariable[] dateVariableArray = dateType.getVariables();
        for (int i = 0; i < dateVariableArray.length; ++i) {
            if (i == 0) {
                string2 = string2 + dateVariableArray[i].getUserName();
                string2 = string2 + "(";
                string2 = stringArray[i].equals("") ? string2 + "?" : string2 + stringArray[i];
                string2 = string2 + ")";
                continue;
            }
            string2 = string2 + dateVariableArray[i].getUserName();
            string2 = string2 + "(";
            string2 = stringArray[i].equals("") ? string2 + "?" : string2 + stringArray[i];
            string2 = string2 + ";";
            string2 = string2 + dateVariableArray[i].getPeriodicity();
            string2 = string2 + ")";
        }
        return string2;
    }

    private String getDateSpecString(DateVariable[] dateVariableArray, String[] stringArray) {
        String string = "";
        for (int i = 0; i < dateVariableArray.length; ++i) {
            if (i == 0) {
                string = string + dateVariableArray[i].getUserName();
                string = string + "(";
                string = stringArray[i].equals("") ? string + "?" : string + stringArray[i];
                string = string + ")";
                continue;
            }
            string = string + dateVariableArray[i].getUserName();
            string = string + "(";
            string = stringArray[i].equals("") ? string + "?" : string + stringArray[i];
            string = string + ";";
            string = string + dateVariableArray[i].getPeriodicity();
            string = string + ")";
        }
        return string;
    }

    private Structure createStructForField(DateVariable dateVariable) {
        Object[] objectArray = new Object[]{new String("1"), new String(dateVariable.getVariableName()), new String("" + dateVariable.getPeriodicity()), new String(dateVariable.getDefaultValue())};
        DefaultStructure defaultStructure = new DefaultStructure((StructureDefinition)fieldDefine, objectArray);
        return defaultStructure;
    }

    static {
        fieldDefine.addAttribute((PropertyDescriptor)new StringProperty(CYCLIC_LEVEL));
        fieldDefine.addAttribute((PropertyDescriptor)new StringProperty(CYCLIC_FIELDNAME));
        fieldDefine.addAttribute((PropertyDescriptor)new IntegerProperty(CYCLIC_FIELDLENGTH));
        fieldDefine.addAttribute((PropertyDescriptor)new IntegerProperty(CYCLIC_FIELDSTARTVALUE));
    }

    private class SecondDateVariable
    extends DateVariable {
        public SecondDateVariable(int n) {
            super(UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_SECOND_LABEL"), UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_SECOND"), "0", "SECOND_", n);
        }
    }

    private class MinuteDateVariable
    extends DateVariable {
        public MinuteDateVariable(int n) {
            super(UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_MINUTE_LABEL"), UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_MINUTE"), "0", "MINUTE_", n);
        }
    }

    private class HourDateVariable
    extends DateVariable {
        public HourDateVariable(int n) {
            super(UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_HOUR_LABEL"), UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_HOUR"), "0", "HOUR_", n);
        }
    }

    private class DayDateVariable
    extends DateVariable {
        public DayDateVariable(int n) {
            super(UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_DAY_LABEL"), UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_DAY"), "1", "DAY_", n);
        }
    }

    private class WeekDateVariable
    extends DateVariable {
        public WeekDateVariable(int n) {
            super(UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_WEEK_LABEL"), UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_WEEK"), "1", "WEEK_", n);
        }
    }

    private class MonthDateVariable
    extends DateVariable {
        public MonthDateVariable(int n) {
            super(UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_MONTH_LABEL"), UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_MONTH"), "1", "MONTH_", n);
        }
    }

    private class QuarterDateVariable
    extends DateVariable {
        public QuarterDateVariable(int n) {
            super(UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_QUARTER_LABEL"), UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_QUARTER"), "1", "QUARTER_", n);
        }
    }

    private class YearDateVariable
    extends DateVariable {
        public YearDateVariable(int n) {
            super(UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_YEAR_LABEL"), UIToolResUtil.getString((ResourceBundle)DateVarUtil.this.mResBundle, (String)"IDS_YEAR"), "1900", "YEAR_", n);
        }
    }

    private class OBSDateVariable
    extends DateVariable {
        public OBSDateVariable(int n) {
            super("Observation", "Observation", "1", "OBS_", n);
        }
    }

    private class CycleDateVariable
    extends DateVariable {
        public CycleDateVariable(int n) {
            super("Cycle", "Cycle", "1", "CYCLE_", n);
        }
    }
}

