/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.dialogs.STEM.ComboBoxEditor;
import com.spss.java_client.ui.dialogs.STEM.ComboBoxRender;
import com.spss.java_client.ui.dialogs.STEM.ContextDataItem;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;

public class ValidateKeysSubDlg
extends BaseDialog {
    private static final int LIST_WIDTH = 160;
    private static final int LIST_HEIGHT = 80;
    static final String STEM_DATA_KEY_LIST = "IDS_STEM_DATA_KEY_LIST";
    static final String STEM_MAP_KEY_LIST = "IDS_STEM_MAP_KEY_LIST";
    static final String STEM_VALIDATE_LIST = "IDS_STEM_VALIDATE_LIST";
    protected ContinueAction mContinueAction;
    private JLabel mDataKeyLabel;
    private SerializableList mDataKeyList;
    private JScrollPane mDataKeyListScroll;
    private JLabel mMapKeyLabel;
    private SerializableList mMapKeyList;
    private JScrollPane mMapKeyListScroll;
    private JLabel mValidateLabel;
    private String mNumDataKeyStr;
    private String mNumMapKeyStr;
    private SerializableList mValidateResult;
    private JScrollPane mValidateResultScroll;
    private JLabel mRecordTableLabel;
    private JTable mRecordTable;
    private DefaultTableModel mRecordTableModel;
    private String mDataSource;
    private String mMapSource;
    private String mKeyName;
    private String mNumKeys;
    private String mUnmatch;
    private String mMatch;
    private int mNumMatched;
    private String mDataFileName;
    private String mDataKeyNames;
    private Vector<Vector<String>> mUnMatchedDataKeys;
    private String mMapFileName;
    private String mMapKeyNames;
    private Vector<Vector<String>> mUnMatchedMapKeys;
    private ContextDataItem mDatasourceItem;
    private boolean mContinuePressed;

    public ValidateKeysSubDlg(BaseWizardDialog baseWizardDialog, ContextDataItem contextDataItem, int n, String string, String string2, String string3, String string4) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STEM_VALIDATE_KEYS_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.mDatasourceItem = contextDataItem;
        this.mNumMatched = n;
        this.mDataFileName = string;
        this.mDataKeyNames = string2;
        this.mUnMatchedDataKeys = contextDataItem.getUnMatchedDataValues();
        this.mMapFileName = string3;
        this.mMapKeyNames = string4;
        this.mUnMatchedMapKeys = contextDataItem.getUnMatchedMapValues();
        this.mContinuePressed = false;
        this.fillList();
        this.initializePanel();
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_validate");
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setDefault();
    }

    private void initializePanel() {
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    private void fillList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(this.mDataSource + this.mDataFileName);
        defaultListModel.addElement(this.mKeyName + this.mDataKeyNames);
        int n = this.mUnMatchedDataKeys.size() + this.mNumMatched;
        defaultListModel.addElement(this.mNumKeys + n);
        this.mDataKeyList.setModel(defaultListModel);
        DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
        defaultListModel2.addElement(this.mMapSource + this.mMapFileName);
        defaultListModel2.addElement(this.mKeyName + this.mMapKeyNames);
        n = this.mUnMatchedMapKeys.size() + this.mNumMatched;
        defaultListModel2.addElement(this.mNumKeys + n);
        this.mMapKeyList.setModel(defaultListModel2);
        DefaultListModel<String> defaultListModel3 = new DefaultListModel<String>();
        defaultListModel3.addElement(this.mMatch + this.mNumMatched);
        defaultListModel3.addElement("");
        defaultListModel3.addElement(this.mUnmatch);
        defaultListModel3.addElement("  " + this.mNumDataKeyStr + this.mUnMatchedDataKeys.size());
        defaultListModel3.addElement("  " + this.mNumMapKeyStr + this.mUnMatchedMapKeys.size());
        this.mValidateResult.setModel(defaultListModel3);
        this.mRecordTableModel.setRowCount(0);
        int n2 = this.mUnMatchedDataKeys.size();
        if (n2 > 100) {
            n2 = 100;
        }
        int n3 = 0;
        String[] stringArray = new String[this.mUnMatchedMapKeys.size()];
        for (n3 = 0; n3 < this.mUnMatchedMapKeys.size(); ++n3) {
            stringArray[n3] = this.getConcatValue(this.mUnMatchedMapKeys.get(n3));
        }
        ComboBoxEditor comboBoxEditor = new ComboBoxEditor(stringArray);
        this.mRecordTable.getColumnModel().getColumn(1).setCellEditor(comboBoxEditor);
        this.mRecordTable.getColumnModel().getColumn(1).setCellRenderer(new ComboBoxRender(stringArray));
        for (n3 = 0; n3 < n2; ++n3) {
            Vector<String> vector = new Vector<String>();
            vector.add(this.getConcatValue(this.mUnMatchedDataKeys.get(n3)));
            if (n3 < stringArray.length) {
                vector.add(stringArray[n3]);
            } else {
                vector.add("");
            }
            this.mRecordTableModel.addRow(vector);
        }
        this.mRecordTable.setModel(this.mRecordTableModel);
    }

    String getConcatValue(Vector<String> vector) {
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + vector.get(i);
            if (i == vector.size() - 1) continue;
            string = string + "/";
        }
        return string;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        JButton jButton = new JButton(this.mContinueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mDataKeyLabel = DialogUtil.createLabel(this, "IDS_STEM_VALIDATE_KEYS_SUB_DATA_LABEL");
        this.mDataKeyList = new SerializableList(STEM_DATA_KEY_LIST);
        this.mDataKeyListScroll = new JScrollPane(this.mDataKeyList);
        this.mDataKeyListScroll.setPreferredSize(new Dimension(160, 80));
        this.mDataKeyLabel.setLabelFor(this.mDataKeyList);
        this.mMapKeyLabel = DialogUtil.createLabel(this, "IDS_STEM_VALIDATE_KEYS_SUB_MAP_LABEL");
        this.mMapKeyList = new SerializableList(STEM_MAP_KEY_LIST);
        this.mMapKeyListScroll = new JScrollPane(this.mMapKeyList);
        this.mMapKeyListScroll.setPreferredSize(new Dimension(160, 80));
        this.mMapKeyLabel.setLabelFor(this.mMapKeyList);
        this.mValidateLabel = DialogUtil.createLabel(this, "IDS_STEM_VALIDATE_KEYS_SUB_RESULT");
        this.mValidateResult = new SerializableList(STEM_VALIDATE_LIST);
        this.mValidateResultScroll = new JScrollPane(this.mValidateResult);
        this.mValidateResultScroll.setPreferredSize(new Dimension(160, 80));
        this.mValidateLabel.setLabelFor(this.mValidateResult);
        this.mNumDataKeyStr = this.getResString("IDS_STEM_VALIDATE_KEYS_NUM_DATA_KEYS");
        this.mNumMapKeyStr = this.getResString("IDS_STEM_VALIDATE_KEYS_NUM_MAP_KEYS");
        this.mRecordTableLabel = DialogUtil.createLabel(this, "IDS_STEM_VALIDATE_KEYS_SUB_RECORD_TABLE");
        Object[] objectArray = this.getResStringArray("IDS_STEM_VALIDATE_KEYS_SUB_RECORD_TABLE_HEADER");
        this.mRecordTableModel = new DefaultTableModel(objectArray, 1){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mRecordTable = new PlainTable();
        this.mRecordTable.setModel(this.mRecordTableModel);
        this.mRecordTable.setRowHeight(22);
        this.mRecordTable.setColumnSelectionAllowed(false);
        this.mRecordTable.setRowSelectionAllowed(true);
        this.mRecordTable.setSelectionMode(0);
        this.mRecordTable.getTableHeader().setReorderingAllowed(false);
        this.mRecordTable.getTableHeader().setResizingAllowed(true);
        this.mRecordTable.setGridColor(Color.darkGray);
        this.mRecordTable.getTableHeader().setReorderingAllowed(false);
        this.mRecordTable.setSelectionMode(0);
        this.mRecordTableLabel.setLabelFor(this.mRecordTable);
        this.mDataSource = this.getResString("IDS_STEM_VALIDATE_KEYS_SUB_DATA_SOURCE_LABEL");
        this.mMapSource = this.getResString("IDS_STEM_VALIDATE_KEYS_SUB_MAP_SOURCE_LABEL");
        this.mKeyName = this.getResString("IDS_STEM_VALIDATE_KEYS_SUB_KEY_NAME_LABEL");
        this.mNumKeys = this.getResString("IDS_STEM_VALIDATE_KEYS_SUB_NUM_KEYS_LABEL");
        this.mUnmatch = this.getResString("IDS_STEM_VALIDATE_KEYS_SUB_UN_MATCH_LABEL");
        this.mMatch = this.getResString("IDS_STEM_VALIDATE_KEYS_SUB_MATCH_LABEL");
    }

    private void setDefault() {
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, 2, n2 * 2);
        insets.set(n2, n2, 2, n2 * 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDataKeyLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(2, n2, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mDataKeyListScroll, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, 2, n2 * 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMapKeyLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(2, n2, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mMapKeyListScroll, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets.set(n2, n2, 2, n2 * 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mValidateLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        insets.set(2, n2, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mValidateResultScroll, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets.set(n2, n2, 2, n2 * 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRecordTableLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mRecordTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(240, 200));
        jScrollPane.setPreferredSize(new Dimension(240, 200));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, n2, n2, n2 * 2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 5, n, insets);
    }

    public boolean continuePressed() {
        return this.mContinuePressed;
    }

    private void setSelectedMatchedKeys() {
        Vector<Pair<Vector<String>, Vector<String>>> vector = new Vector<Pair<Vector<String>, Vector<String>>>();
        for (int i = 0; i < this.mRecordTable.getRowCount(); ++i) {
            Object object = this.mRecordTable.getValueAt(i, 0);
            Object object2 = this.mRecordTable.getValueAt(i, 1);
            if (object2 == null || object2.toString().length() <= 0) continue;
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            if (object2.toString().indexOf("/") > 0) {
                this.getValues(object.toString(), vector2);
                this.getValues(object2.toString(), vector3);
            } else {
                vector2.add(object.toString());
                vector3.add(object2.toString());
            }
            vector.add((Pair<Vector<String>, Vector<String>>)new Pair(vector2, vector3));
        }
        this.mDatasourceItem.setMatchedDataMapValues(vector);
    }

    private void getValues(String string, Vector<String> vector) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValidateKeysSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValidateKeysSubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValidateKeysSubDlg.this.mContinuePressed = true;
            ValidateKeysSubDlg.this.setSelectedMatchedKeys();
            ValidateKeysSubDlg.this.dispose();
        }
    }
}

