/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class SelectProjectionSubDlg
extends BaseDialog {
    protected JButton mContinueButton;
    protected ContinueAction mContinueAction;
    private FocusableTextArea mInfo;
    private FocusableTextArea mRadioGroupInfo;
    private JRadioButton mCityMercedorRadio;
    private JRadioButton mWinkelRadio;
    private JRadioButton mEquatorMercedorRadio;
    private JRadioButton mStereoRadio;
    private SpssButtonGroup mButtonGroup;
    private boolean mIsContinuePressed;

    public SelectProjectionSubDlg(BaseWizardDialog baseWizardDialog) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STEM_SELECT_PROJECTION_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.initializePanel();
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_set_projection");
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setDefault();
    }

    private void initializePanel() {
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    public boolean continuePressed() {
        return this.mIsContinuePressed;
    }

    public int getSelctedProjection(String[] stringArray) {
        if (this.mCityMercedorRadio.isSelected()) {
            stringArray[0] = "MERCATOR";
            return 3857;
        }
        if (this.mWinkelRadio.isSelected()) {
            stringArray[0] = "WINKELTRIPEL";
            return 4326;
        }
        if (this.mEquatorMercedorRadio.isSelected()) {
            stringArray[0] = "MERCATOR";
            return 3857;
        }
        if (this.mStereoRadio.isSelected()) {
            stringArray[0] = "STEREOGRAPHIC";
            return 4326;
        }
        return -1;
    }

    String getSelectedProjection() {
        if (this.mCityMercedorRadio.isSelected() || this.mEquatorMercedorRadio.isSelected()) {
            return "WGS1984";
        }
        if (this.mWinkelRadio.isSelected()) {
            return "WGS1984";
        }
        if (this.mStereoRadio.isSelected()) {
            return "WGS1984";
        }
        return "";
    }

    String getSelectedDisplayProjection() {
        if (this.mCityMercedorRadio.isSelected() || this.mEquatorMercedorRadio.isSelected()) {
            return "MERCATOR";
        }
        if (this.mWinkelRadio.isSelected()) {
            return "WINKELTRIPEL";
        }
        if (this.mStereoRadio.isSelected()) {
            return "STEREOGRAPHIC";
        }
        return "";
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        this.mContinueButton = new JButton(this.mContinueAction);
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mContinueButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mContinueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mInfo = new FocusableTextArea(this.getResString("IDS_STEM_SELECT_PROJECTION_SUB_INFO"), null);
        this.mRadioGroupInfo = new FocusableTextArea(this.getResString("IDS_STEM_SELECT_PROJECTION_SUB_RADIO_GROUP_LABEL"), null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_SELECT_PROJECTION_SUB_STEREO");
        this.mStereoRadio = new JRadioButton(toggleButtonAction);
        int n = this.mStereoRadio.getPreferredSize().width;
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_SELECT_PROJECTION_SUB_MERCATOR");
        this.mCityMercedorRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_SELECT_PROJECTION_SUB_WINKEL");
        this.mWinkelRadio = new SpssMultiLineRadioButton(toggleButtonAction, n);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_SELECT_PROJECTION_SUB_EQUATOR_MERCATOR");
        this.mEquatorMercedorRadio = new JRadioButton(toggleButtonAction);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mCityMercedorRadio);
        this.mButtonGroup.add(this.mWinkelRadio);
        this.mButtonGroup.add(this.mEquatorMercedorRadio);
        this.mButtonGroup.add(this.mStereoRadio);
    }

    private void setDefault() {
        this.mCityMercedorRadio.setSelected(true);
        this.mIsContinuePressed = false;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, n2, 2);
        this.mInfo.setRows(3);
        DialogUtil.addUsingGBL(jPanel, this.mInfo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mInfo.setMinimumSize(new Dimension(300, 80));
        this.mInfo.setPreferredSize(new Dimension(300, 80));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2, 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mCityMercedorRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mWinkelRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 4, n2);
        DialogUtil.addUsingGBL(jPanel, this.mEquatorMercedorRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 8, n2);
        DialogUtil.addUsingGBL(jPanel, this.mStereoRadio, gridBagConstraints, 0, 5, 1, 1, n, insets);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfo);
        vector.add(this.mCityMercedorRadio);
        vector.add(this.mWinkelRadio);
        vector.add(this.mEquatorMercedorRadio);
        vector.add(this.mStereoRadio);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private boolean doValidation() {
        boolean bl = true;
        return bl;
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectProjectionSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectProjectionSubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SelectProjectionSubDlg.this.doValidation()) {
                SelectProjectionSubDlg.this.mIsContinuePressed = true;
                SelectProjectionSubDlg.this.dispose();
            }
        }
    }
}

