/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectMapSubDlg
extends BaseDialog
implements ListSelectionListener {
    private static final int LIST_WIDTH = 280;
    private static final int LIST_HEIGHT = 80;
    static final String STP_MAP_ID_LIST_SPEC = "STP_MAP_ID_LIST_SPEC";
    protected ContinueAction mContinueAction;
    private FocusableTextArea mSelectMapInfo;
    private JLabel mMapListLabel;
    private SerializableList mMapIdList;
    private JScrollPane mMapIdListScroll;
    private boolean mIsContinuePressed;
    private Vector<String> mMapIds;

    public SelectMapSubDlg(BaseWizardDialog baseWizardDialog, Vector<String> vector) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STP_SELECT_MAP_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.mMapIds = vector;
        this.updateOpenDataSetList();
        this.mIsContinuePressed = false;
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_stp_select_map");
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setContinueEnabled();
    }

    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.setDefault();
        this.pack();
    }

    private void setDefault() {
        this.enableControls();
    }

    private void updateOpenDataSetList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : this.mMapIds) {
            defaultListModel.addElement(string);
        }
        this.mMapIdList.setModel(defaultListModel);
        this.mMapIdList.setSelectedIndex(0);
    }

    private void enableControls() {
        this.setContinueEnabled();
    }

    private void setContinueEnabled() {
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 2, 2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, this.mSelectMapInfo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2 * 2, 2, 0, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMapListLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, 2, n2 * 3, n2 * 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mMapIdListScroll, gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMapIdList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        JButton jButton = new JButton(this.mContinueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    int getSelectedMapIndex() {
        return this.mMapIdList.getSelectedIndex();
    }

    public boolean continuePressed() {
        return this.mIsContinuePressed;
    }

    private void initVars() {
        this.mSelectMapInfo = new FocusableTextArea(this.getResString("IDS_STP_SELECT_MAP_SUB_HELP_INFO"), null);
        this.mSelectMapInfo.setRows(3);
        this.mMapListLabel = DialogUtil.createLabel(this, "IDS_STP_SELECT_MAP_LIST_LABEL");
        this.mMapIdList = new SerializableList(STP_MAP_ID_LIST_SPEC);
        this.mMapIdListScroll = new JScrollPane(this.mMapIdList);
        this.mMapIdListScroll.setPreferredSize(new Dimension(280, 80));
        this.mMapIdList.addListSelectionListener(this);
        this.mMapListLabel.setLabelFor(this.mMapIdList);
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectMapSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectMapSubDlg.this.mIsContinuePressed = false;
            SelectMapSubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectMapSubDlg.this.mIsContinuePressed = true;
            SelectMapSubDlg.this.dispose();
        }
    }
}

