/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.STEM.CoordinateSystemUtil;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.STEM.SelectProjectionSubDlg;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SelectCoordinateSubDlg
extends BaseDialog
implements ItemListener,
DocumentListener {
    private BaseWizardDialog mSTEMWizardDlg;
    protected JButton mContinueButton;
    protected ContinueAction mContinueAction;
    private FocusableTextArea mInfo;
    private FocusableTextArea mRadioGroupInfo;
    private JRadioButton mDefaultGeoRadio;
    private JRadioButton mSimpleCartesianRadio;
    private JRadioButton mKnownIDRadio;
    private JLabel mWKIDFieldLabel;
    private IntTextField mWKIDField;
    private JRadioButton mKnownCSNameRadio;
    private JLabel mCSNameLabel;
    private StringTextField mCSNameField;
    private SpssButtonGroup mButtonGroup;
    private boolean mIsContinuePressed;
    private String mDisplayPojection;
    private String mProjection;
    private int mWkid;
    private boolean mEnableCartesian;
    private int mSelectedFromSetProj;

    public SelectCoordinateSubDlg(BaseWizardDialog baseWizardDialog) {
        this(baseWizardDialog, true);
    }

    public SelectCoordinateSubDlg(BaseWizardDialog baseWizardDialog, boolean bl) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STEM_SELECT_COORDINATE_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.mSTEMWizardDlg = baseWizardDialog;
        this.mDisplayPojection = "SIMPLE";
        this.mWkid = -1;
        this.mEnableCartesian = bl;
        this.mSelectedFromSetProj = -1;
        this.initializePanel();
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_stem_coordinates");
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    protected void init() {
        super.init();
    }

    private void initializePanel() {
        this.initVars();
        this.setDefault();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    public boolean continuePressed() {
        return this.mIsContinuePressed;
    }

    public int getSelectedRadioIndex() {
        if (this.mDefaultGeoRadio.isSelected()) {
            return 0;
        }
        if (this.mSimpleCartesianRadio.isSelected()) {
            return 1;
        }
        if (this.mKnownIDRadio.isSelected()) {
            return 2;
        }
        return 3;
    }

    int getSelectionFromSetProject() {
        if (this.mDefaultGeoRadio.isSelected()) {
            return this.mSelectedFromSetProj;
        }
        return -1;
    }

    String getCSName() {
        if (this.mKnownCSNameRadio.isSelected()) {
            return this.mCSNameField.getText();
        }
        return "";
    }

    String getWKID() {
        if (this.mKnownIDRadio.isSelected()) {
            return this.mWKIDField.getText();
        }
        return "";
    }

    String getSelectedProjection() {
        return this.mProjection;
    }

    public int getSelctedDisplayProjection(String[] stringArray) {
        if (this.mDefaultGeoRadio.isSelected()) {
            stringArray[0] = this.mDisplayPojection;
            return this.mWkid;
        }
        if (this.mSimpleCartesianRadio.isSelected()) {
            stringArray[0] = "SIMPLE";
            return this.mWkid;
        }
        if (this.mKnownIDRadio.isSelected()) {
            stringArray[0] = this.mDisplayPojection;
            return Integer.parseInt(this.mWKIDField.getText());
        }
        if (this.mKnownCSNameRadio.isSelected()) {
            stringArray[0] = this.mDisplayPojection;
            CoordinateSystemUtil.CoordinateSystem coordinateSystem = CoordinateSystemUtil.getInstance().lookupByName(this.mCSNameField.getText());
            return coordinateSystem.getWKID();
        }
        return -1;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        this.mContinueButton = new JButton(this.mContinueAction);
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mContinueButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mContinueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mInfo = new FocusableTextArea(this.getResString("IDS_STEM_SELECT_COORDINATE_SUB_INFO"), null);
        this.mRadioGroupInfo = new FocusableTextArea(this.getResString("IDS_STEM_SELECT_COORDINATE_SUB_RADIO_GROUP_LABEL"), null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_SELECT_COORDINATE_SUB_DEFAULT_GEO");
        this.mDefaultGeoRadio = new JRadioButton(toggleButtonAction);
        this.mDefaultGeoRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_SELECT_COORDINATE_SUB_SIMEPLE_CARTESIAN");
        this.mSimpleCartesianRadio = new JRadioButton(toggleButtonAction);
        this.mSimpleCartesianRadio.addItemListener(this);
        this.mSimpleCartesianRadio.setEnabled(this.mEnableCartesian);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_SELECT_COORDINATE_SUB_KNOWN_ID");
        this.mKnownIDRadio = new JRadioButton(toggleButtonAction);
        this.mKnownIDRadio.addItemListener(this);
        this.mWKIDFieldLabel = DialogUtil.createLabel(this, "IDS_STEM_SELECT_COORDINATE_SUB_KNOWN_ID_FIELD");
        this.mWKIDField = new IntTextField(true);
        this.mWKIDField.setColumns(20);
        this.mWKIDField.getDocument().addDocumentListener(this);
        this.mWKIDFieldLabel.setLabelFor((Component)this.mWKIDField);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STEM_SELECT_COORDINATE_SUB_COORDINATE");
        this.mKnownCSNameRadio = new JRadioButton(toggleButtonAction);
        this.mKnownCSNameRadio.addItemListener(this);
        this.mCSNameLabel = DialogUtil.createLabel(this, "IDS_STEM_SELECT_COORDINATE_SUB_CS_NAME_FIELD");
        this.mCSNameField = new StringTextField(20);
        this.mCSNameField.getDocument().addDocumentListener(this);
        this.mCSNameLabel.setLabelFor((Component)((Object)this.mCSNameField));
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mDefaultGeoRadio);
        this.mButtonGroup.add(this.mSimpleCartesianRadio);
        this.mButtonGroup.add(this.mKnownIDRadio);
        this.mButtonGroup.add(this.mKnownCSNameRadio);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JRadioButton) {
            if (this.mKnownCSNameRadio.isSelected()) {
                this.mCSNameField.setEnabled(true);
                this.mCSNameLabel.setEnabled(true);
            } else {
                this.mCSNameField.setEnabled(false);
                this.mCSNameLabel.setEnabled(false);
            }
            if (this.mKnownIDRadio.isSelected()) {
                this.mWKIDFieldLabel.setEnabled(true);
                this.mWKIDField.setEnabled(true);
            } else {
                this.mWKIDFieldLabel.setEnabled(false);
                this.mWKIDField.setEnabled(false);
            }
            this.enableContinueButton();
        }
    }

    private void runSetProjectionSub() {
        SelectProjectionSubDlg selectProjectionSubDlg = new SelectProjectionSubDlg((STEMWizardDlg)((Object)this.getParent()));
        selectProjectionSubDlg.setVisible(true);
        if (selectProjectionSubDlg.continuePressed()) {
            String[] stringArray = new String[1];
            this.mWkid = selectProjectionSubDlg.getSelctedProjection(stringArray);
            this.mDisplayPojection = selectProjectionSubDlg.getSelectedDisplayProjection();
            this.mProjection = selectProjectionSubDlg.getSelectedProjection();
            this.mIsContinuePressed = true;
        } else {
            this.mIsContinuePressed = false;
        }
    }

    private void enableContinueButton() {
        boolean bl = false;
        bl = this.mKnownCSNameRadio.isSelected() ? this.mCSNameField.getText().length() > 0 : (this.mKnownIDRadio.isSelected() ? this.mWKIDField.getText().length() > 0 : true);
        this.mContinueButton.setEnabled(bl);
    }

    private void setDefault() {
        this.mDefaultGeoRadio.setSelected(true);
        this.mIsContinuePressed = false;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, n2, 2);
        this.mInfo.setRows(3);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = fontMetrics.charWidth('_');
        int n4 = fontMetrics.getHeight();
        DialogUtil.addUsingGBL(jPanel, this.mInfo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mInfo.setMinimumSize(new Dimension(300, 80));
        this.mInfo.setPreferredSize(new Dimension(300, 80));
        DialogUtil.addUsingGBL(jPanel, this.mRadioGroupInfo, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mDefaultGeoRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 4, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSimpleCartesianRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 1, n2);
        DialogUtil.addUsingGBL(jPanel, this.mKnownIDRadio, gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, n2 * 4, 4, n2);
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mWKIDFieldLabel, this.mWKIDField}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 1, n2);
        DialogUtil.addUsingGBL(jPanel, this.mKnownCSNameRadio, gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(1, n2 * 4, n2 * 3, n2);
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mCSNameLabel, this.mCSNameField}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 8, 1, 1, n, insets);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfo);
        vector.add(this.mRadioGroupInfo);
        vector.add(this.mDefaultGeoRadio);
        vector.add(this.mSimpleCartesianRadio);
        vector.add(this.mKnownIDRadio);
        vector.add(this.mWKIDField);
        vector.add(this.mKnownCSNameRadio);
        vector.add(this.mCSNameField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private boolean doValidation() {
        boolean bl = true;
        if (this.mKnownIDRadio.isSelected()) {
            int n = Integer.parseInt(this.mWKIDField.getText());
            if (CoordinateSystemUtil.getInstance().lookupByWKID(n) == null) {
                String string = String.format(this.getResString("IDS_STEM_SELECT_COORDINATE_SUB_WRONG_WKID_MESG"), this.mWKIDField.getText());
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                this.mWKIDField.requestFocusInWindow();
                bl = false;
            }
        } else if (this.mKnownCSNameRadio.isSelected()) {
            String string = this.mCSNameField.getText();
            if (CoordinateSystemUtil.getInstance().lookupByName(string) == null) {
                String string2 = String.format(this.getResString("IDS_STEM_SELECT_COORDINATE_SUB_WRONG_CSNAME_MESG"), string);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
                this.mCSNameField.requestFocusInWindow();
                bl = false;
            }
        }
        return bl;
    }

    private boolean needToDisplaySetProjectionSub() {
        boolean bl;
        boolean bl2 = false;
        if (this.mEnableCartesian && (bl = ((STEMWizardDlg)this.mSTEMWizardDlg).getGeoRelationPage().hasMap())) {
            return bl2;
        }
        CoordinateSystemUtil.CoordinateSystemType coordinateSystemType = CoordinateSystemUtil.CoordinateSystemType.PROJECTED;
        String string = "";
        if (this.mDefaultGeoRadio.isSelected()) {
            bl2 = true;
        } else if (this.mKnownIDRadio.isSelected()) {
            int n = Integer.parseInt(this.mWKIDField.getText());
            coordinateSystemType = CoordinateSystemUtil.getInstance().lookupByWKID(n).getType();
        } else if (this.mKnownCSNameRadio.isSelected()) {
            coordinateSystemType = CoordinateSystemUtil.getInstance().lookupByName(this.mCSNameField.getText()).getType();
        }
        if (!bl2 && coordinateSystemType == CoordinateSystemUtil.CoordinateSystemType.GEOGRAPHIC) {
            bl2 = true;
        }
        return bl2;
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectCoordinateSubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectCoordinateSubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = SelectCoordinateSubDlg.this.doValidation();
            if (bl) {
                if (SelectCoordinateSubDlg.this.needToDisplaySetProjectionSub()) {
                    SelectCoordinateSubDlg.this.runSetProjectionSub();
                } else {
                    SelectCoordinateSubDlg.this.mIsContinuePressed = true;
                }
                SelectCoordinateSubDlg.this.dispose();
            }
        }
    }
}

