/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.STEM.CellComboBoxEditor;
import com.spss.java_client.ui.dialogs.STEM.ComboBoxEditor;
import com.spss.java_client.ui.dialogs.STEM.ContextDataItem;
import com.spss.java_client.ui.dialogs.STEM.MultiFieldChooserSubDlg;
import com.spss.java_client.ui.dialogs.STEM.STEMUtil;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.STEM.STPDefineRolePage;
import com.spss.java_client.ui.dialogs.STEM.StepSevenSidebarSelectorPanel;
import com.spss.java_client.ui.dialogs.STEM.UnEditableCellTextRenderer;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.direct_marketing.AbstractDialogStateWizardPage;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class STPSettingsPage
extends AbstractDialogStateWizardPage
implements ItemListener,
ActionListener,
DocumentListener,
ListSelectionListener {
    public static final String NEW_PMML_FILE_NAME = "IDS_NEW_PMML_FILE_NAME";
    public static final String NEW_MAP_FILE_NAME = "IDS_NEW_MAP_FILE_NAME";
    public static final String NEW_RULE_NAME_PREFIX = "IDS_NEW_RULE_NAME_PREFIX";
    static final String sDefaultSpecName = "*\\mapspec.mplan";
    static final String sNewScoreFile = "_Scored";
    static Hashtable<String, Integer> sTimeIntervalMap = new Hashtable();
    private static final int sComboWidth = 120;
    private boolean mIsTimeStamp;
    private StepSevenSidebarSelectorPanel mParamAndOptionPanel;
    private JPanel mOutputPanel;
    private JPanel mTimeIntervalPanel;
    private JPanel mAggregationPanel;
    private JPanel mModelOptionPanel;
    private JPanel mAdvancedPanel;
    private JPanel mSavePanel;
    private FocusableLabel mOutputSetting;
    private JCheckBox mOutTargetCheck;
    private JCheckBox mOutCorreCheck;
    private JCheckBox mOutClusterCheck;
    private JLabel mLocationSpinLabel;
    private NumberSpinner mLocationSpinner;
    private JLabel mMaxClusterSpinLabel;
    private NumberSpinner mMaxClusterSpinner;
    private JCheckBox mOutModelSpecCheck;
    private JCheckBox mOutTimeInfoSummaryCheck;
    private JCheckBox mOutLocationSummaryCheck;
    private JCheckBox mOutModelQualityCheck;
    private JCheckBox mOutTestEffectCheck;
    private JCheckBox mOutMeanStrucCheck;
    private JCheckBox mOutAutoregresCheck;
    private JCheckBox mOutTestSpatialCheck;
    private JCheckBox mOutSpatialParamCheck;
    private FocusableLabel mSaveSetting;
    private JCheckBox mSaveMapCheck;
    private FileTextField mMapFileField;
    private JLabel mMapFileLabel;
    private JButton mMapFileButton;
    private JCheckBox mCopyMapCheck;
    private JRadioButton mNoScoring;
    private JRadioButton mScoreOpenSet;
    private JRadioButton mScoreSPSSData;
    private SpssButtonGroup mScoringGrop;
    private SerializableList mScoreOpenSetNameList;
    private Vector<ContextDataItem> mOpenDataset;
    private JButton mBrowseSPSSDataButton;
    private JLabel mScoreSPSSDataLabel;
    private FileTextField mScoreSPSSDataFileField;
    private ContextDataItem mSelectedFile;
    private JButton mBrowseNewScoredButton;
    private JLabel mNewScoreSPSSDataLabel;
    private FileTextField mNewScoreSPSSDataFileField;
    private JLabel mTimeFieldTableLabel;
    private JTable mTimeFieldTable;
    private DefaultTableModel mTimeFieldTableModel;
    private String[] mIntervalValues;
    private JLabel mTimeIntervalComboLabel;
    private JComboBox mTimeIntervalCombo;
    private JLabel mTimeStartSpinLabel;
    private NumberSpinner mTimeStartSpinner;
    private JLabel mTimeIncreSpinLabel;
    private NumberSpinner mTimeIncreSpinner;
    private JLabel mNumDaysSpinLabel;
    private NumberSpinner mNumDaysSpinner;
    private JLabel mWeekBeginComboLabel;
    private JComboBox mWeekBeginCombo;
    private JLabel mNumHourSpinLabel;
    private NumberSpinner mNumHourSpinner;
    private JLabel mDayBeginSpinLabel;
    private NumberSpinner mDayBeginSpinner;
    private FocusableTextArea mTimeCyclicInfo;
    private JLabel mFirstCycleTableLabel;
    private JTable mFirstCycleTable;
    private DefaultTableModel mFirstCycleTableModel;
    private CellComboBoxEditor mFirstCycleTableCellEditor;
    private JLabel mFirstCycleLengthLabel;
    private NumberSpinner mFirstCycleLength;
    private JLabel mCyclicIncreSpinLabel;
    private NumberSpinner mCyclicIncreSpinner;
    private JLabel mSecondCycleTableLabel;
    private JTable mSecondCycleTable;
    private DefaultTableModel mSecondCycleTableModel;
    private CellComboBoxEditor mSecondCycleTableCellEditor;
    private JLabel mSecondCycleLengthLabel;
    private NumberSpinner mSecondCycleLength;
    private JLabel mSecondStartSpinLabel;
    private NumberSpinner mSecondStartSpinner;
    private JLabel mThirdCycleTableLabel;
    private JTable mThirdCycleTable;
    private DefaultTableModel mThirdCycleTableModel;
    private CellComboBoxEditor mThirdCycleTableCellEditor;
    private JLabel mThirdStartSpinLabel;
    private NumberSpinner mThirdStartSpinner;
    private Vector<STPDefineRolePage.STPDataListContainer> mAllSources;
    private FocusableLabel mTimeAggregFun;
    private JLabel mTimeContComboLabel;
    private JComboBox mTimeContCombo;
    private String[] mContAggreArray;
    private String[] mNormAggreArray;
    private JLabel mTimeOrdinalLabel;
    private JComboBox mTimeOrdinalCombo;
    private String[] mOrdinalAggreArray;
    private JLabel mFieldAndFunctionTableLabel;
    private JTable mFieldAndFunctionTable;
    private DefaultTableModel mFieldAndFunctionTableModel;
    private JButton mFieldSelectButton;
    private JButton mDeleteButton;
    private Vector<ISpssVariable> mContextSourceVars;
    private Vector<ISpssVariable> mVarInAggreTable;
    private CellComboBoxEditor mFieldFunTableCellEditor;
    private FocusableLabel mModelOpSetting;
    private JCheckBox mModelAutoCheck;
    private JLabel mModelMaxLagSpinLabel;
    private NumberSpinner mModelMaxLagSpinner;
    private JLabel mModelConfSpinLabel;
    private NumberSpinner mModelConfSpinner;
    private FocusableLabel mModelSpatialSetting;
    private JRadioButton mParametricRadio;
    private JRadioButton mNonParamRadio;
    private SpssButtonGroup mSpatialRadioGroup;
    private JLabel mParamModelComboLabel;
    private JComboBox mParamModelCombo;
    private JLabel mPowerSpinLabel;
    private NumberSpinner mPowerSpinner;
    private FocusableLabel mAdvancedSetting;
    private JLabel mAdvMaxMissLabel;
    private NumberSpinner mAdvMaxMissSpinner;
    private JLabel mAdvSigLevelLabel;
    private NumberSpinner mAdvSigLevelSpinner;
    private FocusableTextArea mScoringInfo;
    private JLabel mScoringFactorLabel;
    private NumberSpinner mScoringFactorSpinner;
    private DialogFocusTraversalPolicy mTimePanelPolicy;
    private DialogFocusTraversalPolicy mOutputPolicy;
    private DialogFocusTraversalPolicy mAggrePolicy;
    private DialogFocusTraversalPolicy mModelPolicy;
    private DialogFocusTraversalPolicy mAdvancePolicy;
    private DialogFocusTraversalPolicy mSavePolicy;
    private boolean mToNextPage;
    private boolean mKeepSettings;

    public STPSettingsPage(BaseWizardDialog baseWizardDialog) {
        super("STPSettingsPage", baseWizardDialog.getResString("IDS_STEM_STEP_ONE_TITLE"), baseWizardDialog, true);
        STPSettingsPage.createTimeIntervalValueMap();
        this.mToNextPage = true;
        this.mKeepSettings = false;
    }

    @Override
    public String getNextPage() {
        if (this.validate() && this.mToNextPage) {
            return "STEMFinishPage";
        }
        return null;
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    void setKeepSettings(boolean bl) {
        this.mKeepSettings = bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mNonParamRadio || object == this.mParametricRadio) {
            this.enableSpatialCovarPanel();
        } else if (object == this.mNoScoring || object == this.mScoreOpenSet || object == this.mScoreSPSSData) {
            this.enableScoringPanelControls();
            boolean bl = this.enableNextButton();
            this.mWizardDialog.enableNext(bl);
            this.mWizardDialog.enableFinish(bl);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl = this.enableNextButton();
        this.mWizardDialog.enableNext(bl);
        this.mWizardDialog.enableFinish(bl);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        boolean bl = this.enableNextButton();
        this.mWizardDialog.enableNext(bl);
        this.mWizardDialog.enableFinish(bl);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        boolean bl = this.enableNextButton();
        this.mWizardDialog.enableNext(bl);
        this.mWizardDialog.enableFinish(bl);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.enableNextButton();
        this.mWizardDialog.enableNext(bl);
        this.mWizardDialog.enableFinish(bl);
    }

    @Override
    protected void loadDialogState() {
    }

    @Override
    protected void saveDialogState() {
    }

    @Override
    public boolean validate() {
        boolean bl = this.validateTimeInterval();
        if (bl) {
            bl = this.validateOutput();
        }
        if (bl) {
            bl = this.validateSavePanel();
        }
        if (bl) {
            bl = this.validateModelOption();
        }
        if (bl) {
            bl = this.validateAdvancedPanel();
        }
        return bl && super.validate();
    }

    private boolean validateTimeInterval() {
        boolean bl = true;
        if (this.mTimeStartSpinner == null || this.mTimeIncreSpinner == null || this.mNumDaysSpinner == null || this.mNumHourSpinner == null || this.mDayBeginSpinner == null || this.mSecondCycleLength == null || this.mSecondStartSpinner == null || this.mThirdStartSpinner == null || this.mFirstCycleLength == null || this.mCyclicIncreSpinner == null) {
            return bl;
        }
        if (this.mIsTimeStamp) {
            if (!STEMUtil.validateIntSpinner(this.mTimeStartSpinner, -1000, 1000)) {
                return false;
            }
            if (!STEMUtil.validateIntSpinner(this.mTimeIncreSpinner, 1, 100)) {
                return false;
            }
            if (!STEMUtil.validateIntSpinner(this.mNumDaysSpinner, 1, 7)) {
                return false;
            }
            if (!STEMUtil.validateIntSpinner(this.mNumHourSpinner, 1, 24)) {
                return false;
            }
            if (!STEMUtil.validateIntSpinner(this.mDayBeginSpinner, 0, 24)) {
                return false;
            }
        } else {
            if (!STEMUtil.validateIntSpinner(this.mFirstCycleLength, 1, 100)) {
                return false;
            }
            if (!STEMUtil.validateIntSpinner(this.mSecondCycleLength, 1, 100)) {
                return false;
            }
            if (!STEMUtil.validateIntSpinner(this.mSecondStartSpinner, 1, 1000)) {
                return false;
            }
            if (!STEMUtil.validateIntSpinner(this.mThirdStartSpinner, 1, 1000)) {
                return false;
            }
            if (!STEMUtil.validateIntSpinner(this.mCyclicIncreSpinner, 1, 1000)) {
                return false;
            }
        }
        return bl;
    }

    private boolean validateOutput() {
        boolean bl = true;
        if (this.mLocationSpinner == null || this.mMaxClusterSpinner == null) {
            return bl;
        }
        if (!STEMUtil.validateDoubleSpinner(this.mLocationSpinner, 0.0, 1.0)) {
            return false;
        }
        if (!STEMUtil.validateIntSpinner(this.mMaxClusterSpinner, 2, 100)) {
            return false;
        }
        return bl;
    }

    private boolean validateSavePanel() {
        boolean bl = true;
        if (this.mSaveMapCheck == null || this.mMapFileField == null || this.mScoreOpenSet == null || this.mScoreOpenSetNameList == null || this.mScoreSPSSData == null || this.mNewScoreSPSSDataFileField == null) {
            return bl;
        }
        if (this.mSaveMapCheck.isSelected() && this.mMapFileField.getText().length() == 0) {
            bl = false;
        }
        if (bl) {
            if (this.mScoreOpenSet.isSelected()) {
                if (this.mScoreOpenSetNameList.getSelectedIndex() < 0) {
                    bl = false;
                }
            } else if (this.mScoreSPSSData.isSelected()) {
                bl = this.mScoreSPSSDataFileField.getText().length() > 0 && this.mNewScoreSPSSDataFileField.getText().length() > 0;
            }
        }
        return bl;
    }

    private boolean validateModelOption() {
        if (this.mModelMaxLagSpinner == null || this.mParametricRadio == null || this.mPowerSpinner == null) {
            return false;
        }
        if (!STEMUtil.validateIntSpinner(this.mModelMaxLagSpinner, 1, 5)) {
            return false;
        }
        if (!STEMUtil.validateIntSpinner(this.mModelConfSpinner, 90, 99)) {
            return false;
        }
        return !this.mParametricRadio.isSelected() || this.mParamModelCombo.getSelectedIndex() != 1 || STEMUtil.validateDoubleSpinner(this.mPowerSpinner, 1.0, 10.0);
    }

    private boolean validateAdvancedPanel() {
        boolean bl = true;
        if (this.mAdvMaxMissSpinner == null || this.mAdvSigLevelSpinner == null || this.mScoringFactorSpinner == null) {
            return bl;
        }
        if (!STEMUtil.validateIntSpinner(this.mAdvMaxMissSpinner, 1, 100)) {
            return false;
        }
        if (!STEMUtil.validateDoubleSpinner(this.mAdvSigLevelSpinner, 0.0, 0.1)) {
            return false;
        }
        return STEMUtil.validateIntSpinner(this.mScoringFactorSpinner, 0, 100);
    }

    @Override
    public boolean validateOnBack() {
        ((STEMWizardDlg)this.mWizardDialog).getSTPDefineRolePage().setKeepTarget(true);
        return true;
    }

    @Override
    public String getDialogHelpID() {
        int n = this.mParamAndOptionPanel.getSelectedIndex();
        switch (n) {
            case 0: {
                return "idh_stem_stp_time_intervals";
            }
            case 1: {
                return "idh_stem_stp_aggregation";
            }
            case 2: {
                return "idh_stem_stp_output";
            }
            case 3: {
                return "idh_stem_stp_save";
            }
            case 4: {
                return "idh_stem_stp_model_options";
            }
            case 5: {
                return "idh_stem_stp_advanced";
            }
        }
        return "";
    }

    public void reset() {
        this.setDefaults();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mOutClusterCheck) {
            this.enableOutMapPanelControls();
        } else if (object == this.mSaveMapCheck) {
            if (this.mSaveMapCheck.isSelected()) {
                this.mMapFileLabel.setEnabled(true);
                this.mMapFileField.setEnabled(true);
                this.mMapFileButton.setEnabled(true);
                this.mCopyMapCheck.setEnabled(true);
            } else {
                this.mMapFileLabel.setEnabled(false);
                this.mMapFileField.setEnabled(false);
                this.mMapFileButton.setEnabled(false);
                this.mCopyMapCheck.setEnabled(false);
            }
            boolean bl = this.enableNextButton();
            this.mWizardDialog.enableNext(bl);
            this.mWizardDialog.enableFinish(bl);
        } else if (object == this.mFieldSelectButton) {
            Vector<ISpssVariable> vector = this.getUnUsedVars();
            MultiFieldChooserSubDlg multiFieldChooserSubDlg = new MultiFieldChooserSubDlg(this.mWizardDialog, vector);
            multiFieldChooserSubDlg.setVisible(true);
            if (multiFieldChooserSubDlg.continuePressed()) {
                ISpssVariable[] iSpssVariableArray = multiFieldChooserSubDlg.getSelectedFields();
                this.addVarsToAggregationTable(iSpssVariableArray);
            }
        } else if (object == this.mDeleteButton) {
            this.deleteOneRowFromTable();
        } else if (object == this.mMapFileButton) {
            String string = STEMUtil.showOpenMapSpecDialog(this.mWizardDialog, this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SAVE_MAP_TITLE"), this.mWizardDialog.getResString("IDS_STEM_MAP_SPEC_STEM_PLAN_FILE_FILTER"), this.mWizardDialog.getResString("IDS_STEM_MAP_SPEC_STEM_PLAN_FILE_FILTER_EXTN"), RemoteFileChooser.ChooserType.SaveFile);
            this.mMapFileField.setText(string);
            boolean bl = this.enableNextButton();
            this.mWizardDialog.enableNext(bl);
            this.mWizardDialog.enableFinish(bl);
        } else if (object == this.mBrowseSPSSDataButton) {
            String string = this.mNewScoreSPSSDataFileField.getText();
            String string2 = this.mScoreSPSSDataFileField.getText();
            boolean bl = this.isSelectedFileOnRemoteHost(RemoteFileChooser.ChooserType.OpenFile, "IDS_STEM_ADD_CONTEXT_SUB_BROWSE_FILE_TITLE", "IDS_STEM_ADD_CONTEXT_SUB_FILE_FILTER", "IDS_STEM_ADD_CONTEXT_SUB_FILE_EXTENSION", (JTextField)((Object)this.mScoreSPSSDataFileField), (JTextField)((Object)this.mNewScoreSPSSDataFileField));
            if (this.mScoreSPSSDataFileField.getText().length() > 0) {
                boolean bl2 = ((STEMWizardDlg)this.mWizardDialog).getContextPage().isDataSourceUsed(this.mScoreSPSSDataFileField.getText());
                if (bl2) {
                    String string3 = String.format(ComponentState.getSPSSLocale(), this.mWizardDialog.getResString("IDS_STP_SCORE_FILE_IN_USE_ERROR"), this.mScoreSPSSDataFileField.getText());
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string3, VersionInfo.getAppVersionString());
                    this.mScoreSPSSDataFileField.setText(string2);
                    this.mScoreSPSSDataFileField.setSelectionStart(0);
                    this.mScoreSPSSDataFileField.setSelectionEnd(string2.length());
                    this.mNewScoreSPSSDataFileField.setText(string);
                    this.mScoreSPSSDataFileField.requestFocusInWindow();
                    return;
                }
                boolean bl3 = this.enableNextButton();
                this.mWizardDialog.enableNext(bl3);
                this.mWizardDialog.enableFinish(bl3);
            }
        } else if (object == this.mBrowseNewScoredButton) {
            this.isSelectedFileOnRemoteHost(RemoteFileChooser.ChooserType.SaveFile, "IDS_STP_SETTING_SAVE_NEW_SCORING_SCORE_BROWSE_FILE_TITLE", "IDS_STEM_ADD_CONTEXT_SUB_FILE_FILTER", "IDS_STEM_ADD_CONTEXT_SUB_FILE_EXTENSION", (JTextField)((Object)this.mNewScoreSPSSDataFileField), null);
            boolean bl = this.enableNextButton();
            this.mWizardDialog.enableNext(bl);
            this.mWizardDialog.enableFinish(bl);
        }
    }

    @Override
    public void init() {
        this.initVars();
        this.setupPanel(true);
    }

    @Override
    protected void aboutToShowPanel() {
        Object object;
        if (!this.mToNextPage || this.mKeepSettings) {
            if (!this.mToNextPage) {
                this.mToNextPage = true;
            }
            return;
        }
        this.mIsTimeStamp = ((STEMWizardDlg)this.mWizardDialog).getSTPDefineRolePage().isTimeStamp();
        if (this.mIsTimeStamp) {
            Vector<String> vector = ((STEMWizardDlg)this.mWizardDialog).getSTPDefineRolePage().getAutoTimeInterval();
            object = ((STEMWizardDlg)this.mWizardDialog).getSTPDefineRolePage().getTimeFieldSourceAndName();
            this.fillTimeFieldTable((Vector<Pair<String, String>>)object, vector);
            this.mAllSources = null;
        } else {
            this.mAllSources = ((STEMWizardDlg)this.mWizardDialog).getSTPDefineRolePage().getAllDataSources();
            this.fillCyclicTables();
            this.enableSecondCycleAndStartValue();
            this.enableThirdCycleAndStartValue();
        }
        this.setupPanel(this.mIsTimeStamp);
        this.mContextSourceVars = ((STEMWizardDlg)this.mWizardDialog).getSTPDefineRolePage().getNonCatContextSourceFields();
        this.mVarInAggreTable = null;
        boolean bl = this.enableNextButton();
        this.mWizardDialog.enableNext(bl);
        this.mWizardDialog.enableFinish(bl);
        object = this.getTraversalPolicy(this.mParamAndOptionPanel.getSelectedIndex());
        if (object != null) {
            this.mWizardDialog.setFocusTraversalPolicy((FocusTraversalPolicy)object);
        }
        this.mKeepSettings = false;
    }

    private DialogFocusTraversalPolicy getTraversalPolicy(int n) {
        switch (n) {
            case 0: {
                return this.mTimePanelPolicy;
            }
            case 1: {
                return this.mAggrePolicy;
            }
            case 2: {
                return this.mOutputPolicy;
            }
            case 3: {
                return this.mSavePolicy;
            }
            case 4: {
                return this.mModelPolicy;
            }
            case 5: {
                return this.mAdvancePolicy;
            }
        }
        return null;
    }

    private void fillTimeFieldTable(Vector<Pair<String, String>> vector, Vector<String> vector2) {
        Serializable serializable;
        this.mTimeFieldTableModel.setRowCount(0);
        this.mTimeIntervalCombo.setModel(new DefaultComboBoxModel<String>(this.mIntervalValues));
        String string = "";
        boolean bl = true;
        int n = -1;
        if (vector2.size() == 2 && !vector2.get(0).equals(vector2.get(1))) {
            int n2 = -1;
            int n3 = -1;
            serializable = sTimeIntervalMap.get(vector2.get(0));
            if (serializable != null) {
                n2 = (Integer)serializable;
            }
            if ((serializable = sTimeIntervalMap.get(vector2.get(1))) != null) {
                n3 = (Integer)serializable;
            }
            n = n2 == n3 ? (n2 == -1 ? 12 : n2) : (n2 > -1 && n3 > -1 ? (n2 > n3 ? n2 : n3) : (n2 > -1 ? n2 : n3));
        }
        if (n < 0) {
            Integer n4 = sTimeIntervalMap.get(vector2.get(0));
            if (n4 != null && (n = n4.intValue()) > 0) {
                string = this.mIntervalValues[n];
            }
            if (n < 0) {
                string = this.mIntervalValues[12];
                n = 12;
            }
        } else {
            string = this.mIntervalValues[n];
        }
        for (int i = 0; i < vector.size(); ++i) {
            Pair<String, String> pair = vector.get(i);
            serializable = new Vector();
            ((Vector)serializable).add(pair.getFirst());
            ((Vector)serializable).add(pair.getSecond());
            ((Vector)serializable).add(string);
            this.mTimeFieldTableModel.addRow((Vector<?>)serializable);
        }
        this.mTimeFieldTable.setModel(this.mTimeFieldTableModel);
        if (string.length() > 0 && n >= 0) {
            this.mTimeIntervalCombo.setSelectedIndex(n);
            this.enableTimeIntervalControls();
            if (n == 12) {
                String[] stringArray = this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_TIME_INTER_COMBO_PERIOD");
                this.mTimeIntervalCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
            }
        }
    }

    private void fillCyclicTables() {
        this.mFirstCycleTableModel.setRowCount(0);
        this.mSecondCycleTableModel.setRowCount(0);
        this.mThirdCycleTableModel.setRowCount(0);
        int n = this.mAllSources.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            STPDefineRolePage.STPDataListContainer sTPDataListContainer = this.mAllSources.get(i);
            String string = sTPDataListContainer.getDataId();
            VarListModel varListModel = sTPDataListContainer.getSourceModel();
            Vector<String> vector = new Vector<String>();
            for (int j = 0; j < varListModel.getSize(); ++j) {
                object = varListModel.getElementAt(j);
                if (object.getType() != 0) continue;
                vector.add(object.getName());
            }
            String string2 = "";
            object = new Vector();
            ((Vector)object).add(string);
            ((Vector)object).add(string2);
            vector.insertElementAt(string2, 0);
            JComboBox jComboBox = new JComboBox(new DefaultComboBoxModel(vector));
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = STPSettingsPage.this.mFirstCycleTable.getSelectedRow();
                    if (STPSettingsPage.this.mSecondCycleTableModel.getRowCount() == 0) {
                        STPSettingsPage.this.fillSecondAndThirdTables();
                    } else {
                        STPSettingsPage.this.updateSecondTable(n);
                        STPSettingsPage.this.updateThirdTable(n);
                    }
                    boolean bl = STPSettingsPage.this.enableNextButton();
                    STPSettingsPage.this.mWizardDialog.enableNext(bl);
                    STPSettingsPage.this.mWizardDialog.enableFinish(bl);
                }
            });
            this.mFirstCycleTableCellEditor.addRowEditor(i, new DefaultCellEditor(jComboBox));
            this.mFirstCycleTableModel.addRow((Vector<?>)object);
            if (vector.size() != 1) continue;
            ComboBoxEditor comboBoxEditor = (ComboBoxEditor)this.mFirstCycleTable.getCellEditor(i, 1);
            comboBoxEditor.getComboBox().setEnabled(false);
        }
        this.mFirstCycleTable.setModel(this.mFirstCycleTableModel);
        this.mFirstCycleTable.getColumnModel().getColumn(1).setCellEditor(this.mFirstCycleTableCellEditor);
    }

    private void fillSecondAndThirdTables() {
        this.mSecondCycleTableModel.setRowCount(0);
        this.mThirdCycleTableModel.setRowCount(0);
        int n = this.mAllSources.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object;
            STPDefineRolePage.STPDataListContainer sTPDataListContainer = this.mAllSources.get(i);
            String string = sTPDataListContainer.getDataId();
            if (this.mFirstCycleTable.getValueAt(i, 1) == null || this.mFirstCycleTable.getValueAt(i, 1).toString().length() == 0) continue;
            String string2 = this.mFirstCycleTable.getValueAt(i, 1).toString();
            VarListModel varListModel = sTPDataListContainer.getSourceModel();
            Vector<String> vector = new Vector<String>();
            vector.add("");
            for (int j = 0; j < varListModel.getSize(); ++j) {
                object = varListModel.getElementAt(j);
                if (object.getType() != 0 || object.getName().equals(string2)) continue;
                vector.add(object.getName());
            }
            String string3 = "";
            object = new Vector();
            ((Vector)object).add(string);
            ((Vector)object).add(string3);
            JComboBox jComboBox = new JComboBox(new DefaultComboBoxModel(vector));
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    STPSettingsPage.this.enableSecondCycleAndStartValue();
                    boolean bl = STPSettingsPage.this.enableNextButton();
                    STPSettingsPage.this.mWizardDialog.enableNext(bl);
                    STPSettingsPage.this.mWizardDialog.enableFinish(bl);
                }
            });
            this.mSecondCycleTableCellEditor.addRowEditor(n2, new DefaultCellEditor(jComboBox));
            JComboBox jComboBox2 = new JComboBox(new DefaultComboBoxModel(vector));
            jComboBox2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    STPSettingsPage.this.enableThirdCycleAndStartValue();
                    boolean bl = STPSettingsPage.this.enableNextButton();
                    STPSettingsPage.this.mWizardDialog.enableNext(bl);
                    STPSettingsPage.this.mWizardDialog.enableFinish(bl);
                }
            });
            this.mThirdCycleTableCellEditor.addRowEditor(n2, new DefaultCellEditor(jComboBox2));
            this.mSecondCycleTableModel.addRow((Vector<?>)object);
            this.mThirdCycleTableModel.addRow((Vector<?>)object);
            ++n2;
        }
        this.mSecondCycleTable.setModel(this.mSecondCycleTableModel);
        this.mSecondCycleTable.getColumnModel().getColumn(1).setCellEditor(this.mSecondCycleTableCellEditor);
        this.mThirdCycleTable.setModel(this.mThirdCycleTableModel);
        this.mThirdCycleTable.getColumnModel().getColumn(1).setCellEditor(this.mThirdCycleTableCellEditor);
    }

    private void updateSecondTable(int n) {
        Object object;
        if (this.mAllSources == null || this.mAllSources.size() == 0 || n < 0 || n >= this.mAllSources.size()) {
            return;
        }
        STPDefineRolePage.STPDataListContainer sTPDataListContainer = this.mAllSources.get(n);
        String string = this.mFirstCycleTable.getValueAt(n, 1).toString();
        boolean bl = true;
        int n2 = this.findRow(this.mSecondCycleTable, sTPDataListContainer.getDataId());
        if (!(n2 < 0 || bl && string.length() != 0)) {
            this.mSecondCycleTableModel.removeRow(n2);
            this.enableSecondCycleAndStartValue();
            return;
        }
        String string2 = "";
        String string3 = "";
        if (n2 >= 0 && this.mSecondCycleTableModel.getRowCount() > 0 && n2 < this.mSecondCycleTableModel.getRowCount()) {
            string3 = this.mSecondCycleTable.getValueAt(n2, 1).toString();
        }
        VarListModel varListModel = sTPDataListContainer.getSourceModel();
        Vector<String> vector = new Vector<String>();
        vector.add("");
        for (int i = 0; i < varListModel.getSize(); ++i) {
            object = varListModel.getElementAt(i);
            if (object.getType() != 0 || object.getName().equals(string)) continue;
            vector.add(object.getName());
            if (!string3.equals(object.getName())) continue;
            string2 = string3;
        }
        JComboBox jComboBox = new JComboBox(new DefaultComboBoxModel(vector));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STPSettingsPage.this.enableSecondCycleAndStartValue();
                boolean bl = STPSettingsPage.this.enableNextButton();
                STPSettingsPage.this.mWizardDialog.enableNext(bl);
                STPSettingsPage.this.mWizardDialog.enableFinish(bl);
            }
        });
        if (n2 >= 0 && n2 < this.mSecondCycleTableModel.getRowCount()) {
            this.mSecondCycleTableCellEditor.addRowEditor(n2, new DefaultCellEditor(jComboBox));
            this.mSecondCycleTable.setValueAt(string2, n2, 1);
        } else {
            object = new Vector();
            ((Vector)object).add(sTPDataListContainer.getDataId());
            ((Vector)object).add(string2);
            n2 = this.getInsertIndex(this.mSecondCycleTable, n);
            if (n2 < 0) {
                n2 = 0;
            }
            this.mSecondCycleTableModel.insertRow(n2, (Vector<?>)object);
            this.mSecondCycleTableCellEditor.addRowEditor(n2, new DefaultCellEditor(jComboBox));
            this.mSecondCycleTable.setModel(this.mSecondCycleTableModel);
            this.mSecondCycleTable.getColumnModel().getColumn(1).setCellEditor(this.mSecondCycleTableCellEditor);
        }
    }

    private void updateThirdTable(int n) {
        Object object;
        if (this.mAllSources == null || this.mAllSources.size() == 0 || n < 0 || n >= this.mAllSources.size()) {
            return;
        }
        STPDefineRolePage.STPDataListContainer sTPDataListContainer = this.mAllSources.get(n);
        String string = this.mFirstCycleTable.getValueAt(n, 1).toString();
        boolean bl = true;
        int n2 = this.findRow(this.mThirdCycleTable, sTPDataListContainer.getDataId());
        if (n2 >= 0) {
            if (!bl || string.length() == 0) {
                this.mThirdCycleTableModel.removeRow(n2);
                this.enableThirdCycleAndStartValue();
                return;
            }
        } else if (!bl) {
            return;
        }
        String string2 = "";
        String string3 = "";
        if (n2 >= 0 && n2 < this.mThirdCycleTableModel.getRowCount()) {
            string3 = this.mThirdCycleTable.getValueAt(n2, 1).toString();
        }
        VarListModel varListModel = sTPDataListContainer.getSourceModel();
        Vector<String> vector = new Vector<String>();
        vector.add("");
        for (int i = 0; i < varListModel.getSize(); ++i) {
            object = varListModel.getElementAt(i);
            if (object.getMeasurementLevel() != MeasurementLevel.scale || object.getName().equals(string)) continue;
            vector.add(object.getName());
            if (!string3.equals(object.getName())) continue;
            string2 = string3;
        }
        JComboBox jComboBox = new JComboBox(new DefaultComboBoxModel(vector));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STPSettingsPage.this.enableThirdCycleAndStartValue();
                boolean bl = STPSettingsPage.this.enableNextButton();
                STPSettingsPage.this.mWizardDialog.enableNext(bl);
                STPSettingsPage.this.mWizardDialog.enableFinish(bl);
            }
        });
        if (n2 >= 0 && n2 < this.mThirdCycleTableModel.getRowCount()) {
            this.mThirdCycleTableCellEditor.addRowEditor(n2, new DefaultCellEditor(jComboBox));
            this.mThirdCycleTable.setValueAt(string2, n2, 1);
        } else {
            object = new Vector();
            ((Vector)object).add(sTPDataListContainer.getDataId());
            ((Vector)object).add(string2);
            n2 = this.getInsertIndex(this.mThirdCycleTable, n);
            if (n2 < 0) {
                n2 = 0;
            }
            this.mThirdCycleTableModel.insertRow(n2, (Vector<?>)object);
            this.mThirdCycleTableCellEditor.addRowEditor(n2, new DefaultCellEditor(jComboBox));
            this.mThirdCycleTable.setModel(this.mThirdCycleTableModel);
            this.mThirdCycleTable.getColumnModel().getColumn(1).setCellEditor(this.mThirdCycleTableCellEditor);
        }
    }

    int getInsertIndex(JTable jTable, int n) {
        int n2 = -1;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n3 = this.getOrigIndex(jTable.getValueAt(i, 0).toString());
            if (n < n3) {
                n2 = i;
                break;
            }
            if (i + 1 == jTable.getRowCount()) {
                n2 = i + 1;
                continue;
            }
            int n4 = this.getOrigIndex(jTable.getValueAt(i + 1, 0).toString());
            if (n2 >= n4 || n2 <= n3) continue;
            n2 = i + 1;
            break;
        }
        return n2;
    }

    int getOrigIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.mAllSources.size(); ++i) {
            if (!string.equals(this.mAllSources.get(i).getDataId())) continue;
            n = i;
        }
        return n;
    }

    private int findRow(JTable jTable, String string) {
        int n = -1;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            if (!string.equals(jTable.getValueAt(i, 0).toString())) continue;
            return i;
        }
        return n;
    }

    private void setupPanel(boolean bl) {
        this.mParamAndOptionPanel.removeAllPanels();
        if (bl) {
            this.setupTimeIntervalPanel();
        } else {
            this.setupTimeIntervalCyclicPanel();
        }
        this.setupAggregationPanel();
        this.setupOutputPanel();
        this.setupSavePanel();
        this.setupModelOptionPanel();
        this.setupAdvancedPanel();
        this.mParamAndOptionPanel.addPanel(this.mTimeIntervalPanel, this.mWizardDialog.getResString("IDS_STP_SETTING_TIME_INTERVAL_TITLE"), this.mTimePanelPolicy);
        this.mParamAndOptionPanel.addPanel(this.mAggregationPanel, this.mWizardDialog.getResString("IDS_STP_SETTING_AGGREGATION_TITLE"), this.mAggrePolicy);
        this.mParamAndOptionPanel.addPanel(this.mOutputPanel, this.mWizardDialog.getResString("IDS_STP_SETTING_OUTPUT_TITLE"), this.mOutputPolicy);
        this.mParamAndOptionPanel.addPanel(this.mSavePanel, this.mWizardDialog.getResString("IDS_STP_SETTING_SAVE_TITLE"), this.mSavePolicy);
        this.mParamAndOptionPanel.addPanel(this.mModelOptionPanel, this.mWizardDialog.getResString("IDS_STP_SETTING_MODEL_OPTION_TITLE"), this.mModelPolicy);
        this.mParamAndOptionPanel.addPanel(this.mAdvancedPanel, this.mWizardDialog.getResString("IDS_STP_SETTING_ADVANCED_TITLE"), this.mAdvancePolicy);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, n2 * 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, n2, 2, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mParamAndOptionPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults();
    }

    private void setTimeTabTraversalOrder(boolean bl) {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        if (!bl) {
            vector.add(this.mTimeFieldTable);
            vector.add(this.mTimeIntervalCombo);
            vector.add(this.mTimeStartSpinner.getEditor());
            vector.add(this.mTimeIncreSpinner.getEditor());
            vector.add(this.mNumDaysSpinner.getEditor());
            vector.add(this.mWeekBeginCombo);
            vector.add(this.mNumHourSpinner.getEditor());
            vector.add(this.mDayBeginSpinner.getEditor());
        } else {
            vector.add(this.mTimeCyclicInfo);
            vector.add(this.mFirstCycleTable);
            vector.add(this.mFirstCycleLength.getEditor());
            vector.add(this.mCyclicIncreSpinner.getEditor());
            vector.add(this.mSecondCycleTable);
            vector.add(this.mSecondCycleLength.getEditor());
            vector.add(this.mSecondStartSpinner.getEditor());
            vector.add(this.mThirdCycleTable);
            vector.add(this.mThirdStartSpinner.getEditor());
        }
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mTimePanelPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setOutputTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mOutputSetting);
        vector.add(this.mOutTargetCheck);
        vector.add(this.mOutCorreCheck);
        vector.add(this.mOutClusterCheck);
        vector.add(this.mLocationSpinLabel);
        vector.add(this.mLocationSpinner.getEditor());
        vector.add(this.mMaxClusterSpinLabel);
        vector.add(this.mMaxClusterSpinner.getEditor());
        vector.add(this.mOutModelSpecCheck);
        vector.add(this.mOutTimeInfoSummaryCheck);
        vector.add(this.mOutLocationSummaryCheck);
        vector.add(this.mOutModelQualityCheck);
        vector.add(this.mOutTestEffectCheck);
        vector.add(this.mOutMeanStrucCheck);
        vector.add(this.mOutAutoregresCheck);
        vector.add(this.mOutTestSpatialCheck);
        vector.add(this.mOutSpatialParamCheck);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mOutputPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setAggrTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mTimeAggregFun);
        vector.add(this.mTimeContCombo);
        vector.add(this.mTimeOrdinalCombo);
        vector.add(this.mFieldAndFunctionTable);
        vector.add(this.mFieldSelectButton);
        vector.add(this.mDeleteButton);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mAggrePolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setModelTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mModelOpSetting);
        vector.add(this.mModelAutoCheck);
        vector.add(this.mModelMaxLagSpinner.getEditor());
        vector.add(this.mModelConfSpinner.getEditor());
        vector.add(this.mModelSpatialSetting);
        vector.add(this.mParametricRadio);
        vector.add(this.mParamModelCombo);
        vector.add(this.mPowerSpinner.getEditor());
        vector.add(this.mNonParamRadio);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mModelPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setAdvanceTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mAdvancedSetting);
        vector.add(this.mAdvMaxMissLabel);
        vector.add(this.mAdvMaxMissSpinner.getEditor());
        vector.add(this.mAdvSigLevelSpinner.getEditor());
        vector.add(this.mScoringInfo);
        vector.add(this.mScoringFactorLabel);
        vector.add(this.mScoringFactorSpinner.getEditor());
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mAdvancePolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setSaveTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mSaveSetting);
        vector.add(this.mSaveMapCheck);
        vector.add(this.mMapFileField);
        vector.add(this.mMapFileButton);
        vector.add(this.mCopyMapCheck);
        vector.add(this.mNoScoring);
        vector.add(this.mScoreOpenSet);
        vector.add(this.mScoreOpenSetNameList);
        vector.add(this.mScoreSPSSData);
        vector.add(this.mScoreSPSSDataFileField);
        vector.add(this.mBrowseSPSSDataButton);
        vector.add(this.mNewScoreSPSSDataFileField);
        vector.add(this.mBrowseNewScoredButton);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mSavePolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setDefaults() {
        this.mTimeContCombo.setSelectedIndex(1);
        this.setOutputPanelDefault();
        this.setModelPanelDefault();
        this.mNoScoring.setSelected(true);
        this.mTimeContCombo.setSelectedIndex(0);
        this.mTimeOrdinalCombo.setSelectedIndex(1);
        this.updateOpenDataSetList();
    }

    private void setTimeIntervalDefault() {
        this.mTimeStartSpinLabel.setEnabled(false);
        this.mTimeStartSpinner.setEnabled(false);
        this.mTimeIncreSpinLabel.setEnabled(false);
        this.mTimeIncreSpinner.setEnabled(false);
        this.mNumDaysSpinLabel.setEnabled(false);
        this.mNumDaysSpinner.setEnabled(false);
        this.mWeekBeginComboLabel.setEnabled(false);
        this.mWeekBeginCombo.setEnabled(false);
        this.mNumHourSpinLabel.setEnabled(false);
        this.mNumHourSpinner.setEnabled(false);
        this.mDayBeginSpinLabel.setEnabled(false);
        this.mDayBeginSpinner.setEnabled(false);
        this.mFirstCycleLengthLabel.setEnabled(false);
        this.mFirstCycleLength.getEditor().setEnabled(false);
        this.mSecondCycleLengthLabel.setEnabled(false);
        this.mSecondCycleLength.getEditor().setEnabled(false);
        this.mSecondStartSpinLabel.setEnabled(false);
        this.mSecondStartSpinner.getEditor().setEnabled(false);
        this.mThirdStartSpinLabel.setEnabled(false);
        this.mThirdStartSpinner.getEditor().setEnabled(false);
    }

    private void setOutputPanelDefault() {
        this.mOutTargetCheck.setSelected(true);
        this.mOutCorreCheck.setSelected(true);
        this.mOutClusterCheck.setSelected(true);
        this.mOutModelSpecCheck.setSelected(true);
        this.mOutTimeInfoSummaryCheck.setSelected(true);
        this.mOutTestEffectCheck.setSelected(false);
        this.mOutMeanStrucCheck.setSelected(false);
        this.mOutAutoregresCheck.setSelected(false);
        this.mOutTestSpatialCheck.setSelected(true);
        this.mOutSpatialParamCheck.setSelected(false);
        this.enableOutMapPanelControls();
        if (this.mSaveMapCheck.isSelected()) {
            this.mMapFileLabel.setEnabled(true);
            this.mMapFileField.setEnabled(true);
            this.mMapFileButton.setEnabled(true);
            this.mCopyMapCheck.setEnabled(true);
        } else {
            this.mMapFileLabel.setEnabled(false);
            this.mMapFileField.setEnabled(false);
            this.mMapFileButton.setEnabled(false);
            this.mCopyMapCheck.setEnabled(false);
        }
    }

    private void setModelPanelDefault() {
        this.mModelAutoCheck.setSelected(true);
        this.mParametricRadio.setSelected(true);
        this.mParamModelCombo.setSelectedIndex(2);
    }

    private void initVars() {
        this.mParamAndOptionPanel = new StepSevenSidebarSelectorPanel(this.mWizardDialog, "STEM_SETTINGS_Tab", this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SIDEBAR_LABEL"), 83, this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_INFO_TEXT"));
        this.initTimeIntervalPanelVars();
        this.initAggregationPanelVars();
        this.initOutputPanelVars();
        this.initSavePanelVars();
        this.initModelOptionPanelVars();
        this.initAdvancedPanelVars();
    }

    private void initOutputPanelVars() {
        this.mOutputSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STP_SETTING_OUTPUT_INFO"));
        this.mOutTargetCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SPATIAL_TARGET_CHECK", null);
        this.mOutCorreCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SPATIAL_CORREL_CHECK", null);
        this.mOutClusterCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SPATIAL_CLUSTER_CHECK", null);
        this.mOutClusterCheck.addActionListener(this);
        this.mLocationSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SPATIAL_THRESHOLD_SPINNER");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0.2, 0.0, 1.0, 0.1);
        FloatTextField floatTextField = new FloatTextField(0.0, 1.0, 1);
        floatTextField.getDocument().addDocumentListener(this);
        floatTextField.setIncludeMinRange(false);
        floatTextField.setHorizontalAlignment(4);
        this.mLocationSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        this.mLocationSpinner.setAlignmentX(1.0f);
        this.mLocationSpinLabel.setLabelFor(this.mLocationSpinner.getEditor());
        this.mMaxClusterSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SPATIAL_CLUSTER_SPINNER");
        spinnerNumberModel = new SpinnerNumberModel(10, 2, 100, 1);
        IntTextField intTextField = new IntTextField(2, 100, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateOutput()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mMaxClusterSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mMaxClusterSpinner.setAlignmentX(1.0f);
        this.mMaxClusterSpinLabel.setLabelFor(this.mMaxClusterSpinner.getEditor());
        this.mOutModelSpecCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_MODEL_SPEC_CHECK", null);
        this.mOutTimeInfoSummaryCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_MODEL_TEMPORAL_CHECK", null);
        this.mOutLocationSummaryCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_LOC_SUMMARY_CHECK", null);
        this.mOutModelQualityCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_MODEL_QUALITY_CHECK", null);
        this.mOutTestEffectCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_MODEL_TEST_EFFECT_CHECK", null);
        this.mOutMeanStrucCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_MODEL_MEAN_STRUC_CHECK", null);
        this.mOutAutoregresCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_MODEL_AUTOREGR_CHECK", null);
        this.mOutTestSpatialCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_MODEL_TEST_SPATIAL_CHECK", null);
        this.mOutSpatialParamCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_MODEL_PARAM_CHECK", null);
    }

    private void initSavePanelVars() {
        this.mSaveSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STP_SETTING_SAVE_INFO"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SAVE_MAP_CHECK");
        this.mSaveMapCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SAVE_MAP_CHECK", null);
        this.mSaveMapCheck.addActionListener(this);
        this.mMapFileLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SAVE_MAP_FIELD");
        this.mMapFileField = new FileTextField();
        this.mMapFileField.setColumns(20);
        this.mMapFileField.setAction(new TextFieldAction(this.mWizardDialog, NEW_MAP_FILE_NAME));
        this.mMapFileField.getDocument().addDocumentListener(this);
        this.mMapFileLabel.setLabelFor((Component)((Object)this.mMapFileField));
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SAVE_MAP_BUTTON");
        this.mMapFileButton = new JButton(toggleButtonAction);
        this.mMapFileButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SAVE_COPY_MAP");
        this.mCopyMapCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_OUTPUT_SAVE_COPY_MAP", null);
        this.mCopyMapCheck.addActionListener(this);
        this.mNoScoring = DialogUtil.createRadioButton(this.mWizardDialog, "IDS_STP_SETTING_SAVE_SCORING_NO_SCORE", null);
        this.mNoScoring.addItemListener(this);
        this.mScoreOpenSet = DialogUtil.createRadioButton(this.mWizardDialog, "IDS_STP_SETTING_SAVE_SCORING_SCORE_OPEN", null);
        this.mScoreOpenSet.addItemListener(this);
        this.mScoreSPSSData = DialogUtil.createRadioButton(this.mWizardDialog, "IDS_STP_SETTING_SAVE_SCORING_SCORE_SPSS", null);
        this.mScoreSPSSData.addItemListener(this);
        this.mScoringGrop = new SpssButtonGroup();
        this.mScoringGrop.add(this.mNoScoring);
        this.mScoringGrop.add(this.mScoreOpenSet);
        this.mScoringGrop.add(this.mScoreSPSSData);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STP_SETTING_SAVE_SCORING_SCORE_BROWSE");
        this.mBrowseSPSSDataButton = new JButton(toggleButtonAction);
        this.mBrowseSPSSDataButton.addActionListener(this);
        this.mScoreSPSSDataLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_SAVE_SCORING_SCORE_SPSS_LABEL");
        this.mScoreSPSSDataFileField = new FileTextField();
        this.mScoreSPSSDataFileField.setColumns(30);
        this.mScoreSPSSDataLabel.setLabelFor((Component)((Object)this.mScoreSPSSDataFileField));
        this.mScoreSPSSDataFileField.setAction(new TextFieldAction(this.mWizardDialog, "NEW_SCORE_SPSS_DATA_NAME"));
        this.mScoreOpenSetNameList = new SerializableList("IDS_STP_SETTING_SAVE_SCORING_OPEN_DATASETS");
        this.mScoreOpenSetNameList.addListSelectionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STP_SETTING_SAVE_NEW_SCORING_SCORE_BROWSE");
        this.mBrowseNewScoredButton = new JButton(toggleButtonAction);
        this.mBrowseNewScoredButton.addActionListener(this);
        this.mNewScoreSPSSDataLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_SAVE_NEW_SCORING_SCORE_SPSS_LABEL");
        this.mNewScoreSPSSDataFileField = new FileTextField();
        this.mNewScoreSPSSDataFileField.setColumns(30);
        this.mNewScoreSPSSDataLabel.setLabelFor((Component)((Object)this.mNewScoreSPSSDataFileField));
        this.mNewScoreSPSSDataFileField.setAction(new TextFieldAction(this.mWizardDialog, "NEW_SAVED_SCORE_SPSS_DATA_NAME"));
    }

    private void initTimeIntervalPanelVars() {
        this.mTimeFieldTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_FIELD_TABLE_LABEL");
        Object[] objectArray = this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_FIELD_TABLE_HEADER");
        this.mTimeFieldTableModel = new DefaultTableModel(objectArray, 3){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mTimeFieldTable = new PlainTable();
        this.mTimeFieldTable.setModel(this.mTimeFieldTableModel);
        this.mTimeFieldTable.setRowHeight(22);
        this.mTimeFieldTable.setColumnSelectionAllowed(false);
        this.mTimeFieldTable.setRowSelectionAllowed(true);
        this.mTimeFieldTable.setSelectionMode(0);
        this.mTimeFieldTable.getTableHeader().setReorderingAllowed(false);
        this.mTimeFieldTable.getTableHeader().setResizingAllowed(true);
        this.mTimeFieldTable.setGridColor(Color.darkGray);
        this.mTimeFieldTable.getTableHeader().setReorderingAllowed(false);
        this.mTimeFieldTable.setSelectionMode(0);
        this.mTimeFieldTableLabel.setLabelFor(this.mTimeFieldTable);
        this.mTimeFieldTable.getColumnModel().getColumn(0).setCellRenderer(new UnEditableCellTextRenderer());
        this.mTimeFieldTable.getColumnModel().getColumn(1).setCellRenderer(new UnEditableCellTextRenderer());
        this.mTimeFieldTable.getColumnModel().getColumn(2).setCellRenderer(new UnEditableCellTextRenderer());
        this.mTimeIntervalComboLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_TIME_INTER_COMBO");
        this.mIntervalValues = this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_TIME_INTER_COMBO_VALUES");
        this.mTimeIntervalCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mIntervalValues));
        this.mTimeIntervalCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_TIME_INTER_COMBO"));
        this.mTimeIntervalCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STPSettingsPage.this.enableTimeIntervalControls();
            }
        });
        this.mTimeIntervalComboLabel.setLabelFor(this.mTimeIntervalCombo);
        this.mTimeStartSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_START_VALUE");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, -1000, 1000, 1);
        IntTextField intTextField = new IntTextField(-1000, 1000, false);
        intTextField.setHorizontalAlignment(4);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        this.mTimeStartSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mTimeStartSpinner.setAlignmentX(1.0f);
        this.mTimeStartSpinLabel.setLabelFor(this.mTimeStartSpinner.getEditor());
        this.mTimeIncreSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_INCREMENT_BY");
        spinnerNumberModel = new SpinnerNumberModel(1, 1, 100, 1);
        intTextField = new IntTextField(1, 100, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mTimeIncreSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mTimeIncreSpinner.setAlignmentX(1.0f);
        this.mTimeIncreSpinLabel.setLabelFor(this.mTimeIncreSpinner.getEditor());
        this.mNumDaysSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_NUM_PER_WEEK");
        spinnerNumberModel = new SpinnerNumberModel(7, 1, 7, 1);
        intTextField = new IntTextField(1, 7, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mNumDaysSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mNumDaysSpinner.setAlignmentX(1.0f);
        this.mNumDaysSpinLabel.setLabelFor(this.mNumDaysSpinner.getEditor());
        this.mWeekBeginComboLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_WEEK_BEGIN_COMBO");
        this.mWeekBeginCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_WEEK_BEGIN_COMBO_VALUES")));
        this.mWeekBeginCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_WEEK_BEGIN_COMBO"));
        this.mWeekBeginComboLabel.setLabelFor(this.mWeekBeginCombo);
        this.mNumHourSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_NUM_HOURS_DAY");
        spinnerNumberModel = new SpinnerNumberModel(24, 1, 24, 1);
        intTextField = new IntTextField(1, 24, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mNumHourSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mNumHourSpinner.setAlignmentX(1.0f);
        this.mNumHourSpinLabel.setLabelFor(this.mNumHourSpinner.getEditor());
        this.mDayBeginSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_DAY_BEGIN_HOUR");
        spinnerNumberModel = new SpinnerNumberModel(0, 0, 24, 1);
        intTextField = new IntTextField(0, 24, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mDayBeginSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mDayBeginSpinner.setAlignmentX(1.0f);
        this.mDayBeginSpinLabel.setLabelFor(this.mDayBeginSpinner.getEditor());
        String string = this.mWizardDialog.getResString("IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_INFO");
        this.mTimeCyclicInfo = new FocusableTextArea(string, null);
        this.mFirstCycleTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_FIRST_TABLE_LABEL");
        objectArray = this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_FIRST_TABLE_HEADER");
        this.mFirstCycleTableModel = new DefaultTableModel(objectArray, 2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n2 == 0) {
                    return false;
                }
                return n2 == 1;
            }
        };
        this.mFirstCycleTable = new PlainTable();
        this.mFirstCycleTable.setModel(this.mFirstCycleTableModel);
        this.mFirstCycleTable.setRowHeight(22);
        this.mFirstCycleTable.setColumnSelectionAllowed(false);
        this.mFirstCycleTable.setRowSelectionAllowed(true);
        this.mFirstCycleTable.setSelectionMode(0);
        this.mFirstCycleTable.getTableHeader().setReorderingAllowed(false);
        this.mFirstCycleTable.getTableHeader().setResizingAllowed(true);
        this.mFirstCycleTable.setGridColor(Color.darkGray);
        this.mFirstCycleTable.getTableHeader().setReorderingAllowed(false);
        this.mFirstCycleTable.setSelectionMode(0);
        this.mFirstCycleTableLabel.setLabelFor(this.mFirstCycleTable);
        this.mFirstCycleTableCellEditor = new CellComboBoxEditor(this.mFirstCycleTable);
        this.mFirstCycleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = STPSettingsPage.this.mFirstCycleTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = STPSettingsPage.this.mFirstCycleTable.columnAtPoint(mouseEvent.getPoint());
                Object object = null;
                if (n2 == 1) {
                    object = STPSettingsPage.this.mFirstCycleTable.getValueAt(n, n2);
                }
            }
        });
        this.mFirstCycleLengthLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_FIRST_CYCLE_LENGTH");
        spinnerNumberModel = new SpinnerNumberModel(10, 1, 100, 1);
        intTextField = new IntTextField(1, 100, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mFirstCycleLength = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mFirstCycleLength.setAlignmentX(1.0f);
        this.mFirstCycleLengthLabel.setLabelFor(this.mFirstCycleLength.getEditor());
        this.mCyclicIncreSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_FIRST_CYCLE_INCREMENT_VALUE");
        spinnerNumberModel = new SpinnerNumberModel(1, 1, 1000, 1);
        intTextField = new IntTextField(1, 1000, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mCyclicIncreSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mCyclicIncreSpinner.setAlignmentX(1.0f);
        this.mCyclicIncreSpinLabel.setLabelFor(this.mCyclicIncreSpinner.getEditor());
        this.mSecondCycleTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_SECOND_TABLE_LABEL");
        Object[] objectArray2 = this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_TABLE_HEADER");
        this.mSecondCycleTableModel = new DefaultTableModel(objectArray2, 2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mSecondCycleTable = new PlainTable();
        this.mSecondCycleTable.setModel(this.mSecondCycleTableModel);
        this.mSecondCycleTable.setRowHeight(22);
        this.mSecondCycleTable.setColumnSelectionAllowed(false);
        this.mSecondCycleTable.setRowSelectionAllowed(true);
        this.mSecondCycleTable.setSelectionMode(0);
        this.mSecondCycleTable.getTableHeader().setReorderingAllowed(false);
        this.mSecondCycleTable.getTableHeader().setResizingAllowed(true);
        this.mSecondCycleTable.setGridColor(Color.darkGray);
        this.mSecondCycleTable.getTableHeader().setReorderingAllowed(false);
        this.mSecondCycleTable.setSelectionMode(0);
        this.mSecondCycleTableLabel.setLabelFor(this.mSecondCycleTable);
        this.mSecondCycleTableCellEditor = new CellComboBoxEditor(this.mSecondCycleTable);
        this.mSecondCycleLengthLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_SECOND_CYCLE_LENGTH");
        spinnerNumberModel = new SpinnerNumberModel(10, 1, 100, 1);
        intTextField = new IntTextField(1, 100, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mSecondCycleLength = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mSecondCycleLength.setAlignmentX(1.0f);
        this.mSecondCycleLengthLabel.setLabelFor(this.mSecondCycleLength.getEditor());
        this.mSecondStartSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_SECOND_CYCLE_START_VALUE");
        spinnerNumberModel = new SpinnerNumberModel(1, 1, 1000, 1);
        intTextField = new IntTextField(1, 1000, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.setHorizontalAlignment(4);
        intTextField.getDocument().addDocumentListener(this);
        this.mSecondStartSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mSecondStartSpinner.setAlignmentX(1.0f);
        this.mSecondStartSpinLabel.setLabelFor(this.mSecondStartSpinner.getEditor());
        this.mThirdCycleTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_THIRD_TABLE_LABEL");
        this.mThirdCycleTableModel = new DefaultTableModel(objectArray2, 2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mThirdCycleTable = new PlainTable();
        this.mThirdCycleTable.setModel(this.mThirdCycleTableModel);
        this.mThirdCycleTable.setRowHeight(22);
        this.mThirdCycleTable.setColumnSelectionAllowed(false);
        this.mThirdCycleTable.setRowSelectionAllowed(true);
        this.mThirdCycleTable.setSelectionMode(0);
        this.mThirdCycleTable.getTableHeader().setReorderingAllowed(false);
        this.mThirdCycleTable.getTableHeader().setResizingAllowed(true);
        this.mThirdCycleTable.setGridColor(Color.darkGray);
        this.mThirdCycleTable.getTableHeader().setReorderingAllowed(false);
        this.mThirdCycleTable.setSelectionMode(0);
        this.mThirdCycleTableLabel.setLabelFor(this.mThirdCycleTable);
        this.mThirdCycleTableCellEditor = new CellComboBoxEditor(this.mThirdCycleTable);
        this.mThirdStartSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_THIRD_CYCLE_START_VALUE");
        spinnerNumberModel = new SpinnerNumberModel(1, 1, 1000, 1);
        intTextField = new IntTextField(1, 1000, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateTimeInterval()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.setHorizontalAlignment(4);
        intTextField.getDocument().addDocumentListener(this);
        this.mThirdStartSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mThirdStartSpinner.setAlignmentX(1.0f);
        this.mThirdStartSpinLabel.setLabelFor(this.mThirdStartSpinner.getEditor());
    }

    private void initAggregationPanelVars() {
        this.mFieldAndFunctionTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_FF_TABLE_LABEL");
        Object[] objectArray = this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_FF_TABLE_HEADER");
        this.mFieldAndFunctionTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 2;
            }
        };
        this.mFieldAndFunctionTable = new PlainTable();
        this.mFieldAndFunctionTable.setModel(this.mFieldAndFunctionTableModel);
        this.mFieldAndFunctionTable.setRowHeight(22);
        this.mFieldAndFunctionTable.setColumnSelectionAllowed(false);
        this.mFieldAndFunctionTable.setRowSelectionAllowed(true);
        this.mFieldAndFunctionTable.setSelectionMode(0);
        this.mFieldAndFunctionTable.getTableHeader().setReorderingAllowed(false);
        this.mFieldAndFunctionTable.getTableHeader().setResizingAllowed(true);
        this.mFieldAndFunctionTable.setGridColor(Color.darkGray);
        this.mFieldAndFunctionTable.getTableHeader().setReorderingAllowed(false);
        this.mFieldAndFunctionTable.setSelectionMode(0);
        this.mFieldAndFunctionTableLabel.setLabelFor(this.mFieldAndFunctionTable);
        this.mFieldFunTableCellEditor = new CellComboBoxEditor(this.mFieldAndFunctionTable);
        URL uRL = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SOURCE_SELECT_MULTI_FIELD_IMAGE"));
        this.mFieldSelectButton = DialogUtil.createButton(this.mWizardDialog, "", null);
        if (uRL != null) {
            this.mFieldSelectButton.setIcon(new ImageIcon(uRL));
        }
        this.mFieldSelectButton.addActionListener(this);
        uRL = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SOURCE_SELECT_DELETE_IMAGE"));
        this.mDeleteButton = DialogUtil.createButton(this.mWizardDialog, "", null);
        if (uRL != null) {
            this.mDeleteButton.setIcon(new ImageIcon(uRL));
        }
        this.mDeleteButton.addActionListener(this);
        this.mTimeAggregFun = new FocusableLabel(this.mWizardDialog.getResString("IDS_STP_SETTING_TIME_INTERVAL_DEFAULT_INFO"));
        this.mTimeContComboLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_DEFAULT_CONT");
        this.mContAggreArray = this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_DEFAULT_CONT_VALUES");
        this.mTimeContCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mContAggreArray));
        int n = this.mTimeContCombo.getPreferredSize().height;
        this.mTimeContCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_DEFAULT_CONT"));
        this.mTimeContComboLabel.setLabelFor(this.mTimeContCombo);
        this.mTimeContCombo.setPreferredSize(new Dimension(120, n));
        this.mTimeOrdinalLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_DEFAULT_ORDINAL");
        this.mOrdinalAggreArray = this.mWizardDialog.getResStringArray("IDS_STP_SETTING_TIME_INTERVAL_DEFAULT_ORDINAL_VALUES");
        this.mTimeOrdinalCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mOrdinalAggreArray));
        this.mTimeOrdinalCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STP_SETTING_TIME_INTERVAL_DEFAULT_ORDINAL"));
        this.mTimeOrdinalLabel.setLabelFor(this.mTimeOrdinalCombo);
        this.mTimeOrdinalCombo.setPreferredSize(new Dimension(120, n));
    }

    private ImageIcon getIcon(String string) {
        String string2 = ResUtil.getCommonDlgString(string);
        URL uRL = ResUtil.getCommonDlgImageResource(string2);
        return new ImageIcon(uRL);
    }

    private void initModelOptionPanelVars() {
        this.mModelOpSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STP_SETTING_MODEL_OPTION_INFO"));
        this.mModelAutoCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STP_SETTING_MODEL_OPTION_AUTO_INTERCEPT", null);
        this.mModelAutoCheck.addActionListener(this);
        this.mModelMaxLagSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_MODEL_OPTION_MAX_AUTO_LAG");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(5, 1, 5, 1);
        IntTextField intTextField = new IntTextField(1, 5, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateModelOption()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mModelMaxLagSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mModelMaxLagSpinner.setAlignmentX(1.0f);
        this.mModelMaxLagSpinLabel.setLabelFor(this.mModelMaxLagSpinner.getEditor());
        this.mModelConfSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_MODEL_OPTION_CONF_INTERVAL");
        spinnerNumberModel = new SpinnerNumberModel(95, 90, 99, 1);
        IntTextField intTextField2 = new IntTextField(90, 99, true);
        intTextField2.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateModelOption()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField2.getDocument().addDocumentListener(this);
        intTextField2.setHorizontalAlignment(4);
        this.mModelConfSpinner = new NumberSpinner(intTextField2, spinnerNumberModel);
        this.mModelConfSpinner.setAlignmentX(1.0f);
        this.mModelConfSpinLabel.setLabelFor(this.mModelConfSpinner.getEditor());
        this.mModelSpatialSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STP_SETTING_MODEL_OPTION_SPITIAL_INFO"));
        this.mParametricRadio = DialogUtil.createRadioButton(this.mWizardDialog, "IDS_STP_SETTING_MODEL_OPTION_SPITIAL_VARIOGRAM", null);
        this.mParametricRadio.addItemListener(this);
        this.mNonParamRadio = DialogUtil.createRadioButton(this.mWizardDialog, "IDS_STP_SETTING_MODEL_OPTION_SPITIAL_EMPIRICAL", null);
        this.mNonParamRadio.addItemListener(this);
        this.mSpatialRadioGroup = new SpssButtonGroup();
        this.mSpatialRadioGroup.add(this.mParametricRadio);
        this.mSpatialRadioGroup.add(this.mNonParamRadio);
        this.mParamModelComboLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_MODEL_OPTION_SPITIAL_VARIOGRAM_ORDER");
        this.mParamModelCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mWizardDialog.getResStringArray("IDS_STP_SETTING_MODEL_OPTION_SPITIAL_VARIOGRAM_ORDER_VALUES")));
        this.mParamModelCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STP_SETTING_MODEL_OPTION_SPITIAL_VARIOGRAM_ORDER"));
        this.mParamModelComboLabel.setLabelFor(this.mParamModelCombo);
        this.mParamModelCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STPSettingsPage.this.enableSpatialCovarPanel();
            }
        });
        this.mPowerSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_MODEL_OPTION_SPITIAL_VARIOGRAM_POWER");
        spinnerNumberModel = new SpinnerNumberModel(1.5, 1.0, 10.0, 0.1);
        FloatTextField floatTextField = new FloatTextField(1.0, 10.0, 1);
        floatTextField.getDocument().addDocumentListener(this);
        floatTextField.setHorizontalAlignment(4);
        this.mPowerSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        this.mPowerSpinner.setAlignmentX(1.0f);
        this.mPowerSpinLabel.setLabelFor(this.mPowerSpinner.getEditor());
    }

    private void initAdvancedPanelVars() {
        this.mAdvancedSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STP_SETTING_ADVANCED_INFO"));
        this.mAdvMaxMissLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_ADVANCED_MISSING_PERCENT");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(5, 1, 100, 1);
        IntTextField intTextField = new IntTextField(1, 100, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateAdvancedPanel()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mAdvMaxMissSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mAdvMaxMissSpinner.setAlignmentX(1.0f);
        this.mAdvMaxMissLabel.setLabelFor(this.mAdvMaxMissSpinner.getEditor());
        this.mAdvSigLevelLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_ADVANCED_SIG_LEVEL");
        spinnerNumberModel = new SpinnerNumberModel(0.05, 0.0, 0.1, 0.01);
        FloatTextField floatTextField = new FloatTextField(0.0, 0.1, 2);
        floatTextField.getDocument().addDocumentListener(this);
        floatTextField.setHorizontalAlignment(4);
        this.mAdvSigLevelSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        this.mAdvSigLevelSpinner.setAlignmentX(1.0f);
        this.mAdvSigLevelLabel.setLabelFor(this.mAdvSigLevelSpinner.getEditor());
        this.mScoringInfo = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STP_SETTING_ADVANCED_SCORING_INFO"), null);
        this.mScoringFactorLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STP_SETTING_ADVANCED_SCORING_FACTOR");
        spinnerNumberModel = new SpinnerNumberModel(5, 0, 100, 1);
        intTextField = new IntTextField(0, 100, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STPSettingsPage.this.validateAdvancedPanel()) {
                        STPSettingsPage.this.mToNextPage = false;
                    } else {
                        STPSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mScoringFactorSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mScoringFactorSpinner.setAlignmentX(1.0f);
        this.mScoringFactorLabel.setLabelFor(this.mScoringFactorSpinner.getEditor());
    }

    private void setupAdvancedPanel() {
        this.mAdvancedPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(1, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mAdvancedPanel, (JComponent)this.mAdvancedSetting, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_ADVANCED_DATA_PANEL_TITLE"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAdvMaxMissLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2 * 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mAdvMaxMissSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2 * 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mAdvancedPanel, jPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 3, n2, n2);
        DialogUtil.addUsingGBL(this.mAdvancedPanel, this.mAdvSigLevelLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mAdvancedPanel, (JComponent)this.mAdvSigLevelSpinner, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_ADVANCED_SCORING_PANEL_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mScoringInfo, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mScoringFactorLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2 * 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mScoringFactorSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2 * 2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mAdvancedPanel, jPanel2, gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.setAdvanceTabTraversalOrder();
    }

    private void setupTimeIntervalPanel() {
        this.mTimeIntervalPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2 * 3);
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, this.mTimeFieldTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mTimeFieldTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(250, 80));
        jScrollPane.setPreferredSize(new Dimension(250, 80));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2, n2 * 10);
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mTimeIntervalComboLabel, this.mTimeIntervalCombo}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mTimeStartSpinLabel, this.mTimeStartSpinner}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mTimeIncreSpinLabel, this.mTimeIncreSpinner}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mNumDaysSpinLabel, this.mNumDaysSpinner}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mWeekBeginComboLabel, this.mWeekBeginCombo}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mNumHourSpinLabel, this.mNumHourSpinner}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2 * 4, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mDayBeginSpinLabel, this.mDayBeginSpinner}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 8, 1, 1, n, insets);
        this.setTimeTabTraversalOrder(false);
    }

    private void setupTimeIntervalCyclicPanel() {
        this.mTimeIntervalPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, n2, n2, n2 * 3);
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, this.mTimeCyclicInfo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_FIRST_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, this.mFirstCycleTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mFirstCycleTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(120, 100));
        jScrollPane.setPreferredSize(new Dimension(120, 100));
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mFirstCycleLengthLabel, this.mFirstCycleLength}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_SECOND_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel2, this.mSecondCycleTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSecondCycleTable, 20, 31);
        jScrollPane2.setMinimumSize(new Dimension(120, 100));
        jScrollPane2.setPreferredSize(new Dimension(120, 100));
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel2, jScrollPane2, gridBagConstraints, 0, 1, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, PanelFactory.getBasicPanel(new JComponent[]{this.mSecondCycleLengthLabel, this.mSecondCycleLength}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, PanelFactory.getBasicPanel(new JComponent[]{this.mSecondStartSpinLabel, this.mSecondStartSpinner}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_TIME_INTERVAL_CYCLIC_THIRD_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel3, this.mThirdCycleTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane3 = new JScrollPane(this.mThirdCycleTable, 20, 31);
        jScrollPane3.setMinimumSize(new Dimension(120, 100));
        jScrollPane3.setPreferredSize(new Dimension(120, 100));
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2, n2 * 3);
        DialogUtil.addUsingGBL(jPanel3, jScrollPane3, gridBagConstraints, 0, 1, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, PanelFactory.getBasicPanel(new JComponent[]{this.mThirdStartSpinLabel, this.mThirdStartSpinner}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTimeIntervalPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mCyclicIncreSpinLabel, this.mCyclicIncreSpinner}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.setTimeTabTraversalOrder(true);
    }

    private void setupAggregationPanel() {
        this.mAggregationPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mAggregationPanel, (JComponent)this.mTimeAggregFun, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 4, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mAggregationPanel, this.mTimeContComboLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mAggregationPanel, this.mTimeContCombo, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 4, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mAggregationPanel, this.mTimeOrdinalLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2 * 4, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mAggregationPanel, this.mTimeOrdinalCombo, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 * 6, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mAggregationPanel, this.mFieldAndFunctionTableLabel, gridBagConstraints, 0, 4, 2, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        JScrollPane jScrollPane = new JScrollPane(this.mFieldAndFunctionTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(250, 180));
        jScrollPane.setPreferredSize(new Dimension(250, 180));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mFieldSelectButton, this.mDeleteButton}, PanelFactory.PanelType.yaxis, ""), gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2 * 2, n2 * 10);
        DialogUtil.addUsingGBL(this.mAggregationPanel, jPanel, gridBagConstraints, 0, 5, 2, 1, n, insets);
        this.setAggrTabTraversalOrder();
    }

    private void setupOutputPanel() {
        this.mOutputPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, n2, n2, 0);
        DialogUtil.addUsingGBL(this.mOutputPanel, (JComponent)this.mOutputSetting, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, 0, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLocationSpinLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2 * 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLocationSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, 0, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mMaxClusterSpinLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2 * 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMaxClusterSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_OUTPUT_SPATIAL_PANEL_TITLE"));
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mOutTargetCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mOutCorreCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mOutClusterCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets.set(n2, n2 * 5, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, jPanel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, jPanel2, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JPanel jPanel4 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_OUTPUT_MODEL_PANEL_TITLE"));
        insets.set(n2, n2 * 2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel4, this.mOutModelSpecCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mOutTimeInfoSummaryCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mOutLocationSummaryCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mOutModelQualityCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mOutTestEffectCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mOutMeanStrucCheck, gridBagConstraints, 0, 5, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mOutAutoregresCheck, gridBagConstraints, 0, 6, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mOutTestSpatialCheck, gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mOutSpatialParamCheck, gridBagConstraints, 0, 8, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 * 2, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(this.mOutputPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mOutputPanel, jPanel4, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.setOutputTabTraversalOrder();
    }

    private void setupSavePanel() {
        this.mSavePanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, n2, n2, 0);
        DialogUtil.addUsingGBL(this.mSavePanel, (JComponent)this.mSaveSetting, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mSavePanel, this.mSaveMapCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMapFileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mMapFileField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMapFileButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2 * 6, n2, n2);
        DialogUtil.addUsingGBL(this.mSavePanel, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 11, n2 * 4, n2);
        DialogUtil.addUsingGBL(this.mSavePanel, this.mCopyMapCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_SAVE_SCORING_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mNoScoring, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mScoreOpenSet, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mScoreOpenSetNameList, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(280, 80));
        jScrollPane.setPreferredSize(new Dimension(280, 80));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 8, n2, n2 * 10);
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 * 2, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mScoreSPSSData, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2 * 8, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, PanelFactory.getBasicPanel(new JComponent[]{this.mScoreSPSSDataLabel, this.mScoreSPSSDataFileField, this.mBrowseSPSSDataButton}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2 * 8, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, PanelFactory.getBasicPanel(new JComponent[]{this.mNewScoreSPSSDataLabel, this.mNewScoreSPSSDataFileField, this.mBrowseNewScoredButton}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 * 3, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mSavePanel, jPanel2, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.setSaveTabTraversalOrder();
    }

    private void setupModelOptionPanel() {
        this.mModelOptionPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(this.mModelOptionPanel, (JComponent)this.mModelOpSetting, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_MODEL_OPTION_SETTING_TITLE"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mModelAutoCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mModelMaxLagSpinLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mModelMaxLagSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 * 2, n2, n2 * 3, n2 * 5);
        DialogUtil.addUsingGBL(this.mModelOptionPanel, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mModelConfSpinLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mModelConfSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2 * 2, n2, n2 * 3, n2 * 5);
        DialogUtil.addUsingGBL(this.mModelOptionPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STP_SETTING_MODEL_OPTION_SPITIAL_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mModelSpatialSetting, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 4, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mParametricRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 12, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mParamModelComboLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mParamModelCombo, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel4 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, 0, n2 * 2, n2);
        DialogUtil.addUsingGBL(jPanel4, this.mPowerSpinLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2 * 2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel4, (JComponent)this.mPowerSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2 * 12, n2 * 3, n2);
        DialogUtil.addUsingGBL(jPanel3, jPanel4, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 4, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mNonParamRadio, gridBagConstraints, 0, 4, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2, n2 * 2, n2 * 5);
        DialogUtil.addUsingGBL(this.mModelOptionPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setModelTabTraversalOrder();
    }

    private Vector<String> getFieldNames() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
            vector.add(iSpssDataSrc.getVariable(i).getName());
        }
        return vector;
    }

    private void enableOutMapPanelControls() {
        if (this.mOutClusterCheck.isSelected()) {
            this.mLocationSpinLabel.setEnabled(true);
            this.mLocationSpinner.setEnabled(true);
            this.mMaxClusterSpinLabel.setEnabled(true);
            this.mMaxClusterSpinner.setEnabled(true);
        } else {
            this.mLocationSpinLabel.setEnabled(false);
            this.mLocationSpinner.setEnabled(false);
            this.mMaxClusterSpinLabel.setEnabled(false);
            this.mMaxClusterSpinner.setEnabled(false);
        }
    }

    private Vector<ISpssVariable> getUnUsedVars() {
        int n = this.mFieldAndFunctionTableModel.getRowCount();
        if (n == 0) {
            return this.mContextSourceVars;
        }
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < this.mContextSourceVars.size(); ++i) {
            if (this.mVarInAggreTable.contains(this.mContextSourceVars.get(i))) continue;
            vector.add(this.mContextSourceVars.get(i));
        }
        return vector;
    }

    private void deleteOneRowFromTable() {
        int n = this.mFieldAndFunctionTable.getSelectedRow();
        if (n >= 0) {
            this.mFieldAndFunctionTableModel.removeRow(n);
        }
    }

    private void addVarsToAggregationTable(ISpssVariable[] iSpssVariableArray) {
        if (iSpssVariableArray == null || iSpssVariableArray.length == 0) {
            return;
        }
        if (this.mVarInAggreTable == null) {
            this.mVarInAggreTable = new Vector();
        }
        int n = iSpssVariableArray.length;
        for (int i = 0; i < n; ++i) {
            DefaultCellEditor defaultCellEditor;
            String string;
            Vector<String> vector = new Vector<String>();
            ISpssVariable iSpssVariable = iSpssVariableArray[i];
            MeasurementLevel measurementLevel = iSpssVariable.getMeasurementLevel();
            if (measurementLevel == MeasurementLevel.nominal) continue;
            String string2 = ((STEMWizardDlg)this.mWizardDialog).getSTPDefineRolePage().getDataSourceIdFor(iSpssVariable);
            vector.add(string2);
            vector.add(iSpssVariable.getName());
            if (measurementLevel == MeasurementLevel.ordinal) {
                string = this.mOrdinalAggreArray[0];
                defaultCellEditor = new DefaultCellEditor(new JComboBox<String>(new DefaultComboBoxModel<String>(this.mOrdinalAggreArray)));
            } else {
                string = this.mContAggreArray[0];
                defaultCellEditor = new DefaultCellEditor(new JComboBox<String>(new DefaultComboBoxModel<String>(this.mContAggreArray)));
            }
            vector.add(string);
            int n2 = this.mFieldAndFunctionTableModel.getRowCount();
            this.mFieldAndFunctionTableModel.addRow(vector);
            this.mFieldFunTableCellEditor.addRowEditor(n2, defaultCellEditor);
            this.mVarInAggreTable.add(iSpssVariable);
        }
        this.mFieldAndFunctionTable.getColumnModel().getColumn(2).setCellEditor(this.mFieldFunTableCellEditor);
    }

    private void enableSpatialCovarPanel() {
        if (this.mParametricRadio.isSelected()) {
            this.mParamModelComboLabel.setEnabled(true);
            this.mParamModelCombo.setEnabled(true);
            if (this.mParamModelCombo.getSelectedIndex() == 1) {
                this.mPowerSpinLabel.setEnabled(true);
                this.mPowerSpinner.setEnabled(true);
            } else {
                this.mPowerSpinLabel.setEnabled(false);
                this.mPowerSpinner.setEnabled(false);
            }
        } else {
            this.mParamModelComboLabel.setEnabled(false);
            this.mParamModelCombo.setEnabled(false);
            this.mPowerSpinLabel.setEnabled(false);
            this.mPowerSpinner.setEnabled(false);
        }
    }

    private void enableScoringPanelControls() {
        if (this.mNoScoring.isSelected()) {
            this.mScoreOpenSetNameList.setEnabled(false);
            this.mBrowseSPSSDataButton.setEnabled(false);
            this.mScoreSPSSDataLabel.setEnabled(false);
            this.mScoreSPSSDataFileField.setEnabled(false);
            this.mBrowseNewScoredButton.setEnabled(false);
            this.mNewScoreSPSSDataLabel.setEnabled(false);
            this.mNewScoreSPSSDataFileField.setEnabled(false);
        } else if (this.mScoreOpenSet.isSelected()) {
            this.mScoreOpenSetNameList.setEnabled(true);
            this.mBrowseSPSSDataButton.setEnabled(false);
            this.mScoreSPSSDataLabel.setEnabled(false);
            this.mScoreSPSSDataFileField.setEnabled(false);
            this.mBrowseNewScoredButton.setEnabled(false);
            this.mNewScoreSPSSDataLabel.setEnabled(false);
            this.mNewScoreSPSSDataFileField.setEnabled(false);
        } else if (this.mScoreSPSSData.isSelected()) {
            this.mScoreOpenSetNameList.setEnabled(false);
            this.mBrowseSPSSDataButton.setEnabled(true);
            this.mScoreSPSSDataLabel.setEnabled(true);
            this.mScoreSPSSDataFileField.setEnabled(true);
            this.mBrowseNewScoredButton.setEnabled(true);
            this.mNewScoreSPSSDataLabel.setEnabled(true);
            this.mNewScoreSPSSDataFileField.setEnabled(true);
        }
    }

    private void enableSecondCycleAndStartValue() {
        boolean bl = false;
        int n = 0;
        for (n = 0; n < this.mSecondCycleTableModel.getRowCount(); ++n) {
            Object object = this.mSecondCycleTableModel.getValueAt(n, 1);
            if (object == null || object.toString().length() <= 0) continue;
            bl = true;
            break;
        }
        this.mFirstCycleLengthLabel.setEnabled(bl);
        this.mFirstCycleLength.getEditor().setEnabled(bl);
        this.mSecondStartSpinLabel.setEnabled(bl);
        this.mSecondStartSpinner.getEditor().setEnabled(bl);
    }

    private void enableThirdCycleAndStartValue() {
        boolean bl = false;
        int n = 0;
        for (n = 0; n < this.mThirdCycleTableModel.getRowCount(); ++n) {
            Object object = this.mThirdCycleTableModel.getValueAt(n, 1);
            if (object == null || object.toString().length() <= 0) continue;
            bl = true;
            break;
        }
        this.mSecondCycleLengthLabel.setEnabled(bl);
        this.mSecondCycleLength.getEditor().setEnabled(bl);
        this.mThirdStartSpinLabel.setEnabled(bl);
        this.mThirdStartSpinner.getEditor().setEnabled(bl);
    }

    private boolean isFirstTableValueValid() {
        if (this.mFirstCycleTableModel == null) {
            return false;
        }
        int n = this.mFirstCycleTableModel.getRowCount();
        if (n == 0) {
            return true;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.mFirstCycleTableModel.getValueAt(i, 1) == null || this.mFirstCycleTableModel.getValueAt(i, 1).toString().length() <= 0) continue;
            ++n2;
        }
        return n2 > 0;
    }

    private boolean isTableValueValid(DefaultTableModel defaultTableModel) {
        int n = defaultTableModel.getRowCount();
        if (n == 0) {
            return true;
        }
        Object object = defaultTableModel.getValueAt(0, 1);
        boolean bl = false;
        if (object != null && object.toString().length() > 0) {
            bl = true;
        }
        for (int i = 1; i < defaultTableModel.getRowCount(); ++i) {
            Object object2 = defaultTableModel.getValueAt(i, 1);
            if ((!bl || object2 != null && object2.toString().length() != 0) && (bl || object2 == null || object2.toString().length() <= 0)) continue;
            return false;
        }
        return true;
    }

    public boolean enableNextButton() {
        boolean bl = true;
        if (this.mIsTimeStamp) {
            int n = this.mTimeIntervalCombo.getSelectedIndex();
            bl = this.mTimeIntervalCombo.getModel().getSize() > 1 ? n > 0 : n >= 0;
        } else {
            bl = this.isFirstTableValueValid();
            if (bl) {
                bl = this.isTableValueValid(this.mSecondCycleTableModel);
            }
            if (bl) {
                bl = this.isTableValueValid(this.mThirdCycleTableModel);
            }
        }
        return bl && this.validate();
    }

    private void enableTimeIntervalControls() {
        if (this.mTimeIntervalCombo == null || this.mTimeIntervalCombo.getModel().getSize() == 1) {
            return;
        }
        int n = this.mTimeIntervalCombo.getSelectedIndex();
        this.mTimeStartSpinLabel.setEnabled(false);
        this.mTimeStartSpinner.setEnabled(false);
        this.mTimeIncreSpinLabel.setEnabled(false);
        this.mTimeIncreSpinner.setEnabled(false);
        this.mNumDaysSpinLabel.setEnabled(false);
        this.mNumDaysSpinner.setEnabled(false);
        this.mWeekBeginComboLabel.setEnabled(false);
        this.mWeekBeginCombo.setEnabled(false);
        this.mNumHourSpinLabel.setEnabled(false);
        this.mNumHourSpinner.setEnabled(false);
        this.mDayBeginSpinLabel.setEnabled(false);
        this.mDayBeginSpinner.setEnabled(false);
        switch (n) {
            case 1: 
            case 3: {
                this.mTimeIncreSpinLabel.setEnabled(true);
                this.mTimeIncreSpinner.setEnabled(true);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.mNumDaysSpinLabel.setEnabled(true);
                this.mNumDaysSpinner.setEnabled(true);
                this.mWeekBeginComboLabel.setEnabled(true);
                this.mWeekBeginCombo.setEnabled(true);
                this.mTimeIncreSpinLabel.setEnabled(true);
                this.mTimeIncreSpinner.setEnabled(true);
                break;
            }
            case 6: {
                this.mNumDaysSpinLabel.setEnabled(true);
                this.mNumDaysSpinner.setEnabled(true);
                this.mWeekBeginComboLabel.setEnabled(true);
                this.mWeekBeginCombo.setEnabled(true);
                this.mNumHourSpinLabel.setEnabled(true);
                this.mNumHourSpinner.setEnabled(true);
                this.mDayBeginSpinLabel.setEnabled(true);
                this.mDayBeginSpinner.setEnabled(true);
                this.mTimeIncreSpinLabel.setEnabled(true);
                this.mTimeIncreSpinner.setEnabled(true);
                break;
            }
            case 7: {
                this.mTimeStartSpinLabel.setEnabled(false);
                this.mTimeStartSpinner.setEnabled(false);
                this.mNumDaysSpinLabel.setEnabled(true);
                this.mNumDaysSpinner.setEnabled(true);
                this.mWeekBeginComboLabel.setEnabled(true);
                this.mWeekBeginCombo.setEnabled(true);
                this.mNumHourSpinLabel.setEnabled(true);
                this.mNumHourSpinner.setEnabled(true);
                this.mDayBeginSpinLabel.setEnabled(true);
                this.mDayBeginSpinner.setEnabled(true);
                break;
            }
            case 8: {
                this.mTimeStartSpinLabel.setEnabled(true);
                this.mTimeStartSpinner.setEnabled(true);
                this.mNumDaysSpinLabel.setEnabled(true);
                this.mNumDaysSpinner.setEnabled(true);
                this.mWeekBeginComboLabel.setEnabled(true);
                this.mWeekBeginCombo.setEnabled(true);
                this.mNumHourSpinLabel.setEnabled(true);
                this.mNumHourSpinner.setEnabled(true);
                this.mDayBeginSpinLabel.setEnabled(true);
                this.mDayBeginSpinner.setEnabled(true);
                break;
            }
            case 9: {
                this.mTimeIncreSpinLabel.setEnabled(true);
                this.mTimeIncreSpinner.setEnabled(true);
                break;
            }
            case 10: {
                this.mTimeIncreSpinLabel.setEnabled(true);
                this.mTimeIncreSpinner.setEnabled(true);
                break;
            }
            case 11: {
                this.mTimeIncreSpinLabel.setEnabled(true);
                this.mTimeIncreSpinner.setEnabled(true);
                break;
            }
            case 12: {
                this.mTimeIncreSpinLabel.setEnabled(true);
                this.mTimeIncreSpinner.setEnabled(true);
            }
        }
        boolean bl = this.enableNextButton();
        this.mWizardDialog.enableNext(bl);
        this.mWizardDialog.enableFinish(bl);
    }

    String getAggregationSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n /AGGREGATION");
        stringBuffer.append(" CONTINUOUS=");
        stringBuffer.append(STEMWizardDlg.getContAggregationSyntax(this.mTimeContCombo.getSelectedIndex()));
        stringBuffer.append(" ORDINAL=");
        stringBuffer.append(STEMWizardDlg.getOrdinalSyntax(this.mTimeOrdinalCombo.getSelectedIndex()));
        return stringBuffer.toString();
    }

    String getAggreExceptionSyntax(String string) {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string2 = "";
        for (int i = 0; i < this.mFieldAndFunctionTable.getRowCount(); ++i) {
            String string3;
            String string4 = this.mFieldAndFunctionTable.getValueAt(i, 0).toString();
            if (!string4.equals(string)) continue;
            String string5 = this.mFieldAndFunctionTable.getValueAt(i, 1).toString();
            String string6 = this.mFieldAndFunctionTable.getValueAt(i, 2).toString();
            if (string5.length() <= 0 || (string3 = ((STEMWizardDlg)this.mWizardDialog).getAggregationSyntax(string6)).length() <= 0) continue;
            string2 = string2 + " " + string5 + "(" + string3 + ") ";
        }
        if (string2.length() > 0) {
            stringBuffer.append(" AGGEXCEPTIONS =" + string2);
        }
        return stringBuffer.toString();
    }

    String getSTPSettingsSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(this.getTimeIntervalSyntax());
        stringBuffer.append(this.getModelOptionSyntax());
        stringBuffer.append(this.generateOutputPanelSyntax());
        stringBuffer.append(this.getSaveSyntax());
        return stringBuffer.toString();
    }

    private String getTimeIntervalSyntax() {
        String string = this.mIsTimeStamp ? this.getTimeFieldSyntax() : this.getCyclicFieldSyntax();
        return string;
    }

    String getCyclicFields(String string) {
        String string2 = "";
        string2 = this.getFromFirstTable(this.mFirstCycleTable, string);
        if (string2.length() == 0) {
            return string2;
        }
        String string3 = this.getFromTable(this.mSecondCycleTable, string);
        if (string3.length() > 0) {
            string2 = string2 + " " + string3;
        }
        if ((string3 = this.getFromTable(this.mThirdCycleTable, string)).length() > 0) {
            string2 = string2 + " " + string3;
        }
        return string2;
    }

    private String getFromTable(JTable jTable, String string) {
        String string2 = "";
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            Object object;
            TableCellEditor tableCellEditor;
            if (!string.equals(jTable.getValueAt(i, 0).toString()) || (tableCellEditor = jTable.getCellEditor(i, 1)) == null || (object = tableCellEditor.getCellEditorValue()) == null || object.toString().length() <= 0) continue;
            string2 = object.toString();
            break;
        }
        return string2;
    }

    private String getFromFirstTable(JTable jTable, String string) {
        String string2 = "";
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            Object object;
            boolean bl;
            if (!string.equals(jTable.getValueAt(i, 0).toString()) || !(bl = true) || (object = jTable.getValueAt(i, 1)) == null || object.toString().length() <= 0) continue;
            string2 = object.toString();
            break;
        }
        return string2;
    }

    private void updateOpenDataSetList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        Vector<String> vector = this.getDataSetList();
        for (String string : vector) {
            defaultListModel.addElement(string);
        }
        this.mScoreOpenSetNameList.setModel(defaultListModel);
        if (defaultListModel.getSize() == 0) {
            this.mScoreOpenSet.setEnabled(false);
            this.mScoreOpenSetNameList.setEnabled(false);
        }
    }

    private Vector<String> getDataSetList() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        String string = DataMgr.getDataMgr().getDataSource(locallyUniqueId).getDatasetName();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        this.mOpenDataset = new Vector();
        for (SpssFrame spssFrame : spssFrameArray) {
            String string2;
            if (!(spssFrame instanceof DataFrame)) continue;
            DataFrame dataFrame = (DataFrame)spssFrame;
            String string3 = dataFrame.getCoreDocument().getDocName();
            File file = dataFrame.getCoreDocument().getFileSpec();
            LocallyUniqueId locallyUniqueId2 = ((DataDocument)dataFrame.getCoreDocument()).getDataSrc().getDataSetId();
            String string4 = dataFrame.getDatasetName();
            String string5 = "";
            if (file != null) {
                string5 = file.getAbsolutePath();
                string2 = string3;
            } else {
                string2 = string4;
            }
            if (string.equals(string4) || ((STEMWizardDlg)this.mWizardDialog).getContextPage().isOpenDatasetUsedInSTP(locallyUniqueId2)) continue;
            vector.add(string3 + " [" + string4 + "]");
            String string6 = STEMUtil.removeSpaceFrom(string4);
            ContextDataItem contextDataItem = new ContextDataItem(string6, string5, string2, true, true, "", ContextDataItem.DataType.DATASET, "");
            contextDataItem.setDataSetName(string4);
            contextDataItem.setDatasetUID(dataFrame.getDatasetId());
            this.mOpenDataset.add(n, contextDataItem);
            ++n;
        }
        return vector;
    }

    private boolean isSelectedFileOnRemoteHost(RemoteFileChooser.ChooserType chooserType, String string, String string2, String string3, JTextField jTextField, JTextField jTextField2) {
        int n;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(chooserType, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.mWizardDialog.getResString(string));
        String[] stringArray = this.mWizardDialog.getResStringArray(string2);
        String[] stringArray2 = this.mWizardDialog.getResStringArray(string3);
        for (n = 1; n < stringArray.length; ++n) {
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(stringArray[n], stringArray2[n]));
        }
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(stringArray[0], stringArray2[0]));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileSelectionMode(0);
        n = remoteFileChooser.showOpenDialog((Component)((Object)this.mWizardDialog));
        if (n == 0) {
            String string4;
            int n2;
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string5 = remoteFileChooser.getSelectedFilePath();
            jTextField.setText(string5);
            if (jTextField2 != null && jTextField2.getText().length() == 0 && (n2 = (string4 = remoteFileChooser.getSelectedFileName()).indexOf(stringArray2[0])) >= 0) {
                String string6 = string4.substring(0, n2);
                String string7 = string6 + sNewScoreFile + stringArray2[0];
                String string8 = remoteFileChooser.getCurrentDirectory().getAbsolutePath();
                jTextField2.setText(string8 + File.separator + string7);
            }
        }
        return remoteFileChooser.isServerFileSystem();
    }

    ContextDataItem getDataSourceFromScore() {
        this.mSelectedFile = null;
        if (this.mScoreOpenSet.isSelected()) {
            int n = this.mScoreOpenSetNameList.getSelectedIndex();
            if (n >= 0) {
                this.mSelectedFile = this.mOpenDataset.get(n);
            }
        } else if (this.mScoreSPSSData.isSelected()) {
            String string = this.mScoreSPSSDataFileField.getText();
            File file = new File(string);
            String string2 = file.getName();
            String string3 = string2.substring(0, string2.length() - 4);
            string3 = STEMUtil.removeSpaceFrom(string3);
            this.mSelectedFile = new ContextDataItem(string3, string, string2, false, true, "", ContextDataItem.DataType.FILE, "");
        }
        return this.mSelectedFile;
    }

    private String getTimeFieldSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n /TIMEFIELDS");
        int n = this.mTimeIntervalCombo.getSelectedIndex();
        stringBuffer.append(" INPUTINTERVAL=");
        String string = ((JTextField)this.mTimeIncreSpinner.getEditor()).getText();
        if (this.mTimeIntervalCombo.getModel().getSize() > 1) {
            switch (n) {
                case 1: {
                    stringBuffer.append("YEAR INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 2: {
                    stringBuffer.append("QUARTER");
                    break;
                }
                case 3: {
                    stringBuffer.append("MONTH INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 4: {
                    stringBuffer.append("WEEK");
                    break;
                }
                case 5: {
                    stringBuffer.append("DAY");
                    stringBuffer.append(" DAYSWK=");
                    stringBuffer.append(((JTextField)this.mNumDaysSpinner.getEditor()).getText());
                    stringBuffer.append(" WKSTART=");
                    stringBuffer.append(this.getWeekStartSyntax(this.mWeekBeginCombo.getSelectedIndex()));
                    stringBuffer.append(" INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 6: {
                    stringBuffer.append("HOUR");
                    stringBuffer.append(" DAYSWK=");
                    stringBuffer.append(((JTextField)this.mNumDaysSpinner.getEditor()).getText());
                    stringBuffer.append(" WKSTART=");
                    stringBuffer.append(this.getWeekStartSyntax(this.mWeekBeginCombo.getSelectedIndex()));
                    stringBuffer.append(" HRSDAY=");
                    stringBuffer.append(((JTextField)this.mNumHourSpinner.getEditor()).getText());
                    stringBuffer.append(" DAYSTART=");
                    stringBuffer.append(((JTextField)this.mDayBeginSpinner.getEditor()).getText());
                    stringBuffer.append(" INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 7: {
                    stringBuffer.append("MINUTE");
                    stringBuffer.append(" DAYSWK=");
                    stringBuffer.append(((JTextField)this.mNumDaysSpinner.getEditor()).getText());
                    stringBuffer.append(" WKSTART=");
                    stringBuffer.append(this.getWeekStartSyntax(this.mWeekBeginCombo.getSelectedIndex()));
                    stringBuffer.append(" HRSDAY=");
                    stringBuffer.append(((JTextField)this.mNumHourSpinner.getEditor()).getText());
                    stringBuffer.append(" DAYSTART=");
                    stringBuffer.append(((JTextField)this.mDayBeginSpinner.getEditor()).getText());
                    stringBuffer.append(" INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 8: {
                    stringBuffer.append("SECOND");
                    stringBuffer.append(" DAYSWK=");
                    stringBuffer.append(((JTextField)this.mNumDaysSpinner.getEditor()).getText());
                    stringBuffer.append(" WKSTART=");
                    stringBuffer.append(this.getWeekStartSyntax(this.mWeekBeginCombo.getSelectedIndex()));
                    stringBuffer.append(" HRSDAY=");
                    stringBuffer.append(((JTextField)this.mNumHourSpinner.getEditor()).getText());
                    stringBuffer.append(" DAYSTART=");
                    stringBuffer.append(((JTextField)this.mDayBeginSpinner.getEditor()).getText());
                    stringBuffer.append(" INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 9: {
                    stringBuffer.append("DURATION INTERVAL=HOURS INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 10: {
                    stringBuffer.append("DURATION INTERVAL=MINUTES INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 11: {
                    stringBuffer.append("DURATION INTERVAL=SECONDS INCREMENT=");
                    stringBuffer.append(string);
                    break;
                }
                case 12: {
                    stringBuffer.append("PERIOD INCREMENT=");
                    stringBuffer.append(string);
                }
            }
        } else {
            stringBuffer.append("PERIOD INCREMENT=");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String getWeekStartSyntax(int n) {
        switch (n) {
            case 0: {
                return "SUN";
            }
            case 1: {
                return "MON";
            }
            case 2: {
                return "TUE";
            }
            case 3: {
                return "WED";
            }
            case 4: {
                return "THU";
            }
            case 5: {
                return "FRI";
            }
            case 6: {
                return "SAT";
            }
        }
        return "MON";
    }

    private String getCyclicFieldSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n /TIMEFIELDS");
        int n = this.mTimeIntervalCombo.getSelectedIndex();
        stringBuffer.append(" INPUTINTERVAL=PERIOD");
        String string = ((JTextField)this.mCyclicIncreSpinner.getEditor()).getText();
        stringBuffer.append(" INCREMENT=" + string);
        String string2 = "";
        if (this.mSecondStartSpinner.getEditor().isEnabled()) {
            string2 = string2 + ((JTextField)this.mSecondStartSpinner.getEditor()).getText();
        }
        if (this.mThirdStartSpinner.getEditor().isEnabled()) {
            string2 = string2 + " " + ((JTextField)this.mThirdStartSpinner.getEditor()).getText();
        }
        if (string2.length() > 0) {
            stringBuffer.append(" START=" + string2);
        }
        String string3 = "";
        if (this.mFirstCycleLength.getEditor().isEnabled()) {
            string3 = string3 + " " + ((JTextField)this.mFirstCycleLength.getEditor()).getText();
        }
        if (this.mSecondCycleLength.getEditor().isEnabled()) {
            string3 = string3 + " " + ((JTextField)this.mSecondCycleLength.getEditor()).getText();
        }
        if (string3.length() > 0) {
            stringBuffer.append(" LENGTH=" + string3);
        }
        return stringBuffer.toString();
    }

    private String getModelOptionSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n /MODELBUILDING");
        stringBuffer.append(" SIGNIFICANCE=");
        stringBuffer.append(((JTextField)this.mAdvSigLevelSpinner.getEditor()).getText());
        stringBuffer.append(" INTERCEPT=");
        if (this.mModelAutoCheck.isSelected()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        stringBuffer.append(" COVARIANCE=");
        if (this.mParametricRadio.isSelected()) {
            stringBuffer.append("VARIOGRAM(");
            int n = this.mParamModelCombo.getSelectedIndex();
            switch (n) {
                case 0: {
                    stringBuffer.append("1");
                    break;
                }
                case 1: {
                    stringBuffer.append(((JTextField)this.mPowerSpinner.getEditor()).getText());
                    break;
                }
                case 2: {
                    stringBuffer.append("2");
                }
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append("EMPIRICAL");
        }
        stringBuffer.append(" AUTOREGRESSIONLAG=");
        stringBuffer.append(((JTextField)this.mModelMaxLagSpinner.getEditor()).getText());
        stringBuffer.append(" MISSINGRECORDS=");
        double d = (double)Integer.parseInt(((JTextField)this.mAdvMaxMissSpinner.getEditor()).getText()) / 100.0;
        stringBuffer.append(d);
        stringBuffer.append(" CONFIDENCEINTERVAL=");
        d = (double)Integer.parseInt(((JTextField)this.mModelConfSpinner.getEditor()).getText()) / 100.0;
        stringBuffer.append(d);
        stringBuffer.append(" UNCERTAINTY=");
        d = (double)Integer.parseInt(((JTextField)this.mScoringFactorSpinner.getEditor()).getText()) / 100.0;
        stringBuffer.append(d);
        return stringBuffer.toString();
    }

    private String generateOutputPanelSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        stringBuffer2.append("\n /MODELTABLES ");
        stringBuffer2.append(" SPECIFICATIONS=");
        if (this.mOutModelSpecCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer2.append(" TEMPORALINFO=");
        if (this.mOutTimeInfoSummaryCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer2.append(" LOCATIONS=");
        if (this.mOutLocationSummaryCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer2.append(" QUALITY=");
        if (this.mOutModelQualityCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer2.append(" EFFECTS=");
        if (this.mOutTestEffectCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer2.append(" MEANSTRUCTURE=");
        if (this.mOutMeanStrucCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer2.append(" COEFFICIENTS=");
        if (this.mOutAutoregresCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer2.append(" COVARIANCE=");
        if (this.mOutTestSpatialCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer2.append(" PARAMETRIC=");
        if (this.mOutSpatialParamCheck.isSelected()) {
            stringBuffer2.append("YES");
        } else {
            stringBuffer2.append("NO");
        }
        stringBuffer.append(stringBuffer2);
        StringBuffer stringBuffer3 = SyntaxUtil.startSyntax();
        stringBuffer3.append("\n /MAPOUTPUT");
        stringBuffer3.append(" TARGETVALUES=");
        if (this.mOutTargetCheck.isSelected()) {
            stringBuffer3.append("YES");
        } else {
            stringBuffer3.append("NO");
        }
        stringBuffer3.append(" CORRELATIONS=");
        if (this.mOutCorreCheck.isSelected()) {
            stringBuffer3.append("YES");
        } else {
            stringBuffer3.append("NO");
        }
        stringBuffer3.append(" CLUSTERS=");
        if (this.mOutClusterCheck.isSelected()) {
            stringBuffer3.append("YES");
            stringBuffer3.append(" SIMILARITY=" + ((JTextField)this.mLocationSpinner.getEditor()).getText());
            stringBuffer3.append(" MAXCLUSTERS=" + ((JTextField)this.mMaxClusterSpinner.getEditor()).getText());
        } else {
            stringBuffer3.append("NO");
        }
        stringBuffer.append(stringBuffer3);
        return stringBuffer.toString();
    }

    private String getSaveSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n /SAVE SCORE=");
        if (this.mNoScoring.isSelected()) {
            stringBuffer.append("NO");
        } else {
            stringBuffer.append("YES");
            if (this.mSelectedFile == null) {
                this.mSelectedFile = this.getDataSourceFromScore();
            }
            if (this.mSelectedFile != null) {
                if (this.mScoreOpenSet.isSelected()) {
                    stringBuffer.append(" SOURCESTOSCORE=");
                    stringBuffer.append(this.mSelectedFile.getSourceId());
                    stringBuffer.append("(");
                    stringBuffer.append(this.mSelectedFile.getDataSetName());
                    stringBuffer.append(")");
                } else if (this.mScoreSPSSData.isSelected()) {
                    stringBuffer.append(" SOURCESTOSCORE=");
                    stringBuffer.append(this.mSelectedFile.getSourceId());
                    stringBuffer.append("(\"");
                    stringBuffer.append(this.mNewScoreSPSSDataFileField.getText());
                    stringBuffer.append("\")");
                }
            }
        }
        return stringBuffer.toString();
    }

    String getMapSpecFilePath() {
        if (this.mSaveMapCheck.isSelected()) {
            return this.mMapFileField.getText();
        }
        return sDefaultSpecName;
    }

    String getMapSpecSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n /SPECFILE FILE=\"");
        if (this.mSaveMapCheck.isSelected()) {
            stringBuffer.append(this.mMapFileField.getText()).append("\"");
            stringBuffer.append(" DISPLAY=YES");
            stringBuffer.append(" SAVEDATA=");
            if (this.mCopyMapCheck.isSelected()) {
                stringBuffer.append("YES");
            } else {
                stringBuffer.append("NO");
            }
        } else {
            stringBuffer.append(sDefaultSpecName).append("\"");
            stringBuffer.append(" DISPLAY=NO");
            stringBuffer.append(" SAVEDATA=NO");
        }
        return stringBuffer.toString();
    }

    private static void createTimeIntervalValueMap() {
        int n = 0;
        sTimeIntervalMap.put("", n++);
        sTimeIntervalMap.put("YEAR", n++);
        sTimeIntervalMap.put("QUARTER", n++);
        sTimeIntervalMap.put("MONTH", n++);
        sTimeIntervalMap.put("WEEK", n++);
        sTimeIntervalMap.put("DAY", n++);
        sTimeIntervalMap.put("HOUR", n++);
        sTimeIntervalMap.put("MINUTE", n++);
        sTimeIntervalMap.put("SECOND", n++);
        sTimeIntervalMap.put("HOUR_NONPERIOD", n++);
        sTimeIntervalMap.put("MINUTE_NONPERIOD", n++);
        sTimeIntervalMap.put("SECOND_NONPERIOD", n++);
    }
}

