/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ASMapsError;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.STEM.ContextDataItem;
import com.spss.java_client.ui.dialogs.STEM.STEMDataSourcePage;
import com.spss.java_client.ui.dialogs.STEM.STEMSelectRolePage;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.shared.core_tools.utils.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.Bidi;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class STPDefineRolePage
extends STEMSelectRolePage
implements ListDataListener,
ItemListener,
ListSelectionListener,
IVarMoveHandler,
IVarFilter {
    protected static Border sNoFocusBorder = null;
    protected static Border sFocusBorder = null;
    private JLabel mTargetVarListLabel;
    private TargetVariableList mTargetVarList;
    private JScrollPane mTargetVarListScrollPane;
    private ArrowButton mTargetArrowButton;
    private JLabel mPredicVarListLabel;
    private TargetVariableList mPredicVarList;
    private ArrowButton mPredicArrowButton;
    private JScrollPane mPredicVarListScrollPane;
    private JRadioButton mTimeStamp;
    private JRadioButton mCyclicPeriod;
    private SpssButtonGroup mTimeButtonGrop;
    private FocusableTextArea mTimeFieldInfo;
    private JLabel mTimeVarListLabel;
    private TargetVariableList mTimeVarList;
    private JScrollPane mTimeeScrollPane;
    private ArrowButton mTimeArrowButton;
    private Vector<STPDataListContainer> mSources;
    private boolean mKeepTargets = false;
    private String mEventDataId;
    private ISpssVariable mKDEVar;
    private ISpssVariable mTimeFieldVar;
    private boolean mUsingKDE;
    private boolean mNextPressed;
    private Vector<String> mAutoInterval = new Vector();
    private Vector<Pair<String, String>> mSourceAndName = new Vector();

    public STPDefineRolePage(BaseWizardDialog baseWizardDialog) {
        super(baseWizardDialog, "STPDefineRolePage");
        this.mSelectedSrcIndex = -1;
        this.mKDEVar = null;
        this.mTimeFieldVar = null;
        this.mNextPressed = false;
        this.mIsPageModified = false;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_stem_stp_fields";
    }

    @Override
    public String getNextPage() {
        ((STEMWizardDlg)this.mWizardDialog).getSTPSettingsPage().setKeepSettings(!this.mIsPageModified);
        return "STPSettingsPage";
    }

    @Override
    public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
        STPDataListContainer sTPDataListContainer;
        if (this.mDataSourceList == null) {
            return false;
        }
        int n = this.mDataSourceList.getSelectedIndex();
        boolean bl = true;
        if (this.mDataSourceList.getModel().getSize() == 3 && n == 0 && (sTPDataListContainer = this.mSources.get(0)).findVariable(iSpssVariable)) {
            return false;
        }
        return bl;
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        ISpssVariable iSpssVariable;
        int n;
        Object object;
        int n2 = this.mDataSourceList.getSelectedIndex();
        boolean bl = true;
        if (n2 > 0) {
            object = this.mSources.get(n2 - 1);
            if (variableList instanceof SrcVariableList) {
                ISpssVariable[] iSpssVariableArray2 = iSpssVariableArray;
                n = iSpssVariableArray2.length;
                for (int i = 0; i < n; ++i) {
                    iSpssVariable = iSpssVariableArray2[i];
                    if (((STPDataListContainer)object).findVariable(iSpssVariable)) continue;
                    bl = false;
                    break;
                }
            }
            if (this.mSources.size() > 1 && variableList == this.mPredicVarList && n2 == 1) {
                return false;
            }
        } else {
            if (this.mUsingKDE && variableList instanceof SrcVariableList) {
                for (ISpssVariable iSpssVariable2 : iSpssVariableArray) {
                    if (iSpssVariable2 != this.mKDEVar && iSpssVariable2 != this.mTimeFieldVar) continue;
                    return false;
                }
            }
            if (variableList == this.mPredicVarList && this.mSources.size() > 1) {
                object = this.mSources.get(0);
                ISpssVariable[] iSpssVariableArray3 = iSpssVariableArray;
                n = iSpssVariableArray3.length;
                for (int i = 0; i < n; ++i) {
                    iSpssVariable = iSpssVariableArray3[i];
                    if (!((STPDataListContainer)object).findVariable(iSpssVariable)) continue;
                    return false;
                }
            }
        }
        if (this.mUsingKDE && variableList instanceof TargetVariableList) {
            for (ISpssVariable iSpssVariable3 : iSpssVariableArray) {
                if (iSpssVariable3 != this.mTimeFieldVar || !variableList.getModel().contains(iSpssVariable3)) continue;
                return false;
            }
        }
        return bl;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mVariableSrcList) && this.mTimeStamp.isSelected() && this.mSelectedSrcIndex >= 0 && this.mSources.size() > 0) {
            STPDataListContainer sTPDataListContainer = null;
            if (this.mSelectedSrcIndex < 0) {
                return;
            }
            if (this.mSelectedSrcIndex == 0) {
                ISpssVariable iSpssVariable = (ISpssVariable)this.mVariableSrcList.getSelectedValue();
                int n = this.findSourceIndex(iSpssVariable);
                if (n < 0) {
                    return;
                }
                sTPDataListContainer = this.mSources.get(n);
            } else if (this.mSelectedSrcIndex - 1 < this.mSources.size()) {
                sTPDataListContainer = this.mSources.get(this.mSelectedSrcIndex - 1);
            }
            if (sTPDataListContainer != null) {
                if (sTPDataListContainer.getTimeFieldModel().getSize() > 0) {
                    this.mTimeArrowButton.setEnabled(false);
                } else {
                    this.mTimeArrowButton.setEnabled(true);
                }
            }
        } else if (listSelectionEvent.getSource() == this.mDataSourceList) {
            int n = this.mDataSourceList.getSelectedIndex();
            this.loadFieldList(n);
            this.mSelectedSrcIndex = n;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mTimeStamp.isSelected()) {
            this.enableTimeFieldPanel(true);
        } else {
            this.enableTimeFieldPanel(false);
        }
        this.mWizardDialog.enableNext(this.enableNextButton());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mTargetVarList.getModel() || object == this.mTimeVarList.getModel() || object == this.mPredicVarList.getModel()) {
            int n = this.mDataSourceList.getSelectedIndex();
            int n2 = listDataEvent.getIndex0();
            if (n2 < 0 || n < 0) {
                return;
            }
            ISpssVariable iSpssVariable = null;
            iSpssVariable = object == this.mTargetVarList.getModel() ? this.mTargetVarList.getModel().getElementAt(n2) : (object == this.mPredicVarList.getModel() ? this.mPredicVarList.getModel().getElementAt(n2) : this.mTimeVarList.getModel().getElementAt(n2));
            STPDataListContainer sTPDataListContainer = null;
            if (n > 0) {
                sTPDataListContainer = this.mSources.get(n - 1);
            } else if (n == 0 && (n = this.findSourceIndex(iSpssVariable)) >= 0) {
                sTPDataListContainer = this.mSources.get(n);
            }
            if (sTPDataListContainer != null && iSpssVariable != null) {
                if (object == this.mTargetVarList.getModel()) {
                    sTPDataListContainer.addTargetField(iSpssVariable);
                    this.mTargetArrowButton.setEnabled(false);
                } else if (object == this.mPredicVarList.getModel()) {
                    sTPDataListContainer.addPredictorField(iSpssVariable);
                } else {
                    sTPDataListContainer.addTimeField(iSpssVariable);
                }
                sTPDataListContainer.removeSourceField(iSpssVariable);
            }
            this.mIsPageModified = true;
        }
        this.mWizardDialog.enableNext(this.enableNextButton());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mTargetVarList.getModel() || object == this.mTimeVarList.getModel() || object == this.mPredicVarList.getModel()) {
            int n = this.mDataSourceList.getSelectedIndex();
            int n2 = listDataEvent.getIndex0();
            if (n2 < 0) {
                return;
            }
            ISpssVariable iSpssVariable = null;
            STPDataListContainer sTPDataListContainer = null;
            iSpssVariable = object == this.mTargetVarList.getModel() ? ((STEMSelectRolePage.STEMVarListModel)this.mTargetVarList.getModel()).getRemovedVar() : (object == this.mPredicVarList.getModel() ? ((STEMSelectRolePage.STEMVarListModel)this.mPredicVarList.getModel()).getRemovedVar() : ((STEMSelectRolePage.STEMVarListModel)this.mTimeVarList.getModel()).getRemovedVar());
            if (n > 0) {
                sTPDataListContainer = this.mSources.get(n - 1);
            } else if (n == 0 && (n = this.findSourceIndex(iSpssVariable)) >= 0) {
                sTPDataListContainer = this.mSources.get(n);
            }
            if (sTPDataListContainer != null && iSpssVariable != null) {
                if (object == this.mTargetVarList.getModel()) {
                    sTPDataListContainer.removeTargetField(iSpssVariable);
                    this.mTargetArrowButton.setEnabled(true);
                } else if (object == this.mPredicVarList.getModel()) {
                    sTPDataListContainer.removePredictorField(iSpssVariable);
                } else {
                    sTPDataListContainer.removeTimeField(iSpssVariable);
                }
                sTPDataListContainer.addSourceField(iSpssVariable);
            }
            this.mIsPageModified = true;
        }
        this.mWizardDialog.enableNext(this.enableNextButton());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    protected void loadFieldList(int n) {
        if (n < 0) {
            return;
        }
        if (this.mPredicVarList != null) {
            this.mPredicVarList.setEnabled(true);
        }
        if (n == 0) {
            this.mVariableSrcList.getModel().removeAll();
            this.mVariableSrcList.removeAllVarFilters();
            VarListModel varListModel = this.mVariableSrcList.getModel();
            for (int i = 0; i < this.mSources.size(); ++i) {
                STPDataListContainer sTPDataListContainer = this.mSources.get(i);
                VarListModel varListModel2 = sTPDataListContainer.getSourceModel();
                for (int j = 0; j < varListModel2.getSize(); ++j) {
                    varListModel.addElement(varListModel2.getElementAt(j));
                }
            }
            this.mVariableSrcList.setModel(varListModel);
            this.mVariableSrcList.setSelectedIndex(0);
            this.addCellRender(null);
        } else {
            STPDataListContainer sTPDataListContainer = this.mSources.get(n - 1);
            VarListModel varListModel = sTPDataListContainer.getSourceModel();
            if (varListModel != null) {
                this.mVariableSrcList.getModel().removeAll();
                this.mVariableSrcList.removeAllVarFilters();
                VarListModel varListModel3 = this.mVariableSrcList.getModel();
                for (int i = 0; i < varListModel.getSize(); ++i) {
                    varListModel3.addElement(varListModel.getElementAt(i));
                }
                this.mVariableSrcList.setModel(varListModel3);
                this.mVariableSrcList.setSelectedIndex(0);
                if (this.mDataSourceList.getModel().getSize() == 3 && n == 1) {
                    this.mPredicVarList.setEnabled(false);
                }
            }
            this.addCellRender(sTPDataListContainer);
        }
    }

    private void addCellRender(STPDataListContainer sTPDataListContainer) {
        STPTargetlistCellRenderer sTPTargetlistCellRenderer = new STPTargetlistCellRenderer(sTPDataListContainer, this.mTargetVarList);
        this.mTargetVarList.setCellRenderer(sTPTargetlistCellRenderer);
        STPTargetlistCellRenderer sTPTargetlistCellRenderer2 = new STPTargetlistCellRenderer(sTPDataListContainer, this.mPredicVarList);
        this.mPredicVarList.setCellRenderer(sTPTargetlistCellRenderer2);
        STPTargetlistCellRenderer sTPTargetlistCellRenderer3 = new STPTargetlistCellRenderer(sTPDataListContainer, this.mTimeVarList);
        this.mTimeVarList.setCellRenderer(sTPTargetlistCellRenderer3);
    }

    @Override
    public void moveVarOnPredefinedRole() {
    }

    @Override
    public void moveVarOnCustomRole() {
    }

    @Override
    protected void initTargetPanelVar() {
        this.mInfoText = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STP_DEFINE_ROLE_INFOR_TEXT"), null);
        this.mDataSourceList.addListSelectionListener(this);
        this.mVariableSrcList.getModel().addListDataListener(this);
        this.mVariableSrcList.addListSelectionListener(this);
        this.mVariableSrcList.addVarFilter(this);
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        STEMSelectRolePage.STEMVarListModel sTEMVarListModel = new STEMSelectRolePage.STEMVarListModel(this.mTargetVarList);
        this.mTargetVarList.setModel(sTEMVarListModel);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(4, false, false));
        this.mTargetVarList.setIdentifier("IDS_CSAR_STEP_TWO_TARGET_LIST");
        this.mTargetVarListLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STP_DEFINE_ROLE_TARGET_LIST");
        this.mTargetVarListLabel.setLabelFor(this.mTargetVarList);
        this.mTargetVarListScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarListScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarListScrollPane.setMinimumSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarListScrollPane.setVerticalScrollBarPolicy(21);
        this.mTargetVarListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mPredicVarList = new TargetVariableList();
        STEMSelectRolePage.STEMVarListModel sTEMVarListModel2 = new STEMSelectRolePage.STEMVarListModel(this.mPredicVarList);
        this.mPredicVarList.setModel(sTEMVarListModel2);
        this.mPredicVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mPredicVarList.setSelectionMode(0);
        this.mPredicVarList.setIdentifier("IDS_CSAR_STEP_TWO_BOTH_VARIABLE_TARGET_LIST");
        this.mPredicVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mPredicVarList.getFixedCellHeight() * 4 + 2));
        this.mPredicVarList.addVarFilter(this);
        this.mPredicVarList.getModel().addListDataListener(this);
        this.mPredicVarListLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STP_DEFINE_ROLE_PREDICTOR_LIST");
        this.mPredicVarListLabel.setLabelFor(this.mPredicVarList);
        this.mPredicVarListScrollPane = new JScrollPane(this.mPredicVarList);
        this.mPredicVarListScrollPane.setMinimumSize(this.mPredicVarList.getMinimumSize());
        this.mPredicVarListScrollPane.setVerticalScrollBarPolicy(20);
        this.mPredicVarListScrollPane.setHorizontalScrollBarPolicy(30);
        this.mPredicVarListScrollPane.setPreferredSize(this.mPredicVarList.getMinimumSize());
        this.mTimeFieldInfo = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STP_DEFINE_ROLE_TIME_INFOR_TEXT"), null);
        this.mTimeStamp = DialogUtil.createRadioButton(this.mWizardDialog, "IDS_STEM_STP_DEFINE_ROLE_TIME_STAMP_RADIO", null);
        this.mTimeStamp.addItemListener(this);
        this.mCyclicPeriod = DialogUtil.createRadioButton(this.mWizardDialog, "IDS_STEM_STP_DEFINE_ROLE_CYCLIC_PERIOD_RADIO", null);
        this.mCyclicPeriod.addItemListener(this);
        this.mTimeButtonGrop = new SpssButtonGroup();
        this.mTimeButtonGrop.add(this.mTimeStamp);
        this.mTimeButtonGrop.add(this.mCyclicPeriod);
        this.mTimeVarListLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STP_DEFINE_ROLE_TIME_LIST");
        this.mTimeVarList = new TargetVariableList();
        STEMSelectRolePage.STEMVarListModel sTEMVarListModel3 = new STEMSelectRolePage.STEMVarListModel(this.mTimeVarList);
        this.mTimeVarList.setModel(sTEMVarListModel3);
        this.mTimeVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTimeVarList.setSelectionMode(0);
        this.mTimeVarList.setIdentifier("IDS_CSAR_STEP_TWO_PREDICTOR_LIST");
        this.mTimeVarList.addVarFilter(new IVarFilter(){

            @Override
            public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
                boolean bl = true;
                if (STPDefineRolePage.this.mTimeArrowButton != null && !STPDefineRolePage.this.mTimeArrowButton.isEnabled()) {
                    bl = false;
                }
                return bl;
            }
        });
        this.mTimeVarList.getModel().addListDataListener(this);
        this.mTimeVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTimeVarList.getFixedCellHeight() * 4 + 2));
        this.mTimeVarListLabel.setLabelFor(this.mTimeVarList);
        this.mTimeeScrollPane = new JScrollPane(this.mTimeVarList);
        this.mTimeeScrollPane.setVerticalScrollBarPolicy(20);
        this.mTimeeScrollPane.setHorizontalScrollBarPolicy(30);
        this.mTimeeScrollPane.setPreferredSize(this.mTimeVarList.getMinimumSize());
        this.mTimeeScrollPane.setMaximumSize(this.mTimeVarList.getMinimumSize());
        this.mPredicArrowButton = new STPArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPredicArrowButton.setVarMoveHandler(this);
        this.mPredicArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mPredicArrowButton.registerVariableList(this.mPredicVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetArrowButton = new STPArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetArrowButton.setVarMoveHandler(this);
        this.mTargetArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTimeArrowButton = new STPArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTimeArrowButton.setVarMoveHandler(this);
        this.mTimeArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mTimeArrowButton.registerVariableList(this.mTimeVarList, SpssArrowButton.ButtonOrientation.left);
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mDataAndFields = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getAllContextDataFields();
        this.mUsingKDE = true;
        if (((STEMWizardDlg)this.mWizardDialog).getContextPage().countEventData() == 1) {
            Hashtable<String, Vector<ISpssVariable>> hashtable = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getAllEventFields();
            this.mEventDataId = hashtable.keys().nextElement();
            this.mDataAndFields.put(this.mDefaultSources[1], hashtable.elements().nextElement());
        } else {
            this.mTimeFieldVar = null;
            this.mKDEVar = null;
        }
        if (!this.mKeepTargets || this.mSources == null || this.mSources.size() == 0) {
            this.mTargetVarList.removeAll();
            this.mTimeVarList.removeAll();
            this.mPredicVarList.removeAll();
            this.setupSourceContainer();
            if (!this.mNextPressed) {
                this.setupDefaultKDE();
            }
            this.mDataSourceList.setSelectedIndex(1);
            this.mSelectedSrcIndex = 1;
            this.mWizardDialog.enableNext(this.enableNextButton());
        } else if (this.mKeepTargets && this.mSources != null && this.mSources.size() > 0 && this.mSelectedSrcIndex >= 0 && this.mSelectedSrcIndex < this.mDataSourceList.getModel().getSize()) {
            this.mDataSourceList.setSelectedIndex(this.mSelectedSrcIndex);
        }
        this.mNextPressed = false;
        this.mIsPageModified = false;
    }

    private void setupDefaultKDE() {
        if (((STEMWizardDlg)this.mWizardDialog).getContextPage().countEventData() == 1) {
            Vector<String> vector = new Vector<String>();
            this.mTimeFieldVar = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getTimeField(vector);
            this.mEventDataId = vector.get(0);
            boolean bl = ((STEMWizardDlg)this.mWizardDialog).getContextPage().isKDETarget();
            this.mKDEVar = new SpssVariable();
            this.mKDEVar.setName("Density");
            this.mKDEVar.setId(STEMDataSourcePage.sIdGenerator.next());
            this.mKDEVar.setMeasurementLevel(MeasurementLevel.scale);
            if (bl) {
                this.mKDEVar.setRole(Role.target);
            } else {
                this.mKDEVar.setRole(Role.input);
            }
            if (bl) {
                this.mTargetVarList.getModel().removeAll();
                this.mTargetVarList.getModel().addElement(this.mKDEVar);
            } else {
                this.mPredicVarList.getModel().addElement(this.mKDEVar);
            }
        }
    }

    public boolean enableNextButton() {
        boolean bl;
        boolean bl2 = bl = this.mTargetVarList.getModel().getSize() > 0;
        if (bl && this.isTimeStamp()) {
            bl = this.mTimeVarList.getModel().getSize() == this.mSources.size();
        }
        return bl;
    }

    boolean isTimeStamp() {
        return this.mTimeStamp.isSelected();
    }

    private boolean processTimeFieldAndSource() {
        int n;
        String string;
        boolean bl = true;
        if (this.mCyclicPeriod.isSelected()) {
            return bl;
        }
        this.mAutoInterval.clear();
        this.mSourceAndName.clear();
        VarListModel varListModel = this.mTimeVarList.getModel();
        String string2 = "";
        Vector<Boolean> vector = new Vector<Boolean>();
        if (varListModel.getSize() == 2) {
            for (int i = 0; i < varListModel.getSize() && bl; ++i) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(i);
                string = iSpssVariable.getName();
                int n2 = this.findSourceIndex(varListModel.getElementAt(i));
                if (n2 < 0) continue;
                n = iSpssVariable.getFormat().getFormatType().isDateOrTimeFormat() ? 1 : 0;
                vector.add(n != 0);
            }
            if (((Boolean)vector.get(0)).booleanValue() != ((Boolean)vector.get(1)).booleanValue()) {
                String string3 = String.format(ComponentState.getSPSSLocale(), this.mWizardDialog.getResString("IDS_STP_TIME_INTERVAL_UNMATCH_DATE_FORMAT_ERROR"), string2);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string3, VersionInfo.getAppVersionString());
                return false;
            }
        }
        Vector<Boolean> vector2 = new Vector<Boolean>();
        for (int i = 0; i < varListModel.getSize() && bl; ++i) {
            string = varListModel.getElementAt(i);
            String string4 = string.getName();
            n = this.findSourceIndex(varListModel.getElementAt(i));
            if (n < 0) continue;
            boolean bl2 = string.getFormat().getFormatType().isDateOrTimeFormat();
            vector.add(bl2);
            String string5 = this.mSources.get(n).getRealId();
            this.mSourceAndName.add((Pair<String, String>)new Pair((Object)string5, (Object)string4));
            Vector<String> vector3 = new Vector<String>();
            boolean bl3 = this.callBackend(string4, string5, vector3);
            vector2.add(bl3);
            if (bl3) {
                this.mAutoInterval.add(vector3.get(0));
            } else {
                this.mAutoInterval.add("");
            }
            if (bl3) continue;
            if (string2.length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string4;
        }
        if (vector2.size() == 1 && !((Boolean)vector2.get(0)).booleanValue() || vector2.size() == 2 && !((Boolean)vector2.get(0)).booleanValue() && !((Boolean)vector2.get(1)).booleanValue()) {
            bl = false;
        }
        if (bl && vector2.size() == 1 && ((Boolean)vector.get(0)).booleanValue() && (this.mAutoInterval.get(0).length() == 0 || this.mAutoInterval.get(0).equalsIgnoreCase("Periods"))) {
            bl = false;
        }
        if (!bl) {
            this.mAutoInterval.clear();
            this.mSourceAndName.clear();
            String string6 = String.format(ComponentState.getSPSSLocale(), this.mWizardDialog.getResString("IDS_STP_TIME_INTERVAL_DETECTION_ERROR"), string2);
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string6, VersionInfo.getAppVersionString());
        }
        return bl;
    }

    Vector<Pair<String, String>> getTimeFieldSourceAndName() {
        return this.mSourceAndName;
    }

    Vector<String> getAutoTimeInterval() {
        return this.mAutoInterval;
    }

    /*
     * WARNING - void declaration
     */
    private boolean callBackend(String string, String string2, Vector<String> vector) {
        void var11_14;
        boolean bl = true;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector<ContextDataItem> vector5 = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getDataSourceList(true);
        ContextDataItem object2 = null;
        for (ContextDataItem object3 : vector5) {
            if (!object3.getSourceId().equals(string2)) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            return false;
        }
        LocallyUniqueId locallyUniqueId = null;
        String string3 = "";
        if (object2.getDataType() == ContextDataItem.DataType.DATASET) {
            locallyUniqueId = object2.getDatasetUID();
        } else {
            String string4 = object2.getDataSourceFullName();
        }
        this.mWizardDialog.setCursor(Cursor.getPredefinedCursor(3));
        ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().getGatingInfo(locallyUniqueId, (String)var11_14, string, -1, vector4, vector2, vector3);
        if (aSMapsError.getHasError()) {
            String string5 = aSMapsError.getMessage();
            String string6 = aSMapsError.getExplain();
            bl = false;
        } else if (vector2 != null && vector2.size() == 1) {
            String string7 = this.getTimeIntervalFromAutoDetectInfo((String)vector2.get(0));
            vector.add(string7);
        } else {
            bl = false;
        }
        this.mWizardDialog.setCursor(null);
        return bl;
    }

    public String getTimeIntervalFromAutoDetectInfo(String string) {
        String string2 = "";
        if (string != null) {
            try {
                JSONObject jSONObject = JSONObject.parse((String)string);
                JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"intervalResults");
                if (jSONArray.size() == 0) {
                    return string2;
                }
                JSONObject jSONObject2 = (JSONObject)jSONArray.get(0);
                string2 = (String)jSONObject2.get((Object)"timeInterval");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string2;
    }

    String getTimeVarSampleValues(String string) {
        String string2 = "";
        VarListModel varListModel = this.mTimeVarList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            Set set;
            IValueLabelMap iValueLabelMap;
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!string.equals(iSpssVariable.getName()) || (iValueLabelMap = iSpssVariable.getValueLabels()) == null || (set = iValueLabelMap.getValueLabelEntries()).size() <= 0) continue;
            for (Map.Entry entry : set) {
                string2 = string2 + ((OBS)entry.getKey()).getNum() + ", ";
            }
        }
        return string2;
    }

    Vector<ISpssVariable> getNonCatContextSourceFields() {
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        int n = this.mSources.size();
        for (int i = 0; i < n; ++i) {
            STPDataListContainer sTPDataListContainer = this.mSources.get(i);
            VarListModel varListModel = sTPDataListContainer.getPredictorModel();
            for (int j = 0; j < varListModel.getSize(); ++j) {
                vector.add(varListModel.getElementAt(j));
            }
        }
        return vector;
    }

    Vector<STPDataListContainer> getAllDataSources() {
        return this.mSources;
    }

    String getDataSourceIdFor(ISpssVariable iSpssVariable) {
        for (int i = 0; i < this.mSources.size(); ++i) {
            STPDataListContainer sTPDataListContainer = this.mSources.get(i);
            if (!sTPDataListContainer.findVariable(iSpssVariable)) continue;
            return sTPDataListContainer.getDataId();
        }
        return "";
    }

    @Override
    public boolean validateOnBack() {
        ((STEMWizardDlg)this.mWizardDialog).getContextPage().setKeepSettings(true);
        this.mSelectedSrcIndex = this.mDataSourceList.getSelectedIndex();
        return true;
    }

    @Override
    public boolean validate() {
        if (this.processTimeFieldAndSource()) {
            this.mNextPressed = true;
            return super.validate();
        }
        return false;
    }

    private void enableTimeFieldPanel(boolean bl) {
        this.mTimeArrowButton.setEnabled(bl);
        this.mTimeFieldInfo.setEnabled(bl);
        this.mTimeVarListLabel.setEnabled(bl);
        this.mTimeVarList.setEnabled(bl);
    }

    void reset() {
        this.mTargetVarList.removeAll();
        this.mTimeVarList.removeAll();
        this.mPredicVarList.removeAll();
        if (this.mSources != null) {
            this.mSources.clear();
        }
        this.mDataSourceList.removeAll();
        this.mDataSourceList.setModel(new DefaultListModel());
    }

    void setKeepTarget(boolean bl) {
        this.mKeepTargets = bl;
    }

    @Override
    protected void addTargetPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets.set(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mTargetVarListLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mTargetArrowButton, gridBagConstraints, 1, 3, 1, 1, 10, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mTargetVarListScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mPredicVarListLabel, gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(1, insets2.left, 0, 0);
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mPredicArrowButton, gridBagConstraints, 1, 5, 1, 1, 10, insets);
        gridBagConstraints.fill = 1;
        insets.set(1, insets2.left, n2, n2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mPredicVarListScrollPane, gridBagConstraints, 2, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(1, insets2.left, 10, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mEventDataPanel, this.mTimeArrowButton, gridBagConstraints, 1, 7, 1, 1, 10, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STP_DEFINE_ROLE_TIME_PANEL_TITLE"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTimeStamp, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, insets2.left * 5, 1, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTimeVarListLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(1, insets2.left * 5, 2, n2 * 5);
        DialogUtil.addUsingGBL(jPanel, this.mTimeeScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, insets2.left * 5, 1, n2);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), 50);
        this.mTimeFieldInfo.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, this.mTimeFieldInfo, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, insets2.left, 1, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCyclicPeriod, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        insets.set(1, insets2.left, 10, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mEventDataPanel, jPanel, gridBagConstraints, 2, 6, 1, 2, n, insets);
        this.setDefault();
        this.setTabTraversalOrder();
    }

    @Override
    String getDataRoleSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        int n = this.mSources.size();
        for (int i = 0; i < n; ++i) {
            String string;
            boolean bl;
            STPDataListContainer sTPDataListContainer = this.mSources.get(i);
            stringBuffer.append("\n /DATASET");
            stringBuffer.append(" DATAID=" + sTPDataListContainer.getRealId());
            boolean bl2 = bl = i == 0 && n == 2;
            if (bl) {
                stringBuffer.append(" KDENAME=KDE");
            }
            VarListModel varListModel = sTPDataListContainer.getTargetModel();
            int n2 = 0;
            if (!bl && varListModel.getSize() == 1) {
                stringBuffer.append(" TARGET=" + varListModel.getElementAt(0).getName());
            }
            if ((varListModel = sTPDataListContainer.getPredictorModel()).getSize() > 0) {
                stringBuffer.append(" INPUTS=");
                for (n2 = 0; n2 < varListModel.getSize(); ++n2) {
                    stringBuffer.append(varListModel.getElementAt(n2).getName() + " ");
                }
            }
            if (this.mTimeStamp.isSelected()) {
                varListModel = sTPDataListContainer.getTimeFieldModel();
                if (varListModel.getSize() == 1) {
                    stringBuffer.append(" TIMEINDEX=");
                    stringBuffer.append(varListModel.getElementAt(0).getName());
                }
            } else {
                string = ((STEMWizardDlg)this.mWizardDialog).getSTPSettingsPage().getCyclicFields(sTPDataListContainer.getDataId());
                if (string.length() > 0) {
                    stringBuffer.append(" TIMEINDEX=" + string);
                }
            }
            string = ((STEMWizardDlg)this.mWizardDialog).getSTPSettingsPage().getAggreExceptionSyntax(sTPDataListContainer.getDataId());
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void setDefault() {
        this.mPredicArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mPredicArrowButton.setEnabled(true);
        this.mTargetArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mTimeStamp.setSelected(true);
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfoText);
        vector.add(this.mDataSourceList);
        Vector<Object> vector2 = this.mSortPanel.getTabTraversalComponent();
        vector.addAll(vector2);
        vector.add(this.mVariableSrcList);
        vector.addAll(this.mSelectorPanel.getTabTraversalComponent());
        vector.add(this.mTargetArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mPredicArrowButton);
        vector.add(this.mPredicVarList);
        vector.add(this.mTimeArrowButton);
        vector.add(this.mTimeStamp);
        vector.add(this.mTimeVarList);
        vector.add(this.mTimeFieldInfo);
        vector.add(this.mCyclicPeriod);
        Vector<Object> vector3 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector3, false);
    }

    private void setupSourceContainer() {
        int n = this.mDataSourceList.getModel().getSize();
        this.mSources = new Vector();
        ListModel listModel = this.mDataSourceList.getModel();
        for (int i = 1; i < n; ++i) {
            String string = listModel.getElementAt(i).toString();
            STPDataListContainer sTPDataListContainer = new STPDataListContainer(string);
            if (n == 3 && i == 1) {
                sTPDataListContainer.setRealId(this.mEventDataId);
            }
            VarListModel varListModel = sTPDataListContainer.getSourceModel();
            Vector vector = (Vector)this.mDataAndFields.get(string);
            if (vector != null) {
                for (ISpssVariable iSpssVariable : vector) {
                    varListModel.addElement(iSpssVariable);
                }
            }
            sTPDataListContainer.setSourceModel(varListModel);
            this.mSources.add(i - 1, sTPDataListContainer);
        }
    }

    private int findSourceIndex(ISpssVariable iSpssVariable) {
        for (int i = 0; i < this.mSources.size(); ++i) {
            STPDataListContainer sTPDataListContainer = this.mSources.get(i);
            if (!sTPDataListContainer.findVariable(iSpssVariable)) continue;
            return i;
        }
        return -1;
    }

    class STPArrowButton
    extends ArrowButton {
        public STPArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(buttonOrientation);
        }

        @Override
        protected boolean canMoveVars(VariableList variableList, ISpssVariable[] iSpssVariableArray) {
            int n = STPDefineRolePage.this.mDataSourceList.getSelectedIndex();
            boolean bl = true;
            if (n > 0) {
                STPDataListContainer sTPDataListContainer = (STPDataListContainer)STPDefineRolePage.this.mSources.get(n - 1);
                if (variableList instanceof SrcVariableList) {
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (sTPDataListContainer.findVariable(iSpssVariable)) continue;
                        bl = false;
                        break;
                    }
                }
            }
            return bl && super.canMoveVars(variableList, iSpssVariableArray);
        }

        @Override
        protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
            super.updateEnable(srcDestHolder);
            if (srcDestHolder != null && STPDefineRolePage.this.mDataSourceList != null && STPDefineRolePage.this.mDataSourceList.getModel().getSize() == 3 && STPDefineRolePage.this.mDataSourceList.getSelectedIndex() == 0) {
                ArrowButton.VarListHolder varListHolder = (ArrowButton.VarListHolder)srcDestHolder;
                ArrowButton.VarListHolder varListHolder2 = (ArrowButton.VarListHolder)this.getTargetVarHolder();
                ISpssVariable[] iSpssVariableArray = varListHolder.getVarList().getSelectedValues();
                if (varListHolder2.getVarList() == STPDefineRolePage.this.mPredicVarList) {
                    STPDataListContainer sTPDataListContainer = (STPDataListContainer)STPDefineRolePage.this.mSources.get(0);
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        if (!sTPDataListContainer.findVariable(iSpssVariable)) continue;
                        this.setEnabled(false);
                        break;
                    }
                }
            }
        }
    }

    class STPTargetlistCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private STPDataListContainer mSource;
        private TargetVariableList mTargetList;

        STPTargetlistCellRenderer(STPDataListContainer sTPDataListContainer, TargetVariableList targetVariableList) {
            this.mSource = sTPDataListContainer;
            this.mTargetList = targetVariableList;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3 = object instanceof ISpssVariable;
            boolean bl4 = STPDefineRolePage.this.mVariableSrcList.getShowVarLabels();
            boolean bl5 = false;
            ISpssVariable iSpssVariable = null;
            if (bl3) {
                iSpssVariable = (ISpssVariable)object;
                this.setIcon(STPDefineRolePage.this.mVariableSrcList.getShowIcon() ? this.mTargetList.getIcon((ISpssVariable)object) : null);
                String string = iSpssVariable.getName();
                String string2 = iSpssVariable.getLabel();
                if (!ComponentState.isBtdRtlOrLtr()) {
                    if (bl4 && string2.length() > 0) {
                        this.setText(string2 + " [" + string + "]");
                    } else {
                        this.setText(string);
                    }
                } else if (bl4 && string2.length() > 0) {
                    this.setText(this.concatLabelNameForBidiDispaly(string2, string));
                } else {
                    this.setText(this.concatLabelNameForBidiDispaly(null, string));
                }
                if (iSpssVariable.getId().isNull() && CommandLine.isClementineCaller() && !DialogDataModel.isSpecialVariable(iSpssVariable)) {
                    bl5 = true;
                }
            } else {
                this.setText(object != null ? object.toString() : "");
            }
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                if (bl5) {
                    this.setForeground(Color.RED);
                }
            } else {
                this.setOpaque(false);
            }
            boolean bl6 = jList.isEnabled();
            if (iSpssVariable != null && this.mSource != null) {
                bl6 = this.mSource.findVariable(iSpssVariable);
            }
            if (this.mTargetList == STPDefineRolePage.this.mTimeVarList) {
                bl6 = bl6 && STPDefineRolePage.this.mTimeStamp.isSelected();
            }
            this.setEnabled(bl6);
            this.setFont(jList.getFont());
            this.handleBorder(jList, bl2);
            return this;
        }

        private String concatLabelNameForBidiDispaly(String string, String string2) {
            String string3 = null;
            if (string == null && string2 == null) {
                return string3;
            }
            string3 = string != null && string.length() > 0 ? (ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200f' + string + " [" + string2 + "]" : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200e' + string + " [" + string2 + "]" : string + " [" + string2 + "]")) : (ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200f' + string2 : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string2.charAt(0)), 1).isRightToLeft() ? '\u200e' + string2 : string2));
            return string3;
        }

        private void handleBorder(JList jList, boolean bl) {
            if (sNoFocusBorder == null || sFocusBorder == null) {
                this.createBorders();
            }
            Border border = bl && jList.isEnabled() ? sFocusBorder : sNoFocusBorder;
            this.setBorder(border);
        }

        private void createBorders() {
            Border border = BorderFactory.createEmptyBorder(0, 2, 0, 0);
            Border border2 = UIManager.getBorder("List.focusCellHighlightBorder");
            sFocusBorder = BorderFactory.createCompoundBorder(border2, border);
            border2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            sNoFocusBorder = BorderFactory.createCompoundBorder(border2, border);
        }
    }

    class STPDataListContainer {
        private String mDataId;
        private String mRealDataId;
        private Vector<ISpssVariable> mVariables;
        private SrcVariableList mSrcList;
        private TargetVariableList mTargetList;
        private TargetVariableList mPredicVarList;
        private TargetVariableList mTimeFieldList;

        public STPDataListContainer(String string) {
            this.mDataId = string;
            this.mRealDataId = string;
            this.mSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
            this.mSrcList.setIdentifier(string);
            this.mTargetList = new TargetVariableList();
            this.mTargetList.setIdentifier(string + "_TARGET");
            this.mPredicVarList = new TargetVariableList();
            this.mPredicVarList.setIdentifier(string + "_PREDICTOR");
            this.mTimeFieldList = new TargetVariableList();
            this.mTimeFieldList.setIdentifier(string + "_TIME_FIELD");
            this.mVariables = new Vector();
        }

        public VarListModel getSourceModel() {
            return this.mSrcList.getModel();
        }

        public ISpssVariable getVariable(String string) {
            for (ISpssVariable iSpssVariable : this.mVariables) {
                if (!iSpssVariable.getName().equals(string)) continue;
                return iSpssVariable;
            }
            return null;
        }

        public void setSourceModel(VarListModel varListModel) {
            this.mSrcList.setModel(varListModel);
            for (int i = 0; i < varListModel.getSize(); ++i) {
                this.mVariables.add(i, varListModel.getElementAt(i));
            }
        }

        public boolean findVariable(ISpssVariable iSpssVariable) {
            return this.mVariables.contains(iSpssVariable);
        }

        public void addSourceField(ISpssVariable iSpssVariable) {
            this.mSrcList.getModel().addElement(iSpssVariable);
        }

        public void removeSourceField(ISpssVariable iSpssVariable) {
            this.mSrcList.getModel().removeElement(iSpssVariable);
        }

        public VarListModel getTargetModel() {
            return this.mTargetList.getModel();
        }

        public void setTargetModel(VarListModel varListModel) {
            this.mTargetList.setModel(varListModel);
        }

        public void addTargetField(ISpssVariable iSpssVariable) {
            this.mTargetList.getModel().addElement(iSpssVariable);
        }

        public void removeTargetField(ISpssVariable iSpssVariable) {
            this.mTargetList.getModel().removeElement(iSpssVariable);
        }

        public VarListModel getPredictorModel() {
            return this.mPredicVarList.getModel();
        }

        public void setPreditiorModel(VarListModel varListModel) {
            this.mPredicVarList.setModel(varListModel);
        }

        public void addPredictorField(ISpssVariable iSpssVariable) {
            this.mPredicVarList.getModel().addElement(iSpssVariable);
        }

        public Vector<String> getPredString() {
            String string;
            ISpssVariable iSpssVariable;
            Vector<String> vector = new Vector<String>();
            VarListModel varListModel = this.mTargetList.getModel();
            int n = 0;
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                string = iSpssVariable.getName() + "(" + this.mDataId + ") ";
                vector.add(string);
            }
            varListModel = this.mPredicVarList.getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                string = iSpssVariable.getName() + "(" + this.mDataId + ") ";
                vector.add(string);
            }
            return vector;
        }

        public Vector<String> getAllModelFieldString() {
            Vector<String> vector = this.getPredString();
            VarListModel varListModel = this.mTimeFieldList.getModel();
            int n = 0;
            for (n = 0; n < varListModel.getSize(); ++n) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(n);
                String string = iSpssVariable.getName() + "(" + this.mDataId + ") ";
                vector.add(string);
            }
            return vector;
        }

        public Vector<ISpssVariable> getContField() {
            ISpssVariable iSpssVariable;
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
            VarListModel varListModel = this.mTargetList.getModel();
            int n = 0;
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                if (iSpssVariable.getMeasurementLevel() != MeasurementLevel.scale) continue;
                vector.add(iSpssVariable);
            }
            varListModel = this.mPredicVarList.getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                if (iSpssVariable.getMeasurementLevel() != MeasurementLevel.scale) continue;
                vector.add(iSpssVariable);
            }
            varListModel = this.mTimeFieldList.getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                if (iSpssVariable.getMeasurementLevel() != MeasurementLevel.scale) continue;
                vector.add(iSpssVariable);
            }
            return vector;
        }

        public void removePredictorField(ISpssVariable iSpssVariable) {
            this.mPredicVarList.getModel().removeElement(iSpssVariable);
        }

        public VarListModel getTimeFieldModel() {
            return this.mTimeFieldList.getModel();
        }

        public void setTimeFieldModel(VarListModel varListModel) {
            this.mTimeFieldList.setModel(varListModel);
        }

        public void addTimeField(ISpssVariable iSpssVariable) {
            this.mTimeFieldList.getModel().addElement(iSpssVariable);
        }

        public void removeTimeField(ISpssVariable iSpssVariable) {
            this.mTimeFieldList.getModel().removeElement(iSpssVariable);
        }

        public String getDataId() {
            return this.mDataId;
        }

        public String getRealId() {
            return this.mRealDataId;
        }

        public void setRealId(String string) {
            this.mRealDataId = string;
        }
    }
}

