/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.STEM.GSARDefineRolePage;
import com.spss.java_client.ui.dialogs.STEM.MergeEventDataPage;
import com.spss.java_client.ui.dialogs.STEM.STEMDataSourcePage;
import com.spss.java_client.ui.dialogs.STEM.STEMFinishPage;
import com.spss.java_client.ui.dialogs.STEM.STEMGeoRelationshipPage;
import com.spss.java_client.ui.dialogs.STEM.STEMSettingsPage;
import com.spss.java_client.ui.dialogs.STEM.STEMStepOne;
import com.spss.java_client.ui.dialogs.STEM.STEMUtil;
import com.spss.java_client.ui.dialogs.STEM.STPDefineRolePage;
import com.spss.java_client.ui.dialogs.STEM.STPSettingsPage;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.CharacterUtil;
import com.spss.vis.maptool.DataBundle;
import com.spss.vis.maptool.EsriShapefileReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class STEMWizardDlg
extends BaseWizardDialog {
    public static final int HEADER_LABEL_SIZE = 18;
    protected DialogDataModel mDialogDataModel = new DialogDataModel();
    private STEMStepOne mStepOnePage;
    private STEMGeoRelationshipPage mSelectMapPage;
    private STEMDataSourcePage mContextDataPage;
    private MergeEventDataPage mMergeEventPage;
    private GSARDefineRolePage mGSARSelectRolePage;
    private STPDefineRolePage mSTPSelectRolePage;
    private STEMSettingsPage mSTEMSettingsPage;
    private STPSettingsPage mSTPSettingsPage;
    private STEMFinishPage mFinishPage;
    private JFrame mParent;
    private Vector<ISpssVariable> mVarsFromActiveDataset;
    private Vector<String> mUniqIDs;

    public STEMWizardDlg(JFrame jFrame) {
        super(jFrame, true, STEMResBundle.getDefaultResourceBundleName(), STEMResBundle.getImageFolder());
        this.mParent = jFrame;
        this.mUniqIDs = new Vector();
        Dimension dimension = this.getSize();
        if (dimension.height > 550) {
            dimension.height = 550;
        }
        if (dimension.width > 700) {
            dimension.width = 600;
        }
        this.setSize(dimension);
        this.setLocationRelativeTo(jFrame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (STEMWizardDlg.this.isDisplayable()) {
                    ProcedureDlgMgr.getMgr().loadPersistentState(STEMWizardDlg.this.getIActionKey(), STEMWizardDlg.this.getDialogDataModel());
                    STEMWizardDlg.this.loadDialogState();
                }
            }
        });
    }

    protected void loadDialogState() {
        BaseProcedureDialog.loadState(this.getDialogDataModel(), (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
    }

    protected void saveDialogState() {
        BaseProcedureDialog.saveState(this.getDialogDataModel(), (Container)((Object)this));
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
    }

    public DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    public String getResBundleName() {
        return UtilitiesResBundle.getDefaultResourceBundleName();
    }

    public String getImageFolderName() {
        return UtilitiesResBundle.getImageFolder();
    }

    void setVarMoveHandler(IVarMoveHandler iVarMoveHandler) {
        this.mVarMoveHandler = iVarMoveHandler;
    }

    STEMDataSourcePage getContextPage() {
        return this.mContextDataPage;
    }

    GSARDefineRolePage getGSARDefineRolePage() {
        return this.mGSARSelectRolePage;
    }

    STPDefineRolePage getSTPDefineRolePage() {
        return this.mSTPSelectRolePage;
    }

    STPSettingsPage getSTPSettingsPage() {
        return this.mSTPSettingsPage;
    }

    STEMStepOne getStepOnePage() {
        return this.mStepOnePage;
    }

    STEMGeoRelationshipPage getGeoRelationPage() {
        return this.mSelectMapPage;
    }

    STEMSettingsPage getGSARSettingsPage() {
        return this.mSTEMSettingsPage;
    }

    MergeEventDataPage getMergePage() {
        return this.mMergeEventPage;
    }

    @Override
    public void init() {
        super.init();
        this.mVarsFromActiveDataset = this.loadVarsFromActiveDataset();
        this.mStepOnePage = new STEMStepOne(this);
        this.mSelectMapPage = new STEMGeoRelationshipPage(this);
        this.mContextDataPage = new STEMDataSourcePage(this);
        this.mMergeEventPage = new MergeEventDataPage(this);
        this.mGSARSelectRolePage = new GSARDefineRolePage(this);
        this.mSTPSelectRolePage = new STPDefineRolePage(this);
        this.mSTEMSettingsPage = new STEMSettingsPage(this);
        this.mSTPSettingsPage = new STPSettingsPage(this);
        this.mFinishPage = new STEMFinishPage(this);
        this.enableFinish(false);
        try {
            this.registerPage(this.mStepOnePage);
            this.registerPage(this.mSelectMapPage);
            this.registerPage(this.mContextDataPage);
            this.registerPage(this.mMergeEventPage);
            this.registerPage(this.mGSARSelectRolePage);
            this.registerPage(this.mSTPSelectRolePage);
            this.registerPage(this.mSTEMSettingsPage);
            this.registerPage(this.mSTPSettingsPage);
            this.registerPage(this.mFinishPage);
        }
        catch (BaseWizardDialog.PageAlreadyRegistered pageAlreadyRegistered) {
            pageAlreadyRegistered.printStackTrace();
        }
        this.pack();
    }

    public static String[] showOpenFileDialog(BaseDialog baseDialog, String string, String[] stringArray, String[] stringArray2, int n) {
        int n2;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileSelectionMode(0);
        for (n2 = 1; n2 < stringArray.length; ++n2) {
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(stringArray[n2], stringArray2[n2]));
        }
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(stringArray[n], stringArray2[n]));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        n2 = remoteFileChooser.showOpenDialog((Component)baseDialog);
        if (n2 == 0) {
            String string2 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            return new String[]{string2, remoteFileChooser.getSelectedFileName()};
        }
        return null;
    }

    public static String getAttributes(String string) {
        String[] stringArray;
        DataBundle dataBundle = null;
        String string2 = "";
        try {
            stringArray = string.substring(0, string.length() - 4) + ".dbf";
            dataBundle = EsriShapefileReader.loadDataFile((File)new File((String)stringArray));
        }
        catch (IOException iOException) {
            return "";
        }
        stringArray = dataBundle.getAttributeNames();
        if (stringArray == null) {
            return "";
        }
        int n = 0;
        for (String string3 : stringArray) {
            string2 = string2 + stringArray[n++];
            if (n >= stringArray.length) continue;
            string2 = string2 + "; ";
        }
        return string2;
    }

    public static String[] getAttributesNames(String string) {
        DataBundle dataBundle = null;
        String string2 = "";
        try {
            String string3 = string.substring(0, string.length() - 4) + ".dbf";
            dataBundle = EsriShapefileReader.loadDataFile((File)new File(string3));
        }
        catch (IOException iOException) {
            return null;
        }
        return dataBundle.getAttributeNames();
    }

    public STEMStepOne getSelectModelPage() {
        return this.mStepOnePage;
    }

    String findUniqueId(String string) {
        String string2;
        String string3 = string;
        string3 = string2 = STEMUtil.removeSpaceFrom(string3);
        while (this.mUniqIDs.contains(string3)) {
            string3 = string3 + "_1";
        }
        this.mUniqIDs.add(string3);
        return string3;
    }

    public String getDialogHelpID() {
        return "idh_stem_gating";
    }

    private Vector<ISpssVariable> loadVarsFromActiveDataset() {
        ISpssDataSrc iSpssDataSrc;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (spssFrame instanceof DataFrame && (iSpssDataSrc = DataMgr.getDataMgr().getDataSource(((DataFrame)spssFrame).getDatasetId())) != null) {
            for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                vector.add(iSpssVariable);
            }
        }
        return vector;
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.mSelectMapPage.getMapSpecSyntax();
        if (string.length() > 0) {
            stringBuffer.append(this.mContextDataPage.getDatasetNameSyntax());
            stringBuffer.append(string);
            stringBuffer.append(this.mContextDataPage.getDataSourceSyntax());
            if (this.mStepOnePage.isGSARSelected()) {
                stringBuffer.append(this.mSTEMSettingsPage.getMapSpecSyntax());
            } else if (this.mStepOnePage.isSTPSelected()) {
                stringBuffer.append(this.mSTPSettingsPage.getMapSpecSyntax());
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mStepOnePage.isGSARSelected()) {
            stringBuffer.append(this.mSTEMSettingsPage.getDeclareSyntax());
        }
        stringBuffer.append(this.mStepOnePage.getStepOneSyntax());
        String string2 = "";
        string2 = string.length() == 0 ? this.mSelectMapPage.getMapSpecPath() : (this.mStepOnePage.isGSARSelected() ? this.mSTEMSettingsPage.getMapSpecFilePath() : this.mSTPSettingsPage.getMapSpecFilePath());
        if (this.mStepOnePage.isGSARSelected()) {
            stringBuffer.append("\n /MAPSPEC FILE=");
            stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            stringBuffer.append(this.mSTEMSettingsPage.getAutoBinSyntax());
            stringBuffer.append(this.mGSARSelectRolePage.getDataRoleSyntax());
            stringBuffer.append(this.mSTEMSettingsPage.generateGSARSettingsSyntax());
        } else {
            stringBuffer.append("\n /MAPSPEC FILE=");
            stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            stringBuffer.append(this.mSTPSettingsPage.getAggregationSyntax());
            stringBuffer.append(this.mSTPSelectRolePage.getDataRoleSyntax());
            stringBuffer.append(this.mSTPSettingsPage.getSTPSettingsSyntax());
        }
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public static String getContAggregationSyntax(int n) {
        switch (n) {
            case 0: {
                return "MEAN";
            }
            case 1: {
                return "MEDIAN";
            }
            case 2: {
                return "SUM";
            }
        }
        return "";
    }

    public static String getOrdinalSyntax(int n) {
        switch (n) {
            case 0: {
                return "MEDIAN";
            }
            case 1: {
                return "MODE";
            }
            case 2: {
                return "HIGHEST";
            }
            case 3: {
                return "LOWEST";
            }
        }
        return "";
    }

    public String getAggregationSyntax(String string) {
        String string2 = "";
        if (string.equals(this.getResString("IDS_STEM_BIN_AGGRE_DEFAULT"))) {
            return string2;
        }
        if (string.equals(this.getResString("IDS_STEM_BIN_AGGRE_MEAN"))) {
            string2 = "MEAN";
        } else if (string.equals(this.getResString("IDS_STEM_BIN_AGGRE_MEDIAN"))) {
            string2 = "MEDIAN";
        } else if (string.equals(this.getResString("IDS_STEM_BIN_AGGRE_MODE"))) {
            string2 = "MODE";
        } else if (string.equals(this.getResString("IDS_STEM_BIN_AGGRE_SUM"))) {
            string2 = "SUM";
        } else if (string.equals(this.getResString("IDS_STEM_BIN_AGGRE_HIGH"))) {
            string2 = "HIGH";
        } else if (string.equals(this.getResString("IDS_STEM_BIN_AGGRE_LOW"))) {
            string2 = "LOW";
        }
        return string2;
    }

    private void setActionInfo(AbstractAction abstractAction, String string) {
        abstractAction.putValue("Name", ResUtil.getCommonDlgString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string;
            Integer n = ResUtil.getCommonDlgAccessKey(string2 = string2.replaceFirst("IDS_", "IDK_"));
            if (n != null) {
                abstractAction.putValue("MnemonicKey", n);
            }
        }
    }

    public boolean canFinish() {
        boolean bl = this.mStepOnePage != null ? this.mStepOnePage.isPageValidToContinue() : false;
        return bl;
    }

    @Override
    protected BaseWizardDialog.DoFinishAction doFinish() {
        if (this.mFinishPage.isPasteSelected()) {
            return BaseWizardDialog.DoFinishAction.ePaste;
        }
        return BaseWizardDialog.DoFinishAction.eOK;
    }

    @Override
    protected boolean validateOnFinish() {
        return super.validateOnFinish();
    }

    public Vector<Object> addBaseWizardTabTraversal(Vector<Object> vector) {
        int n;
        Vector<Object> vector2 = new Vector<Object>();
        for (n = 0; n < vector.size(); ++n) {
            vector2.add(vector.elementAt(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector2.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector2;
    }

    @Override
    public String getIActionKey() {
        return "analyze_stem_data_preparation";
    }

    public String getTitle() {
        return this.getResString("IDS_STEM_STEP_ONE_TITLE");
    }

    public Vector<ISpssVariable> getVarsFromActiveDataset() {
        return this.mVarsFromActiveDataset;
    }

    public JFrame getParentFrame() {
        return this.mParent;
    }

    public static JPanel createButtonsPanel(JButton[] jButtonArray) {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 0;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n3, n3, n3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        for (n2 = 0; n2 < jButtonArray.length; ++n2) {
            if (n2 == jButtonArray.length - 1) {
                gridBagConstraints.weighty = 1.0;
                insets.set(n3 * 4, n3, n3, n3);
            }
            DialogUtil.addUsingGBL(jPanel, jButtonArray[n2], gridBagConstraints, 0, n2, 1, 1, n, insets);
        }
        return jPanel;
    }

    class PreviewCanvas
    extends JPanel {
        private BufferedImage mPrevImage;

        public PreviewCanvas(BufferedImage bufferedImage) {
            this.mPrevImage = bufferedImage;
        }

        public void setImage(BufferedImage bufferedImage) {
            this.mPrevImage = bufferedImage;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.mPrevImage != null) {
                graphics.drawImage(this.mPrevImage, 0, 0, null);
            }
        }
    }
}

