/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.xml.DOMFactory;
import com.spss.java_client.core.xml.SchemaType;
import com.spss.java_client.ui.dialogs.STEM.STEMDataSourcePage;
import com.spss.java_client.ui.dialogs.STEM.STEMPlanHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class STEMUtil {
    private static final String STEM_PLAN_ROOT_NAME = "SPSSGeoSpatialPlan";
    public static final String DATA_MODEL_XML_ROOT_NAME = "DataModel";
    private DataModelContent mDataModelContent = null;

    static boolean validateDoubleSpinner(NumberSpinner numberSpinner, double d, double d2) {
        String string = ((JTextField)numberSpinner.getEditor()).getText();
        if (string.length() == 0) {
            return false;
        }
        double d3 = Double.parseDouble(string);
        return !(d3 < d) && !(d3 > d2);
    }

    static boolean validateIntSpinner(NumberSpinner numberSpinner, int n, int n2) {
        String string = ((JTextField)numberSpinner.getEditor()).getText();
        if (string.length() == 0) {
            return false;
        }
        int n3 = Integer.parseInt(string);
        return n3 >= n && n3 <= n2;
    }

    public static STEMPlanHandler selectAndParseMapSpec(String string, BaseDialog baseDialog) {
        STEMPlanHandler sTEMPlanHandler = null;
        String string2 = "";
        if (string.length() != 0) {
            PesFile pesFile;
            File file = null;
            boolean bl = false;
            if (string.length() != 0) {
                file = new File(string);
            }
            if ((pesFile = PES_Repository.getPesFile((String)string)) != null) {
                String string3 = PES_Repository.RetrieveFromPES((PesFile)pesFile);
                file = pesFile.getCacheFile();
                bl = true;
                if (file == null) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)baseDialog, string3, VersionInfo.getAppVersionString());
                }
            }
            if (string.length() != 0) {
                boolean bl2 = false;
                String string4 = PrefsMgr.getPrefsMgr().getTempPath();
                String string5 = file.getName();
                if (DataServerProxy.getDataProxy().isRemoteConnection()) {
                    UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
                    if (!utilityProxy.copyServerFile(string, string4 + string5, false)) {
                        return null;
                    }
                    file = new File(string4 + string5);
                    bl = true;
                }
                if (file.exists() && file.canRead()) {
                    string2 = STEMUtil.getXMLFileFromZip(file, STEM_PLAN_ROOT_NAME);
                }
                if (string2.length() > 0) {
                    sTEMPlanHandler = new STEMPlanHandler(baseDialog);
                    bl2 = sTEMPlanHandler.parsePlanFile(string2);
                    if (bl2) {
                        return sTEMPlanHandler;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog((Window)baseDialog, baseDialog.getResString("IDS_STEM_MAP_SPEC_ERROR"), VersionInfo.getAppVersionString());
                    sTEMPlanHandler = null;
                } else {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)baseDialog, baseDialog.getResString("IDS_STEM_MAP_SPEC_ERROR"), VersionInfo.getAppVersionString());
                    sTEMPlanHandler = null;
                }
                if (bl) {
                    file.delete();
                }
            }
        }
        return sTEMPlanHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXMLFileFromZip(File file, String string) {
        Object object;
        String string2 = PrefsMgr.getPrefsMgr().getTempPath();
        String string3 = "";
        if (file != null) {
            object = null;
            try {
                object = new FileInputStream(file);
                JarInputStream jarInputStream = new JarInputStream((InputStream)object);
                JarEntry jarEntry = jarInputStream.getNextJarEntry();
                while (jarEntry != null) {
                    ByteBuffer byteBuffer = STEMUtil.readEntry(jarInputStream);
                    File file2 = new File(string2 + jarEntry.getName());
                    file2.deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    ((OutputStream)fileOutputStream).write(byteBuffer.array());
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    if (string3.length() == 0) {
                        string3 = STEMUtil.getXMLFileName(string2, jarEntry.getName(), string);
                    }
                    jarInputStream.closeEntry();
                    jarEntry = jarInputStream.getNextJarEntry();
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        object = string3;
        if (string3.length() > 0) {
            object = string2 + string3;
        }
        return object;
    }

    public static DataModelContent handleDataModelXML(String string, String string2) {
        try {
            if (string2.length() > 0) {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(string2);
                outputStreamWriter.flush();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return STEMUtil.handleDataModelXML(string);
    }

    public static DataModelContent handleDataModelXML(String string) {
        Document document;
        DataModelContent dataModelContent = null;
        DOMFactory dOMFactory = new DOMFactory();
        try {
            document = dOMFactory.createDOM(new InputSource(new FileInputStream(string)), SchemaType.SCHEMA_NONE);
            if (document == null) {
                return dataModelContent;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return dataModelContent;
        }
        Element element = document.getDocumentElement();
        if (!element.getNodeName().equals(DATA_MODEL_XML_ROOT_NAME)) {
            return dataModelContent;
        }
        NodeList nodeList = element.getElementsByTagName("Fields");
        if (nodeList.getLength() == 1) {
            dataModelContent = new DataModelContent();
            NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("Field");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                FormatType formatType;
                Object object;
                NodeList nodeList3;
                Element element2 = (Element)nodeList2.item(i);
                String string2 = element2.getAttribute("structure");
                if (string2.equals("list")) {
                    nodeList3 = element2.getElementsByTagName("Geo");
                    if (nodeList3.getLength() <= 0) continue;
                    object = (Element)nodeList3.item(0);
                    String string3 = object.getAttribute("type");
                    dataModelContent.setGeoType(string3);
                    string3 = object.getAttribute("coordinates");
                    dataModelContent.setCoordinates(Integer.parseInt(string3));
                    string3 = object.getAttribute("wkid");
                    if (string3.length() > 0) {
                        dataModelContent.setWKId(Integer.parseInt(string3));
                    }
                    string3 = object.getAttribute("csname");
                    dataModelContent.setCSName(string3);
                    string3 = object.getAttribute("isProjected");
                    if (string3.equals("true")) {
                        dataModelContent.setIsProjected(true);
                        continue;
                    }
                    dataModelContent.setIsProjected(false);
                    continue;
                }
                string2 = element2.getAttribute("name");
                nodeList3 = STEMUtil.getMLevel(element2.getAttribute("measure"));
                object = element2.getAttribute("storage");
                int n = 0;
                if (((String)object).equals("string")) {
                    n = 8;
                    formatType = FormatType.A;
                } else {
                    formatType = ((String)object).equals("date") ? FormatType.DATE : FormatType.F;
                }
                SpssVariable spssVariable = new SpssVariable();
                spssVariable.setName(string2);
                spssVariable.setType((short)n);
                spssVariable.setMeasurementLevel((MeasurementLevel)nodeList3);
                SPSS_Format sPSS_Format = new SPSS_Format();
                sPSS_Format.setFormatType(formatType);
                spssVariable.setFormat(sPSS_Format);
                spssVariable.setId(STEMDataSourcePage.sIdGenerator.next());
                dataModelContent.addOneField((ISpssVariable)spssVariable);
            }
        }
        return dataModelContent;
    }

    public static MeasurementLevel getMLevel(String string) {
        if (string.equals("discrete")) {
            return MeasurementLevel.nominal;
        }
        if (string.equals("continuous")) {
            return MeasurementLevel.scale;
        }
        return MeasurementLevel.unknown;
    }

    private static ByteBuffer readEntry(JarInputStream jarInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        try {
            int n = jarInputStream.read(byArray, 0, 2048);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = jarInputStream.read(byArray, 0, 2048);
            }
        }
        catch (IOException iOException) {
            byteArrayOutputStream.reset();
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private static String getXMLFileName(String string, String string2, String string3) {
        Document document;
        DOMFactory dOMFactory = new DOMFactory();
        try {
            document = dOMFactory.createDOM(new InputSource(new FileInputStream(string + string2)), SchemaType.SCHEMA_NONE);
            if (document == null) {
                return "";
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return "";
        }
        Element element = document.getDocumentElement();
        if (string3.equals(element.getNodeName())) {
            return string2;
        }
        return "";
    }

    public static String removeSpaceFrom(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '-' || c == '$' || c == '.' || c == '#' || c == '@') continue;
            string2 = string2 + c;
        }
        if (string2.length() == 0) {
            string2 = "stemID";
        }
        return string2;
    }

    public static String showOpenMapSpecDialog(BaseDialog baseDialog, String string, String string2, String string3, RemoteFileChooser.ChooserType chooserType) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(chooserType, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileSelectionMode(0);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string3));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = chooserType == RemoteFileChooser.ChooserType.OpenFile ? remoteFileChooser.showOpenDialog((Component)baseDialog) : remoteFileChooser.showSaveDialog((Component)baseDialog);
        if (n == 0) {
            String string4 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            return string4;
        }
        return "";
    }

    static void setupColumnWidths(JTable jTable, double[] dArray) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (dArray == null || tableColumnModel.getColumnCount() != dArray.length) {
            return;
        }
        int n = jTable.getPreferredScrollableViewportSize().width;
        int n2 = 0;
        for (double d : dArray) {
            tableColumnModel.getColumn(n2).setPreferredWidth((int)((double)n * d));
            ++n2;
        }
    }

    static class DataModelContent {
        private Vector<ISpssVariable> mDataModelFields = new Vector();
        private GeoType mGeoType = GeoType.UNKNOWN;
        private int mCoordinates = -1;
        private int mWKId = -1;
        private String mCSName = "";
        private boolean mIsProjected = false;

        public Vector<ISpssVariable> getDataModelFields() {
            return this.mDataModelFields;
        }

        public void setDataModelFields(Vector<ISpssVariable> vector) {
            this.mDataModelFields = vector;
        }

        public void addOneField(ISpssVariable iSpssVariable) {
            if (this.mDataModelFields == null) {
                this.mDataModelFields = new Vector();
            }
            this.mDataModelFields.add(iSpssVariable);
        }

        public GeoType getGeoType() {
            return this.mGeoType;
        }

        public void setGeoType(GeoType geoType) {
            this.mGeoType = geoType;
        }

        public void setGeoType(String string) {
            this.mGeoType = string.equals("Point") ? GeoType.POINT : (string.equals("MultiPoint") ? GeoType.MULTI_POINT : (string.equals("LineString") ? GeoType.LINE : (string.equals("MultiLineString") ? GeoType.MULTI_LINE : (string.equals("Polygon") ? GeoType.POLYGON : (string.equals("MultiPolygon") ? GeoType.MULTI_POLYGON : GeoType.UNKNOWN)))));
        }

        public int getCoordinates() {
            return this.mCoordinates;
        }

        public void setCoordinates(int n) {
            this.mCoordinates = n;
        }

        public int getWKId() {
            return this.mWKId;
        }

        public void setWKId(int n) {
            this.mWKId = n;
        }

        public String getCSName() {
            return this.mCSName;
        }

        public void setCSName(String string) {
            this.mCSName = string;
        }

        public boolean isProjected() {
            return this.mIsProjected;
        }

        public void setIsProjected(boolean bl) {
            this.mIsProjected = bl;
        }
    }

    public static enum GeoType {
        POINT,
        MULTI_POINT,
        LINE,
        MULTI_LINE,
        POLYGON,
        MULTI_POLYGON,
        UNKNOWN;


        public String toString() {
            switch (this) {
                case POINT: {
                    return "Point";
                }
                case MULTI_POINT: {
                    return "MultiPoint";
                }
                case LINE: {
                    return "LineString";
                }
                case MULTI_LINE: {
                    return "MultiLineString";
                }
                case POLYGON: {
                    return "Polygon";
                }
                case MULTI_POLYGON: {
                    return "MultiPolygon";
                }
            }
            return "";
        }
    }
}

