/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.controls.ButtonEditCtrl;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.IButtonEditListener;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.STEM.BinningSubDlg;
import com.spss.java_client.ui.dialogs.STEM.CellComboBoxEditor;
import com.spss.java_client.ui.dialogs.STEM.ComboBoxEditor;
import com.spss.java_client.ui.dialogs.STEM.ComboBoxRender;
import com.spss.java_client.ui.dialogs.STEM.ContextDataItem;
import com.spss.java_client.ui.dialogs.STEM.ListWithCheckbox;
import com.spss.java_client.ui.dialogs.STEM.MultiFieldChooserSubDlg;
import com.spss.java_client.ui.dialogs.STEM.STEMUtil;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.STEM.StepSevenSidebarSelectorPanel;
import com.spss.java_client.ui.dialogs.STEM.UnEditableCellTextRenderer;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.direct_marketing.AbstractDialogStateWizardPage;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class STEMSettingsPage
extends AbstractDialogStateWizardPage
implements ActionListener,
TableModelListener,
DocumentListener {
    public static final String NEW_PMML_FILE_NAME = "IDS_NEW_PMML_FILE_NAME";
    public static final String NEW_MAP_FILE_NAME = "IDS_NEW_MAP_FILE_NAME";
    public static final String NEW_RULE_NAME_PREFIX = "IDS_NEW_RULE_NAME_PREFIX";
    static final String sDefaultSpecName = "*\\mapspec.mplan";
    static final String sBestNamePrefix = "Bestrule";
    private StepSevenSidebarSelectorPanel mParamAndOptionPanel;
    private JPanel mOutputPanel;
    private JPanel mRuleBuildingPanel;
    private JPanel mSavePanel;
    private JPanel mBinAndAggregPanel;
    private FocusableLabel mOutputSetting;
    private FocusableLabel mCreateTables;
    private JCheckBox mRuleConfCheck;
    private JCheckBox mRuleSupportCheck;
    private JCheckBox mRuleLiftCheck;
    private JCheckBox mRuleAnteSupportCheck;
    private JCheckBox mRuleDeployCheck;
    private FocusableLabel mRulesToDisplayLabel;
    private JLabel mRuleNumSpinLabel;
    private NumberSpinner mRuleNumSpinner;
    private FocusableLabel mCreateMaps;
    private JCheckBox mMapConfCheck;
    private JCheckBox mMapSupportCheck;
    private JCheckBox mMapLiftCheck;
    private JCheckBox mMapAnteSupportCheck;
    private JCheckBox mMapDeployCheck;
    private JLabel mMapNumSpinLabel;
    private NumberSpinner mMapNumSpinner;
    private JPanel mMapPanel;
    private JCheckBox mWordleCheck;
    private JLabel mWordleSortLabel;
    private JComboBox mWordleSortCombo;
    private JLabel mWordleNumSpinLabel;
    private NumberSpinner mWordleNumSpinner;
    private JCheckBox mModelFieldTranCheck;
    private JCheckBox mModelRecSummCheck;
    private JCheckBox mModelRuleStatsCheck;
    private JCheckBox mModelFreqItemCheck;
    private JCheckBox mModelFreqFieldCheck;
    private JCheckBox mModelExcludeInputs;
    private FocusableLabel mSaveSetting;
    private JCheckBox mSaveMapCheck;
    private FileTextField mMapFileField;
    private JLabel mMapFileLabel;
    private JButton mMapFileButton;
    private JCheckBox mCopyMapCheck;
    private JLabel mScoreSourceListLabel;
    private ListWithCheckbox mScoreSourceList;
    private FocusableTextArea mScoringInfo;
    private FocusableTextArea mTargetInfo;
    private JLabel mTargetTableLabel;
    private JTable mTargetValueTable;
    private DefaultTableModel mTargetValueTableModel;
    private FocusableTextArea mBestRuleInfo;
    private JLabel mBestRuleSpinLabel;
    private NumberSpinner mNumBestRuleSpinner;
    private JLabel mRuleNamePrefLabel;
    private StringTextField mRuleNamePrefField;
    private FocusableLabel mBuildRuleSetting;
    private FocusableTextArea mBuildItemPerRuleInfo;
    private JLabel mBuildMaxConsqSpinLabel;
    private NumberSpinner mBuildMaxConsqSpinner;
    private JLabel mBuildMaxAnteSpinLabel;
    private NumberSpinner mBuildMaxAnteSpinner;
    private FocusableTextArea mBuildRuleCritInfo;
    private JLabel mBuildCriConfSpinLabel;
    private NumberSpinner mBuildCriConfSpinner;
    private JLabel mBuildCriSuppSpinLabel;
    private NumberSpinner mBuildCriSuppSpinner;
    private JLabel mBuildCriAnteqSpinLabel;
    private NumberSpinner mBuildCriAnteSpinner;
    private JLabel mBuildCriLiftSpinLabel;
    private NumberSpinner mBuildCriLiftSpinner;
    private JLabel mBuildExcludeTableLabel;
    private JTable mBuildExcludeTable;
    private ComboBoxEditor mExcludeColOneEditor;
    private ComboBoxEditor mExcludeColTwoEditor;
    private DefaultTableModel mBuildExcludeTableModel;
    private JLabel mBuildSameTableLabel;
    private JTable mBuildSameTable;
    private ComboBoxEditor mSameColOneEditor;
    private ComboBoxEditor mSameColTwoEditor;
    private DefaultTableModel mBuildSameTableModel;
    private FocusableLabel mBinAndAggrSetting;
    private JCheckBox mAggregateMap;
    private JLabel mDefaultAggrLabel;
    private JComboBox mDefaultAggrCombo;
    private JLabel mOrdinalAggrLabel;
    private JComboBox mOrdinalAggrCombo;
    private JLabel mBinAutoSpinLabel;
    private NumberSpinner mBinAutoSpinner;
    private JLabel mBinContFieldTableLabel;
    private JTable mBinContFieldTable;
    private DefaultTableModel mBinContFieldTableModel;
    private CellComboBoxEditor mAggrComboEditor;
    private String[] mTableAggregationArray;
    private String[] mTableOrdinalArray;
    private JButton mFieldSelectButton;
    private JButton mDeleteButton;
    private DialogFocusTraversalPolicy mOutputPolicy;
    private DialogFocusTraversalPolicy mSavePolicy;
    private DialogFocusTraversalPolicy mRuleBuildPolicy;
    private DialogFocusTraversalPolicy mBinAndAggrPolicy;
    private String[] mAggregationArray;
    private String[] mOrdinalArray;
    private Vector<ISpssVariable> mContAndOrdinalVars;
    private Vector<ISpssVariable> mVarInAggreTable;
    private String mPreviousValue;
    private boolean mToNextPage = true;

    public STEMSettingsPage(BaseWizardDialog baseWizardDialog) {
        super("STEMSettingsPage", baseWizardDialog.getResString("IDS_STEM_STEP_ONE_TITLE"), baseWizardDialog, true);
    }

    @Override
    public String getNextPage() {
        if (this.mToNextPage) {
            return "STEMFinishPage";
        }
        this.mToNextPage = true;
        return null;
    }

    public boolean enableNextButton() {
        return this.validate();
    }

    @Override
    public boolean validate() {
        boolean bl = this.validateOutput();
        if (bl) {
            bl = this.validSavePanel();
        }
        if (bl) {
            bl = this.validateRuleBuilding();
        }
        if (bl) {
            bl = this.validateAggre();
        }
        return bl && super.validate();
    }

    private boolean validateOutput() {
        boolean bl = true;
        if (this.mRuleNumSpinner == null || this.mWordleCheck == null || this.mWordleNumSpinner == null || this.mMapNumSpinner == null) {
            return bl;
        }
        if (!STEMUtil.validateIntSpinner(this.mRuleNumSpinner, 1, 1000)) {
            return false;
        }
        if (this.mWordleCheck != null && this.mWordleCheck.isSelected() && !STEMUtil.validateIntSpinner(this.mWordleNumSpinner, 1, 10)) {
            return false;
        }
        if (this.mMapNumSpinner.isEnabled() && !STEMUtil.validateIntSpinner(this.mMapNumSpinner, 1, 10)) {
            return false;
        }
        return bl;
    }

    private boolean validSavePanel() {
        if (this.mNumBestRuleSpinner == null || this.mRuleNamePrefField == null || this.mSaveMapCheck == null || this.mMapFileField == null) {
            return true;
        }
        if (this.mNumBestRuleSpinner.isEnabled()) {
            if (!STEMUtil.validateIntSpinner(this.mNumBestRuleSpinner, 0, 5)) {
                return false;
            }
            if (this.mRuleNamePrefField.getText().length() == 0) {
                return false;
            }
        }
        return !this.mSaveMapCheck.isSelected() || this.mMapFileField.getText().length() != 0;
    }

    private boolean validateRuleBuilding() {
        boolean bl = true;
        if (this.mBuildMaxConsqSpinner == null || this.mBuildMaxAnteSpinner == null || this.mBuildCriConfSpinner == null || this.mBuildCriSuppSpinner == null || this.mBuildCriAnteSpinner == null || this.mBuildCriLiftSpinner == null) {
            return bl;
        }
        if (!STEMUtil.validateIntSpinner(this.mBuildMaxConsqSpinner, 1, 9)) {
            return false;
        }
        if (!STEMUtil.validateIntSpinner(this.mBuildMaxAnteSpinner, 0, 5)) {
            return false;
        }
        if (!STEMUtil.validateDoubleSpinner(this.mBuildCriConfSpinner, 0.01, 100.0)) {
            return false;
        }
        if (!STEMUtil.validateDoubleSpinner(this.mBuildCriSuppSpinner, 0.01, 100.0)) {
            return false;
        }
        if (!STEMUtil.validateDoubleSpinner(this.mBuildCriAnteSpinner, 0.01, 100.0)) {
            return false;
        }
        if (!STEMUtil.validateDoubleSpinner(this.mBuildCriLiftSpinner, 1.0, 10.0)) {
            return false;
        }
        return bl;
    }

    private boolean validateAggre() {
        boolean bl = true;
        if (this.mBinAutoSpinner == null) {
            return bl;
        }
        if (!STEMUtil.validateIntSpinner(this.mBinAutoSpinner, 2, 10)) {
            return false;
        }
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mWizardDialog.enableNext(this.enableNextButton());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mWizardDialog.enableNext(this.enableNextButton());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    void displayOutofRangeError(String string, String string2) {
        String string3 = String.format(ComponentState.getSPSSLocale(), this.mWizardDialog.getResString("IDS_STEM_OUT_OF_RANGE_VALUE"), string, string2);
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string3, VersionInfo.getAppVersionString());
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean validateOnBack() {
        ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().setKeepTarget(true);
        return true;
    }

    @Override
    protected void loadDialogState() {
    }

    @Override
    protected void saveDialogState() {
    }

    @Override
    public String getDialogHelpID() {
        int n = this.mParamAndOptionPanel.getSelectedIndex();
        switch (n) {
            case 0: {
                return "idh_stem_gsar_output";
            }
            case 1: {
                return "idh_stem_gsar_save";
            }
            case 2: {
                return "idh_stem_gsar_rule_building";
            }
            case 3: {
                return "idh_stem_gsar_bin_aggregate";
            }
        }
        return "";
    }

    public void reset() {
        this.setDefaults();
        this.mScoreSourceList.setListData(new Object[0]);
        this.mScoreSourceList.removeAll();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mWordleCheck) {
            this.enableWordlePanelControl();
        } else if (object == this.mSaveMapCheck) {
            this.enableSaveControls();
        } else if (object == this.mFieldSelectButton) {
            Vector<ISpssVariable> vector = this.getUnUsedVars();
            MultiFieldChooserSubDlg multiFieldChooserSubDlg = new MultiFieldChooserSubDlg(this.mWizardDialog, vector);
            multiFieldChooserSubDlg.setVisible(true);
            if (multiFieldChooserSubDlg.continuePressed()) {
                ISpssVariable[] iSpssVariableArray = multiFieldChooserSubDlg.getSelectedFields();
                this.addVarsToAggregationTable(iSpssVariableArray);
            }
        } else if (object == this.mDeleteButton) {
            this.deleteOneRowFromTable();
        } else if (object == this.mMapFileButton) {
            String string = STEMUtil.showOpenMapSpecDialog(this.mWizardDialog, this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SAVE_MAP_TITLE"), this.mWizardDialog.getResString("IDS_STEM_MAP_SPEC_STEM_PLAN_FILE_FILTER"), this.mWizardDialog.getResString("IDS_STEM_MAP_SPEC_STEM_PLAN_FILE_FILTER_EXTN"), RemoteFileChooser.ChooserType.SaveFile);
            this.mMapFileField.setText(string);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object = tableModelEvent.getSource();
        if (tableModelEvent.getType() == 0 && (object == this.mBuildExcludeTableModel || object == this.mBuildSameTableModel)) {
            int n = tableModelEvent.getLastRow();
            if (object == this.mBuildExcludeTableModel) {
                if (n == this.mBuildExcludeTableModel.getRowCount() - 1) {
                    Vector<String> vector = new Vector<String>();
                    vector.add("");
                    this.mBuildExcludeTableModel.addRow(vector);
                }
            } else {
                int n2 = tableModelEvent.getColumn();
                if (n == this.mBuildSameTableModel.getRowCount() - 1) {
                    Vector<String> vector = new Vector<String>();
                    vector.add("");
                    this.mBuildSameTableModel.addRow(vector);
                }
            }
        }
    }

    private boolean checkDuplicateValues(int n, int n2, String string, DefaultTableModel defaultTableModel, boolean bl) {
        boolean bl2 = false;
        int n3 = 0;
        if (n2 == 0) {
            n3 = 1;
        }
        String string2 = "";
        Object object = defaultTableModel.getValueAt(n, n3);
        if (object != null) {
            string2 = object.toString();
        }
        if (string.length() > 0 && string2.length() > 0) {
            boolean bl3;
            if (string.equals(string2)) {
                String string3 = this.mWizardDialog.getResString("IDS_STEM_MAP_SETTING_SAME_FIELD");
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string3, VersionInfo.getAppVersionString());
                bl2 = true;
            } else if (bl && !(bl3 = this.checkMeasurementLevel(string, string2))) {
                String string4 = this.mWizardDialog.getResString("IDS_STEM_MAP_SETTING_UNMATCH_MEASUR");
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string4, VersionInfo.getAppVersionString());
                bl2 = true;
            }
        }
        return bl2;
    }

    private Vector<ISpssVariable> getUnUsedVars() {
        int n = this.mBinContFieldTableModel.getRowCount();
        if (n == 0) {
            return this.mContAndOrdinalVars;
        }
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < this.mContAndOrdinalVars.size(); ++i) {
            if (this.mVarInAggreTable.contains(this.mContAndOrdinalVars.get(i))) continue;
            vector.add(this.mContAndOrdinalVars.get(i));
        }
        return vector;
    }

    private boolean checkMeasurementLevel(String string, String string2) {
        return ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().isSameMeasurLevel(string, string2);
    }

    private void addVarsToAggregationTable(ISpssVariable[] iSpssVariableArray) {
        if (iSpssVariableArray == null || iSpssVariableArray.length == 0) {
            return;
        }
        if (this.mVarInAggreTable == null) {
            this.mVarInAggreTable = new Vector();
        }
        int n = iSpssVariableArray.length;
        for (int i = 0; i < n; ++i) {
            JComboBox<String> jComboBox;
            Vector<String> vector = new Vector<String>();
            ISpssVariable iSpssVariable = iSpssVariableArray[i];
            String string = ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().getDataSourceIdFor(iSpssVariable);
            vector.add(string);
            vector.add(iSpssVariable.getName());
            if (iSpssVariable.getMeasurementLevel() == MeasurementLevel.ordinal) {
                jComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mTableOrdinalArray));
            } else {
                if (iSpssVariable.getMeasurementLevel() != MeasurementLevel.scale) continue;
                jComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mTableAggregationArray));
            }
            boolean bl = ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().isDataSourceEvent(string);
            jComboBox.setSelectedIndex(0);
            if (bl) {
                jComboBox.setEnabled(false);
            }
            vector.add(jComboBox.getSelectedItem().toString());
            vector.add("");
            this.mBinContFieldTableModel.addRow(vector);
            int n2 = this.mBinContFieldTableModel.getRowCount();
            this.mAggrComboEditor.addRowEditor(n2 - 1, new DefaultCellEditor(jComboBox));
            this.mVarInAggreTable.add(iSpssVariable);
        }
        this.mBinContFieldTable.getColumnModel().getColumn(2).setCellEditor(this.mAggrComboEditor);
    }

    @Override
    public void init() {
        this.initVars();
        this.setupOutputPanel();
        this.setupSavePanel();
        this.setupRuleBuildingPanel();
        this.setupBinAndAggregPanel();
        this.mParamAndOptionPanel.addPanel(this.mOutputPanel, this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_TITLE"), this.mOutputPolicy);
        this.mParamAndOptionPanel.addPanel(this.mSavePanel, this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SAVE_TITLE"), this.mSavePolicy);
        this.mParamAndOptionPanel.addPanel(this.mRuleBuildingPanel, this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_RULE_BUIDING_TITLE"), this.mRuleBuildPolicy);
        this.mParamAndOptionPanel.addPanel(this.mBinAndAggregPanel, this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_AGGREGATION_TITLE"), this.mBinAndAggrPolicy);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, n2, n2 * 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, n2, 2, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mParamAndOptionPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.setDefaults();
    }

    private void setOutputTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mOutputSetting);
        vector.add(this.mCreateTables);
        vector.add(this.mRuleConfCheck);
        vector.add(this.mRuleSupportCheck);
        vector.add(this.mRuleLiftCheck);
        vector.add(this.mRuleAnteSupportCheck);
        vector.add(this.mRuleDeployCheck);
        vector.add(this.mRulesToDisplayLabel);
        vector.add(this.mRuleNumSpinner.getEditor());
        vector.add(this.mCreateMaps);
        vector.add(this.mMapConfCheck);
        vector.add(this.mMapSupportCheck);
        vector.add(this.mMapLiftCheck);
        vector.add(this.mMapAnteSupportCheck);
        vector.add(this.mMapDeployCheck);
        vector.add(this.mMapNumSpinner.getEditor());
        vector.add(this.mWordleCheck);
        vector.add(this.mWordleSortCombo);
        vector.add(this.mWordleNumSpinner.getEditor());
        vector.add(this.mModelFieldTranCheck);
        vector.add(this.mModelRecSummCheck);
        vector.add(this.mModelRuleStatsCheck);
        vector.add(this.mModelFreqItemCheck);
        vector.add(this.mModelFreqFieldCheck);
        vector.add(this.mModelExcludeInputs);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mOutputPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setSaveTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mSaveSetting);
        vector.add(this.mSaveMapCheck);
        vector.add(this.mMapFileField);
        vector.add(this.mMapFileButton);
        vector.add(this.mCopyMapCheck);
        vector.add(this.mScoreSourceList);
        vector.add(this.mScoringInfo);
        vector.add(this.mTargetInfo);
        vector.add(this.mTargetValueTable);
        vector.add(this.mBestRuleInfo);
        vector.add(this.mNumBestRuleSpinner.getEditor());
        vector.add(this.mRuleNamePrefField);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mSavePolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setRuleBuildingTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mBuildRuleSetting);
        vector.add(this.mBuildItemPerRuleInfo);
        vector.add(this.mBuildMaxConsqSpinner.getEditor());
        vector.add(this.mBuildMaxAnteSpinner.getEditor());
        vector.add(this.mBuildRuleCritInfo);
        vector.add(this.mBuildCriConfSpinner.getEditor());
        vector.add(this.mBuildCriSuppSpinner.getEditor());
        vector.add(this.mBuildCriAnteSpinner.getEditor());
        vector.add(this.mBuildCriLiftSpinner.getEditor());
        vector.add(this.mBuildExcludeTable);
        vector.add(this.mBuildSameTable);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mRuleBuildPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private void setBinAndAggrTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.addAll(this.mParamAndOptionPanel.getTraversalComponent());
        vector.add(this.mBinAndAggrSetting);
        vector.add(this.mAggregateMap);
        vector.add(this.mDefaultAggrCombo);
        vector.add(this.mOrdinalAggrCombo);
        vector.add(this.mBinAutoSpinLabel);
        vector.add(this.mBinAutoSpinner.getEditor());
        vector.add(this.mBinContFieldTable);
        vector.add(this.mFieldSelectButton);
        vector.add(this.mDeleteButton);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mBinAndAggrPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        boolean bl = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().hasMap();
        if (!bl) {
            this.mMapPanel.setEnabled(false);
            this.mCreateMaps.setEnabled(false);
            this.mMapConfCheck.setEnabled(false);
            this.mMapSupportCheck.setEnabled(false);
            this.mMapLiftCheck.setEnabled(false);
            this.mMapAnteSupportCheck.setEnabled(false);
            this.mMapDeployCheck.setEnabled(false);
            this.mMapNumSpinLabel.setEnabled(false);
            this.mMapNumSpinner.setEnabled(false);
        } else {
            this.mMapPanel.setEnabled(true);
            this.mCreateMaps.setEnabled(true);
            this.mMapConfCheck.setEnabled(true);
            this.mMapSupportCheck.setEnabled(true);
            this.mMapLiftCheck.setEnabled(true);
            this.mMapAnteSupportCheck.setEnabled(true);
            this.mMapDeployCheck.setEnabled(true);
            this.mMapNumSpinLabel.setEnabled(true);
            this.mMapNumSpinner.setEnabled(true);
        }
        boolean bl2 = this.setupScoringSourceList(bl);
        this.setupTargetTable();
        this.setupTreatedSameTable();
        this.setupExcludeTable();
        this.mContAndOrdinalVars = ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().getContAndOrdinalModelField();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = this.getTraversalPolicy(this.mParamAndOptionPanel.getSelectedIndex());
        if (dialogFocusTraversalPolicy != null) {
            this.mWizardDialog.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        }
        if (bl2) {
            this.mAggregateMap.setSelected(false);
        } else {
            this.mAggregateMap.setSelected(true);
        }
        this.mWizardDialog.enableFinish(true);
    }

    private DialogFocusTraversalPolicy getTraversalPolicy(int n) {
        switch (n) {
            case 0: {
                return this.mOutputPolicy;
            }
            case 1: {
                return this.mSavePolicy;
            }
            case 2: {
                return this.mRuleBuildPolicy;
            }
            case 3: {
                return this.mBinAndAggrPolicy;
            }
        }
        return null;
    }

    private boolean setupScoringSourceList(boolean bl) {
        boolean bl2 = false;
        String string = "";
        Vector<ContextDataItem> vector = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getDataSourceList(false);
        if (vector.size() > 0) {
            string = vector.get(0).getMapAssocId();
        }
        this.mScoreSourceList.setListData(new Object[0]);
        this.mScoreSourceList.removeAll();
        int n = 0;
        for (ContextDataItem contextDataItem : vector) {
            JCheckBox jCheckBox = new JCheckBox(contextDataItem.getSourceId());
            jCheckBox.setSelected(false);
            this.mScoreSourceList.addCheckbox(jCheckBox);
            if (bl && !bl2 && n > 0) {
                if (string.equals(contextDataItem.getMapAssocId())) {
                    bl2 = true;
                } else {
                    string = contextDataItem.getMapAssocId();
                }
            }
            ++n;
        }
        this.enableTargetAndBestRule();
        return bl2;
    }

    private void setupTargetTable() {
        Vector<String> vector = ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().getPredFields();
        this.mTargetValueTableModel.setNumRows(0);
        this.mTargetValueTable.removeAll();
        int n = vector.size();
        if (n == 0) {
            return;
        }
        if (n > 5) {
            n = 5;
        }
        for (int i = 0; i < n; ++i) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add("");
            this.mTargetValueTableModel.addRow(vector2);
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        for (String string : vector) {
            stringArray[n2++] = string;
        }
        ComboBoxEditor comboBoxEditor = new ComboBoxEditor(stringArray);
        this.mTargetValueTable.getColumnModel().getColumn(0).setCellEditor(comboBoxEditor);
        this.mTargetValueTable.getColumnModel().getColumn(0).setCellRenderer(new ComboBoxRender(stringArray));
    }

    private void setupTreatedSameTable() {
        String[] stringArray;
        Vector<String> vector = ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().getAllModelFields();
        this.mBuildSameTableModel.setNumRows(0);
        this.mBuildSameTable.removeAll();
        int n = vector.size();
        if (n == 0) {
            return;
        }
        if (n > 5) {
            n = 5;
        }
        for (int i = 0; i < n; ++i) {
            stringArray = new Vector();
            stringArray.add("");
            this.mBuildSameTableModel.addRow((Vector<?>)stringArray);
        }
        ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_NOMINAL_VAR_IMAGE")));
        stringArray = new String[vector.size()];
        int n2 = 0;
        ImageIcon[] imageIconArray = new ImageIcon[vector.size()];
        for (String string : vector) {
            imageIconArray[n2] = imageIcon;
            stringArray[n2++] = string;
        }
        this.mSameColOneEditor = new ComboBoxEditor(stringArray);
        this.mBuildSameTable.getColumnModel().getColumn(0).setCellEditor(this.mSameColOneEditor);
        this.mSameColOneEditor.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = STEMSettingsPage.this.mSameColOneEditor.getCellEditorValue()) != null) {
                    String string = object.toString();
                    int n = STEMSettingsPage.this.mBuildSameTable.getSelectedRow();
                    int n2 = STEMSettingsPage.this.mBuildSameTable.getSelectedColumn();
                    Object object2 = STEMSettingsPage.this.mBuildSameTableModel.getValueAt(n, n2);
                    boolean bl = STEMSettingsPage.this.checkDuplicateValues(n, n2, string, STEMSettingsPage.this.mBuildSameTableModel, true);
                    if (bl) {
                        STEMSettingsPage.this.mSameColOneEditor.getComboBox().setSelectedItem(object2);
                    }
                }
            }
        });
        this.mBuildSameTable.getColumnModel().getColumn(0).setCellRenderer(new ComboBoxRender(stringArray));
        this.mSameColTwoEditor = new ComboBoxEditor(stringArray);
        this.mBuildSameTable.getColumnModel().getColumn(1).setCellEditor(this.mSameColTwoEditor);
        this.mSameColTwoEditor.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = STEMSettingsPage.this.mSameColTwoEditor.getCellEditorValue()) != null) {
                    String string = object.toString();
                    int n = STEMSettingsPage.this.mBuildSameTable.getSelectedRow();
                    int n2 = STEMSettingsPage.this.mBuildSameTable.getSelectedColumn();
                    Object object2 = STEMSettingsPage.this.mBuildSameTableModel.getValueAt(n, n2);
                    boolean bl = STEMSettingsPage.this.checkDuplicateValues(n, n2, string, STEMSettingsPage.this.mBuildSameTableModel, true);
                    if (bl) {
                        STEMSettingsPage.this.mSameColTwoEditor.getComboBox().setSelectedItem(object2);
                    }
                }
            }
        });
        this.mBuildSameTable.getColumnModel().getColumn(1).setCellRenderer(new ComboBoxRender(stringArray));
    }

    private void setupExcludeTable() {
        Vector<String> vector = ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().getAllModelFields();
        this.mBuildExcludeTableModel.setNumRows(0);
        this.mBuildExcludeTable.removeAll();
        int n = vector.size();
        if (n == 0) {
            return;
        }
        if (n > 5) {
            n = 5;
        }
        for (int i = 0; i < n; ++i) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add("");
            this.mBuildExcludeTableModel.addRow(vector2);
        }
        String[] stringArray = new String[vector.size() + 1];
        int n2 = 0;
        for (String string : vector) {
            stringArray[n2++] = string;
        }
        this.mExcludeColOneEditor = new ComboBoxEditor(stringArray);
        this.mExcludeColTwoEditor = new ComboBoxEditor(stringArray);
        this.mBuildExcludeTable.getColumnModel().getColumn(0).setCellEditor(this.mExcludeColOneEditor);
        this.mExcludeColOneEditor.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = STEMSettingsPage.this.mExcludeColOneEditor.getCellEditorValue()) != null) {
                    String string = object.toString();
                    int n = STEMSettingsPage.this.mBuildExcludeTable.getSelectedRow();
                    int n2 = STEMSettingsPage.this.mBuildExcludeTable.getSelectedColumn();
                    Object object2 = STEMSettingsPage.this.mBuildExcludeTableModel.getValueAt(n, n2);
                    boolean bl = STEMSettingsPage.this.checkDuplicateValues(n, n2, string, STEMSettingsPage.this.mBuildExcludeTableModel, false);
                    if (bl) {
                        STEMSettingsPage.this.mExcludeColOneEditor.getComboBox().setSelectedItem(object2);
                    }
                }
            }
        });
        this.mBuildExcludeTable.getColumnModel().getColumn(0).setCellRenderer(new ComboBoxRender(stringArray));
        this.mBuildExcludeTable.getColumnModel().getColumn(1).setCellEditor(this.mExcludeColTwoEditor);
        this.mExcludeColTwoEditor.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = STEMSettingsPage.this.mExcludeColTwoEditor.getCellEditorValue()) != null) {
                    String string = object.toString();
                    int n = STEMSettingsPage.this.mBuildExcludeTable.getSelectedRow();
                    int n2 = STEMSettingsPage.this.mBuildExcludeTable.getSelectedColumn();
                    Object object2 = STEMSettingsPage.this.mBuildExcludeTableModel.getValueAt(n, n2);
                    boolean bl = STEMSettingsPage.this.checkDuplicateValues(n, n2, string, STEMSettingsPage.this.mBuildExcludeTableModel, false);
                    if (bl) {
                        STEMSettingsPage.this.mExcludeColTwoEditor.getComboBox().setSelectedItem(object2);
                    }
                }
            }
        });
        this.mBuildExcludeTable.getColumnModel().getColumn(1).setCellRenderer(new ComboBoxRender(stringArray));
    }

    private void setDefaults() {
        this.setOutputDefaults();
        this.mAggregateMap.setSelected(true);
        this.mOrdinalAggrCombo.setSelectedIndex(1);
        this.enableSaveControls();
    }

    private void setOutputDefaults() {
        this.mWordleCheck.setSelected(false);
        this.mRuleConfCheck.setSelected(true);
        this.mRuleSupportCheck.setSelected(true);
        this.mMapConfCheck.setSelected(true);
        this.mMapSupportCheck.setSelected(true);
        this.mModelRuleStatsCheck.setSelected(true);
        this.mModelFreqFieldCheck.setSelected(true);
        this.enableWordlePanelControl();
    }

    private void enableSaveControls() {
        if (this.mSaveMapCheck.isSelected()) {
            this.mMapFileLabel.setEnabled(true);
            this.mMapFileField.setEnabled(true);
            this.mMapFileButton.setEnabled(true);
            this.mCopyMapCheck.setEnabled(true);
        } else {
            this.mMapFileLabel.setEnabled(false);
            this.mMapFileField.setEnabled(false);
            this.mMapFileButton.setEnabled(false);
            this.mCopyMapCheck.setEnabled(false);
        }
        this.mWizardDialog.enableNext(this.enableNextButton());
    }

    private void deleteOneRowFromTable() {
        int n = this.mBinContFieldTable.getSelectedRow();
        if (n >= 0) {
            this.mBinContFieldTableModel.removeRow(n);
        }
    }

    private void initVars() {
        this.mParamAndOptionPanel = new StepSevenSidebarSelectorPanel(this.mWizardDialog, "STEM_SETTINGS_Tab", this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SIDEBAR_LABEL"), 83, this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_INFO_TEXT"));
        this.initOutputPanelVars();
        this.initSavePanelVars();
        this.initRuleBuidingPanelVars();
        this.initBinAndAggrPanelVars();
    }

    private void initOutputPanelVars() {
        this.mOutputSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_SETTIMG_INFO"));
        this.mCreateTables = new FocusableLabel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_CREATE_TABLE_LABEL"));
        this.mRuleConfCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_RULE_CONF", null);
        this.mRuleSupportCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_RULE_SUPPORT", null);
        this.mRuleLiftCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_RULE_LIFT", null);
        this.mRuleAnteSupportCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_RULE_ANTE", null);
        this.mRuleDeployCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_RULE_DEPLOY", null);
        this.mRulesToDisplayLabel = new FocusableLabel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_RULE_TO_SHOW_LABEL"));
        this.mRuleNumSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_RULE_NUM");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(30, 1, 1000, 1);
        IntTextField intTextField = new IntTextField(1, 1000, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STEMSettingsPage.this.validate()) {
                        STEMSettingsPage.this.mToNextPage = false;
                    } else {
                        STEMSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mRuleNumSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mRuleNumSpinner.setAlignmentX(1.0f);
        this.mRuleNumSpinLabel.setLabelFor(this.mRuleNumSpinner.getEditor());
        this.mCreateMaps = new FocusableLabel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_CREATE_MAP_LABEL"));
        this.mMapConfCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MAP_CONF", null);
        this.mMapSupportCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MAP_SUPPORT", null);
        this.mMapLiftCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MAP_LIFT", null);
        this.mMapAnteSupportCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MAP_ANTE", null);
        this.mMapDeployCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MAP_DEPLOY", null);
        this.mMapNumSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MAP_NUM");
        spinnerNumberModel = new SpinnerNumberModel(5, 1, 10, 1);
        intTextField = new IntTextField(1, 10, true);
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mMapNumSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mMapNumSpinner.setAlignmentX(1.0f);
        this.mMapNumSpinLabel.setLabelFor(this.mMapNumSpinner.getEditor());
        this.mWordleCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_CHECK", null);
        this.mWordleCheck.addActionListener(this);
        String[] stringArray = this.mWizardDialog.getResStringArray("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT_ARRARY");
        this.mWordleSortLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT");
        this.mWordleSortCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(stringArray));
        this.mWordleSortCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_SORT"));
        this.mWordleSortLabel.setLabelFor(this.mWordleSortCombo);
        this.mWordleNumSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_NUL_RULES");
        spinnerNumberModel = new SpinnerNumberModel(10, 1, 10, 1);
        intTextField = new IntTextField(1, 10, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STEMSettingsPage.this.validate()) {
                        STEMSettingsPage.this.mToNextPage = false;
                    } else {
                        STEMSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mWordleNumSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mWordleNumSpinner.setAlignmentX(1.0f);
        this.mWordleNumSpinLabel.setLabelFor(this.mWordleNumSpinner.getEditor());
        this.mModelFieldTranCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MODEL_TRANS", null);
        this.mModelRecSummCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MODEL_SUMMARY", null);
        this.mModelRuleStatsCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MODEL_RULE_STATS", null);
        this.mModelFreqItemCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MODEL_FREQ_ITEM", null);
        this.mModelFreqFieldCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MODEL_FREQ_FIELDS", null);
        this.mModelExcludeInputs = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_OUTPUT_MODEL_EXCLUDE_INPUT", null);
    }

    private void initRuleBuidingPanelVars() {
        this.mBuildRuleSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_BUIDING_INFO"));
        this.mBuildItemPerRuleInfo = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_BUIDING_ITEM_PER_RULE_INFO"), null);
        this.mBuildMaxConsqSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BUIDING_ITEM_PER_RULE_MAX_CONSEQ");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 9, 1);
        IntTextField intTextField = new IntTextField(1, 9, true);
        intTextField.setHorizontalAlignment(4);
        intTextField.getDocument().addDocumentListener(this);
        this.mBuildMaxConsqSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mBuildMaxConsqSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = ((JTextField)STEMSettingsPage.this.mBuildMaxConsqSpinner.getEditor()).getText();
                int n = Integer.parseInt(string);
                int n2 = Integer.parseInt(((JTextField)STEMSettingsPage.this.mBuildMaxAnteSpinner.getEditor()).getText());
                int n3 = n2 + n;
                if (n3 >= 10 && (n2 = 10 - n) <= 5 && n2 >= 0) {
                    ((JTextField)STEMSettingsPage.this.mBuildMaxAnteSpinner.getEditor()).setText(Integer.toString(n2));
                }
            }
        });
        this.mBuildMaxConsqSpinner.setAlignmentX(1.0f);
        this.mBuildMaxConsqSpinLabel.setLabelFor(this.mBuildMaxConsqSpinner.getEditor());
        this.mBuildMaxAnteSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BUIDING_ITEM_PER_RULE_MAX_ANTE");
        spinnerNumberModel = new SpinnerNumberModel(5, 0, 5, 1);
        intTextField = new IntTextField(0, 5, true);
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mBuildMaxAnteSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mBuildMaxAnteSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n;
                String string = ((JTextField)STEMSettingsPage.this.mBuildMaxAnteSpinner.getEditor()).getText();
                int n2 = Integer.parseInt(string);
                if (n2 + (n = Integer.parseInt(((JTextField)STEMSettingsPage.this.mBuildMaxConsqSpinner.getEditor()).getText())) >= 10 && (n = 10 - n2) <= 9 && n >= 1) {
                    ((JTextField)STEMSettingsPage.this.mBuildMaxConsqSpinner.getEditor()).setText(Integer.toString(n));
                }
            }
        });
        this.mBuildMaxAnteSpinner.setAlignmentX(1.0f);
        this.mBuildMaxAnteSpinLabel.setLabelFor(this.mBuildMaxAnteSpinner.getEditor());
        this.mBuildRuleCritInfo = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_BUIDING_RULE_CRIT_INFO"), null);
        this.mBuildRuleCritInfo.setRows(2);
        this.mBuildCriConfSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BUIDING_RULE_CRIT_CONF");
        spinnerNumberModel = new SpinnerNumberModel(10.0, 0.01, 100.0, 1.0);
        FloatTextField floatTextField = new FloatTextField(0.0, 100.0, 1, true);
        floatTextField.setHorizontalAlignment(4);
        this.mBuildCriConfSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        floatTextField.getDocument().addDocumentListener(this);
        this.mBuildCriConfSpinner.setAlignmentX(1.0f);
        this.mBuildCriConfSpinLabel.setLabelFor(this.mBuildCriConfSpinner.getEditor());
        this.mBuildCriSuppSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BUIDING_RULE_CRIT_SUPPORT");
        spinnerNumberModel = new SpinnerNumberModel(5.0, 0.01, 100.0, 1.0);
        floatTextField = new FloatTextField(0.0, 100.0, 1, true);
        floatTextField.getDocument().addDocumentListener(this);
        floatTextField.setHorizontalAlignment(4);
        this.mBuildCriSuppSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        this.mBuildCriSuppSpinner.setAlignmentX(1.0f);
        this.mBuildCriSuppSpinLabel.setLabelFor(this.mBuildCriSuppSpinner.getEditor());
        this.mBuildCriAnteqSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BUIDING_RULE_CRIT_ANTE");
        spinnerNumberModel = new SpinnerNumberModel(5.0, 0.01, 100.0, 1.0);
        floatTextField = new FloatTextField(0.0, 100.0, 1, true);
        floatTextField.getDocument().addDocumentListener(this);
        floatTextField.setHorizontalAlignment(4);
        this.mBuildCriAnteSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        this.mBuildCriAnteSpinner.setAlignmentX(1.0f);
        this.mBuildCriAnteqSpinLabel.setLabelFor(this.mBuildCriAnteSpinner.getEditor());
        this.mBuildCriLiftSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BUIDING_RULE_CRIT_LIFT");
        spinnerNumberModel = new SpinnerNumberModel(1.2, 1.0, 10.0, 0.1);
        floatTextField = new FloatTextField(1.0, 10.0, 2, true);
        floatTextField.getDocument().addDocumentListener(this);
        floatTextField.setHorizontalAlignment(4);
        this.mBuildCriLiftSpinner = new NumberSpinner(floatTextField, spinnerNumberModel);
        this.mBuildCriLiftSpinner.setAlignmentX(1.0f);
        this.mBuildCriLiftSpinLabel.setLabelFor(this.mBuildCriLiftSpinner.getEditor());
        this.mBuildExcludeTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BUIDING_EXCLUDE_TABLE_LABEL");
        this.mBuildExcludeTableModel = new DefaultTableModel(new String[]{"", ""}, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mBuildExcludeTableModel.addTableModelListener(this);
        this.mBuildExcludeTable = new PlainTable();
        this.mBuildExcludeTable.setModel(this.mBuildExcludeTableModel);
        this.mBuildExcludeTable.setRowHeight(22);
        this.mBuildExcludeTable.setColumnSelectionAllowed(false);
        this.mBuildExcludeTable.setRowSelectionAllowed(true);
        this.mBuildExcludeTable.setSelectionMode(0);
        this.mBuildExcludeTable.getTableHeader().setReorderingAllowed(false);
        this.mBuildExcludeTable.getTableHeader().setResizingAllowed(true);
        this.mBuildExcludeTable.setGridColor(Color.darkGray);
        this.mBuildExcludeTable.getTableHeader().setReorderingAllowed(false);
        this.mBuildExcludeTable.setSelectionMode(0);
        this.mBuildExcludeTableLabel.setLabelFor(this.mBuildExcludeTable);
        this.mBuildSameTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BUIDING_TREAT_TABLE_LABEL");
        this.mBuildSameTableModel = new DefaultTableModel(new String[]{"", ""}, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mBuildSameTableModel.addTableModelListener(this);
        this.mBuildSameTable = new PlainTable();
        this.mBuildSameTable.setModel(this.mBuildSameTableModel);
        this.mBuildSameTable.setRowHeight(22);
        this.mBuildSameTable.setColumnSelectionAllowed(false);
        this.mBuildSameTable.setRowSelectionAllowed(true);
        this.mBuildSameTable.setSelectionMode(0);
        this.mBuildSameTable.getTableHeader().setReorderingAllowed(false);
        this.mBuildSameTable.getTableHeader().setResizingAllowed(true);
        this.mBuildSameTable.setGridColor(Color.darkGray);
        this.mBuildSameTable.getTableHeader().setReorderingAllowed(false);
        this.mBuildSameTable.setSelectionMode(0);
        this.mBuildSameTableLabel.setLabelFor(this.mBuildSameTable);
    }

    private void initSavePanelVars() {
        this.mSaveSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SAVE_SETTIMG_INFO"));
        this.mSaveMapCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_SAVE_MAP_CHECK", null);
        this.mSaveMapCheck.addActionListener(this);
        this.mMapFileLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_SAVE_MAP_FIELD");
        this.mMapFileField = new FileTextField();
        this.mMapFileField.getDocument().addDocumentListener(this);
        this.mMapFileField.setColumns(30);
        this.mMapFileField.setAction(new TextFieldAction(this.mWizardDialog, NEW_MAP_FILE_NAME));
        this.mMapFileLabel.setLabelFor((Component)((Object)this.mMapFileField));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_SAVE_MAP_BUTTON");
        this.mMapFileButton = new JButton(toggleButtonAction);
        this.mMapFileButton.addActionListener(this);
        this.mCopyMapCheck = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_SAVE_COPY_MAP", null);
        this.mScoreSourceListLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_SETTINGS_SAVE_SCORING_LIST_LABEL");
        this.mScoreSourceList = new ListWithCheckbox();
        this.mScoreSourceList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    JCheckBox jCheckBox;
                    int n = STEMSettingsPage.this.mScoreSourceList.getSelectedIndex();
                    jCheckBox.setSelected(!(jCheckBox = (JCheckBox)STEMSettingsPage.this.mScoreSourceList.getModel().getElementAt(n)).isSelected());
                    STEMSettingsPage.this.mScoreSourceList.repaint();
                }
            }
        });
        this.mScoreSourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = STEMSettingsPage.this.mScoreSourceList.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    JCheckBox jCheckBox;
                    jCheckBox.setSelected(!(jCheckBox = (JCheckBox)STEMSettingsPage.this.mScoreSourceList.getModel().getElementAt(n)).isSelected());
                    STEMSettingsPage.this.enableTargetAndBestRule();
                    STEMSettingsPage.this.mScoreSourceList.repaint();
                }
            }
        });
        this.mScoreSourceListLabel.setLabelFor(this.mScoreSourceList);
        this.mScoringInfo = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_SETTINGS_SAVE_SCORING_PANEL_MESSAGE"), null);
        this.mScoringInfo.setRows(3);
        this.mTargetInfo = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SAVE_TARGET_INFO"), null);
        this.mTargetTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_SAVE_TARGET_LABEL");
        this.mTargetValueTableModel = new DefaultTableModel(new String[]{""}, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        };
        this.mTargetValueTable = new PlainTable();
        this.mTargetValueTable.setModel(this.mTargetValueTableModel);
        this.mTargetValueTable.setRowHeight(22);
        this.mTargetValueTable.setColumnSelectionAllowed(false);
        this.mTargetValueTable.setRowSelectionAllowed(true);
        this.mTargetValueTable.setSelectionMode(0);
        this.mTargetValueTable.getTableHeader().setReorderingAllowed(false);
        this.mTargetValueTable.getTableHeader().setResizingAllowed(true);
        this.mTargetValueTable.setGridColor(Color.darkGray);
        this.mTargetValueTable.getTableHeader().setReorderingAllowed(false);
        this.mTargetValueTable.setSelectionMode(0);
        this.mTargetTableLabel.setLabelFor(this.mTargetValueTable);
        this.mBestRuleInfo = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SAVE_BEST_RULE_INFO"), null);
        this.mBestRuleInfo.setRows(2);
        this.mBestRuleSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_SAVE_BEST_RULE_NUM_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(3, 0, 5, 1);
        IntTextField intTextField = new IntTextField(0, 5, true);
        intTextField.getDocument().addDocumentListener(this);
        intTextField.setHorizontalAlignment(4);
        this.mNumBestRuleSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mNumBestRuleSpinner.setAlignmentX(1.0f);
        this.mBestRuleSpinLabel.setLabelFor(this.mNumBestRuleSpinner.getEditor());
        this.mRuleNamePrefLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_SAVE_BEST_RULE_NAME_LABEL");
        this.mRuleNamePrefField = new StringTextField(sBestNamePrefix);
        this.mRuleNamePrefField.getDocument().addDocumentListener(this);
        this.mRuleNamePrefField.setColumns(15);
        this.mRuleNamePrefField.setAction(new TextFieldAction(this.mWizardDialog, NEW_RULE_NAME_PREFIX));
        this.mRuleNamePrefLabel.setLabelFor((Component)((Object)this.mRuleNamePrefField));
    }

    private void initBinAndAggrPanelVars() {
        this.mBinAndAggrSetting = new FocusableLabel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_BINNING_INFO"));
        this.mAggregateMap = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_STEM_STEP_FIVE_AGGREGATE_MAP_CHECK");
        this.mAggregationArray = this.mWizardDialog.getResStringArray("IDS_STEM_STEP_FIVE_FIELDS_AGGREGATION_ARRARY");
        this.mDefaultAggrLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_DEFAULT_AGGRAGATION");
        this.mDefaultAggrCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mAggregationArray));
        this.mDefaultAggrCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_DEFAULT_AGGRAGATION"));
        this.mDefaultAggrLabel.setLabelFor(this.mDefaultAggrCombo);
        this.mOrdinalArray = this.mWizardDialog.getResStringArray("IDS_STEM_STEP_FIVE_FIELDS_AGGR_ORDINAL_ARRARY");
        this.mOrdinalAggrLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_DEFAULT_ORDINAL");
        this.mOrdinalAggrCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(this.mOrdinalArray));
        this.mOrdinalAggrCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_DEFAULT_AGGRAGATION_ORDINAL"));
        this.mOrdinalAggrLabel.setLabelFor(this.mOrdinalAggrCombo);
        this.mBinAutoSpinLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BINNING_AUTO_BIN");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(5, 2, 10, 1);
        IntTextField intTextField = new IntTextField(2, 10, true);
        intTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!STEMSettingsPage.this.validate()) {
                        STEMSettingsPage.this.mToNextPage = false;
                    } else {
                        STEMSettingsPage.this.mToNextPage = true;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        intTextField.setHorizontalAlignment(4);
        intTextField.getDocument().addDocumentListener(this);
        this.mBinAutoSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mBinAutoSpinner.setAlignmentX(1.0f);
        this.mBinAutoSpinLabel.setLabelFor(this.mBinAutoSpinner.getEditor());
        this.mTableAggregationArray = this.mWizardDialog.getResStringArray("IDS_STEM_STEP_FIVE_FIELDS_TABLE_AGGREGATION_ARRARY");
        this.mTableOrdinalArray = this.mWizardDialog.getResStringArray("IDS_STEM_STEP_FIVE_FIELDS_TABLE_AGGR_ORDINAL_ARRARY");
        this.mBinContFieldTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_SEVEN_BINNING_CONT_FIELD_TABLE");
        Object[] objectArray = this.mWizardDialog.getResStringArray("IDS_STEM_STEP_SEVEN_BINNING_CONT_FIELD_TABLE_HEADER");
        this.mBinContFieldTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n < 0 || n2 < 0) {
                    return false;
                }
                if (n2 == 3) {
                    return true;
                }
                if (n2 == 2) {
                    String string = STEMSettingsPage.this.mBinContFieldTableModel.getValueAt(n, 0).toString();
                    return !((STEMWizardDlg)STEMSettingsPage.this.mWizardDialog).getGSARDefineRolePage().isDataSourceEvent(string);
                }
                return false;
            }
        };
        this.mBinContFieldTable = new PlainTable();
        this.mBinContFieldTable.setModel(this.mBinContFieldTableModel);
        this.mBinContFieldTable.setRowHeight(22);
        this.mBinContFieldTable.setColumnSelectionAllowed(false);
        this.mBinContFieldTable.setRowSelectionAllowed(true);
        this.mBinContFieldTable.setSelectionMode(0);
        this.mBinContFieldTable.getTableHeader().setReorderingAllowed(false);
        this.mBinContFieldTable.getTableHeader().setResizingAllowed(true);
        this.mBinContFieldTable.setGridColor(Color.darkGray);
        this.mBinContFieldTable.getTableHeader().setReorderingAllowed(false);
        this.mBinContFieldTable.setSelectionMode(0);
        this.mBinContFieldTableLabel.setLabelFor(this.mBinContFieldTable);
        this.mBinContFieldTable.getColumnModel().getColumn(0).setCellRenderer(new UnEditableCellTextRenderer());
        this.mBinContFieldTable.getColumnModel().getColumn(1).setCellRenderer(new UnEditableCellTextRenderer());
        final ButtonEditCtrl buttonEditCtrl = new ButtonEditCtrl(3);
        TableColumn tableColumn = this.mBinContFieldTable.getColumnModel().getColumn(3);
        tableColumn.setCellEditor(buttonEditCtrl);
        buttonEditCtrl.addButtonListener(new IButtonEditListener(){

            @Override
            public void buttonPressed(long l, int n) {
                String string;
                String string2 = STEMSettingsPage.this.mBinContFieldTable.getValueAt((int)l, 1).toString();
                if (STEMSettingsPage.this.isContVar(string2) && (string = STEMSettingsPage.this.runBinningSubDlg((int)l)).length() > 0) {
                    buttonEditCtrl.getTextField().setText(string);
                }
                buttonEditCtrl.stopCellEditing();
            }
        });
        tableColumn.setCellRenderer(new UnEditableCellTextRenderer());
        this.mAggrComboEditor = new CellComboBoxEditor(this.mBinContFieldTable);
        URL uRL = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SOURCE_SELECT_MULTI_FIELD_IMAGE"));
        this.mFieldSelectButton = DialogUtil.createButton(this.mWizardDialog, "", null);
        if (uRL != null) {
            this.mFieldSelectButton.setIcon(new ImageIcon(uRL));
        }
        this.mFieldSelectButton.addActionListener(this);
        uRL = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SOURCE_SELECT_DELETE_IMAGE"));
        this.mDeleteButton = DialogUtil.createButton(this.mWizardDialog, "", null);
        if (uRL != null) {
            this.mDeleteButton.setIcon(new ImageIcon(uRL));
        }
        this.mDeleteButton.addActionListener(this);
    }

    private void setupBinAndAggregPanel() {
        this.mBinAndAggregPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, (JComponent)this.mBinAndAggrSetting, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, this.mAggregateMap, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, this.mDefaultAggrLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, this.mDefaultAggrCombo, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, this.mOrdinalAggrLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, this.mOrdinalAggrCombo, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, this.mBinAutoSpinLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, (JComponent)this.mBinAutoSpinner, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, this.mBinContFieldTableLabel, gridBagConstraints, 0, 5, 2, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        JScrollPane jScrollPane = new JScrollPane(this.mBinContFieldTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(400, 200));
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(new JComponent[]{this.mFieldSelectButton, this.mDeleteButton}, PanelFactory.PanelType.yaxis, ""), gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mBinAndAggregPanel, jPanel, gridBagConstraints, 0, 6, 2, 1, n, insets);
        this.setBinAndAggrTabTraversalOrder();
    }

    private void setupRuleBuildingPanel() {
        this.mRuleBuildingPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, 0, n2, 0);
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_BUIDING_ITEM_PER_RULE_TITLE"));
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mBuildItemPerRuleInfo, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBuildMaxConsqSpinLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mBuildMaxConsqSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBuildMaxAnteSpinLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mBuildMaxAnteSpinner, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_BUIDING_RULE_CRIT_TITLE"));
        insets.set(n2, n2, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mBuildRuleCritInfo, gridBagConstraints, 0, 0, 3, 1, n, insets);
        JLabel jLabel = new JLabel("%");
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mBuildCriConfSpinLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mBuildCriConfSpinner, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mBuildCriSuppSpinLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mBuildCriSuppSpinner, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, new JLabel("%"), gridBagConstraints, 2, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mBuildCriAnteqSpinLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets.set(n2, n2, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mBuildCriAnteSpinner, gridBagConstraints, 1, 3, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, new JLabel("%"), gridBagConstraints, 2, 3, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mBuildCriLiftSpinLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mBuildCriLiftSpinner, gridBagConstraints, 1, 4, 2, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_BUIDING_EXCLUDE_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mBuildExcludeTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mBuildExcludeTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(200, 200));
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel4 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_BUIDING_TREAT_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel4, this.mBuildSameTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mBuildSameTable, 20, 31);
        jScrollPane2.setMinimumSize(new Dimension(200, 200));
        jScrollPane2.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel4, jScrollPane2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, n2, n2, n2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mRuleBuildingPanel, (JComponent)this.mBuildRuleSetting, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mRuleBuildingPanel, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mRuleBuildingPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mRuleBuildingPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mRuleBuildingPanel, jPanel4, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mRuleBuildingPanel, PanelFactory.getEmptyPanel(""), gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.setRuleBuildingTabTraversalOrder();
    }

    private void setupOutputPanel() {
        this.mOutputPanel = PanelFactory.getEmptyPanel("");
        JPanel jPanel = this.setupOutputLeftPanel();
        JPanel jPanel2 = this.setupOutputRightPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(this.mOutputPanel, (JComponent)this.mOutputSetting, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mOutputPanel, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mOutputPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mOutputPanel, PanelFactory.getEmptyPanel(""), gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.setOutputTabTraversalOrder();
    }

    private JPanel setupOutputLeftPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        JPanel jPanel2 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_RULE_TABLE_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, n2, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mCreateTables, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2 * 4, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel2, this.mRuleConfCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mRuleSupportCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mRuleLiftCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mRuleAnteSupportCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mRuleDeployCheck, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mRulesToDisplayLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel("");
        insets.set(n2, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mRuleNumSpinLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mRuleNumSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, n2 * 9, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 8, 1, 1, n, insets);
        JPanel jPanel4 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_WORDLE_TITLE"));
        insets.set(n2, n2, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel4, this.mWordleCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel5 = PanelFactory.getEmptyPanel("");
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel5, this.mWordleSortLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel5, this.mWordleSortCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2 * 6, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel4, jPanel5, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel6 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel6, this.mWordleNumSpinLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel6, (JComponent)this.mWordleNumSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, n2 * 6, n2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel4, jPanel6, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(n2, 0, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, 0, n2, n2 * 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupOutputRightPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        this.mMapPanel = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_CREATE_MAP_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(0, n2, n2, n2 * 2);
        DialogUtil.addUsingGBL(this.mMapPanel, (JComponent)this.mCreateMaps, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2 * 5, n2, n2 * 2);
        DialogUtil.addUsingGBL(this.mMapPanel, this.mMapConfCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mMapPanel, this.mMapSupportCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mMapPanel, this.mMapLiftCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mMapPanel, this.mMapAnteSupportCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mMapPanel, this.mMapDeployCheck, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        insets.set(n2, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mMapNumSpinLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMapNumSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2 * 2);
        DialogUtil.addUsingGBL(this.mMapPanel, jPanel2, gridBagConstraints, 0, 6, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_OUTPUT_MODEL_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel3, this.mModelFieldTranCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mModelRecSummCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mModelRuleStatsCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mModelFreqItemCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mModelFreqFieldCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mModelExcludeInputs, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets.set(n2, 0, n2, n2 * 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMapPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, 0, n2, n2 * 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private String runBinningSubDlg(int n) {
        String string = "";
        String string2 = this.mBinContFieldTableModel.getValueAt(n, 1).toString();
        BinningSubDlg binningSubDlg = new BinningSubDlg(this.mWizardDialog, string2);
        binningSubDlg.setVisible(true);
        if (binningSubDlg.continuePressed()) {
            string = binningSubDlg.getBinValues();
        }
        return string;
    }

    private void setupSavePanel() {
        this.mSavePanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = 3;
        Insets insets = new Insets(n2, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(this.mSavePanel, (JComponent)this.mSaveSetting, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2 * 2, n2 * 4, n2, n2);
        DialogUtil.addUsingGBL(this.mSavePanel, this.mSaveMapCheck, gridBagConstraints, 0, 3, 2, 1, n, insets);
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMapFileLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mMapFileField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMapFileButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCopyMapCheck, gridBagConstraints, 0, 1, 3, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, n2 * 10, 0, n2);
        DialogUtil.addUsingGBL(this.mSavePanel, jPanel, gridBagConstraints, 0, 4, 2, 1, n, insets);
        JPanel jPanel2 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_SETTINGS_SAVE_SCORING_PANEL_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, 0, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mScoreSourceListLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mScoreSourceList, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(200, 130));
        jScrollPane.setPreferredSize(new Dimension(200, 130));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mScoringInfo, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel3 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SAVE_TARGET_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, this.mTargetInfo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mTargetTableLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetValueTable, 20, 31);
        jScrollPane2.setMinimumSize(new Dimension(200, 100));
        jScrollPane2.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel3, jScrollPane2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2 * 3, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel4 = PanelFactory.getEmptyPanel(this.mWizardDialog.getResString("IDS_STEM_STEP_SEVEN_SAVE_BEST_RULE_TITLE"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel4, this.mBestRuleInfo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel5 = PanelFactory.getEmptyPanel("");
        insets.set(n2, 0, n2, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel5, this.mBestRuleSpinLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel5, (JComponent)this.mNumBestRuleSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel4, jPanel5, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel6 = PanelFactory.getEmptyPanel("");
        insets.set(n2, 0, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel6, this.mRuleNamePrefLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel6, (JComponent)((Object)this.mRuleNamePrefField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel4, jPanel6, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2 * 3, n2, n2, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jPanel4, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2 * 4, n2 * 4, n2 * 6, n2);
        DialogUtil.addUsingGBL(this.mSavePanel, jPanel2, gridBagConstraints, 0, 6, 2, 1, n, insets);
        this.setSaveTabTraversalOrder();
    }

    private boolean isContVar(String string) {
        boolean bl = false;
        for (int i = 0; i < this.mContAndOrdinalVars.size(); ++i) {
            ISpssVariable iSpssVariable = this.mContAndOrdinalVars.get(i);
            if (!string.equals(iSpssVariable.getName()) || iSpssVariable.getMeasurementLevel() != MeasurementLevel.scale) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void enableWordlePanelControl() {
        if (this.mWordleCheck.isSelected()) {
            this.mWordleSortLabel.setEnabled(true);
            this.mWordleSortCombo.setEnabled(true);
            this.mWordleNumSpinLabel.setEnabled(true);
            this.mWordleNumSpinner.setEnabled(true);
        } else {
            this.mWordleSortLabel.setEnabled(false);
            this.mWordleSortCombo.setEnabled(false);
            this.mWordleNumSpinLabel.setEnabled(false);
            this.mWordleNumSpinner.setEnabled(false);
        }
        boolean bl = this.validate();
        this.mWizardDialog.enableNext(bl);
        this.mWizardDialog.enableFinish(bl);
    }

    private void enableTargetAndBestRule() {
        ListModel listModel = this.mScoreSourceList.getModel();
        boolean bl = false;
        for (int i = 0; i < listModel.getSize(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.mScoreSourceList.getModel().getElementAt(i);
            if (!jCheckBox.isSelected()) continue;
            bl = true;
            break;
        }
        this.mTargetInfo.setEnabled(bl);
        this.mTargetTableLabel.setEnabled(bl);
        this.mTargetValueTable.setEnabled(bl);
        this.mBestRuleInfo.setEnabled(bl);
        this.mBestRuleSpinLabel.setEnabled(bl);
        this.mNumBestRuleSpinner.getEditor().setEnabled(bl);
        this.mRuleNamePrefLabel.setEnabled(bl);
        this.mRuleNamePrefField.setEnabled(bl);
        this.mWizardDialog.enableNext(this.enableNextButton());
    }

    String generateGSARSettingsSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(this.genetateRuleBuildingSyntax());
        stringBuffer.append(this.generateOutputSyntax());
        stringBuffer.append(this.generateSaveSyntax());
        return stringBuffer.toString();
    }

    String getAutoBinSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n /AUTOBINNING BINS=" + ((JTextField)this.mBinAutoSpinner.getEditor()).getText());
        stringBuffer.append("\n /AGGREGATION");
        stringBuffer.append(" AGGMAP=");
        if (this.mAggregateMap.isSelected()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        stringBuffer.append(" CONTINUOUS=");
        stringBuffer.append(STEMWizardDlg.getContAggregationSyntax(this.mDefaultAggrCombo.getSelectedIndex()));
        stringBuffer.append(" ORDINAL=");
        stringBuffer.append(STEMWizardDlg.getOrdinalSyntax(this.mOrdinalAggrCombo.getSelectedIndex()));
        return stringBuffer.toString();
    }

    String getBinExceptionSyntax(String string) {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < this.mBinContFieldTable.getRowCount(); ++i) {
            String string4 = this.mBinContFieldTable.getValueAt(i, 0).toString();
            if (!string4.equals(string)) continue;
            String string5 = this.mBinContFieldTable.getValueAt(i, 1).toString();
            String string6 = this.mBinContFieldTable.getValueAt(i, 2).toString();
            String string7 = this.mBinContFieldTable.getValueAt(i, 3).toString();
            if (string5.length() <= 0) continue;
            String string8 = ((STEMWizardDlg)this.mWizardDialog).getAggregationSyntax(string6);
            if (string8.length() > 0) {
                string2 = string2 + " " + string5 + "(" + string8 + ");";
            }
            if (string7.length() <= 0 || string7.trim().length() <= 0) continue;
            String string9 = this.mWizardDialog.getResString("IDS_STEM_BINNING_SUB_AUTO_BIN_VALUE");
            if (string7.trim().equalsIgnoreCase(string9)) continue;
            string7 = string7.replace(';', ',');
            string3 = string3 + " " + string5 + "(" + string7 + ");";
        }
        if (string3.length() > 0) {
            if (string3.endsWith(";")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            stringBuffer.append(" BINEXCEPTIONS =" + string3);
        }
        if (string2.length() > 0) {
            if (string2.endsWith(";")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringBuffer.append(" AGGEXCEPTIONS =" + string2);
        }
        return stringBuffer.toString();
    }

    private String genetateRuleBuildingSyntax() {
        String string;
        String string2;
        int n;
        StringBuffer stringBuffer;
        Object object;
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        stringBuffer2.append("\n /RULEGENERATION");
        stringBuffer2.append(" MAXCONDITION=" + ((JTextField)this.mBuildMaxAnteSpinner.getEditor()).getText());
        stringBuffer2.append(" MAXPREDICTION=" + ((JTextField)this.mBuildMaxConsqSpinner.getEditor()).getText());
        stringBuffer2.append(" MINSUPPORT=" + this.getDoubleValue(((JTextField)this.mBuildCriSuppSpinner.getEditor()).getText()));
        stringBuffer2.append(" MINCONDITIONSUPPORT=" + this.getDoubleValue(((JTextField)this.mBuildCriAnteSpinner.getEditor()).getText()));
        stringBuffer2.append(" MINCONFIDENCE=" + this.getDoubleValue(((JTextField)this.mBuildCriConfSpinner.getEditor()).getText()));
        stringBuffer2.append(" MINLIFT=" + ((JTextField)this.mBuildCriLiftSpinner.getEditor()).getText());
        int n2 = this.mBuildExcludeTable.getRowCount();
        if (n2 > 0 && (object = this.mBuildExcludeTable.getValueAt(0, 0)) != null && object.toString().length() > 0) {
            stringBuffer = new StringBuffer("");
            for (n = 0; n < n2; ++n) {
                string2 = this.getVarAndSourceString(this.mBuildExcludeTable.getValueAt(n, 0));
                string = this.getVarAndSourceString(this.mBuildExcludeTable.getValueAt(n, 1));
                if (string2.length() <= 0 || string.length() <= 0) continue;
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(string2 + " " + string);
                    continue;
                }
                stringBuffer.append("; " + string2 + " " + string);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer2.append(" EXCLUDE=");
                stringBuffer2.append(stringBuffer);
            }
        }
        if ((n2 = this.mBuildSameTable.getRowCount()) > 0 && (object = this.mBuildSameTable.getValueAt(0, 0)) != null && object.toString().length() > 0) {
            stringBuffer = new StringBuffer("");
            for (n = 0; n < n2; ++n) {
                string2 = this.getVarAndSourceString(this.mBuildSameTable.getValueAt(n, 0));
                string = this.getVarAndSourceString(this.mBuildSameTable.getValueAt(n, 1));
                if (string2.length() <= 0 || string.length() <= 0) continue;
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(string2 + " " + string);
                    continue;
                }
                stringBuffer.append("; " + string2 + " " + string);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer2.append(" ENCODEASSAME=");
                stringBuffer2.append(stringBuffer);
            }
        }
        return stringBuffer2.toString();
    }

    String getVarAndSourceString(Object object) {
        String string = "";
        if (object == null || object.toString().length() == 0) {
            return string;
        }
        Vector<String> vector = new Vector<String>();
        ISpssVariable iSpssVariable = ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().getVariable(object.toString(), vector);
        if (iSpssVariable != null) {
            string = string + iSpssVariable.getName() + "(" + vector.get(0) + ") ";
        }
        return string;
    }

    private double getDoubleValue(String string) {
        double d = Double.parseDouble(string);
        return d / 100.0;
    }

    private String generateOutputSyntax() {
        boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n /MODELTABLES ");
        stringBuffer.append(" FIELDTRANSFORMATION=");
        if (this.mModelFieldTranCheck.isSelected()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        stringBuffer.append(" RECORDSUMMARY=");
        if (this.mModelRecSummCheck.isSelected()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        stringBuffer.append(" EVALUATION=");
        if (this.mModelRuleStatsCheck.isSelected()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        stringBuffer.append(" ITEMFREQ=");
        if (this.mModelFreqItemCheck.isSelected()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        stringBuffer.append(" FIELDFREQ=");
        if (this.mModelFreqFieldCheck.isSelected()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        stringBuffer.append(" EXCLUDEDINPUTS=");
        if (this.mModelExcludeInputs.isSelected()) {
            stringBuffer.append("YES");
        } else {
            stringBuffer.append("NO");
        }
        boolean bl2 = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().hasMap();
        String string = " NUMRULES=" + ((JTextField)this.mMapNumSpinner.getEditor()).getText();
        boolean bl3 = false;
        if (bl2 && this.mMapConfCheck.isSelected()) {
            stringBuffer.append("\n /MAPOUTPUT DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("CONFIDENCE ");
            stringBuffer.append(string);
            bl3 = true;
        }
        if (bl2 && this.mMapSupportCheck.isSelected()) {
            stringBuffer.append("\n /MAPOUTPUT DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("RULESUPPORT ");
            stringBuffer.append(string);
            bl3 = true;
        }
        if (bl2 && this.mMapLiftCheck.isSelected()) {
            stringBuffer.append("\n /MAPOUTPUT DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("LIFT ");
            stringBuffer.append(string);
            bl3 = true;
        }
        if (bl2 && this.mMapAnteSupportCheck.isSelected()) {
            stringBuffer.append("\n /MAPOUTPUT DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("CONDSUPPORT ");
            stringBuffer.append(string);
            bl3 = true;
        }
        if (bl2 && this.mMapDeployCheck.isSelected()) {
            stringBuffer.append("\n /MAPOUTPUT DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("DEPLOYABILITY ");
            stringBuffer.append(string);
            bl3 = true;
        }
        if (bl2 && !bl3) {
            stringBuffer.append("\n /MAPOUTPUT DISPLAY=NO");
        }
        stringBuffer.append("\n /WORDCLOUD ");
        if (this.mWordleCheck.isSelected()) {
            bl = true;
            stringBuffer.append("DISPLAY=YES");
        } else {
            stringBuffer.append("DISPLAY=NO");
            bl = false;
        }
        if (bl) {
            stringBuffer.append(" CRITERION=");
            int n = this.mWordleSortCombo.getSelectedIndex();
            switch (n) {
                case 0: {
                    stringBuffer.append("CONFIDENCE ");
                    break;
                }
                case 1: {
                    stringBuffer.append("RULESUPPORT ");
                    break;
                }
                case 2: {
                    stringBuffer.append("LIFT ");
                    break;
                }
                case 3: {
                    stringBuffer.append("CONDSUPPORT ");
                    break;
                }
                case 4: {
                    stringBuffer.append("DEPLOYABILITY ");
                }
            }
            stringBuffer.append(" NUMRULES=" + ((JTextField)this.mWordleNumSpinner.getEditor()).getText());
        }
        String string2 = " NUMRULES=";
        string2 = string2 + ((JTextField)this.mRuleNumSpinner.getEditor()).getText();
        if (this.mRuleConfCheck.isSelected()) {
            stringBuffer.append("\n /RULESTABLE ");
            stringBuffer.append("DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("CONFIDENCE ");
            stringBuffer.append(string2);
        }
        if (this.mRuleSupportCheck.isSelected()) {
            stringBuffer.append("\n /RULESTABLE ");
            stringBuffer.append("DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("RULESUPPORT ");
            stringBuffer.append(string2);
        }
        if (this.mRuleLiftCheck.isSelected()) {
            stringBuffer.append("\n /RULESTABLE ");
            stringBuffer.append("DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("LIFT ");
            stringBuffer.append(string2);
        }
        if (this.mRuleAnteSupportCheck.isSelected()) {
            stringBuffer.append("\n /RULESTABLE ");
            stringBuffer.append("DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("CONDSUPPORT ");
            stringBuffer.append(string2);
        }
        if (this.mRuleDeployCheck.isSelected()) {
            stringBuffer.append("\n /RULESTABLE ");
            stringBuffer.append("DISPLAY=YES");
            stringBuffer.append(" CRITERION=");
            stringBuffer.append("DEPLOYABILITY ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    String getDeclareSyntax() {
        String string = "";
        ListModel listModel = this.mScoreSourceList.getModel();
        Vector<ContextDataItem> vector = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getDataSourceList(false);
        for (int i = 0; i < listModel.getSize(); ++i) {
            ContextDataItem contextDataItem;
            JCheckBox jCheckBox = (JCheckBox)this.mScoreSourceList.getModel().getElementAt(i);
            if (!jCheckBox.isSelected() || (contextDataItem = vector.get(i)).getDataType() != ContextDataItem.DataType.FILE && contextDataItem.getDataType() != ContextDataItem.DataType.MAP) continue;
            string = string + "\nDATASET DECLARE " + contextDataItem.getSourceId() + ". ";
        }
        return string;
    }

    private String generateSaveSyntax() {
        String string;
        Object object;
        int n;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        ListModel listModel = this.mScoreSourceList.getModel();
        String string2 = "";
        String string3 = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getCurrentActiveDataFile();
        Vector<ContextDataItem> vector = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getDataSourceList(false);
        for (n = 0; n < listModel.getSize(); ++n) {
            object = (JCheckBox)this.mScoreSourceList.getModel().getElementAt(n);
            if (!((AbstractButton)object).isSelected()) continue;
            ContextDataItem contextDataItem = vector.get(n);
            string = contextDataItem.getDataType() == ContextDataItem.DataType.DATASET && contextDataItem.getDataSourceFullName().equals(string3) ? "*" : contextDataItem.getSourceId();
            string2 = string2 + contextDataItem.getSourceId() + "(" + string + ") ";
        }
        if (string2.length() <= 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("\n /SAVE");
        stringBuffer.append(" SOURCESTOSCORE=");
        stringBuffer.append(string2);
        stringBuffer.append(" BESTRULE=");
        stringBuffer.append(((JTextField)this.mNumBestRuleSpinner.getEditor()).getText());
        stringBuffer.append(" BESTNAME=\"");
        stringBuffer.append(this.mRuleNamePrefField.getText());
        stringBuffer.append("\"");
        n = this.mTargetValueTable.getRowCount();
        if (n > 0 && (object = this.mTargetValueTable.getValueAt(0, 0)) != null && object.toString().length() > 0) {
            stringBuffer.append(" TARGETS=");
            for (int i = 0; i < n; ++i) {
                string = this.getVarAndSourceString(this.mTargetValueTable.getValueAt(i, 0));
                if (string.length() <= 0) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    private String getScoreSourceSyntax(String string, boolean bl) {
        String string2 = string;
        int n = string.lastIndexOf(".");
        if (n > 0 && !bl) {
            string2 = string2.substring(0, n);
        }
        if (string2.indexOf(32) >= 0) {
            string2 = string2.replace(' ', '_');
        }
        return string2;
    }

    String getMapSpecSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("\n /SPECFILE FILE=\"");
        stringBuffer.append(this.getMapSpecFilePath()).append("\"");
        if (this.mSaveMapCheck.isSelected()) {
            stringBuffer.append(" DISPLAY=YES");
            stringBuffer.append(" SAVEDATA=");
            if (this.mCopyMapCheck.isSelected()) {
                stringBuffer.append("YES");
            } else {
                stringBuffer.append("NO");
            }
        } else {
            stringBuffer.append(" DISPLAY=NO");
            stringBuffer.append(" SAVEDATA=NO");
        }
        return stringBuffer.toString();
    }

    String getMapSpecFilePath() {
        if (this.mSaveMapCheck.isSelected()) {
            return this.mMapFileField.getText();
        }
        return sDefaultSpecName;
    }

    class AnalysisVariableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private ImageIcon[] mIcons;
        private String[] mValues;
        private ImageIcon[] sMeasurementIcons = new ImageIcon[]{null, new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_NOMINAL_VAR_IMAGE"))), new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_ORDINAL_VAR_IMAGE"))), new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SCALE_VAR_IMAGE")))};

        AnalysisVariableCellRenderer(ImageIcon[] imageIconArray, String[] stringArray) {
            this.mIcons = imageIconArray;
            this.mValues = stringArray;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setIcon(this.mIcons[0]);
            Object object2 = jTable.getCellEditor().getCellEditorValue();
            if (object2 != null) {
                this.setText(object2.toString());
            }
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }
}

