/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.xml.DOMFactory;
import com.spss.java_client.core.xml.SchemaType;
import com.spss.java_client.ui.dialogs.STEM.GeoContextSource;
import com.spss.java_client.ui.dialogs.STEM.STEMPlanAlertDlg;
import com.spss.uitools.dialogs.BaseDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class STEMPlanHandler {
    private Vector<GeoContextSource> mGeoContextSources;
    private Vector<GeoContextSource.NonSpatialDataSource> mDataSources;
    private String mAllMapProjection;
    private String mAllMapDisplay;
    private int mAllMapWKID;
    private BaseDialog mWizardDlg;
    private Vector<String> mRemovedAssocID;
    private String[] mRoleString;

    public STEMPlanHandler(BaseDialog baseDialog) {
        this.mWizardDlg = baseDialog;
        this.mGeoContextSources = new Vector();
        this.mDataSources = new Vector();
        this.mRemovedAssocID = new Vector();
    }

    public boolean parsePlanFile(String string) {
        NodeList nodeList;
        int n;
        Document document;
        boolean bl = true;
        DOMFactory dOMFactory = new DOMFactory();
        try {
            document = dOMFactory.createDOM(new InputSource(new FileInputStream(string)), SchemaType.SCHEMA_NONE);
            if (document == null) {
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute("timeStamp");
        if (string2 != null && string2.length() > 0 && (n = string2.lastIndexOf(10)) == string2.length() - 1) {
            string2 = string2.substring(0, n);
        }
        if ((nodeList = element.getElementsByTagName("GeoContextSources")).getLength() > 0) {
            bl = this.handlGeoContextSources(nodeList);
        }
        if (!bl) {
            return bl;
        }
        return bl;
    }

    private boolean handlGeoContextSources(NodeList nodeList) {
        boolean bl = true;
        Element element = (Element)nodeList.item(0);
        this.mAllMapProjection = element.getAttribute("projection");
        this.mAllMapDisplay = element.getAttribute("display");
        String string = element.getAttribute("WKID");
        if (string.length() > 0) {
            this.mAllMapWKID = this.getIntValue(string);
        }
        NodeList nodeList2 = element.getElementsByTagName("GeoContextSource");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element2 = (Element)nodeList2.item(i);
            String string2 = element2.getAttribute("id");
            GeoContextSource geoContextSource = new GeoContextSource(string2);
            string2 = element2.getAttribute("type");
            geoContextSource.setType(string2);
            string2 = element2.getAttribute("finalSource");
            Vector<String> vector = new Vector<String>();
            Vector<Boolean> vector2 = new Vector<Boolean>();
            String string3 = this.getSourceFullPath(string2, vector, vector2);
            Vector<STEMPlanAlertDlg.AlertValue> vector3 = new Vector<STEMPlanAlertDlg.AlertValue>();
            Vector<String> vector4 = new Vector<String>();
            boolean bl2 = this.isFileExist(string3, vector.get(0), false, vector3, vector4, vector2.get(0));
            if (!bl2) {
                this.mRemovedAssocID.add(geoContextSource.getGeoSourceID());
                STEMPlanAlertDlg.AlertValue alertValue = vector3.get(0);
                if (alertValue == STEMPlanAlertDlg.AlertValue.STEM_PLAN_CANCEL) {
                    return false;
                }
                if (alertValue == STEMPlanAlertDlg.AlertValue.STEM_PLAN_SKIP) continue;
                string3 = vector4.get(0);
                if (string3.length() == 0) {
                    return false;
                }
            }
            geoContextSource.setFinalSourceName(string3);
            string2 = element2.getAttribute("layer");
            geoContextSource.setMapLayerName(string2);
            string2 = element2.getAttribute("closeRadius");
            geoContextSource.setCloseRadius(this.getDoubleValue(string2));
            string2 = element2.getAttribute("maxRelations");
            geoContextSource.setMaxRelations(this.getIntValue(string2));
            string2 = element2.getAttribute("distanceMeasure");
            geoContextSource.setDistanceMeasure(string2);
            string2 = element2.getAttribute("Predicate");
            geoContextSource.setPredicateType(string2);
            string2 = element2.getAttribute("CoordSystem");
            geoContextSource.setCoordType(string2);
            string2 = element2.getAttribute("wkid");
            if (string2.length() > 0) {
                geoContextSource.setWKID(this.getIntValue(string2));
            }
            if ((string2 = element2.getAttribute("projection")).length() > 0) {
                geoContextSource.setCSName(string2);
            }
            this.mGeoContextSources.add(geoContextSource);
        }
        NodeList nodeList3 = element.getElementsByTagName("NonSpatialSource");
        if (nodeList3.getLength() > 0) {
            bl = this.HandleNonSpatialSourceList(nodeList3);
        }
        return bl;
    }

    public Vector<GeoContextSource> getGeoContextSources() {
        return this.mGeoContextSources;
    }

    public Vector<GeoContextSource.NonSpatialDataSource> getDataSources() {
        return this.mDataSources;
    }

    private double getDoubleValue(String string) {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.MAX_VALUE;
        }
        return d;
    }

    private int getIntValue(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    private boolean HandleNonSpatialSourceList(NodeList nodeList) {
        boolean bl = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Object object3;
            boolean bl2;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("source");
            Vector<String> vector = new Vector<String>();
            Vector<Boolean> vector2 = new Vector<Boolean>();
            String string2 = this.getSourceFullPath(string, vector, vector2);
            String string3 = element.getAttribute("id");
            String string4 = element.getAttribute("mapId");
            String string5 = element.getAttribute("role");
            if (string5.equals("CONTEXT")) {
                bl2 = true;
            } else {
                if (!string5.equals("EVENTDENSITY")) continue;
                bl2 = false;
            }
            String string6 = element.getAttribute("type");
            if (string6.equals("Map") && string.equals(string4)) {
                if (this.mRemovedAssocID.contains(string4)) continue;
                string2 = string2 + ".dbf";
            } else {
                object3 = new Vector<STEMPlanAlertDlg.AlertValue>();
                object2 = new Vector<String>();
                boolean bl3 = this.isFileExist(string2, vector.get(0), true, (Vector<STEMPlanAlertDlg.AlertValue>)object3, (Vector<String>)object2, vector2.get(0));
                if (!bl3) {
                    object = (STEMPlanAlertDlg.AlertValue)((Object)((Vector)object3).get(0));
                    if (object == STEMPlanAlertDlg.AlertValue.STEM_PLAN_CANCEL) {
                        return false;
                    }
                    if (object == STEMPlanAlertDlg.AlertValue.STEM_PLAN_SKIP) continue;
                    string2 = (String)((Vector)object2).get(0);
                    if (string2.length() == 0) {
                        return false;
                    }
                }
            }
            object3 = new GeoContextSource.NonSpatialDataSource(string2, string3, bl2);
            ((GeoContextSource.NonSpatialDataSource)object3).setAssociatedMapId(string4);
            ((GeoContextSource.NonSpatialDataSource)object3).setSourceType(string6);
            object2 = element.getElementsByTagName("MapKeys");
            if (object2.getLength() == 1) {
                NodeList nodeList2 = ((Element)object2.item(0)).getElementsByTagName("Field");
                bl = this.HandleFieldList(nodeList2, (GeoContextSource.NonSpatialDataSource)object3, ElementType.MapKeys);
            }
            if ((object2 = element.getElementsByTagName("DataKeys")).getLength() == 1) {
                NodeList nodeList3 = ((Element)object2.item(0)).getElementsByTagName("Field");
                bl = this.HandleFieldList(nodeList3, (GeoContextSource.NonSpatialDataSource)object3, ElementType.DataKeys);
            }
            if ((object2 = element.getElementsByTagName("DataToMap")).getLength() > 0) {
                bl = this.HandleDataToMapEle((NodeList)object2, (GeoContextSource.NonSpatialDataSource)object3);
            }
            if ((object2 = element.getElementsByTagName("CoordinatesSource")).getLength() == 1) {
                Element element2 = (Element)object2.item(0);
                object = element2.getElementsByTagName("XField");
                if (object.getLength() != 1) {
                    return false;
                }
                Element element3 = (Element)object.item(0);
                String string7 = element3.getAttribute("name");
                ((GeoContextSource.NonSpatialDataSource)object3).setXCoordinateField(string7);
                object = element2.getElementsByTagName("YField");
                if (object.getLength() != 1) {
                    return false;
                }
                element3 = (Element)object.item(0);
                string7 = element3.getAttribute("name");
                ((GeoContextSource.NonSpatialDataSource)object3).setYCoordinateField(string7);
                object = element2.getElementsByTagName("ZField");
                if (object.getLength() == 1) {
                    element3 = (Element)object.item(0);
                    string7 = element3.getAttribute("name");
                    ((GeoContextSource.NonSpatialDataSource)object3).setZCoordinateField(string7);
                }
                string7 = element2.getAttribute("CoordSystem");
                ((GeoContextSource.NonSpatialDataSource)object3).setCoordType(string7);
                string7 = element2.getAttribute("wkid");
                if (string7.length() > 0) {
                    ((GeoContextSource.NonSpatialDataSource)object3).setWKID(this.getIntValue(string7));
                }
                if ((string7 = element2.getAttribute("projection")).length() > 0) {
                    ((GeoContextSource.NonSpatialDataSource)object3).setCSName(string7);
                }
            }
            this.mDataSources.add((GeoContextSource.NonSpatialDataSource)object3);
        }
        return bl;
    }

    String getSourceFullPath(String string, Vector<String> vector, Vector<Boolean> vector2) {
        if (string.length() == 0 || string.indexOf("zip://") != 0) {
            vector.add(string);
            vector2.add(false);
            return string;
        }
        String string2 = PrefsMgr.getPrefsMgr().getTempPath();
        String string3 = string.substring(6, string.length());
        vector.add(string3);
        vector2.add(true);
        return string2 + string3;
    }

    boolean isFileExist(String string, String string2, boolean bl, Vector<STEMPlanAlertDlg.AlertValue> vector, Vector<String> vector2, boolean bl2) {
        boolean bl3 = true;
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            bl3 = false;
            String string3 = "";
            string3 = !bl ? String.format(ComponentState.getSPSSLocale(), this.mWizardDlg.getResString("IDS_STEM_MAP_SPEC_FILE_ERROR"), string2) : String.format(ComponentState.getSPSSLocale(), this.mWizardDlg.getResString("IDS_STEM_MAP_SPEC_DATASET_ERROR"), string2);
            STEMPlanAlertDlg sTEMPlanAlertDlg = new STEMPlanAlertDlg(this.mWizardDlg, bl, string3);
            sTEMPlanAlertDlg.setVisible(true);
            vector.add(sTEMPlanAlertDlg.getAlertOptionValue());
            if (sTEMPlanAlertDlg.getAlertOptionValue() == STEMPlanAlertDlg.AlertValue.STEM_PLAN_BROWSE) {
                vector2.add(sTEMPlanAlertDlg.getNewFilePath());
            }
        }
        if (bl2) {
            file.deleteOnExit();
        }
        return bl3;
    }

    private boolean HandleDataToMapEle(NodeList nodeList, GeoContextSource.NonSpatialDataSource nonSpatialDataSource) {
        boolean bl = true;
        Vector<GeoContextSource.MatchDataToMap> vector = new Vector<GeoContextSource.MatchDataToMap>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2;
            GeoContextSource.MatchDataToMap matchDataToMap = new GeoContextSource.MatchDataToMap();
            NodeList nodeList3 = ((Element)nodeList.item(0)).getElementsByTagName("DataValue");
            if (nodeList3.getLength() == 1 && (nodeList2 = ((Element)nodeList3.item(0)).getElementsByTagName("Array")).getLength() == 1) {
                this.HandleArrayEle(nodeList2, matchDataToMap, false);
            }
            if ((nodeList3 = ((Element)nodeList.item(0)).getElementsByTagName("MapValue")).getLength() == 1 && (nodeList2 = ((Element)nodeList3.item(0)).getElementsByTagName("Array")).getLength() == 1) {
                this.HandleArrayEle(nodeList2, matchDataToMap, true);
            }
            vector.add(matchDataToMap);
        }
        nonSpatialDataSource.setDataToMap(vector);
        return bl;
    }

    private boolean HandleArrayEle(NodeList nodeList, GeoContextSource.MatchDataToMap matchDataToMap, boolean bl) {
        boolean bl2 = true;
        Element element = (Element)nodeList.item(0);
        String string = element.getAttribute("type");
        boolean bl3 = string.equals("int") || string.equals("real");
        String string2 = element.getFirstChild().getNodeValue();
        if (string2 == null) {
            return false;
        }
        String string3 = "\"";
        if (bl3) {
            string3 = " ";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        int n = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.trim().length() == 0) continue;
            if (bl) {
                matchDataToMap.addOneMapFieldValue(string4);
                continue;
            }
            matchDataToMap.addOneDataFieldValue(string4);
        }
        return bl2;
    }

    private boolean HandleFieldList(NodeList nodeList, GeoContextSource.NonSpatialDataSource nonSpatialDataSource, ElementType elementType) {
        boolean bl = true;
        boolean bl2 = elementType == ElementType.MapKeys || elementType == ElementType.DataKeys;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("name");
            vector.add(string);
        }
        if (elementType == ElementType.MapKeys) {
            nonSpatialDataSource.setMapKeys(vector);
        } else if (elementType == ElementType.DataKeys) {
            nonSpatialDataSource.setDataKeys(vector);
        }
        return bl;
    }

    public String getAllMapProjection() {
        return this.mAllMapProjection;
    }

    public String getAllMapDisplay() {
        return this.mAllMapDisplay;
    }

    public int getAllMapWKID() {
        return this.mAllMapWKID;
    }

    public static enum ElementType {
        MapKeys,
        DataKeys,
        DataToMap;

    }
}

