/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.ASMapsError;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.STEM.ContextDataItem;
import com.spss.java_client.ui.dialogs.STEM.CoordinateSystemUtil;
import com.spss.java_client.ui.dialogs.STEM.GeoContextSource;
import com.spss.java_client.ui.dialogs.STEM.GeoRelationshipSubDlg;
import com.spss.java_client.ui.dialogs.STEM.MapImagePanel;
import com.spss.java_client.ui.dialogs.STEM.ProjectionSubDlg;
import com.spss.java_client.ui.dialogs.STEM.STEMPlanHandler;
import com.spss.java_client.ui.dialogs.STEM.STEMPreviewCanvas;
import com.spss.java_client.ui.dialogs.STEM.STEMUtil;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.STEM.SelectCoordinateSubDlg;
import com.spss.java_client.ui.dialogs.STEM.SelectMapSubDlg;
import com.spss.java_client.ui.dialogs.STEM.SelectProjectionSubDlg;
import com.spss.java_client.ui.dialogs.STEM.UnEditableCellTextRenderer;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.direct_marketing.AbstractDialogStateWizardPage;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.output.vis.charting.OutputVisComponent;
import com.spss.output.vis.charting.OutputVisComponentImpl;
import com.spss.output.vis.charting.nativeImpl.util.MapStatJSONUtil;
import com.spss.output.vis.charting.nativeImpl.util.OutputVisComponentUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IOptionConstants;
import com.spss.uitools.util.PASWFileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class STEMGeoRelationshipPage
extends AbstractDialogStateWizardPage
implements ActionListener {
    private static final int PREVIEW_HEIGHT = 300;
    public static final Dimension mImageSize = new Dimension(250, 300);
    private FocusableTextArea mInfoText1;
    private FocusableTextArea mInfoText2;
    private JButton mLoadMapSpecButton;
    private JButton mAddFileButton;
    private JButton mRelationButton;
    private JButton mUpButton;
    private JButton mDownButton;
    private JButton mDeleteButton;
    private JButton mPreviewAllButton;
    private JLabel mMapsTableLabel;
    private JTable mMapsFileTable;
    private MapTableModel mMapsFileTableModel;
    private String[] mRelationshipStrings;
    private String[] mIncrementStr;
    private JLabel mPreviewLabel;
    private MapImagePanel mImagePanel;
    private STEMPreviewCanvas mCanvas;
    Hashtable<String, BufferedImage> mMapAndImage = new Hashtable();
    Hashtable<String, String> mMapLayerTypes = new Hashtable();
    private DialogFocusTraversalPolicy mPolicy;
    private String mMapSpecPath;
    private boolean mIsMapSpecModified;
    private ContextDataItem.CoordinateSys mAllMapCoorSys = null;
    private int mAllMapWKID = -1;
    private String mAllMapCSName = null;
    private String mAllMapDisplayProj = null;
    private ContextDataItem.CoordinateSys mCurrentMapCoorSys = null;
    private int mCurrentMapWKID = -1;
    private String mCurrentMapCSName = null;
    private Vector<ISpssVariable> mVarInfoDbf;
    private JSONObject mJsonObj;
    private BufferedImage mMapImage = null;
    private String mMapGeoTypeString = "";
    private STEMUtil.GeoType mMapGeoType;
    private String[] mRoleString;
    private boolean mIsSTP;
    public String sDefaultContextKeyName;
    private boolean mIsPageModified = false;
    private boolean mKeepControlSettings = false;
    private boolean mFromDataSource;
    private boolean mShowProjectionDlg;

    public STEMGeoRelationshipPage(BaseWizardDialog baseWizardDialog) {
        super("STEMGeoRelationshipPage", baseWizardDialog.getResString("IDS_STEM_STEP_ONE_TITLE"), baseWizardDialog, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        if (object == this.mAddFileButton) {
            String string = this.mWizardDialog.getResString("IDS_STEM_SHP_FILE_INFO");
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString(), true, SpssAlertOptionPane.IconType.eQuestion);
            String[] stringArray = this.mWizardDialog.getResStringArray("IDS_STEM_MAPS_SHP_FILE_FILTER_ARRY");
            String[] stringArray2 = this.mWizardDialog.getResStringArray("IDS_STEM_MAPS_SHP_FILE_EXT_ARRY");
            String[] stringArray3 = STEMWizardDlg.showOpenFileDialog(this.mWizardDialog, this.mWizardDialog.getResString("IDS_STEM_MAPS_OPEN_SHP_FILE_TITLE"), stringArray, stringArray2, 0);
            if (stringArray3 != null && stringArray3.length == 2) {
                this.mIsMapSpecModified = true;
                Vector<String> vector = new Vector<String>();
                boolean bl = this.getMapInfoFromBackend(stringArray3[0], stringArray3[1], vector);
                if (bl) {
                    String string2 = stringArray3[1];
                    if (string2.endsWith(".shp") || string2.endsWith(".zip")) {
                        this.updateSourceTable(stringArray3[0], stringArray3[1], true, vector.get(0));
                    }
                    n = this.mMapsFileTable.getRowCount() - 1;
                }
                this.mIsPageModified = true;
            }
            this.enableButtons();
        } else if (object == this.mRelationButton) {
            int n2 = this.mMapsFileTable.getSelectedRow();
            if (n2 < 0) {
                return;
            }
            this.runGeoRelationshipSub(n2);
            n = n2;
        } else if (object == this.mDownButton || object == this.mUpButton) {
            int n3 = this.mMapsFileTable.getSelectedRow();
            if (n3 >= 0) {
                if (object == this.mUpButton) {
                    this.manipulateUp(n3);
                } else {
                    this.manipulateDown(n3);
                }
                this.mIsMapSpecModified = true;
                this.mIsPageModified = true;
            }
            this.enableButtons();
        } else if (object == this.mDeleteButton) {
            this.deleteOneRow();
            this.mIsMapSpecModified = true;
            this.mIsPageModified = true;
        } else if (object == this.mLoadMapSpecButton) {
            String string = STEMUtil.showOpenMapSpecDialog(this.mWizardDialog, this.mWizardDialog.getResString("IDS_STEM_MAP_SPEC_STEM_PLAN_FILE_TITLE"), this.mWizardDialog.getResString("IDS_STEM_MAP_SPEC_STEM_PLAN_FILE_FILTER"), this.mWizardDialog.getResString("IDS_STEM_MAP_SPEC_STEM_PLAN_FILE_FILTER_EXTN"), RemoteFileChooser.ChooserType.OpenFile);
            STEMPlanHandler sTEMPlanHandler = STEMUtil.selectAndParseMapSpec(string, this.mWizardDialog);
            if (sTEMPlanHandler != null) {
                this.mMapSpecPath = string;
                Vector<GeoContextSource> vector = sTEMPlanHandler.getGeoContextSources();
                this.mAllMapCSName = sTEMPlanHandler.getAllMapProjection();
                if (this.mAllMapCSName.length() == 0) {
                    this.mAllMapCSName = null;
                }
                this.mAllMapDisplayProj = sTEMPlanHandler.getAllMapDisplay();
                this.mAllMapWKID = sTEMPlanHandler.getAllMapWKID();
                int n4 = vector.size();
                Hashtable<String, Vector<ISpssVariable>> hashtable = new Hashtable<String, Vector<ISpssVariable>>();
                if (this.mIsSTP && n4 > 1) {
                    Vector<String> vector2 = new Vector<String>();
                    for (GeoContextSource geoContextSource : vector) {
                        vector2.add(geoContextSource.getGeoSourceID());
                    }
                    SelectMapSubDlg selectMapSubDlg = new SelectMapSubDlg(this.mWizardDialog, vector2);
                    selectMapSubDlg.setVisible(true);
                    if (!selectMapSubDlg.continuePressed()) return;
                    int n5 = selectMapSubDlg.getSelectedMapIndex();
                    this.addOneGeoSource(vector.get(n5));
                    hashtable.put(vector.get(n5).getGeoSourceID(), this.mVarInfoDbf);
                    this.mAddFileButton.setEnabled(false);
                } else {
                    for (int i = 0; i < n4; ++i) {
                        boolean bl = this.addOneGeoSource(vector.get(i));
                        if (!bl) {
                            this.reset();
                            ((STEMWizardDlg)this.mWizardDialog).getContextPage().reset();
                            return;
                        }
                        hashtable.put(vector.get(i).getGeoSourceID(), this.mVarInfoDbf);
                    }
                }
                Vector<GeoContextSource.NonSpatialDataSource> vector3 = sTEMPlanHandler.getDataSources();
                this.updateSourceTable(vector3, hashtable);
                this.mIsPageModified = true;
                n = this.mMapsFileTable.getRowCount() - 1;
                if (this.mIsSTP && n4 >= 1) {
                    this.mAddFileButton.setEnabled(false);
                    this.mLoadMapSpecButton.setEnabled(false);
                }
            }
        } else if (object == this.mPreviewAllButton) {
            this.showAllMaps();
        }
        if (n < 0) return;
        this.mMapsFileTable.setRowSelectionInterval(n, n);
        this.mMapsFileTable.setColumnSelectionInterval(1, 1);
        this.mMapsFileTable.requestFocusInWindow();
    }

    boolean fromMapSpec() {
        return this.mMapSpecPath.length() > 0;
    }

    boolean hasMap() {
        return this.mMapsFileTableModel.getRowCount() > 0;
    }

    void setKeepControlSettings(boolean bl) {
        this.mKeepControlSettings = bl;
    }

    void setFromDataSource(boolean bl) {
        this.mFromDataSource = bl;
    }

    Vector<String> getAllMapIds() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.mMapsFileTableModel.getRowCount(); ++i) {
            vector.add(this.mMapsFileTableModel.getValue(i).getMapId());
        }
        return vector;
    }

    boolean isMapKeyNumeric(String string, String string2) {
        boolean bl = true;
        for (int i = 0; i < this.mMapsFileTableModel.getRowCount(); ++i) {
            MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(i);
            if (!mapSpecItem.getMapId().equals(string)) continue;
            bl = mapSpecItem.isMapKeyNumeric(string2);
            break;
        }
        return bl;
    }

    boolean isPointMap(String string) {
        for (int i = 0; i < this.mMapsFileTableModel.getRowCount(); ++i) {
            MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(i);
            if (!mapSpecItem.getMapId().equals(string)) continue;
            return mapSpecItem.getMapGeoTypeString().equals(MapStatJSONUtil.GeoJSONShapeType.point.name());
        }
        return false;
    }

    STEMUtil.GeoType getMapType(String string) {
        STEMUtil.GeoType geoType = STEMUtil.GeoType.UNKNOWN;
        for (int i = 0; i < this.mMapsFileTableModel.getRowCount(); ++i) {
            MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(i);
            if (!mapSpecItem.getMapId().equals(string)) continue;
            geoType = mapSpecItem.getMapType();
        }
        return geoType;
    }

    String getShpFilePath(String string) {
        for (int i = 0; i < this.mMapsFileTableModel.getRowCount(); ++i) {
            MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(i);
            if (!mapSpecItem.getMapId().equals(string)) continue;
            return mapSpecItem.getMapFullName();
        }
        return "";
    }

    Hashtable<String, Vector<ISpssVariable>> getMapKeys() {
        Hashtable<String, Vector<ISpssVariable>> hashtable = new Hashtable<String, Vector<ISpssVariable>>();
        for (int i = 0; i < this.mMapsFileTableModel.getRowCount(); ++i) {
            MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(i);
            hashtable.put(mapSpecItem.getMapId(), mapSpecItem.getMapKeys());
        }
        return hashtable;
    }

    void setCoordSysAndDisplay(ContextDataItem.CoordinateSys coordinateSys, int n, String string, String string2) {
        this.mAllMapCoorSys = coordinateSys;
        this.mAllMapWKID = n;
        this.mAllMapCSName = string;
        this.mAllMapDisplayProj = string2;
    }

    public Vector<String> getDBFList() {
        Vector<String> vector = new Vector<String>();
        int n = this.mMapsFileTableModel.getRowCount();
        String string = "dbf";
        for (int i = 0; i < n; ++i) {
            String string2 = this.mMapsFileTableModel.getValueAt(i, 0).toString();
            if (!string2.endsWith(".shp")) continue;
            File file = new File(string2);
            String string3 = file.getName();
            vector.add(string3.substring(0, string3.length() - 3) + string);
        }
        return vector;
    }

    void updateSourceTable(String string, String string2, boolean bl, String string3) {
        if (string.endsWith(".shp") || string.endsWith(".zip")) {
            File file = new File(string);
            String string4 = this.handleDBFfileName(string2);
            String string5 = string4.substring(0, string4.length() - 3) + "dbf";
            ((STEMWizardDlg)this.mWizardDialog).getContextPage().updateTableFromMap(file.getParent() + File.separator + string5, string5, bl, this.mVarInfoDbf, string3);
            this.mWizardDialog.enableNext(true);
        }
    }

    String handleDBFfileName(String string) {
        int n = string.lastIndexOf(92);
        if (n > 0) {
            return string.substring(n + 1);
        }
        n = string.lastIndexOf(47);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    void updateSourceTable(Vector<GeoContextSource.NonSpatialDataSource> vector, Hashtable<String, Vector<ISpssVariable>> hashtable) {
        boolean bl = vector.size() == 1 && hashtable.size() == 0;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            String string;
            GeoContextSource.NonSpatialDataSource nonSpatialDataSource = vector.get(i);
            String string2 = string = nonSpatialDataSource.getSourceName();
            if (!string.equals("*")) {
                object3 = new File(string);
                string2 = ((File)object3).getName();
            }
            object3 = this.getDataSourceType(nonSpatialDataSource.getSourceType());
            String string3 = this.mRoleString[1];
            if (bl && !this.mIsSTP) {
                string3 = this.mRoleString[0];
            }
            if (i >= 2 && this.mIsSTP) {
                string3 = this.mRoleString[2];
            }
            String string4 = nonSpatialDataSource.getXCoordinateField();
            String string5 = nonSpatialDataSource.getYCoordinateField();
            String string6 = nonSpatialDataSource.getZCoordinateField();
            String string7 = "";
            ContextDataItem contextDataItem = new ContextDataItem(nonSpatialDataSource.getSourceId(), string, string2, false, nonSpatialDataSource.isRoleContext(), nonSpatialDataSource.getAssociatedMapId(), (ContextDataItem.DataType)((Object)object3), string7);
            contextDataItem.setAssocSetStatus(true);
            String string8 = nonSpatialDataSource.getAssociatedMapId();
            boolean bl2 = false;
            if (nonSpatialDataSource.getSourceType().equals("Map")) {
                if (hashtable.get(string8) == null || hashtable.get(string8).size() == 0) continue;
                contextDataItem.setSpssVars(hashtable.get(string8));
                bl2 = true;
            }
            if (string4.length() > 0 && string5.length() > 0) {
                if (bl && this.mIsSTP || !bl) {
                    string7 = "Coordinates (" + string4 + "," + string5;
                    if (string6.length() > 0) {
                        string7 = string7 + "," + string6;
                        contextDataItem.setCoordinateZVar(string6);
                    }
                    string7 = string7 + ")";
                    contextDataItem.setAssocType(ContextDataItem.AssocType.COORDINATE);
                    contextDataItem.setDisplayMapString(string7);
                    contextDataItem.setAssocSetStatus(true);
                    contextDataItem.setCoordinateXVar(string4);
                    contextDataItem.setCoordinateYVar(string5);
                    object2 = this.getCoordType(nonSpatialDataSource.getCoordType());
                    int n = nonSpatialDataSource.getWKID();
                    object = nonSpatialDataSource.getCSName();
                    if (object2 == ContextDataItem.CoordinateSys.WKID) {
                        contextDataItem.setWKID(String.valueOf(n));
                    } else if (object2 == ContextDataItem.CoordinateSys.PROJECTION) {
                        contextDataItem.setProjection((String)object);
                    }
                    contextDataItem.setCoorSystem((ContextDataItem.CoordinateSys)((Object)object2));
                }
            } else if (!bl) {
                contextDataItem.setAssocType(ContextDataItem.AssocType.KEYS);
                object2 = nonSpatialDataSource.getMapKeys();
                String string9 = "";
                for (String string10 : object2) {
                    string9 = string9 + string10 + " ";
                }
                object = nonSpatialDataSource.getDataKeys();
                if (object3 == ContextDataItem.DataType.MAP) {
                    contextDataItem.setKeyList((Vector<String>)object2);
                    if (string9.length() == 0) {
                        string9 = this.sDefaultContextKeyName;
                    }
                    string7 = "Key: " + string9;
                    contextDataItem.setDisplayMapString(string7);
                    contextDataItem.setAssocSetStatus(true);
                } else {
                    String string10;
                    string10 = "";
                    Iterator iterator = ((Vector)object).iterator();
                    while (iterator.hasNext()) {
                        String string11 = (String)iterator.next();
                        string10 = string10 + string11 + " ";
                    }
                    contextDataItem.setSelectedMapKeys((Vector<String>)object2);
                    contextDataItem.setSelectedDataKeys((Vector<String>)object);
                    if (string10.length() > 0 && string9.length() > 0) {
                        string7 = "Map Key: " + string9 + "; Data Key: " + string10;
                    }
                    contextDataItem.setDisplayMapString(string7);
                    contextDataItem.setAssocSetStatus(true);
                }
            }
            ((STEMWizardDlg)this.mWizardDialog).getContextPage().addOneItemFromMapSpec(contextDataItem, -1);
        }
    }

    private ContextDataItem.CoordinateSys getCoordType(String string) {
        ContextDataItem.CoordinateSys coordinateSys = ContextDataItem.CoordinateSys.GEO;
        if (string.equals(ContextDataItem.CoordinateSys.CARTESIAN.toString())) {
            coordinateSys = ContextDataItem.CoordinateSys.CARTESIAN;
        } else if (string.equals(ContextDataItem.CoordinateSys.WKID.toString())) {
            coordinateSys = ContextDataItem.CoordinateSys.WKID;
        } else if (string.equals(ContextDataItem.CoordinateSys.PROJECTION.toString())) {
            coordinateSys = ContextDataItem.CoordinateSys.PROJECTION;
        }
        return coordinateSys;
    }

    private void runGeoRelationshipSub(int n) {
        if (n >= 0 && !this.isRowEmpty(n)) {
            MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(n);
            GeoRelationshipSubDlg geoRelationshipSubDlg = new GeoRelationshipSubDlg(this.mWizardDialog, mapSpecItem);
            geoRelationshipSubDlg.setVisible(true);
            if (geoRelationshipSubDlg.continuePressed()) {
                this.mIsMapSpecModified = true;
                String string = this.getRelDisplayString(mapSpecItem.getRelationship(), mapSpecItem.getDistance(), mapSpecItem.getIncrement());
                this.mMapsFileTableModel.setValueAt(string, n, 1);
                this.mIsPageModified = true;
            }
        }
    }

    private ContextDataItem.DataType getDataSourceType(String string) {
        if (string.equals("Map")) {
            return ContextDataItem.DataType.MAP;
        }
        return ContextDataItem.DataType.FILE;
    }

    private boolean getMapInfoFromBackend(String string, String string2, Vector<String> vector) {
        boolean bl = this.callBackendOnShpFile(string, string2);
        if (bl) {
            String string3 = this.updateMapTable(string, string2);
            vector.add(string3);
            this.updateImageForMap(string);
            return true;
        }
        return false;
    }

    private String updateMapTable(String string, String string2) {
        String string3 = this.addOneShpFileInfoTable(string, string2);
        return string3;
    }

    private void updateImageForMap(String string) {
        int n = this.mMapsFileTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        BufferedImage bufferedImage = this.mMapsFileTableModel.getValue(n).getMapImage();
        if (bufferedImage != null) {
            int n2 = bufferedImage.getHeight();
            int n3 = bufferedImage.getWidth();
            Dimension dimension = new Dimension(bufferedImage.getWidth() + 4, bufferedImage.getHeight() + 4);
            this.mCanvas.setImage(bufferedImage);
            this.mCanvas.setPreferredSize(dimension);
            this.mCanvas.setOpaque(true);
            this.mCanvas.setBackground(Color.white);
            this.mImagePanel.validate();
            this.mImagePanel.repaint();
        }
    }

    private boolean addOneGeoSource(GeoContextSource geoContextSource) {
        String string = geoContextSource.getFinalSourceName();
        File file = new File(string);
        String string2 = file.getName();
        String string3 = geoContextSource.getGeoSourceID();
        boolean bl = this.callBackendOnShpFile(string, string2);
        if (bl) {
            String string4;
            String string5 = this.mRelationshipStrings[1];
            double d = 1.0;
            if (this.mMapGeoType == STEMUtil.GeoType.MULTI_POLYGON || this.mMapGeoType == STEMUtil.GeoType.POLYGON) {
                string5 = this.mRelationshipStrings[0];
                d = -1.0;
            }
            if ((string4 = this.getRelStringFromPredicate(geoContextSource.getPredicateType().toString())).length() == 0) {
                string4 = string5;
            }
            MapSpecItem mapSpecItem = new MapSpecItem(string3, string2, string, string4, this.getDistanceString(geoContextSource.getDistanceMeasure()));
            ContextDataItem.CoordinateSys coordinateSys = this.getCoordType(geoContextSource.getCoordType());
            mapSpecItem.setCoorSystem(coordinateSys);
            if (coordinateSys == ContextDataItem.CoordinateSys.WKID) {
                mapSpecItem.setMapWKID(geoContextSource.getWKID());
            } else if (coordinateSys == ContextDataItem.CoordinateSys.PROJECTION) {
                mapSpecItem.setMapCSName(geoContextSource.getCSName());
            }
            mapSpecItem.setProjection(geoContextSource.getProjectionName());
            mapSpecItem.setMaxAssoction(geoContextSource.getMaxRelations());
            mapSpecItem.setMapType(this.mMapGeoType);
            mapSpecItem.setMapImage(this.mMapImage);
            mapSpecItem.setMapGeoJSON(this.mJsonObj);
            mapSpecItem.setMapGeoTypeString(this.mMapGeoTypeString);
            mapSpecItem.setDistance(geoContextSource.getCloseRadius());
            mapSpecItem.setRelDisplayValue(this.getRelDisplayString(mapSpecItem.getRelationship(), geoContextSource.getCloseRadius(), this.getDistanceString(geoContextSource.getDistanceMeasure())));
            this.setMapKeys(mapSpecItem);
            this.addOneRow(mapSpecItem);
            this.updateImageForMap(string);
        }
        return bl;
    }

    private String getDistanceString(GeoContextSource.DistMeasureType distMeasureType) {
        if (distMeasureType == GeoContextSource.DistMeasureType.MILE) {
            return this.mIncrementStr[0];
        }
        if (distMeasureType == GeoContextSource.DistMeasureType.FOOT) {
            return this.mIncrementStr[1];
        }
        if (distMeasureType == GeoContextSource.DistMeasureType.KM) {
            return this.mIncrementStr[2];
        }
        if (distMeasureType == GeoContextSource.DistMeasureType.METER) {
            return this.mIncrementStr[3];
        }
        return this.mIncrementStr[0];
    }

    private String getRelStringFromPredicate(String string) {
        if (string.equalsIgnoreCase("WITHIN")) {
            return this.mRelationshipStrings[0];
        }
        if (string.equalsIgnoreCase("CLOSE")) {
            return this.mRelationshipStrings[1];
        }
        if (string.equalsIgnoreCase("CONTAINS")) {
            return this.mRelationshipStrings[2];
        }
        if (string.equalsIgnoreCase("INTERSECTS")) {
            return this.mRelationshipStrings[4];
        }
        if (string.equalsIgnoreCase("CROSS")) {
            return this.mRelationshipStrings[3];
        }
        if (string.equalsIgnoreCase("EAST")) {
            return this.mRelationshipStrings[7];
        }
        if (string.equalsIgnoreCase("WEST")) {
            return this.mRelationshipStrings[8];
        }
        if (string.equalsIgnoreCase("SOUTH")) {
            return this.mRelationshipStrings[6];
        }
        if (string.equalsIgnoreCase("NORTH")) {
            return this.mRelationshipStrings[5];
        }
        return "";
    }

    String getRelDisplayString(String string, double d, String string2) {
        String string3 = string;
        if (string.equals(this.mRelationshipStrings[1]) || string.equals(this.mRelationshipStrings[5]) | string.equals(this.mRelationshipStrings[6]) || string.equals(this.mRelationshipStrings[7]) || string.equals(this.mRelationshipStrings[8])) {
            string3 = string3 + "(" + d + "," + string2 + ")";
        }
        return string3;
    }

    private String addOneShpFileInfoTable(String string, String string2) {
        String string3 = this.mRelationshipStrings[1];
        double d = 1.0;
        if (this.mMapGeoType == STEMUtil.GeoType.MULTI_POLYGON || this.mMapGeoType == STEMUtil.GeoType.POLYGON) {
            string3 = this.mRelationshipStrings[0];
            d = -1.0;
        }
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
        String string4 = preferences.get("measurement_system", PrefDefaults.DEF_MEASUREMENT_UNITS);
        String string5 = this.mIncrementStr[0];
        if (!string4.equalsIgnoreCase(IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[1])) {
            string5 = this.mIncrementStr[2];
        }
        String string6 = "";
        String string7 = this.mMapLayerTypes.get(string);
        if (string7 != null) {
            string6 = string7.toString();
        }
        if (this.mIsSTP) {
            string3 = "";
        }
        String string8 = string2.substring(0, string2.length() - 4);
        string8 = ((STEMWizardDlg)this.mWizardDialog).findUniqueId(string8);
        MapSpecItem mapSpecItem = new MapSpecItem(string8, string2, string, string3, string5);
        mapSpecItem.setCoorSystem(this.mCurrentMapCoorSys);
        if (this.mCurrentMapCoorSys == ContextDataItem.CoordinateSys.WKID) {
            mapSpecItem.setMapWKID(this.mCurrentMapWKID);
        } else if (this.mCurrentMapCoorSys == ContextDataItem.CoordinateSys.PROJECTION) {
            mapSpecItem.setMapCSName(this.mCurrentMapCSName);
        }
        mapSpecItem.setMapImage(this.mMapImage);
        mapSpecItem.setMapType(this.mMapGeoType);
        mapSpecItem.setMapGeoJSON(this.mJsonObj);
        mapSpecItem.setMapGeoTypeString(this.mMapGeoTypeString);
        mapSpecItem.setDistance(d);
        mapSpecItem.setRelDisplayValue(this.getRelDisplayString(string3, d, string5));
        this.setMapKeys(mapSpecItem);
        this.addOneRow(mapSpecItem);
        return string8;
    }

    private void setMapKeys(MapSpecItem mapSpecItem) {
        mapSpecItem.setMapKeys(this.mVarInfoDbf);
    }

    private void addOneRow(MapSpecItem mapSpecItem) {
        int n = this.mMapsFileTableModel.getRowCount() - 1;
        if (this.isRowEmpty(n)) {
            this.mMapsFileTableModel.removeRow(n);
            this.mMapsFileTableModel.insertRow(n, mapSpecItem);
        } else {
            this.mMapsFileTableModel.addRow(mapSpecItem);
        }
        String string = mapSpecItem.getMapLayer();
        this.mMapsFileTable.setModel(this.mMapsFileTableModel);
        this.mMapsFileTable.getColumnModel().getColumn(0).setCellRenderer(new UnEditableCellTextRenderer());
        n = this.mMapsFileTable.getRowCount() - 1;
        this.mMapsFileTable.setRowSelectionInterval(n, n);
        this.mMapsFileTable.setColumnSelectionInterval(0, 0);
    }

    private boolean isRowEmpty(int n) {
        return n >= 0 && n < this.mMapsFileTable.getRowCount() && (this.mMapsFileTableModel.getValueAt(n, 0) == null || this.mMapsFileTableModel.getValueAt(n, 0).toString().length() == 0);
    }

    private boolean makePreviewImage(String string, String string2) {
        boolean bl = true;
        this.mVarInfoDbf = null;
        try {
            int n;
            int n2;
            boolean bl2;
            STEMUtil.DataModelContent dataModelContent = null;
            String string3 = "";
            int n3 = 0;
            String string4 = "";
            int n4 = 0;
            dataModelContent = this.runValidateMap(string);
            if (dataModelContent == null) {
                return false;
            }
            int n5 = dataModelContent.getWKId();
            String[] stringArray = new String[1];
            boolean bl3 = bl2 = this.mMapsFileTable.getRowCount() == 0;
            if (bl2) {
                if (n5 == -1 || !dataModelContent.isProjected() && this.mAllMapCSName == null) {
                    BaseDialog baseDialog;
                    n2 = 0;
                    if (n5 == -1) {
                        baseDialog = new SelectCoordinateSubDlg(this.mWizardDialog, false);
                        baseDialog.setVisible(true);
                        if (baseDialog.continuePressed()) {
                            int n6 = baseDialog.getSelectedRadioIndex();
                            n5 = baseDialog.getSelctedDisplayProjection(stringArray);
                            switch (n6) {
                                case 0: {
                                    this.mAllMapCoorSys = ContextDataItem.CoordinateSys.GEO;
                                    this.mAllMapWKID = 4326;
                                    this.mAllMapCSName = "GCS_WGS_1984";
                                    this.mAllMapDisplayProj = stringArray[0];
                                    n3 = 4326;
                                    string3 = "GCS_WGS_1984";
                                    n4 = n5;
                                    string4 = CoordinateSystemUtil.getInstance().lookupByWKID(n4).getName();
                                    this.mCurrentMapCoorSys = ContextDataItem.CoordinateSys.GEO;
                                    break;
                                }
                                case 2: {
                                    this.mAllMapCoorSys = ContextDataItem.CoordinateSys.WKID;
                                    this.mAllMapWKID = n5;
                                    this.mAllMapDisplayProj = stringArray[0];
                                    n3 = n5;
                                    this.mAllMapCSName = string3 = CoordinateSystemUtil.getInstance().lookupByWKID(n3).getName();
                                    this.mCurrentMapCoorSys = ContextDataItem.CoordinateSys.WKID;
                                    this.mCurrentMapWKID = n3;
                                    break;
                                }
                                case 3: {
                                    this.mAllMapCoorSys = ContextDataItem.CoordinateSys.PROJECTION;
                                    this.mAllMapCSName = baseDialog.getCSName();
                                    this.mAllMapWKID = CoordinateSystemUtil.getInstance().lookupByName(this.mAllMapCSName).getWKID();
                                    this.mAllMapDisplayProj = stringArray[0];
                                    string3 = baseDialog.getCSName();
                                    n3 = n5;
                                    this.mCurrentMapCoorSys = ContextDataItem.CoordinateSys.PROJECTION;
                                    this.mCurrentMapCSName = string3;
                                }
                            }
                            n2 = 1;
                        }
                    } else {
                        this.mCurrentMapWKID = n5;
                        this.mAllMapWKID = n5;
                        this.mAllMapCSName = CoordinateSystemUtil.getInstance().lookupByWKID(this.mAllMapWKID).getName();
                        baseDialog = new SelectProjectionSubDlg(this.mWizardDialog);
                        baseDialog.setVisible(true);
                        if (baseDialog.continuePressed()) {
                            n5 = baseDialog.getSelctedProjection(stringArray);
                            this.mAllMapCoorSys = ContextDataItem.CoordinateSys.WKID;
                            this.mAllMapDisplayProj = stringArray[0];
                            n4 = n5;
                            string4 = CoordinateSystemUtil.getInstance().lookupByWKID(n4).getName();
                            n2 = 1;
                            this.mCurrentMapCoorSys = ContextDataItem.CoordinateSys.WKID;
                        }
                    }
                    if (n2 == 0) {
                        return false;
                    }
                } else {
                    if (this.mAllMapCSName == null) {
                        this.mAllMapCoorSys = ContextDataItem.CoordinateSys.WKID;
                        this.mAllMapWKID = n5;
                        this.mAllMapCSName = dataModelContent.getCSName();
                        this.mAllMapDisplayProj = "SIMPLE";
                    }
                    this.mCurrentMapCoorSys = ContextDataItem.CoordinateSys.WKID;
                    this.mCurrentMapWKID = n5;
                }
            } else if (n5 != -1 && dataModelContent.isProjected()) {
                this.mCurrentMapCoorSys = ContextDataItem.CoordinateSys.WKID;
                this.mCurrentMapWKID = n5;
            } else {
                if (n5 == -1) {
                    string3 = this.mAllMapCSName;
                    n3 = this.mAllMapWKID;
                }
                if (!dataModelContent.isProjected()) {
                    n4 = this.getDisplayWKID();
                    string4 = n4 == 0 ? "" : CoordinateSystemUtil.getInstance().lookupByWKID(n4).getName();
                }
            }
            dataModelContent = this.runGetGeoJSon(string, string3, n3, string4, n4);
            if (dataModelContent == null) {
                if (this.mMapsFileTable.getRowCount() == 0) {
                    this.mAllMapCoorSys = ContextDataItem.CoordinateSys.GEO;
                    this.mAllMapWKID = 0;
                    this.mAllMapCSName = null;
                    this.mAllMapDisplayProj = "";
                }
                return false;
            }
            this.mVarInfoDbf = dataModelContent.getDataModelFields();
            n2 = dataModelContent.getWKId();
            this.mVarInfoDbf = dataModelContent.getDataModelFields();
            if (this.mShowProjectionDlg && n2 > -1 && dataModelContent.isProjected() && n2 != this.mAllMapWKID && (n = this.mMapsFileTable.getSelectedRow()) >= 0 && !this.isRowEmpty(n)) {
                String string5 = this.mMapsFileTable.getValueAt(n, 0).toString();
                ProjectionSubDlg projectionSubDlg = new ProjectionSubDlg(this.mWizardDialog, string5, Integer.toString(this.mAllMapWKID), string2, Integer.toString(n2));
                projectionSubDlg.setVisible(true);
                if (projectionSubDlg.continuePressed()) {
                    int n7 = projectionSubDlg.getSelectedRadio();
                    if (n7 == 1) {
                        this.mAllMapWKID = n2;
                        this.mAllMapCSName = CoordinateSystemUtil.getInstance().lookupByWKID(this.mAllMapWKID).getName();
                        this.mAllMapCoorSys = this.mCurrentMapCoorSys;
                    }
                    this.mShowProjectionDlg = !projectionSubDlg.isUseForAllChecked();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private int getDisplayWKID() {
        if (this.mAllMapDisplayProj.equals("SIMPLE")) {
            return 0;
        }
        if (this.mAllMapDisplayProj.equals("MERCATOR")) {
            return 3857;
        }
        if (this.mAllMapDisplayProj.equals("WINKELTRIPEL")) {
            return 4326;
        }
        if (this.mAllMapDisplayProj.equals("STEREOGRAPHIC")) {
            return 4326;
        }
        return 0;
    }

    private STEMUtil.DataModelContent runGetGeoJSon(String string, String string2, int n, String string3, int n2) {
        STEMUtil.DataModelContent dataModelContent = null;
        String string4 = "";
        String string5 = "";
        String string6 = PrefsMgr.getPrefsMgr().getTempPath();
        File file = null;
        File file2 = null;
        try {
            file = PASWFileUtil.createTempFile((String)"datamodel", (String)".xml", (File)new File(string6));
            file2 = PASWFileUtil.createTempFile((String)"GeoJson", (String)".json", (File)new File(string6));
            file2.deleteOnExit();
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().getShapeGeoJSON(string2, n, string3, n2, string, file, file2);
        if (aSMapsError.getHasError()) {
            string4 = aSMapsError.getMessage();
            string5 = aSMapsError.getExplain();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string4 + " " + string5, VersionInfo.getAppVersionString());
        } else {
            dataModelContent = STEMUtil.handleDataModelXML(file.getAbsolutePath());
            if (dataModelContent != null) {
                BufferedImage bufferedImage = this.renderGeoJSON(file2.getAbsolutePath(), dataModelContent.getGeoType(), this.getProjection(dataModelContent.getWKId()));
                if (bufferedImage != null) {
                    this.mMapImage = bufferedImage;
                    this.mMapGeoType = dataModelContent.getGeoType();
                    this.mMapAndImage.put(string, bufferedImage);
                } else {
                    string4 = this.mWizardDialog.getResString("IDS_STEM_MAP_FILE_ERROR");
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string4, VersionInfo.getAppVersionString());
                    dataModelContent = null;
                }
            }
        }
        file.delete();
        file2.delete();
        return dataModelContent;
    }

    private STEMUtil.DataModelContent runValidateMap(String string) {
        STEMUtil.DataModelContent dataModelContent = null;
        String string2 = "";
        String string3 = "";
        String string4 = PrefsMgr.getPrefsMgr().getTempPath();
        File file = null;
        try {
            file = PASWFileUtil.createTempFile((String)"datamodel", (String)".xml", (File)new File(string4));
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().validateShapeFile(string, file);
        if (aSMapsError.getHasError()) {
            string2 = aSMapsError.getMessage();
            string3 = aSMapsError.getExplain();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string2 + " " + string3, VersionInfo.getAppVersionString());
        } else {
            dataModelContent = STEMUtil.handleDataModelXML(file.getAbsolutePath());
        }
        file.delete();
        return dataModelContent;
    }

    private BufferedImage renderGeoJSON(String string, STEMUtil.GeoType geoType, String string2) {
        BufferedImage bufferedImage = null;
        this.mJsonObj = null;
        this.mMapGeoTypeString = "";
        OutputVisComponentImpl outputVisComponentImpl = new OutputVisComponentImpl();
        File file = new File(string);
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2;
            String string3 = file.getName();
            JSONObject jSONObject3 = JSONObject.parse((InputStream)new FileInputStream(file));
            String string4 = (String)jSONObject3.get((Object)"id");
            if (string4 == null) {
                string4 = string3.substring(0, string3.length() - 5);
            }
            this.mMapGeoTypeString = this.getGeoTypeString(geoType);
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put((Object)"name", (Object)string4);
            jSONObject4.put((Object)"shape", (Object)this.mMapGeoTypeString);
            jSONArray.add((Object)jSONObject4);
            if (jSONObject3.get((Object)"source") == null) {
                jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"id", (Object)string4);
                jSONObject = new JSONObject();
                jSONObject.put((Object)"type", (Object)"GeoJSON");
                jSONObject.put((Object)"key", null);
                jSONObject.put((Object)"value", (Object)jSONObject3);
                jSONObject2.put((Object)"source", (Object)jSONObject);
                this.mJsonObj = jSONObject2;
                outputVisComponentImpl.addExternalSource((String)jSONObject2.get((Object)"id"), (JSONObject)jSONObject2.get((Object)"source"));
            } else {
                outputVisComponentImpl.addExternalSource(string4, jSONObject3);
                this.mJsonObj = jSONObject3;
            }
            jSONObject2 = new JSONArray();
            jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)"mapProjection");
            jSONObject.put((Object)"value", (Object)this.mAllMapDisplayProj);
            jSONObject2.add((Object)jSONObject);
            JSONObject jSONObject5 = MapStatJSONUtil.generateMapStatJSON((JSONArray)jSONArray);
            outputVisComponentImpl.setExternalConfig((JSONArray)jSONObject2);
            outputVisComponentImpl.setViewStatJSON(jSONObject5);
            outputVisComponentImpl.showView(new ArrayList());
            bufferedImage = OutputVisComponentUtil.exportComponentViewAsImage((OutputVisComponent)outputVisComponentImpl, (Integer)STEMGeoRelationshipPage.mImageSize.width, (Integer)300);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        file.delete();
        return bufferedImage;
    }

    private String getGeoTypeString(STEMUtil.GeoType geoType) {
        String string = geoType == STEMUtil.GeoType.POINT || geoType == STEMUtil.GeoType.MULTI_POINT ? MapStatJSONUtil.GeoJSONShapeType.point.name() : (geoType == STEMUtil.GeoType.POLYGON || geoType == STEMUtil.GeoType.MULTI_POLYGON ? MapStatJSONUtil.GeoJSONShapeType.polygon.name() : MapStatJSONUtil.GeoJSONShapeType.polygon.name());
        return string;
    }

    private String getProjection(int n) {
        String string = "simple";
        if (n == 4326) {
            string = "winkelTripel";
        }
        return string;
    }

    private void showAllMaps() {
        BufferedImage bufferedImage = this.getAllImage();
        if (bufferedImage != null) {
            Dimension dimension = new Dimension(bufferedImage.getWidth() + 4, bufferedImage.getHeight() + 4);
            this.mCanvas.setImage(bufferedImage);
            this.mCanvas.setPreferredSize(dimension);
            this.mCanvas.setOpaque(true);
            this.mCanvas.setBackground(Color.white);
            this.mImagePanel.validate();
            this.mImagePanel.repaint();
        }
    }

    private BufferedImage getAllImage() {
        return this.getAllImage(STEMGeoRelationshipPage.mImageSize.width, 300);
    }

    BufferedImage getAllImage(int n, int n2) {
        Object object;
        JSONObject jSONObject;
        MapSpecItem mapSpecItem;
        this.mJsonObj = null;
        int n3 = this.mMapsFileTableModel.getRowCount();
        if (n3 == 0) {
            return null;
        }
        OutputVisComponentImpl outputVisComponentImpl = new OutputVisComponentImpl();
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < n3; ++i) {
            mapSpecItem = this.mMapsFileTableModel.getValue(i);
            jSONObject = mapSpecItem.getMapGeoJSON();
            object = (String)jSONObject.get((Object)"id");
            String string = mapSpecItem.getMapGeoTypeString();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put((Object)"name", object);
            jSONObject2.put((Object)"shape", (Object)string);
            jSONArray.add((Object)jSONObject2);
            outputVisComponentImpl.addExternalSource((String)object, (JSONObject)jSONObject.get((Object)"source"));
        }
        JSONObject jSONObject3 = MapStatJSONUtil.generateMapStatJSON((JSONArray)jSONArray);
        mapSpecItem = new JSONArray();
        jSONObject = new JSONObject();
        jSONObject.put((Object)"id", (Object)"mapProjection");
        jSONObject.put((Object)"value", (Object)"simple");
        mapSpecItem.add(jSONObject);
        outputVisComponentImpl.setExternalConfig((JSONArray)mapSpecItem);
        outputVisComponentImpl.setViewStatJSON(jSONObject3);
        outputVisComponentImpl.showView(new ArrayList());
        object = OutputVisComponentUtil.exportComponentViewAsImage((OutputVisComponent)outputVisComponentImpl, (Integer)n, (Integer)n2);
        return object;
    }

    private void enableButtons() {
        this.mAddFileButton.setEnabled(true);
        this.mLoadMapSpecButton.setEnabled(true);
        if (this.mMapsFileTable.getRowCount() == 0) {
            this.mPreviewAllButton.setEnabled(false);
        } else {
            this.mPreviewAllButton.setEnabled(true);
        }
        if (!this.mIsSTP) {
            this.mRelationButton.setEnabled(true);
        } else {
            this.mRelationButton.setEnabled(false);
        }
        if (this.mMapsFileTable.getRowCount() == 0 || this.mMapsFileTable.getSelectedRowCount() == 0 || this.mMapsFileTable.getRowCount() == 1 && this.isRowEmpty(0)) {
            this.mDownButton.setEnabled(false);
            this.mDeleteButton.setEnabled(false);
            this.mUpButton.setEnabled(false);
            this.mRelationButton.setEnabled(false);
            this.mAddFileButton.requestFocusInWindow();
        } else if (this.mMapsFileTable.getRowCount() == 1 && this.mMapsFileTable.getSelectedRowCount() == 1) {
            this.mDeleteButton.setEnabled(true);
            this.mDownButton.setEnabled(false);
            this.mUpButton.setEnabled(false);
        } else if (this.mMapsFileTable.getRowCount() > 1 && this.mMapsFileTable.getSelectedRowCount() >= 1) {
            this.mDeleteButton.setEnabled(true);
            int n = this.mMapsFileTable.getSelectedRow();
            if (n == 0) {
                this.mDownButton.setEnabled(true);
                this.mUpButton.setEnabled(false);
            } else if (n == this.mMapsFileTable.getRowCount() - 1) {
                this.mDownButton.setEnabled(false);
                this.mUpButton.setEnabled(true);
            } else {
                this.mDownButton.setEnabled(true);
                this.mUpButton.setEnabled(true);
            }
        }
        if (this.mIsSTP && this.mMapsFileTable.getRowCount() >= 1) {
            this.mAddFileButton.setEnabled(false);
            this.mLoadMapSpecButton.setEnabled(false);
        }
    }

    private void manipulateDown(int n) {
        int n2 = n + 2;
        int n3 = n;
        MapTableModel mapTableModel = (MapTableModel)this.mMapsFileTable.getModel();
        MapSpecItem mapSpecItem = mapTableModel.getValue(n);
        mapTableModel.insertRow(n2, mapSpecItem);
        mapTableModel.removeRow(n3);
        this.mMapsFileTable.getSelectionModel().setSelectionInterval(n2 - 1, n2 - 1);
        this.updateImageForMap(this.mMapsFileTable.getValueAt(n2 - 1, 0).toString());
    }

    private void manipulateUp(int n) {
        int n2 = n - 1;
        int n3 = n + 1;
        MapTableModel mapTableModel = (MapTableModel)this.mMapsFileTable.getModel();
        MapSpecItem mapSpecItem = mapTableModel.getValue(n);
        mapTableModel.insertRow(n2, mapSpecItem);
        mapTableModel.removeRow(n3);
        this.mMapsFileTable.getSelectionModel().setSelectionInterval(n2, n2);
        this.updateImageForMap(this.mMapsFileTable.getValueAt(n2, 0).toString());
    }

    private void deleteOneRow() {
        int n = this.mMapsFileTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (!this.isRowEmpty(n)) {
            MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(n);
            String string = mapSpecItem.getMapFullName();
            this.mMapAndImage.remove(string);
            this.mMapLayerTypes.remove(string);
            this.mMapsFileTableModel.removeRow(n);
            this.updateSourceTable(string, mapSpecItem.getMapFileName(), false, mapSpecItem.getMapId());
            int n2 = -1;
            if (n < this.mMapsFileTable.getRowCount()) {
                this.mMapsFileTable.setRowSelectionInterval(n, n);
                this.mMapsFileTable.setColumnSelectionInterval(0, 0);
                n2 = n;
            } else if (n - 1 >= 0) {
                this.mMapsFileTable.setRowSelectionInterval(n - 1, n - 1);
                this.mMapsFileTable.setColumnSelectionInterval(0, 0);
                n2 = n - 1;
            }
            if (n2 >= 0) {
                mapSpecItem = this.mMapsFileTableModel.getValue(n2);
                string = mapSpecItem.getMapFullName();
                this.updateImageForMap(string);
            } else {
                this.mCanvas.setImage(null);
            }
            if (this.mMapsFileTable.getSelectedRowCount() == 0) {
                this.mUpButton.setEnabled(false);
                this.mDownButton.setEnabled(false);
                this.mDeleteButton.setEnabled(false);
                this.mAddFileButton.requestFocusInWindow();
            }
        }
        this.enableButtons();
    }

    @Override
    protected void loadDialogState() {
    }

    @Override
    protected void saveDialogState() {
    }

    void reset() {
        this.mMapsFileTableModel.removeAll();
        this.mCanvas.setImage(null);
        this.setDefault();
    }

    @Override
    public void init() {
        JSeparator jSeparator;
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        if (jPanel.getComponentCount() > 0) {
            DialogUtil.normalizeLabelWidths(jPanel);
            DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 2;
            insets.top = n2;
            jSeparator = new JSeparator();
            DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mInfoText1, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(0, n2 * 3, 0, n2 * 3);
        DialogUtil.addUsingGBL(jPanel2, this.mLoadMapSpecButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel2, gridBagConstraints, 0, 0, 3, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mInfoText2, gridBagConstraints, 0, 1, 3, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mMapsFileTable, 20, 31);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mMapsTableLabel, gridBagConstraints, 0, 2, 2, 1, n, insets);
        jScrollPane.setMinimumSize(new Dimension(200, 100));
        jScrollPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2, 2, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, jScrollPane, gridBagConstraints, 0, 3, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, 2, 2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.createButtonsPanel(new JButton[]{this.mAddFileButton, this.mRelationButton, this.mUpButton, this.mDownButton}), gridBagConstraints, 1, 3, 1, 1, n, insets);
        insets.set(n2, n2, 3, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mDeleteButton, gridBagConstraints, 1, 4, 1, 1, 25, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mPreviewLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, 2, n2, n2);
        this.mCanvas.setPreferredSize(mImageSize);
        this.mCanvas.setMinimumSize(mImageSize);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Dimension dimension = new Dimension(200, 300);
        this.mImagePanel.setMinimumSize(dimension);
        this.mImagePanel.setPreferredSize(dimension);
        insets.set(0, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mImagePanel, gridBagConstraints, 2, 3, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(2, n2, 2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mPreviewAllButton, gridBagConstraints, 0, 5, 1, 1, 10, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.top = n2;
        jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 6, 3, 1, 20, insets);
        this.setDefault();
        this.setTabTraversalOrder();
    }

    private JPanel createButtonsPanel(JButton[] jButtonArray) {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = 0;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n3, n3, n3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        for (n2 = 0; n2 < jButtonArray.length; ++n2) {
            DialogUtil.addUsingGBL(jPanel, jButtonArray[n2], gridBagConstraints, 0, n2, 1, 1, n, insets);
        }
        return jPanel;
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsSTP) {
            return "idh_stem_stp_select_map";
        }
        return "idh_stem_select_maps";
    }

    @Override
    public boolean validate() {
        boolean bl = true;
        return bl && super.validate();
    }

    @Override
    public String getNextPage() {
        if (this.mIsPageModified || this.mMapsFileTable.getRowCount() != 0 || this.mFromDataSource) {
            ((STEMWizardDlg)this.mWizardDialog).getContextPage().setKeepSettings(!this.mIsPageModified);
        }
        return "STEMDataSourcePage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mIsPageModified = false;
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
        this.mIsSTP = !((STEMWizardDlg)this.mWizardDialog).getStepOnePage().isGSARSelected();
        this.mRoleString = this.mIsSTP ? this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_STP_ARRARY") : this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_ARRARY");
        this.mWizardDialog.enableNext(true);
        this.enableButtons();
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfoText1);
        vector.add(this.mLoadMapSpecButton);
        vector.add(this.mInfoText2);
        vector.add(this.mMapsFileTable);
        vector.add(this.mAddFileButton);
        vector.add(this.mUpButton);
        vector.add(this.mDownButton);
        vector.add(this.mDeleteButton);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        return jPanel;
    }

    private void initVars() {
        this.mInfoText1 = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STEP_THREE_INFOR_TEXT_1"), null);
        this.mInfoText2 = new FocusableTextArea(this.mWizardDialog.getResString("IDS_STEM_STEP_THREE_INFOR_TEXT_2"), null);
        this.mRoleString = this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_ARRARY");
        this.sDefaultContextKeyName = this.mWizardDialog.getResString("IDS_STEM_CONTEXT_DATA_DEFAULT_KEY");
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_STEP_THREE_LOAD_MAP_SPEC_BUTTON");
        this.mLoadMapSpecButton = new JButton(toggleButtonAction);
        this.mLoadMapSpecButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_MAPS_ADD_FILE_BUTTON_LABEL");
        this.mAddFileButton = new JButton(toggleButtonAction);
        this.mAddFileButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_MAPS_ADD_SERVICE_BUTTON_LABEL");
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_MAPS_RELATION_BUTTON_LABEL");
        this.mRelationButton = new JButton(toggleButtonAction);
        this.mRelationButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_MAPS_UP_BUTTON_LABEL");
        this.mUpButton = new JButton(toggleButtonAction);
        this.mUpButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_MAPS_DOWN_BUTTON_LABEL");
        this.mDownButton = new JButton(toggleButtonAction);
        this.mDownButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_MAPS_DELETE_BUTTON_LABEL");
        this.mDeleteButton = new JButton(toggleButtonAction);
        this.mDeleteButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_MAPS_PREVIEW_ALL_BUTTON_LABEL");
        this.mPreviewAllButton = new JButton(toggleButtonAction);
        this.mPreviewAllButton.addActionListener(this);
        String[] stringArray = this.mWizardDialog.getResStringArray("IDS_STEM_STEP_THREE_MAP_TABLE_HEADER_ARRARY");
        this.mIncrementStr = this.mWizardDialog.getResStringArray("IDS_STEM_GEOSPATIAL_RELATION_SUB_INCREMENT_VALUES");
        this.mMapsFileTableModel = new MapTableModel(stringArray);
        this.mMapsFileTable = new PlainTable();
        this.mMapsFileTable.setModel(this.mMapsFileTableModel);
        this.mMapsFileTable.setRowHeight(22);
        this.mMapsFileTable.setColumnSelectionAllowed(false);
        this.mMapsFileTable.setRowSelectionAllowed(true);
        this.mMapsFileTable.setSelectionMode(0);
        this.mMapsFileTable.getTableHeader().setReorderingAllowed(false);
        this.mMapsFileTable.getTableHeader().setResizingAllowed(true);
        this.mMapsFileTable.setGridColor(Color.darkGray);
        this.mMapsFileTable.getTableHeader().setReorderingAllowed(false);
        this.mMapsFileTable.setSelectionMode(0);
        this.mMapsFileTable.getColumnModel().getColumn(1).setCellRenderer(new UnEditableCellTextRenderer());
        this.mRelationshipStrings = this.mWizardDialog.getResStringArray("IDS_STEM_STEP_THREE_MAP_RELATIONSHIP_ARRARY");
        this.mMapsFileTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = STEMGeoRelationshipPage.this.mMapsFileTable.getSelectedRow();
                if (n >= 0 && !STEMGeoRelationshipPage.this.isRowEmpty(n)) {
                    STEMGeoRelationshipPage.this.mIsMapSpecModified = true;
                    String string = STEMGeoRelationshipPage.this.mMapsFileTableModel.getValue(n).getMapFullName();
                    STEMGeoRelationshipPage.this.updateImageForMap(string);
                    STEMGeoRelationshipPage.this.enableButtons();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!STEMGeoRelationshipPage.this.mIsSTP) {
                    int n = STEMGeoRelationshipPage.this.mMapsFileTable.getSelectedColumn();
                    int n2 = STEMGeoRelationshipPage.this.mMapsFileTable.getSelectedRow();
                    if (n == 2 && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                        STEMGeoRelationshipPage.this.runGeoRelationshipSub(n2);
                    }
                }
            }
        });
        this.mMapsTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_MAPS_MAP_TABLE_LABEL");
        this.mMapsTableLabel.setLabelFor(this.mMapsFileTable);
        this.mCanvas = new STEMPreviewCanvas(null);
        this.mImagePanel = new MapImagePanel(this.mCanvas, mImageSize);
        this.mPreviewLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_MAPS_PREVIEW_PANEL_LABEL");
        this.mPreviewLabel.setLabelFor(this.mImagePanel);
    }

    private void setDefault() {
        this.mMapSpecPath = "";
        this.mIsMapSpecModified = false;
        this.mAllMapCoorSys = ContextDataItem.CoordinateSys.GEO;
        this.mAllMapWKID = 0;
        this.mAllMapCSName = null;
        this.mAllMapDisplayProj = "";
        this.mShowProjectionDlg = true;
    }

    String getMapSpecPath() {
        return this.mMapSpecPath;
    }

    private boolean callBackendOnShpFile(String string, String string2) {
        SpssProgressDlg spssProgressDlg = new SpssProgressDlg((Window)((Object)this.mWizardDialog), VersionInfo.getAppVersionString());
        spssProgressDlg.setMessage(this.mWizardDialog.getResString("IDS_STEM_LOAD_MAP_PROGRESS_DLG_TEXT"));
        spssProgressDlg.setLocationRelativeTo((Component)((Object)this.mWizardDialog));
        MapInteractiveCallRunnable mapInteractiveCallRunnable = new MapInteractiveCallRunnable(string, string2, spssProgressDlg);
        Thread thread = new Thread(mapInteractiveCallRunnable);
        thread.start();
        spssProgressDlg.setVisible(true);
        if (!spssProgressDlg.isWorkDone()) {
            thread.interrupt();
            return false;
        }
        return mapInteractiveCallRunnable.isConnectSuccess();
    }

    String getMapSpecSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        int n = this.mMapsFileTable.getRowCount();
        if (this.mMapSpecPath.length() > 0 && !this.mIsMapSpecModified) {
            return stringBuffer.toString();
        }
        stringBuffer.append("\nSPATIAL MAPSPEC");
        String string = this.getMapProjectionSyntax(n);
        stringBuffer.append(string);
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n /MAP");
            MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(i);
            stringBuffer.append(" TYPE=");
            if (mapSpecItem.getMapLayer().length() == 0) {
                stringBuffer.append("FILE");
            } else {
                stringBuffer.append("SERVICE");
            }
            stringBuffer.append(" SOURCE=" + CharacterUtil.smartQuote((String)mapSpecItem.getMapFullName()) + " ");
            if (mapSpecItem.getMapLayer().length() > 0) {
                stringBuffer.append(" LAYER=" + mapSpecItem.getMapLayer());
            }
            stringBuffer.append(" IDENTIFIER=" + mapSpecItem.getMapId());
            ContextDataItem.CoordinateSys coordinateSys = mapSpecItem.getCoorSystem();
            if (coordinateSys != null) {
                stringBuffer.append(" COORDSYSTEM=");
                if (coordinateSys == ContextDataItem.CoordinateSys.GEO) {
                    stringBuffer.append("GEOGRAPHIC ");
                } else if (coordinateSys == ContextDataItem.CoordinateSys.WKID) {
                    stringBuffer.append("WKID(" + mapSpecItem.getMapWKID() + ") ");
                } else if (coordinateSys == ContextDataItem.CoordinateSys.PROJECTION) {
                    stringBuffer.append("PROJECTION(\"" + mapSpecItem.getMapCSName() + "\") ");
                }
            }
            if (this.mIsSTP) continue;
            stringBuffer.append(" SPATIALRELATION=" + this.getRelationshipSyntax(mapSpecItem.getRelationship()));
            String string2 = mapSpecItem.getRelationship();
            if (string2.equals(this.mRelationshipStrings[1]) || string2.equals(this.mRelationshipStrings[5]) | string2.equals(this.mRelationshipStrings[6]) || string2.equals(this.mRelationshipStrings[7]) || string2.equals(this.mRelationshipStrings[8])) {
                stringBuffer.append(" CLOSERADIUS=" + mapSpecItem.getDistance());
                stringBuffer.append(" CLOSEMEASURE=" + this.getCloseMeasureSyntax(mapSpecItem.getIncrement()));
            }
            stringBuffer.append(" MAXRELATIONS=" + mapSpecItem.getMaxAssoction());
        }
        return stringBuffer.toString();
    }

    private String getMapProjectionSyntax(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (n == 0 && this.mIsSTP) {
            stringBuffer.append("\n /MAPPROJECTION ");
            if (this.mAllMapCoorSys == ContextDataItem.CoordinateSys.CARTESIAN) {
                stringBuffer.append("PROJECTION=CARTESIAN ");
            } else if (this.mAllMapCSName != null && !this.mAllMapCSName.startsWith("GCS_")) {
                stringBuffer.append("WKID=" + this.mAllMapWKID + " ");
                if (this.mAllMapCSName.length() > 0) {
                    stringBuffer.append("PROJECTION=\"" + this.mAllMapCSName + "\" ");
                }
            }
            stringBuffer.append(" DISPLAY=" + this.mAllMapDisplayProj);
        } else if (n > 0) {
            int n2 = 0;
            String string = "";
            if (!(this.mAllMapCoorSys != ContextDataItem.CoordinateSys.PROJECTION && this.mAllMapCoorSys != ContextDataItem.CoordinateSys.WKID || this.mAllMapCSName == null || this.mAllMapCSName.startsWith("GCS_"))) {
                n2 = this.mAllMapWKID;
                string = this.mAllMapCSName;
            }
            for (int i = 0; i < n && n2 == 0; ++i) {
                MapSpecItem mapSpecItem = this.mMapsFileTableModel.getValue(i);
                ContextDataItem.CoordinateSys coordinateSys = mapSpecItem.getCoorSystem();
                if (coordinateSys == null || string.length() != 0 || coordinateSys != ContextDataItem.CoordinateSys.WKID && coordinateSys != ContextDataItem.CoordinateSys.PROJECTION) continue;
                String string2 = mapSpecItem.getMapCSName();
                if (string2.length() > 0) {
                    if (string2.startsWith("GCS_")) continue;
                    string = string2;
                    n2 = mapSpecItem.getMapWKID();
                    if (n2 != 0) continue;
                    n2 = CoordinateSystemUtil.getInstance().lookupByName(string).getWKID();
                    continue;
                }
                string2 = CoordinateSystemUtil.getInstance().lookupByWKID(mapSpecItem.getMapWKID()).getName();
                if (string2.startsWith("GCS_")) continue;
                string = string2;
                n2 = mapSpecItem.getMapWKID();
            }
            if (n2 != 0) {
                stringBuffer.append("\n /MAPPROJECTION ");
                stringBuffer.append("WKID=" + n2 + " ");
                stringBuffer.append("PROJECTION=\"" + string + "\" ");
                stringBuffer.append(" DISPLAY=SIMPLE");
            } else {
                stringBuffer.append("\n /MAPPROJECTION ");
                stringBuffer.append(" DISPLAY=" + this.mAllMapDisplayProj);
            }
        }
        return stringBuffer.toString();
    }

    private String getRelationshipSyntax(String string) {
        int n = -1;
        for (int i = 0; i < this.mRelationshipStrings.length; ++i) {
            if (!this.mRelationshipStrings[i].equals(string)) continue;
            n = i;
        }
        switch (n) {
            case 0: {
                return "WITHIN";
            }
            case 1: {
                return "CLOSE";
            }
            case 2: {
                return "CONTAINS";
            }
            case 3: {
                return "CROSS";
            }
            case 4: {
                return "INTERSECTS";
            }
            case 5: {
                return "NORTH";
            }
            case 6: {
                return "SOUTH";
            }
            case 7: {
                return "EAST";
            }
            case 8: {
                return "WEST";
            }
        }
        return "";
    }

    private String getCloseMeasureSyntax(String string) {
        int n = -1;
        for (int i = 0; i < this.mIncrementStr.length; ++i) {
            if (!this.mIncrementStr[i].equals(string)) continue;
            n = i;
        }
        switch (n) {
            case 0: {
                return "MILE";
            }
            case 1: {
                return "FOOT";
            }
            case 2: {
                return "KILOMETER";
            }
            case 3: {
                return "METER";
            }
            case 4: {
                return "CENTIMETER";
            }
        }
        return "";
    }

    class MapInteractiveCallRunnable
    implements Runnable {
        private boolean mBackEndRequestSuccess = false;
        private SpssProgressDlg mSpssProgressDlg;
        private String mShpFilePath;
        private String mShpFileName;

        public MapInteractiveCallRunnable(String string, String string2, SpssProgressDlg spssProgressDlg) {
            this.mSpssProgressDlg = spssProgressDlg;
            this.mShpFilePath = string;
            this.mShpFileName = string2;
        }

        @Override
        public void run() {
            try {
                this.mBackEndRequestSuccess = STEMGeoRelationshipPage.this.makePreviewImage(this.mShpFilePath, this.mShpFileName);
                if (Thread.currentThread().isInterrupted()) {
                    this.mBackEndRequestSuccess = false;
                    return;
                }
                this.mSpssProgressDlg.setWorkDone(true);
            }
            catch (Exception exception) {
                this.mBackEndRequestSuccess = false;
                this.mSpssProgressDlg.setWorkDone(true);
            }
            this.mSpssProgressDlg.dispose();
        }

        public boolean isConnectSuccess() {
            return this.mBackEndRequestSuccess;
        }
    }

    class MapSpecItem
    implements SerializableObject {
        private String mMapId;
        private String mMapFileName = "";
        private String mMapFullName;
        private String mMapLayer;
        private String mRelationship;
        private double mDistance;
        private String mIncrement;
        private int mMaxAssoction;
        private String mProjection;
        private boolean mRenderUnmatched;
        private JSONObject mMapGeoJSON;
        private BufferedImage mMapImage;
        private String mMapGeoTypeString;
        private STEMUtil.GeoType mMapType;
        private String mRelDisplayValue;
        private int mMapWKID;
        private String mMapCSName;
        private ContextDataItem.CoordinateSys mCoordSysType;
        private Vector<ISpssVariable> mMapKeys;

        public MapSpecItem(String string, String string2, String string3, String string4, String string5) {
            this.mMapId = string;
            this.mMapFileName = string2;
            this.mMapFullName = string3;
            this.mMapLayer = "";
            this.mRelationship = string4;
            this.mDistance = 1.0;
            this.mIncrement = string5;
            this.mMaxAssoction = 1;
            this.mProjection = "";
            this.mRenderUnmatched = true;
            this.mMapGeoJSON = null;
            this.mMapImage = null;
            this.mMapGeoTypeString = "";
            this.mMapKeys = new Vector();
            this.mRelDisplayValue = "";
            this.mCoordSysType = ContextDataItem.CoordinateSys.GEO;
            this.mMapCSName = "";
            this.mMapWKID = 0;
            this.mMapType = STEMUtil.GeoType.UNKNOWN;
        }

        public String getMapId() {
            return this.mMapId;
        }

        public void setMapId(String string) {
            this.mMapId = string;
        }

        public String getMapFileName() {
            return this.mMapFileName;
        }

        public void setMapFileName(String string) {
            this.mMapFileName = string;
        }

        public String getMapFullName() {
            return this.mMapFullName;
        }

        public void setMapFullName(String string) {
            this.mMapFullName = string;
        }

        public String getMapLayer() {
            return this.mMapLayer;
        }

        public void setMapLayer(String string) {
            this.mMapLayer = string;
        }

        public String getRelationship() {
            return this.mRelationship;
        }

        public void setRelationship(String string) {
            this.mRelationship = string;
        }

        public String getRelDisplayValue() {
            return this.mRelDisplayValue;
        }

        public void setRelDisplayValue(String string) {
            this.mRelDisplayValue = string;
        }

        public double getDistance() {
            return this.mDistance;
        }

        public void setDistance(double d) {
            this.mDistance = d;
        }

        public String getIncrement() {
            return this.mIncrement;
        }

        public void setIncrement(String string) {
            this.mIncrement = string;
        }

        public int getMaxAssoction() {
            return this.mMaxAssoction;
        }

        public void setMaxAssoction(int n) {
            this.mMaxAssoction = n;
        }

        public String getProjection() {
            return this.mProjection;
        }

        public void setProjection(String string) {
            this.mProjection = string;
        }

        public boolean isRenderUnmatched() {
            return this.mRenderUnmatched;
        }

        public void setRenderUnmatched(boolean bl) {
            this.mRenderUnmatched = bl;
        }

        public JSONObject getMapGeoJSON() {
            return this.mMapGeoJSON;
        }

        public void setMapGeoJSON(JSONObject jSONObject) {
            this.mMapGeoJSON = jSONObject;
        }

        public BufferedImage getMapImage() {
            return this.mMapImage;
        }

        public void setMapImage(BufferedImage bufferedImage) {
            this.mMapImage = bufferedImage;
        }

        public String getMapGeoTypeString() {
            return this.mMapGeoTypeString;
        }

        public void setMapGeoTypeString(String string) {
            this.mMapGeoTypeString = string;
        }

        public ContextDataItem.CoordinateSys getCoorSystem() {
            return this.mCoordSysType;
        }

        public void setCoorSystem(ContextDataItem.CoordinateSys coordinateSys) {
            this.mCoordSysType = coordinateSys;
        }

        public int getMapWKID() {
            return this.mMapWKID;
        }

        public void setMapWKID(int n) {
            this.mMapWKID = n;
        }

        public String getMapCSName() {
            return this.mMapCSName;
        }

        public void setMapCSName(String string) {
            this.mMapCSName = string;
        }

        public Vector<ISpssVariable> getMapKeys() {
            return this.mMapKeys;
        }

        public boolean isMapKeyNumeric(String string) {
            boolean bl = true;
            if (this.mMapKeys != null) {
                for (ISpssVariable iSpssVariable : this.mMapKeys) {
                    if (!iSpssVariable.getName().equals(string) || iSpssVariable.getType() <= 0) continue;
                    bl = false;
                    break;
                }
            }
            return bl;
        }

        public void setMapKeys(Vector<ISpssVariable> vector) {
            this.mMapKeys = vector;
        }

        public STEMUtil.GeoType getMapType() {
            return this.mMapType;
        }

        public void setMapType(STEMUtil.GeoType geoType) {
            this.mMapType = geoType;
        }

        protected Object clone() throws CloneNotSupportedException {
            MapSpecItem mapSpecItem = new MapSpecItem(this.mMapId, this.mMapFileName, this.mMapFullName, this.mRelationship, this.mIncrement);
            mapSpecItem.setMapLayer(this.mMapLayer);
            mapSpecItem.setDistance(this.mDistance);
            mapSpecItem.setMaxAssoction(this.mMaxAssoction);
            mapSpecItem.setProjection(this.mProjection);
            mapSpecItem.setRenderUnmatched(this.mRenderUnmatched);
            return mapSpecItem;
        }

        public String getClassName() {
            return " com.spss.java_client.ui.dialogs.STEM.STEMGeoRelationshipPage.MapSpecItem";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mMapId = objectInputStream.readUTF();
            this.mMapFileName = objectInputStream.readUTF();
            this.mMapFullName = objectInputStream.readUTF();
            this.mMapLayer = objectInputStream.readUTF();
            this.mRelationship = objectInputStream.readUTF();
            this.mDistance = objectInputStream.readInt();
            this.mIncrement = objectInputStream.readUTF();
            this.mMaxAssoction = objectInputStream.readInt();
            this.mProjection = objectInputStream.readUTF();
            this.mRenderUnmatched = objectInputStream.readBoolean();
            return true;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.mMapId);
            objectOutputStream.writeUTF(this.mMapFileName);
            objectOutputStream.writeUTF(this.mMapFullName);
            objectOutputStream.writeUTF(this.mMapLayer);
            objectOutputStream.writeUTF(this.mRelationship);
            objectOutputStream.writeDouble(this.mDistance);
            objectOutputStream.writeUTF(this.mIncrement);
            objectOutputStream.writeInt(this.mMaxAssoction);
            objectOutputStream.writeUTF(this.mProjection);
            objectOutputStream.writeBoolean(this.mRenderUnmatched);
            return true;
        }
    }

    class MapTableModel
    extends AbstractTableModel {
        private Vector<MapSpecItem> mMapData = new Vector();
        private String[] COLUMN_NAMES;

        public MapTableModel(String[] stringArray) {
            this.COLUMN_NAMES = stringArray;
        }

        @Override
        public int getRowCount() {
            return this.mMapData.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public MapSpecItem getValue(int n) {
            if (n < 0 || n >= this.mMapData.size()) {
                return null;
            }
            MapSpecItem mapSpecItem = this.mMapData.get(n);
            return mapSpecItem;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MapSpecItem mapSpecItem = this.mMapData.get(n);
            switch (n2) {
                case 0: {
                    return mapSpecItem.getMapFileName();
                }
                case 1: {
                    return mapSpecItem.getRelDisplayValue();
                }
            }
            return null;
        }

        public void setData(Vector<MapSpecItem> vector) {
            this.mMapData = vector;
            this.fireTableDataChanged();
        }

        public void insertRow(int n, MapSpecItem mapSpecItem) {
            this.mMapData.insertElementAt(mapSpecItem, n);
            this.fireTableDataChanged();
        }

        public void removeRow(int n) {
            this.mMapData.remove(n);
            this.fireTableDataChanged();
        }

        public void removeAll() {
            this.mMapData.clear();
            this.fireTableDataChanged();
        }

        public void addRow(MapSpecItem mapSpecItem) {
            this.mMapData.add(mapSpecItem);
            this.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null) {
                return;
            }
            MapSpecItem mapSpecItem = this.mMapData.get(n);
            if (n2 == 0) {
                mapSpecItem.setMapFileName(object.toString());
            } else if (n2 == 1) {
                mapSpecItem.setRelDisplayValue(object.toString());
                this.fireTableDataChanged();
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Vector<MapSpecItem> getTableData() {
            return this.mMapData;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return super.getColumnClass(n);
        }
    }
}

