/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ASMapsError;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.STEM.AddContextDataSubDlg;
import com.spss.java_client.ui.dialogs.STEM.ComboBoxEditor;
import com.spss.java_client.ui.dialogs.STEM.ContextDataItem;
import com.spss.java_client.ui.dialogs.STEM.CoordinateSystemUtil;
import com.spss.java_client.ui.dialogs.STEM.DataMapAssociationSubDlg;
import com.spss.java_client.ui.dialogs.STEM.STEMStepOne;
import com.spss.java_client.ui.dialogs.STEM.STEMUtil;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.STEM.UnEditableCellTextRenderer;
import com.spss.java_client.ui.dialogs.STEM.ValidateKeysSubDlg;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.direct_marketing.AbstractDialogStateWizardPage;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.Pair;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class STEMDataSourcePage
extends AbstractDialogStateWizardPage
implements ActionListener {
    private static String sGSAREventID = "Event Data";
    private String sMapAssocDefault;
    private String mTextInfoCommon;
    private FocusableTextArea mCommonInfoText;
    private String mContexInfoStrGSAR;
    private String mContextInfoStrSTP;
    private FocusableTextArea mContextInfoTextArea;
    private JButton mContextAddSourceButton;
    private JButton mContextValidateButton;
    private JButton mContextAssociateButton;
    private JButton mContextRemoveButton;
    private JLabel mContextSourceTableLabel;
    private JTable mContextSourceTable;
    private ContextDataModel mContextSourceTableModel;
    private Vector<ContextDataItem> mDeletedMapDataList;
    private SpssVariableNameCellEditor mSourceIDCellEditor;
    private String mEventInfoStrGSAR;
    private String mEventInfoStrSTP;
    private FocusableTextArea mEventInfoTextArea;
    private JButton mEventAddSourceButton;
    private JButton mEventValidateButton;
    private JButton mEventAssociateButton;
    private JButton mEventRemoveButton;
    private JLabel mEventSourceTableLabel;
    private JTable mEventSourceTable;
    private ContextDataModel mEventSourceTableModel;
    private String mCurrentActiveDataFile;
    boolean mHasMap;
    private boolean mIsOnBack = false;
    private boolean mIsGSAR;
    private String[] mRoleString;
    private String mAssocKeyStr;
    private String mAssocDataKeyStr;
    private String mAssocMapKeyStr;
    private DialogFocusTraversalPolicy mPolicy;
    Border mEmptyBorder = BorderFactory.createEmptyBorder();
    Border mHighLightBorder = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
    static LocallyUniqueId.LocallyUniqueIDGenerator sIdGenerator = new LocallyUniqueId.LocallyUniqueIDGenerator(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
    private ISpssVariable mTimeFieldVar = null;
    private String mSTPEventSourceId;
    private boolean mKDEVarTarget = false;
    private Boolean mUseExisting = null;
    private String mDataNameSyntax;
    private boolean mIsPageModified;
    private boolean mKeepSettings = false;
    private boolean mFromDataSource;

    public STEMDataSourcePage(BaseWizardDialog baseWizardDialog) {
        super("STEMDataSourcePage", baseWizardDialog.getResString("IDS_STEM_STEP_ONE_TITLE"), baseWizardDialog, true);
        this.mDeletedMapDataList = new Vector();
    }

    @Override
    protected void aboutToShowPanel() {
        int n;
        super.aboutToShowPanel();
        this.mIsPageModified = false;
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
        ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().setFromDataSource(false);
        this.mHasMap = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().hasMap();
        this.mIsGSAR = ((STEMWizardDlg)this.mWizardDialog).getStepOnePage().isGSARSelected();
        if (this.mIsGSAR) {
            this.mContextInfoTextArea.setText(this.mContexInfoStrGSAR);
            this.mEventInfoTextArea.setText(this.mEventInfoStrGSAR);
            this.mRoleString = this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_ARRARY");
            this.mEventSourceTableLabel.setText(this.mWizardDialog.getResString("IDS_STEM_FIELDS_EVNET_SOURCE_TABLE_LABEL"));
        } else {
            this.mContextInfoTextArea.setText(this.mContextInfoStrSTP);
            this.mEventInfoTextArea.setText(this.mEventInfoStrSTP);
            this.mRoleString = this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_STP_ARRARY");
            this.mEventSourceTableLabel.setText(this.mWizardDialog.getResString("IDS_STEM_FIELDS_POINT_DENSITY_SOURCE_TABLE_LABEL"));
        }
        boolean bl = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().fromMapSpec();
        if (this.mKeepSettings) {
            this.setNextFinishButtonState();
            return;
        }
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mCurrentActiveDataFile = iSpssDataSrc.getFileSpec();
        IVariableSet iVariableSet = iSpssDataSrc.getALLVARIABLES();
        boolean bl2 = iVariableSet == null || iVariableSet.getVariableNames().size() == 0;
        int n2 = this.mCurrentActiveDataFile.lastIndexOf(File.separatorChar);
        String string = iSpssDataSrc.getDatasetName();
        String string2 = this.sMapAssocDefault;
        if (!this.mHasMap && this.mIsGSAR) {
            string2 = "";
        }
        String string3 = this.mCurrentActiveDataFile.substring(n2 + 1);
        this.mDataNameSyntax = "";
        String string4 = this.mRoleString[0];
        if (!this.mHasMap && !this.mIsGSAR) {
            string4 = this.mRoleString[1];
        }
        if (this.mIsOnBack) {
            this.checkEmptyAssoc();
        }
        if ((n = this.mContextSourceTable.getRowCount()) == 0) {
            this.mContextAddSourceButton.setEnabled(true);
            this.mContextAssociateButton.setEnabled(false);
            this.mContextValidateButton.setEnabled(false);
            this.mContextRemoveButton.setEnabled(false);
        }
        if ((n = this.mEventSourceTable.getRowCount()) == 0) {
            this.mEventAddSourceButton.setEnabled(true);
            this.mEventAssociateButton.setEnabled(false);
            this.mEventValidateButton.setEnabled(false);
            this.mEventRemoveButton.setEnabled(false);
        }
        this.setNextFinishButtonState();
        if (!this.mHasMap) {
            if (this.mIsGSAR) {
                this.mContextSourceTableModel.removeAll();
                this.mContextAddSourceButton.setEnabled(false);
                this.mContextAssociateButton.setEnabled(false);
                this.mContextValidateButton.setEnabled(false);
                this.mContextRemoveButton.setEnabled(false);
            } else {
                this.mEventSourceTableModel.removeAll();
                this.mEventAddSourceButton.setEnabled(false);
                this.mEventAssociateButton.setEnabled(false);
                this.mEventValidateButton.setEnabled(false);
                this.mEventRemoveButton.setEnabled(false);
            }
        } else if (this.mEventSourceTable.getRowCount() > 0 || this.mContextSourceTable.getRowCount() > 0) {
            this.enableButtonControls(this.mContextAddSourceButton, -1);
        }
        this.mKeepSettings = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.mContextSourceTable.getSelectedRow();
        if (object == this.mContextValidateButton || object == this.mEventValidateButton) {
            n = this.mContextSourceTable.getSelectedRow();
            if (object == this.mEventValidateButton) {
                n = this.mEventSourceTable.getSelectedRow();
            }
            if (n < 0) {
                return;
            }
            ContextDataItem contextDataItem = this.mContextSourceTableModel.getValue(n);
            if (object == this.mEventValidateButton) {
                contextDataItem = this.mEventSourceTableModel.getValue(n);
            }
            Vector<Vector<String>> vector = contextDataItem.getUnMatchedDataValues();
            if (contextDataItem.getDataType() == ContextDataItem.DataType.MAP) {
                return;
            }
            if (vector.size() == 0) {
                this.callBackend(contextDataItem);
            } else {
                String string3;
                Vector<String> vector2 = contextDataItem.getSelectedDataKeys();
                String string2 = "";
                int n2 = 0;
                for (String string3 : vector2) {
                    string2 = string2 + "key";
                    if (n2 >= vector2.size() - 1) continue;
                    string2 = string2 + "/";
                }
                Vector<String> vector3 = contextDataItem.getSelectedDataKeys();
                string3 = "";
                n2 = 0;
                Object object2 = vector3.iterator();
                while (object2.hasNext()) {
                    String string4 = (String)object2.next();
                    string3 = string3 + "key";
                    if (n2 >= vector3.size() - 1) continue;
                    string3 = string3 + "/";
                }
                object2 = new ValidateKeysSubDlg(this.mWizardDialog, contextDataItem, contextDataItem.getNumMatchedValues(), contextDataItem.getSourceId(), string2, contextDataItem.getMapAssocId(), string3);
                object2.setVisible(true);
            }
            this.mIsPageModified = true;
        } else if (object == this.mContextRemoveButton || object == this.mEventRemoveButton) {
            JButton jButton;
            if (object == this.mContextRemoveButton) {
                this.deleteOneRow(this.mContextSourceTable, this.mContextSourceTableModel, -1);
                jButton = this.mContextRemoveButton;
            } else {
                this.deleteOneRow(this.mEventSourceTable, this.mEventSourceTableModel, -1);
                jButton = this.mEventRemoveButton;
            }
            this.enableButtonControls(jButton, -1);
            this.setNextFinishButtonState();
            this.mIsPageModified = true;
        } else if (object == this.mContextAddSourceButton || object == this.mEventAddSourceButton) {
            String string = this.mRoleString[1];
            boolean bl = true;
            if (object == this.mEventAddSourceButton) {
                string = this.mRoleString[0];
                bl = false;
            }
            Vector<ContextDataItem> vector = this.getUnusedMapDataFiles();
            AddContextDataSubDlg addContextDataSubDlg = new AddContextDataSubDlg(this.mWizardDialog, vector, bl, string);
            addContextDataSubDlg.setVisible(true);
            if (addContextDataSubDlg.continuePressed()) {
                JButton jButton;
                ContextDataItem contextDataItem = addContextDataSubDlg.getSelectedFile();
                String string5 = this.sMapAssocDefault;
                boolean bl2 = false;
                if (!this.mHasMap) {
                    if (this.mIsGSAR) {
                        string5 = "";
                        bl2 = true;
                    }
                } else if (contextDataItem.getDataType() == ContextDataItem.DataType.MAP) {
                    bl2 = true;
                    string5 = this.mAssocKeyStr + ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().sDefaultContextKeyName;
                    contextDataItem.setAssocType(ContextDataItem.AssocType.KEYS);
                }
                contextDataItem.setDisplayMapString(string5);
                contextDataItem.setAssocSetStatus(bl2);
                int n3 = -1;
                if (object == this.mContextAddSourceButton) {
                    this.addOneRow(contextDataItem, n3, this.mContextSourceTable, this.mContextSourceTableModel);
                    n = this.mContextSourceTable.getRowCount() - 1;
                    if (addContextDataSubDlg.AssocatePressed()) {
                        this.processAssocateAction(contextDataItem, this.mContextSourceTableModel, n, addContextDataSubDlg.getDisplayPrj());
                    }
                    jButton = this.mContextAddSourceButton;
                } else {
                    this.addOneRow(contextDataItem, n3, this.mEventSourceTable, this.mEventSourceTableModel);
                    n = this.mEventSourceTable.getRowCount() - 1;
                    if (addContextDataSubDlg.AssocatePressed()) {
                        this.processAssocateAction(contextDataItem, this.mEventSourceTableModel, n, addContextDataSubDlg.getDisplayPrj());
                    }
                    jButton = this.mEventAddSourceButton;
                }
                this.enableButtonControls(jButton, n);
                this.setNextFinishButtonState();
                this.mIsPageModified = true;
            }
        } else if (object == this.mContextAssociateButton || object == this.mEventAssociateButton) {
            if (object == this.mContextAssociateButton && n >= 0) {
                this.runAssociateSub(n, this.mContextSourceTableModel);
                this.mIsPageModified = true;
            } else if (object == this.mEventAssociateButton && (n = this.mEventSourceTable.getSelectedRow()) >= 0) {
                this.runAssociateSub(n, this.mEventSourceTableModel);
                this.mIsPageModified = true;
            }
        }
        if (object == this.mContextAssociateButton || object == this.mContextAddSourceButton || object == this.mContextValidateButton) {
            if (n >= 0) {
                this.mContextSourceTable.requestFocusInWindow();
                this.mContextSourceTable.setRowSelectionInterval(n, n);
                this.mContextSourceTable.setColumnSelectionInterval(3, 3);
            }
        } else if ((object == this.mEventAssociateButton || object == this.mEventAddSourceButton || object == this.mEventValidateButton) && n >= 0 && this.mEventSourceTable.getRowCount() > 0) {
            this.mEventSourceTable.requestFocusInWindow();
            this.mEventSourceTable.setRowSelectionInterval(n, n);
            this.mEventSourceTable.setColumnSelectionInterval(3, 3);
        }
    }

    @Override
    protected void loadDialogState() {
    }

    @Override
    protected void saveDialogState() {
    }

    void reset() {
        this.mContextSourceTableModel.removeAll();
        this.mEventSourceTableModel.removeAll();
        this.mDeletedMapDataList.removeAllElements();
        this.mIsPageModified = true;
        this.setDefault();
        ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().setFromDataSource(false);
    }

    void setKeepSettings(boolean bl) {
        this.mKeepSettings = bl;
    }

    @Override
    public void init() {
        JSeparator jSeparator;
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        if (jPanel.getComponentCount() > 0) {
            DialogUtil.normalizeLabelWidths(jPanel);
            DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 2, 1, n, insets);
            gridBagConstraints.fill = 2;
            insets.top = n2;
            jSeparator = new JSeparator();
            DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 2, 1, n, insets);
        }
        FontMetrics fontMetrics = this.mContextSourceTable.getFontMetrics(this.mContextSourceTable.getFont());
        int n3 = fontMetrics.charWidth('_');
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2, n2 * 2, n2);
        this.mCommonInfoText.setPreferredSize(new Dimension(100 * n3, 100));
        this.mCommonInfoText.setMinimumSize(new Dimension(100 * n3, 100));
        DialogUtil.addUsingGBL(this.mWizardPage, this.mCommonInfoText, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mContextSourceTableLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Dimension dimension = this.mContextValidateButton.getPreferredSize();
        this.mContextAssociateButton.setPreferredSize(dimension);
        this.mContextAddSourceButton.setPreferredSize(dimension);
        this.mContextRemoveButton.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, PanelFactory.getBasicPanel(new JComponent[]{this.mContextAddSourceButton, this.mContextRemoveButton, this.mContextAssociateButton, this.mContextValidateButton}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 1, 1, 1, 1, 26, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mContextSourceTable, 20, 31);
        jScrollPane.setMinimumSize(new Dimension(n3 * 100, 100));
        jScrollPane.setPreferredSize(new Dimension(n3 * 100, 100));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, n2, 1, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, jScrollPane, gridBagConstraints, 0, 2, 2, 1, n, insets);
        insets.set(0, n2 * 3, n2 * 4, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mWizardPage, this.mContextInfoTextArea, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mEventSourceTableLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mEventAssociateButton.setPreferredSize(dimension);
        this.mEventAddSourceButton.setPreferredSize(dimension);
        this.mEventRemoveButton.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, PanelFactory.getBasicPanel(new JComponent[]{this.mEventAddSourceButton, this.mEventRemoveButton, this.mEventAssociateButton, this.mEventValidateButton}, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 1, 4, 1, 1, 26, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mEventSourceTable, 20, 31);
        jScrollPane2.setMinimumSize(new Dimension(n3 * 100, 100));
        jScrollPane2.setPreferredSize(new Dimension(n3 * 100, 100));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(1, n2, 1, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, jScrollPane2, gridBagConstraints, 0, 5, 2, 1, n, insets);
        insets.set(0, n2 * 3, 2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mWizardPage, this.mEventInfoTextArea, gridBagConstraints, 0, 6, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        insets.top = n2;
        jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 7, 2, 1, 20, insets);
        this.setDefault();
        this.setTabTraversalOrder();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_stem_data_sources";
    }

    @Override
    public boolean validate() {
        int n;
        boolean bl = true;
        if (!this.mSourceIDCellEditor.isValid()) {
            return false;
        }
        if (this.mIsGSAR && this.mHasMap) {
            bl = this.areSameAssoctionForEvent();
        }
        if (!bl) {
            return bl;
        }
        if (!this.mIsGSAR) {
            bl = this.enoughFields();
        }
        if (!bl) {
            return bl;
        }
        if (this.mHasMap && !this.mIsGSAR && (n = this.mEventSourceTableModel.getRowCount()) > 0) {
            ContextDataItem contextDataItem = this.mContextSourceTableModel.getValue(0);
            Vector<ISpssVariable> vector = contextDataItem.getSpssVars();
            if (vector.size() == 0) {
                vector = this.getSpssVarFromData(contextDataItem);
            }
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, ISpssVariable> hashtable = new Hashtable<String, ISpssVariable>();
            boolean bl2 = false;
            for (ISpssVariable iSpssVariable : vector) {
                if (iSpssVariable.getType() != 0) continue;
                vector2.add(iSpssVariable.getName());
                hashtable.put(iSpssVariable.getName(), iSpssVariable);
            }
            this.mUseExisting = new Boolean(false);
            this.mTimeFieldVar = null;
            this.mKDEVarTarget = true;
            this.mSTPEventSourceId = contextDataItem.getSourceId();
        }
        return true;
    }

    private boolean areSameAssoctionForEvent() {
        boolean bl = true;
        boolean bl2 = true;
        ContextDataItem contextDataItem = null;
        ContextDataItem.AssocType assocType = ContextDataItem.AssocType.UNKNOWMN;
        STEMUtil.GeoType geoType = STEMUtil.GeoType.UNKNOWN;
        for (int i = 0; i < this.mEventSourceTableModel.getRowCount(); ++i) {
            contextDataItem = this.mEventSourceTableModel.getValue(i);
            if (assocType == ContextDataItem.AssocType.UNKNOWMN) {
                assocType = contextDataItem.getAssocType();
            } else if (assocType != contextDataItem.getAssocType()) {
                bl = false;
                break;
            }
            if (assocType != ContextDataItem.AssocType.KEYS) continue;
            STEMUtil.GeoType geoType2 = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().getMapType(contextDataItem.getMapAssocId());
            if (geoType == STEMUtil.GeoType.UNKNOWN) {
                geoType = geoType2;
                continue;
            }
            if (geoType2 == geoType) continue;
            bl2 = false;
        }
        if (!bl) {
            String string = this.mWizardDialog.getResString("IDS_STEM_CONTEXT_DATA_GSAR_ASSOC_NOT_SAME");
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString());
            return false;
        }
        if (!bl2) {
            String string = this.mWizardDialog.getResString("IDS_STEM_CONTEXT_DATA_GSAR_MAP_GEO_TYPE_NOT_SAME");
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString());
            return false;
        }
        return bl;
    }

    private boolean enoughFields() {
        int n;
        int n2;
        boolean bl = true;
        ContextDataItem contextDataItem = null;
        for (n2 = 0; n2 < this.mContextSourceTableModel.getRowCount(); ++n2) {
            contextDataItem = this.mContextSourceTableModel.getValue(n2);
            n = this.availableContVar(contextDataItem, false);
            if (n == -1 || n != 0) continue;
            bl = false;
            break;
        }
        for (n2 = 0; n2 < this.mEventSourceTableModel.getRowCount() && bl; ++n2) {
            contextDataItem = this.mEventSourceTableModel.getValue(n2);
            n = this.availableContVar(contextDataItem, true);
            if (n == -1 || n != 0) continue;
            bl = false;
            break;
        }
        if (!bl) {
            String string = this.mWizardDialog.getResString("IDS_STEM_CONTEXT_DATA_STP_TOO_FEW_CONT_FIELDS");
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), string, VersionInfo.getAppVersionString());
        }
        return bl;
    }

    private int availableContVar(ContextDataItem contextDataItem, boolean bl) {
        int n = 0;
        Vector<ISpssVariable> vector = contextDataItem.getSpssVars();
        if (vector == null || vector.size() == 0) {
            vector = this.getSpssVarFromData(contextDataItem);
        }
        if (vector == null) {
            return n;
        }
        for (ISpssVariable iSpssVariable : vector) {
            if (iSpssVariable.getType() != 0) continue;
            String string = iSpssVariable.getName();
            if (bl) {
                if (string.equals(contextDataItem.getCoordinateXVar()) || string.equals(contextDataItem.getCoordinateYVar()) || string.equals(contextDataItem.getCoordinateZVar())) continue;
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }

    private void enableButtonControls(JButton jButton, int n) {
        int n2 = this.mContextSourceTableModel.getRowCount();
        int n3 = this.mEventSourceTableModel.getRowCount();
        if (!this.mHasMap) {
            if (this.mIsGSAR) {
                if (n3 == 1) {
                    this.mEventAddSourceButton.setEnabled(false);
                    if (this.mEventSourceTable.getSelectedRow() >= 0) {
                        this.mEventRemoveButton.setEnabled(true);
                    } else {
                        this.mEventRemoveButton.setEnabled(false);
                    }
                } else {
                    this.mEventAddSourceButton.setEnabled(true);
                }
            } else {
                if (n2 == 1) {
                    this.mContextAddSourceButton.setEnabled(false);
                    if (this.mContextSourceTable.getSelectedRow() >= 0) {
                        this.mContextRemoveButton.setEnabled(true);
                    } else {
                        this.mContextRemoveButton.setEnabled(false);
                    }
                } else {
                    this.mContextAddSourceButton.setEnabled(true);
                }
                if (jButton == this.mContextAddSourceButton && (n >= 0 || this.mContextSourceTable.getSelectedRow() >= 0)) {
                    this.mContextAssociateButton.setEnabled(true);
                    this.mContextRemoveButton.setEnabled(true);
                }
            }
        } else {
            if (!this.mIsGSAR) {
                if (n2 == 1) {
                    this.mContextAddSourceButton.setEnabled(false);
                    if (this.mContextSourceTable.getSelectedRow() >= 0) {
                        this.mContextRemoveButton.setEnabled(true);
                    } else {
                        this.mContextRemoveButton.setEnabled(false);
                    }
                } else {
                    this.mContextAddSourceButton.setEnabled(true);
                }
                if (n3 == 1) {
                    this.mEventAddSourceButton.setEnabled(false);
                    if (this.mEventSourceTable.getSelectedRow() >= 0) {
                        this.mEventRemoveButton.setEnabled(true);
                    } else {
                        this.mEventRemoveButton.setEnabled(false);
                    }
                } else {
                    this.mEventAddSourceButton.setEnabled(true);
                }
            } else {
                this.mEventAddSourceButton.setEnabled(true);
                this.mContextAddSourceButton.setEnabled(true);
            }
            if (jButton == this.mContextAddSourceButton && (n >= 0 || this.mContextSourceTable.getSelectedRow() >= 0)) {
                this.mContextAssociateButton.setEnabled(true);
                this.mContextRemoveButton.setEnabled(true);
                this.mEventRemoveButton.setEnabled(false);
                this.mEventAssociateButton.setEnabled(false);
                this.mEventValidateButton.setEnabled(false);
            } else if (jButton == this.mEventAddSourceButton && (n >= 0 || this.mEventSourceTable.getSelectedRow() >= 0)) {
                this.mEventAssociateButton.setEnabled(true);
                this.mEventRemoveButton.setEnabled(true);
                this.mContextAssociateButton.setEnabled(false);
                this.mContextRemoveButton.setEnabled(false);
                this.mContextValidateButton.setEnabled(false);
            }
        }
    }

    public boolean enableNextButton() {
        ContextDataItem contextDataItem;
        int n;
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        this.mContextAddSourceButton.setEnabled(true);
        boolean bl2 = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().hasMap();
        int n4 = this.mContextSourceTable.getRowCount();
        if (n4 == 0) {
            this.mContextAssociateButton.setEnabled(false);
            return false;
        }
        if (bl2 || !this.mIsGSAR) {
            if (n4 < 2 && this.mIsGSAR) {
                bl = false;
            }
            if (bl) {
                for (n = 0; n < n4; ++n) {
                    contextDataItem = this.mContextSourceTableModel.getValue(n);
                    String string = contextDataItem.getDisplayMapString();
                    if (!(string.length() != 0 && !string.equals(this.sMapAssocDefault) || !bl2 && this.mIsGSAR)) {
                        bl = false;
                    }
                    if (!contextDataItem.isRoleContext()) {
                        ++n2;
                        continue;
                    }
                    ++n3;
                }
                if (bl) {
                    bl = this.mIsGSAR ? n2 > 0 && n3 > 0 : n3 == 1 && n2 <= 1;
                }
            }
        } else {
            boolean bl3 = bl = this.mContextSourceTable.getRowCount() > 0;
        }
        if (!this.mIsGSAR) {
            if (!this.mHasMap && this.mContextSourceTable.getRowCount() > 0) {
                this.mContextAddSourceButton.setEnabled(false);
                this.mContextAssociateButton.setEnabled(true);
            } else if (n3 == 1 && n2 == 1) {
                this.mContextAddSourceButton.setEnabled(false);
            }
        } else if (!this.mHasMap && n4 == 1) {
            this.mContextAddSourceButton.setEnabled(false);
        }
        if (bl) {
            for (n = 0; n < n4 && bl; ++n) {
                contextDataItem = this.mContextSourceTableModel.getValue(n);
                if (contextDataItem.getSourceId().trim().length() != 0) continue;
                return false;
            }
        }
        return bl;
    }

    public boolean canEnableNextButton() {
        boolean bl = true;
        int n = this.mEventSourceTableModel.getRowCount();
        int n2 = this.mContextSourceTable.getRowCount();
        if (n == 0 && n2 == 0) {
            return false;
        }
        boolean bl2 = false;
        if (this.mHasMap) {
            if (this.mIsGSAR ? n == 0 || n2 == 0 : n2 == 0) {
                return false;
            }
            return this.isTableValid(this.mEventSourceTableModel, true) && this.isTableValid(this.mContextSourceTableModel, true);
        }
        if (this.mIsGSAR) {
            if (n == 0) {
                return false;
            }
            return this.isTableValid(this.mEventSourceTableModel, false);
        }
        if (n2 == 0) {
            return false;
        }
        return this.isTableValid(this.mContextSourceTableModel, true);
    }

    private boolean isTableValid(ContextDataModel contextDataModel, boolean bl) {
        boolean bl2 = true;
        int n = contextDataModel.getRowCount();
        for (int i = 0; i < n && bl2; ++i) {
            ContextDataItem contextDataItem = contextDataModel.getValue(i);
            String string = contextDataItem.getDisplayMapString();
            if (contextDataItem.getSourceId().length() != 0 && (!bl || string.length() != 0 && !string.equals(this.sMapAssocDefault))) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    @Override
    public String getNextPage() {
        STEMStepOne sTEMStepOne = ((STEMWizardDlg)this.mWizardDialog).getStepOnePage();
        if (sTEMStepOne.isSTPSelected()) {
            ((STEMWizardDlg)this.mWizardDialog).getSTPDefineRolePage().setKeepTarget(!this.mIsPageModified);
            return "STPDefineRolePage";
        }
        if (this.countEventData() > 1) {
            return "MergeEventDataPage";
        }
        ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().setKeepTarget(!this.mIsPageModified);
        return "GSARDefineRolePage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean validateOnBack() {
        this.mIsOnBack = true;
        ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().setKeepControlSettings(true);
        ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().setFromDataSource(true);
        return true;
    }

    private void enableValidate(int n, ContextDataModel contextDataModel) {
        if (contextDataModel == this.mContextSourceTableModel) {
            if (n < 0) {
                this.mContextValidateButton.setEnabled(false);
                return;
            }
            ContextDataItem contextDataItem = contextDataModel.getValue(n);
            Vector<Vector<String>> vector = contextDataItem.getUnMatchedDataValues();
            Vector<String> vector2 = contextDataItem.getSelectedDataKeys();
            Vector<String> vector3 = contextDataItem.getSelectedMapKeys();
            if (contextDataItem.getDataType() != ContextDataItem.DataType.MAP && vector2.size() > 0 && vector3.size() > 0) {
                this.mContextValidateButton.setEnabled(true);
            } else {
                this.mContextValidateButton.setEnabled(false);
            }
            this.mContextAssociateButton.setEnabled(true);
        } else {
            if (n < 0) {
                this.mEventValidateButton.setEnabled(false);
                return;
            }
            ContextDataItem contextDataItem = contextDataModel.getValue(n);
            Vector<Vector<String>> vector = contextDataItem.getUnMatchedDataValues();
            Vector<String> vector4 = contextDataItem.getSelectedDataKeys();
            Vector<String> vector5 = contextDataItem.getSelectedMapKeys();
            if (contextDataItem.getDataType() != ContextDataItem.DataType.MAP && vector4.size() > 0 && vector5.size() > 0) {
                this.mEventValidateButton.setEnabled(true);
            } else {
                this.mEventValidateButton.setEnabled(false);
            }
            this.mEventAssociateButton.setEnabled(true);
        }
    }

    private void setNextFinishButtonState() {
        this.mWizardDialog.enableNext(this.canEnableNextButton());
    }

    void updateTableFromMap(String string, String string2, boolean bl, Vector<ISpssVariable> vector, String string3) {
        if (bl) {
            this.mHasMap = true;
            this.addOneRow(string2.substring(0, string2.length() - 4), string, string2, true, true, string3, ContextDataItem.DataType.MAP, vector, "", -1);
        } else {
            int n;
            int n2 = -1;
            boolean bl2 = false;
            int n3 = this.mContextSourceTableModel.getRowCount();
            for (n = 0; n < n3; ++n) {
                if (!this.mContextSourceTableModel.getValueAt(n, 0).toString().equals(string2)) continue;
                n2 = n;
                break;
            }
            if (n2 >= 0) {
                this.deleteOneRow(this.mContextSourceTable, this.mContextSourceTableModel, n2);
                bl2 = true;
            }
            if (!bl2) {
                n3 = this.mEventSourceTableModel.getRowCount();
                for (n = 0; n < n3; ++n) {
                    if (!this.mEventSourceTableModel.getValueAt(n, 0).toString().equals(string2)) continue;
                    n2 = n;
                    break;
                }
            }
            if (n2 >= 0) {
                this.deleteOneRow(this.mEventSourceTable, this.mEventSourceTableModel, n2);
                bl2 = true;
            }
            if (!bl2) {
                for (n = 0; n < this.mDeletedMapDataList.size(); ++n) {
                    if (!string2.equals(this.mDeletedMapDataList.get(n).getContextDataSourceName())) continue;
                    n2 = n;
                    break;
                }
            }
            if (n2 >= 0 && n2 < this.mDeletedMapDataList.size()) {
                this.mDeletedMapDataList.remove(n2);
            }
        }
    }

    boolean usingExisingDataSTP() {
        return !this.mIsGSAR && this.mTimeFieldVar != null;
    }

    boolean isKDETarget() {
        return this.mKDEVarTarget;
    }

    ISpssVariable getTimeField(Vector<String> vector) {
        if (vector != null) {
            vector.add(0, this.mSTPEventSourceId);
        }
        return this.mTimeFieldVar;
    }

    Vector<String> getAllContextDataID() {
        int n = this.mContextSourceTableModel.getRowCount();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            ContextDataItem contextDataItem = this.mContextSourceTableModel.getValue(i);
            vector.add(contextDataItem.getSourceId());
        }
        return vector;
    }

    Vector<String> getAllEventDataID() {
        int n = this.mEventSourceTableModel.getRowCount();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            ContextDataItem contextDataItem = this.mEventSourceTableModel.getValue(i);
            vector.add(contextDataItem.getSourceId());
        }
        return vector;
    }

    String getCurrentActiveDataFile() {
        return this.mCurrentActiveDataFile;
    }

    int countEventData() {
        return this.mEventSourceTableModel.getRowCount();
    }

    boolean isOpenDatasetUsedInSTP(LocallyUniqueId locallyUniqueId) {
        ContextDataItem contextDataItem;
        int n;
        boolean bl = false;
        int n2 = this.mContextSourceTableModel.getRowCount();
        for (n = 0; n < n2; ++n) {
            contextDataItem = this.mContextSourceTableModel.getValue(n);
            if (contextDataItem.getDataType() != ContextDataItem.DataType.DATASET || !locallyUniqueId.equals((Object)contextDataItem.getDatasetUID())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            n2 = this.mEventSourceTableModel.getRowCount();
            for (n = 0; n < n2; ++n) {
                contextDataItem = this.mEventSourceTableModel.getValue(n);
                if (contextDataItem.getDataType() != ContextDataItem.DataType.DATASET || !locallyUniqueId.equals((Object)contextDataItem.getDatasetUID())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    Hashtable<String, Vector<ISpssVariable>> getAllContextDataFields() {
        int n = this.mContextSourceTableModel.getRowCount();
        Hashtable<String, Vector<ISpssVariable>> hashtable = new Hashtable<String, Vector<ISpssVariable>>();
        for (int i = 0; i < n; ++i) {
            ContextDataItem contextDataItem = this.mContextSourceTableModel.getValue(i);
            Vector<ISpssVariable> vector = this.getSpssVarFromData(contextDataItem, false);
            if (vector == null) continue;
            hashtable.put(contextDataItem.getSourceId(), vector);
        }
        return hashtable;
    }

    Hashtable<String, Vector<ISpssVariable>> getAllEventFields() {
        int n = this.mEventSourceTableModel.getRowCount();
        Hashtable<String, Vector<ISpssVariable>> hashtable = new Hashtable<String, Vector<ISpssVariable>>();
        for (int i = 0; i < n; ++i) {
            ContextDataItem contextDataItem = this.mEventSourceTableModel.getValue(i);
            Vector<ISpssVariable> vector = this.getSpssVarFromData(contextDataItem, false);
            if (vector == null) continue;
            hashtable.put(contextDataItem.getSourceId(), vector);
        }
        return hashtable;
    }

    private Vector<ISpssVariable> getSpssVarFromData(ContextDataItem contextDataItem) {
        return this.getSpssVarFromData(contextDataItem, true);
    }

    private Vector<ISpssVariable> getSpssVarFromData(ContextDataItem contextDataItem, boolean bl) {
        String string;
        Object object;
        String string2;
        Vector<VariableBlock> vector;
        Object object2;
        Vector<Object> vector2 = contextDataItem.getSpssVars();
        if (vector2.size() == 0) {
            object2 = contextDataItem.getDataType();
            vector = null;
            if (object2 == ContextDataItem.DataType.MAP) {
                vector = contextDataItem.getVarInfoFromdbf();
            } else if (object2 == ContextDataItem.DataType.FILE && ((vector = contextDataItem.getVarInfoFromdbf()) == null || vector.size() == 0)) {
                string2 = contextDataItem.getDataSourceFullName();
                object = DocUtil.testOpenEncryptedData(this.getParentFrame(), string2);
                boolean bl2 = ((DocUtil.EncryptionTestResults)object).isCanContinue();
                if (bl2) {
                    vector = ((DocUtil.DataEncryptionTestResults)object).getVarBlocks();
                }
            }
            if (vector != null && vector.size() > 0) {
                vector2 = new Vector();
                for (VariableBlock variableBlock : vector) {
                    SpssVariable iSpssVariable = new SpssVariable();
                    iSpssVariable.setName(variableBlock.getVarName());
                    iSpssVariable.setMeasurementLevel(variableBlock.getVarLevel());
                    iSpssVariable.setLabel(variableBlock.getVarLabel());
                    string = variableBlock.getFormatType();
                    SPSS_Format sPSS_Format = new SPSS_Format();
                    sPSS_Format.setFormatType((FormatType)string);
                    iSpssVariable.setFormat(sPSS_Format);
                    iSpssVariable.setType((short)variableBlock.getDiType());
                    iSpssVariable.setId(sIdGenerator.next());
                    vector2.add((ISpssVariable)iSpssVariable);
                }
            } else if (object2 == ContextDataItem.DataType.DATASET) {
                vector2 = this.getVarsFromDataset(contextDataItem.getDataSourceFullName(), contextDataItem.getDatasetUID());
            }
            contextDataItem.setSpssVars(vector2);
        }
        if (!bl) {
            string2 = contextDataItem.getCoordinateXVar();
            object2 = contextDataItem.getCoordinateYVar();
            vector = contextDataItem.getCoordinateYVar();
            if (string2.length() > 0) {
                object = new Vector();
                for (ISpssVariable iSpssVariable : vector2) {
                    string = iSpssVariable.getName();
                    if (string.equals(string2) || string.equals(object2) || ((String)((Object)vector)).length() > 0 && string.equals(vector)) continue;
                    ((Vector)object).add(iSpssVariable);
                }
                return object;
            }
        }
        return vector2;
    }

    private Vector<ISpssVariable> getVarsFromDataset(String string, LocallyUniqueId locallyUniqueId) {
        Vector<ISpssVariable> vector = null;
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame[] spssFrameArray2 = spssFrameArray;
        int n = spssFrameArray2.length;
        for (int i = 0; i < n; ++i) {
            SpssFrame spssFrame = spssFrameArray2[i];
            if (!spssFrame.docType().equals((Object)DocType.DE_DOC)) continue;
            File file = spssFrame.getCoreDocument().getFileSpec();
            if (file != null && file.getAbsolutePath().equals(string)) {
                iSpssDataSrc = ((DataFrame)spssFrame).getDataSource();
                break;
            }
            if (string.length() == 0 && locallyUniqueId != null && (iSpssDataSrc = ((DataFrame)spssFrame).getDataSource()).getDataSetId().equals((Object)locallyUniqueId)) break;
        }
        if (iSpssDataSrc != null) {
            vector = new Vector<ISpssVariable>();
            int n2 = iSpssDataSrc.columnCount();
            for (n = 0; n < n2; ++n) {
                vector.add(n, iSpssDataSrc.getVariable(n));
            }
        }
        return vector;
    }

    protected JFrame getParentFrame() {
        Container container = this.mWizardDialog.getParent();
        JFrame jFrame = container instanceof JFrame ? (JFrame)container : SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        return jFrame;
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
    }

    public Vector<ContextDataItem> getDataSourceList(boolean bl) {
        int n;
        Vector<ContextDataItem> vector = new Vector<ContextDataItem>();
        for (n = 0; n < this.mEventSourceTableModel.getRowCount(); ++n) {
            vector.add(this.mEventSourceTableModel.getValue(n));
        }
        if (bl) {
            for (n = 0; n < this.mContextSourceTableModel.getRowCount(); ++n) {
                vector.add(this.mContextSourceTableModel.getValue(n));
            }
        }
        return vector;
    }

    public boolean isEvent(String string) {
        return string.equals(this.mRoleString[0]);
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCommonInfoText);
        vector.add(this.mContextAddSourceButton);
        vector.add(this.mContextRemoveButton);
        vector.add(this.mContextAssociateButton);
        vector.add(this.mContextValidateButton);
        vector.add(this.mContextSourceTable);
        vector.add(this.mContextInfoTextArea);
        vector.add(this.mEventAddSourceButton);
        vector.add(this.mEventRemoveButton);
        vector.add(this.mEventAssociateButton);
        vector.add(this.mEventValidateButton);
        vector.add(this.mEventSourceTable);
        vector.add(this.mEventInfoTextArea);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        return jPanel;
    }

    private void checkEmptyAssoc() {
        int n = this.mContextSourceTableModel.getRowCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ContextDataItem contextDataItem = this.mContextSourceTableModel.getValue(i);
            String string = contextDataItem.getDisplayMapString();
            if (this.mHasMap && string.length() == 0) {
                contextDataItem.setDisplayMapString(this.sMapAssocDefault);
                this.mContextSourceTableModel.setValueAt(false, i, 3);
                this.mContextSourceTableModel.setValueAt(this.sMapAssocDefault, i, 4);
            }
            if (this.mHasMap) continue;
            contextDataItem.setDisplayMapString("");
            this.mContextSourceTableModel.setValueAt(true, i, 3);
            if (bl) continue;
            bl = contextDataItem.isRoleContext();
        }
    }

    private void setupRoleColumn() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.mRoleString);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    int n = STEMDataSourcePage.this.mContextSourceTable.getEditingRow();
                    String string = jComboBox.getSelectedItem().toString();
                    if (jComboBox.getSelectedIndex() == 2) {
                        STEMDataSourcePage.this.mContextAssociateButton.setEnabled(false);
                    } else {
                        STEMDataSourcePage.this.mContextAssociateButton.setEnabled(true);
                    }
                    if (n >= 0) {
                        ContextDataItem contextDataItem = STEMDataSourcePage.this.mContextSourceTableModel.getValue(n);
                        if (STEMDataSourcePage.this.mHasMap && !STEMDataSourcePage.this.mIsGSAR && (string.equals(STEMDataSourcePage.this.mRoleString[0]) || string.equals(STEMDataSourcePage.this.mRoleString[1]))) {
                            int n2 = STEMDataSourcePage.this.checkExistingEvent(string);
                            if (n2 >= 0 && n != n2) {
                                String string2 = String.format(ComponentState.getSPSSLocale(), STEMDataSourcePage.this.mWizardDialog.getResString("IDS_STEM_EXISTING_DATA_SOURCE_ROLE"), string, STEMDataSourcePage.this.mContextSourceTableModel.getValue(n2).getSourceId());
                                int n3 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)STEMDataSourcePage.this.mWizardDialog), string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                                if (n3 == 1) {
                                    STEMDataSourcePage.this.mContextSourceTableModel.setValueAt(string, n, 2);
                                    STEMDataSourcePage.this.mContextSourceTableModel.setValueAt(STEMDataSourcePage.this.mRoleString[2], n2, 2);
                                }
                            }
                        } else {
                            STEMDataSourcePage.this.mContextSourceTableModel.setValueAt(string, n, 2);
                        }
                        if (string.equals(STEMDataSourcePage.this.mRoleString[2]) || !STEMDataSourcePage.this.mHasMap) {
                            STEMDataSourcePage.this.mContextSourceTableModel.setValueAt(true, n, 3);
                        } else if (contextDataItem.getDisplayMapString().length() == 0 || contextDataItem.getDisplayMapString().equals(STEMDataSourcePage.this.sMapAssocDefault)) {
                            STEMDataSourcePage.this.mContextSourceTableModel.setValueAt(false, n, 3);
                        } else {
                            STEMDataSourcePage.this.mContextSourceTableModel.setValueAt(true, n, 3);
                        }
                        if (STEMDataSourcePage.this.mIsGSAR && STEMDataSourcePage.this.mHasMap) {
                            if (string.equals(STEMDataSourcePage.this.mRoleString[0])) {
                                contextDataItem.setDisplayID(sGSAREventID);
                            } else {
                                contextDataItem.setDisplayID(contextDataItem.getSourceId());
                            }
                        }
                        STEMDataSourcePage.this.setNextFinishButtonState();
                        if (STEMDataSourcePage.this.mContextSourceTable.getCellEditor() != null) {
                            STEMDataSourcePage.this.mContextSourceTable.getCellEditor().stopCellEditing();
                        }
                        STEMDataSourcePage.this.mContextSourceTable.requestFocusInWindow();
                        STEMDataSourcePage.this.mContextSourceTable.setRowSelectionInterval(n, n);
                        STEMDataSourcePage.this.mContextSourceTable.setColumnSelectionInterval(2, 2);
                    }
                }
            }
        });
        ComboBoxEditor comboBoxEditor = new ComboBoxEditor(jComboBox);
    }

    private int checkExistingEvent(String string) {
        for (int i = 0; i < this.mContextSourceTableModel.getRowCount(); ++i) {
            ContextDataItem contextDataItem = this.mContextSourceTableModel.getValue(i);
        }
        return -1;
    }

    private void initVars() {
        sGSAREventID = this.mWizardDialog.getResString("IDS_STEM_FIELDS_SOURCE_EVENT_DATA_ID");
        this.sMapAssocDefault = this.mWizardDialog.getResString("IDS_STEM_CONTEXT_DATA_MAP_ASSOC_DEFAULT");
        this.mAssocKeyStr = this.mWizardDialog.getResString("IDS_STEM_ASSOC_DISPLAY_KEY");
        String[] stringArray = this.mWizardDialog.getResStringArray("IDS_STEM_DATA_MAP_ASSOC_SUB_TABLE_HEADER");
        this.mAssocDataKeyStr = stringArray[0] + ":";
        this.mAssocMapKeyStr = stringArray[1] + ":";
        this.mTextInfoCommon = this.mWizardDialog.getResString("IDS_STEM_STEM_HELP_INFOR_TEXT");
        this.mCommonInfoText = new FocusableTextArea(this.mTextInfoCommon, null);
        this.mCommonInfoText.setRows(3);
        this.mContexInfoStrGSAR = this.mWizardDialog.getResString("IDS_STEM_GSAR_CONTEXT_INFOR_TEXT");
        this.mContextInfoStrSTP = this.mWizardDialog.getResString("IDS_STEM_STP_CONTEXT_INFOR_TEXT");
        this.mContextInfoTextArea = new FocusableTextArea(this.mContexInfoStrGSAR, null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_ADD_BUTTON_LABEL");
        this.mContextAddSourceButton = new JButton(toggleButtonAction);
        this.mContextAddSourceButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_VALIDATE_BUTTON_LABEL");
        this.mContextValidateButton = new JButton(toggleButtonAction);
        this.mContextValidateButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_ASSOCIATE_BUTTON_LABEL");
        this.mContextAssociateButton = new JButton(toggleButtonAction);
        this.mContextAssociateButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_DELETE_BUTTON_LABEL");
        this.mContextRemoveButton = new JButton(toggleButtonAction);
        this.mContextRemoveButton.addActionListener(this);
        String[] stringArray2 = this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_HEADER_ARRARY");
        this.mContextSourceTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_FIELDS_SOURCE_TABLE_LABEL");
        this.mContextSourceTableModel = new ContextDataModel(stringArray2);
        this.mContextSourceTable = new PlainTable(this.mContextSourceTableModel);
        this.mContextSourceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = STEMDataSourcePage.this.mContextSourceTable.getSelectedColumn();
                int n2 = STEMDataSourcePage.this.mContextSourceTable.getSelectedRow();
                if (n2 >= 0) {
                    STEMDataSourcePage.this.enableButtonControls(STEMDataSourcePage.this.mContextAddSourceButton, n2);
                }
                if (STEMDataSourcePage.this.mHasMap || !STEMDataSourcePage.this.mIsGSAR) {
                    if (n2 >= 0) {
                        STEMDataSourcePage.this.enableValidate(n2, STEMDataSourcePage.this.mContextSourceTableModel);
                    }
                    if (n == 3 && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && STEMDataSourcePage.this.mContextAssociateButton.isEnabled()) {
                        STEMDataSourcePage.this.runAssociateSub(n2, STEMDataSourcePage.this.mContextSourceTableModel);
                    }
                }
            }
        });
        this.mContextSourceTable.setPreferredScrollableViewportSize(new Dimension(450, 300));
        this.mContextSourceTable.setRowHeight(22);
        this.mContextSourceTable.setColumnSelectionAllowed(true);
        this.mContextSourceTable.setSelectionMode(0);
        this.mContextSourceTable.setRowSelectionAllowed(true);
        this.mContextSourceTable.getTableHeader().setReorderingAllowed(false);
        this.mContextSourceTable.getTableHeader().setResizingAllowed(true);
        this.mContextSourceTable.setGridColor(Color.darkGray);
        this.mContextSourceTable.getTableHeader().setReorderingAllowed(false);
        this.mContextSourceTableLabel.setLabelFor(this.mContextSourceTable);
        this.mContextSourceTable.getColumnModel().getColumn(0).setCellRenderer(new UnEditableCellTextRenderer());
        this.mRoleString = this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_ARRARY");
        this.mContextSourceTable.getColumnModel().getColumn(2).setCellRenderer(new StatusRenderer());
        this.mContextSourceTable.getColumnModel().getColumn(3).setCellRenderer(new UnEditableCellTextRenderer());
        TableColumn tableColumn = this.mContextSourceTable.getColumnModel().getColumn(1);
        StringTextField stringTextField = new StringTextField();
        this.mSourceIDCellEditor = new SpssVariableNameCellEditor((JTextField)((Object)stringTextField), this.mContextSourceTable);
        tableColumn.setCellEditor(this.mSourceIDCellEditor);
        STEMUtil.setupColumnWidths(this.mContextSourceTable, new double[]{0.35, 0.2, 0.05, 0.4});
        this.mEventInfoStrGSAR = this.mWizardDialog.getResString("IDS_STEM_GSAR_EVNET_INFOR_TEXT");
        this.mEventInfoStrSTP = this.mWizardDialog.getResString("IDS_STEM_STP_POINT_DENSITY_INFOR_TEXT");
        this.mEventInfoTextArea = new FocusableTextArea(this.mContexInfoStrGSAR, null);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_EVNET_ADD_BUTTON_LABEL");
        this.mEventAddSourceButton = new JButton(toggleButtonAction);
        this.mEventAddSourceButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_EVNET_VALIDATE_BUTTON_LABEL");
        this.mEventValidateButton = new JButton(toggleButtonAction);
        this.mEventValidateButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_EVNET_ASSOCIATE_BUTTON_LABEL");
        this.mEventAssociateButton = new JButton(toggleButtonAction);
        this.mEventAssociateButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_EVNET_DELETE_BUTTON_LABEL");
        this.mEventRemoveButton = new JButton(toggleButtonAction);
        this.mEventRemoveButton.addActionListener(this);
        this.mEventSourceTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_FIELDS_EVNET_SOURCE_TABLE_LABEL");
        this.mEventSourceTableModel = new ContextDataModel(stringArray2);
        this.mEventSourceTable = new PlainTable(this.mEventSourceTableModel);
        this.mEventSourceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = STEMDataSourcePage.this.mEventSourceTable.getSelectedColumn();
                int n2 = STEMDataSourcePage.this.mEventSourceTable.getSelectedRow();
                if (n2 >= 0) {
                    STEMDataSourcePage.this.enableButtonControls(STEMDataSourcePage.this.mEventAddSourceButton, n2);
                }
                if (STEMDataSourcePage.this.mHasMap) {
                    if (n2 >= 0) {
                        STEMDataSourcePage.this.enableValidate(n2, STEMDataSourcePage.this.mEventSourceTableModel);
                    }
                    if (n == 3 && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && STEMDataSourcePage.this.mEventAssociateButton.isEnabled()) {
                        STEMDataSourcePage.this.runAssociateSub(n2, STEMDataSourcePage.this.mEventSourceTableModel);
                    }
                }
            }
        });
        this.mEventSourceTable.setPreferredScrollableViewportSize(new Dimension(450, 300));
        this.mEventSourceTable.setRowHeight(22);
        this.mEventSourceTable.setColumnSelectionAllowed(true);
        this.mEventSourceTable.setSelectionMode(0);
        this.mEventSourceTable.setRowSelectionAllowed(true);
        this.mEventSourceTable.getTableHeader().setReorderingAllowed(false);
        this.mEventSourceTable.getTableHeader().setResizingAllowed(true);
        this.mEventSourceTable.setGridColor(Color.darkGray);
        this.mEventSourceTable.getTableHeader().setReorderingAllowed(false);
        this.mEventSourceTableLabel.setLabelFor(this.mEventSourceTable);
        this.mEventSourceTable.getColumnModel().getColumn(0).setCellRenderer(new UnEditableCellTextRenderer());
        this.mRoleString = this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_SOURCE_TABLE_ROLE_ARRARY");
        this.mEventSourceTable.getColumnModel().getColumn(2).setCellRenderer(new StatusRenderer());
        this.mEventSourceTable.getColumnModel().getColumn(3).setCellRenderer(new UnEditableCellTextRenderer());
        STEMUtil.setupColumnWidths(this.mEventSourceTable, new double[]{0.35, 0.2, 0.05, 0.4});
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object = tableModelEvent.getSource();
        if (tableModelEvent.getType() == 0 && object == this.mContextSourceTableModel && this.mWizardDialog.getWizardModel().getCurrentPage() == this) {
            int n = tableModelEvent.getFirstRow();
            if (this.mContextSourceTableModel.getValue(n) == null) {
                return;
            }
            String string = this.mContextSourceTableModel.getValue(n).getSourceId();
            boolean bl = this.isValidDataSourceID(n, string);
            if (string.length() > 0) {
                if (!bl) {
                    this.mWizardDialog.enableNext(false);
                    String string2 = this.mWizardDialog.getResString("IDS_STEM_CONTEXT_DATA_DUPLICATE_ID");
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string2, VersionInfo.getAppVersionString());
                    this.mContextSourceTable.setRowSelectionInterval(n, n);
                    this.mContextSourceTable.setColumnSelectionInterval(1, 1);
                } else {
                    bl = DialogUtil.checkNewVarName((Window)((Object)this.mWizardDialog), null, string);
                    if (bl) {
                        this.setNextFinishButtonState();
                    }
                }
            }
        }
    }

    private boolean isValidDataSourceID(int n, String string) {
        boolean bl = true;
        if (string.length() > 0) {
            for (int i = 0; i < this.mContextSourceTableModel.getRowCount(); ++i) {
                String string2;
                if (i == n || !string.equals(string2 = this.mContextSourceTableModel.getValue(i).getSourceId())) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void setDefault() {
        this.mContextValidateButton.setEnabled(false);
        this.mEventValidateButton.setEnabled(false);
        this.mIsOnBack = false;
        this.mIsOnBack = false;
        this.mTimeFieldVar = null;
        this.mKDEVarTarget = false;
        this.mUseExisting = null;
        this.mKeepSettings = false;
    }

    public void addOneRow(String string, String string2, String string3, boolean bl, boolean bl2, String string4, ContextDataItem.DataType dataType, Vector<ISpssVariable> vector, String string5, int n) {
        if (dataType == ContextDataItem.DataType.MAP) {
            string = string + "_1";
        }
        string = ((STEMWizardDlg)this.mWizardDialog).findUniqueId(string);
        if (string2.length() == 0) {
            string3 = string;
        }
        ContextDataItem contextDataItem = new ContextDataItem(string, string2, string3, bl, bl2, string4, dataType, string5);
        if (string2.equals(this.mCurrentActiveDataFile)) {
            contextDataItem.setDatasetUID(SpssMgr.getSpssMgr().getActiveClientDatasetId());
        }
        if (dataType == ContextDataItem.DataType.MAP) {
            if (vector != null) {
                contextDataItem.setSpssVars(vector);
            }
            if (string5.length() == 0) {
                Vector<String> vector2 = new Vector<String>();
                vector2.add(((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().sDefaultContextKeyName);
                contextDataItem.setKeyList(vector2);
                contextDataItem.setAssocType(ContextDataItem.AssocType.KEYS);
                contextDataItem.setDisplayMapString(this.mAssocKeyStr + ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().sDefaultContextKeyName);
                contextDataItem.setAssocSetStatus(true);
            }
        } else if (dataType == ContextDataItem.DataType.DATASET && !this.mHasMap && this.mIsGSAR && string5.length() == 0) {
            contextDataItem.setAssocSetStatus(true);
        }
        if (dataType == ContextDataItem.DataType.MAP) {
            this.mDeletedMapDataList.add(contextDataItem);
        }
    }

    void addOneDBFDataSource(ContextDataItem contextDataItem) {
        this.mDeletedMapDataList.add(contextDataItem);
    }

    public void addOneRow(ContextDataItem contextDataItem, int n, JTable jTable, ContextDataModel contextDataModel) {
        int n2;
        int n3 = n2 = contextDataModel.getRowCount() - 1;
        int n4 = 2;
        if (!this.mHasMap) {
            n4 = 1;
        }
        if (!this.mIsGSAR && n2 + 1 >= n4) {
            this.mContextAssociateButton.setEnabled(false);
        }
        if (n >= 0) {
            contextDataModel.insertRow(n, contextDataItem);
            n3 = n;
        } else {
            contextDataModel.addRow(contextDataItem);
            n3 = contextDataModel.getRowCount() - 1;
        }
        jTable.setModel(contextDataModel);
        jTable.setRowSelectionInterval(n3, n3);
    }

    void addOneItemFromMapSpec(ContextDataItem contextDataItem, int n) {
        if (contextDataItem.isRoleContext()) {
            this.addOneRow(contextDataItem, n, this.mContextSourceTable, this.mContextSourceTableModel);
        } else {
            this.addOneRow(contextDataItem, n, this.mEventSourceTable, this.mEventSourceTableModel);
        }
    }

    String findDataSourceName(String string) {
        ContextDataItem contextDataItem;
        int n;
        for (n = 0; n < this.mContextSourceTable.getRowCount(); ++n) {
            contextDataItem = this.mContextSourceTableModel.getValue(n);
            if (!string.equals(contextDataItem.getSourceId())) continue;
            return string + "_1";
        }
        for (n = 0; n < this.mEventSourceTable.getRowCount(); ++n) {
            contextDataItem = this.mEventSourceTableModel.getValue(n);
            if (!string.equals(contextDataItem.getSourceId())) continue;
            return string + "_1";
        }
        return string;
    }

    private void deleteOneRow(JTable jTable, ContextDataModel contextDataModel, int n) {
        int n2;
        int n3 = n2 = n >= 0 ? n : jTable.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        ContextDataItem contextDataItem = contextDataModel.getValue(n2);
        contextDataModel.removeRow(n2);
        if (n2 < jTable.getRowCount()) {
            jTable.requestFocusInWindow();
            jTable.setRowSelectionInterval(n2, n2);
            jTable.setColumnSelectionInterval(3, 3);
        } else if (n2 - 1 >= 0) {
            jTable.requestFocusInWindow();
            jTable.setRowSelectionInterval(n2 - 1, n2 - 1);
            jTable.setColumnSelectionInterval(3, 3);
        }
        if (jTable.getSelectedRowCount() == 0) {
            if (jTable == this.mContextSourceTable) {
                this.mContextRemoveButton.setEnabled(false);
                this.mContextAddSourceButton.setEnabled(true);
                this.mContextAssociateButton.setEnabled(false);
                this.mContextAddSourceButton.requestFocusInWindow();
            } else {
                this.mEventRemoveButton.setEnabled(false);
                this.mEventAddSourceButton.setEnabled(true);
                this.mEventAssociateButton.setEnabled(false);
                this.mEventAddSourceButton.requestFocusInWindow();
            }
        }
    }

    private boolean callBackend(ContextDataItem contextDataItem) {
        boolean bl = true;
        String string = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().getShpFilePath(contextDataItem.getMapAssocId());
        Vector<String> vector = contextDataItem.getSelectedMapKeys();
        String string2 = "";
        for (int i = 0; i < vector.size(); ++i) {
            string2 = string2 + vector.get(i) + ";";
        }
        LocallyUniqueId locallyUniqueId = null;
        if (contextDataItem.getDataType() == ContextDataItem.DataType.DATASET) {
            locallyUniqueId = contextDataItem.getDatasetUID();
        }
        String string3 = contextDataItem.getDataSourceFullName();
        Vector<String> vector2 = contextDataItem.getSelectedDataKeys();
        String string4 = "";
        for (int i = 0; i < vector2.size(); ++i) {
            string4 = string4 + vector2.get(i) + ";";
        }
        Vector<Vector<String>> vector3 = new Vector<Vector<String>>();
        Vector<Vector<String>> vector4 = new Vector<Vector<String>>();
        Vector vector5 = new Vector();
        ASMapsError aSMapsError = SysFileProxy.getSysFileProxy().matchShapeKeys(string, vector, locallyUniqueId, string3, vector2, 2001, vector3, vector4, vector5);
        if (aSMapsError.getHasError()) {
            String string5 = aSMapsError.getMessage();
            String string6 = aSMapsError.getExplain();
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string5 + " " + string6, VersionInfo.getAppVersionString());
            bl = false;
        } else {
            Object object;
            int n;
            if (vector3.size() > 100 && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), (String)(object = this.mWizardDialog.getResString("IDS_STEM_VALIDATE_KEYS_TOO_MANY_UNMATCHED")), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 2) {
                return false;
            }
            object = new File(string);
            contextDataItem.setUnMatchedMapValues(vector3);
            contextDataItem.setUnMatchedDataValues(vector4);
            contextDataItem.setNumMatchedValues((Integer)vector5.get(0));
            ValidateKeysSubDlg validateKeysSubDlg = new ValidateKeysSubDlg(this.mWizardDialog, contextDataItem, (Integer)vector5.get(0), contextDataItem.getSourceId(), string4, ((File)object).getName(), string2);
            validateKeysSubDlg.setVisible(true);
        }
        return bl;
    }

    private void runAssociateSub(int n, ContextDataModel contextDataModel) {
        ContextDataItem contextDataItem = contextDataModel.getValue(n);
        if (contextDataItem.getSpssVars().size() == 0) {
            this.getSpssVarFromData(contextDataItem);
        }
        Vector<String> vector = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().getAllMapIds();
        Hashtable<String, Vector<ISpssVariable>> hashtable = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().getMapKeys();
        boolean bl = false;
        if (contextDataItem.getDataType() == ContextDataItem.DataType.MAP) {
            bl = ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().isPointMap(contextDataItem.getMapAssocId());
        }
        DataMapAssociationSubDlg dataMapAssociationSubDlg = new DataMapAssociationSubDlg(this.mWizardDialog, contextDataItem, vector, hashtable, this.mIsGSAR, bl, this.mRoleString);
        dataMapAssociationSubDlg.setVisible(true);
        if (dataMapAssociationSubDlg.continuePressed()) {
            this.processAssocateAction(contextDataItem, contextDataModel, n, dataMapAssociationSubDlg.getDisplayProjection());
            this.setNextFinishButtonState();
        }
    }

    private void processAssocateAction(ContextDataItem contextDataItem, ContextDataModel contextDataModel, int n, String string) {
        Object object;
        String string2;
        String string3 = "";
        if (contextDataItem.getCoordinateXVar().length() > 0) {
            string3 = "Coordinates (" + contextDataItem.getCoordinateXVar() + "," + contextDataItem.getCoordinateYVar();
            if (!this.mIsGSAR) {
                string3 = string3 + "," + contextDataItem.getCoordinateZVar();
            }
            string3 = string3 + ")";
        } else {
            Vector<String> vector = contextDataItem.getDataType() == ContextDataItem.DataType.MAP ? contextDataItem.getKeyList() : contextDataItem.getSelectedDataKeys();
            string2 = "";
            for (String string4 : vector) {
                string2 = string2 + string4 + " ";
            }
            if (contextDataItem.getDataType() == ContextDataItem.DataType.MAP) {
                string3 = this.mAssocKeyStr + string2;
            } else {
                String string4;
                object = contextDataItem.getSelectedMapKeys();
                string4 = "";
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    string4 = string4 + string5 + " ";
                }
                string3 = this.mAssocMapKeyStr + " " + string4 + "; " + this.mAssocDataKeyStr + " " + string2;
            }
        }
        if (!this.mHasMap && !this.mIsGSAR && contextDataItem.getCoordinateXVar().length() > 0) {
            int n2 = 0;
            string2 = "";
            object = contextDataItem.getCoorSystem();
            if (object == ContextDataItem.CoordinateSys.GEO) {
                n2 = 4326;
                string2 = "GCS_WGS_1984";
            } else if (object == ContextDataItem.CoordinateSys.WKID) {
                n2 = Integer.parseInt(contextDataItem.getWKID());
                string2 = CoordinateSystemUtil.getInstance().lookupByWKID(n2).getName();
            } else if (object == ContextDataItem.CoordinateSys.PROJECTION) {
                string2 = contextDataItem.getProjection();
                n2 = CoordinateSystemUtil.getInstance().lookupByName(string2).getWKID();
            }
            ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().setCoordSysAndDisplay((ContextDataItem.CoordinateSys)((Object)object), n2, string2, string);
        }
        contextDataModel.setValueAt(string3, n, 3);
        contextDataModel.setValueAt(true, n, 2);
        this.enableValidate(n, contextDataModel);
    }

    boolean isMapkeyNumeric(String string, String string2) {
        return ((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().isMapKeyNumeric(string, string2);
    }

    Vector<ContextDataItem> getUnusedMapDataFiles() {
        Object object;
        int n;
        if (this.mDeletedMapDataList.size() == 0) {
            return this.mDeletedMapDataList;
        }
        Vector<Object> vector = new Vector<Object>();
        for (n = 0; n < this.mContextSourceTableModel.getRowCount(); ++n) {
            object = this.mContextSourceTableModel.getValue(n);
            if (((ContextDataItem)object).getDataType() != ContextDataItem.DataType.MAP) continue;
            vector.add(object);
        }
        for (n = 0; n < this.mEventSourceTableModel.getRowCount(); ++n) {
            object = this.mEventSourceTableModel.getValue(n);
            if (((ContextDataItem)object).getDataType() != ContextDataItem.DataType.MAP) continue;
            vector.add(object);
        }
        if (vector.size() == 0) {
            return this.mDeletedMapDataList;
        }
        object = new Vector();
        if (vector.size() == this.mDeletedMapDataList.size()) {
            return object;
        }
        for (n = 0; n < this.mDeletedMapDataList.size(); ++n) {
            ContextDataItem contextDataItem = this.mDeletedMapDataList.get(n);
            boolean bl = false;
            for (int i = 0; i < vector.size() && !bl; ++i) {
                if (!contextDataItem.getDataSourceFullName().equals(((ContextDataItem)vector.get(i)).getDataSourceFullName())) continue;
                bl = true;
            }
            if (bl) continue;
            ((Vector)object).add(contextDataItem);
        }
        return object;
    }

    boolean isDataSetUsed(LocallyUniqueId locallyUniqueId) {
        LocallyUniqueId locallyUniqueId2;
        ContextDataItem contextDataItem;
        int n;
        boolean bl = false;
        int n2 = this.mContextSourceTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            contextDataItem = this.mContextSourceTableModel.getValue(n);
            if (contextDataItem.getDataType() != ContextDataItem.DataType.DATASET || (locallyUniqueId2 = contextDataItem.getDatasetUID()) == null || !locallyUniqueId2.equals((Object)locallyUniqueId)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            n2 = this.mEventSourceTableModel.getRowCount();
            for (n = 0; n < n2; ++n) {
                contextDataItem = this.mEventSourceTableModel.getValue(n);
                if (contextDataItem.getDataType() != ContextDataItem.DataType.DATASET || (locallyUniqueId2 = contextDataItem.getDatasetUID()) == null || !locallyUniqueId2.equals((Object)locallyUniqueId)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    boolean isDataSourceUsed(String string) {
        ContextDataItem contextDataItem;
        int n;
        boolean bl = false;
        int n2 = this.mContextSourceTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            contextDataItem = this.mContextSourceTableModel.getValue(n);
            if (!contextDataItem.getDataSourceFullName().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            n2 = this.mEventSourceTableModel.getRowCount();
            for (n = 0; n < n2; ++n) {
                contextDataItem = this.mEventSourceTableModel.getValue(n);
                if (!contextDataItem.getDataSourceFullName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    String getDatasetNameSyntax() {
        return this.mDataNameSyntax;
    }

    String getDataSourceSyntax() {
        ContextDataItem contextDataItem;
        int n;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (n = 0; n < this.mContextSourceTable.getRowCount(); ++n) {
            contextDataItem = this.mContextSourceTableModel.getValue(n);
            stringBuffer.append(this.getSyntaxForItem(contextDataItem, true, stringBuffer2));
        }
        for (n = 0; n < this.mEventSourceTable.getRowCount(); ++n) {
            contextDataItem = this.mEventSourceTableModel.getValue(n);
            stringBuffer.append(this.getSyntaxForItem(contextDataItem, false, stringBuffer2));
        }
        if (!this.mIsGSAR && (contextDataItem = ((STEMWizardDlg)this.mWizardDialog).getSTPSettingsPage().getDataSourceFromScore()) != null) {
            stringBuffer.append("\n /DATA ");
            ContextDataItem.DataType dataType = contextDataItem.getDataType();
            stringBuffer.append(" TYPE=" + dataType.toString());
            stringBuffer.append(" SOURCE=");
            if (dataType == ContextDataItem.DataType.FILE) {
                stringBuffer.append(CharacterUtil.smartQuote((String)contextDataItem.getDataSourceFullName()));
            } else {
                String string = contextDataItem.getDataSourceFullName();
                if (this.mCurrentActiveDataFile.equals(string)) {
                    stringBuffer.append("*");
                } else {
                    stringBuffer.append(contextDataItem.getDataSetName());
                }
            }
            stringBuffer.append(" IDENTIFIER=" + contextDataItem.getSourceId());
            stringBuffer.append(" ROLE=SCORE");
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    private String getSyntaxForItem(ContextDataItem contextDataItem, boolean bl, StringBuffer stringBuffer) {
        Object object;
        Iterator<String> iterator;
        Object object2;
        Object object3;
        Object object4;
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        int n = this.mContextSourceTable.getRowCount();
        stringBuffer2.append("\n /DATA ");
        ContextDataItem.DataType dataType = contextDataItem.getDataType();
        stringBuffer2.append(" TYPE=" + dataType.toString());
        stringBuffer2.append(" SOURCE=");
        if (dataType == ContextDataItem.DataType.FILE) {
            stringBuffer2.append(CharacterUtil.smartQuote((String)contextDataItem.getDataSourceFullName()));
        } else if (dataType == ContextDataItem.DataType.MAP) {
            stringBuffer2.append(contextDataItem.getMapAssocId());
        } else {
            object4 = contextDataItem.getDataSourceFullName();
            if (this.mCurrentActiveDataFile.equals(object4)) {
                stringBuffer2.append("*");
            } else {
                stringBuffer2.append(contextDataItem.getDataSetName());
            }
        }
        stringBuffer2.append(" IDENTIFIER=" + contextDataItem.getSourceId());
        stringBuffer2.append(" ROLE=");
        if (bl) {
            stringBuffer2.append("CONTEXT");
        } else {
            stringBuffer2.append("EVENTDENSITY");
        }
        if (dataType == ContextDataItem.DataType.MAP && ((Vector)(object4 = contextDataItem.getKeyList())).size() > 0) {
            stringBuffer2.append(" KEY=");
            if (!this.mIsGSAR && bl) {
                stringBuffer.append(" KEY=");
            }
            if (((Vector)object4).size() == 1 && ((String)((Vector)object4).get(0)).equals(((STEMWizardDlg)this.mWizardDialog).getGeoRelationPage().sDefaultContextKeyName)) {
                stringBuffer2.append("SHAPEID");
                if (!this.mIsGSAR && bl) {
                    stringBuffer.append("SHAPEID");
                }
            } else {
                stringBuffer2.append("DEFINED(");
                if (!this.mIsGSAR && bl) {
                    stringBuffer.append("DEFINED(");
                }
                object3 = ((Vector)object4).iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    stringBuffer2.append((String)object2 + " ");
                    if (this.mIsGSAR || !bl) continue;
                    stringBuffer.append((String)object2 + " ");
                }
                stringBuffer2.append(")");
                if (!this.mIsGSAR && bl) {
                    stringBuffer.append(")");
                }
            }
        }
        boolean bl2 = false;
        if (!contextDataItem.getMapAssocId().equals(this.sMapAssocDefault) && contextDataItem.getMapAssocId().length() > 0) {
            if (dataType != ContextDataItem.DataType.MAP) {
                stringBuffer2.append(" MAPID=" + contextDataItem.getMapAssocId());
                if (!this.mIsGSAR && bl) {
                    stringBuffer.append(" MAPID=" + contextDataItem.getMapAssocId());
                }
            }
            bl2 = true;
        }
        object3 = contextDataItem.getSelectedDataKeys();
        object2 = new Vector();
        Vector<String> vector = contextDataItem.getSelectedMapKeys();
        Vector<Boolean> vector2 = new Vector<Boolean>();
        if (((Vector)object3).size() > 0 && vector.size() == ((Vector)object3).size()) {
            stringBuffer2.append(" DATAKEY=");
            if (!this.mIsGSAR && bl) {
                stringBuffer.append(" DATAKEY=");
            }
            iterator = ((Vector)object3).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ((Vector)object2).add(contextDataItem.isVarNumeric(string));
                stringBuffer2.append(string + " ");
                if (this.mIsGSAR || !bl) continue;
                stringBuffer.append(string + " ");
            }
            vector = contextDataItem.getSelectedMapKeys();
            stringBuffer2.append(" MAPKEY=");
            if (!this.mIsGSAR && bl) {
                stringBuffer.append(" MAPKEY=");
            }
            for (String string : vector) {
                vector2.add(this.isMapkeyNumeric(contextDataItem.getMapAssocId(), string));
                stringBuffer2.append(string + " ");
                if (this.mIsGSAR || !bl) continue;
                stringBuffer.append(string + " ");
            }
        }
        iterator = contextDataItem.getCoordinateXVar();
        boolean bl3 = false;
        if (((String)((Object)iterator)).length() > 0) {
            stringBuffer2.append(" XCOORDINATE=" + (String)((Object)iterator));
            if (!this.mIsGSAR && bl) {
                stringBuffer.append(" XCOORDINATE=" + iterator);
            }
            bl3 = true;
        }
        if (((String)((Object)(iterator = contextDataItem.getCoordinateYVar()))).length() > 0) {
            stringBuffer2.append(" YCOORDINATE=" + (String)((Object)iterator));
            if (!this.mIsGSAR && bl) {
                stringBuffer.append(" YCOORDINATE=" + iterator);
            }
        }
        if (((String)((Object)(iterator = contextDataItem.getCoordinateZVar()))).length() > 0) {
            stringBuffer2.append(" ZCOORDINATE=" + (String)((Object)iterator));
            if (!this.mIsGSAR) {
                stringBuffer.append(" ZCOORDINATE=" + iterator);
            }
        }
        if (bl3) {
            object = contextDataItem.getCoorSystem();
            StringBuffer stringBuffer3 = new StringBuffer("");
            stringBuffer3.append(contextDataItem.getCoorSystem().toString());
            if (object == ContextDataItem.CoordinateSys.WKID) {
                stringBuffer3.append("(" + contextDataItem.getWKID() + ")");
            } else if (object == ContextDataItem.CoordinateSys.PROJECTION) {
                stringBuffer3.append("(\"" + contextDataItem.getProjection() + "\")");
            }
            stringBuffer2.append(" COORDSYSTEM=" + stringBuffer3.toString());
            if (!this.mIsGSAR && bl) {
                stringBuffer.append(" COORDSYSTEM=" + stringBuffer3.toString());
            }
        }
        if (((Vector)(object = contextDataItem.getMatchedDataMapValues())).size() > 0) {
            stringBuffer2.append(" DATATOMAP=");
            if (!this.mIsGSAR && bl) {
                stringBuffer.append(" DATATOMAP=");
            }
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Pair pair = (Pair)((Vector)object).get(i);
                Vector vector3 = (Vector)pair.getFirst();
                Vector vector4 = (Vector)pair.getSecond();
                if (vector3.size() != vector4.size()) continue;
                String string = "";
                String string2 = "";
                for (int j = 0; j < vector3.size(); ++j) {
                    if (!((Boolean)((Vector)object2).get(j)).booleanValue()) {
                        string = string + "\"";
                    }
                    string = string + (String)vector3.get(j);
                    if (!((Boolean)((Vector)object2).get(j)).booleanValue()) {
                        string = string + "\"";
                    }
                    if (!((Boolean)vector2.get(j)).booleanValue()) {
                        string2 = string2 + "\"";
                    }
                    string2 = string2 + (String)vector4.get(j);
                    if (!((Boolean)vector2.get(j)).booleanValue()) {
                        string2 = string2 + "\"";
                    }
                    if (j >= vector3.size() - 1) continue;
                    string = string + " ";
                    string2 = string2 + " ";
                }
                if (string.length() <= 0) continue;
                stringBuffer2.append(string + " TO " + string2);
                if (!this.mIsGSAR && bl) {
                    stringBuffer.append(string + " TO " + string2);
                }
                if (i >= ((Vector)object).size() - 1) continue;
                stringBuffer2.append("; ");
                if (this.mIsGSAR || !bl) continue;
                stringBuffer.append("; ");
            }
        }
        return stringBuffer2.toString();
    }

    class SpssVariableNameCellEditor
    extends DefaultCellEditor {
        private JTable mTable;
        StringTextField mEditor;
        private boolean mIsValid;

        public SpssVariableNameCellEditor(JTextField jTextField, JTable jTable) {
            super(jTextField);
            this.mEditor = null;
            this.mEditor = (StringTextField)((Object)this.getComponent());
            this.mTable = jTable;
            this.mIsValid = true;
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = true;
            this.mIsValid = true;
            String string = (String)super.getCellEditorValue();
            String string2 = null;
            int n = this.mTable.getSelectedRow();
            if (string.length() > 0) {
                String string3;
                int n2;
                Object object;
                String string4 = ((ContextDataModel)this.mTable.getModel()).getValue(n).getSourceId();
                VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true);
                if (validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_STANDARD || validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE) {
                    if (validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE) {
                        string2 = ResUtil.getCommonDlgString("ERR_TRAILING_UNDERSCORE_MESSAGE");
                    }
                } else {
                    string2 = validNameCode.equals((Object)VarNameValidator.ValidNameCode.SPSSNAME_BADLTH) ? ResUtil.getCommonDlgString("ERR_BADVAR_LENGTH_ERROR_MESSAGE") : (validNameCode.equals((Object)VarNameValidator.ValidNameCode.SPSSNAME_RESERVED) ? ResUtil.getCommonDlgString("ERR_BADVAR_RESERVED_ERROR_MESSAGE") : (validNameCode.equals((Object)VarNameValidator.ValidNameCode.SPSSNAME_BADFIRST) ? ResUtil.getCommonDlgString("ERR_BADVAR_FIRST_ERROR_MESSAGE") : (validNameCode.equals((Object)VarNameValidator.ValidNameCode.SPSSNAME_BADLAST) ? ResUtil.getCommonDlgString("ERR_BADVAR_LAST_ERROR_MESSAGE") : (validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_BADCHAR ? ResUtil.getCommonDlgString("ERR_BADVAR_MIDDLE_ERROR_MESSAGE") : ResUtil.getCommonDlgString("ERR_BAD_VAR_NAME")))));
                }
                boolean bl2 = bl = string2 == null;
                if (bl) {
                    object = this.mTable.getModel();
                    int n3 = object.getRowCount();
                    for (n2 = 0; n2 < n3 && n2 != n; ++n2) {
                        string3 = object.getValueAt(n2, 1).toString();
                        if (string3.length() <= 0 || !string3.equals(string)) continue;
                        string2 = STEMDataSourcePage.this.mWizardDialog.getResString("IDS_STEM_CONTEXT_DATA_DUPLICATE_ID");
                        bl = false;
                        break;
                    }
                }
                if (!bl && string2 != null) {
                    string = string4;
                    this.mIsValid = false;
                    object = string2;
                    String string5 = string;
                    n2 = n;
                    string3 = string4;
                    SwingUtilities.invokeLater(new Runnable((String)object, string3, n2, string5){
                        final /* synthetic */ String val$errorStr;
                        final /* synthetic */ String val$forig;
                        final /* synthetic */ int val$sint;
                        final /* synthetic */ String val$value;
                        {
                            this.val$errorStr = string;
                            this.val$forig = string2;
                            this.val$sint = n;
                            this.val$value = string3;
                        }

                        @Override
                        public void run() {
                            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)STEMDataSourcePage.this.mWizardDialog), this.val$errorStr, VersionInfo.getAppVersionString());
                            SpssVariableNameCellEditor.this.getComponent().requestFocusInWindow();
                            SpssVariableNameCellEditor.this.mTable.getModel().setValueAt(this.val$forig, this.val$sint, 1);
                            SpssVariableNameCellEditor.this.mTable.getSelectionModel().setSelectionInterval(this.val$sint, this.val$sint);
                            SpssVariableNameCellEditor.this.mTable.getColumnModel().getSelectionModel().setSelectionInterval(1, 1);
                            SpssVariableNameCellEditor.this.mTable.requestFocus();
                            SpssVariableNameCellEditor.this.mEditor.setText(this.val$value);
                            SpssVariableNameCellEditor.this.mIsValid = true;
                        }
                    });
                }
                if (!string.equals(string4)) {
                    STEMDataSourcePage.this.mIsPageModified = true;
                }
            }
            if (bl && string.length() > 0) {
                STEMDataSourcePage.this.setNextFinishButtonState();
            }
            ((ContextDataModel)this.mTable.getModel()).getValue(n).setSourceId(string);
            return bl && super.stopCellEditing();
        }

        public boolean isValid() {
            return this.mIsValid;
        }
    }

    class StatusRenderer
    extends JLabel
    implements TableCellRenderer {
        public StatusRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setBorder(STEMDataSourcePage.this.mHighLightBorder);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(jTable.getTableHeader().getBackground());
            this.setForeground(Color.black);
            this.setOpaque(true);
            this.setBorder(bl2 ? STEMDataSourcePage.this.mHighLightBorder : STEMDataSourcePage.this.mEmptyBorder);
            this.setHorizontalAlignment(0);
            ContextDataModel contextDataModel = (ContextDataModel)jTable.getModel();
            boolean bl3 = true;
            if (bl3) {
                ResourceBundle resourceBundle = ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                String string = "IDS_STEM_CONTEXT_DATA_STATUS_NOT_SET_SMALL_IMAGE";
                String string2 = resourceBundle.getString("IDS_STEM_CONTEXT_DATA_MAP_ASSOC_DEFAULT");
                if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                    string = "IDS_STEM_CONTEXT_DATA_STATUS_SET_SMALL_IMAGE";
                    string2 = resourceBundle.getString("IDS_STEM_CONTEXT_DATA_MAP_ASSOC_SET");
                }
                URL uRL = ResUtil.getImageResourceFullPath(STEMResBundle.getImageFolder() + ResUtil.getString(resourceBundle, string));
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.setIcon(imageIcon);
                this.setToolTipText(string2);
            }
            return this;
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setBorder(STEMDataSourcePage.this.mHighLightBorder);
            this.setBorderPainted(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = jTable.isCellEditable(n, n2);
            if (!bl3) {
                this.setBackground(jTable.getTableHeader().getBackground());
                this.setForeground(Color.black);
                this.setOpaque(true);
            } else if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setBorder(bl2 ? STEMDataSourcePage.this.mHighLightBorder : STEMDataSourcePage.this.mEmptyBorder);
            this.setSelected(object != null && (Boolean)object != false);
            this.setEnabled(bl3);
            return this;
        }
    }

    class ContextDataModel
    extends AbstractTableModel {
        private Vector<ContextDataItem> mData = new Vector();
        private String[] COLUMN_NAMES;
        private boolean mIsComboBoxEnabled;

        public ContextDataModel(String[] stringArray) {
            this.COLUMN_NAMES = stringArray;
            this.mIsComboBoxEnabled = true;
        }

        @Override
        public int getRowCount() {
            return this.mData.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public ContextDataItem getValue(int n) {
            if (n < 0 || n >= this.mData.size()) {
                return null;
            }
            ContextDataItem contextDataItem = this.mData.get(n);
            return contextDataItem;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ContextDataItem contextDataItem = this.mData.get(n);
            String string = contextDataItem.getDisplayMapString();
            switch (n2) {
                case 0: {
                    if (contextDataItem.getDataType() == ContextDataItem.DataType.FILE) {
                        return contextDataItem.getDataSourceFullName();
                    }
                    return contextDataItem.getContextDataSourceName();
                }
                case 1: {
                    return contextDataItem.getDisplayID();
                }
                case 2: {
                    return contextDataItem.isAssocSet();
                }
                case 3: {
                    return contextDataItem.getDisplayMapString();
                }
            }
            return null;
        }

        public void setData(Vector<ContextDataItem> vector) {
            this.mData = vector;
            this.fireTableDataChanged();
        }

        public void insertRow(int n, ContextDataItem contextDataItem) {
            this.mData.insertElementAt(contextDataItem, n);
            this.fireTableDataChanged();
        }

        public void removeRow(int n) {
            this.mData.remove(n);
            this.fireTableDataChanged();
        }

        public void removeAll() {
            this.mData.clear();
            this.fireTableDataChanged();
        }

        public void addRow(ContextDataItem contextDataItem) {
            this.mData.add(contextDataItem);
            this.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ContextDataItem contextDataItem = this.mData.get(n);
            if (n2 == 0) {
                contextDataItem.setContextDataSourceName(object.toString());
            } else if (n2 == 1) {
                contextDataItem.setSourceId(object.toString());
                contextDataItem.setDisplayID(object.toString());
            } else if (n2 == 2 && object instanceof Boolean) {
                contextDataItem.setAssocSetStatus((Boolean)object);
            } else if (n2 == 3) {
                contextDataItem.setDisplayMapString(object.toString());
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                ContextDataItem contextDataItem = this.mData.get(n);
                return contextDataItem.isRoleContext();
            }
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public boolean isComboBoxEnabled() {
            return this.mIsComboBoxEnabled;
        }

        public void enableComboBox(boolean bl) {
            this.mIsComboBoxEnabled = bl;
        }

        public Vector<ContextDataItem> getTableData() {
            return this.mData;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return super.getColumnClass(n);
        }
    }
}

