/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.dialogs.STEM.CellComboBoxEditor;
import com.spss.java_client.ui.dialogs.STEM.STEMWizardDlg;
import com.spss.java_client.ui.dialogs.STEM.UnEditableCellTextRenderer;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.direct_marketing.AbstractDialogStateWizardPage;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class MergeEventDataPage
extends AbstractDialogStateWizardPage
implements ActionListener,
TableModelListener {
    static int COMBOBOX_WIDTH = 180;
    private String mStringType;
    private String mNumericType;
    private FocusableTextArea mInfoText;
    private JButton mKeepAllButton;
    private JButton mExcludeAllButton;
    private JLabel mDataSourceComboLabel;
    private JComboBox mDataSourceCombo;
    private Vector<String> mDataSourceList;
    private String mCommonFields;
    private String mAllFields;
    private JLabel mSourceTableLabel;
    private JTable mSourceTable;
    private DefaultTableModel mSourceTableModel;
    private CellComboBoxEditor mTypeEditor;
    private CellComboBoxEditor mMLEditor;
    Hashtable<String, Vector<ISpssVariable>> mDataAndFields;
    Vector<String> mDataSourceFiles;
    private int mSelectedSrcIndex = -1;
    private String[] mColNames;
    private Hashtable<String, EventDataField> mEventDataFields;
    private boolean mResetKeep = false;
    private int mClickedCol;
    private int mClickedRow;
    private String mEventIDs;
    private boolean mKeepState = false;
    private boolean mIsModified;
    private DialogFocusTraversalPolicy mPolicy;
    Border mEmptyBorder = BorderFactory.createEmptyBorder();
    Border mHighLightBorder = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");

    public MergeEventDataPage(BaseWizardDialog baseWizardDialog) {
        super("MergeEventDataPage", baseWizardDialog.getResString("IDS_STEM_STEP_ONE_TITLE"), baseWizardDialog, true);
        this.mEventDataFields = new Hashtable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mExcludeAllButton) {
            this.checkAll(false);
            this.mIsModified = true;
        } else if (object == this.mKeepAllButton) {
            this.checkAll(true);
            this.mIsModified = true;
        } else if (object == this.mDataSourceCombo) {
            int n = this.mDataSourceCombo.getSelectedIndex();
            this.updateEventDataFieldState();
            this.updateSourceTable(n);
            this.mSelectedSrcIndex = n;
            this.setupColumnWidths();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object = tableModelEvent.getSource();
        if (this.mSelectedSrcIndex == this.mDataSourceList.size() - 1 && tableModelEvent.getType() == 0 && object == this.mSourceTableModel) {
            this.mClickedCol = tableModelEvent.getColumn();
            this.mClickedRow = tableModelEvent.getLastRow();
        }
    }

    @Override
    protected void loadDialogState() {
    }

    @Override
    protected void saveDialogState() {
    }

    private void handleCheckboxClick() {
        if (this.mClickedCol == 4) {
            EventDataField eventDataField;
            boolean bl = (Boolean)this.mSourceTableModel.getValueAt(this.mClickedRow, 4);
            String string = this.mSourceTableModel.getValueAt(this.mClickedRow, 1).toString();
            int n = string.indexOf(40);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((eventDataField = this.mEventDataFields.get(string)).isDuplicate()) {
                this.setKeep(bl, string, this.mClickedRow);
            }
        }
    }

    private void setKeep(boolean bl, String string, int n) {
        for (int i = 0; i < this.mSourceTable.getRowCount(); ++i) {
            if (i == n) continue;
            String string2 = this.mSourceTableModel.getValueAt(i, 1).toString();
            int n2 = string2.indexOf(40);
            if (n2 >= 0) {
                string2 = string2.substring(0, n2);
            }
            if (!string2.equals(string)) continue;
            this.mSourceTableModel.setValueAt(bl, i, 4);
        }
        this.mResetKeep = true;
    }

    @Override
    public void init() {
        JSeparator jSeparator;
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        if (jPanel.getComponentCount() > 0) {
            DialogUtil.normalizeLabelWidths(jPanel);
            DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 2;
            insets.top = n2;
            jSeparator = new JSeparator();
            DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2, n2 * 2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mInfoText, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n2, n2, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mWizardPage, this.mDataSourceComboLabel, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mWizardPage, this.mDataSourceCombo, gridBagConstraints, 0, 4, 2, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSourceTable, 20, 31);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, this.mSourceTableLabel, gridBagConstraints, 0, 5, 2, 1, n, insets);
        jScrollPane.setMinimumSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 100));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, n2, 2, n2);
        DialogUtil.addUsingGBL(this.mWizardPage, jScrollPane, gridBagConstraints, 0, 6, 1, 1, n, insets);
        insets.set(2, 0, 2, n2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mWizardPage, STEMWizardDlg.createButtonsPanel(new JButton[]{this.mKeepAllButton, this.mExcludeAllButton}), gridBagConstraints, 1, 6, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        insets.top = n2;
        jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 7, 2, 1, 20, insets);
        this.setDefault();
        this.setTabTraversalOrder();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_stem_gsar_define_events";
    }

    @Override
    public boolean validate() {
        boolean bl = true;
        this.updateEventDataFieldState();
        this.mKeepState = true;
        ((STEMWizardDlg)this.mWizardDialog).getGSARDefineRolePage().setKeepTarget(!this.mIsModified);
        return bl && super.validate();
    }

    @Override
    public boolean validateOnBack() {
        ((STEMWizardDlg)this.mWizardDialog).getContextPage().setKeepSettings(true);
        return true;
    }

    @Override
    public String getNextPage() {
        return "GSARDefineRolePage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    Vector<ISpssVariable> getSelectedEventFields() {
        this.mEventIDs = "";
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        Enumeration<EventDataField> enumeration = this.mEventDataFields.elements();
        while (enumeration.hasMoreElements()) {
            EventDataField eventDataField = enumeration.nextElement();
            if (!eventDataField.isInclude()) continue;
            vector.add(eventDataField.getSpssVar());
        }
        int n = this.mDataSourceFiles.size();
        for (int i = 0; i < n; ++i) {
            this.mEventIDs = this.mEventIDs + this.mDataSourceFiles.get(i) + " ";
        }
        return vector;
    }

    String getEventDataIDs() {
        return this.mEventIDs;
    }

    EventDataField getEventDataField(String string) {
        return this.mEventDataFields.get(string);
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mIsModified = false;
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mPolicy.getDefaultComponent((Container)((Object)this.mWizardDialog)).requestFocusInWindow();
        if (!this.mKeepState) {
            this.mDataSourceFiles = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getAllEventDataID();
            this.mDataSourceList.removeAllElements();
            this.mDataSourceList.add(this.mCommonFields);
            for (int i = 0; i < this.mDataSourceFiles.size(); ++i) {
                this.mDataSourceList.add(this.mDataSourceFiles.get(i));
            }
            this.mDataSourceList.add(this.mAllFields);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.mDataSourceList);
            this.mDataSourceCombo.setModel(defaultComboBoxModel);
            this.mDataAndFields = ((STEMWizardDlg)this.mWizardDialog).getContextPage().getAllEventFields();
            this.mEventDataFields.clear();
            this.mDataSourceCombo.setSelectedIndex(0);
            this.setNextFinishButtonState();
        }
    }

    private void checkAll(boolean bl) {
        if (this.mSourceTableModel.getRowCount() == 0) {
            return;
        }
        for (int i = 0; i < this.mSourceTableModel.getRowCount(); ++i) {
            this.mSourceTableModel.setValueAt(bl, i, 4);
        }
    }

    private boolean isMorethanTwo() {
        int n = 0;
        Enumeration<EventDataField> enumeration = this.mEventDataFields.elements();
        while (enumeration.hasMoreElements() && n < 2) {
            EventDataField eventDataField = enumeration.nextElement();
            if (!eventDataField.isInclude()) continue;
            ++n;
        }
        return n >= 2;
    }

    private void updateSourceTable(int n) {
        this.mSourceTableModel.setRowCount(0);
        this.mTypeEditor.removeAll();
        this.mMLEditor.removeAll();
        if (n == 0) {
            this.handleAllCommonFields();
        } else if (n == this.mDataSourceList.size() - 1) {
            this.displayAllFields();
        } else {
            String string = this.mDataSourceList.get(n);
            Vector<ISpssVariable> vector = this.mDataAndFields.get(this.mDataSourceList.get(n));
            int n2 = 1;
            if (n == 1) {
                n2 = 2;
            }
            for (ISpssVariable iSpssVariable : vector) {
                boolean bl;
                String string2 = this.mNumericType;
                if (iSpssVariable.getType() > 0) {
                    string2 = this.mStringType;
                }
                Vector<String> vector2 = new Vector<String>();
                vector2.add(string2);
                String string3 = this.getMLString(iSpssVariable.getMeasurementLevel());
                Vector<String> vector3 = new Vector<String>();
                vector3.add(string3);
                String string4 = this.findDataSources(iSpssVariable, n, n2, vector2, vector3);
                if (string4.length() > 0) {
                    string4 = string + "," + string4;
                    bl = true;
                } else {
                    string4 = string;
                    bl = false;
                }
                String string5 = iSpssVariable.getName();
                if (this.mEventDataFields.get(string5) != null) {
                    EventDataField eventDataField = this.mEventDataFields.get(string5);
                    if (eventDataField.isDuplicate()) {
                        string2 = eventDataField.getTypeStr();
                        string3 = eventDataField.getMLevelString();
                    }
                    bl = eventDataField.isInclude();
                }
                if (iSpssVariable.getLabel().length() > 0) {
                    string5 = string5 + "(" + iSpssVariable.getLabel() + ")";
                }
                int n3 = this.addOneRow(string4, string5, string2, string3, bl);
                this.mTypeEditor.addRowEditor(n3, new DefaultCellEditor(this.getComboBox(vector2, string2)));
                this.mMLEditor.addRowEditor(n3, new DefaultCellEditor(this.getComboBox(vector3, string3)));
            }
            this.mSourceTable.getColumn(this.mColNames[2]).setCellEditor(this.mTypeEditor);
            this.mSourceTable.getColumn(this.mColNames[3]).setCellEditor(this.mMLEditor);
        }
    }

    String getMLString(MeasurementLevel measurementLevel) {
        String string = measurementLevel.equals((Object)MeasurementLevel.nominal) ? "IDS_NOMINAL" : (measurementLevel.equals((Object)MeasurementLevel.ordinal) ? "IDS_ORDINAL" : "IDS_SCALE");
        return ResUtil.getCommonDlgString(string);
    }

    private void handleAllCommonFields() {
        int n = this.mDataSourceList.size() - 1;
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i < n; ++i) {
            String string = this.mDataSourceList.get(i);
            Vector<ISpssVariable> vector2 = this.mDataAndFields.get(string);
            int n2 = i + 1;
            for (ISpssVariable iSpssVariable : vector2) {
                boolean bl;
                String string2 = iSpssVariable.getName();
                if (vector.contains(string2)) continue;
                String string3 = this.getTypeString(iSpssVariable.getType());
                Vector<String> vector3 = new Vector<String>();
                vector3.add(string3);
                String string4 = this.getMLString(iSpssVariable.getMeasurementLevel());
                Vector<String> vector4 = new Vector<String>();
                vector4.add(string4);
                String string5 = this.findDataSources(iSpssVariable, -1, n2, vector3, vector4);
                if (string5.length() > 0) {
                    Object object;
                    boolean bl2 = true;
                    if (this.mEventDataFields.get(string2) != null) {
                        object = this.mEventDataFields.get(string2);
                        string3 = ((EventDataField)object).getTypeStr();
                        string4 = ((EventDataField)object).getMLevelString();
                        bl2 = ((EventDataField)object).isInclude();
                    }
                    string5 = string + "," + string5;
                    object = string2;
                    if (iSpssVariable.getLabel().length() > 0) {
                        object = string2 + "(" + iSpssVariable.getLabel() + ")";
                    }
                    int n3 = this.addOneRow(string5, (String)object, string3, string4, bl2);
                    this.mTypeEditor.addRowEditor(n3, new DefaultCellEditor(this.getComboBox(vector3, string3)));
                    this.mMLEditor.addRowEditor(n3, new DefaultCellEditor(this.getComboBox(vector4, string4)));
                    vector.add(string2);
                    bl = true;
                } else {
                    bl = false;
                    string5 = string;
                }
                if (this.mEventDataFields.get(string2) != null) continue;
                this.mEventDataFields.put(string2, new EventDataField(string2, iSpssVariable, bl, bl, string5));
            }
            this.mSourceTable.getColumn(this.mColNames[2]).setCellEditor(this.mTypeEditor);
            this.mSourceTable.getColumn(this.mColNames[3]).setCellEditor(this.mMLEditor);
        }
    }

    private void updateEventDataFieldState() {
        if (this.mSourceTableModel.getRowCount() == 0 || this.mEventDataFields.size() == 0) {
            return;
        }
        for (int i = 0; i < this.mSourceTableModel.getRowCount(); ++i) {
            EventDataField eventDataField;
            String string = this.mSourceTableModel.getValueAt(i, 1).toString();
            int n = string.indexOf(40);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((eventDataField = this.mEventDataFields.get(string)).isDuplicate()) {
                eventDataField.setType(this.mSourceTableModel.getValueAt(i, 2).toString());
                eventDataField.setMLevel(this.mSourceTableModel.getValueAt(i, 3).toString());
            }
            eventDataField.setInclude((Boolean)this.mSourceTableModel.getValueAt(i, 4));
        }
    }

    private void displayAllFields() {
        int n = this.mDataSourceList.size() - 1;
        for (int i = 1; i < n; ++i) {
            String string = this.mDataSourceList.get(i);
            Vector<ISpssVariable> vector = this.mDataAndFields.get(string);
            for (ISpssVariable iSpssVariable : vector) {
                String string2 = iSpssVariable.getName();
                String string3 = this.getTypeString(iSpssVariable.getType());
                String string4 = this.getMLString(iSpssVariable.getMeasurementLevel());
                boolean bl = false;
                if (this.mEventDataFields.get(string2) != null) {
                    EventDataField eventDataField = this.mEventDataFields.get(string2);
                    if (eventDataField.isDuplicate()) {
                        string3 = eventDataField.getTypeStr();
                        string4 = eventDataField.getMLevelString();
                    }
                    bl = eventDataField.isInclude();
                }
                if (iSpssVariable.getLabel().length() > 0) {
                    string2 = string2 + "(" + iSpssVariable.getLabel() + ")";
                }
                this.addOneRow(string, string2, string3, string4, bl);
            }
            this.mSourceTable.getColumn(this.mColNames[2]).setCellEditor(new DefaultCellEditor(new JTextField()));
            this.mSourceTable.getColumn(this.mColNames[3]).setCellEditor(new DefaultCellEditor(new JTextField()));
        }
    }

    private JComboBox getComboBox(Vector<String> vector, String string) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (String string2 : vector) {
            jComboBox.addItem(string2);
        }
        jComboBox.setSelectedItem(string);
        return jComboBox;
    }

    private String findDataSources(ISpssVariable iSpssVariable, int n, int n2, Vector<String> vector, Vector<String> vector2) {
        String string = "";
        String string2 = iSpssVariable.getName();
        int n3 = this.mDataSourceList.size() - 1;
        for (int i = n2; i < n3; ++i) {
            if (n >= 0 && (n < 0 || i == n)) continue;
            String string3 = this.mDataSourceList.get(i);
            Vector<ISpssVariable> vector3 = this.mDataAndFields.get(string3);
            boolean bl = false;
            for (int j = 0; j < vector3.size() && !bl; ++j) {
                String string4;
                ISpssVariable iSpssVariable2 = vector3.get(j);
                if (!string2.equals(iSpssVariable2.getName())) continue;
                boolean bl2 = false;
                if (iSpssVariable2.getType() != iSpssVariable.getType()) {
                    bl2 = true;
                    string4 = this.getTypeString(iSpssVariable2.getType());
                    if (!vector.contains(string4)) {
                        vector.add(string4);
                    }
                }
                if (iSpssVariable2.getMeasurementLevel() != iSpssVariable.getMeasurementLevel()) {
                    string4 = this.getMLString(iSpssVariable2.getMeasurementLevel());
                    if (!vector2.contains(string4)) {
                        vector2.add(string4);
                    }
                    bl2 = true;
                }
                string = string + string3 + ",";
            }
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getTypeString(int n) {
        String string = this.mNumericType;
        if (n > 0) {
            string = this.mStringType;
        }
        return string;
    }

    private int getStorageType(String string) {
        if (this.mNumericType.equals(string)) {
            return 0;
        }
        return 1;
    }

    private void setNextFinishButtonState() {
        this.mWizardDialog.enableNext(this.validate());
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfoText);
        vector.add(this.mDataSourceCombo);
        vector.add(this.mSourceTable);
        vector.add(this.mKeepAllButton);
        vector.add(this.mExcludeAllButton);
        Vector<Object> vector2 = ((STEMWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        return jPanel;
    }

    private void initVars() {
        this.mStringType = this.mWizardDialog.getResString("IDS_STEM_FIELDS_MERGE_EVENT_TYPE_STRING");
        this.mNumericType = this.mWizardDialog.getResString("IDS_STEM_FIELDS_MERGE_EVENT_TYPE_NUMERIC");
        String string = this.mWizardDialog.getResString("IDS_STEM_STEP_MERGE_EVENT_INFOR_TEXT1") + this.mWizardDialog.getResString("IDS_STEM_STEP_MERGE_EVENT_INFOR_TEXT2");
        this.mInfoText = new FocusableTextArea(string, null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_MERGE_EVENT_KEEP_BUTTON_LABEL");
        this.mKeepAllButton = new JButton(toggleButtonAction);
        this.mKeepAllButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_STEM_FIELDS_MERGE_EVENT_EXCLUDE_BUTTON_LABEL");
        this.mExcludeAllButton = new JButton(toggleButtonAction);
        this.mExcludeAllButton.addActionListener(this);
        this.mDataSourceComboLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_STEP_TWO_DATA_SOURCE_COMBO");
        this.mDataSourceCombo = new JComboBox();
        this.mDataSourceCombo.setAction(new ComboboxAction(this.mWizardDialog, "IDS_STEM_STEP_TWO_DATA_SOURCE_COMBO"));
        int n = this.mDataSourceCombo.getPreferredSize().height;
        this.mDataSourceCombo.setPreferredSize(new Dimension(COMBOBOX_WIDTH, n));
        this.mDataSourceComboLabel.setLabelFor(this.mDataSourceCombo);
        this.mDataSourceCombo.addActionListener(this);
        this.mDataSourceList = new Vector();
        this.mCommonFields = this.mWizardDialog.getResString("IDS_STEM_FIELDS_MERGE_EVENT_FILTER_VALUE_COMMON");
        this.mAllFields = this.mWizardDialog.getResString("IDS_STEM_FIELDS_MERGE_EVENT_FILTER_VALUE_ALL");
        this.mDataSourceList.add(this.mCommonFields);
        this.mColNames = this.mWizardDialog.getResStringArray("IDS_STEM_FIELDS_MERGE_EVENT_TABLE_HEADER_ARRARY");
        this.mSourceTableLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_STEM_FIELDS_MERGE_EVENT_TABLE_LABEL");
        this.mSourceTableModel = new DefaultTableModel(this.mColNames, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n2 == 0 || n2 == 1) {
                    return false;
                }
                if (n2 == 4) {
                    return true;
                }
                return MergeEventDataPage.this.mSelectedSrcIndex != MergeEventDataPage.this.mDataSourceList.size() - 1;
            }
        };
        this.mSourceTableModel.addTableModelListener(this);
        this.mSourceTable = new PlainTable(this.mSourceTableModel);
        this.mSourceTable.setPreferredScrollableViewportSize(new Dimension(450, 300));
        this.mSourceTable.setRowHeight(22);
        this.mSourceTable.setColumnSelectionAllowed(true);
        this.mSourceTable.setSelectionMode(0);
        this.mSourceTable.setRowSelectionAllowed(true);
        this.mSourceTable.getTableHeader().setReorderingAllowed(false);
        this.mSourceTable.getTableHeader().setResizingAllowed(true);
        this.mSourceTable.setGridColor(Color.darkGray);
        this.mSourceTable.getTableHeader().setReorderingAllowed(false);
        this.mSourceTableLabel.setLabelFor(this.mSourceTable);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setVerticalAlignment(1);
        jCheckBox.setHorizontalAlignment(0);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MergeEventDataPage.this.mSelectedSrcIndex == MergeEventDataPage.this.mDataSourceList.size() - 1) {
                    MergeEventDataPage.this.handleCheckboxClick();
                }
                MergeEventDataPage.this.mIsModified = true;
                MergeEventDataPage.this.mClickedCol = -1;
                MergeEventDataPage.this.mClickedRow = -1;
            }
        });
        this.mSourceTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(jCheckBox));
        this.mSourceTable.getColumnModel().getColumn(4).setCellRenderer(new CheckBoxRenderer());
        this.mSourceTable.getColumnModel().getColumn(0).setCellRenderer(new UnEditableCellTextRenderer());
        this.mSourceTable.getColumnModel().getColumn(1).setCellRenderer(new UnEditableCellTextRenderer());
        this.mTypeEditor = new CellComboBoxEditor(this.mSourceTable);
        this.mMLEditor = new CellComboBoxEditor(this.mSourceTable);
    }

    private void setDefault() {
    }

    public int addOneRow(String string, String string2, String string3, String string4, boolean bl) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(string);
        vector.add(string2);
        vector.add(string3);
        vector.add(string4);
        vector.add(bl);
        this.mSourceTableModel.addRow(vector);
        this.mSourceTable.setModel(this.mSourceTableModel);
        return this.mSourceTableModel.getRowCount() - 1;
    }

    private void setupColumnWidths() {
        double[] dArray = new double[]{0.25, 0.3, 0.15, 0.2, 0.1};
        TableColumnModel tableColumnModel = this.mSourceTable.getColumnModel();
        int n = this.mSourceTable.getPreferredScrollableViewportSize().width;
        int n2 = 0;
        for (double d : dArray) {
            tableColumnModel.getColumn(n2).setPreferredWidth((int)((double)n * d));
            ++n2;
        }
    }

    class EventDataField {
        private String mVarName;
        private ISpssVariable mSpssVar;
        private boolean mInclude;
        private boolean mIsDuplicate;
        private String mDataSourceId;

        public EventDataField(String string, ISpssVariable iSpssVariable, boolean bl, boolean bl2, String string2) {
            this.mVarName = string;
            this.mInclude = bl;
            this.mIsDuplicate = bl2;
            this.mDataSourceId = string2;
            try {
                this.mSpssVar = iSpssVariable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }

        public String getVarName() {
            return this.mVarName;
        }

        public ISpssVariable getSpssVar() {
            return this.mSpssVar;
        }

        public String getDataSourceId() {
            return this.mDataSourceId;
        }

        public boolean isInclude() {
            return this.mInclude;
        }

        public void setInclude(boolean bl) {
            this.mInclude = bl;
        }

        public boolean isDuplicate() {
            return this.mIsDuplicate;
        }

        public void setType(String string) {
            if (this.mIsDuplicate) {
                this.mSpssVar.setType(this.getStorageType(string));
            }
        }

        public String getTypeStr() {
            return MergeEventDataPage.this.getTypeString(this.mSpssVar.getType());
        }

        public void setMLevel(String string) {
            if (this.mIsDuplicate) {
                this.mSpssVar.setMeasurementLevel(this.getMLevel(string));
            }
        }

        public String getMLevelString() {
            return MergeEventDataPage.this.getMLString(this.mSpssVar.getMeasurementLevel());
        }

        private short getStorageType(String string) {
            if (MergeEventDataPage.this.mNumericType.equals(string)) {
                return 0;
            }
            return 1;
        }

        private MeasurementLevel getMLevel(String string) {
            if (string.equalsIgnoreCase(ResUtil.getCommonDlgString("IDS_NOMINAL"))) {
                return MeasurementLevel.nominal;
            }
            if (string.equalsIgnoreCase(ResUtil.getCommonDlgString("IDS_ORDINAL"))) {
                return MeasurementLevel.ordinal;
            }
            return MeasurementLevel.scale;
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setBorder(MergeEventDataPage.this.mHighLightBorder);
            this.setBorderPainted(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setBorder(bl2 ? MergeEventDataPage.this.mHighLightBorder : MergeEventDataPage.this.mEmptyBorder);
            this.setSelected(object != null && (Boolean)object != false);
            this.setEnabled(jTable.isCellEditable(n, n2));
            return this;
        }
    }
}

