/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.ui.dialogs.STEM.STEMPreviewCanvas;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MapImagePanel
extends JPanel {
    private STEMPreviewCanvas mCanvas;
    private Dimension mSize;

    public MapImagePanel(STEMPreviewCanvas sTEMPreviewCanvas, Dimension dimension) {
        this.mCanvas = sTEMPreviewCanvas;
        this.mSize = dimension;
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(""));
        this.initLayout();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MapImagePanel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                MapImagePanel.this.repaint();
            }
        });
    }

    protected void initLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JScrollPane jScrollPane = new JScrollPane(this.mCanvas);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(this.mSize);
        this.mCanvas.setPreferredSize(this.mSize);
        this.mCanvas.setMinimumSize(this.mSize);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, null);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasFocus()) {
            this.paintFocus(graphics);
        }
    }

    public void paintFocus(Graphics graphics) {
        Color color = UIManager.getColor("ToggleButton.focus");
        graphics.setColor(color);
        Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
        rectangle.grow(-4, -4);
        BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

