/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.STEM;

import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.STEM.res.STEMResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class KDESubDlg
extends BaseDialog
implements ItemListener {
    protected JButton mContinueButton;
    protected ContinueAction mContinueAction;
    private FocusableTextArea mInfo;
    private FocusableTextArea mRadioGroupInfo;
    private JRadioButton mUseExistRadio;
    private JRadioButton mCalculateRadio;
    private JLabel mRoleLabel;
    private JComboBox mRoleCombo;
    private JLabel mTimeFieldLabel;
    private JComboBox mTimeFieldCombo;
    private SpssButtonGroup mButtonGroup;
    private boolean mIsContinuePressed;
    private Vector<String> mNumericFields;

    public KDESubDlg(BaseWizardDialog baseWizardDialog, Vector<String> vector) {
        super((BaseDialog)baseWizardDialog, baseWizardDialog.getResString("IDS_STP_KED_SUB_TITLE"), true, ResUtil.getBundle(STEMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), STEMResBundle.getImageFolder());
        this.mNumericFields = vector;
        this.initializePanel();
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, " idh_stem_stp_kde");
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JRadioButton) {
            if (this.mCalculateRadio.isSelected()) {
                this.mRoleLabel.setEnabled(true);
                this.mRoleCombo.setEnabled(true);
                this.mTimeFieldLabel.setEnabled(true);
                this.mTimeFieldCombo.setEnabled(true);
            } else {
                this.mRoleLabel.setEnabled(false);
                this.mRoleCombo.setEnabled(false);
                this.mTimeFieldLabel.setEnabled(false);
                this.mTimeFieldCombo.setEnabled(false);
            }
            this.enableContinueButton();
        }
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setDefault();
    }

    private void initializePanel() {
        this.mNumericFields.insertElementAt("", 0);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.mNumericFields);
        this.mTimeFieldCombo.setModel(defaultComboBoxModel);
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    public boolean continuePressed() {
        return this.mIsContinuePressed;
    }

    public int getKDERoleAndField(int[] nArray, int[] nArray2) {
        int n;
        if (this.mUseExistRadio.isSelected()) {
            nArray[0] = -1;
            nArray2[0] = -1;
            n = 0;
        } else {
            nArray[0] = this.mRoleCombo.getSelectedIndex();
            nArray2[0] = this.mTimeFieldCombo.getSelectedIndex();
            n = 1;
        }
        return n;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        this.mContinueButton = new JButton(this.mContinueAction);
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mContinueButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mContinueButton);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mContinueButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mInfo = new FocusableTextArea(this.getResString("IDS_STP_KDE_SUB_HELP_INFO"), null);
        this.mRadioGroupInfo = new FocusableTextArea(this.getResString("IDS_STP_KDE_SUB_RADIO_GROUP_TITLE"), null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_STP_KDE_SUB_USE_EXISTING");
        this.mUseExistRadio = new JRadioButton(toggleButtonAction);
        this.mUseExistRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_STP_KDE_SUB_CALCULATE");
        this.mCalculateRadio = new JRadioButton(toggleButtonAction);
        this.mCalculateRadio.addItemListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mUseExistRadio);
        this.mButtonGroup.add(this.mCalculateRadio);
        this.mRoleLabel = DialogUtil.createLabel(this, "IDS_STP_KDE_SUB_ROLE_FOR_KDE");
        this.mRoleCombo = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.getResStringArray("IDS_STP_KDE_SUB_ROLE_VALUES"));
        this.mRoleCombo.setModel(defaultComboBoxModel);
        this.mRoleCombo.setAction(new ComboboxAction(this, "IDS_STP_KDE_SUB_ROLE_FOR_KDE"));
        this.mRoleLabel.setLabelFor(this.mRoleCombo);
        this.mTimeFieldLabel = DialogUtil.createLabel(this, "IDS_STP_KDE_SUB_TIME_FIELD");
        this.mTimeFieldCombo = new JComboBox();
        this.mTimeFieldCombo.setAction(new ComboboxAction(this, "IDS_STP_KDE_SUB_TIME_FIELD"));
        this.mTimeFieldCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KDESubDlg.this.enableContinueButton();
            }
        });
        this.mTimeFieldLabel.setLabelFor(this.mTimeFieldCombo);
    }

    private void setDefault() {
        this.mUseExistRadio.setSelected(true);
        this.mIsContinuePressed = false;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 0, n2, n2 * 2);
        this.mInfo.setRows(3);
        DialogUtil.addUsingGBL(jPanel, this.mInfo, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mInfo.setMinimumSize(new Dimension(350, 70));
        this.mInfo.setPreferredSize(new Dimension(350, 70));
        DialogUtil.addUsingGBL(jPanel, this.mRadioGroupInfo, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(1, n2 * 2, 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mUseExistRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 2, 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mCalculateRadio, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 4, 4, 2);
        DialogUtil.addUsingGBL(jPanel, this.mRoleLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 2, 4, n2);
        DialogUtil.addUsingGBL(jPanel, this.mRoleCombo, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 * 4, 10, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTimeFieldLabel, gridBagConstraints, 0, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 2, 10, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTimeFieldCombo, gridBagConstraints, 1, 5, 1, 1, n, insets);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mInfo);
        vector.add(this.mRadioGroupInfo);
        vector.add(this.mUseExistRadio);
        vector.add(this.mCalculateRadio);
        vector.add(this.mRoleCombo);
        vector.add(this.mTimeFieldCombo);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void enableContinueButton() {
        boolean bl = true;
        if (this.mCalculateRadio.isSelected() && this.mTimeFieldCombo.getSelectedIndex() == 0) {
            bl = false;
        }
        this.mContinueButton.setEnabled(bl);
    }

    protected class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KDESubDlg.this.doHelp();
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
            this.putValue("Name", UIToolResUtil.getString((String)"IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KDESubDlg.this.processCancel();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KDESubDlg.this.mIsContinuePressed = true;
            KDESubDlg.this.dispose();
        }
    }
}

